/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import ca.ubc.cs.beta.aeatk.json.serializers.ParameterConfigurationSpaceJson;
import ca.ubc.cs.beta.aeatk.misc.java.io.FileReaderNoException.FileReaderNoExceptionThrown;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.LineType;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.NormalizedRange;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationStringFormatException;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationStringMissingParameterException;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import ec.util.MersenneTwisterFast;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import net.jcip.annotations.Immutable;

@Immutable
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@JsonSerialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSpaceSerializer.class)
@JsonDeserialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSpaceDeserializer.class)
public class ParameterConfigurationSpace
implements Serializable {
    private static final long serialVersionUID = -9137375058810057209L;
    private final Map<String, List<String>> values;
    private final Map<String, String> defaultValues;
    private final Map<String, Map<String, List<String>>> dependentValues;
    private final Map<String, Boolean> isContinuous;
    @Deprecated
    private final List<String> paramNames;
    private final Map<String, Map<String, Integer>> categoricalValueMap;
    private final String absoluteFileName;
    private final Map<String, NormalizedRange> contNormalizedRanges;
    private final Map<String, Integer> paramKeyIndexMap;
    private final boolean[] parameterDomainContinuous;
    private final int[] categoricalSize;
    private final List<int[][]> forbiddenParameterValuesList;
    public static final int INVALID_CATEGORICAL_SIZE = 0;
    private final int numberOfParameters;
    private final int[][] condParents;
    private final int[][][] condParentVals;
    private boolean hasRealParameterFile;
    private final List<String> forbiddenLines;
    private final double[] defaultConfigurationValueArray;
    final double[] searchSubspaceValues;
    final boolean[] searchSubspaceActive;
    private final List<String> authorativeParameterNameOrder;
    private final String[] authorativeParameterOrderArray;
    private final NormalizedRange[] normalizedRangesByIndex;
    private final String pcsFile;
    private final Map<String, String> searchSubspace;
    public static final String SINGLETON_ABSOLUTE_NAME = "<--[SINGLETON SPACE]-->";
    public static final String NULL_ABSOLUTE_NAME = "<--[NULL SPACE]-->";

    public ParameterConfigurationSpace(String filename) {
        this(new File(filename));
    }

    public ParameterConfigurationSpace(Reader reader, Map<String, String> searchSubspace) {
        this(reader, "ReaderOnly-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1.0E7), searchSubspace);
        this.hasRealParameterFile = false;
    }

    public ParameterConfigurationSpace(Reader reader) {
        this(reader, "ReaderOnly-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1.0E7));
        this.hasRealParameterFile = false;
    }

    public ParameterConfigurationSpace(File file) {
        this((Reader)new FileReaderNoExceptionThrown(file), file.getAbsolutePath());
    }

    public ParameterConfigurationSpace(Reader file, String absoluteFileName) {
        this(file, absoluteFileName, Collections.EMPTY_MAP);
    }

    /*
     * Exception decompiling
     */
    public ParameterConfigurationSpace(Reader file, String absoluteFileName, Map<String, String> searchSubspace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getParamFileName() {
        return this.absoluteFileName;
    }

    private void parseLine(String line) {
        LineType type = LineType.OTHER;
        int commentStart = line.indexOf("#");
        line = line.trim();
        if (commentStart >= 0) {
            line = line.substring(0, commentStart).trim();
        }
        if (line.length() == 0) {
            return;
        }
        if (line.indexOf("|") >= 0) {
            type = LineType.CONDITIONAL;
        } else if (line.trim().substring(0, 1).equals("{")) {
            type = LineType.FORBIDDEN;
        } else {
            if (line.indexOf("[") < 0) {
                type = LineType.OTHER;
                if (line.trim().equals("Conditionals:")) {
                    return;
                }
                if (line.trim().equals("Forbidden:")) {
                    return;
                }
                throw new IllegalArgumentException("Cannot parse the following line:" + line);
            }
            if (line.indexOf("[") != line.lastIndexOf("[")) {
                type = LineType.CONTINUOUS;
            } else if (line.trim().indexOf("{") > 1 && line.trim().indexOf("}") > 1) {
                type = LineType.CATEGORICAL;
            } else {
                throw new IllegalArgumentException("Syntax error parsing line " + line + " probably malformed");
            }
        }
        switch (type) {
            case CONDITIONAL: {
                this.parseConditionalLine(line);
                break;
            }
            case CATEGORICAL: {
                this.parseCategoricalLine(line);
                break;
            }
            case CONTINUOUS: {
                this.parseContinuousLine(line);
                break;
            }
            case FORBIDDEN: {
                this.forbiddenLines.add(line);
                break;
            }
            default: {
                throw new IllegalStateException("Not sure how I can be parsing some other type, ");
            }
        }
    }

    private void parseForbiddenLine(String line) {
        String originalLine = line;
        if (line.trim().indexOf("{", 1) != -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained more than one { in line: " + originalLine);
        }
        if ((line = line.replace("{", "")).trim().indexOf("}") == -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained no closing brace \"}\" in line: " + originalLine);
        }
        if ((line = line.replaceFirst("}", "")).trim().indexOf("}") != -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained multiple closing braces \"}\" in line: " + originalLine);
        }
        String[] nameValuePairs = line.split(",");
        ArrayList<int[]> forbiddenIndexValuePairs = new ArrayList<int[]>();
        for (String nameValuePair : nameValuePairs) {
            Object[] nvPairArr = nameValuePair.split("=");
            if (nvPairArr.length != 2) {
                throw new IllegalArgumentException("Line specifying forbidden parameters contained an name value pair that could not be parsed: " + Arrays.toString(nvPairArr) + " in line: " + originalLine);
            }
            String name = nvPairArr[0].trim();
            Integer indexIntoValueArrays = this.paramKeyIndexMap.get(name);
            if (indexIntoValueArrays == null) {
                throw new IllegalArgumentException("Unknown parameter " + name + " in line: " + originalLine);
            }
            String value = ((String)nvPairArr[1]).trim();
            if (this.isContinuous.get(name).booleanValue()) {
                throw new IllegalArgumentException("Forbidden Parameter Declarations can only exclude combinations of categorical parameters " + name + " is continuous; in line: " + line);
            }
            Integer valueIndex = this.categoricalValueMap.get(name).get(value);
            if (valueIndex == null) {
                throw new IllegalArgumentException("Invalid parameter value " + value + " for parameter " + name + " in line: " + line);
            }
            int[] nvPairArrayForm = new int[]{indexIntoValueArrays, valueIndex};
            forbiddenIndexValuePairs.add(nvPairArrayForm);
        }
        this.forbiddenParameterValuesList.add((int[][])forbiddenIndexValuePairs.toArray((T[])new int[0][0]));
    }

    private void parseContinuousLine(String line) {
        boolean intValuesOnly;
        int secondBracket;
        String name = this.getName(line);
        int firstBracket = line.indexOf("[");
        String domainValues = line.substring(firstBracket + 1, secondBracket = line.indexOf("]"));
        String[] contValues = domainValues.split(",");
        if (contValues.length != 2) {
            throw new IllegalArgumentException("Expected two parameter values (or one comma between the first brackets) from line \"" + line + "\" but received " + contValues.length);
        }
        double min = Double.valueOf(contValues[0]);
        double max = Double.valueOf(contValues[1]);
        String defaultValue = this.getDefault(secondBracket, line);
        this.paramNames.add(name);
        this.isContinuous.put(name, Boolean.TRUE);
        this.values.put(name, Collections.emptyList());
        this.defaultValues.put(name, defaultValue);
        String lineRemaining = line.substring(line.indexOf("]", secondBracket + 1) + 1);
        boolean logScale = lineRemaining.length() > 0 && lineRemaining.trim().contains("l");
        lineRemaining = lineRemaining.replaceFirst("l", "").trim();
        boolean bl = intValuesOnly = lineRemaining.length() > 0 && lineRemaining.trim().contains("i");
        if (intValuesOnly) {
            try {
                if (!this.isIntegerDouble(Double.valueOf(contValues[0]))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(Double.valueOf(contValues[1]))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(Double.valueOf(defaultValue))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
            }
        }
        if ((lineRemaining = lineRemaining.replaceFirst("i", "").trim()).trim().length() != 0) {
            throw new IllegalArgumentException("Unknown or duplicate modifier(s): " + lineRemaining + " in line: " + line);
        }
        try {
            this.contNormalizedRanges.put(name, new NormalizedRange(min, max, logScale, intValuesOnly));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "; error occured while parsing line: " + line);
        }
        String subString = line.substring(line.indexOf("]") + 1, line.indexOf("[", line.indexOf("]"))).trim();
        if (subString.length() > 0) {
            throw new IllegalArgumentException("Invalid Characters detected between domain and default value on line : " + line);
        }
    }

    private void parseCategoricalLine(String line) {
        String name = this.getName(line);
        List<String> paramValues = this.getValues(line);
        String defaultValue = this.getDefault(0, line);
        this.paramNames.add(name);
        this.values.put(name, paramValues);
        LinkedHashMap<String, Integer> valueMap = new LinkedHashMap<String, Integer>();
        int lastIndexOf = line.lastIndexOf("]");
        int i = 0;
        for (String value : paramValues) {
            valueMap.put(value, i);
            ++i;
        }
        this.categoricalValueMap.put(name, valueMap);
        this.defaultValues.put(name, defaultValue);
        this.isContinuous.put(name, Boolean.FALSE);
        String remaining = line.substring(lastIndexOf + 1).trim();
        if (remaining.contains("i")) {
            throw new IllegalArgumentException("Cannot set categorical value as having integral only values on line " + line);
        }
        if (remaining.contains("l")) {
            throw new IllegalArgumentException("Cannot set categorical value as being selected with a log distribution" + line);
        }
        if (remaining.length() > 0) {
            throw new IllegalArgumentException("Extra flags set for categorical value (flags are not permitted on categorical values) on line : " + line);
        }
    }

    private void parseConditionalLine(String line) {
        String name2;
        String lineToParse = line;
        String name1 = this.getName(line);
        if (name1.equals(name2 = this.getName(line.substring(line.indexOf("|") + 1)))) {
            throw new IllegalArgumentException("Parameter " + name1 + " cannot be conditional on itself in line: " + line);
        }
        lineToParse = lineToParse.replaceFirst(name1, "");
        lineToParse = lineToParse.replaceFirst("|", "");
        lineToParse = lineToParse.replaceFirst(name2, "");
        if ((lineToParse = lineToParse.trim()).indexOf(" in ") < 0) {
            throw new IllegalStateException("Unknown or missing operator in line: " + line);
        }
        List<String> condValues = this.getValues(line);
        Map<String, List<String>> dependencies = this.dependentValues.get(name1);
        if (dependencies == null) {
            dependencies = new HashMap<String, List<String>>();
            this.dependentValues.put(name1, dependencies);
        }
        if (dependencies.get(name2) != null) {
            throw new IllegalArgumentException("Parameter " + name1 + " already has a previous dependency for " + name2 + " values {" + dependencies.get(name2).toString() + "}. Parameter dependencies respecified in line: " + line);
        }
        dependencies.put(name2, condValues);
    }

    private String getName(String line) {
        return this.getName(line, 0);
    }

    private String getName(String line, int offset) {
        line = line.trim();
        int firstSpace = line.indexOf(" ");
        int firstPipe = line.indexOf("|");
        int firstCurly = line.indexOf("{");
        int firstSquare = line.indexOf("[");
        if (firstSpace == -1) {
            firstSpace = Integer.MAX_VALUE;
        }
        if (firstPipe == -1) {
            firstPipe = Integer.MAX_VALUE;
        }
        if (firstCurly == -1) {
            firstCurly = Integer.MAX_VALUE;
        }
        if (firstSquare == -1) {
            firstSquare = Integer.MAX_VALUE;
        }
        int nameBoundary = Math.min(firstSpace, firstPipe);
        nameBoundary = Math.min(nameBoundary, firstCurly);
        String name = line.substring(offset, nameBoundary = Math.min(nameBoundary, firstSquare)).trim();
        if (name.length() == 0) {
            throw new IllegalArgumentException("Did Not Parse a Parameter Name in line: " + line);
        }
        return name;
    }

    private String getDefault(int offset, String line) {
        String defaultValue = line.substring(line.indexOf("[", offset + 1) + 1, line.indexOf("]", offset + 1)).trim();
        if (defaultValue.length() == 0) {
            throw new IllegalArgumentException("Invalid Default Value specified in line: " + line);
        }
        return defaultValue;
    }

    private List<String> getValues(String line) {
        String oLine = line;
        int start = line.indexOf("{");
        int end = line.indexOf("}");
        line = line.substring(start + 1, end);
        line = line.replace(',', '\n');
        BufferedReader r = new BufferedReader(new StringReader(line));
        LinkedList<String> strings = new LinkedList<String>();
        try {
            String value;
            while ((value = r.readLine()) != null) {
                if (value.trim().length() == 0) {
                    throw new IllegalArgumentException("Value cannot be empty (consist only of whitespace) in line: " + oLine);
                }
                strings.add(value.trim());
            }
        }
        catch (IOException e) {
            System.err.println("Some random IOException occured?");
            e.printStackTrace();
            throw new IllegalStateException("An exception occured while reading values from (" + oLine + ") we mistakenly thought this would never happen, please contact developer", e);
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(strings);
        if (set.size() < strings.size()) {
            throw new IllegalStateException("Duplicate Value detected in line: " + oLine);
        }
        return strings;
    }

    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.paramNames);
    }

    public Map<String, Boolean> getContinuousMap() {
        return Collections.unmodifiableMap(this.isContinuous);
    }

    public Map<String, List<String>> getValuesMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map<String, String> getDefaultValuesMap() {
        return Collections.unmodifiableMap(this.defaultValues);
    }

    public Map<String, Map<String, List<String>>> getDependentValuesMap() {
        return Collections.unmodifiableMap(this.dependentValues);
    }

    public Map<String, Map<String, Integer>> getCategoricalValueMap() {
        return Collections.unmodifiableMap(this.categoricalValueMap);
    }

    public Map<String, NormalizedRange> getNormalizedRangeMap() {
        return Collections.unmodifiableMap(this.contNormalizedRanges);
    }

    public List<String> getParameterNamesInAuthorativeOrder() {
        return this.authorativeParameterNameOrder;
    }

    public int hashCode() {
        return this.absoluteFileName.hashCode();
    }

    public boolean isCompatible(ParameterConfigurationSpace oSpace) {
        return Arrays.equals(this.categoricalSize, oSpace.categoricalSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterConfigurationSpace) {
            ParameterConfigurationSpace po = (ParameterConfigurationSpace)o;
            if (po.absoluteFileName.equals(this.absoluteFileName) && Arrays.equals(this.searchSubspaceActive, po.searchSubspaceActive) && Arrays.equals(this.searchSubspaceValues, po.searchSubspaceValues)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ParamFile:" + this.absoluteFileName;
    }

    public ParameterConfiguration getRandomParameterConfiguration(Random random) {
        return this.getRandomParameterConfiguration(random, false);
    }

    public ParameterConfiguration getRandomParameterConfiguration(Random random, boolean allowForbiddenParameters) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), allowForbiddenParameters);
    }

    public ParameterConfiguration getRandomParameterConfiguration(MersenneTwisterFast random) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), false);
    }

    public ParameterConfiguration getRandomParameterConfiguration(MersenneTwisterFast random, boolean allowForbiddenParameters) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), allowForbiddenParameters);
    }

    private ParameterConfiguration getRandomParameterConfiguration(RandomAdapter random, boolean allowForbiddenParameters) {
        if (random == null) {
            throw new IllegalArgumentException("Cannot supply null random object ");
        }
        double[] valueArray = new double[this.numberOfParameters];
        for (int j = 0; j < 1000000; ++j) {
            for (int i = 0; i < this.numberOfParameters; ++i) {
                if (this.searchSubspaceActive[i]) {
                    valueArray[i] = this.searchSubspaceValues[i];
                    continue;
                }
                if (this.parameterDomainContinuous[i]) {
                    NormalizedRange nr = this.normalizedRangesByIndex[i];
                    valueArray[i] = nr.normalizeValue(nr.unnormalizeValue(random.nextDouble()));
                    continue;
                }
                valueArray[i] = random.nextInt(this.categoricalSize[i]) + 1;
            }
            ParameterConfiguration p = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
            if (!allowForbiddenParameters && p.isForbiddenParameterConfiguration()) continue;
            return p;
        }
        throw new IllegalArgumentException("After 1,000,000 attempts at generating a random configurations we have failed to generate even one that isn't forbidden. It is likely that your forbidden parameter settings are too restrictive. Try excluding smaller regions of the space.");
    }

    public ParameterConfiguration getDefaultConfiguration() {
        return this.getConfigurationFromValueArray(this.defaultConfigurationValueArray);
    }

    private ParameterConfiguration _getDefaultConfiguration() {
        ParameterConfiguration p = new ParameterConfiguration(this, new double[this.numberOfParameters], this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
        Map<String, String> defaultMap = this.getDefaultValuesMap();
        p.putAll((Map<? extends String, ? extends String>)defaultMap);
        return p;
    }

    public double getUpperBoundOnSize() {
        double configSpaceSize = 1.0;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            int catSize = this.categoricalSize[i];
            if (catSize != 0) {
                configSpaceSize *= (double)catSize;
                continue;
            }
            NormalizedRange nr = this.contNormalizedRanges.get(this.authorativeParameterNameOrder.get(i));
            if (nr.isIntegerOnly()) {
                configSpaceSize *= nr.unnormalizeValue(1.0) - nr.unnormalizeValue(0.0) + 1.0;
                continue;
            }
            return Double.POSITIVE_INFINITY;
        }
        return configSpaceSize;
    }

    public double getLowerBoundOnSize() {
        double configSpaceSize = 1.0;
        if (this.forbiddenParameterValuesList.size() > 0) {
            return 1.0;
        }
        for (int i = 0; i < this.numberOfParameters; ++i) {
            int catSize = this.categoricalSize[i];
            if (this.condParents[i].length > 0) continue;
            if (catSize != 0) {
                configSpaceSize *= (double)catSize;
                continue;
            }
            NormalizedRange nr = this.contNormalizedRanges.get(this.authorativeParameterNameOrder.get(i));
            if (nr.isIntegerOnly()) {
                configSpaceSize *= nr.unnormalizeValue(1.0) - nr.unnormalizeValue(0.0) + 1.0;
                continue;
            }
            return Double.POSITIVE_INFINITY;
        }
        return configSpaceSize;
    }

    private ParameterConfiguration getConfigurationFromValueArray(double[] valueArray) {
        if (valueArray.length != this.categoricalSize.length) {
            throw new IllegalArgumentException("Value Array Length is not the right size " + valueArray.length + " vs " + this.categoricalSize.length);
        }
        return new ParameterConfiguration(this, (double[])valueArray.clone(), this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
    }

    public ParameterConfiguration getParameterConfigurationFromString(String paramString, ParameterConfiguration.ParameterStringFormat f) {
        return this.getParameterConfigurationFromString(paramString, f, null);
    }

    public ParameterConfiguration getParameterConfigurationFromString(String paramString, ParameterConfiguration.ParameterStringFormat f, Random rand) {
        try {
            ParameterConfiguration config;
            String trySpecialParamString = paramString.trim().toUpperCase();
            if (trySpecialParamString.equals("DEFAULT") || trySpecialParamString.equals("<DEFAULT>")) {
                return this.getDefaultConfiguration();
            }
            if (trySpecialParamString.equals("RANDOM") || trySpecialParamString.equals("<RANDOM>")) {
                if (rand == null) {
                    throw new IllegalStateException("Cannot generate random configurations unless a random object is passed with us");
                }
                return this.getRandomParameterConfiguration(rand);
            }
            HashSet<String> namesSpecified = new HashSet<String>();
            ParameterConfiguration defaultConfig = this.getDefaultConfiguration();
            switch (f) {
                case NODB_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case NODB_SYNTAX: {
                    String[] paramSplit;
                    String[] params;
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString;
                    for (String param : params = tmpParamString.split("\\s-")) {
                        if (param.equals("") || (paramSplit = param.trim().split(" "))[1].trim().equals("NaN")) continue;
                        config.put(paramSplit[0].trim(), paramSplit[1].replaceAll("'", "").trim());
                        namesSpecified.add(paramSplit[0].trim());
                    }
                    break;
                }
                case STATEFILE_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case STATEFILE_SYNTAX: {
                    String[] paramSplit;
                    String[] params;
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString.replaceAll("'", "");
                    for (String param : params = tmpParamString.split(",")) {
                        if (param.equals("") || (paramSplit = param.trim().split("="))[1].trim().equals("NaN")) continue;
                        config.put(paramSplit[0].trim(), paramSplit[1].trim());
                        namesSpecified.add(paramSplit[0].trim());
                    }
                    break;
                }
                case ARRAY_STRING_SYNTAX: {
                    double[] valueArray = new double[this.numberOfParameters];
                    String tmpParamString = paramString;
                    String[] params = tmpParamString.split(",");
                    if (params.length != valueArray.length) {
                        throw new IllegalArgumentException("Param String Value Array expected to be: " + valueArray.length + " but got a string of length " + paramString.length());
                    }
                    for (int i = 0; i < valueArray.length; ++i) {
                        valueArray[i] = Double.valueOf(params[i]);
                    }
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    namesSpecified.addAll(config.keySet());
                    break;
                }
                case SURROGATE_EXECUTOR: {
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = paramString.trim().replaceAll("-P", "");
                    String[] params = tmpParamString.split(" ");
                    for (int i = 0; i < params.length; ++i) {
                        String[] param = params[i].split("=");
                        if (param.length != 2) {
                            throw new IllegalArgumentException("Param String could not parse portion of string " + paramString + " error occured while seperating: (" + params[i] + ")");
                        }
                        namesSpecified.add(param[0].trim());
                        config.put(param[0].trim(), param[1].trim());
                    }
                    if (namesSpecified.equals(config.getActiveParameters())) break;
                    HashSet<String> missingButRequired = new HashSet<String>();
                    HashSet<String> specifiedButNotActive = new HashSet<String>();
                    missingButRequired.addAll(config.getActiveParameters());
                    missingButRequired.removeAll(namesSpecified);
                    specifiedButNotActive.addAll(namesSpecified);
                    specifiedButNotActive.removeAll(config.getActiveParameters());
                    throw new IllegalArgumentException("Param String specified some combination of inactive parameters and/or missed active parameters. \nRequired Parameters: " + config.getActiveParameters().size() + "\nSpecified Parameters: " + namesSpecified.size() + "\nRequired But Missing: " + ((Object)missingButRequired).toString() + "\nSpecified But Not Required" + ((Object)specifiedButNotActive).toString());
                }
                case NODB_OR_STATEFILE_SYNTAX: {
                    try {
                        return this.getParameterConfigurationFromString(paramString, ParameterConfiguration.ParameterStringFormat.STATEFILE_SYNTAX, rand);
                    }
                    catch (RuntimeException e) {
                        return this.getParameterConfigurationFromString(paramString, ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX, rand);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Parsing not implemented for String Format" + (Object)((Object)f));
                }
            }
            HashSet<String> allParameters = new HashSet<String>(this.getParameterNames());
            allParameters.removeAll(config.getActiveParameters());
            for (String inactiveParameter : allParameters) {
                if (config.get(inactiveParameter) != null) continue;
                config.put(inactiveParameter, defaultConfig.get(inactiveParameter));
            }
            TreeSet<String> unSetActiveParameters = new TreeSet<String>(config.getActiveParameters());
            unSetActiveParameters.removeAll(namesSpecified);
            if (unSetActiveParameters.size() > 0) {
                throw new ParameterConfigurationStringMissingParameterException("Error processing Parameter Configuration String \"" + paramString + "\" in format: " + (Object)((Object)f) + ". The string specified is missing one or more required parameters: " + ((Object)unSetActiveParameters).toString());
            }
            return config;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ParameterConfigurationStringFormatException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ParameterConfigurationStringFormatException("Error processing Parameter Configuration String \"" + paramString + "\" in format: " + (Object)((Object)f) + " please check the arguments (and nested exception) and try again", e);
        }
    }

    public int[] getCategoricalSize() {
        return (int[])this.categoricalSize.clone();
    }

    public int[][] getCondParentsArray() {
        return (int[][])this.condParents.clone();
    }

    public int[][][] getCondParentValsArray() {
        return (int[][][])this.condParentVals.clone();
    }

    public boolean isForbiddenParameterConfiguration(double[] valueArray) {
        for (int[][] forbiddenParamValues : this.forbiddenParameterValuesList) {
            boolean match = true;
            for (int[] forbiddenParamValue : forbiddenParamValues) {
                if (valueArray[forbiddenParamValue[0]] == (double)(forbiddenParamValue[1] + 1)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean isIntegerDouble(double d) {
        return d - Math.floor(d) == 0.0;
    }

    public boolean hasRealParameterFile() {
        return this.hasRealParameterFile;
    }

    public static ParameterConfigurationSpace getSingletonConfigurationSpace() {
        return new ParameterConfigurationSpace((Reader)new StringReader("singleton { singleton } [singleton]"), SINGLETON_ABSOLUTE_NAME);
    }

    public static ParameterConfigurationSpace getNullConfigurationSpace() {
        return new ParameterConfigurationSpace((Reader)new StringReader(""), NULL_ABSOLUTE_NAME);
    }

    void setValueInArray(double[] valueArray, String key, String newValue) {
        Integer index = this.paramKeyIndexMap.get(key);
        if (index == null) {
            throw new IllegalArgumentException("This key does not exist in the Parameter Space: " + key);
        }
        if (newValue == null) {
            valueArray[index.intValue()] = Double.NaN;
        } else if (this.parameterDomainContinuous[index]) {
            NormalizedRange nr = this.getNormalizedRangeMap().get(key);
            valueArray[index.intValue()] = nr.normalizeValue(nr.unnormalizeValue(nr.normalizeValue(Double.valueOf(newValue))));
        } else {
            List<String> inOrderValues = this.getValuesMap().get(key);
            int i = 1;
            boolean valueFound = false;
            for (String possibleValue : inOrderValues) {
                if (possibleValue.equals(newValue)) {
                    valueArray[index.intValue()] = i;
                    valueFound = true;
                    break;
                }
                ++i;
            }
            if (!valueFound) {
                throw new IllegalArgumentException("Value is not legal for this parameter: " + key + " Value:" + newValue);
            }
        }
    }

    public String getPCSFile() {
        return this.pcsFile;
    }

    public Map<String, String> getSearchSubspace() {
        return this.searchSubspace;
    }

    private static class RandomAdapter {
        private MersenneTwisterFast fastRand;
        private Random rand;

        RandomAdapter(Random r) {
            this.rand = r;
            this.fastRand = null;
        }

        RandomAdapter(MersenneTwisterFast fastRand) {
            this.rand = null;
            this.fastRand = fastRand;
        }

        public int nextInt(int n) {
            if (this.fastRand != null) {
                return this.fastRand.nextInt(n);
            }
            return this.rand.nextInt(n);
        }

        public double nextDouble() {
            if (this.fastRand != null) {
                return this.fastRand.nextDouble();
            }
            return this.rand.nextDouble();
        }
    }
}

