/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.probleminstance;

import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InstanceListWithSeeds {
    private final InstanceSeedGenerator seedGen;
    private final List<ProblemInstance> instances;
    private final List<String> instanceNames;
    private final Map<String, String> instanceSpecificInfo;
    private final List<ProblemInstance> instancesFromFeatures;
    private final String instanceFileAbsolutePath;
    private final String instanceFeatureFileAbsolutePath;

    public InstanceListWithSeeds(InstanceSeedGenerator seedGen, List<ProblemInstance> instances) {
        this.seedGen = seedGen;
        this.instances = instances;
        this.instanceNames = Collections.emptyList();
        this.instanceSpecificInfo = Collections.emptyMap();
        this.instancesFromFeatures = Collections.emptyList();
        this.instanceFileAbsolutePath = null;
        this.instanceFeatureFileAbsolutePath = null;
    }

    public InstanceListWithSeeds(InstanceSeedGenerator seedGen, List<ProblemInstance> instances, List<ProblemInstance> instancesByFeatures, String instanceFileAbsolutePath, String instanceFeatureFileAbsolutePath) {
        this.seedGen = seedGen;
        this.instances = instances;
        this.instanceNames = Collections.emptyList();
        this.instanceSpecificInfo = Collections.emptyMap();
        this.instancesFromFeatures = instancesByFeatures;
        this.instanceFileAbsolutePath = instanceFileAbsolutePath;
        this.instanceFeatureFileAbsolutePath = instanceFeatureFileAbsolutePath;
    }

    InstanceListWithSeeds(InstanceSeedGenerator seedGen, List<ProblemInstance> instances, List<String> instanceNames, Map<String, String> instanceSpecificInfo) {
        this.seedGen = seedGen;
        this.instanceNames = instanceNames;
        this.instances = instances == null ? new LinkedList() : instances;
        this.instanceSpecificInfo = instanceSpecificInfo;
        this.instancesFromFeatures = Collections.emptyList();
        this.instanceFileAbsolutePath = null;
        this.instanceFeatureFileAbsolutePath = null;
    }

    public InstanceSeedGenerator getSeedGen() {
        return this.seedGen;
    }

    public List<ProblemInstance> getInstances() {
        return this.instances;
    }

    public List<ProblemInstance> getInstancesFromFeatures() {
        return this.instancesFromFeatures;
    }

    List<String> getInstancesByName() {
        return this.instanceNames;
    }

    Map<String, String> getInstanceSpecificInfo() {
        return this.instanceSpecificInfo;
    }

    public String getInstanceFileAbsolutePath() {
        return this.instanceFileAbsolutePath;
    }

    public String getInstanceFeatureFileAbsolutePath() {
        return this.instanceFeatureFileAbsolutePath;
    }
}

