/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.probleminstance;

import ca.ubc.cs.beta.aeatk.json.serializers.ProblemInstanceJson;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;

@JsonSerialize(using=ProblemInstanceJson.ProblemInstanceSeedPairSerializer.class)
@JsonDeserialize(using=ProblemInstanceJson.ProblemInstanceSeedPairDeserializer.class)
public class ProblemInstanceSeedPair
implements Comparable<ProblemInstanceSeedPair>,
Serializable {
    private static final long serialVersionUID = 7686639875384341346L;
    private final ProblemInstance pi;
    private final long seed;

    public ProblemInstanceSeedPair(ProblemInstance pi, long seed) {
        if (pi == null) {
            throw new IllegalArgumentException("ProblemInstance cannot be null");
        }
        this.pi = pi;
        this.seed = seed;
    }

    public ProblemInstance getProblemInstance() {
        return this.pi;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemInstanceSeedPair) {
            ProblemInstanceSeedPair aisp = (ProblemInstanceSeedPair)o;
            return aisp.seed == this.seed && this.pi.equals(aisp.pi);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seed >>> 32 ^ (long)((int)this.seed) ^ (long)this.pi.hashCode());
    }

    public String toString() {
        return "<Instance:" + this.pi.getInstanceID() + ", Seed:" + this.seed + ">";
    }

    @Override
    public int compareTo(ProblemInstanceSeedPair o) {
        int idDiff = this.pi.getInstanceID() - o.pi.getInstanceID();
        if (idDiff != 0) {
            return idDiff;
        }
        long seedDiff = this.seed - o.seed;
        if (seedDiff < 0L) {
            return -1;
        }
        if (seedDiff > 0L) {
            return 1;
        }
        return 0;
    }
}

