/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.ReadWriteLockThreadTracker;
import ca.ubc.cs.beta.aeatk.runhistory.RunData;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSharingRunHistoryDecorator
implements ThreadSafeRunHistory {
    private final RunHistory runHistory;
    ReadWriteLockThreadTracker rwltt = new ReadWriteLockThreadTracker();
    private static final Logger log = LoggerFactory.getLogger(FileSharingRunHistoryDecorator.class);
    private final String sharedFileName;
    private final FileOutputStream fout;
    private final ObjectMapper map = new ObjectMapper();
    private static final String JSON_FILE_PREFIX = "live-rundata-";
    private static final String JSON_FILE_SUFFIX = ".json";
    private final File outputDir;
    private final int MSBetweenUpdates;
    private final JsonFactory factory = new JsonFactory();
    private final JsonGenerator g;
    private final List<ProblemInstance> pis;
    private final ConcurrentHashMap<File, Integer> importedRuns = new ConcurrentHashMap();
    private long lastUpdateTime = 0L;

    public FileSharingRunHistoryDecorator(RunHistory runHistory, File directory, int outputID, List<ProblemInstance> pis, int MSecondsBetweenUpdates) {
        this.runHistory = runHistory;
        this.outputDir = directory;
        if (MSecondsBetweenUpdates < 0) {
            throw new IllegalArgumentException("Seconds between updates must be positive, not:" + MSecondsBetweenUpdates);
        }
        this.MSBetweenUpdates = MSecondsBetweenUpdates;
        this.sharedFileName = new File(directory + File.separator + JSON_FILE_PREFIX + outputID + JSON_FILE_SUFFIX).getAbsolutePath();
        final File f = new File(this.sharedFileName);
        try {
            this.fout = new FileOutputStream(f);
            this.factory.setCodec((ObjectCodec)this.map);
            this.g = this.factory.createGenerator((OutputStream)this.fout);
            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            this.map.configure(SerializationFeature.INDENT_OUTPUT, true);
            this.map.registerModule((Module)sModule);
            ArrayList<ProblemInstance> myPis = new ArrayList<ProblemInstance>(pis);
            this.g.writeObject(myPis);
            this.g.flush();
            this.pis = Collections.unmodifiableList(myPis);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create shared model output file :" + this.sharedFileName);
        }
        if (log.isInfoEnabled()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("FileSharingRunHistory Logger (" + f.getName() + ")");
                    ArrayList<String> addedRunsStr = new ArrayList<String>();
                    int total = 0;
                    for (Map.Entry ent : FileSharingRunHistoryDecorator.this.importedRuns.entrySet()) {
                        addedRunsStr.add(((File)ent.getKey()).getName() + "=>" + ent.getValue());
                        int values = (Integer)ent.getValue();
                        if (values <= 0) continue;
                        total += values;
                    }
                    log.info("At shutdown RunHistory writing to {} had atleast {} runs added to it {}", new Object[]{f, total, addedRunsStr});
                }
            });
            Runtime.getRuntime().addShutdownHook(t);
        }
    }

    @Override
    public void append(Collection<AlgorithmRunResult> runs) {
        this.append(runs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(Collection<AlgorithmRunResult> runs, boolean write) {
        this.lockWrite();
        try {
            for (AlgorithmRunResult run : runs) {
                try {
                    this.runHistory.append(run);
                }
                catch (DuplicateRunException e1) {
                    continue;
                }
                if (!write) continue;
                try {
                    this.g.writeObject((Object)run);
                    this.g.flush();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't save data as JSON", e);
                }
                this.reReadFiles();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reReadFiles() {
        try {
            this.lockWrite();
            if (System.currentTimeMillis() - this.lastUpdateTime < (long)this.MSBetweenUpdates) {
                return;
            }
            try {
                File[] matchingFiles;
                for (File match : matchingFiles = this.outputDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.getName().startsWith(FileSharingRunHistoryDecorator.JSON_FILE_PREFIX) && pathname.getName().endsWith(FileSharingRunHistoryDecorator.JSON_FILE_SUFFIX)) {
                            return !pathname.getAbsolutePath().equals(FileSharingRunHistoryDecorator.this.sharedFileName);
                        }
                        return false;
                    }
                })) {
                    log.trace("Matching files: {} my file: {} ", (Object)match.getAbsolutePath(), (Object)this.sharedFileName);
                    this.readRunsFromFile(match);
                }
            }
            finally {
                this.lastUpdateTime = System.currentTimeMillis();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRunsFromFile(File match) {
        this.importedRuns.putIfAbsent(match, 0);
        int previousRuns = this.importedRuns.get(match);
        if (previousRuns == -1) {
            return;
        }
        JsonFactory jfactory = new JsonFactory();
        try {
            ObjectMapper map = new ObjectMapper(jfactory);
            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            map.registerModule((Module)sModule);
            JsonParser jParser = jfactory.createParser(match);
            ArrayList<Object> pis = new ArrayList<Object>(Arrays.asList((Object[])map.readValue(jParser, ProblemInstance[].class)));
            if (!pis.equals(this.pis)) {
                log.warn("Instances in file {} do match our instances, ignoring file.\nMine   : {}\nTheirs : {}", new Object[]{match, this.pis, pis});
                return;
            }
            ArrayList<Object> runResult = new ArrayList<Object>();
            MappingIterator it = map.readValues(jParser, (TypeReference)new TypeReference<AlgorithmRunResult>(){});
            while (it.hasNext()) {
                runResult.add(it.nextValue());
            }
            int newValue = previousRuns;
            try {
                for (AlgorithmRunResult run : runResult.subList(previousRuns, runResult.size())) {
                    try {
                        this.runHistory.append(run);
                        ++newValue;
                    }
                    catch (DuplicateRunException e) {}
                }
            }
            finally {
                this.importedRuns.put(match, newValue);
            }
        }
        catch (JsonParseException e) {
            log.debug("Error occurred reading file in shared run history" + match.getAbsolutePath() + ":", (Throwable)e);
        }
        catch (IOException e) {
            log.debug("Error occurred reading file in shared run history" + match.getAbsolutePath() + ":", (Throwable)e);
        }
    }

    @Override
    public void append(AlgorithmRunResult run) throws DuplicateRunException {
        this.append(Collections.singleton(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunObjective getRunObjective() {
        this.lockRead();
        try {
            RunObjective runObjective = this.runHistory.getRunObjective();
            return runObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverallObjective getOverallObjective() {
        this.lockRead();
        try {
            OverallObjective overallObjective = this.runHistory.getOverallObjective();
            return overallObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementIteration() {
        this.lockWrite();
        try {
            this.runHistory.incrementIteration();
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIteration() {
        this.lockRead();
        try {
            int n = this.runHistory.getIteration();
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getProblemInstancesRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getProblemInstancesRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getProblemInstanceSeedPairsRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getProblemInstanceSeedPairsRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, minimumResponseValue);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalRunCost() {
        this.lockRead();
        try {
            double d = this.runHistory.getTotalRunCost();
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getUniqueInstancesRan();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ParameterConfiguration> getUniqueParamConfigurations() {
        this.lockRead();
        try {
            Set<ParameterConfiguration> set = this.runHistory.getUniqueParamConfigurations();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] getParameterConfigurationInstancesRanByIndexExcludingRedundant() {
        this.lockRead();
        try {
            int[][] nArray = this.runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant();
            return nArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ParameterConfiguration> getAllParameterConfigurationsRan() {
        this.lockRead();
        try {
            List<ParameterConfiguration> list = this.runHistory.getAllParameterConfigurationsRan();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        this.lockRead();
        try {
            double[][] dArray = this.runHistory.getAllConfigurationsRanInValueArrayForm();
            return dArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunData> getAlgorithmRunDataIncludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunData> getAlgorithmRunDataExcludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getEarlyCensoredProblemInstanceSeedPairs(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThetaIdx(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            int n = this.runHistory.getThetaIdx(configuration);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void readLock() {
        this.lockRead();
    }

    @Override
    public void releaseReadLock() {
        this.unlockRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigIncludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.runHistory.getPerformanceForConfig(configuration);
            return map;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        this.lockRead();
        try {
            List<Long> list = this.runHistory.getSeedsUsedByInstance(pi);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    public void lockRead() {
        this.rwltt.lockRead();
    }

    private void unlockRead() {
        this.rwltt.unlockRead();
    }

    private void lockWrite() {
        this.rwltt.lockWrite();
    }

    private void unlockWrite() {
        this.rwltt.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateThetaIdx(ParameterConfiguration config) {
        this.lockWrite();
        try {
            int n = this.runHistory.getOrCreateThetaIdx(config);
            return n;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public double getEmpiricalCostLowerBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostLowerBound(config, instanceSet, cutoffTime);
    }

    @Override
    public double getEmpiricalCostUpperBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostUpperBound(config, instanceSet, cutoffTime);
    }
}

