/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

@ThreadSafe
public class KeyObjectManager<V> {
    private final BidiMap bidiMap;
    private int nextID;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();

    public KeyObjectManager() {
        this(1);
    }

    public KeyObjectManager(int firstID) {
        this.nextID = firstID;
        this.bidiMap = new DualHashBidiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Integer id, V obj) {
        try {
            this.myLock.writeLock().lock();
            if (this.bidiMap.containsKey((Object)id) || this.bidiMap.containsValue(obj)) {
                block12: {
                    System.out.println("Trying to add < " + id + "," + obj + ">");
                    if (this.bidiMap.containsKey((Object)id)) {
                        System.out.println("bidiMap contains key " + id + " already");
                        System.out.println("Value : " + this.bidiMap.get((Object)id));
                    }
                    if (this.bidiMap.containsValue(obj)) {
                        System.out.println("bidiMap contains value " + obj + " already");
                        System.out.println("Key: " + this.bidiMap.getKey(obj));
                    }
                    try {
                        if (!this.bidiMap.get((Object)id).equals(obj)) break block12;
                        return;
                    }
                    catch (NullPointerException e) {
                        System.err.println("Help me data structure corruption caused by RACE CONDITION!");
                        throw e;
                    }
                }
                if (this.bidiMap.containsKey((Object)id)) {
                    throw new IllegalArgumentException("Cannot replace index");
                }
                if (this.bidiMap.containsValue(obj)) {
                    throw new IllegalArgumentException("Cannot replace value");
                }
            }
            this.bidiMap.put((Object)id, obj);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(V obj) {
        try {
            this.myLock.writeLock().lock();
            this.add(this.nextID++, obj);
            int n = this.nextID - 1;
            return n;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue(int key) {
        try {
            this.myLock.readLock().lock();
            Object object = this.bidiMap.get((Object)key);
            return (V)object;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKey(V obj) {
        try {
            this.myLock.readLock().lock();
            Integer i = (Integer)this.bidiMap.getKey(obj);
            if (i == null) {
                int n = -1;
                return n;
            }
            int n = i;
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateKey(V obj) {
        if (obj == null) {
            throw new IllegalStateException("Can't write a null key");
        }
        try {
            this.myLock.writeLock().lock();
            this.myLock.readLock().lock();
            if (this.bidiMap.containsValue(obj)) {
                this.myLock.writeLock().unlock();
                int n = (Integer)this.bidiMap.getKey(obj);
                return n;
            }
            int n = this.append(obj);
            return n;
        }
        finally {
            if (this.myLock.writeLock().isHeldByCurrentThread()) {
                this.myLock.writeLock().unlock();
            }
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.myLock.readLock().lock();
            int n = this.bidiMap.size();
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }
}

