/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.ReadWriteLockThreadTracker;
import ca.ubc.cs.beta.aeatk.runhistory.RunData;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadSafeRunHistoryWrapper
implements ThreadSafeRunHistory {
    private final RunHistory runHistory;
    ReadWriteLockThreadTracker rwltt = new ReadWriteLockThreadTracker();

    public ThreadSafeRunHistoryWrapper(RunHistory runHistory) {
        this.runHistory = runHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Collection<AlgorithmRunResult> runs) throws DuplicateRunException {
        this.lockWrite();
        try {
            for (AlgorithmRunResult run : runs) {
                this.runHistory.append(run);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(AlgorithmRunResult run) throws DuplicateRunException {
        this.lockWrite();
        try {
            this.runHistory.append(run);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunObjective getRunObjective() {
        this.lockRead();
        try {
            RunObjective runObjective = this.runHistory.getRunObjective();
            return runObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverallObjective getOverallObjective() {
        this.lockRead();
        try {
            OverallObjective overallObjective = this.runHistory.getOverallObjective();
            return overallObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementIteration() {
        this.lockWrite();
        try {
            this.runHistory.incrementIteration();
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIteration() {
        this.lockRead();
        try {
            int n = this.runHistory.getIteration();
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getProblemInstancesRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getProblemInstancesRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getProblemInstanceSeedPairsRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getProblemInstanceSeedPairsRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, minimumResponseValue);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalRunCost() {
        this.lockRead();
        try {
            double d = this.runHistory.getTotalRunCost();
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getUniqueInstancesRan();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ParameterConfiguration> getUniqueParamConfigurations() {
        this.lockRead();
        try {
            Set<ParameterConfiguration> set = this.runHistory.getUniqueParamConfigurations();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] getParameterConfigurationInstancesRanByIndexExcludingRedundant() {
        this.lockRead();
        try {
            int[][] nArray = this.runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant();
            return nArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ParameterConfiguration> getAllParameterConfigurationsRan() {
        this.lockRead();
        try {
            List<ParameterConfiguration> list = this.runHistory.getAllParameterConfigurationsRan();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        this.lockRead();
        try {
            double[][] dArray = this.runHistory.getAllConfigurationsRanInValueArrayForm();
            return dArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunData> getAlgorithmRunDataIncludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunData> getAlgorithmRunDataExcludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getEarlyCensoredProblemInstanceSeedPairs(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThetaIdx(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            int n = this.runHistory.getThetaIdx(configuration);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void readLock() {
        this.lockRead();
    }

    @Override
    public void releaseReadLock() {
        this.unlockRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigIncludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.runHistory.getPerformanceForConfig(configuration);
            return map;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        this.lockRead();
        try {
            List<Long> list = this.runHistory.getSeedsUsedByInstance(pi);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    public void lockRead() {
        this.rwltt.lockRead();
    }

    private void unlockRead() {
        this.rwltt.unlockRead();
    }

    private void lockWrite() {
        this.rwltt.lockWrite();
    }

    private void unlockWrite() {
        this.rwltt.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateThetaIdx(ParameterConfiguration config) {
        this.lockWrite();
        try {
            int n = this.runHistory.getOrCreateThetaIdx(config);
            return n;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public double getEmpiricalCostLowerBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostLowerBound(config, instanceSet, cutoffTime);
    }

    @Override
    public double getEmpiricalCostUpperBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostUpperBound(config, instanceSet, cutoffTime);
    }
}

