/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractSyncTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluator {
    private final ExecutorService execService;

    public AbstractSyncTargetAlgorithmEvaluator() {
        this.execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory(this.getClass().getSimpleName() + " Abstract Blocking TAE Async Processing Thread"));
    }

    public AbstractSyncTargetAlgorithmEvaluator(int aThreads) {
        this.execService = Executors.newFixedThreadPool(aThreads, new SequentiallyNamedThreadFactory(this.getClass().getSimpleName() + " Abstract Blocking TAE Async Processing Thread"));
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        List<AlgorithmRunResult> runs = AbstractSyncTargetAlgorithmEvaluator.this.evaluateRun(runConfigs, obs);
                        handler.onSuccess(runs);
                    }
                    catch (RuntimeException e) {
                        handler.onFailure(e);
                    }
                    catch (Throwable t) {
                        handler.onFailure(new IllegalStateException("Unexpected throwable detected", t));
                        if (!(t instanceof Error)) break block3;
                        throw t;
                    }
                }
            }
        };
        if (this.areRunsPersisted()) {
            run.run();
        } else {
            this.execService.execute(run);
        }
    }

    protected abstract void subtypeShutdown();

    @Override
    public final void notifyShutdown() {
        this.execService.shutdown();
        this.subtypeShutdown();
    }
}

