/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality.OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class AbstractTargetAlgorithmEvaluator
implements TargetAlgorithmEvaluator {
    protected final AtomicInteger runCount = new AtomicInteger(0);

    @Override
    public abstract List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> var1, TargetAlgorithmEvaluatorRunObserver var2);

    @Override
    public abstract void evaluateRunsAsync(List<AlgorithmRunConfiguration> var1, TargetAlgorithmEvaluatorCallback var2, TargetAlgorithmEvaluatorRunObserver var3);

    @Override
    public final List<AlgorithmRunResult> evaluateRun(AlgorithmRunConfiguration run) {
        return this.evaluateRun(Collections.singletonList(run), null);
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs) {
        return this.evaluateRun(runConfigs, null);
    }

    @Override
    public final void evaluateRunsAsync(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluatorCallback handler) {
        this.evaluateRunsAsync(Collections.singletonList(runConfig), handler);
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback handler) {
        this.evaluateRunsAsync(runConfigs, handler, null);
    }

    @Override
    public int getRunCount() {
        return this.runCount.get();
    }

    @Override
    public int getRunHash() {
        return 0;
    }

    @Override
    public void seek(List<AlgorithmRunResult> runs) {
        this.runCount.set(runs.size());
    }

    protected void addRuns(List<AlgorithmRunResult> runs) {
        this.runCount.addAndGet(runs.size());
    }

    @Override
    public String getManualCallString(AlgorithmRunConfiguration runConfig) {
        AlgorithmExecutionConfiguration execConfig = runConfig.getAlgorithmExecutionConfiguration();
        StringBuilder sb = new StringBuilder();
        String commandSeparator = ";";
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            commandSeparator = "&";
        }
        if (execConfig.getAlgorithmExecutionDirectory().matches(".*\\s.*")) {
            sb.append("cd \"").append(execConfig.getAlgorithmExecutionDirectory()).append("\"" + commandSeparator + " ");
        } else {
            sb.append("cd ").append(execConfig.getAlgorithmExecutionDirectory()).append(commandSeparator + " ");
        }
        sb.append(CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(runConfig));
        sb.append("");
        return sb.toString();
    }

    @Override
    public void waitForOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingRuns() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingBatches() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final void close() {
        this.notifyShutdown();
    }
}

