/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.AbstractAsyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.algorithmrunner.ConcurrentAlgorithmRunner;
import com.beust.jcommander.ParameterException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTargetAlgorithmEvaluator
extends AbstractAsyncTargetAlgorithmEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int observerFrequency;
    private final CommandLineTargetAlgorithmEvaluatorOptions options;
    private final BlockingQueue<Integer> executionIDs;
    private final ExecutorService asyncExecService;
    private final ExecutorService commandLineAlgorithmRunExecutorService;
    private final ExecutorService observerExecutorService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("CLI TAE Observer Threads", true));
    private final Semaphore asyncExecutions;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    CommandLineTargetAlgorithmEvaluator(CommandLineTargetAlgorithmEvaluatorOptions options) {
        this.observerFrequency = options.observerFrequency;
        if (this.observerFrequency < 50) {
            throw new ParameterException("Observer Frequency can't be less than 50 ms");
        }
        this.options = options;
        this.executionIDs = new ArrayBlockingQueue<Integer>(options.cores);
        this.asyncExecService = Executors.newFixedThreadPool(options.cores, new SequentiallyNamedThreadFactory("CLI TAE Asynchronous Request Processing"));
        this.commandLineAlgorithmRunExecutorService = Executors.newFixedThreadPool(options.cores, new SequentiallyNamedThreadFactory("CLI TAE Master Dispatch Thread", true));
        this.asyncExecutions = new Semaphore(options.cores, true);
        int numCPUs = Runtime.getRuntime().availableProcessors();
        if (options.cores > numCPUs) {
            this.log.warn("Number of cores requested is seemingly greater than the number of available cores. This may affect runtime measurements");
        }
        for (int i = 0; i < options.cores; ++i) {
            this.executionIDs.add(i);
        }
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback taeCallback, final TargetAlgorithmEvaluatorRunObserver runStatusObserver) {
        if (runConfigs.size() == 0) {
            taeCallback.onSuccess(Collections.emptyList());
            return;
        }
        try {
            this.asyncExecutions.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            taeCallback.onFailure(new IllegalStateException("Request interrupted", e));
            return;
        }
        this.asyncExecService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    ConcurrentAlgorithmRunner runner = null;
                    List<AlgorithmRunResult> runs = null;
                    try {
                        try {
                            runner = CommandLineTargetAlgorithmEvaluator.this.getAlgorithmRunner(runConfigs, runStatusObserver);
                            runs = runner.run(CommandLineTargetAlgorithmEvaluator.this.commandLineAlgorithmRunExecutorService);
                        }
                        finally {
                            CommandLineTargetAlgorithmEvaluator.this.asyncExecutions.release();
                        }
                    }
                    catch (RuntimeException e) {
                        taeCallback.onFailure(e);
                        return;
                    }
                    catch (Throwable e) {
                        taeCallback.onFailure(new IllegalStateException("Unexpected Throwable:", e));
                        if (e instanceof Error) {
                            throw e;
                        }
                        return;
                    }
                    CommandLineTargetAlgorithmEvaluator.this.addRuns(runs);
                    try {
                        if (runStatusObserver != null) {
                            runStatusObserver.currentStatus(runs);
                        }
                        taeCallback.onSuccess(runs);
                    }
                    catch (RuntimeException e) {
                        taeCallback.onFailure(e);
                    }
                    catch (Throwable e) {
                        taeCallback.onFailure(new IllegalStateException("Unexpected Throwable:", e));
                        if (!(e instanceof Error)) break block12;
                        throw e;
                    }
                }
            }
        });
    }

    private ConcurrentAlgorithmRunner getAlgorithmRunner(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        int cores = this.options.cores;
        if (!this.options.concurrentExecution) {
            cores = 1;
        }
        return new ConcurrentAlgorithmRunner(runConfigs, cores, obs, this.options, this.executionIDs, this.observerExecutorService);
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    public boolean areRunsObservable() {
        return true;
    }

    @Override
    public void notifyShutdown() {
        try {
            this.asyncExecService.shutdown();
            this.commandLineAlgorithmRunExecutorService.shutdown();
            this.observerExecutorService.shutdown();
            this.log.debug("Awaiting Termination of existing command line algorithm runs");
            boolean terminated = this.asyncExecService.awaitTermination(10L, TimeUnit.SECONDS);
            while (!terminated) {
                this.log.warn("Termination of target algorithm evaluator failed, outstanding runs must still exist, ");
                terminated = this.asyncExecService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            terminated = this.commandLineAlgorithmRunExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
            while (!terminated) {
                this.log.warn("Termination of target algorithm evaluator failed (CLI Runs), outstanding runs must still exist, ");
                terminated = this.commandLineAlgorithmRunExecutorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            terminated = this.observerExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
            while (!terminated) {
                this.log.warn("Termination of target algorithm evaluator failed (CLI Runs), outstanding runs must still exist, ");
                terminated = this.observerExecutorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.asyncExecService.shutdownNow();
            this.commandLineAlgorithmRunExecutorService.shutdownNow();
            this.observerExecutorService.shutdownNow();
            return;
        }
    }
}

