/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.algorithmrunner;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentAlgorithmRunner {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentAlgorithmRunner.class);
    protected final List<AlgorithmRunConfiguration> runConfigs;
    protected final List<Callable<AlgorithmRunResult>> runs;
    private final Semaphore updatedRunMapSemaphore = new Semaphore(0);
    private final Future<?> runStatusWatchingFuture;
    private final CountDownLatch observerThreadTerminated = new CountDownLatch(1);
    private final AtomicBoolean observerThreadStarted = new AtomicBoolean(false);

    public ConcurrentAlgorithmRunner(final List<AlgorithmRunConfiguration> runConfigs, int numberOfConcurrentExecutions, final TargetAlgorithmEvaluatorRunObserver obs, final CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs, ExecutorService execService) {
        if (runConfigs == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.runConfigs = runConfigs;
        this.runs = new ArrayList<Callable<AlgorithmRunResult>>(runConfigs.size());
        final ConcurrentHashMap<AlgorithmRunConfiguration, RunningAlgorithmRunResult> runConfigToLatestUpdatedRunMap = new ConcurrentHashMap<AlgorithmRunConfiguration, RunningAlgorithmRunResult>(runConfigs.size());
        final ConcurrentHashMap<AlgorithmRunConfiguration, Integer> runConfigToPositionInListMap = new ConcurrentHashMap<AlgorithmRunConfiguration, Integer>(runConfigs.size());
        int i = 0;
        for (AlgorithmRunConfiguration rc : runConfigs) {
            StatusVariableKillHandler killH = new StatusVariableKillHandler();
            runConfigToPositionInListMap.put(rc, i);
            runConfigToLatestUpdatedRunMap.put(rc, new RunningAlgorithmRunResult(rc, 0.0, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), 0.0, killH));
            TargetAlgorithmEvaluatorRunObserver individualRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

                @Override
                public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                    if (((AlgorithmRunResult)runConfigToLatestUpdatedRunMap.get(runs.get(0).getAlgorithmRunConfiguration())).isRunCompleted() && !runs.get(0).isRunCompleted()) {
                        StringBuilder sb = new StringBuilder("Current Run Status being notified: " + runs.get(0).getAlgorithmRunConfiguration());
                        sb.append("\n Current status in table").append(((AlgorithmRunResult)runConfigToLatestUpdatedRunMap.get(runs.get(0).getAlgorithmRunConfiguration())).getAlgorithmRunConfiguration());
                        IllegalStateException e = new IllegalStateException("RACE CONDITION: " + sb.toString());
                        log.error("Some kind of race condition has occurred", (Throwable)e);
                        e.printStackTrace();
                        throw e;
                    }
                    runConfigToLatestUpdatedRunMap.put(runs.get(0).getAlgorithmRunConfiguration(), runs.get(0));
                    ConcurrentAlgorithmRunner.this.updatedRunMapSemaphore.release();
                }
            };
            CommandLineAlgorithmRun run = new CommandLineAlgorithmRun(rc, individualRunObserver, killH, options, executionIDs);
            this.runs.add(run);
            ++i;
        }
        ++i;
        Runnable runStatusWatchingThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        if (!ConcurrentAlgorithmRunner.this.observerThreadStarted.compareAndSet(false, true)) {
                            return;
                        }
                        this.doLoop();
                    }
                    finally {
                        ConcurrentAlgorithmRunner.this.observerThreadTerminated.countDown();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }

            public void doLoop() throws InterruptedException {
                boolean outstandingRuns;
                long startOfTimer = 0L;
                do {
                    long lastUpdate = System.currentTimeMillis();
                    ConcurrentAlgorithmRunner.this.updatedRunMapSemaphore.acquire();
                    ConcurrentAlgorithmRunner.this.updatedRunMapSemaphore.drainPermits();
                    AlgorithmRunResult[] runs = new AlgorithmRunResult[runConfigs.size()];
                    outstandingRuns = false;
                    long delta = System.currentTimeMillis() - startOfTimer;
                    if (delta < (long)options.observerFrequency) {
                        Thread.sleep(Math.max(1L, (long)options.observerFrequency - delta + 20L));
                    }
                    for (Map.Entry entries : runConfigToLatestUpdatedRunMap.entrySet()) {
                        AlgorithmRunResult run = (AlgorithmRunResult)entries.getValue();
                        if (run.getRunStatus().equals((Object)RunStatus.RUNNING)) {
                            outstandingRuns = true;
                        }
                        runs[((Integer)runConfigToPositionInListMap.get(entries.getKey())).intValue()] = run;
                    }
                    try {
                        List<AlgorithmRunResult> runList = Arrays.asList(runs);
                        if (obs != null) {
                            obs.currentStatus(runList);
                        }
                        startOfTimer = System.currentTimeMillis();
                    }
                    catch (RuntimeException e) {
                        log.error("Error occured while notifying observer ", (Throwable)e);
                        throw e;
                    }
                } while (outstandingRuns);
            }
        };
        this.runStatusWatchingFuture = execService.submit(runStatusWatchingThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<AlgorithmRunResult> run(ExecutorService p) {
        ArrayList<AlgorithmRunResult> arrayList;
        ArrayList<AlgorithmRunResult> results = new ArrayList<AlgorithmRunResult>();
        List<Callable<AlgorithmRunResult>> runsToDo = this.runs;
        List<Future<AlgorithmRunResult>> futures = p.invokeAll(runsToDo);
        try {
            for (Future<AlgorithmRunResult> futRuns : futures) {
                AlgorithmRunResult run;
                try {
                    run = futRuns.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof TargetAlgorithmAbortException) {
                        throw (TargetAlgorithmAbortException)e.getCause();
                    }
                    throw new IllegalStateException("Unexpected exception occurred while trying to run algorithm", e);
                }
                if (run.getRunStatus().equals((Object)RunStatus.ABORT)) {
                    throw new TargetAlgorithmAbortException(run);
                }
                results.add(run);
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            try {
                for (Future<AlgorithmRunResult> future : futures) {
                    future.cancel(true);
                }
                this.runStatusWatchingFuture.cancel(true);
                boolean alreadyStarted = this.observerThreadStarted.getAndSet(true);
                if (alreadyStarted) {
                    while (!this.observerThreadTerminated.await(10L, TimeUnit.MINUTES)) {
                        log.warn("Awaiting shutdown of Target Algorithm Evaluator Observer Thread did not complete within 10 minutes");
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while processing runs");
            }
        }
        for (Future<AlgorithmRunResult> future : futures) {
            future.cancel(true);
        }
        this.runStatusWatchingFuture.cancel(true);
        boolean alreadyStarted = this.observerThreadStarted.getAndSet(true);
        if (alreadyStarted) {
            while (!this.observerThreadTerminated.await(10L, TimeUnit.MINUTES)) {
                log.warn("Awaiting shutdown of Target Algorithm Evaluator Observer Thread did not complete within 10 minutes");
            }
        }
        return arrayList;
    }
}

