/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.misc.string.SplitQuotedString;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.AbstractSyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.IPCTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.mechanism.ReverseTCPMechanism;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.mechanism.TCPMechanism;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.mechanism.UDPMechanism;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class IPCTargetAlgorithmEvaluator
extends AbstractSyncTargetAlgorithmEvaluator {
    private static final Logger log = LoggerFactory.getLogger(IPCTargetAlgorithmEvaluator.class);
    private final IPCTargetAlgorithmEvaluatorOptions options;
    private final ServerSocket serverSocket;
    private final Process proc;
    private final ExecutorService executors = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("IPC Target Algorithm Evaluator Threads ", true));
    private final LinkedBlockingQueue<Socket> openConnections = new LinkedBlockingQueue();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final AtomicBoolean subProcessShutdownDetected = new AtomicBoolean(false);

    public IPCTargetAlgorithmEvaluator(IPCTargetAlgorithmEvaluatorOptions options) {
        this.options = options;
        int localPort = 0;
        switch (this.options.ipcMechanism) {
            case TCP: {
                this.verifyRemoteAddress();
                this.serverSocket = null;
                log.info("Target Algorithm Evaluator making TCP connections to {}:{}.", (Object)options.remoteHost, (Object)options.remotePort);
                break;
            }
            case UDP: {
                this.verifyRemoteAddress();
                this.serverSocket = null;
                log.info("Target Algorithm Evaluator making UDP connections to {}:{}.", (Object)options.remoteHost, (Object)options.remotePort);
                break;
            }
            case REVERSE_TCP: {
                try {
                    this.serverSocket = new ServerSocket(this.options.localPort);
                    localPort = this.serverSocket.getLocalPort();
                    log.info("IPC Target Algorithm Evaluator is listening on port {}", (Object)localPort);
                    break;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't start server on local port", e);
                }
            }
            default: {
                throw new ParameterException("Not implemented:" + (Object)((Object)this.options.ipcMechanism));
            }
        }
        if (options.execScript != null && options.execScript.trim().length() > 0) {
            Process proc;
            String[] args = SplitQuotedString.splitQuotedString(options.execScript + " " + localPort);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.redirectErrorStream(true);
            pb.command(args);
            try {
                proc = pb.start();
            }
            catch (IOException e) {
                log.debug("Couldn't start process exec script:", (Throwable)e);
                throw new ParameterException("Could not start IPC Target Algorithm Evaluator execution script, please check your arguments and try again, error was: " + e.getMessage());
            }
            IPCStreamReader sg = new IPCStreamReader(proc.getInputStream(), options.execScriptOutput);
            this.executors.execute(sg);
            this.proc = proc;
        } else {
            this.proc = null;
        }
        if (options.poolConnections) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Socket sock = IPCTargetAlgorithmEvaluator.this.serverSocket.accept();
                            sock.setTcpNoDelay(true);
                            IPCTargetAlgorithmEvaluator.this.openConnections.put(sock);
                        }
                    }
                    catch (SocketException e) {
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (IOException e) {
                        log.error("Unknown Error occurred", (Throwable)e);
                        return;
                    }
                }
            };
            this.executors.execute(run);
        }
    }

    private void verifyRemoteAddress() throws ParameterException {
        if (this.options.remotePort <= 0 || this.options.remotePort > 65535) {
            throw new ParameterException("To use the " + (Object)((Object)this.options.ipcMechanism) + " mechanism you must specify a port in [1,65535]");
        }
        if (this.options.remoteHost == null) {
            throw new ParameterException("You must specify a remote host to use the " + (Object)((Object)this.options.ipcMechanism));
        }
        try {
            InetAddress.getByName(this.options.remoteHost);
        }
        catch (UnknownHostException e) {
            throw new ParameterException("Could resolve hostname: " + this.options.remoteHost);
        }
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return this.options.persistent;
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }

    @Override
    protected void subtypeShutdown() {
        this.isShutdown.set(true);
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                log.error("Could not close server socket.", (Throwable)e);
            }
        }
        this.executors.shutdownNow();
        if (this.proc != null) {
            this.proc.destroy();
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver runStatusObserver) {
        ArrayList<AlgorithmRunResult> completedRuns;
        block17: {
            completedRuns = new ArrayList<AlgorithmRunResult>(runConfigs.size());
            if (this.subProcessShutdownDetected.get()) {
                log.warn("Exec script has terminated, it is unclear if this run will ever be completed");
            }
            if (this.options.ipcMechanism.equals((Object)IPCTargetAlgorithmEvaluatorOptions.IPCMechanism.REVERSE_TCP)) {
                while (true) {
                    ReverseTCPMechanism rtcp = new ReverseTCPMechanism(this.options.encodingMechanism.getEncoder());
                    try {
                        Socket socket = this.getConnection();
                        try {
                            InputStream in = socket.getInputStream();
                            OutputStream out = socket.getOutputStream();
                            for (AlgorithmRunConfiguration rc : runConfigs) {
                                AlgorithmRunResult run = rtcp.evaluateRun(in, out, rc);
                                completedRuns.add(run);
                            }
                            break block17;
                        }
                        finally {
                            this.returnConnection(socket);
                        }
                    }
                    catch (IOException e) {
                        log.error("Error occured during IPC call, trying connection again in 10 seconds", (Throwable)e);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw new TargetAlgorithmAbortException(e1);
                        }
                    }
                }
            }
            block14: for (AlgorithmRunConfiguration rc : runConfigs) {
                switch (this.options.ipcMechanism) {
                    case UDP: {
                        UDPMechanism udp = new UDPMechanism(this.options.encodingMechanism.getEncoder());
                        AlgorithmRunResult run = udp.evaluateRun(rc, this.options.remotePort, this.options.remoteHost, this.options.udpPacketSize);
                        completedRuns.add(run);
                        continue block14;
                    }
                    case TCP: {
                        TCPMechanism tcp = new TCPMechanism(this.options.encodingMechanism.getEncoder());
                        AlgorithmRunResult run = tcp.evaluateRun(rc, this.options.remoteHost, this.options.remotePort);
                        completedRuns.add(run);
                        continue block14;
                    }
                    case REVERSE_TCP: {
                        throw new IllegalStateException("Shouldn't be able to get to this branch");
                    }
                }
                throw new IllegalStateException("Not sure what this was");
            }
        }
        return completedRuns;
    }

    private synchronized void returnConnection(Socket socket) throws IOException {
        if (this.options.poolConnections) {
            try {
                if (socket.isConnected() && !socket.isClosed()) {
                    this.openConnections.put(socket);
                }
                log.debug("Stale connection being returned, dropping");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        } else {
            socket.close();
        }
    }

    private Socket getConnection() throws IOException {
        if (this.options.poolConnections) {
            try {
                Socket socket = this.openConnections.take();
                if (socket.isConnected() && !socket.isClosed()) {
                    return socket;
                }
                log.debug("Stale connection detected, retrying");
                return this.getConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Could not obtain connection, interrupted", e);
            }
        }
        Socket socket = this.serverSocket.accept();
        socket.setTcpNoDelay(true);
        return socket;
    }

    private class IPCStreamReader
    implements Runnable {
        InputStream is;
        private boolean output;

        private IPCStreamReader(InputStream is, boolean output) {
            this.is = is;
            this.output = output;
        }

        @Override
        public void run() {
            LinkedList<String> last10Lines = new LinkedList<String>();
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.output) {
                        log.info("IPC-TAE Client> " + line);
                        continue;
                    }
                    last10Lines.add(line);
                    if (last10Lines.size() <= 10) continue;
                    last10Lines.poll();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (!IPCTargetAlgorithmEvaluator.this.isShutdown.get()) {
                try {
                    IPCTargetAlgorithmEvaluator.this.proc.waitFor();
                    IPCTargetAlgorithmEvaluator.this.subProcessShutdownDetected.set(true);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    int retValue = IPCTargetAlgorithmEvaluator.this.proc.exitValue();
                    if (retValue > 0) {
                        log.warn("Calling script shutdown with non-zero exit ({}) code, last 10 lines were:", (Object)retValue);
                        for (String aLine : last10Lines) {
                            log.warn("> " + aLine);
                        }
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
        }
    }
}

