/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.mechanism;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.ipc.encoding.EncodingMechanism;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TCPMechanism {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EncodingMechanism enc;

    public TCPMechanism(EncodingMechanism enc) {
        this.enc = enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmRunResult evaluateRun(AlgorithmRunConfiguration rc, String remoteHost, int remotePort) {
        AlgorithmRunResult algorithmRunResult;
        Socket clientSocket = new Socket(remoteHost, remotePort);
        try {
            BufferedOutputStream bout = new BufferedOutputStream(clientSocket.getOutputStream());
            AutoStartStopWatch watch = new AutoStartStopWatch();
            bout.write(this.enc.getOutputBytes(rc));
            bout.flush();
            algorithmRunResult = this.enc.getInputBytes(rc, clientSocket.getInputStream(), watch);
        }
        catch (Throwable throwable) {
            try {
                clientSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log.error("Error creating socket, trying connection again in 10 seconds", (Throwable)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new TargetAlgorithmAbortException(e1);
                }
                return this.evaluateRun(rc, remoteHost, remotePort);
            }
        }
        clientSocket.close();
        return algorithmRunResult;
    }
}

