/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CheckForDuplicateRunConfigDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean throwException;

    public CheckForDuplicateRunConfigDecorator(TargetAlgorithmEvaluator tae, boolean throwException) {
        super(tae);
        this.throwException = throwException;
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        this.checkRunConfigs(runConfigs);
        return this.tae.evaluateRun(runConfigs, obs);
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.checkRunConfigs(runConfigs);
        this.tae.evaluateRunsAsync(runConfigs, handler, obs);
    }

    public void checkRunConfigs(List<AlgorithmRunConfiguration> runConfigs) {
        HashSet<AlgorithmRunConfiguration> rcs = new HashSet<AlgorithmRunConfiguration>();
        rcs.addAll(runConfigs);
        if (rcs.size() != runConfigs.size()) {
            this.log.error("Duplicate Run Configurations Requested this is almost certainly a bug");
            this.log.error("Duplicate Run Configs Follow:");
            for (AlgorithmRunConfiguration rc : this.findDuplicates(runConfigs)) {
                this.log.error("\tDuplicate Run Config: {}", (Object)rc);
            }
            this.log.error("All Run Configs follow:");
            for (AlgorithmRunConfiguration rc : runConfigs) {
                this.log.error("\tRun Config: {} ", (Object)rc);
            }
            if (this.throwException) {
                throw new IllegalStateException("Duplicate Run Configurations cannot be part of the same call of evaluateRun()/evaluateRunAsync()");
            }
        }
    }

    private Set<AlgorithmRunConfiguration> findDuplicates(List<AlgorithmRunConfiguration> listContainingDuplicates) {
        HashSet<AlgorithmRunConfiguration> setToReturn = new HashSet<AlgorithmRunConfiguration>();
        HashSet<AlgorithmRunConfiguration> set1 = new HashSet<AlgorithmRunConfiguration>();
        for (AlgorithmRunConfiguration yourInt : listContainingDuplicates) {
            if (set1.add(yourInt)) continue;
            setToReturn.add(yourInt);
        }
        return setToReturn;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

