/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LogEveryTargetAlgorithmEvaluatorDecorator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    Logger log = LoggerFactory.getLogger(LogEveryTargetAlgorithmEvaluatorDecorator.class);
    private final boolean logRCOnly;
    private final String context;

    public LogEveryTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        this(tae, false);
    }

    public LogEveryTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, String context) {
        this(tae, context, false);
    }

    public LogEveryTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, boolean logRequestResponsesRCOnly) {
        super(tae);
        this.context = "";
        this.logRCOnly = logRequestResponsesRCOnly;
    }

    public LogEveryTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, String context, boolean logRequestResponsesRCOnly) {
        super(tae);
        this.logRCOnly = logRequestResponsesRCOnly;
        this.context = context != null ? "(" + context + ") " : "";
    }

    @Override
    protected AlgorithmRunResult processRun(AlgorithmRunResult run) {
        if (this.logRCOnly) {
            this.log.debug("Run {}Completed: {} ", (Object)this.context, (Object)run.getAlgorithmRunConfiguration());
        } else {
            this.log.debug("Run {}Completed: {} : {} ", new Object[]{this.context, run, run.getAdditionalRunData()});
        }
        return run;
    }

    @Override
    protected AlgorithmRunConfiguration processRun(AlgorithmRunConfiguration rc) {
        this.log.debug("Run {}Scheduled: {} ", (Object)this.context, (Object)rc);
        return rc;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

