/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import com.beust.jcommander.ParameterException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final double scalingFactor;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<AlgorithmRunConfiguration> killedRuns = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, double scalingFactor) {
        super(tae);
        if (scalingFactor <= 1.0) {
            throw new ParameterException("Scaling Factor for killing cannot be less than or equal to 1.0");
        }
        if (scalingFactor < 2.0) {
            this.log.warn("Scaling factors less than 2.0 are STRONGLY discouraged, as the runtime observations we make are only very approximate.");
        }
        this.scalingFactor = scalingFactor;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.tae.evaluateRun(runConfigs, new KillingTargetAlgorithmEvaluatorRunObserver(obs));
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.tae.evaluateRunsAsync(runConfigs, oHandler, new KillingTargetAlgorithmEvaluatorRunObserver(obs));
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }

    private class KillingTargetAlgorithmEvaluatorRunObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;

        KillingTargetAlgorithmEvaluatorRunObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            for (AlgorithmRunResult algorithmRunResult : runs) {
                if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING) && algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime() * KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.scalingFactor < algorithmRunResult.getRuntime() && !KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.killedRuns.contains(algorithmRunResult.getAlgorithmRunConfiguration())) {
                    Object[] args = new Object[]{algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRuntime(), KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.scalingFactor, algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime()};
                    KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.log.warn("Killed run {} at {} for exceeding {} times its cutoff time of {} (secs)", args);
                    algorithmRunResult.kill();
                }
                if (this.obs == null) continue;
                this.obs.currentStatus(runs);
            }
        }
    }
}

