/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class StrictlyIncreasingRuntimesTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AtomicDouble> maxRuntimeObserved = new ConcurrentHashMap();

    public StrictlyIncreasingRuntimesTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, final TargetAlgorithmEvaluatorRunObserver obs) {
        for (AlgorithmRunConfiguration rc : runConfigs) {
            this.maxRuntimeObserved.put(rc, new AtomicDouble(0.0));
        }
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                ArrayList<AlgorithmRunResult> fixedRuns = new ArrayList<AlgorithmRunResult>(runs.size());
                for (AlgorithmRunResult run : runs) {
                    double runtime = 0.0;
                    switch (run.getRunStatus()) {
                        case KILLED: {
                            runtime = Math.max(((AtomicDouble)StrictlyIncreasingRuntimesTargetAlgorithmEvaluatorDecorator.this.maxRuntimeObserved.get(run.getAlgorithmRunConfiguration())).get(), run.getRuntime());
                            break;
                        }
                        default: {
                            runtime = run.getRuntime();
                        }
                    }
                    fixedRuns.add(new ExistingAlgorithmRunResult(run.getAlgorithmRunConfiguration(), run.getRunStatus(), runtime, run.getRunLength(), run.getQuality(), run.getResultSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime()));
                }
                this.handler.onSuccess(fixedRuns);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        TargetAlgorithmEvaluatorRunObserver runObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                ArrayList<ExistingAlgorithmRunResult> fixedRuns = new ArrayList<ExistingAlgorithmRunResult>(runs.size());
                for (final AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING)) {
                        KillHandler kh = new KillHandler(){
                            AtomicBoolean b = new AtomicBoolean(false);

                            @Override
                            public void kill() {
                                this.b.set(true);
                                algorithmRunResult.kill();
                            }

                            @Override
                            public boolean isKilled() {
                                return this.b.get();
                            }
                        };
                        fixedRuns.add(new RunningAlgorithmRunResult(algorithmRunResult.getAlgorithmRunConfiguration(), this.updateRuntime(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRuntime()), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getWallclockExecutionTime(), kh));
                        continue;
                    }
                    if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.KILLED)) {
                        fixedRuns.add(new ExistingAlgorithmRunResult(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRunStatus(), this.updateRuntime(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRuntime()), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getAdditionalRunData(), algorithmRunResult.getWallclockExecutionTime()));
                        continue;
                    }
                    fixedRuns.add(new ExistingAlgorithmRunResult(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRunStatus(), algorithmRunResult.getRuntime(), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getAdditionalRunData(), algorithmRunResult.getWallclockExecutionTime()));
                }
                if (obs != null) {
                    obs.currentStatus(fixedRuns);
                }
            }

            private double updateRuntime(AlgorithmRunConfiguration rc, double runtime) {
                double oldValue;
                AtomicDouble d = (AtomicDouble)StrictlyIncreasingRuntimesTargetAlgorithmEvaluatorDecorator.this.maxRuntimeObserved.get(rc);
                while ((oldValue = d.get()) < runtime) {
                    d.compareAndSet(oldValue, runtime);
                }
                return runtime;
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, runObs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

