/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseDynamicCappingExclusivelyTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public UseDynamicCappingExclusivelyTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, final TargetAlgorithmEvaluatorRunObserver obs) {
        final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunConfiguration> transformedRuns = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunConfiguration>();
        ArrayList<AlgorithmRunConfiguration> newRunConfigs = new ArrayList<AlgorithmRunConfiguration>(runConfigs.size());
        for (AlgorithmRunConfiguration rc : runConfigs) {
            if (rc.hasCutoffLessThanMax()) {
                AlgorithmRunConfiguration newRC = new AlgorithmRunConfiguration(rc.getProblemInstanceSeedPair(), rc.getParameterConfiguration(), rc.getAlgorithmExecutionConfiguration());
                transformedRuns.put(newRC, rc);
                newRunConfigs.add(newRC);
                continue;
            }
            transformedRuns.put(rc, rc);
            newRunConfigs.add(rc);
        }
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                ArrayList<AlgorithmRunResult> fixedRuns = new ArrayList<AlgorithmRunResult>(runs.size());
                for (AlgorithmRunResult run : runs) {
                    AlgorithmRunConfiguration origRunConfig;
                    RunStatus r = run.getRunStatus();
                    double runtime = run.getRuntime();
                    if (runtime > (origRunConfig = (AlgorithmRunConfiguration)transformedRuns.get(run.getAlgorithmRunConfiguration())).getCutoffTime()) {
                        switch (r) {
                            case SAT: 
                            case UNSAT: 
                            case KILLED: 
                            case TIMEOUT: {
                                r = RunStatus.TIMEOUT;
                                runtime = origRunConfig.getCutoffTime();
                                break;
                            }
                        }
                    }
                    fixedRuns.add(new ExistingAlgorithmRunResult(origRunConfig, r, runtime, run.getRunLength(), run.getQuality(), run.getResultSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime()));
                }
                this.handler.onSuccess(fixedRuns);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        TargetAlgorithmEvaluatorRunObserver runObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                ArrayList<ExistingAlgorithmRunResult> fixedRuns = new ArrayList<ExistingAlgorithmRunResult>(runs.size());
                for (final AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING)) {
                        KillHandler kh = new KillHandler(){
                            AtomicBoolean b = new AtomicBoolean(false);

                            @Override
                            public void kill() {
                                this.b.set(true);
                                algorithmRunResult.kill();
                            }

                            @Override
                            public boolean isKilled() {
                                return this.b.get();
                            }
                        };
                        if (transformedRuns.get(algorithmRunResult.getAlgorithmRunConfiguration()) == null) {
                            UseDynamicCappingExclusivelyTargetAlgorithmEvaluatorDecorator.this.log.error("Couldn't find original run config for {} in {} ", (Object)algorithmRunResult.getAlgorithmRunConfiguration(), (Object)transformedRuns);
                        }
                        fixedRuns.add(new RunningAlgorithmRunResult((AlgorithmRunConfiguration)transformedRuns.get(algorithmRunResult.getAlgorithmRunConfiguration()), algorithmRunResult.getRuntime(), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getWallclockExecutionTime(), kh));
                        if (!(((AlgorithmRunConfiguration)transformedRuns.get(algorithmRunResult.getAlgorithmRunConfiguration())).getCutoffTime() < algorithmRunResult.getRuntime())) continue;
                        algorithmRunResult.kill();
                        continue;
                    }
                    fixedRuns.add(new ExistingAlgorithmRunResult((AlgorithmRunConfiguration)transformedRuns.get(algorithmRunResult.getAlgorithmRunConfiguration()), algorithmRunResult.getRunStatus(), algorithmRunResult.getRuntime(), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getAdditionalRunData(), algorithmRunResult.getWallclockExecutionTime()));
                }
                if (obs != null) {
                    obs.currentStatus(fixedRuns);
                }
            }
        };
        this.tae.evaluateRunsAsync(newRunConfigs, myHandler, runObs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

