/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AbortOnCrashTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    public AbortOnCrashTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.validate(super.evaluateRun(runConfigs, obs));
    }

    private List<AlgorithmRunResult> validate(List<AlgorithmRunResult> runs) {
        for (AlgorithmRunResult run : runs) {
            if (!run.getRunStatus().equals((Object)RunStatus.CRASHED)) continue;
            throw new TargetAlgorithmAbortException("Target Algorithm Run Reported Crashed: " + run.toString());
        }
        return runs;
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                try {
                    AbortOnCrashTargetAlgorithmEvaluator.this.validate(runs);
                    handler.onSuccess(runs);
                }
                catch (TargetAlgorithmAbortException e) {
                    handler.onFailure(e);
                }
            }

            @Override
            public void onFailure(RuntimeException t) {
                handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

