/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    AtomicBoolean jvmShutdownDetected = new AtomicBoolean(false);
    AtomicBoolean jvmShutdownNoticeLogged = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
        Thread shutdownHookDetection = new Thread(new Runnable(){

            @Override
            public void run() {
                JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownDetected.set(true);
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHookDetection);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback callback, final TargetAlgorithmEvaluatorRunObserver observer) {
        if (this.jvmShutdownDetected.get()) {
            if (this.jvmShutdownNoticeLogged.compareAndSet(false, true)) {
                this.log.debug("JVM Shutdown detected, all algorithm execution requests and completion results are being dropped");
            }
            return;
        }
        TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownDetected.get()) {
                    if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownNoticeLogged.compareAndSet(false, true)) {
                        JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.log.debug("JVM Shutdown detected, all algorithm execution requests and completion results are being dropped");
                    }
                    return;
                }
                callback.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException e) {
                if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownDetected.get()) {
                    if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownNoticeLogged.compareAndSet(false, true)) {
                        JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.log.debug("JVM Shutdown detected, all algorithm execution requests and completion results are being dropped");
                    }
                    return;
                }
                callback.onFailure(e);
            }
        };
        TargetAlgorithmEvaluatorRunObserver taeObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownDetected.get()) {
                    if (JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.jvmShutdownNoticeLogged.compareAndSet(false, true)) {
                        JVMShutdownBlockerTargetAlgorithmEvaluatorDecorator.this.log.debug("JVM Shutdown detected, all algorithm execution requests and completion results are being dropped");
                    }
                    return;
                }
                observer.currentStatus(runs);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, taeCallback, observer != null ? taeObs : null);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }
}

