/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SATConsistencyTargetAlgorithmEvaluator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private final ConcurrentHashMap<ProblemInstance, RunStatus> runResults = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(SATConsistencyTargetAlgorithmEvaluator.class);
    private final boolean throwException;

    public SATConsistencyTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae, boolean throwException) {
        super(tae);
        this.throwException = throwException;
    }

    @Override
    protected AlgorithmRunResult processRun(AlgorithmRunResult run) {
        RunStatus result = run.getRunStatus();
        switch (result) {
            case SAT: 
            case UNSAT: {
                RunStatus previousResult = this.runResults.putIfAbsent(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), result);
                if (previousResult != null && !previousResult.equals((Object)result)) {
                    Object[] args = new Object[]{run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), previousResult, result};
                    log.error("SAT/UNSAT discrepancy detected on problem instance: {}. Previous value: {}, currentValue: {}", args);
                    if (this.throwException) {
                        throw new TargetAlgorithmAbortException("RunResult dispatch detected inconsistence with previous result " + (Object)((Object)previousResult) + " currentResult: " + (Object)((Object)result) + " run" + run);
                    }
                }
            }
            case TIMEOUT: 
            case CRASHED: 
            case ABORT: 
            case KILLED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected run result on algorithm run: " + run);
            }
        }
        return run;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

