/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TimingCheckerTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private double totalWallClockOverhead = 0.0;
    private double totalRuntimeOverhead = 0.0;
    private double totalWallClockVersusRuntimeDifference = 0.0;
    private double totalWalltime;
    private double totalRuntime;
    private boolean subsecondOverheadLogged = false;
    private static final Logger log = LoggerFactory.getLogger(TimingCheckerTargetAlgorithmEvaluator.class);
    private double runtimeDeltaToRequireLogging = 1.0;
    private double wallClockDeltaToRequireLogging = 10.0;

    public TimingCheckerTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDecorateeNotifyShutdown() {
        TimingCheckerTargetAlgorithmEvaluator timingCheckerTargetAlgorithmEvaluator = this;
        synchronized (timingCheckerTargetAlgorithmEvaluator) {
            double maxOverhead = 0.0;
            maxOverhead = Math.max(this.totalRuntimeOverhead / this.totalRuntime, maxOverhead);
            maxOverhead = Math.max(this.totalWallClockOverhead / this.totalWalltime, maxOverhead);
            maxOverhead = Math.max(this.totalWalltime / this.totalRuntime, maxOverhead);
            if (log.isDebugEnabled() || maxOverhead > 0.1) {
                log.debug("Total Reported Runtime: {} (s), Total of Sum Max(runtime-cutoff,0): {} (s)", (Object)this.totalRuntime, (Object)this.totalRuntimeOverhead);
                log.debug("Total Walltime: {} (s), Total of Sum Max(walltime - cutoff, 0): {} (s)", (Object)this.totalWalltime, (Object)this.totalWallClockOverhead);
                log.debug("Total Difference between Walltime and Runtime (Sum of the amount of wallclock time - sum of the amount of reported CPU time) : {} seconds", (Object)this.totalWallClockVersusRuntimeDifference);
            }
        }
    }

    protected synchronized AlgorithmRunResult processRun(AlgorithmRunResult run) {
        double runtimeOverhead = run.getRuntime() - run.getAlgorithmRunConfiguration().getCutoffTime();
        this.totalRuntime += Math.max(run.getRuntime(), 0.0);
        this.totalRuntimeOverhead += Math.max(runtimeOverhead, 0.0);
        if (runtimeOverhead > this.runtimeDeltaToRequireLogging) {
            this.runtimeDeltaToRequireLogging = runtimeOverhead + 1.0;
            Object[] args = new Object[]{run.getRuntime(), run.getAlgorithmRunConfiguration().getCutoffTime(), runtimeOverhead, this.runtimeDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported a runtime of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        double wallClockOverhead = run.getWallclockExecutionTime() - run.getAlgorithmRunConfiguration().getCutoffTime();
        this.totalWalltime += Math.max(run.getWallclockExecutionTime(), 0.0);
        this.totalWallClockOverhead += Math.max(wallClockOverhead, 0.0);
        if (wallClockOverhead > Math.min(Math.max(10.0, 1.5 * run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime()), this.wallClockDeltaToRequireLogging)) {
            this.wallClockDeltaToRequireLogging = wallClockOverhead + 1.0;
            Object[] args = new Object[]{run.getWallclockExecutionTime(), run.getAlgorithmRunConfiguration().getCutoffTime(), wallClockOverhead, this.wallClockDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported wallclock time of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        this.totalWallClockVersusRuntimeDifference += Math.max(run.getWallclockExecutionTime() - run.getRuntime(), 0.0);
        return run;
    }

    protected synchronized AlgorithmRunConfiguration processRun(AlgorithmRunConfiguration rc) {
        return rc;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.processRuns(this.tae.evaluateRun(this.processRunConfigs(runConfigs), new WarnOnExceededCutoffRunObserver(obs)));
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                runs = TimingCheckerTargetAlgorithmEvaluator.this.processRuns(runs);
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(this.processRunConfigs(runConfigs), myHandler, new WarnOnExceededCutoffRunObserver(obs));
    }

    protected final List<AlgorithmRunResult> processRuns(List<AlgorithmRunResult> runs) {
        for (int i = 0; i < runs.size(); ++i) {
            runs.set(i, this.processRun(runs.get(i)));
        }
        return runs;
    }

    protected final List<AlgorithmRunConfiguration> processRunConfigs(List<AlgorithmRunConfiguration> runConfigs) {
        runConfigs = new ArrayList<AlgorithmRunConfiguration>(runConfigs);
        for (int i = 0; i < runConfigs.size(); ++i) {
            runConfigs.set(i, this.processRun(runConfigs.get(i)));
        }
        return runConfigs;
    }

    private class WarnOnExceededCutoffRunObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private final TargetAlgorithmEvaluatorRunObserver obs;
        private ConcurrentHashMap<AlgorithmRunConfiguration, Boolean> warnCreated = new ConcurrentHashMap();

        public WarnOnExceededCutoffRunObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            try {
                if (this.obs != null) {
                    this.obs.currentStatus(runs);
                }
            }
            catch (Throwable throwable) {
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.isRunCompleted() || !(algorithmRunResult.getWallclockExecutionTime() > 3.0 * algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime()) || !(algorithmRunResult.getWallclockExecutionTime() > 180.0) || this.warnCreated.putIfAbsent(algorithmRunResult.getAlgorithmRunConfiguration(), Boolean.TRUE) != null) continue;
                    log.warn("We have been waiting for {} seconds for a run that should have taken at most {} seconds.\n The sample call for the run that is delayed is: cd \"{}\" " + CommandLineAlgorithmRun.COMMAND_SEPERATOR + "  {} ", new Object[]{algorithmRunResult.getWallclockExecutionTime(), algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime(), new File(algorithmRunResult.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(algorithmRunResult.getAlgorithmRunConfiguration())});
                }
                throw throwable;
            }
            for (AlgorithmRunResult algorithmRunResult : runs) {
                if (algorithmRunResult.isRunCompleted() || !(algorithmRunResult.getWallclockExecutionTime() > 3.0 * algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime()) || !(algorithmRunResult.getWallclockExecutionTime() > 180.0) || this.warnCreated.putIfAbsent(algorithmRunResult.getAlgorithmRunConfiguration(), Boolean.TRUE) != null) continue;
                log.warn("We have been waiting for {} seconds for a run that should have taken at most {} seconds.\n The sample call for the run that is delayed is: cd \"{}\" " + CommandLineAlgorithmRun.COMMAND_SEPERATOR + "  {} ", new Object[]{algorithmRunResult.getWallclockExecutionTime(), algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime(), new File(algorithmRunResult.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(algorithmRunResult.getAlgorithmRunConfiguration())});
            }
        }
    }
}

