/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class VerifySATTargetAlgorithmEvaluator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private static transient Logger log = LoggerFactory.getLogger(VerifySATTargetAlgorithmEvaluator.class);
    private static final Set<String> satResponses = new HashSet<String>();
    private static final Set<String> unsatResponses = new HashSet<String>();

    public VerifySATTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    protected AlgorithmRunResult processRun(AlgorithmRunResult run) {
        switch (run.getRunStatus()) {
            case SAT: {
                if (unsatResponses.contains(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation())) {
                    Object[] args = new Object[]{run.getRunStatus(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation(), run};
                    log.error("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                    break;
                }
                if (!run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation().equals("UNKNOWN")) break;
                Object[] args = new Object[]{run.getRunStatus(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation(), run};
                log.warn("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                break;
            }
            case UNSAT: {
                if (satResponses.contains(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation())) {
                    Object[] args = new Object[]{run.getRunStatus(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation(), run};
                    log.error("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}> ): {} ", args);
                    break;
                }
                if (!run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation().equals("UNKNOWN")) break;
                Object[] args = new Object[]{run.getRunStatus(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation(), run};
                log.warn("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                break;
            }
        }
        return run;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }

    static {
        String[] mySatResponses = new String[]{"SAT", "SATISFIABLE"};
        String[] myUnsatResponses = new String[]{"UNSAT", "UNSATISFIABLE"};
        satResponses.addAll(Arrays.asList(mySatResponses));
        unsatResponses.addAll(Arrays.asList(myUnsatResponses));
    }
}

