/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final ExecutorService execService = Executors.newFixedThreadPool(1, new SequentiallyNamedThreadFactory("TAE Warning Checking Thread", true));
    private volatile boolean observed = false;
    private final Semaphore runsSubmitted = new Semaphore(0);
    private final Semaphore runsObserved = new Semaphore(0);

    public WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, final int timeToWaitInSeconds) {
        super(tae);
        this.execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.runsSubmitted.acquire();
                        AutoStartStopWatch watch = new AutoStartStopWatch();
                        boolean acquired = WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.runsObserved.tryAcquire(timeToWaitInSeconds, TimeUnit.SECONDS);
                        watch.stop();
                        if (!acquired) {
                            Logger log = LoggerFactory.getLogger(this.getClass());
                            log.warn("Runs have been submitted to Target Algorithm Evaluator but we have not recieved any data back after {} seconds of waiting, it's possible that the observer frequency is too low, or something is wrong with the Target Algorithm Evaluator", (Object)(watch.time() / 1000L));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.execService.shutdown();
                }
            }
        });
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        if (this.observed) {
            return this.tae.evaluateRun(runConfigs, obs);
        }
        this.runsSubmitted.release();
        List<AlgorithmRunResult> runs = this.tae.evaluateRun(runConfigs, new WarningObserver(obs));
        this.markObserved();
        return runs;
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        if (this.observed) {
            this.tae.evaluateRunsAsync(runConfigs, oHandler, obs);
        } else {
            this.runsSubmitted.release();
            TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
                private final TargetAlgorithmEvaluatorCallback handler;
                {
                    this.handler = oHandler;
                }

                @Override
                public void onSuccess(List<AlgorithmRunResult> runs) {
                    WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.markObserved();
                    this.handler.onSuccess(runs);
                }

                @Override
                public void onFailure(RuntimeException t) {
                    WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.markObserved();
                    this.handler.onFailure(t);
                }
            };
            this.tae.evaluateRunsAsync(runConfigs, myHandler, new WarningObserver(obs));
        }
    }

    @Override
    public final void postDecorateeNotifyShutdown() {
        this.execService.shutdownNow();
    }

    private final synchronized void markObserved() {
        this.observed = true;
        this.runsObserved.release();
        if (!this.execService.isShutdown()) {
            this.execService.shutdownNow();
        }
    }

    private class WarningObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;

        WarningObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public synchronized void currentStatus(List<? extends AlgorithmRunResult> runs) {
            if (this.obs != null) {
                this.obs.currentStatus(runs);
            }
            if (!WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.observed) {
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.getWallclockExecutionTime() > 0.0) {
                        WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.markObserved();
                        return;
                    }
                    if (!(algorithmRunResult.getWallclockExecutionTime() > 0.0)) continue;
                    WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator.this.markObserved();
                    return;
                }
            }
        }
    }
}

