/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init;

import ca.ubc.cs.beta.aeatk.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TAEPluginSecurityManager;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAlgorithmEvaluatorLoader {
    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(String name, Map<String, AbstractOptions> taeOptions) {
        Logger log = LoggerFactory.getLogger(TargetAlgorithmEvaluatorLoader.class);
        ClassLoader loader = SPIClassLoaderHelper.getClassLoader();
        Iterator<TargetAlgorithmEvaluatorFactory> taeIt = ServiceLoader.load(TargetAlgorithmEvaluatorFactory.class, loader).iterator();
        while (taeIt.hasNext()) {
            try {
                TargetAlgorithmEvaluatorFactory tae = taeIt.next();
                if (tae.getName().contains(" ")) {
                    log.warn("Target Algorithm Evaluator has white space in it's name, this is a violation of the contract of {}. Sleeping for 5 seconds", (Object)TargetAlgorithmEvaluatorFactory.class.getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!tae.getName().trim().equals(name.trim())) continue;
                return tae.getTargetAlgorithmEvaluator(taeOptions);
            }
            catch (ServiceConfigurationError e) {
                log.error("Error occured while retrieving Target Algorithm Evaluator", (Throwable)e);
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new IllegalArgumentException("No Target Algorithm Evalutor found for name: " + name);
    }

    public static Map<String, AbstractOptions> getAvailableTargetAlgorithmEvaluators() {
        return TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators(SPIClassLoaderHelper.getClassLoader());
    }

    /*
     * Exception decompiling
     */
    private static Map<String, AbstractOptions> getAvailableTargetAlgorithmEvaluators(ClassLoader loader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SecurityManager initSecurityManagerIfPossible() {
        SecurityManager old = System.getSecurityManager();
        try {
            System.setSecurityManager(new TAEPluginSecurityManager());
            return old;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void resetSecurityManagerIfPossible(SecurityManager oldSecurityManager) {
        try {
            System.setSecurityManager(oldSecurityManager);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

