/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.termination.standard;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aeatk.termination.ConditionType;
import ca.ubc.cs.beta.aeatk.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aeatk.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AlgorithmRunLimitCondition
extends AbstractTerminationCondition
implements EventHandler<AlgorithmRunCompletedEvent> {
    private final String NAME = "NUMBER OF RUNS";
    private final long algorithmRunLimit;
    private final AtomicLong algorithmRuns = new AtomicLong(0L);

    public AlgorithmRunLimitCondition(long algorithmRunLimit) {
        this.algorithmRunLimit = algorithmRunLimit;
    }

    @Override
    public boolean haveToStop() {
        return this.algorithmRuns.get() >= this.algorithmRunLimit;
    }

    @Override
    public void handleEvent(AlgorithmRunCompletedEvent event) {
    }

    @Override
    public void notifyRun(AlgorithmRunResult run) {
        this.algorithmRuns.incrementAndGet();
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.singleton(new ValueMaxStatus(ConditionType.NUMBER_OF_RUNS, this.algorithmRuns.get(), this.algorithmRunLimit, "NUMBER OF RUNS", "Algorithm Runs", ""));
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "algorithm run limit (" + this.algorithmRuns + " runs) has been reached.";
        }
        return "";
    }
}

