/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.termination.standard;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.termination.ConditionType;
import ca.ubc.cs.beta.aeatk.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aeatk.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class ConfigurationSpaceExhaustedCondition
extends AbstractTerminationCondition
implements EventHandler<AlgorithmRunCompletedEvent> {
    private final double runLimit;
    private final AtomicLong algorithmRuns = new AtomicLong(0L);
    private final String NAME = "CONFIG_SPACE";
    private final int runsPerConfiguration;
    private final double configSpaceSize;

    public ConfigurationSpaceExhaustedCondition(ParameterConfigurationSpace configSpace, int runsPerConfiguration) {
        this.runLimit = configSpace.getUpperBoundOnSize() * (double)runsPerConfiguration;
        this.runsPerConfiguration = runsPerConfiguration;
        this.configSpaceSize = configSpace.getUpperBoundOnSize();
    }

    @Override
    public boolean haveToStop() {
        return this.runLimit <= (double)this.algorithmRuns.get();
    }

    @Override
    public void handleEvent(AlgorithmRunCompletedEvent event) {
        this.algorithmRuns.incrementAndGet();
    }

    @Override
    public void notifyRun(AlgorithmRunResult run) {
        this.algorithmRuns.incrementAndGet();
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        long currentStatus = this.algorithmRuns.get();
        double currentFraction = (double)(currentStatus * 100L) / this.runLimit;
        if (currentFraction >= 10.0) {
            return Collections.singleton(new ValueMaxStatus(ConditionType.NUMBER_OF_RUNS, currentStatus, this.runLimit, "CONFIG_SPACE", "Configuration Space Searched " + currentFraction + " % \n"));
        }
        return Collections.emptySet();
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "every possible configuration (" + this.configSpaceSize + ") and problem instance seed pair (" + this.runsPerConfiguration + ") has been run.";
        }
        return "";
    }
}

