/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.termination.standard;

import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aeatk.termination.ConditionType;
import ca.ubc.cs.beta.aeatk.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aeatk.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ModelIterationTerminationCondition
extends AbstractTerminationCondition
implements EventHandler<ModelBuildEndEvent> {
    private final String NAME = "NUMBER OF RUNS";
    private final long modelBuildLimit;
    private final AtomicLong modelBuildIteration = new AtomicLong(0L);

    public ModelIterationTerminationCondition(long modelBuildLimit) {
        this.modelBuildLimit = modelBuildLimit;
    }

    @Override
    public boolean haveToStop() {
        return this.modelBuildIteration.get() >= this.modelBuildLimit;
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.singleton(new ValueMaxStatus(ConditionType.OTHER, this.modelBuildIteration.get(), this.modelBuildLimit, "NUMBER OF RUNS", "Model/Iteration", ""));
    }

    @Override
    public void handleEvent(ModelBuildEndEvent event) {
        this.modelBuildIteration.incrementAndGet();
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
        evtManager.registerHandler(ModelBuildEndEvent.class, this);
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "model building / iteration limit (" + this.modelBuildIteration + ") has been reached.";
        }
        return "";
    }
}

