/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.trajectoryfile;

import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFile;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFileParser;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@UsageTextField(hiddenSection=true)
public class TrajectoryFileOptions
extends AbstractOptions {
    @Parameter(names={"--trajectory-files", "--trajectory-file", "--trajectoryFile"}, description="Trajectory file(s) to read configurations from", variableArity=true)
    public List<String> trajectoryFiles = new ArrayList<String>();
    @Parameter(names={"--trajectory-use-tunertime-if-no-walltime", "--useTunerTimeIfNoWallTime"}, description="Use the tuner time as walltime if there is no walltime in the trajectory file")
    public boolean useTunerTimeIfNoWallTime;

    public List<TrajectoryFileEntry> parseTrajectoryFile(ParameterConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        if (this.trajectoryFiles.size() > 0) {
            return TrajectoryFileParser.parseTrajectoryFileAsList(new File(this.trajectoryFiles.get(0)), configSpace, this.useTunerTimeIfNoWallTime);
        }
        throw new IllegalArgumentException("No trajectory file specified (precondition of calling this");
    }

    public Set<TrajectoryFile> parseTrajectoryFiles(ParameterConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        TreeSet<TrajectoryFile> tfes = new TreeSet<TrajectoryFile>();
        for (String trajFile : this.trajectoryFiles) {
            tfes.add(new TrajectoryFile(new File(trajFile), TrajectoryFileParser.parseTrajectoryFileAsList(new File(trajFile), configSpace, this.useTunerTimeIfNoWallTime)));
        }
        return tfes;
    }
}

