/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.watchdog;

import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aeatk.watchdog.ThreadWatchDog;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LiveThreadWatchDog<K extends AutomaticConfiguratorEvent>
implements ThreadWatchDog<K> {
    private volatile long lastEventTimeStamp = Long.MIN_VALUE;
    private final Set<Thread> threads = Collections.synchronizedSet(new LinkedHashSet());
    private final ScheduledExecutorService watchDogThread = Executors.newScheduledThreadPool(2, new SequentiallyNamedThreadFactory("Watch Dog Thread", true));
    private volatile boolean init = false;
    private final long lastEventDelayInMS;
    private int delayBetweenChecks;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int delayBeforeShutdownInMS;
    private final int logThreadActivityFrequencyInSeconds;

    public LiveThreadWatchDog(long lastEventDelayInSeconds, int delayBetweenChecksInSeconds, int delayBeforeShutdownInSeconds, int logThreadActivityFrequencyInSeconds) {
        if (delayBeforeShutdownInSeconds < 0) {
            throw new IllegalArgumentException("Delay Before Shutdown must be non-negative");
        }
        if (lastEventDelayInSeconds < 0L) {
            throw new IllegalArgumentException("Last Event Delay in Seconds must be non-negative");
        }
        if (delayBetweenChecksInSeconds < 0) {
            throw new IllegalArgumentException("Delay Between CHecks in Seconds must be positive");
        }
        if (logThreadActivityFrequencyInSeconds < 0) {
            throw new IllegalArgumentException("LogThreadActivityMust be greater than zero");
        }
        this.lastEventDelayInMS = lastEventDelayInSeconds * 1000L;
        this.delayBetweenChecks = delayBetweenChecksInSeconds;
        this.delayBeforeShutdownInMS = delayBeforeShutdownInSeconds;
        this.logThreadActivityFrequencyInSeconds = logThreadActivityFrequencyInSeconds;
    }

    @Override
    public synchronized void handleEvent(K event) {
        this.init();
        this.lastEventTimeStamp = System.currentTimeMillis();
    }

    @Override
    public synchronized void registerCurrentThread() {
        this.init();
        this.registerThread(Thread.currentThread());
    }

    @Override
    public synchronized void registerThread(Thread t) {
        this.init();
        this.threads.add(t);
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.watchDogThread.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LiveThreadWatchDog liveThreadWatchDog = LiveThreadWatchDog.this;
                synchronized (liveThreadWatchDog) {
                    if (System.currentTimeMillis() - LiveThreadWatchDog.this.lastEventTimeStamp < LiveThreadWatchDog.this.lastEventDelayInMS) {
                        return;
                    }
                    Set set = LiveThreadWatchDog.this.threads;
                    synchronized (set) {
                        boolean deadThread = false;
                        for (Thread t : LiveThreadWatchDog.this.threads) {
                            deadThread = deadThread || !t.isAlive();
                        }
                        if (!deadThread) {
                            return;
                        }
                        LiveThreadWatchDog.this.log.error("Dead Thread Detected");
                        for (Thread t : LiveThreadWatchDog.this.threads) {
                            StringBuilder sb = new StringBuilder();
                            for (StackTraceElement el : t.getStackTrace()) {
                                sb.append(el.toString() + "\n");
                            }
                            Object[] args = new Object[]{t.getName(), t.getId(), t.getState(), t.isInterrupted(), sb.toString()};
                            LiveThreadWatchDog.this.log.error("Thread: {} [{}] State: {} Interrupted: {}\nStack Trace:\n {}", args);
                            t.interrupt();
                        }
                        ThreadMXBean b = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] infos = b.getThreadInfo(b.getAllThreadIds(), true, true);
                        LiveThreadWatchDog.this.log.error("Dumping all thread info");
                        for (ThreadInfo info : infos) {
                            LiveThreadWatchDog.this.log.error("ThreadInfo: ", (Object)info);
                        }
                        try {
                            if (LiveThreadWatchDog.this.delayBeforeShutdownInMS > 0) {
                                Thread.sleep(LiveThreadWatchDog.this.delayBeforeShutdownInMS);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        System.exit(101);
                    }
                }
            }
        }, this.delayBetweenChecks, this.delayBetweenChecks, TimeUnit.SECONDS);
        this.watchDogThread.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LiveThreadWatchDog liveThreadWatchDog = LiveThreadWatchDog.this;
                synchronized (liveThreadWatchDog) {
                    Set set = LiveThreadWatchDog.this.threads;
                    synchronized (set) {
                        for (Thread t : LiveThreadWatchDog.this.threads) {
                            StringBuilder sb = new StringBuilder();
                            for (StackTraceElement el : t.getStackTrace()) {
                                sb.append("\t").append(el.toString()).append("\n");
                            }
                            Object[] args = new Object[]{t.getName(), t.getId(), t.getState(), t.isInterrupted(), sb.toString()};
                            LiveThreadWatchDog.this.log.debug("Thread: {} [{}] State: {} Interrupted: {}\nStack Trace:\n{}", args);
                            t.interrupt();
                        }
                        ThreadMXBean b = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] infos = b.getThreadInfo(b.getAllThreadIds(), true, true);
                        LiveThreadWatchDog.this.log.debug("Dumping all thread info");
                        StringBuilder info = new StringBuilder();
                        for (ThreadInfo threadInfo : infos) {
                            info.append("Thread: ").append(threadInfo.getThreadName()).append(" [").append(threadInfo.getThreadId()).append("]");
                            info.append(" State: ").append((Object)threadInfo.getThreadState()).append("\n");
                            info.append("Lock Name:").append(threadInfo.getLockName()).append("  Owner: ").append(threadInfo.getLockOwnerName()).append(" [").append(threadInfo.getLockOwnerId()).append("]\n");
                            StringBuilder sb = new StringBuilder();
                            for (StackTraceElement el : threadInfo.getStackTrace()) {
                                sb.append("\t").append(el.toString()).append("\n");
                            }
                            info.append("Stack Trace:\n").append((CharSequence)sb);
                            info.append("\n");
                        }
                        LiveThreadWatchDog.this.log.debug("Thread Dump {}:", (Object)info);
                    }
                }
            }
        }, this.logThreadActivityFrequencyInSeconds, this.logThreadActivityFrequencyInSeconds, TimeUnit.SECONDS);
    }
}

