# PySNMP SMI module. Autogenerated from smidump -f python BGP4-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:13 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")

# Objects

bgp = ModuleIdentity((1, 3, 6, 1, 2, 1, 15)).setRevisions(("2006-01-11 00:00","1994-05-05 00:00","1991-10-26 18:39",))
if mibBuilder.loadTexts: bgp.setOrganization("IETF IDR Working Group")
if mibBuilder.loadTexts: bgp.setContactInfo("E-mail:  idr@ietf.org\n\nJeffrey Haas, Susan Hares  (Editors)\nNextHop Technologies\n825 Victors Way\nSuite 100\nAnn Arbor, MI 48108-2738\nTel: +1 734 222-1600\nFax: +1 734 222-1602\nE-mail: jhaas@nexthop.com\n        skh@nexthop.com")
if mibBuilder.loadTexts: bgp.setDescription("The MIB module for the BGP-4 protocol.\n\nCopyright (C) The Internet Society (2006).  This\nversion of this MIB module is part of RFC 4273;\nsee the RFC itself for full legal notices.")
bgpNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 15, 0))
bgpVersion = MibScalar((1, 3, 6, 1, 2, 1, 15, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpVersion.setDescription("Vector of supported BGP protocol version\nnumbers.  Each peer negotiates the version\nfrom this vector.  Versions are identified\nvia the string of bits contained within this\nobject.  The first octet contains bits 0 to\n7, the second octet contains bits 8 to 15,\nand so on, with the most significant bit\nreferring to the lowest bit number in the\noctet (e.g., the MSB of the first octet\nrefers to bit 0).  If a bit, i, is present\nand set, then the version (i+1) of the BGP\nis supported.")
bgpLocalAs = MibScalar((1, 3, 6, 1, 2, 1, 15, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpLocalAs.setDescription("The local autonomous system number.")
bgpPeerTable = MibTable((1, 3, 6, 1, 2, 1, 15, 3))
if mibBuilder.loadTexts: bgpPeerTable.setDescription("BGP peer table.  This table contains,\none entry per BGP peer, information about the\nconnections with BGP peers.")
bgpPeerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 15, 3, 1)).setIndexNames((0, "BGP4-MIB", "bgpPeerRemoteAddr"))
if mibBuilder.loadTexts: bgpPeerEntry.setDescription("Entry containing information about the\nconnection with a BGP peer.")
bgpPeerIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerIdentifier.setDescription("The BGP Identifier of this entry's BGP peer.\nThis entry MUST be 0.0.0.0 unless the\nbgpPeerState is in the openconfirm or the\nestablished state.")
bgpPeerState = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,5,4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("idle", 1), ("connect", 2), ("active", 3), ("opensent", 4), ("openconfirm", 5), ("established", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerState.setDescription("The BGP peer connection state.")
bgpPeerAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("stop", 1), ("start", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerAdminStatus.setDescription("The desired state of the BGP connection.\nA transition from 'stop' to 'start' will cause\nthe BGP Manual Start Event to be generated.\nA transition from 'start' to 'stop' will cause\nthe BGP Manual Stop Event to be generated.\nThis parameter can be used to restart BGP peer\nconnections.  Care should be used in providing\nwrite access to this object without adequate\nauthentication.")
bgpPeerNegotiatedVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerNegotiatedVersion.setDescription("The negotiated version of BGP running between\nthe two peers.\n\nThis entry MUST be zero (0) unless the\nbgpPeerState is in the openconfirm or the\n\n\n\nestablished state.\n\nNote that legal values for this object are\nbetween 0 and 255.")
bgpPeerLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 5), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerLocalAddr.setDescription("The local IP address of this entry's BGP\nconnection.")
bgpPeerLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerLocalPort.setDescription("The local port for the TCP connection between\nthe BGP peers.")
bgpPeerRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 7), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerRemoteAddr.setDescription("The remote IP address of this entry's BGP\npeer.")
bgpPeerRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerRemotePort.setDescription("The remote port for the TCP connection\nbetween the BGP peers.  Note that the\nobjects bgpPeerLocalAddr,\nbgpPeerLocalPort, bgpPeerRemoteAddr, and\nbgpPeerRemotePort provide the appropriate\nreference to the standard MIB TCP\nconnection table.")
bgpPeerRemoteAs = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerRemoteAs.setDescription("The remote autonomous system number received in\nthe BGP OPEN message.")
bgpPeerInUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerInUpdates.setDescription("The number of BGP UPDATE messages\nreceived on this connection.")
bgpPeerOutUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerOutUpdates.setDescription("The number of BGP UPDATE messages\ntransmitted on this connection.")
bgpPeerInTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerInTotalMessages.setDescription("The total number of messages received\nfrom the remote peer on this connection.")
bgpPeerOutTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerOutTotalMessages.setDescription("The total number of messages transmitted to\nthe remote peer on this connection.")
bgpPeerLastError = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 14), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerLastError.setDescription("The last error code and subcode seen by this\npeer on this connection.  If no error has\noccurred, this field is zero.  Otherwise, the\nfirst byte of this two byte OCTET STRING\ncontains the error code, and the second byte\ncontains the subcode.")
bgpPeerFsmEstablishedTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerFsmEstablishedTransitions.setDescription("The total number of times the BGP FSM\ntransitioned into the established state\nfor this peer.")
bgpPeerFsmEstablishedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerFsmEstablishedTime.setDescription("This timer indicates how long (in\nseconds) this peer has been in the\nestablished state or how long\nsince this peer was last in the\nestablished state.  It is set to zero when\na new peer is configured or when the router is\n\n\n\nbooted.")
bgpPeerConnectRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerConnectRetryInterval.setDescription("Time interval (in seconds) for the\nConnectRetry timer.  The suggested value\nfor this timer is 120 seconds.")
bgpPeerHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 18), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(3,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerHoldTime.setDescription("Time interval (in seconds) for the Hold\nTimer established with the peer.  The\nvalue of this object is calculated by this\nBGP speaker, using the smaller of the\nvalues in bgpPeerHoldTimeConfigured and the\nHold Time received in the OPEN message.\n\nThis value must be at least three seconds\nif it is not zero (0).\n\nIf the Hold Timer has not been established\nwith the peer this object MUST have a value\nof zero (0).\n\nIf the bgpPeerHoldTimeConfigured object has\na value of (0), then this object MUST have a\nvalue of (0).")
bgpPeerKeepAlive = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 21845))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerKeepAlive.setDescription("Time interval (in seconds) for the KeepAlive\ntimer established with the peer.  The value\nof this object is calculated by this BGP\nspeaker such that, when compared with\nbgpPeerHoldTime, it has the same proportion\nthat bgpPeerKeepAliveConfigured has,\ncompared with bgpPeerHoldTimeConfigured.\n\nIf the KeepAlive timer has not been established\nwith the peer, this object MUST have a value\nof zero (0).\n\nIf the of bgpPeerKeepAliveConfigured object\nhas a value of (0), then this object MUST have\na value of (0).")
bgpPeerHoldTimeConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 20), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(3,65535),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerHoldTimeConfigured.setDescription("Time interval (in seconds) for the Hold Time\nconfigured for this BGP speaker with this\npeer.  This value is placed in an OPEN\nmessage sent to this peer by this BGP\nspeaker, and is compared with the Hold\nTime field in an OPEN message received\nfrom the peer when determining the Hold\nTime (bgpPeerHoldTime) with the peer.\nThis value must not be less than three\nseconds if it is not zero (0).  If it is\nzero (0), the Hold Time is NOT to be\nestablished with the peer.  The suggested\nvalue for this timer is 90 seconds.")
bgpPeerKeepAliveConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 21), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 21845))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerKeepAliveConfigured.setDescription("Time interval (in seconds) for the\nKeepAlive timer configured for this BGP\nspeaker with this peer.  The value of this\nobject will only determine the\nKEEPALIVE messages' frequency relative to\nthe value specified in\nbgpPeerHoldTimeConfigured; the actual\ntime interval for the KEEPALIVE messages is\nindicated by bgpPeerKeepAlive.  A\nreasonable maximum value for this timer\nwould be one third of that of\nbgpPeerHoldTimeConfigured.\nIf the value of this object is zero (0),\nno periodical KEEPALIVE messages are sent\nto the peer after the BGP connection has\nbeen established.  The suggested value for\nthis timer is 30 seconds.")
bgpPeerMinASOriginationInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 22), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerMinASOriginationInterval.setDescription("Time interval (in seconds) for the\nMinASOriginationInterval timer.\nThe suggested value for this timer is 15\nseconds.")
bgpPeerMinRouteAdvertisementInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 23), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bgpPeerMinRouteAdvertisementInterval.setDescription("Time interval (in seconds) for the\nMinRouteAdvertisementInterval timer.\nThe suggested value for this timer is 30\nseconds for EBGP connections and 5\nseconds for IBGP connections.")
bgpPeerInUpdateElapsedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 3, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPeerInUpdateElapsedTime.setDescription("Elapsed time (in seconds) since the last BGP\nUPDATE message was received from the peer.\nEach time bgpPeerInUpdates is incremented,\nthe value of this object is set to zero (0).")
bgpIdentifier = MibScalar((1, 3, 6, 1, 2, 1, 15, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpIdentifier.setDescription("The BGP Identifier of the local system.")
bgpRcvdPathAttrTable = MibTable((1, 3, 6, 1, 2, 1, 15, 5))
if mibBuilder.loadTexts: bgpRcvdPathAttrTable.setDescription("The BGP Received Path Attribute Table\ncontains information about paths to\n\n\n\ndestination networks, received from all\npeers running BGP version 3 or less.")
bgpPathAttrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 15, 5, 1)).setIndexNames((0, "BGP4-MIB", "bgpPathAttrDestNetwork"), (0, "BGP4-MIB", "bgpPathAttrPeer"))
if mibBuilder.loadTexts: bgpPathAttrEntry.setDescription("Information about a path to a network.")
bgpPathAttrPeer = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrPeer.setDescription("The IP address of the peer where the path\ninformation was learned.")
bgpPathAttrDestNetwork = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrDestNetwork.setDescription("The address of the destination network.")
bgpPathAttrOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("igp", 1), ("egp", 2), ("incomplete", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrOrigin.setDescription("The ultimate origin of the path information.")
bgpPathAttrASPath = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrASPath.setDescription("The set of ASes that must be traversed to reach\nthe network.  This object is probably best\nrepresented as SEQUENCE OF INTEGER.  For SMI\ncompatibility, though, it is represented as\nOCTET STRING.  Each AS is represented as a pair\nof octets according to the following algorithm:\n\n   first-byte-of-pair = ASNumber / 256;\n   second-byte-of-pair = ASNumber & 255;")
bgpPathAttrNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 5), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrNextHop.setDescription("The address of the border router that should\nbe used for the destination network.")
bgpPathAttrInterASMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 5, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgpPathAttrInterASMetric.setDescription("The optional inter-AS metric.  If this\nattribute has not been provided for this route,\nthe value for this object is 0.")
bgp4PathAttrTable = MibTable((1, 3, 6, 1, 2, 1, 15, 6))
if mibBuilder.loadTexts: bgp4PathAttrTable.setDescription("The BGP-4 Received Path Attribute Table\ncontains information about paths to\ndestination networks, received from all\nBGP4 peers.")
bgp4PathAttrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 15, 6, 1)).setIndexNames((0, "BGP4-MIB", "bgp4PathAttrIpAddrPrefix"), (0, "BGP4-MIB", "bgp4PathAttrIpAddrPrefixLen"), (0, "BGP4-MIB", "bgp4PathAttrPeer"))
if mibBuilder.loadTexts: bgp4PathAttrEntry.setDescription("Information about a path to a network.")
bgp4PathAttrPeer = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrPeer.setDescription("The IP address of the peer where the path\ninformation was learned.")
bgp4PathAttrIpAddrPrefixLen = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrIpAddrPrefixLen.setDescription("Length in bits of the IP address prefix in\nthe Network Layer Reachability\nInformation field.")
bgp4PathAttrIpAddrPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrIpAddrPrefix.setDescription("An IP address prefix in the Network Layer\nReachability Information field.  This object\n\n\n\nis an IP address containing the prefix with\nlength specified by\nbgp4PathAttrIpAddrPrefixLen.\nAny bits beyond the length specified by\nbgp4PathAttrIpAddrPrefixLen are zeroed.")
bgp4PathAttrOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("igp", 1), ("egp", 2), ("incomplete", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrOrigin.setDescription("The ultimate origin of the path\ninformation.")
bgp4PathAttrASPathSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 5), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrASPathSegment.setDescription("The sequence of AS path segments.  Each AS\npath segment is represented by a triple\n<type, length, value>.\n\nThe type is a 1-octet field that has two\npossible values:\n    1      AS_SET: unordered set of ASes that a\n                route in the UPDATE message\n                has traversed\n\n    2      AS_SEQUENCE: ordered set of ASes that\n                a route in the UPDATE message\n                has traversed.\n\nThe length is a 1-octet field containing the\n\n\n\nnumber of ASes in the value field.\n\nThe value field contains one or more AS\nnumbers.  Each AS is represented in the octet\nstring as a pair of octets according to the\nfollowing algorithm:\n\n   first-byte-of-pair = ASNumber / 256;\n   second-byte-of-pair = ASNumber & 255;\n\nKnown Issues:\no BGP Confederations will result in\n  a type of either 3 or 4.\no An AS Path may be longer than 255 octets.\n  This may result in this object containing\n  a truncated AS Path.")
bgp4PathAttrNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 6), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrNextHop.setDescription("The address of the border router that\nshould be used for the destination\nnetwork.  This address is the NEXT_HOP\naddress received in the UPDATE packet.")
bgp4PathAttrMultiExitDisc = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrMultiExitDisc.setDescription("This metric is used to discriminate\nbetween multiple exit points to an\nadjacent autonomous system.  A value of -1\nindicates the absence of this attribute.\n\nKnown Issues:\no The BGP-4 specification uses an\n  unsigned 32 bit number.  Thus, this\n\n\n\n  object cannot represent the full\n  range of the protocol.")
bgp4PathAttrLocalPref = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrLocalPref.setDescription("The originating BGP4 speaker's degree of\npreference for an advertised route.  A\nvalue of -1 indicates the absence of this\nattribute.\n\nKnown Issues:\no The BGP-4 specification uses an\n  unsigned 32 bit number and thus this\n  object cannot represent the full\n  range of the protocol.")
bgp4PathAttrAtomicAggregate = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("lessSpecificRouteNotSelected", 1), ("lessSpecificRouteSelected", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrAtomicAggregate.setDescription("If the ATOMIC_AGGREGATE attribute is present\nin the Path Attributes then this object MUST\nhave a value of 'lessSpecificRouteNotSelected'.\n\nIf the ATOMIC_AGGREGATE attribute is missing\nin the Path Attributes then this object MUST\nhave a value of 'lessSpecificRouteSelected'.\n\nNote that ATOMIC_AGGREGATE is now a primarily\ninformational attribute.")
bgp4PathAttrAggregatorAS = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrAggregatorAS.setDescription("The AS number of the last BGP4 speaker that\nperformed route aggregation.  A value of\nzero (0) indicates the absence of this\nattribute.\n\nNote that propagation of AS of zero is illegal\nin the Internet.")
bgp4PathAttrAggregatorAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 11), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrAggregatorAddr.setDescription("The IP address of the last BGP4 speaker\nthat performed route aggregation.  A\nvalue of 0.0.0.0 indicates the absence\nof this attribute.")
bgp4PathAttrCalcLocalPref = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrCalcLocalPref.setDescription("The degree of preference calculated by the\nreceiving BGP4 speaker for an advertised\nroute.  A value of -1 indicates the\nabsence of this attribute.\n\nKnown Issues:\no The BGP-4 specification uses an\n  unsigned 32 bit number and thus this\n  object cannot represent the full\n  range of the protocol.")
bgp4PathAttrBest = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("false", 1), ("true", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrBest.setDescription("An indication of whether this route\nwas chosen as the best BGP4 route for this\ndestination.")
bgp4PathAttrUnknown = MibTableColumn((1, 3, 6, 1, 2, 1, 15, 6, 1, 14), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bgp4PathAttrUnknown.setDescription("One or more path attributes not understood by\nthis BGP4 speaker.\n\nPath attributes are recorded in the Update Path\nattribute format of type, length, value.\n\nSize zero (0) indicates the absence of such\nattributes.\n\nOctets beyond the maximum size, if any, are not\nrecorded by this object.\n\nKnown Issues:\no Attributes understood by this speaker, but not\n  represented in this MIB, are unavailable to\n  the agent.")
bgpTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 15, 7))
bgp4MIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 15, 8))
bgp4MIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 15, 8, 1))
bgp4MIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 15, 8, 2))

# Augmentions

# Notifications

bgpBackwardTransition = NotificationType((1, 3, 6, 1, 2, 1, 15, 7, 2)).setObjects(("BGP4-MIB", "bgpPeerState"), ("BGP4-MIB", "bgpPeerLastError"), )
bgpEstablishedNotification = NotificationType((1, 3, 6, 1, 2, 1, 15, 0, 1)).setObjects(("BGP4-MIB", "bgpPeerRemoteAddr"), ("BGP4-MIB", "bgpPeerState"), ("BGP4-MIB", "bgpPeerLastError"), )
bgpEstablished = NotificationType((1, 3, 6, 1, 2, 1, 15, 7, 1)).setObjects(("BGP4-MIB", "bgpPeerState"), ("BGP4-MIB", "bgpPeerLastError"), )
bgpBackwardTransNotification = NotificationType((1, 3, 6, 1, 2, 1, 15, 0, 2)).setObjects(("BGP4-MIB", "bgpPeerRemoteAddr"), ("BGP4-MIB", "bgpPeerState"), ("BGP4-MIB", "bgpPeerLastError"), )

# Groups

bgp4MIBPeerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 2)).setObjects(("BGP4-MIB", "bgpPeerKeepAlive"), ("BGP4-MIB", "bgpPeerOutUpdates"), ("BGP4-MIB", "bgpPeerRemoteAs"), ("BGP4-MIB", "bgpPeerLastError"), ("BGP4-MIB", "bgpPeerMinRouteAdvertisementInterval"), ("BGP4-MIB", "bgpPeerMinASOriginationInterval"), ("BGP4-MIB", "bgpPeerLocalPort"), ("BGP4-MIB", "bgpPeerInTotalMessages"), ("BGP4-MIB", "bgpPeerRemotePort"), ("BGP4-MIB", "bgpPeerConnectRetryInterval"), ("BGP4-MIB", "bgpPeerState"), ("BGP4-MIB", "bgpPeerInUpdateElapsedTime"), ("BGP4-MIB", "bgpPeerInUpdates"), ("BGP4-MIB", "bgpPeerAdminStatus"), ("BGP4-MIB", "bgpPeerKeepAliveConfigured"), ("BGP4-MIB", "bgpPeerOutTotalMessages"), ("BGP4-MIB", "bgpPeerHoldTime"), ("BGP4-MIB", "bgpPeerFsmEstablishedTransitions"), ("BGP4-MIB", "bgpPeerLocalAddr"), ("BGP4-MIB", "bgpPeerHoldTimeConfigured"), ("BGP4-MIB", "bgpPeerRemoteAddr"), ("BGP4-MIB", "bgpPeerIdentifier"), ("BGP4-MIB", "bgpPeerFsmEstablishedTime"), ("BGP4-MIB", "bgpPeerNegotiatedVersion"), )
bgp4MIBTrapGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 5)).setObjects(("BGP4-MIB", "bgpBackwardTransition"), ("BGP4-MIB", "bgpEstablished"), )
bgpRcvdPathAttrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 3)).setObjects(("BGP4-MIB", "bgpPathAttrInterASMetric"), ("BGP4-MIB", "bgpPathAttrPeer"), ("BGP4-MIB", "bgpPathAttrOrigin"), ("BGP4-MIB", "bgpPathAttrDestNetwork"), ("BGP4-MIB", "bgpPathAttrASPath"), ("BGP4-MIB", "bgpPathAttrNextHop"), )
bgp4MIBNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 6)).setObjects(("BGP4-MIB", "bgpEstablishedNotification"), ("BGP4-MIB", "bgpBackwardTransNotification"), )
bgp4MIBPathAttrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 4)).setObjects(("BGP4-MIB", "bgp4PathAttrMultiExitDisc"), ("BGP4-MIB", "bgp4PathAttrAtomicAggregate"), ("BGP4-MIB", "bgp4PathAttrAggregatorAddr"), ("BGP4-MIB", "bgp4PathAttrIpAddrPrefixLen"), ("BGP4-MIB", "bgp4PathAttrBest"), ("BGP4-MIB", "bgp4PathAttrOrigin"), ("BGP4-MIB", "bgp4PathAttrCalcLocalPref"), ("BGP4-MIB", "bgp4PathAttrPeer"), ("BGP4-MIB", "bgp4PathAttrUnknown"), ("BGP4-MIB", "bgp4PathAttrIpAddrPrefix"), ("BGP4-MIB", "bgp4PathAttrNextHop"), ("BGP4-MIB", "bgp4PathAttrLocalPref"), ("BGP4-MIB", "bgp4PathAttrASPathSegment"), ("BGP4-MIB", "bgp4PathAttrAggregatorAS"), )
bgp4MIBGlobalsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 15, 8, 2, 1)).setObjects(("BGP4-MIB", "bgpVersion"), ("BGP4-MIB", "bgpLocalAs"), ("BGP4-MIB", "bgpIdentifier"), )

# Exports

# Module identity
mibBuilder.exportSymbols("BGP4-MIB", PYSNMP_MODULE_ID=bgp)

# Objects
mibBuilder.exportSymbols("BGP4-MIB", bgp=bgp, bgpNotification=bgpNotification, bgpVersion=bgpVersion, bgpLocalAs=bgpLocalAs, bgpPeerTable=bgpPeerTable, bgpPeerEntry=bgpPeerEntry, bgpPeerIdentifier=bgpPeerIdentifier, bgpPeerState=bgpPeerState, bgpPeerAdminStatus=bgpPeerAdminStatus, bgpPeerNegotiatedVersion=bgpPeerNegotiatedVersion, bgpPeerLocalAddr=bgpPeerLocalAddr, bgpPeerLocalPort=bgpPeerLocalPort, bgpPeerRemoteAddr=bgpPeerRemoteAddr, bgpPeerRemotePort=bgpPeerRemotePort, bgpPeerRemoteAs=bgpPeerRemoteAs, bgpPeerInUpdates=bgpPeerInUpdates, bgpPeerOutUpdates=bgpPeerOutUpdates, bgpPeerInTotalMessages=bgpPeerInTotalMessages, bgpPeerOutTotalMessages=bgpPeerOutTotalMessages, bgpPeerLastError=bgpPeerLastError, bgpPeerFsmEstablishedTransitions=bgpPeerFsmEstablishedTransitions, bgpPeerFsmEstablishedTime=bgpPeerFsmEstablishedTime, bgpPeerConnectRetryInterval=bgpPeerConnectRetryInterval, bgpPeerHoldTime=bgpPeerHoldTime, bgpPeerKeepAlive=bgpPeerKeepAlive, bgpPeerHoldTimeConfigured=bgpPeerHoldTimeConfigured, bgpPeerKeepAliveConfigured=bgpPeerKeepAliveConfigured, bgpPeerMinASOriginationInterval=bgpPeerMinASOriginationInterval, bgpPeerMinRouteAdvertisementInterval=bgpPeerMinRouteAdvertisementInterval, bgpPeerInUpdateElapsedTime=bgpPeerInUpdateElapsedTime, bgpIdentifier=bgpIdentifier, bgpRcvdPathAttrTable=bgpRcvdPathAttrTable, bgpPathAttrEntry=bgpPathAttrEntry, bgpPathAttrPeer=bgpPathAttrPeer, bgpPathAttrDestNetwork=bgpPathAttrDestNetwork, bgpPathAttrOrigin=bgpPathAttrOrigin, bgpPathAttrASPath=bgpPathAttrASPath, bgpPathAttrNextHop=bgpPathAttrNextHop, bgpPathAttrInterASMetric=bgpPathAttrInterASMetric, bgp4PathAttrTable=bgp4PathAttrTable, bgp4PathAttrEntry=bgp4PathAttrEntry, bgp4PathAttrPeer=bgp4PathAttrPeer, bgp4PathAttrIpAddrPrefixLen=bgp4PathAttrIpAddrPrefixLen, bgp4PathAttrIpAddrPrefix=bgp4PathAttrIpAddrPrefix, bgp4PathAttrOrigin=bgp4PathAttrOrigin, bgp4PathAttrASPathSegment=bgp4PathAttrASPathSegment, bgp4PathAttrNextHop=bgp4PathAttrNextHop, bgp4PathAttrMultiExitDisc=bgp4PathAttrMultiExitDisc, bgp4PathAttrLocalPref=bgp4PathAttrLocalPref, bgp4PathAttrAtomicAggregate=bgp4PathAttrAtomicAggregate, bgp4PathAttrAggregatorAS=bgp4PathAttrAggregatorAS, bgp4PathAttrAggregatorAddr=bgp4PathAttrAggregatorAddr, bgp4PathAttrCalcLocalPref=bgp4PathAttrCalcLocalPref, bgp4PathAttrBest=bgp4PathAttrBest, bgp4PathAttrUnknown=bgp4PathAttrUnknown, bgpTraps=bgpTraps, bgp4MIBConformance=bgp4MIBConformance, bgp4MIBCompliances=bgp4MIBCompliances, bgp4MIBGroups=bgp4MIBGroups)

# Notifications
mibBuilder.exportSymbols("BGP4-MIB", bgpBackwardTransition=bgpBackwardTransition, bgpEstablishedNotification=bgpEstablishedNotification, bgpEstablished=bgpEstablished, bgpBackwardTransNotification=bgpBackwardTransNotification)

# Groups
mibBuilder.exportSymbols("BGP4-MIB", bgp4MIBPeerGroup=bgp4MIBPeerGroup, bgp4MIBTrapGroup=bgp4MIBTrapGroup, bgpRcvdPathAttrGroup=bgpRcvdPathAttrGroup, bgp4MIBNotificationGroup=bgp4MIBNotificationGroup, bgp4MIBPathAttrGroup=bgp4MIBPathAttrGroup, bgp4MIBGlobalsGroup=bgp4MIBGlobalsGroup)
