# PySNMP SMI module. Autogenerated from smidump -f python DISMAN-PING-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:16 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, RowStatus, StorageType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "StorageType", "TextualConvention", "TruthValue")

# Types

class OperationResponseStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,8,2,3,5,10,6,11,4,9,7,)
    namedValues = namedval.NamedValues(("responseReceived", 1), ("unableToResolveDnsName", 10), ("invalidHostAddress", 11), ("unknown", 2), ("internalError", 3), ("requestTimedOut", 4), ("unknownDestinationAddress", 5), ("noRouteToTarget", 6), ("interfaceInactiveToTarget", 7), ("arpFailure", 8), ("maxConcurrentLimitReached", 9), )
    pass


# Objects

pingMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 80)).setRevisions(("2006-06-13 00:00","2000-09-21 00:00",))
if mibBuilder.loadTexts: pingMIB.setOrganization("IETF Distributed Management Working Group")
if mibBuilder.loadTexts: pingMIB.setContactInfo("Juergen Quittek\n\nNEC Europe Ltd.\nNetwork Laboratories\nKurfuersten-Anlage 36\n69115 Heidelberg\nGermany\n\nPhone: +49 6221 4342-115\n\n\n\nEmail: quittek@netlab.nec.de")
if mibBuilder.loadTexts: pingMIB.setDescription("The Ping MIB (DISMAN-PING-MIB) provides the capability of\ncontrolling the use of the ping function at a remote\nhost.\n\nCopyright (C) The Internet Society (2006).  This version of\nthis MIB module is part of RFC 4560; see the RFC itself for\nfull legal notices.")
pingNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 0))
pingObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 1))
pingMaxConcurrentRequests = MibScalar((1, 3, 6, 1, 2, 1, 80, 1, 1), Unsigned32().clone(10)).setMaxAccess("readwrite").setUnits("requests")
if mibBuilder.loadTexts: pingMaxConcurrentRequests.setDescription("The maximum number of concurrent active ping requests\nthat are allowed within an agent implementation.  A value\nof 0 for this object implies that there is no limit for\nthe number of concurrent active requests in effect.\n\n\n\n\nThe limit applies only to new requests being activated.\nWhen a new value is set, the agent will continue processing\nall the requests already active, even if their number\nexceeds the limit just imposed.")
pingCtlTable = MibTable((1, 3, 6, 1, 2, 1, 80, 1, 2))
if mibBuilder.loadTexts: pingCtlTable.setDescription("Defines the ping Control Table for providing, via SNMP,\nthe capability of performing ping operations at\na remote host.  The results of these operations are\nstored in the pingResultsTable and the\npingProbeHistoryTable.")
pingCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 80, 1, 2, 1)).setIndexNames((0, "DISMAN-PING-MIB", "pingCtlOwnerIndex"), (0, "DISMAN-PING-MIB", "pingCtlTestName"))
if mibBuilder.loadTexts: pingCtlEntry.setDescription("Defines an entry in the pingCtlTable.  The first index\nelement, pingCtlOwnerIndex, is of type SnmpAdminString,\na textual convention that allows for use of the SNMPv3\nView-Based Access Control Model (RFC 3415, VACM)\nand that allows a management application to identify its\nentries.  The second index, pingCtlTestName (also an\nSnmpAdminString), enables the same management\napplication to have multiple outstanding requests.")
pingCtlOwnerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pingCtlOwnerIndex.setDescription("To facilitate the provisioning of access control by a\nsecurity administrator using the View-Based Access\nControl Model (RFC 2575, VACM) for tables in which\nmultiple users may need to create or\nmodify entries independently, the initial index is used\nas an 'owner index'.  Such an initial index has a syntax\nof SnmpAdminString and can thus be trivially mapped to a\nsecurityName or groupName defined in VACM, in\naccordance with a security policy.\n\nWhen used in conjunction with such a security policy, all\nentries in the table belonging to a particular user (or\ngroup) will have the same value for this initial index.\nFor a given user's entries in a particular table, the\nobject identifiers for the information in these entries\nwill have the same subidentifiers (except for the 'column'\nsubidentifier) up to the end of the encoded owner index.\nTo configure VACM to permit access to this portion of the\ntable, one would create vacmViewTreeFamilyTable entries\nwith the value of vacmViewTreeFamilySubtree including\nthe owner index portion, and vacmViewTreeFamilyMask\n'wildcarding' the column subidentifier.  More elaborate\nconfigurations are possible.")
pingCtlTestName = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pingCtlTestName.setDescription("The name of the ping test.  This is locally unique, within\nthe scope of a pingCtlOwnerIndex.")
pingCtlTargetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 3), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTargetAddressType.setDescription("Specifies the type of host address to be used at a remote\nhost for performing a ping operation.")
pingCtlTargetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 4), InetAddress().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTargetAddress.setDescription("Specifies the host address to be used at a remote host for\nperforming a ping operation.  The host address type is\ndetermined by the value of the corresponding\npingCtlTargetAddressType.\n\nA value for this object MUST be set prior to transitioning\nits corresponding pingCtlEntry to active(1) via\npingCtlRowStatus.")
pingCtlDataSize = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65507)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlDataSize.setDescription("Specifies the size of the data portion to be\ntransmitted in a ping operation, in octets.  Whether this\nvalue can be applied depends on the selected\nimplementation method for performing a ping operation,\nindicated by pingCtlType in the same conceptual row.\nIf the method used allows applying the value contained\n\n\n\nin this object, then it MUST be applied.  If the specified\nsize is not appropriate for the chosen ping method, the\nimplementation SHOULD use whatever size (appropriate to\nthe method) is closest to the specified size.\n\nThe maximum value for this object was computed by\nsubtracting the smallest possible IP header size of\n20 octets (IPv4 header with no options) and the UDP\nheader size of 8 octets from the maximum IP packet size.\nAn IP packet has a maximum size of 65535 octets\n(excluding IPv6 Jumbograms).")
pingCtlTimeOut = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 60)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTimeOut.setDescription("Specifies the time-out value, in seconds, for a\nremote ping operation.")
pingCtlProbeCount = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 15)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlProbeCount.setDescription("Specifies the number of times to perform a ping\noperation at a remote host as part of a single ping test.")
pingCtlAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlAdminStatus.setDescription("Reflects the desired state that a pingCtlEntry should be\nin:\n\n\n\n\n   enabled(1)  - Attempt to activate the test as defined by\n                 this pingCtlEntry.\n   disabled(2) - Deactivate the test as defined by this\n                 pingCtlEntry.\n\nRefer to the corresponding pingResultsOperStatus to\ndetermine the operational state of the test defined by\nthis entry.")
pingCtlDataFill = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 1024)).clone('\x00')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlDataFill.setDescription("The content of this object is used together with the\ncorresponding pingCtlDataSize value to determine how to\nfill the data portion of a probe packet.  The option of\nselecting a data fill pattern can be useful when links\nare compressed or have data pattern sensitivities.  The\ncontents of pingCtlDataFill should be repeated in a ping\npacket when the size of the data portion of the ping\npacket is greater than the size of pingCtlDataFill.")
pingCtlFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 10), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlFrequency.setDescription("The number of seconds to wait before repeating a ping test\nas defined by the value of the various objects in the\ncorresponding row.\n\nA single ping test consists of a series of ping probes.\nThe number of probes is determined by the value of the\ncorresponding pingCtlProbeCount object.  After a single\ntest is completed the number of seconds as defined by the\nvalue of pingCtlFrequency MUST elapse before the\nnext ping test is started.\n\nA value of 0 for this object implies that the test\nas defined by the corresponding entry will not be\nrepeated.")
pingCtlMaxRows = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 11), Unsigned32().clone(50)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlMaxRows.setDescription("The maximum number of corresponding entries allowed\nin the pingProbeHistoryTable.  An implementation of this\nMIB will remove the oldest corresponding entry in the\npingProbeHistoryTable to allow the addition of an\nnew entry once the number of corresponding rows in the\npingProbeHistoryTable reaches this value.\n\nOld entries are not removed when a new test is\nstarted.  Entries are added to the pingProbeHistoryTable\nuntil pingCtlMaxRows is reached before entries begin to\nbe removed.\n\nA value of 0 for this object disables creation of\npingProbeHistoryTable entries.")
pingCtlStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 12), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent' need not\nallow write-access to any columnar objects in the row.")
pingCtlTrapGeneration = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 13), Bits().subtype(namedValues=namedval.NamedValues(("probeFailure", 0), ("testFailure", 1), ("testCompletion", 2), )).clone(())).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTrapGeneration.setDescription("The value of this object determines when and whether\nto generate a notification for this entry:\n\n\n\nprobeFailure(0)   - Generate a pingProbeFailed\n    notification subject to the value of\n    pingCtlTrapProbeFailureFilter.  The object\n    pingCtlTrapProbeFailureFilter can be used\n    to specify the number of consecutive probe\n    failures that are required before a\n    pingProbeFailed notification can be generated.\ntestFailure(1)    - Generate a pingTestFailed\n    notification.  In this instance the object\n    pingCtlTrapTestFailureFilter can be used to\n    determine the number of probe failures that\n    signal when a test fails.\ntestCompletion(2) - Generate a pingTestCompleted\n    notification.\n\nBy default, no bits are set, indicating that\nnone of the above options is selected.")
pingCtlTrapProbeFailureFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 15)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTrapProbeFailureFilter.setDescription("The value of this object is used to determine when\nto generate a pingProbeFailed NOTIFICATION.\n\nSetting BIT probeFailure(0) of object\npingCtlTrapGeneration to '1' implies that a\npingProbeFailed NOTIFICATION is generated only when\n\na number of consecutive ping probes equal to the\nvalue of pingCtlTrapProbeFailureFilter fail within\na given ping test.  After triggering the notification,\nthe probe failure counter is reset to zero.")
pingCtlTrapTestFailureFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 15)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlTrapTestFailureFilter.setDescription("The value of this object is used to determine when\nto generate a pingTestFailed NOTIFICATION.\n\nSetting BIT testFailure(1) of object\n\n\n\npingCtlTrapGeneration to '1' implies that a\npingTestFailed NOTIFICATION is generated only when\na number of consecutive ping tests equal to the\nvalue of pingCtlTrapProbeFailureFilter fail.\nAfter triggering the notification, the test failure\ncounter is reset to zero.")
pingCtlType = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 16), ObjectIdentifier().clone((1, 3, 6, 1, 2, 1, 80, 3, 1))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlType.setDescription("The value of this object is used either to report or\nto select the implementation method to be used for\ncalculating a ping response time.  The value of this\nobject MAY be selected from pingImplementationTypeDomains.\n\nAdditional implementation types SHOULD be allocated as\nrequired by implementers of the DISMAN-PING-MIB under\ntheir enterprise-specific registration point and not\nbeneath pingImplementationTypeDomains.")
pingCtlDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 17), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlDescr.setDescription("The purpose of this object is to provide a\ndescriptive name of the remote ping test.")
pingCtlSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 18), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlSourceAddressType.setDescription("Specifies the type of the source address,\npingCtlSourceAddress, to be used at a remote host\nwhen a ping operation is performed.")
pingCtlSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 19), InetAddress().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlSourceAddress.setDescription("Use the specified IP address (which must be given in\nnumeric form, not as a hostname) as the source address\nin outgoing probe packets.  On hosts with more than one\nIP address, this option can be used to select the address\nto be used.  If the IP address is not one of this\nmachine's interface addresses, an error is returned and\nnothing is sent.  A zero-length octet string value for\nthis object disables source address specification.\n\nThe address type (InetAddressType) that relates to\nthis object is specified by the corresponding value\nof pingCtlSourceAddressType.")
pingCtlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 20), InterfaceIndexOrZero().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlIfIndex.setDescription("Setting this object to an interface's ifIndex prior\nto starting a remote ping operation directs\nthe ping probes to be transmitted over the\nspecified interface.  A value of zero for this object\nmeans that this option is not enabled.")
pingCtlByPassRouteTable = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 21), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlByPassRouteTable.setDescription("The purpose of this object is to enable optional\nbypassing the route table.  If enabled, the remote\nhost will bypass the normal routing tables and send\ndirectly to a host on an attached network.  If the\nhost is not on a directly attached network, an\nerror is returned.  This option can be used to perform\nthe ping operation to a local host through an\ninterface that has no route defined (e.g., after the\ninterface was dropped by the routing daemon at the host).")
pingCtlDSField = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 22), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlDSField.setDescription("Specifies the value to store in the Type of Service\n(TOS) octet in the IPv4 header or in the Traffic\nClass octet in the IPv6 header, respectively, of the\nIP packet used to encapsulate the ping probe.\n\nThe octet to be set in the IP header contains the\nDifferentiated Services (DS) Field in the six most\nsignificant bits.\n\nThis option can be used to determine what effect an\nexplicit DS Field setting has on a ping response.\nNot all values are legal or meaningful.  A value of 0\nmeans that the function represented by this option is\nnot supported.  DS Field usage is often not supported\nby IP implementations, and not all values are supported.\nRefer to RFC 2474 and RFC 3260 for guidance on usage of\nthis field.")
pingCtlRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 2, 1, 23), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pingCtlRowStatus.setDescription("This object allows entries to be created and deleted\nin the pingCtlTable.  Deletion of an entry in this\ntable results in the deletion of all corresponding (same\npingCtlOwnerIndex and pingCtlTestName index values)\npingResultsTable and pingProbeHistoryTable entries.\n\nA value MUST be specified for pingCtlTargetAddress\nprior to acceptance of a transition to active(1) state.\n\nWhen a value for pingCtlTargetAddress is set,\n\n\n\nthe value of object pingCtlRowStatus changes\nfrom notReady(3) to notInService(2).\n\nActivation of a remote ping operation is controlled\nvia pingCtlAdminStatus, not by changing\nthis object's value to active(1).\n\nTransitions in and out of active(1) state are not\nallowed while an entry's pingResultsOperStatus is\nactive(1), with the exception that deletion of\nan entry in this table by setting its RowStatus\nobject to destroy(6) will stop an active\nping operation.\n\nThe operational state of a ping operation\ncan be determined by examination of its\npingResultsOperStatus object.")
pingResultsTable = MibTable((1, 3, 6, 1, 2, 1, 80, 1, 3))
if mibBuilder.loadTexts: pingResultsTable.setDescription("Defines the Ping Results Table for providing\nthe capability of performing ping operations at\na remote host.  The results of these operations are\nstored in the pingResultsTable and the pingProbeHistoryTable.\n\nAn entry is added to the pingResultsTable when an\npingCtlEntry is started by successful transition\nof its pingCtlAdminStatus object to enabled(1).\n\nIf the object pingCtlAdminStatus already has the value\nenabled(1), and if the corresponding pingResultsOperStatus\nobject has the value completed(3), then successfully writing\nenabled(1) to object pingCtlAdminStatus re-initializes the\nalready existing entry in the pingResultsTable.  The values\nof objects in the re-initialized entry are the same as the\nvalues of objects in a new entry would be.\n\nAn entry is removed from the pingResultsTable when\nits corresponding pingCtlEntry is deleted.")
pingResultsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 80, 1, 3, 1)).setIndexNames((0, "DISMAN-PING-MIB", "pingCtlOwnerIndex"), (0, "DISMAN-PING-MIB", "pingCtlTestName"))
if mibBuilder.loadTexts: pingResultsEntry.setDescription("Defines an entry in the pingResultsTable.  The\npingResultsTable has the same indexing as the\npingCtlTable so that a pingResultsEntry\ncorresponds to the pingCtlEntry that caused it to\nbe created.")
pingResultsOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("completed", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsOperStatus.setDescription("Reflects the operational state of a pingCtlEntry:\n\nenabled(1)    - Test is active.\ndisabled(2)   - Test has stopped.\ncompleted(3)  - Test is completed.")
pingResultsIpTargetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 2), InetAddressType().clone('unknown')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsIpTargetAddressType.setDescription("This object indicates the type of address stored\nin the corresponding pingResultsIpTargetAddress\nobject.")
pingResultsIpTargetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 3), InetAddress().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsIpTargetAddress.setDescription("This object reports the IP address associated\nwith a pingCtlTargetAddress value when the destination\naddress is specified as a DNS name.  The value of\nthis object should be a zero-length octet string\nwhen a DNS name is not specified or when a\nspecified DNS name fails to resolve.\n\nThe address type (InetAddressType) that relates to\nthis object is specified by the corresponding value\nof pingResultsIpTargetAddressType.")
pingResultsMinRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsMinRtt.setDescription("The minimum ping round-trip-time (RTT) received.  A value\nof 0 for this object implies that no RTT has been received.")
pingResultsMaxRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsMaxRtt.setDescription("The maximum ping round-trip-time (RTT) received.  A value\nof 0 for this object implies that no RTT has been received.")
pingResultsAverageRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsAverageRtt.setDescription("The current average ping round-trip-time (RTT).")
pingResultsProbeResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsProbeResponses.setDescription("Number of responses received for the corresponding\npingCtlEntry and pingResultsEntry.  The value of this object\nMUST be reported as 0 when no probe responses have been\nreceived.")
pingResultsSentProbes = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsSentProbes.setDescription("The value of this object reflects the number of probes sent\nfor the corresponding pingCtlEntry and pingResultsEntry.\nThe value of this object MUST be reported as 0 when no probes\nhave been sent.")
pingResultsRttSumOfSquares = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsRttSumOfSquares.setDescription("This object contains the sum of the squares for all ping\nresponses received.  Its purpose is to enable standard\ndeviation calculation.  The value of this object MUST\nbe reported as 0 when no ping responses have been\nreceived.")
pingResultsLastGoodProbe = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 3, 1, 10), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingResultsLastGoodProbe.setDescription("Date and time when the last response was received for\na probe.")
pingProbeHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 80, 1, 4))
if mibBuilder.loadTexts: pingProbeHistoryTable.setDescription("Defines a table for storing the results of ping\noperations.  The number of entries in this table is\nlimited per entry in the pingCtlTable by the value\nof the corresponding pingCtlMaxRows object.\n\nAn entry in this table is created when the result of\na ping probe is determined.  The initial 2 instance\nidentifier index values identify the pingCtlEntry\nthat a probe result (pingProbeHistoryEntry) belongs\nto.  An entry is removed from this table when\nits corresponding pingCtlEntry is deleted.\n\nAn implementation of this MIB will remove the oldest\nentry in the pingProbeHistoryTable of the\ncorresponding entry in the pingCtlTable to allow\nthe addition of an new entry once the number of rows\nin the pingProbeHistoryTable reaches the value\nspecified by pingCtlMaxRows for the corresponding\nentry in the pingCtlTable.")
pingProbeHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 80, 1, 4, 1)).setIndexNames((0, "DISMAN-PING-MIB", "pingCtlOwnerIndex"), (0, "DISMAN-PING-MIB", "pingCtlTestName"), (0, "DISMAN-PING-MIB", "pingProbeHistoryIndex"))
if mibBuilder.loadTexts: pingProbeHistoryEntry.setDescription("Defines an entry in the pingProbeHistoryTable.\nThe first two index elements identify the\npingCtlEntry that a pingProbeHistoryEntry belongs\nto.  The third index element selects a single\nprobe result.")
pingProbeHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pingProbeHistoryIndex.setDescription("An entry in this table is created when the result of\na ping probe is determined.  The initial 2 instance\nidentifier index values identify the pingCtlEntry\nthat a probe result (pingProbeHistoryEntry) belongs\nto.\n\nAn implementation MUST start assigning\npingProbeHistoryIndex values at 1 and wrap after\nexceeding the maximum possible value as defined by\nthe limit of this object ('ffffffff'h).")
pingProbeHistoryResponse = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 4, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingProbeHistoryResponse.setDescription("The amount of time measured in milliseconds from when\na probe was sent to when its response was received or\nwhen it timed out.  The value of this object is reported\nas 0 when it is not possible to transmit a probe.")
pingProbeHistoryStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 4, 1, 3), OperationResponseStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingProbeHistoryStatus.setDescription("The result of a particular probe done by a remote host.")
pingProbeHistoryLastRC = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 4, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingProbeHistoryLastRC.setDescription("The last implementation-method-specific reply code received.\nIf the ICMP Echo capability is being used, then a successful\nprobe ends when an ICMP response is received that contains\nthe code ICMP_ECHOREPLY(0).  The ICMP codes are maintained\nby IANA.  Standardized ICMP codes are listed at\nhttp://www.iana.org/assignments/icmp-parameters.\nThe ICMPv6 codes are listed at\nhttp://www.iana.org/assignments/icmpv6-parameters.")
pingProbeHistoryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 80, 1, 4, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pingProbeHistoryTime.setDescription("Timestamp for when this probe result was determined.")
pingConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 2))
pingCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 2, 1))
pingGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 2, 2))
pingImplementationTypeDomains = MibIdentifier((1, 3, 6, 1, 2, 1, 80, 3))
pingIcmpEcho = ObjectIdentity((1, 3, 6, 1, 2, 1, 80, 3, 1))
if mibBuilder.loadTexts: pingIcmpEcho.setDescription("Indicates that an implementation is using the Internet\nControl Message Protocol (ICMP) 'ECHO' facility.")
pingUdpEcho = ObjectIdentity((1, 3, 6, 1, 2, 1, 80, 3, 2))
if mibBuilder.loadTexts: pingUdpEcho.setDescription("Indicates that an implementation is using the UDP echo\nport (7).")
pingSnmpQuery = ObjectIdentity((1, 3, 6, 1, 2, 1, 80, 3, 3))
if mibBuilder.loadTexts: pingSnmpQuery.setDescription("Indicates that an implementation is using an SNMP query\nto calculate a round trip time.")
pingTcpConnectionAttempt = ObjectIdentity((1, 3, 6, 1, 2, 1, 80, 3, 4))
if mibBuilder.loadTexts: pingTcpConnectionAttempt.setDescription("Indicates that an implementation is attempting to\nconnect to a TCP port in order to calculate a round\ntrip time.")

# Augmentions

# Notifications

pingTestCompleted = NotificationType((1, 3, 6, 1, 2, 1, 80, 0, 3)).setObjects(("DISMAN-PING-MIB", "pingCtlTargetAddress"), ("DISMAN-PING-MIB", "pingCtlTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsLastGoodProbe"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsAverageRtt"), ("DISMAN-PING-MIB", "pingResultsRttSumOfSquares"), ("DISMAN-PING-MIB", "pingResultsSentProbes"), ("DISMAN-PING-MIB", "pingResultsMinRtt"), ("DISMAN-PING-MIB", "pingResultsOperStatus"), ("DISMAN-PING-MIB", "pingResultsMaxRtt"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddress"), ("DISMAN-PING-MIB", "pingResultsProbeResponses"), )
pingTestFailed = NotificationType((1, 3, 6, 1, 2, 1, 80, 0, 2)).setObjects(("DISMAN-PING-MIB", "pingCtlTargetAddress"), ("DISMAN-PING-MIB", "pingCtlTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsLastGoodProbe"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsAverageRtt"), ("DISMAN-PING-MIB", "pingResultsRttSumOfSquares"), ("DISMAN-PING-MIB", "pingResultsSentProbes"), ("DISMAN-PING-MIB", "pingResultsMinRtt"), ("DISMAN-PING-MIB", "pingResultsOperStatus"), ("DISMAN-PING-MIB", "pingResultsMaxRtt"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddress"), ("DISMAN-PING-MIB", "pingResultsProbeResponses"), )
pingProbeFailed = NotificationType((1, 3, 6, 1, 2, 1, 80, 0, 1)).setObjects(("DISMAN-PING-MIB", "pingCtlTargetAddress"), ("DISMAN-PING-MIB", "pingCtlTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsLastGoodProbe"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsAverageRtt"), ("DISMAN-PING-MIB", "pingResultsRttSumOfSquares"), ("DISMAN-PING-MIB", "pingResultsSentProbes"), ("DISMAN-PING-MIB", "pingResultsMinRtt"), ("DISMAN-PING-MIB", "pingResultsOperStatus"), ("DISMAN-PING-MIB", "pingResultsMaxRtt"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddress"), ("DISMAN-PING-MIB", "pingResultsProbeResponses"), )

# Groups

pingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 1)).setObjects(("DISMAN-PING-MIB", "pingResultsIpTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsAverageRtt"), ("DISMAN-PING-MIB", "pingMaxConcurrentRequests"), ("DISMAN-PING-MIB", "pingResultsRttSumOfSquares"), ("DISMAN-PING-MIB", "pingProbeHistoryStatus"), ("DISMAN-PING-MIB", "pingResultsOperStatus"), ("DISMAN-PING-MIB", "pingCtlRowStatus"), ("DISMAN-PING-MIB", "pingCtlSourceAddressType"), ("DISMAN-PING-MIB", "pingResultsProbeResponses"), ("DISMAN-PING-MIB", "pingCtlType"), ("DISMAN-PING-MIB", "pingCtlTargetAddressType"), ("DISMAN-PING-MIB", "pingCtlTrapGeneration"), ("DISMAN-PING-MIB", "pingCtlTimeOut"), ("DISMAN-PING-MIB", "pingCtlStorageType"), ("DISMAN-PING-MIB", "pingCtlDataSize"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddress"), ("DISMAN-PING-MIB", "pingCtlTargetAddress"), ("DISMAN-PING-MIB", "pingCtlProbeCount"), ("DISMAN-PING-MIB", "pingProbeHistoryResponse"), ("DISMAN-PING-MIB", "pingCtlSourceAddress"), ("DISMAN-PING-MIB", "pingResultsMinRtt"), ("DISMAN-PING-MIB", "pingResultsMaxRtt"), ("DISMAN-PING-MIB", "pingCtlDSField"), ("DISMAN-PING-MIB", "pingCtlAdminStatus"), ("DISMAN-PING-MIB", "pingCtlTrapTestFailureFilter"), ("DISMAN-PING-MIB", "pingCtlFrequency"), ("DISMAN-PING-MIB", "pingResultsSentProbes"), ("DISMAN-PING-MIB", "pingCtlTrapProbeFailureFilter"), ("DISMAN-PING-MIB", "pingCtlDescr"), ("DISMAN-PING-MIB", "pingCtlMaxRows"), ("DISMAN-PING-MIB", "pingCtlDataFill"), ("DISMAN-PING-MIB", "pingCtlByPassRouteTable"), ("DISMAN-PING-MIB", "pingProbeHistoryLastRC"), ("DISMAN-PING-MIB", "pingCtlIfIndex"), )
pingHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 6)).setObjects(("DISMAN-PING-MIB", "pingProbeHistoryLastRC"), ("DISMAN-PING-MIB", "pingProbeHistoryStatus"), ("DISMAN-PING-MIB", "pingProbeHistoryTime"), ("DISMAN-PING-MIB", "pingProbeHistoryResponse"), )
pingNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 3)).setObjects(("DISMAN-PING-MIB", "pingTestCompleted"), ("DISMAN-PING-MIB", "pingTestFailed"), ("DISMAN-PING-MIB", "pingProbeFailed"), )
pingMinimumGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 4)).setObjects(("DISMAN-PING-MIB", "pingResultsIpTargetAddressType"), ("DISMAN-PING-MIB", "pingResultsAverageRtt"), ("DISMAN-PING-MIB", "pingMaxConcurrentRequests"), ("DISMAN-PING-MIB", "pingResultsRttSumOfSquares"), ("DISMAN-PING-MIB", "pingResultsOperStatus"), ("DISMAN-PING-MIB", "pingCtlSourceAddressType"), ("DISMAN-PING-MIB", "pingResultsProbeResponses"), ("DISMAN-PING-MIB", "pingCtlType"), ("DISMAN-PING-MIB", "pingCtlTargetAddressType"), ("DISMAN-PING-MIB", "pingCtlTrapGeneration"), ("DISMAN-PING-MIB", "pingCtlTimeOut"), ("DISMAN-PING-MIB", "pingCtlStorageType"), ("DISMAN-PING-MIB", "pingCtlDataSize"), ("DISMAN-PING-MIB", "pingResultsIpTargetAddress"), ("DISMAN-PING-MIB", "pingCtlTargetAddress"), ("DISMAN-PING-MIB", "pingCtlProbeCount"), ("DISMAN-PING-MIB", "pingCtlSourceAddress"), ("DISMAN-PING-MIB", "pingResultsMinRtt"), ("DISMAN-PING-MIB", "pingResultsMaxRtt"), ("DISMAN-PING-MIB", "pingCtlDSField"), ("DISMAN-PING-MIB", "pingResultsLastGoodProbe"), ("DISMAN-PING-MIB", "pingCtlAdminStatus"), ("DISMAN-PING-MIB", "pingCtlTrapTestFailureFilter"), ("DISMAN-PING-MIB", "pingCtlFrequency"), ("DISMAN-PING-MIB", "pingResultsSentProbes"), ("DISMAN-PING-MIB", "pingCtlTrapProbeFailureFilter"), ("DISMAN-PING-MIB", "pingCtlDescr"), ("DISMAN-PING-MIB", "pingCtlMaxRows"), ("DISMAN-PING-MIB", "pingCtlDataFill"), ("DISMAN-PING-MIB", "pingCtlByPassRouteTable"), ("DISMAN-PING-MIB", "pingCtlIfIndex"), )
pingCtlRowStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 5)).setObjects(("DISMAN-PING-MIB", "pingCtlRowStatus"), )
pingTimeStampGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 80, 2, 2, 2)).setObjects(("DISMAN-PING-MIB", "pingResultsLastGoodProbe"), ("DISMAN-PING-MIB", "pingProbeHistoryTime"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DISMAN-PING-MIB", PYSNMP_MODULE_ID=pingMIB)

# Types
mibBuilder.exportSymbols("DISMAN-PING-MIB", OperationResponseStatus=OperationResponseStatus)

# Objects
mibBuilder.exportSymbols("DISMAN-PING-MIB", pingMIB=pingMIB, pingNotifications=pingNotifications, pingObjects=pingObjects, pingMaxConcurrentRequests=pingMaxConcurrentRequests, pingCtlTable=pingCtlTable, pingCtlEntry=pingCtlEntry, pingCtlOwnerIndex=pingCtlOwnerIndex, pingCtlTestName=pingCtlTestName, pingCtlTargetAddressType=pingCtlTargetAddressType, pingCtlTargetAddress=pingCtlTargetAddress, pingCtlDataSize=pingCtlDataSize, pingCtlTimeOut=pingCtlTimeOut, pingCtlProbeCount=pingCtlProbeCount, pingCtlAdminStatus=pingCtlAdminStatus, pingCtlDataFill=pingCtlDataFill, pingCtlFrequency=pingCtlFrequency, pingCtlMaxRows=pingCtlMaxRows, pingCtlStorageType=pingCtlStorageType, pingCtlTrapGeneration=pingCtlTrapGeneration, pingCtlTrapProbeFailureFilter=pingCtlTrapProbeFailureFilter, pingCtlTrapTestFailureFilter=pingCtlTrapTestFailureFilter, pingCtlType=pingCtlType, pingCtlDescr=pingCtlDescr, pingCtlSourceAddressType=pingCtlSourceAddressType, pingCtlSourceAddress=pingCtlSourceAddress, pingCtlIfIndex=pingCtlIfIndex, pingCtlByPassRouteTable=pingCtlByPassRouteTable, pingCtlDSField=pingCtlDSField, pingCtlRowStatus=pingCtlRowStatus, pingResultsTable=pingResultsTable, pingResultsEntry=pingResultsEntry, pingResultsOperStatus=pingResultsOperStatus, pingResultsIpTargetAddressType=pingResultsIpTargetAddressType, pingResultsIpTargetAddress=pingResultsIpTargetAddress, pingResultsMinRtt=pingResultsMinRtt, pingResultsMaxRtt=pingResultsMaxRtt, pingResultsAverageRtt=pingResultsAverageRtt, pingResultsProbeResponses=pingResultsProbeResponses, pingResultsSentProbes=pingResultsSentProbes, pingResultsRttSumOfSquares=pingResultsRttSumOfSquares, pingResultsLastGoodProbe=pingResultsLastGoodProbe, pingProbeHistoryTable=pingProbeHistoryTable, pingProbeHistoryEntry=pingProbeHistoryEntry, pingProbeHistoryIndex=pingProbeHistoryIndex, pingProbeHistoryResponse=pingProbeHistoryResponse, pingProbeHistoryStatus=pingProbeHistoryStatus, pingProbeHistoryLastRC=pingProbeHistoryLastRC, pingProbeHistoryTime=pingProbeHistoryTime, pingConformance=pingConformance, pingCompliances=pingCompliances, pingGroups=pingGroups, pingImplementationTypeDomains=pingImplementationTypeDomains, pingIcmpEcho=pingIcmpEcho, pingUdpEcho=pingUdpEcho, pingSnmpQuery=pingSnmpQuery, pingTcpConnectionAttempt=pingTcpConnectionAttempt)

# Notifications
mibBuilder.exportSymbols("DISMAN-PING-MIB", pingTestCompleted=pingTestCompleted, pingTestFailed=pingTestFailed, pingProbeFailed=pingProbeFailed)

# Groups
mibBuilder.exportSymbols("DISMAN-PING-MIB", pingGroup=pingGroup, pingHistoryGroup=pingHistoryGroup, pingNotificationsGroup=pingNotificationsGroup, pingMinimumGroup=pingMinimumGroup, pingCtlRowStatusGroup=pingCtlRowStatusGroup, pingTimeStampGroup=pingTimeStampGroup)
