# PySNMP SMI module. Autogenerated from smidump -f python DISMAN-TRACEROUTE-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:16 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( OperationResponseStatus, ) = mibBuilder.importSymbols("DISMAN-PING-MIB", "OperationResponseStatus")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, RowStatus, StorageType, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "StorageType", "TruthValue")

# Objects

traceRouteMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 81)).setRevisions(("2006-06-13 00:00","2000-09-21 00:00",))
if mibBuilder.loadTexts: traceRouteMIB.setOrganization("IETF Distributed Management Working Group")
if mibBuilder.loadTexts: traceRouteMIB.setContactInfo("Juergen Quittek\n\nNEC Europe Ltd.\nNetwork Laboratories\nKurfuersten-Anlage 36\n69115 Heidelberg\nGermany\n\nPhone: +49 6221 4342-115\nEmail: quittek@netlab.nec.de")
if mibBuilder.loadTexts: traceRouteMIB.setDescription("The Traceroute MIB (DISMAN-TRACEROUTE-MIB) provides\naccess to the traceroute capability at a remote host.\n\nCopyright (C) The Internet Society (2006). This version of\nthis MIB module is part of RFC 4560; see the RFC itself for\nfull legal notices.")
traceRouteNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 0))
traceRouteObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 1))
traceRouteMaxConcurrentRequests = MibScalar((1, 3, 6, 1, 2, 1, 81, 1, 1), Unsigned32().clone(10)).setMaxAccess("readwrite").setUnits("requests")
if mibBuilder.loadTexts: traceRouteMaxConcurrentRequests.setDescription("The maximum number of concurrent active traceroute requests\nthat are allowed within an agent implementation.  A value\nof 0 for this object implies that there is no limit for\nthe number of concurrent active requests in effect.\n\nThe limit applies only to new requests being activated.\nWhen a new value is set, the agent will continue processing\nall the requests already active, even if their number\nexceeds the limit just imposed.")
traceRouteCtlTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 2))
if mibBuilder.loadTexts: traceRouteCtlTable.setDescription("Defines the Remote Operations Traceroute Control Table for\nproviding the capability of invoking traceroute from a remote\nhost.  The results of traceroute operations can be stored in\nthe traceRouteResultsTable, traceRouteProbeHistoryTable, and\nthe traceRouteHopsTable.")
traceRouteCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 2, 1)).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"))
if mibBuilder.loadTexts: traceRouteCtlEntry.setDescription("Defines an entry in the traceRouteCtlTable.  The first\nindex element, traceRouteCtlOwnerIndex, is of type\nSnmpAdminString, a textual convention that allows for\nuse of the SNMPv3 View-Based Access Control Model\n(RFC 3415, VACM) and that allows a management\napplication to identify its entries.  The second index,\ntraceRouteCtlTestName (also an SnmpAdminString),\nenables the same management application to have\nmultiple requests outstanding.")
traceRouteCtlOwnerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteCtlOwnerIndex.setDescription("To facilitate the provisioning of access control by a\nsecurity administrator using the View-Based Access\nControl Model (RFC 3415, VACM) for tables in which\nmultiple users may need to create or\nmodify entries independently, the initial index is used as\nan 'owner index'.  Such an initial index has a syntax of\nSnmpAdminString and can thus be trivially mapped to a\nsecurityName or groupName defined in VACM, in\naccordance with a security policy.\n\nWhen used in conjunction with such a security policy,\nall entries in the table belonging to a particular user\n(or group) will have the same value for this initial\nindex.  For a given user's entries in a particular\ntable, the object identifiers for the information in\nthese entries will have the same subidentifiers (except\nfor the 'column' subidentifier) up to the end of the\nencoded owner index. To configure VACM to permit access\nto this portion of the table, one would create\nvacmViewTreeFamilyTable entries with the value of\nvacmViewTreeFamilySubtree including the owner index\nportion, and vacmViewTreeFamilyMask 'wildcarding' the\ncolumn subidentifier.  More elaborate configurations\nare possible.")
traceRouteCtlTestName = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteCtlTestName.setDescription("The name of a traceroute test.  This is locally unique,\nwithin the scope of a traceRouteCtlOwnerIndex.")
traceRouteCtlTargetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 3), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTargetAddressType.setDescription("Specifies the type of host address to be used on the\ntraceroute request at the remote host.")
traceRouteCtlTargetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 4), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTargetAddress.setDescription("Specifies the host address used on the\ntraceroute request at the remote host.  The\nhost address type can be determined by\nexamining the value of the corresponding\ntraceRouteCtlTargetAddressType.\n\nA value for this object MUST be set prior to\ntransitioning its corresponding traceRouteCtlEntry to\nactive(1) via traceRouteCtlRowStatus.")
traceRouteCtlByPassRouteTable = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 5), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlByPassRouteTable.setDescription("The purpose of this object is to enable optional\nbypassing the route table.  If enabled, the remote\nhost will bypass the normal routing tables and send\ndirectly to a host on an attached network.  If the\nhost is not on a directly attached network, an\nerror is returned.  This option can be used to perform\nthe traceroute operation to a local host through an\ninterface that has no route defined (e.g., after the\ninterface was dropped by the routing daemon at the host).")
traceRouteCtlDataSize = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65507)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDataSize.setDescription("Specifies the size of the data portion of a traceroute\nrequest, in octets.  If the RECOMMENDED traceroute method\n(UDP datagrams as probes) is used, then the value\ncontained in this object MUST be applied.  If another\ntraceroute method is used for which the specified size\nis not appropriate, then the implementation SHOULD use\nwhatever size (appropriate to the method) is closest to\nthe specified size.\n\n\n\n\nThe maximum value for this object was computed by\nsubtracting the smallest possible IP header size of\n20 octets (IPv4 header with no options) and the UDP\nheader size of 8 octets from the maximum IP packet size.\nAn IP packet has a maximum size of 65535 octets\n(excluding IPv6 Jumbograms).")
traceRouteCtlTimeOut = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 60)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTimeOut.setDescription("Specifies the time-out value, in seconds, for\na traceroute request.")
traceRouteCtlProbesPerHop = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlProbesPerHop.setDescription("Specifies the number of times to reissue a traceroute\nrequest with the same time-to-live (TTL) value.")
traceRouteCtlPort = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(33434)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlPort.setDescription("Specifies the (initial) UDP port to send the traceroute\nrequest to.  A port needs to be specified that is not in\nuse at the destination (target) host.  The default\nvalue for this object is the IANA assigned port,\n33434, for the traceroute function.")
traceRouteCtlMaxTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(30)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxTtl.setDescription("Specifies the maximum time-to-live value.")
traceRouteCtlDSField = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDSField.setDescription("Specifies the value to store in the Type of Service\n(TOS) octet in the IPv4 header or in the Traffic\nClass octet in the IPv6 header, respectively, of the\nIP packet used to encapsulate the traceroute probe.\n\nThe octet to be set in the IP header contains the\nDifferentiated Services (DS) Field in the six most\nsignificant bits.\n\nThis option can be used to determine what effect an\nexplicit DS Field setting has on a traceroute response.\nNot all values are legal or meaningful.  A value of 0\nmeans that the function represented by this option is\nnot supported.  DS Field usage is often not supported\nby IP implementations, and not all values are supported.\nRefer to RFC 2474 and RFC 3260 for guidance on usage of\nthis field.")
traceRouteCtlSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 12), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlSourceAddressType.setDescription("Specifies the type of the source address,\ntraceRouteCtlSourceAddress, to be used at a remote host\nwhen a traceroute operation is performed.")
traceRouteCtlSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 13), InetAddress().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlSourceAddress.setDescription("Use the specified IP address (which must be given as an\nIP number, not a hostname) as the source address in\noutgoing probe packets.  On hosts with more than one IP\naddress, this option can be used to select the address\nto be used.  If the IP address is not one of this\nmachine's interface addresses, an error is returned, and\nnothing is sent.  A zero-length octet string value for\nthis object disables source address specification.\nThe address type (InetAddressType) that relates to\nthis object is specified by the corresponding value\nof traceRouteCtlSourceAddressType.")
traceRouteCtlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 14), InterfaceIndexOrZero().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlIfIndex.setDescription("Setting this object to an interface's ifIndex prior\nto starting a remote traceroute operation directs\nthe traceroute probes to be transmitted over the\nspecified interface.  A value of zero for this object\nimplies that this option is not enabled.")
traceRouteCtlMiscOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 15), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMiscOptions.setDescription("Enables an application to specify implementation-dependent\noptions.")
traceRouteCtlMaxFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 16), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxFailures.setDescription("The value of this object indicates the maximum number\nof consecutive timeouts allowed before a remote traceroute\nrequest is terminated.  A value of either 255 (maximum\nhop count/possible TTL value) or 0 indicates that the\nfunction of terminating a remote traceroute request when a\nspecific number of consecutive timeouts are detected is\ndisabled.")
traceRouteCtlDontFragment = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 17), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDontFragment.setDescription("This object enables setting of the don't fragment flag (DF)\nin the IP header for a probe.  Use of this object enables\na manual PATH MTU test is performed.")
traceRouteCtlInitialTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 18), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlInitialTtl.setDescription("The value of this object specifies the initial TTL value to\nuse.  This enables bypassing the initial (often well known)\nportion of a path.")
traceRouteCtlFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 19), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlFrequency.setDescription("The number of seconds to wait before repeating a\ntraceroute test, as defined by the value of the\nvarious objects in the corresponding row.\n\nAfter a single test is completed the number of seconds\nas defined by the value of traceRouteCtlFrequency MUST\nelapse before the next traceroute test is started.\n\nA value of 0 for this object implies that the test\nas defined by the corresponding entry will not be\n\n\nrepeated.")
traceRouteCtlStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 20), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent' need not\nallow write-access to any columnar objects in the row.")
traceRouteCtlAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlAdminStatus.setDescription("Reflects the desired state that an traceRouteCtlEntry\nshould be in:\n\n   enabled(1)  - Attempt to activate the test as defined by\n                 this traceRouteCtlEntry.\n   disabled(2) - Deactivate the test as defined by this\n                 traceRouteCtlEntry.\n\nRefer to the corresponding traceRouteResultsOperStatus to\ndetermine the operational state of the test defined by\nthis entry.")
traceRouteCtlDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 22), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDescr.setDescription("The purpose of this object is to provide a\ndescriptive name of the remote traceroute\ntest.")
traceRouteCtlMaxRows = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 23), Unsigned32().clone(50)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxRows.setDescription("The maximum number of corresponding entries allowed\nin the traceRouteProbeHistoryTable.  An implementation\nof this MIB will remove the oldest corresponding entry\nin the traceRouteProbeHistoryTable to allow the\naddition of an new entry once the number of\ncorresponding rows in the traceRouteProbeHistoryTable\nreaches this value.\n\nOld entries are not removed when a new test is\nstarted.  Entries are added to the\ntraceRouteProbeHistoryTable until traceRouteCtlMaxRows\nis reached before entries begin to be removed.\nA value of 0 for this object disables creation of\ntraceRouteProbeHistoryTable entries.")
traceRouteCtlTrapGeneration = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 24), Bits().subtype(namedValues=namedval.NamedValues(("pathChange", 0), ("testFailure", 1), ("testCompletion", 2), )).clone(())).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTrapGeneration.setDescription("The value of this object determines when and whether to\ngenerate a notification for this entry:\n\npathChange(0)     - Generate a traceRoutePathChange\n    notification when the current path varies from a\n    previously determined path.\ntestFailure(1)    - Generate a traceRouteTestFailed\n    notification when the full path to a target\n    can't be determined.\ntestCompletion(2) - Generate a traceRouteTestCompleted\n    notification when the path to a target has been\n    determined.\n\nThe value of this object defaults to an empty set,\nindicating that none of the above options has been\nselected.")
traceRouteCtlCreateHopsEntries = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 25), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlCreateHopsEntries.setDescription("The current path for a traceroute test is kept in the\ntraceRouteHopsTable on a per-hop basis when the value of\nthis object is true(1).")
traceRouteCtlType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 26), ObjectIdentifier().clone((1, 3, 6, 1, 2, 1, 81, 3, 1))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlType.setDescription("The value of this object is used either to report or to\nselect the implementation method to be used for\nperforming a traceroute operation.  The value of this\nobject may be selected from\ntraceRouteImplementationTypeDomains.\n\nAdditional implementation types should be allocated as\nrequired by implementers of the DISMAN-TRACEROUTE-MIB\nunder their enterprise specific registration point,\nnot beneath traceRouteImplementationTypeDomains.")
traceRouteCtlRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 27), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlRowStatus.setDescription("This object allows entries to be created and deleted\nin the traceRouteCtlTable.  Deletion of an entry in\nthis table results in a deletion of all corresponding (same\ntraceRouteCtlOwnerIndex and traceRouteCtlTestName\nindex values) traceRouteResultsTable,\ntraceRouteProbeHistoryTable, and traceRouteHopsTable\nentries.\n\nA value MUST be specified for traceRouteCtlTargetAddress\nprior to acceptance of a transition to active(1) state.\n\n\n\n\nWhen a value for pingCtlTargetAddress is set,\nthe value of object pingCtlRowStatus changes\nfrom notReady(3) to notInService(2).\n\nActivation of a remote traceroute operation is\ncontrolled via traceRouteCtlAdminStatus, and not\nby transitioning of this object's value to active(1).\n\nTransitions in and out of active(1) state are not\nallowed while an entry's traceRouteResultsOperStatus\nis active(1), with the exception that deletion of\nan entry in this table by setting its RowStatus\nobject to destroy(6) will stop an active\ntraceroute operation.\n\nThe operational state of an traceroute operation\ncan be determined by examination of the corresponding\ntraceRouteResultsOperStatus object.")
traceRouteResultsTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 3))
if mibBuilder.loadTexts: traceRouteResultsTable.setDescription("Defines the Remote Operations Traceroute Results Table for\nkeeping track of the status of a traceRouteCtlEntry.\n\nAn entry is added to the traceRouteResultsTable when an\ntraceRouteCtlEntry is started by successful transition\nof its traceRouteCtlAdminStatus object to enabled(1).\n\nIf the object traceRouteCtlAdminStatus already has the value\nenabled(1), and if the corresponding\ntraceRouteResultsOperStatus object has the value\ncompleted(3), then successfully writing enabled(1) to the\nobject traceRouteCtlAdminStatus re-initializes the already\nexisting entry in the traceRouteResultsTable.  The values of\nobjects in the re-initialized entry are the same as\nthe values of objects in a new entry would be.\n\nAn entry is removed from the traceRouteResultsTable when\n\n\n\nits corresponding traceRouteCtlEntry is deleted.")
traceRouteResultsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 3, 1)).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"))
if mibBuilder.loadTexts: traceRouteResultsEntry.setDescription("Defines an entry in the traceRouteResultsTable.  The\ntraceRouteResultsTable has the same indexing as the\ntraceRouteCtlTable so that a traceRouteResultsEntry\ncorresponds to the traceRouteCtlEntry that caused it to\nbe created.")
traceRouteResultsOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("completed", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsOperStatus.setDescription("Reflects the operational state of an traceRouteCtlEntry:\n\nenabled(1)   - Test is active.\ndisabled(2)  - Test has stopped.\ncompleted(3) - Test is completed.")
traceRouteResultsCurHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsCurHopCount.setDescription("Reflects the current TTL value (from 1 to\n255) for a remote traceroute operation.\nMaximum TTL value is determined by\ntraceRouteCtlMaxTtl.")
traceRouteResultsCurProbeCount = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsCurProbeCount.setDescription("Reflects the current probe count (1..10) for\na remote traceroute operation.  The maximum\nprobe count is determined by\ntraceRouteCtlProbesPerHop.")
traceRouteResultsIpTgtAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsIpTgtAddrType.setDescription("This object indicates the type of address stored\nin the corresponding traceRouteResultsIpTgtAddr\nobject.")
traceRouteResultsIpTgtAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsIpTgtAddr.setDescription("This object reports the IP address associated\nwith a traceRouteCtlTargetAddress value when the\ndestination address is specified as a DNS name.\nThe value of this object should be a zero-length\noctet string when a DNS name is not specified or\nwhen a specified DNS name fails to resolve.")
traceRouteResultsTestAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsTestAttempts.setDescription("The current number of attempts to determine a path\nto a target.  The value of this object MUST be started\nat 0.")
traceRouteResultsTestSuccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsTestSuccesses.setDescription("The current number of attempts to determine a path\nto a target that have succeeded.  The value of this\nobject MUST be reported as 0 when no attempts have\nsucceeded.")
traceRouteResultsLastGoodPath = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsLastGoodPath.setDescription("The date and time when the last complete path\nwas determined.  A path is complete if responses\nwere received or timeout occurred for each hop on\nthe path; i.e., for each TTL value from the value\nof the corresponding traceRouteCtlInitialTtl object\nup to the end of the path or (if no reply from the\ntarget IP address was received) up to the value of\nthe corresponding traceRouteCtlMaxTtl object.")
traceRouteProbeHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 4))
if mibBuilder.loadTexts: traceRouteProbeHistoryTable.setDescription("Defines the Remote Operations Traceroute Results Table\nfor storing the results of a traceroute operation.\n\nAn implementation of this MIB will remove the oldest\n\n\nentry in the traceRouteProbeHistoryTable of the\ncorresponding entry in the traceRouteCtlTable to allow\nthe addition of a new entry once the number of rows in\nthe traceRouteProbeHistoryTable reaches the value specified\nby traceRouteCtlMaxRows for the corresponding entry in the\ntraceRouteCtlTable.")
traceRouteProbeHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 4, 1)).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHopIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryProbeIndex"))
if mibBuilder.loadTexts: traceRouteProbeHistoryEntry.setDescription("Defines a table for storing the results of a traceroute\noperation.  Entries in this table are limited by\nthe value of the corresponding traceRouteCtlMaxRows\nobject.\n\nThe first two index elements identify the\ntraceRouteCtlEntry that a traceRouteProbeHistoryEntry\nbelongs to.  The third index element selects a single\ntraceroute operation result.  The fourth and fifth indexes\nselect the hop and the probe for a particular\ntraceroute operation.")
traceRouteProbeHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteProbeHistoryIndex.setDescription("An entry in this table is created when the result of\na traceroute probe is determined.  The initial 2 instance\nidentifier index values identify the traceRouteCtlEntry\nthat a probe result (traceRouteProbeHistoryEntry) belongs\nto.  An entry is removed from this table when\nits corresponding traceRouteCtlEntry is deleted.\n\nAn implementation MUST start assigning\ntraceRouteProbeHistoryIndex values at 1 and wrap after\nexceeding the maximum possible value, as defined by the\nlimit of this object ('ffffffff'h).")
traceRouteProbeHistoryHopIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteProbeHistoryHopIndex.setDescription("Indicates which hop in a traceroute path the probe's\nresults are for.  The value of this object is initially\ndetermined by the value of traceRouteCtlInitialTtl.")
traceRouteProbeHistoryProbeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteProbeHistoryProbeIndex.setDescription("Indicates the index of a probe for a particular\nhop in a traceroute path.  The number of probes per\nhop is determined by the value of the corresponding\ntraceRouteCtlProbesPerHop object.")
traceRouteProbeHistoryHAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryHAddrType.setDescription("This objects indicates the type of address stored\nin the corresponding traceRouteProbeHistoryHAddr\nobject.")
traceRouteProbeHistoryHAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryHAddr.setDescription("The address of a hop in a traceroute path.  This object\nis not allowed to be a DNS name.  The value of the\ncorresponding object, traceRouteProbeHistoryHAddrType,\nindicates this object's IP address type.")
traceRouteProbeHistoryResponse = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryResponse.setDescription("The amount of time measured in milliseconds from when\na probe was sent to when its response was received or\nwhen it timed out.  The value of this object is reported\nas 0 when it is not possible to transmit a probe.")
traceRouteProbeHistoryStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 7), OperationResponseStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryStatus.setDescription("The result of a traceroute operation made by a remote\nhost for a particular probe.")
traceRouteProbeHistoryLastRC = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryLastRC.setDescription("The last implementation-method-specific reply code received.\n\nTraceroute is usually implemented by transmitting a series of\nprobe packets with increasing time-to-live values.  A probe\npacket is a UDP datagram encapsulated into an IP packet.\nEach hop in a path to the target (destination) host rejects\nthe probe packets (probe's TTL too small, ICMP reply) until\neither the maximum TTL is exceeded or the target host is\nreceived.")
traceRouteProbeHistoryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryTime.setDescription("Timestamp for when this probe's results were determined.")
traceRouteHopsTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 5))
if mibBuilder.loadTexts: traceRouteHopsTable.setDescription("Defines the Remote Operations Traceroute Hop Table for\nkeeping track of the results of traceroute tests on a\nper-hop basis.")
traceRouteHopsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 5, 1)).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteHopsHopIndex"))
if mibBuilder.loadTexts: traceRouteHopsEntry.setDescription("Defines an entry in the traceRouteHopsTable.\nThe first two index elements identify the\ntraceRouteCtlEntry that a traceRouteHopsEntry\nbelongs to.  The third index element,\ntraceRouteHopsHopIndex, selects a\nhop in a traceroute path.")
traceRouteHopsHopIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: traceRouteHopsHopIndex.setDescription("Specifies the hop index for a traceroute hop.  Values\nfor this object with respect to the same\ntraceRouteCtlOwnerIndex and traceRouteCtlTestName\nMUST start at 1 and be given increasing values for\nsubsequent hops.  The value of traceRouteHopsHopIndex is not\nnecessarily the number of the hop on the traced path.\n\nThe traceRouteHopsTable keeps the current traceroute\npath per traceRouteCtlEntry if enabled by\nsetting the corresponding traceRouteCtlCreateHopsEntries\nto true(1).\n\nAll hops (traceRouteHopsTable entries) in a traceroute\npath MUST be updated at the same time when a traceroute\noperation is completed.  Care needs to be applied when a path\neither changes or can't be determined.  The initial portion\nof the path, up to the first hop change, MUST retain the\nsame traceRouteHopsHopIndex values.  The remaining portion\nof the path SHOULD be assigned new traceRouteHopsHopIndex\nvalues.")
traceRouteHopsIpTgtAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsIpTgtAddressType.setDescription("This object indicates the type of address stored\nin the corresponding traceRouteHopsIpTgtAddress\nobject.")
traceRouteHopsIpTgtAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsIpTgtAddress.setDescription("This object reports the IP address associated with\n\n\n\nthe hop.  A value for this object should be reported\nas a numeric IP address, not as a DNS name.\n\nThe address type (InetAddressType) that relates to\nthis object is specified by the corresponding value\nof pingCtlSourceAddressType.")
traceRouteHopsMinRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsMinRtt.setDescription("The minimum traceroute round-trip-time (RTT) received for\nthis hop.  A value of 0 for this object implies that no\nRTT has been received.")
traceRouteHopsMaxRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsMaxRtt.setDescription("The maximum traceroute round-trip-time (RTT) received for\nthis hop.  A value of 0 for this object implies that no\nRTT has been received.")
traceRouteHopsAverageRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsAverageRtt.setDescription("The current average traceroute round-trip-time (RTT) for\nthis hop.")
traceRouteHopsRttSumOfSquares = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsRttSumOfSquares.setDescription("This object contains the sum of the squares of all\nround-trip-times received for this hop.  Its purpose is\nto enable standard deviation calculation.")
traceRouteHopsSentProbes = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsSentProbes.setDescription("The value of this object reflects the number of probes sent\nfor this hop during this traceroute test.  The value of this\nobject should start at 0.")
traceRouteHopsProbeResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsProbeResponses.setDescription("Number of responses received for this hop during this\ntraceroute test.  This value of this object should start\nat 0.")
traceRouteHopsLastGoodProbe = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 10), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsLastGoodProbe.setDescription("Date and time at which the last response was received for a\nprobe for this hop during this traceroute test.")
traceRouteConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2))
traceRouteCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2, 1))
traceRouteGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2, 2))
traceRouteImplementationTypeDomains = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 3))
traceRouteUsingUdpProbes = ObjectIdentity((1, 3, 6, 1, 2, 1, 81, 3, 1))
if mibBuilder.loadTexts: traceRouteUsingUdpProbes.setDescription("Indicates that an implementation is using UDP probes to\nperform the traceroute operation.")

# Augmentions

# Notifications

traceRouteTestCompleted = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 3)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), )
traceRouteTestFailed = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 2)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), )
traceRoutePathChange = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 1)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), )

# Groups

traceRouteHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 7)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryLastRC"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryTime"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryResponse"), )
traceRouteHopsTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 4)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteHopsSentProbes"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsLastGoodProbe"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsAverageRtt"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsIpTgtAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsIpTgtAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsRttSumOfSquares"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsProbeResponses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsMinRtt"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsMaxRtt"), )
traceRouteCtlRowStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 6)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatus"), )
traceRouteTimeStampGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 2)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryTime"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsLastGoodPath"), )
traceRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 1)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxFailures"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlProbesPerHop"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteMaxConcurrentRequests"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlIfIndex"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMiscOptions"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlAdminStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlFrequency"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestSuccesses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlPort"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxRows"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDataSize"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTimeOut"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlCreateHopsEntries"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlInitialTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurHopCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryLastRC"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDontFragment"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestAttempts"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDescr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDSField"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsOperStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlStorageType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlByPassRouteTable"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTrapGeneration"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryResponse"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurProbeCount"), )
traceRouteNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 3)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteTestCompleted"), ("DISMAN-TRACEROUTE-MIB", "traceRouteTestFailed"), ("DISMAN-TRACEROUTE-MIB", "traceRoutePathChange"), )
traceRouteMinimumGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 5)).setObjects(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxFailures"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlProbesPerHop"), ("DISMAN-TRACEROUTE-MIB", "traceRouteMaxConcurrentRequests"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlIfIndex"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMiscOptions"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlAdminStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlFrequency"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestSuccesses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlPort"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxRows"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDataSize"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTimeOut"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlCreateHopsEntries"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlInitialTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurHopCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDontFragment"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestAttempts"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDescr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDSField"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsOperStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlStorageType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlByPassRouteTable"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsLastGoodPath"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTrapGeneration"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurProbeCount"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DISMAN-TRACEROUTE-MIB", PYSNMP_MODULE_ID=traceRouteMIB)

# Objects
mibBuilder.exportSymbols("DISMAN-TRACEROUTE-MIB", traceRouteMIB=traceRouteMIB, traceRouteNotifications=traceRouteNotifications, traceRouteObjects=traceRouteObjects, traceRouteMaxConcurrentRequests=traceRouteMaxConcurrentRequests, traceRouteCtlTable=traceRouteCtlTable, traceRouteCtlEntry=traceRouteCtlEntry, traceRouteCtlOwnerIndex=traceRouteCtlOwnerIndex, traceRouteCtlTestName=traceRouteCtlTestName, traceRouteCtlTargetAddressType=traceRouteCtlTargetAddressType, traceRouteCtlTargetAddress=traceRouteCtlTargetAddress, traceRouteCtlByPassRouteTable=traceRouteCtlByPassRouteTable, traceRouteCtlDataSize=traceRouteCtlDataSize, traceRouteCtlTimeOut=traceRouteCtlTimeOut, traceRouteCtlProbesPerHop=traceRouteCtlProbesPerHop, traceRouteCtlPort=traceRouteCtlPort, traceRouteCtlMaxTtl=traceRouteCtlMaxTtl, traceRouteCtlDSField=traceRouteCtlDSField, traceRouteCtlSourceAddressType=traceRouteCtlSourceAddressType, traceRouteCtlSourceAddress=traceRouteCtlSourceAddress, traceRouteCtlIfIndex=traceRouteCtlIfIndex, traceRouteCtlMiscOptions=traceRouteCtlMiscOptions, traceRouteCtlMaxFailures=traceRouteCtlMaxFailures, traceRouteCtlDontFragment=traceRouteCtlDontFragment, traceRouteCtlInitialTtl=traceRouteCtlInitialTtl, traceRouteCtlFrequency=traceRouteCtlFrequency, traceRouteCtlStorageType=traceRouteCtlStorageType, traceRouteCtlAdminStatus=traceRouteCtlAdminStatus, traceRouteCtlDescr=traceRouteCtlDescr, traceRouteCtlMaxRows=traceRouteCtlMaxRows, traceRouteCtlTrapGeneration=traceRouteCtlTrapGeneration, traceRouteCtlCreateHopsEntries=traceRouteCtlCreateHopsEntries, traceRouteCtlType=traceRouteCtlType, traceRouteCtlRowStatus=traceRouteCtlRowStatus, traceRouteResultsTable=traceRouteResultsTable, traceRouteResultsEntry=traceRouteResultsEntry, traceRouteResultsOperStatus=traceRouteResultsOperStatus, traceRouteResultsCurHopCount=traceRouteResultsCurHopCount, traceRouteResultsCurProbeCount=traceRouteResultsCurProbeCount, traceRouteResultsIpTgtAddrType=traceRouteResultsIpTgtAddrType, traceRouteResultsIpTgtAddr=traceRouteResultsIpTgtAddr, traceRouteResultsTestAttempts=traceRouteResultsTestAttempts, traceRouteResultsTestSuccesses=traceRouteResultsTestSuccesses, traceRouteResultsLastGoodPath=traceRouteResultsLastGoodPath, traceRouteProbeHistoryTable=traceRouteProbeHistoryTable, traceRouteProbeHistoryEntry=traceRouteProbeHistoryEntry, traceRouteProbeHistoryIndex=traceRouteProbeHistoryIndex, traceRouteProbeHistoryHopIndex=traceRouteProbeHistoryHopIndex, traceRouteProbeHistoryProbeIndex=traceRouteProbeHistoryProbeIndex, traceRouteProbeHistoryHAddrType=traceRouteProbeHistoryHAddrType, traceRouteProbeHistoryHAddr=traceRouteProbeHistoryHAddr, traceRouteProbeHistoryResponse=traceRouteProbeHistoryResponse, traceRouteProbeHistoryStatus=traceRouteProbeHistoryStatus, traceRouteProbeHistoryLastRC=traceRouteProbeHistoryLastRC, traceRouteProbeHistoryTime=traceRouteProbeHistoryTime, traceRouteHopsTable=traceRouteHopsTable, traceRouteHopsEntry=traceRouteHopsEntry, traceRouteHopsHopIndex=traceRouteHopsHopIndex, traceRouteHopsIpTgtAddressType=traceRouteHopsIpTgtAddressType, traceRouteHopsIpTgtAddress=traceRouteHopsIpTgtAddress, traceRouteHopsMinRtt=traceRouteHopsMinRtt, traceRouteHopsMaxRtt=traceRouteHopsMaxRtt, traceRouteHopsAverageRtt=traceRouteHopsAverageRtt, traceRouteHopsRttSumOfSquares=traceRouteHopsRttSumOfSquares, traceRouteHopsSentProbes=traceRouteHopsSentProbes, traceRouteHopsProbeResponses=traceRouteHopsProbeResponses, traceRouteHopsLastGoodProbe=traceRouteHopsLastGoodProbe, traceRouteConformance=traceRouteConformance, traceRouteCompliances=traceRouteCompliances, traceRouteGroups=traceRouteGroups, traceRouteImplementationTypeDomains=traceRouteImplementationTypeDomains, traceRouteUsingUdpProbes=traceRouteUsingUdpProbes)

# Notifications
mibBuilder.exportSymbols("DISMAN-TRACEROUTE-MIB", traceRouteTestCompleted=traceRouteTestCompleted, traceRouteTestFailed=traceRouteTestFailed, traceRoutePathChange=traceRoutePathChange)

# Groups
mibBuilder.exportSymbols("DISMAN-TRACEROUTE-MIB", traceRouteHistoryGroup=traceRouteHistoryGroup, traceRouteHopsTableGroup=traceRouteHopsTableGroup, traceRouteCtlRowStatusGroup=traceRouteCtlRowStatusGroup, traceRouteTimeStampGroup=traceRouteTimeStampGroup, traceRouteGroup=traceRouteGroup, traceRouteNotificationsGroup=traceRouteNotificationsGroup, traceRouteMinimumGroup=traceRouteMinimumGroup)
