# PySNMP SMI module. Autogenerated from smidump -f python DNS-RESOLVER-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:17 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( DnsClass, DnsName, DnsNameAsIndex, DnsOpCode, DnsQClass, DnsQType, DnsRespCode, DnsTime, DnsType, dns, ) = mibBuilder.importSymbols("DNS-SERVER-MIB", "DnsClass", "DnsName", "DnsNameAsIndex", "DnsOpCode", "DnsQClass", "DnsQType", "DnsRespCode", "DnsTime", "DnsType", "dns")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( DisplayString, RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TextualConvention")

# Objects

dnsResMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 32, 2)).setRevisions(("1994-01-28 22:50",))
if mibBuilder.loadTexts: dnsResMIB.setOrganization("IETF DNS Working Group")
if mibBuilder.loadTexts: dnsResMIB.setContactInfo("       Rob Austein\nPostal: Epilogue Technology Corporation\n        268 Main Street, Suite 283\n        North Reading, MA 10864\n        US\n   Tel: +1 617 245 0804\n   Fax: +1 617 245 8122\nE-Mail: sra@epilogue.com\n\n        Jon Saperia\nPostal: Digital Equipment Corporation\n        110 Spit Brook Road\n        ZKO1-3/H18\n        Nashua, NH 03062-2698\n        US\n   Tel: +1 603 881 0480\n   Fax: +1 603 881 0120\nE-mail: saperia@zko.dec.com")
if mibBuilder.loadTexts: dnsResMIB.setDescription("The MIB module for entities implementing the client\n(resolver) side of the Domain Name System (DNS)\nprotocol.")
dnsResMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1))
dnsResConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 1))
dnsResConfigImplementIdent = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 1), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResConfigImplementIdent.setDescription("The implementation identification string for the\nresolver software in use on the system, for example;\n`RES-2.1'")
dnsResConfigService = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("recursiveOnly", 1), ("iterativeOnly", 2), ("recursiveAndIterative", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResConfigService.setDescription("Kind of DNS resolution service provided:\n\nrecursiveOnly(1) indicates a stub resolver.\n\niterativeOnly(2) indicates a normal full service\nresolver.\n\nrecursiveAndIterative(3) indicates a full-service\nresolver which performs a mix of recursive and iterative\nqueries.")
dnsResConfigMaxCnames = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResConfigMaxCnames.setDescription("Limit on how many CNAMEs the resolver should allow\nbefore deciding that there's a CNAME loop.  Zero means\nthat resolver has no explicit CNAME limit.")
dnsResConfigSbeltTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4))
if mibBuilder.loadTexts: dnsResConfigSbeltTable.setDescription("Table of safety belt information used by the resolver\nwhen it hasn't got any better idea of where to send a\nquery, such as when the resolver is booting or is a stub\nresolver.")
dnsResConfigSbeltEntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResConfigSbeltAddr"), (0, "DNS-RESOLVER-MIB", "dnsResConfigSbeltSubTree"), (0, "DNS-RESOLVER-MIB", "dnsResConfigSbeltClass"))
if mibBuilder.loadTexts: dnsResConfigSbeltEntry.setDescription("An entry in the resolver's Sbelt table.\nRows may be created or deleted at any time by the DNS\nresolver and by SNMP SET requests.  Whether the values\nchanged via SNMP are saved in stable storage across\n`reset' operations is implementation-specific.")
dnsResConfigSbeltAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResConfigSbeltAddr.setDescription("The IP address of the Sbelt name server identified by\nthis row of the table.")
dnsResConfigSbeltName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 2), DnsName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dnsResConfigSbeltName.setDescription("The DNS name of a Sbelt nameserver identified by this\nrow of the table.  A zero-length string indicates that\nthe name is not known by the resolver.")
dnsResConfigSbeltRecursion = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("iterative", 1), ("recursive", 2), ("recursiveAndIterative", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dnsResConfigSbeltRecursion.setDescription("Kind of queries resolver will be sending to the name\nserver identified in this row of the table:\n\niterative(1) indicates that resolver will be directing\niterative queries to this name server (RD bit turned\noff).\n\nrecursive(2) indicates that resolver will be directing\nrecursive queries to this name server (RD bit turned\non).\n\nrecursiveAndIterative(3) indicates that the resolver\nwill be directing both recursive and iterative queries\nto the server identified in this row of the table.")
dnsResConfigSbeltPref = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dnsResConfigSbeltPref.setDescription("This value identifies the preference for the name server\nidentified in this row of the table.  The lower the\nvalue, the more desirable the resolver considers this\nserver.")
dnsResConfigSbeltSubTree = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 5), DnsNameAsIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResConfigSbeltSubTree.setDescription("Queries sent to the name server identified by this row\nof the table are limited to those for names in the name\nsubtree identified by this variable.  If no such\nlimitation applies, the value of this variable is the\nname of the root domain (a DNS name consisting of a\nsingle zero octet).")
dnsResConfigSbeltClass = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 6), DnsClass()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResConfigSbeltClass.setDescription("The class of DNS queries that will be sent to the server\nidentified by this row of the table.")
dnsResConfigSbeltStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 4, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dnsResConfigSbeltStatus.setDescription("Row status column for this row of the Sbelt table.")
dnsResConfigUpTime = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 5), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResConfigUpTime.setDescription("If the resolver has a persistent state (e.g., a\nprocess), this value will be the time elapsed since it\nstarted.  For software without persistant state, this\nvalue will be 0.")
dnsResConfigResetTime = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 6), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResConfigResetTime.setDescription("If the resolver has a persistent state (e.g., a process)\nand supports a `reset' operation (e.g., can be told to\nre-read configuration files), this value will be the\ntime elapsed since the last time the resolver was\n`reset.'  For software that does not have persistence or\ndoes not support a `reset' operation, this value will be\nzero.")
dnsResConfigReset = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,4,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("reset", 2), ("initializing", 3), ("running", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResConfigReset.setDescription("Status/action object to reinitialize any persistant\nresolver state.  When set to reset(2), any persistant\nresolver state (such as a process) is reinitialized as if\nthe resolver had just been started.  This value will\nnever be returned by a read operation.  When read, one of\nthe following values will be returned:\n    other(1) - resolver in some unknown state;\n    initializing(3) - resolver (re)initializing;\n    running(4) - resolver currently running.")
dnsResCounter = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 2))
dnsResCounterByOpcodeTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 3))
if mibBuilder.loadTexts: dnsResCounterByOpcodeTable.setDescription("Table of the current count of resolver queries and\nanswers.")
dnsResCounterByOpcodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 3, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResCounterByOpcodeCode"))
if mibBuilder.loadTexts: dnsResCounterByOpcodeEntry.setDescription("Entry in the resolver counter table.  Entries are\nindexed by DNS OpCode.")
dnsResCounterByOpcodeCode = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 3, 1, 1), DnsOpCode()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCounterByOpcodeCode.setDescription("The index to this table.  The OpCodes that have already\nbeen defined are found in RFC-1035.")
dnsResCounterByOpcodeQueries = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterByOpcodeQueries.setDescription("Total number of queries that have sent out by the\nresolver since initialization for the OpCode which is\nthe index to this row of the table.")
dnsResCounterByOpcodeResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterByOpcodeResponses.setDescription("Total number of responses that have been received by the\nresolver since initialization for the OpCode which is\nthe index to this row of the table.")
dnsResCounterByRcodeTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 4))
if mibBuilder.loadTexts: dnsResCounterByRcodeTable.setDescription("Table of the current count of responses to resolver\nqueries.")
dnsResCounterByRcodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 4, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResCounterByRcodeCode"))
if mibBuilder.loadTexts: dnsResCounterByRcodeEntry.setDescription("Entry in the resolver response table.  Entries are\nindexed by DNS response code.")
dnsResCounterByRcodeCode = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 4, 1, 1), DnsRespCode()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCounterByRcodeCode.setDescription("The index to this table.  The Response Codes that have\nalready been defined are found in RFC-1035.")
dnsResCounterByRcodeResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterByRcodeResponses.setDescription("Number of responses the resolver has received for the\nresponse code value which identifies this row of the\ntable.")
dnsResCounterNonAuthDataResps = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterNonAuthDataResps.setDescription("Number of requests made by the resolver for which a\nnon-authoritative answer (cached data) was received.")
dnsResCounterNonAuthNoDataResps = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterNonAuthNoDataResps.setDescription("Number of requests made by the resolver for which a\nnon-authoritative answer - no such data response (empty\nanswer) was received.")
dnsResCounterMartians = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterMartians.setDescription("Number of responses received which were received from\nservers that the resolver does not think it asked.")
dnsResCounterRecdResponses = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterRecdResponses.setDescription("Number of responses received to all queries.")
dnsResCounterUnparseResps = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterUnparseResps.setDescription("Number of responses received which were unparseable.")
dnsResCounterFallbacks = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCounterFallbacks.setDescription("Number of times the resolver had to fall back to its\nseat belt information.")
dnsResLameDelegation = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 3))
dnsResLameDelegationOverflows = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResLameDelegationOverflows.setDescription("Number of times the resolver attempted to add an entry\nto the Lame Delegation table but was unable to for some\nreason such as space constraints.")
dnsResLameDelegationTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2))
if mibBuilder.loadTexts: dnsResLameDelegationTable.setDescription("Table of name servers returning lame delegations.\n\nA lame delegation has occured when a parent zone\ndelegates authority for a child zone to a server that\nappears not to think that it is authoritative for the\nchild zone in question.")
dnsResLameDelegationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResLameDelegationSource"), (0, "DNS-RESOLVER-MIB", "dnsResLameDelegationName"), (0, "DNS-RESOLVER-MIB", "dnsResLameDelegationClass"))
if mibBuilder.loadTexts: dnsResLameDelegationEntry.setDescription("Entry in lame delegation table.  Only the resolver may\ncreate rows in this table.  SNMP SET requests may be used\nto delete rows.")
dnsResLameDelegationSource = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResLameDelegationSource.setDescription("Source of lame delegation.")
dnsResLameDelegationName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1, 2), DnsNameAsIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResLameDelegationName.setDescription("DNS name for which lame delegation was received.")
dnsResLameDelegationClass = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1, 3), DnsClass()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResLameDelegationClass.setDescription("DNS class of received lame delegation.")
dnsResLameDelegationCounts = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResLameDelegationCounts.setDescription("How many times this lame delegation has been received.")
dnsResLameDelegationStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 3, 2, 1, 5), RowStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResLameDelegationStatus.setDescription("Status column for the lame delegation table.  Since only\nthe agent (DNS resolver) creates rows in this table, the\nonly values that a manager may write to this variable\nare active(1) and destroy(6).")
dnsResCache = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 4))
dnsResCacheStatus = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("clear", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResCacheStatus.setDescription("Status/action for the resolver's cache.\n\nenabled(1) means that the use of the cache is allowed.\nQuery operations can return this state.\n\ndisabled(2) means that the cache is not being used.\nQuery operations can return this state.\n\nSetting this variable to clear(3) deletes the entire\ncontents of the resolver's cache, but does not otherwise\nchange the resolver's state.  The status will retain its\nprevious value from before the clear operation (i.e.,\nenabled(1) or disabled(2)).  The value of clear(3) can\nNOT be returned by a query operation.")
dnsResCacheMaxTTL = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 2), DnsTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResCacheMaxTTL.setDescription("Maximum Time-To-Live for RRs in this cache.  If the\nresolver does not implement a TTL ceiling, the value of\nthis field should be zero.")
dnsResCacheGoodCaches = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheGoodCaches.setDescription("Number of RRs the resolver has cached successfully.")
dnsResCacheBadCaches = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheBadCaches.setDescription("Number of RRs the resolver has refused to cache because\nthey appear to be dangerous or irrelevant.  E.g., RRs\nwith suspiciously high TTLs, unsolicited root\ninformation, or that just don't appear to be relevant to\nthe question the resolver asked.")
dnsResCacheRRTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5))
if mibBuilder.loadTexts: dnsResCacheRRTable.setDescription("This table contains information about all the resource\nrecords currently in the resolver's cache.")
dnsResCacheRREntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResCacheRRName"), (0, "DNS-RESOLVER-MIB", "dnsResCacheRRClass"), (0, "DNS-RESOLVER-MIB", "dnsResCacheRRType"), (0, "DNS-RESOLVER-MIB", "dnsResCacheRRIndex"))
if mibBuilder.loadTexts: dnsResCacheRREntry.setDescription("An entry in the resolvers's cache.  Rows may be created\nonly by the resolver.  SNMP SET requests may be used to\ndelete rows.")
dnsResCacheRRName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 1), DnsNameAsIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCacheRRName.setDescription("Owner name of the Resource Record in the cache which is\nidentified in this row of the table.  As described in\nRFC-1034, the owner of the record is the domain name\nwere the RR is found.")
dnsResCacheRRClass = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 2), DnsClass()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCacheRRClass.setDescription("DNS class of the Resource Record in the cache which is\nidentified in this row of the table.")
dnsResCacheRRType = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 3), DnsType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCacheRRType.setDescription("DNS type of the Resource Record in the cache which is\nidentified in this row of the table.")
dnsResCacheRRTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 4), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheRRTTL.setDescription("Time-To-Live of RR in DNS cache.  This is the initial\nTTL value which was received with the RR when it was\noriginally received.")
dnsResCacheRRElapsedTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 5), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheRRElapsedTTL.setDescription("Elapsed seconds since RR was received.")
dnsResCacheRRSource = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 6), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheRRSource.setDescription("Host from which RR was received, 0.0.0.0 if unknown.")
dnsResCacheRRData = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 7), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheRRData.setDescription("RDATA portion of a cached RR.  The value is in the\nformat defined for the particular DNS class and type of\nthe resource record.")
dnsResCacheRRStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 8), RowStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResCacheRRStatus.setDescription("Status column for the resolver cache table.  Since only\nthe agent (DNS resolver) creates rows in this table, the\nonly values that a manager may write to this variable\nare active(1) and destroy(6).")
dnsResCacheRRIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 9), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResCacheRRIndex.setDescription("A value which makes entries in the table unique when the\nother index values (dnsResCacheRRName,\ndnsResCacheRRClass, and dnsResCacheRRType) do not\nprovide a unique index.")
dnsResCacheRRPrettyName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 4, 5, 1, 10), DnsName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResCacheRRPrettyName.setDescription("Name of the RR at this row in the table.  This is\nidentical to the dnsResCacheRRName variable, except that\ncharacter case is preserved in this variable, per DNS\nconventions.")
dnsResNCache = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 5))
dnsResNCacheStatus = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("clear", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResNCacheStatus.setDescription("Status/action for the resolver's negative response\ncache.\n\nenabled(1) means that the use of the negative response\ncache is allowed.  Query operations can return this\nstate.\ndisabled(2) means that the negative response cache is\nnot being used.  Query operations can return this state.\n\nSetting this variable to clear(3) deletes the entire\ncontents of the resolver's negative response cache.  The\nstatus will retain its previous value from before the\nclear operation (i.e., enabled(1) or disabled(2)).  The\nvalue of clear(3) can NOT be returned by a query\noperation.")
dnsResNCacheMaxTTL = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 2), DnsTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResNCacheMaxTTL.setDescription("Maximum Time-To-Live for cached authoritative errors.\nIf the resolver does not implement a TTL ceiling, the\nvalue of this field should be zero.")
dnsResNCacheGoodNCaches = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheGoodNCaches.setDescription("Number of authoritative errors the resolver has cached\nsuccessfully.")
dnsResNCacheBadNCaches = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheBadNCaches.setDescription("Number of authoritative errors the resolver would have\nliked to cache but was unable to because the appropriate\nSOA RR was not supplied or looked suspicious.")
dnsResNCacheErrTable = MibTable((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5))
if mibBuilder.loadTexts: dnsResNCacheErrTable.setDescription("The resolver's negative response cache.  This table\ncontains information about authoritative errors that\nhave been cached by the resolver.")
dnsResNCacheErrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1)).setIndexNames((0, "DNS-RESOLVER-MIB", "dnsResNCacheErrQName"), (0, "DNS-RESOLVER-MIB", "dnsResNCacheErrQClass"), (0, "DNS-RESOLVER-MIB", "dnsResNCacheErrQType"), (0, "DNS-RESOLVER-MIB", "dnsResNCacheErrIndex"))
if mibBuilder.loadTexts: dnsResNCacheErrEntry.setDescription("An entry in the resolver's negative response cache\ntable.  Only the resolver can create rows.  SNMP SET\nrequests may be used to delete rows.")
dnsResNCacheErrQName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 1), DnsNameAsIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResNCacheErrQName.setDescription("QNAME associated with a cached authoritative error.")
dnsResNCacheErrQClass = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 2), DnsQClass()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResNCacheErrQClass.setDescription("DNS QCLASS associated with a cached authoritative\nerror.")
dnsResNCacheErrQType = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 3), DnsQType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dnsResNCacheErrQType.setDescription("DNS QTYPE associated with a cached authoritative error.")
dnsResNCacheErrTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 4), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrTTL.setDescription("Time-To-Live of a cached authoritative error at the time\nof the error, it should not be decremented by the number\nof seconds since it was received.  This should be the\nTTL as copied from the MINIMUM field of the SOA that\naccompanied the authoritative error, or a smaller value\nif the resolver implements a ceiling on negative\nresponse cache TTLs.")
dnsResNCacheErrElapsedTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 5), DnsTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrElapsedTTL.setDescription("Elapsed seconds since authoritative error was received.")
dnsResNCacheErrSource = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 6), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrSource.setDescription("Host which sent the authoritative error, 0.0.0.0 if\nunknown.")
dnsResNCacheErrCode = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("nonexistantName", 1), ("noData", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrCode.setDescription("The authoritative error that has been cached:\n\nnonexistantName(1) indicates an authoritative name error\n(RCODE = 3).\n\nnoData(2) indicates an authoritative response with no\nerror (RCODE = 0) and no relevant data.\n\nother(3) indicates some other cached authoritative\nerror.  At present, no such errors are known to exist.")
dnsResNCacheErrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 8), RowStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dnsResNCacheErrStatus.setDescription("Status column for the resolver negative response cache\ntable.  Since only the agent (DNS resolver) creates rows\nin this table, the only values that a manager may write\nto this variable are active(1) and destroy(6).")
dnsResNCacheErrIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrIndex.setDescription("A value which makes entries in the table unique when the\nother index values (dnsResNCacheErrQName,\ndnsResNCacheErrQClass, and dnsResNCacheErrQType) do not\nprovide a unique index.")
dnsResNCacheErrPrettyName = MibTableColumn((1, 3, 6, 1, 2, 1, 32, 2, 1, 5, 5, 1, 10), DnsName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResNCacheErrPrettyName.setDescription("QNAME associated with this row in the table.  This is\nidentical to the dnsResNCacheErrQName variable, except\nthat character case is preserved in this variable, per\nDNS conventions.")
dnsResOptCounter = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 1, 6))
dnsResOptCounterReferals = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterReferals.setDescription("Number of responses which were received from servers\nredirecting query to another server.")
dnsResOptCounterRetrans = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterRetrans.setDescription("Number requests retransmitted for all reasons.")
dnsResOptCounterNoResponses = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterNoResponses.setDescription("Number of queries that were retransmitted because of no\nresponse.")
dnsResOptCounterRootRetrans = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterRootRetrans.setDescription("Number of queries that were retransmitted that were to\nroot servers.")
dnsResOptCounterInternals = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterInternals.setDescription("Number of requests internally generated by the\nresolver.")
dnsResOptCounterInternalTimeOuts = MibScalar((1, 3, 6, 1, 2, 1, 32, 2, 1, 6, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dnsResOptCounterInternalTimeOuts.setDescription("Number of requests internally generated which timed\nout.")
dnsResMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 2))
dnsResMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 32, 2, 3))

# Augmentions

# Groups

dnsResLameDelegationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 3)).setObjects(("DNS-RESOLVER-MIB", "dnsResLameDelegationOverflows"), ("DNS-RESOLVER-MIB", "dnsResLameDelegationName"), ("DNS-RESOLVER-MIB", "dnsResLameDelegationStatus"), ("DNS-RESOLVER-MIB", "dnsResLameDelegationSource"), ("DNS-RESOLVER-MIB", "dnsResLameDelegationClass"), ("DNS-RESOLVER-MIB", "dnsResLameDelegationCounts"), )
dnsResCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 2)).setObjects(("DNS-RESOLVER-MIB", "dnsResCounterMartians"), ("DNS-RESOLVER-MIB", "dnsResCounterByOpcodeQueries"), ("DNS-RESOLVER-MIB", "dnsResCounterByOpcodeResponses"), ("DNS-RESOLVER-MIB", "dnsResCounterNonAuthDataResps"), ("DNS-RESOLVER-MIB", "dnsResCounterByRcodeResponses"), ("DNS-RESOLVER-MIB", "dnsResCounterUnparseResps"), ("DNS-RESOLVER-MIB", "dnsResCounterByRcodeCode"), ("DNS-RESOLVER-MIB", "dnsResCounterByOpcodeCode"), ("DNS-RESOLVER-MIB", "dnsResCounterNonAuthNoDataResps"), ("DNS-RESOLVER-MIB", "dnsResCounterRecdResponses"), ("DNS-RESOLVER-MIB", "dnsResCounterFallbacks"), )
dnsResCacheGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 4)).setObjects(("DNS-RESOLVER-MIB", "dnsResCacheBadCaches"), ("DNS-RESOLVER-MIB", "dnsResCacheRRClass"), ("DNS-RESOLVER-MIB", "dnsResCacheGoodCaches"), ("DNS-RESOLVER-MIB", "dnsResCacheRRIndex"), ("DNS-RESOLVER-MIB", "dnsResCacheRRType"), ("DNS-RESOLVER-MIB", "dnsResCacheRRPrettyName"), ("DNS-RESOLVER-MIB", "dnsResCacheRRSource"), ("DNS-RESOLVER-MIB", "dnsResCacheRRStatus"), ("DNS-RESOLVER-MIB", "dnsResCacheMaxTTL"), ("DNS-RESOLVER-MIB", "dnsResCacheRRData"), ("DNS-RESOLVER-MIB", "dnsResCacheRRName"), ("DNS-RESOLVER-MIB", "dnsResCacheRRElapsedTTL"), ("DNS-RESOLVER-MIB", "dnsResCacheStatus"), ("DNS-RESOLVER-MIB", "dnsResCacheRRTTL"), )
dnsResOptCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 6)).setObjects(("DNS-RESOLVER-MIB", "dnsResOptCounterReferals"), ("DNS-RESOLVER-MIB", "dnsResOptCounterInternalTimeOuts"), ("DNS-RESOLVER-MIB", "dnsResOptCounterNoResponses"), ("DNS-RESOLVER-MIB", "dnsResOptCounterRetrans"), ("DNS-RESOLVER-MIB", "dnsResOptCounterInternals"), ("DNS-RESOLVER-MIB", "dnsResOptCounterRootRetrans"), )
dnsResNCacheGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 5)).setObjects(("DNS-RESOLVER-MIB", "dnsResNCacheGoodNCaches"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrQType"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrSource"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrElapsedTTL"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrIndex"), ("DNS-RESOLVER-MIB", "dnsResNCacheMaxTTL"), ("DNS-RESOLVER-MIB", "dnsResNCacheBadNCaches"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrTTL"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrPrettyName"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrStatus"), ("DNS-RESOLVER-MIB", "dnsResNCacheStatus"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrQName"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrQClass"), ("DNS-RESOLVER-MIB", "dnsResNCacheErrCode"), )
dnsResConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 32, 2, 2, 1)).setObjects(("DNS-RESOLVER-MIB", "dnsResConfigSbeltName"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltStatus"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltRecursion"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltSubTree"), ("DNS-RESOLVER-MIB", "dnsResConfigResetTime"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltClass"), ("DNS-RESOLVER-MIB", "dnsResConfigMaxCnames"), ("DNS-RESOLVER-MIB", "dnsResConfigService"), ("DNS-RESOLVER-MIB", "dnsResConfigUpTime"), ("DNS-RESOLVER-MIB", "dnsResConfigImplementIdent"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltPref"), ("DNS-RESOLVER-MIB", "dnsResConfigSbeltAddr"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DNS-RESOLVER-MIB", PYSNMP_MODULE_ID=dnsResMIB)

# Objects
mibBuilder.exportSymbols("DNS-RESOLVER-MIB", dnsResMIB=dnsResMIB, dnsResMIBObjects=dnsResMIBObjects, dnsResConfig=dnsResConfig, dnsResConfigImplementIdent=dnsResConfigImplementIdent, dnsResConfigService=dnsResConfigService, dnsResConfigMaxCnames=dnsResConfigMaxCnames, dnsResConfigSbeltTable=dnsResConfigSbeltTable, dnsResConfigSbeltEntry=dnsResConfigSbeltEntry, dnsResConfigSbeltAddr=dnsResConfigSbeltAddr, dnsResConfigSbeltName=dnsResConfigSbeltName, dnsResConfigSbeltRecursion=dnsResConfigSbeltRecursion, dnsResConfigSbeltPref=dnsResConfigSbeltPref, dnsResConfigSbeltSubTree=dnsResConfigSbeltSubTree, dnsResConfigSbeltClass=dnsResConfigSbeltClass, dnsResConfigSbeltStatus=dnsResConfigSbeltStatus, dnsResConfigUpTime=dnsResConfigUpTime, dnsResConfigResetTime=dnsResConfigResetTime, dnsResConfigReset=dnsResConfigReset, dnsResCounter=dnsResCounter, dnsResCounterByOpcodeTable=dnsResCounterByOpcodeTable, dnsResCounterByOpcodeEntry=dnsResCounterByOpcodeEntry, dnsResCounterByOpcodeCode=dnsResCounterByOpcodeCode, dnsResCounterByOpcodeQueries=dnsResCounterByOpcodeQueries, dnsResCounterByOpcodeResponses=dnsResCounterByOpcodeResponses, dnsResCounterByRcodeTable=dnsResCounterByRcodeTable, dnsResCounterByRcodeEntry=dnsResCounterByRcodeEntry, dnsResCounterByRcodeCode=dnsResCounterByRcodeCode, dnsResCounterByRcodeResponses=dnsResCounterByRcodeResponses, dnsResCounterNonAuthDataResps=dnsResCounterNonAuthDataResps, dnsResCounterNonAuthNoDataResps=dnsResCounterNonAuthNoDataResps, dnsResCounterMartians=dnsResCounterMartians, dnsResCounterRecdResponses=dnsResCounterRecdResponses, dnsResCounterUnparseResps=dnsResCounterUnparseResps, dnsResCounterFallbacks=dnsResCounterFallbacks, dnsResLameDelegation=dnsResLameDelegation, dnsResLameDelegationOverflows=dnsResLameDelegationOverflows, dnsResLameDelegationTable=dnsResLameDelegationTable, dnsResLameDelegationEntry=dnsResLameDelegationEntry, dnsResLameDelegationSource=dnsResLameDelegationSource, dnsResLameDelegationName=dnsResLameDelegationName, dnsResLameDelegationClass=dnsResLameDelegationClass, dnsResLameDelegationCounts=dnsResLameDelegationCounts, dnsResLameDelegationStatus=dnsResLameDelegationStatus, dnsResCache=dnsResCache, dnsResCacheStatus=dnsResCacheStatus, dnsResCacheMaxTTL=dnsResCacheMaxTTL, dnsResCacheGoodCaches=dnsResCacheGoodCaches, dnsResCacheBadCaches=dnsResCacheBadCaches, dnsResCacheRRTable=dnsResCacheRRTable, dnsResCacheRREntry=dnsResCacheRREntry, dnsResCacheRRName=dnsResCacheRRName, dnsResCacheRRClass=dnsResCacheRRClass, dnsResCacheRRType=dnsResCacheRRType, dnsResCacheRRTTL=dnsResCacheRRTTL, dnsResCacheRRElapsedTTL=dnsResCacheRRElapsedTTL, dnsResCacheRRSource=dnsResCacheRRSource, dnsResCacheRRData=dnsResCacheRRData, dnsResCacheRRStatus=dnsResCacheRRStatus, dnsResCacheRRIndex=dnsResCacheRRIndex, dnsResCacheRRPrettyName=dnsResCacheRRPrettyName, dnsResNCache=dnsResNCache, dnsResNCacheStatus=dnsResNCacheStatus, dnsResNCacheMaxTTL=dnsResNCacheMaxTTL, dnsResNCacheGoodNCaches=dnsResNCacheGoodNCaches, dnsResNCacheBadNCaches=dnsResNCacheBadNCaches, dnsResNCacheErrTable=dnsResNCacheErrTable, dnsResNCacheErrEntry=dnsResNCacheErrEntry, dnsResNCacheErrQName=dnsResNCacheErrQName, dnsResNCacheErrQClass=dnsResNCacheErrQClass, dnsResNCacheErrQType=dnsResNCacheErrQType, dnsResNCacheErrTTL=dnsResNCacheErrTTL, dnsResNCacheErrElapsedTTL=dnsResNCacheErrElapsedTTL, dnsResNCacheErrSource=dnsResNCacheErrSource, dnsResNCacheErrCode=dnsResNCacheErrCode, dnsResNCacheErrStatus=dnsResNCacheErrStatus, dnsResNCacheErrIndex=dnsResNCacheErrIndex, dnsResNCacheErrPrettyName=dnsResNCacheErrPrettyName, dnsResOptCounter=dnsResOptCounter, dnsResOptCounterReferals=dnsResOptCounterReferals, dnsResOptCounterRetrans=dnsResOptCounterRetrans, dnsResOptCounterNoResponses=dnsResOptCounterNoResponses, dnsResOptCounterRootRetrans=dnsResOptCounterRootRetrans, dnsResOptCounterInternals=dnsResOptCounterInternals, dnsResOptCounterInternalTimeOuts=dnsResOptCounterInternalTimeOuts, dnsResMIBGroups=dnsResMIBGroups, dnsResMIBCompliances=dnsResMIBCompliances)

# Groups
mibBuilder.exportSymbols("DNS-RESOLVER-MIB", dnsResLameDelegationGroup=dnsResLameDelegationGroup, dnsResCounterGroup=dnsResCounterGroup, dnsResCacheGroup=dnsResCacheGroup, dnsResOptCounterGroup=dnsResOptCounterGroup, dnsResNCacheGroup=dnsResNCacheGroup, dnsResConfigGroup=dnsResConfigGroup)
