# PySNMP SMI module. Autogenerated from smidump -f python DOCS-BPI-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:17 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( docsIfCmServiceId, docsIfCmtsServiceId, docsIfMib, ) = mibBuilder.importSymbols("DOCS-IF-MIB", "docsIfCmServiceId", "docsIfCmtsServiceId", "docsIfMib")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( DateAndTime, DisplayString, MacAddress, RowStatus, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "MacAddress", "RowStatus", "TruthValue")

# Objects

docsBpiMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 127, 5)).setRevisions(("2001-03-13 00:00","2000-11-03 19:30","2000-02-16 19:30",))
if mibBuilder.loadTexts: docsBpiMIB.setOrganization("IETF IPCDN Working Group")
if mibBuilder.loadTexts: docsBpiMIB.setContactInfo("Rich Woundy\nPostal: Cisco Systems\n        250 Apollo Drive\n        Chelmsford, MA 01824 U.S.A.\nTel: +1 978 244 8000\nE-mail: rwoundy@cisco.com\n\nIETF IPCDN Working Group\nGeneral Discussion: ipcdn@ietf.org\nSubscribe: http://www.ietf.org/mailman/listinfo/ipcdn\nArchive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn\nCo-chairs: Richard Woundy, rwoundy@cisco.com\n           Andrew Valentine, a.valentine@eu.hns.com")
if mibBuilder.loadTexts: docsBpiMIB.setDescription("This is the MIB Module for the DOCSIS Baseline Privacy Interface\n(BPI) at cable modems (CMs) and cable modem termination systems\n(CMTSs). CableLabs requires the implementation of this MIB in\nDOCSIS 1.0 cable modems that implement the Baseline Privacy\nInterface, as a prerequisite for DOCSIS 1.0 certification.")
docsBpiMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 1))
docsBpiCmObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1))
docsBpiCmBaseTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1))
if mibBuilder.loadTexts: docsBpiCmBaseTable.setDescription("This table describes the basic and authorization-related Baseline\nPrivacy attributes of each CM MAC interface.")
docsBpiCmBaseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsBpiCmBaseEntry.setDescription("Each entry contains objects describing attributes of one CM MAC\ninterface. An entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsBpiCmPrivacyEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmPrivacyEnable.setDescription("This object identifies whether this CM is provisioned to run\nBaseline Privacy. This is analogous to the presence (or absence)\nof the Baseline Privacy Configuration Setting option. The status\nof each individual SID with respect to Baseline Privacy is\ncaptured in the docsBpiCmTEKPrivacyEnable object.")
docsBpiCmPublicKey = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(74,74),constraint.ValueSizeConstraint(106,106),constraint.ValueSizeConstraint(140,140),constraint.ValueSizeConstraint(270,270),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmPublicKey.setDescription("The value of this object is a DER-encoded RSAPublicKey ASN.1 type\nstring, as defined in the RSA Encryption Standard (PKCS #1) [22],\ncorresponding to the public key of the CM. The 74, 106, 140, and\n270 byte key encoding lengths correspond to 512 bit, 768 bit, 1024\nbit, and 2048 public moduli respectively.")
docsBpiCmAuthState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,4,3,5,)).subtype(namedValues=namedval.NamedValues(("authWait", 2), ("authorized", 3), ("reauthWait", 4), ("authRejectWait", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthState.setDescription("The value of this object is the state of the CM authorization\nFSM.  The start state indicates that FSM is in its initial state.")
docsBpiCmAuthKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthKeySequenceNumber.setDescription("The value of this object is the authorization key sequence number\nfor this FSM.")
docsBpiCmAuthExpires = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthExpires.setDescription("The value of this object is the actual clock time when the current\nauthorization for this FSM expires. If the CM does not have an active\nauthorization, then the value is of the expiration date and time of\nthe last active authorization.")
docsBpiCmAuthReset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmAuthReset.setDescription("Setting this object to TRUE generates a Reauthorize event in the\nauthorization FSM. Reading this object always returns FALSE.")
docsBpiCmAuthGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthGraceTime.setDescription("The value of this object is the grace time for an authorization key.\nA CM is expected to start trying to get a new authorization key\nbeginning AuthGraceTime seconds before the authorization key actually\nexpires.")
docsBpiCmTEKGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKGraceTime.setDescription("The value of this object is the grace time for a TEK.  A CM is\nexpected to start trying to get a new TEK beginning TEKGraceTime\nseconds before the TEK actually expires.")
docsBpiCmAuthWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthWaitTimeout.setDescription("The value of this object is the Authorize Wait Timeout.")
docsBpiCmReauthWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmReauthWaitTimeout.setDescription("The value of this object is the Reauthorize Wait Timeout in seconds.")
docsBpiCmOpWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmOpWaitTimeout.setDescription("The value of this object is the Operational Wait Timeout in seconds.")
docsBpiCmRekeyWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmRekeyWaitTimeout.setDescription("The value of this object is the Rekey Wait Timeout in seconds.")
docsBpiCmAuthRejectWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 600))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthRejectWaitTimeout.setDescription("The value of this object is the Authorization Reject Wait Timeout in\nseconds.")
docsBpiCmAuthRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthRequests.setDescription("The value of this object is the count of times the CM has\ntransmitted an Authorization Request message.")
docsBpiCmAuthReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthReplies.setDescription("The value of this object is the count of times the CM has\nreceived an Authorization Reply message.")
docsBpiCmAuthRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthRejects.setDescription("The value of this object is the count of times the CM has\nreceived an Authorization Reject message.")
docsBpiCmAuthInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthInvalids.setDescription("The value of this object is the count of times the CM has\nreceived an Authorization Invalid message.")
docsBpiCmAuthRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 18), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unauthorizedSid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthRejectErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent Authorization Reject message received by\nthe CM.  This has value unknown(2) if the last Error-Code value was\n0, and none(1) if no Authorization Reject message has been received\nsince reboot.")
docsBpiCmAuthRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 19), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthRejectErrorString.setDescription("The value of this object is the Display-String in most recent\nAuthorization Reject message received by the CM.  This is a zero\nlength string if no Authorization Reject message has been received\nsince reboot.")
docsBpiCmAuthInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,6,5,3,7,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unsolicited", 5), ("invalidKeySequence", 6), ("keyRequestAuthenticationFailure", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthInvalidErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent Authorization Invalid message received by\nthe CM.  This has value unknown(2) if the last Error-Code value was\n0, and none(1) if no Authorization Invalid message has been received\nsince reboot.")
docsBpiCmAuthInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 1, 1, 21), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmAuthInvalidErrorString.setDescription("The value of this object is the Display-String in most recent\nAuthorization Invalid message received by the CM.  This is a zero\n\n\nlength string if no Authorization Invalid message has been received\nsince reboot.")
docsBpiCmTEKTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2))
if mibBuilder.loadTexts: docsBpiCmTEKTable.setDescription("This table describes the attributes of each CM Traffic Encryption Key\n(TEK) association. The CM maintains (no more than) one TEK association\nper SID per CM MAC interface.")
docsBpiCmTEKEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmServiceId"))
if mibBuilder.loadTexts: docsBpiCmTEKEntry.setDescription("Each entry contains objects describing the TEK association attributes\nof one SID. The CM MUST create one entry per unicast SID, regardless\nof whether the SID was obtained from a Registration Response message,\nor from an Authorization Reply message.")
docsBpiCmTEKPrivacyEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKPrivacyEnable.setDescription("This object identifies whether this SID is provisioned to run\nBaseline Privacy. This is analogous to enabling Baseline Privacy on\na provisioned SID using the Class-of-Service Privacy Enable option.\nBaseline Privacy is not effectively enabled for any SID unless\nBaseline Privacy is enabled for the CM, which is managed via the\ndocsBpiCmPrivacyEnable object.")
docsBpiCmTEKState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,2,4,1,5,3,)).subtype(namedValues=namedval.NamedValues(("start", 1), ("opWait", 2), ("opReauthWait", 3), ("operational", 4), ("rekeyWait", 5), ("rekeyReauthWait", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKState.setDescription("The value of this object is the state of the indicated TEK FSM.\nThe start(1) state indicates that FSM is in its initial state.")
docsBpiCmTEKExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKExpiresOld.setDescription("The value of this object is the actual clock time for expiration\nof the immediate predecessor of the most recent TEK for this FSM.\nIf this FSM has only one TEK, then the value is the time of activation\nof this FSM.")
docsBpiCmTEKExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKExpiresNew.setDescription("The value of this object is the actual clock time for expiration\nof the most recent TEK for this FSM.")
docsBpiCmTEKKeyRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKKeyRequests.setDescription("The value of this object is the count of times the CM has transmitted\na Key Request message.")
docsBpiCmTEKKeyReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKKeyReplies.setDescription("The value of this object is the count of times the CM has received\na Key Reply message, including a message whose authentication failed.")
docsBpiCmTEKKeyRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKKeyRejects.setDescription("The value of this object is the count of times the CM has received\na Key Reject message, including a message whose authentication failed.")
docsBpiCmTEKInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKInvalids.setDescription("The value of this object is the count of times the CM has received\na TEK Invalid message, including a message whose authentication failed.")
docsBpiCmTEKAuthPends = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKAuthPends.setDescription("The value of this object is the count of times an Authorization\nPending (Auth Pend) event occurred in this FSM.")
docsBpiCmTEKKeyRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedSid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKKeyRejectErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent Key Reject message received by the CM. This\nhas value unknown(2) if the last Error-Code value was 0, and none(1)\nif no Key Reject message has been received since reboot.")
docsBpiCmTEKKeyRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 11), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKKeyRejectErrorString.setDescription("The value of this object is the Display-String in most recent Key\nReject message received by the CM. This is a zero length string if no\nKey Reject message has been received since reboot.")
docsBpiCmTEKInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,6,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("invalidKeySequence", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKInvalidErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent TEK Invalid message received by the CM.\nThis has value unknown(2) if the last Error-Code value was 0, and\nnone(1) if no TEK Invalid message has been received since reboot.")
docsBpiCmTEKInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 1, 2, 1, 13), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmTEKInvalidErrorString.setDescription("The value of this object is the Display-String in most recent TEK\nInvalid message received by the CM. This is a zero length string if\nno TEK Invalid message has been received since reboot.")
docsBpiCmtsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2))
docsBpiCmtsBaseTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1))
if mibBuilder.loadTexts: docsBpiCmtsBaseTable.setDescription("This table describes the basic Baseline Privacy attributes of each\nCMTS MAC interface.")
docsBpiCmtsBaseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsBpiCmtsBaseEntry.setDescription("Each entry contains objects describing attributes of one CMTS MAC\ninterface. An entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsBpiCmtsDefaultAuthLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 6048000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsDefaultAuthLifetime.setDescription("The value of this object is the default lifetime, in seconds, the\nCMTS assigns to a new authorization key.")
docsBpiCmtsDefaultTEKLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 604800))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsDefaultTEKLifetime.setDescription("The value of this object is the default lifetime, in seconds, the\nCMTS assigns to a new Traffic Encryption Key (TEK).")
docsBpiCmtsDefaultAuthGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsDefaultAuthGraceTime.setDescription("This object was obsoleted because the provisioning system, not the CMTS,\nmanages the authorization key grace time for DOCSIS CMs.")
docsBpiCmtsDefaultTEKGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsDefaultTEKGraceTime.setDescription("This object was obsoleted because the provisioning system, not the CMTS,\nmanages the Traffic Encryption Key (TEK) grace time for DOCSIS CMs.")
docsBpiCmtsAuthRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthRequests.setDescription("The value of this object is the count of times the CMTS has\nreceived an Authorization Request message from any CM.")
docsBpiCmtsAuthReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthReplies.setDescription("The value of this object is the count of times the CMTS has\ntransmitted an Authorization Reply message to any CM.")
docsBpiCmtsAuthRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthRejects.setDescription("The value of this object is the count of times the CMTS has\n\n\ntransmitted an Authorization Reject message to any CM.")
docsBpiCmtsAuthInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthInvalids.setDescription("The value of this object is the count of times the CMTS has\ntransmitted an Authorization Invalid message to any CM.")
docsBpiCmtsAuthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2))
if mibBuilder.loadTexts: docsBpiCmtsAuthTable.setDescription("This table describes the attributes of each CM authorization\nassociation. The CMTS maintains one authorization association with\neach Baseline Privacy-enabled CM on each CMTS MAC interface.")
docsBpiCmtsAuthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-BPI-MIB", "docsBpiCmtsAuthCmMacAddress"))
if mibBuilder.loadTexts: docsBpiCmtsAuthEntry.setDescription("Each entry contains objects describing attributes of one\nauthorization association. The CMTS MUST create one entry per CM per\nMAC interface, based on the receipt of an Authorization Request\nmessage, and MUST not delete the entry before the CM authorization\npermanently expires.")
docsBpiCmtsAuthCmMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmMacAddress.setDescription("The value of this object is the physical address of the CM to\nwhich the authorization association applies.")
docsBpiCmtsAuthCmPublicKey = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(74,74),constraint.ValueSizeConstraint(106,106),constraint.ValueSizeConstraint(140,140),constraint.ValueSizeConstraint(270,270),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmPublicKey.setDescription("The value of this object is a DER-encoded RSAPublicKey ASN.1 type\nstring, as defined in the RSA Encryption Standard (PKCS #1) [22],\ncorresponding to the public key of the CM. The 74, 106, 140, and\n270 byte key encoding lengths correspond to 512 bit, 768 bit, 1024\nbit, and 2048 public moduli respectively. This is a zero-length\nstring if the CMTS does not retain the public key.")
docsBpiCmtsAuthCmKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmKeySequenceNumber.setDescription("The value of this object is the authorization key sequence number\nfor this CM.")
docsBpiCmtsAuthCmExpires = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmExpires.setDescription("The value of this object is the actual clock time when the current\nauthorization for this CM expires. If this CM does not have an\nactive authorization, then the value is of the expiration date and\ntime of the last active authorization.")
docsBpiCmtsAuthCmLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 6048000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmLifetime.setDescription("The value of this object is the lifetime, in seconds, the CMTS\nassigns to an authorization key for this CM.")
docsBpiCmtsAuthCmGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmGraceTime.setDescription("The value of this object is the grace time for the authorization key\nin seconds.  The CM is expected to start trying to get a new\nauthorization key beginning AuthGraceTime seconds before the\nauthorization key actually expires.")
docsBpiCmtsAuthCmReset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,4,1,)).subtype(namedValues=namedval.NamedValues(("noResetRequested", 1), ("invalidateAuth", 2), ("sendAuthInvalid", 3), ("invalidateTeks", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmReset.setDescription("Setting this object to invalidateAuth(2) causes the CMTS to\ninvalidate the current CM authorization key, but not to transmit an\nAuthorization Invalid message nor to invalidate unicast TEKs.  Setting\nthis object to sendAuthInvalid(3) causes the CMTS to invalidate the\ncurrent CM authorization key, and to transmit an Authorization Invalid\nmessage to the CM, but not to invalidate unicast TEKs.  Setting this\nobject to invalidateTeks(4) causes the CMTS to invalidate the current\nCM authorization key, to transmit an Authorization Invalid message to\nthe CM, and to invalidate all unicast TEKs associated with this CM\nauthorization. Reading this object returns the most-recently-set value\nof this object, or returns noResetRequested(1) if the object has not\nbeen set since the last CMTS reboot.")
docsBpiCmtsAuthCmRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmRequests.setDescription("The value of this object is the count of times the CMTS has\nreceived an Authorization Request message from this CM.")
docsBpiCmtsAuthCmReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmReplies.setDescription("The value of this object is the count of times the CMTS has\ntransmitted an Authorization Reply message to this CM.")
docsBpiCmtsAuthCmRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmRejects.setDescription("The value of this object is the count of times the CMTS has\ntransmitted an Authorization Reject message to this CM.")
docsBpiCmtsAuthCmInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthCmInvalids.setDescription("The value of this object is the count of times the CMTS has\ntransmitted an Authorization Invalid message to this CM.")
docsBpiCmtsAuthRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unauthorizedSid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthRejectErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent Authorization Reject message transmitted to\nthe CM.  This has value unknown(2) if the last Error-Code value was\n0, and none(1) if no Authorization Reject message has been transmitted\nto the CM.")
docsBpiCmtsAuthRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 13), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthRejectErrorString.setDescription("The value of this object is the Display-String in most recent\nAuthorization Reject message transmitted to the CM.  This is a\nzero length string if no Authorization Reject message has been\ntransmitted to the CM.")
docsBpiCmtsAuthInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 14), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,6,5,3,7,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unsolicited", 5), ("invalidKeySequence", 6), ("keyRequestAuthenticationFailure", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthInvalidErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in most recent Authorization Invalid message transmitted\nto the CM.  This has value unknown(2) if the last Error-Code value was\n0, and none(1) if no Authorization Invalid message has been\ntransmitted to the CM.")
docsBpiCmtsAuthInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 2, 1, 15), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsAuthInvalidErrorString.setDescription("The value of this object is the Display-String in most recent\nAuthorization Invalid message transmitted to the CM.  This is a\nzero length string if no Authorization Invalid message has been\ntransmitted to the CM.")
docsBpiCmtsTEKTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3))
if mibBuilder.loadTexts: docsBpiCmtsTEKTable.setDescription("This table describes the attributes of each CM Traffic Encryption\nKey (TEK) association. The CMTS maintains one TEK association per BPI\nSID on each CMTS MAC interface.")
docsBpiCmtsTEKEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsServiceId"))
if mibBuilder.loadTexts: docsBpiCmtsTEKEntry.setDescription("Each entry contains objects describing attributes of one TEK\nassociation on a particular CMTS MAC interface. The CMTS MUST create\none entry per SID per MAC interface, based on the receipt of an\nKey Request message, and MUST not delete the entry before the CM\nauthorization for the SID permanently expires.")
docsBpiCmtsTEKLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 604800))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsTEKLifetime.setDescription("The value of this object is the lifetime, in seconds, the CMTS assigns\nto keys for this TEK association.")
docsBpiCmtsTEKGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1800))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKGraceTime.setDescription("The value of this object is the grace time for the TEK in seconds.\nThe CM is expected to start trying to get a new TEK beginning\nTEKGraceTime seconds before the TEK actually expires.")
docsBpiCmtsTEKExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKExpiresOld.setDescription("The value of this object is the actual clock time for expiration\nof the immediate predecessor of the most recent TEK for this FSM.\nIf this FSM has only one TEK, then the value is the time of activation\nof this FSM.")
docsBpiCmtsTEKExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKExpiresNew.setDescription("The value of this object is the actual clock time for expiration\nof the most recent TEK for this FSM.")
docsBpiCmtsTEKReset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpiCmtsTEKReset.setDescription("Setting this object to TRUE causes the CMTS to invalidate the current\nactive TEK(s) (plural due to key transition periods), and to generate\na new TEK for the associated SID; the CMTS MAY also generate an\nunsolicited TEK Invalid message, to optimize the TEK synchronization\n\n\nbetween the CMTS and the CM. Reading this object always returns\nFALSE.")
docsBpiCmtsKeyRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsKeyRequests.setDescription("The value of this object is the count of times the CMTS has\nreceived a Key Request message.")
docsBpiCmtsKeyReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsKeyReplies.setDescription("The value of this object is the count of times the CMTS has\ntransmitted a Key Reply message.")
docsBpiCmtsKeyRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsKeyRejects.setDescription("The value of this object is the count of times the CMTS has\ntransmitted a Key Reject message.")
docsBpiCmtsTEKInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKInvalids.setDescription("The value of this object is the count of times the CMTS has\ntransmitted a TEK Invalid message.")
docsBpiCmtsKeyRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("unauthorizedSid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsKeyRejectErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in the most recent Key Reject message sent in response to\na Key Request for this BPI SID. This has value unknown(2) if the last\nError-Code value was 0, and none(1) if no Key Reject message has been\nreceived since reboot.")
docsBpiCmtsKeyRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 11), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsKeyRejectErrorString.setDescription("The value of this object is the Display-String in the most recent\nKey Reject message sent in response to a Key Request for this BPI\nSID.  This is a zero length string if no Key Reject message has been\nreceived since reboot.")
docsBpiCmtsTEKInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,6,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("unknown", 2), ("invalidKeySequence", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKInvalidErrorCode.setDescription("The value of this object is the enumerated description of the\nError-Code in the most recent TEK Invalid message sent in association\nwith this BPI SID.  This has value unknown(2) if the last Error-Code\nvalue was 0, and none(1) if no TEK Invalid message has been received\n\n\nsince reboot.")
docsBpiCmtsTEKInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 3, 1, 13), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpiCmtsTEKInvalidErrorString.setDescription("The value of this object is the Display-String in the most recent TEK\nInvalid message sent in association with this BPI SID.  This is a zero\nlength string if no TEK Invalid message has been received since reboot.")
docsBpiMulticastControl = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4))
docsBpiIpMulticastMapTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1))
if mibBuilder.loadTexts: docsBpiIpMulticastMapTable.setDescription("This table describes the mapping of IP multicast address prefixes to\nmulticast SIDs on each CMTS MAC interface.")
docsBpiIpMulticastMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-BPI-MIB", "docsBpiIpMulticastAddress"), (0, "DOCS-BPI-MIB", "docsBpiIpMulticastPrefixLength"))
if mibBuilder.loadTexts: docsBpiIpMulticastMapEntry.setDescription("Each entry contains objects describing the mapping of one IP\nmulticast address prefix to one multicast SID on one CMTS MAC\ninterface. The CMTS uses the mapping when forwarding downstream IP\nmulticast traffic.")
docsBpiIpMulticastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpiIpMulticastAddress.setDescription("This object represents the IP multicast address (prefix) to be\nmapped by this row, in conjunction with\ndocsBpiIpMulticastPrefixLength.")
docsBpiIpMulticastPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpiIpMulticastPrefixLength.setDescription("This object represents the IP multicast address prefix length\nfor this row. The value of this object represents the length in\nbits of docsBpiIpMulticastAddress for multicast address\ncomparisons, using big-endian ordering. An IP multicast address\nmatches this row if the (docsBpiIpMulticastPrefixLength) most\nsignificant bits of the IP multicast address and of the\n(docsBpiIpMulticastAddress) are identical.\nThis object is similar in usage to an IP address mask. The value\n0 corresponds to IP address mask 0.0.0.0, the value 1 corresponds\nto IP address mask 128.0.0.0, the value 8 corresponds to IP\naddress mask 255.0.0.0, and the value 32 corresponds to IP\naddress mask 255.255.255.255.")
docsBpiIpMulticastServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(8192, 16368))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpiIpMulticastServiceId.setDescription("This object represents the multicast SID to be used in this\nIP multicast address prefix mapping entry.")
docsBpiIpMulticastMapControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpiIpMulticastMapControl.setDescription("This object controls and reflects the IP multicast address prefix\nmapping entry. There is no restriction on the ability to change values\nin this row while the row is active.")
docsBpiMulticastAuthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 2))
if mibBuilder.loadTexts: docsBpiMulticastAuthTable.setDescription("This table describes the multicast SID authorization for each\nCM on each CMTS MAC interface.")
docsBpiMulticastAuthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-BPI-MIB", "docsBpiMulticastServiceId"), (0, "DOCS-BPI-MIB", "docsBpiMulticastCmMacAddress"))
if mibBuilder.loadTexts: docsBpiMulticastAuthEntry.setDescription("Each entry contains objects describing the key authorization of one\ncable modem for one multicast SID for one CMTS MAC interface.")
docsBpiMulticastServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(8192, 16368))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpiMulticastServiceId.setDescription("This object represents the multicast SID for authorization.")
docsBpiMulticastCmMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 2, 1, 2), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpiMulticastCmMacAddress.setDescription("This object represents the MAC address of the CM to which the\nmulticast SID authorization applies.")
docsBpiMulticastAuthControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 5, 1, 2, 4, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpiMulticastAuthControl.setDescription("This object controls and reflects the CM authorization for each\nmulticast SID. There is no restriction on the ability to change\nvalues in this row while the row is active.")
docsBpiNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 2))
docsBpiConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 3))
docsBpiCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 3, 1))
docsBpiGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 5, 3, 2))

# Augmentions

# Groups

docsBpiObsoleteObjectsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 5, 3, 2, 3)).setObjects(("DOCS-BPI-MIB", "docsBpiCmtsDefaultAuthGraceTime"), ("DOCS-BPI-MIB", "docsBpiCmtsDefaultTEKGraceTime"), )
docsBpiCmtsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 5, 3, 2, 2)).setObjects(("DOCS-BPI-MIB", "docsBpiCmtsAuthCmRequests"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthReplies"), ("DOCS-BPI-MIB", "docsBpiCmtsDefaultTEKLifetime"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthRequests"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKExpiresOld"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKInvalidErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmtsDefaultAuthLifetime"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmReset"), ("DOCS-BPI-MIB", "docsBpiCmtsKeyRejectErrorString"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKExpiresNew"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthInvalids"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKInvalidErrorString"), ("DOCS-BPI-MIB", "docsBpiIpMulticastServiceId"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthRejects"), ("DOCS-BPI-MIB", "docsBpiIpMulticastMapControl"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKGraceTime"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthRejectErrorString"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthInvalidErrorString"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmGraceTime"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKInvalids"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmExpires"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthInvalidErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmtsKeyRequests"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmKeySequenceNumber"), ("DOCS-BPI-MIB", "docsBpiCmtsKeyRejects"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmReplies"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKLifetime"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmLifetime"), ("DOCS-BPI-MIB", "docsBpiCmtsKeyReplies"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthRejectErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmRejects"), ("DOCS-BPI-MIB", "docsBpiCmtsTEKReset"), ("DOCS-BPI-MIB", "docsBpiCmtsKeyRejectErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmInvalids"), ("DOCS-BPI-MIB", "docsBpiMulticastAuthControl"), ("DOCS-BPI-MIB", "docsBpiCmtsAuthCmPublicKey"), )
docsBpiCmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 5, 3, 2, 1)).setObjects(("DOCS-BPI-MIB", "docsBpiCmAuthGraceTime"), ("DOCS-BPI-MIB", "docsBpiCmTEKKeyRequests"), ("DOCS-BPI-MIB", "docsBpiCmTEKExpiresOld"), ("DOCS-BPI-MIB", "docsBpiCmTEKInvalidErrorString"), ("DOCS-BPI-MIB", "docsBpiCmAuthRejectErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmTEKKeyReplies"), ("DOCS-BPI-MIB", "docsBpiCmRekeyWaitTimeout"), ("DOCS-BPI-MIB", "docsBpiCmPrivacyEnable"), ("DOCS-BPI-MIB", "docsBpiCmOpWaitTimeout"), ("DOCS-BPI-MIB", "docsBpiCmTEKKeyRejects"), ("DOCS-BPI-MIB", "docsBpiCmAuthRejects"), ("DOCS-BPI-MIB", "docsBpiCmAuthInvalidErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmTEKGraceTime"), ("DOCS-BPI-MIB", "docsBpiCmPublicKey"), ("DOCS-BPI-MIB", "docsBpiCmAuthRejectErrorString"), ("DOCS-BPI-MIB", "docsBpiCmAuthExpires"), ("DOCS-BPI-MIB", "docsBpiCmTEKPrivacyEnable"), ("DOCS-BPI-MIB", "docsBpiCmAuthInvalids"), ("DOCS-BPI-MIB", "docsBpiCmAuthReplies"), ("DOCS-BPI-MIB", "docsBpiCmTEKInvalidErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmTEKKeyRejectErrorCode"), ("DOCS-BPI-MIB", "docsBpiCmAuthRejectWaitTimeout"), ("DOCS-BPI-MIB", "docsBpiCmAuthKeySequenceNumber"), ("DOCS-BPI-MIB", "docsBpiCmAuthRequests"), ("DOCS-BPI-MIB", "docsBpiCmTEKExpiresNew"), ("DOCS-BPI-MIB", "docsBpiCmTEKKeyRejectErrorString"), ("DOCS-BPI-MIB", "docsBpiCmAuthWaitTimeout"), ("DOCS-BPI-MIB", "docsBpiCmAuthInvalidErrorString"), ("DOCS-BPI-MIB", "docsBpiCmTEKAuthPends"), ("DOCS-BPI-MIB", "docsBpiCmAuthReset"), ("DOCS-BPI-MIB", "docsBpiCmTEKInvalids"), ("DOCS-BPI-MIB", "docsBpiCmAuthState"), ("DOCS-BPI-MIB", "docsBpiCmReauthWaitTimeout"), ("DOCS-BPI-MIB", "docsBpiCmTEKState"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DOCS-BPI-MIB", PYSNMP_MODULE_ID=docsBpiMIB)

# Objects
mibBuilder.exportSymbols("DOCS-BPI-MIB", docsBpiMIB=docsBpiMIB, docsBpiMIBObjects=docsBpiMIBObjects, docsBpiCmObjects=docsBpiCmObjects, docsBpiCmBaseTable=docsBpiCmBaseTable, docsBpiCmBaseEntry=docsBpiCmBaseEntry, docsBpiCmPrivacyEnable=docsBpiCmPrivacyEnable, docsBpiCmPublicKey=docsBpiCmPublicKey, docsBpiCmAuthState=docsBpiCmAuthState, docsBpiCmAuthKeySequenceNumber=docsBpiCmAuthKeySequenceNumber, docsBpiCmAuthExpires=docsBpiCmAuthExpires, docsBpiCmAuthReset=docsBpiCmAuthReset, docsBpiCmAuthGraceTime=docsBpiCmAuthGraceTime, docsBpiCmTEKGraceTime=docsBpiCmTEKGraceTime, docsBpiCmAuthWaitTimeout=docsBpiCmAuthWaitTimeout, docsBpiCmReauthWaitTimeout=docsBpiCmReauthWaitTimeout, docsBpiCmOpWaitTimeout=docsBpiCmOpWaitTimeout, docsBpiCmRekeyWaitTimeout=docsBpiCmRekeyWaitTimeout, docsBpiCmAuthRejectWaitTimeout=docsBpiCmAuthRejectWaitTimeout, docsBpiCmAuthRequests=docsBpiCmAuthRequests, docsBpiCmAuthReplies=docsBpiCmAuthReplies, docsBpiCmAuthRejects=docsBpiCmAuthRejects, docsBpiCmAuthInvalids=docsBpiCmAuthInvalids, docsBpiCmAuthRejectErrorCode=docsBpiCmAuthRejectErrorCode, docsBpiCmAuthRejectErrorString=docsBpiCmAuthRejectErrorString, docsBpiCmAuthInvalidErrorCode=docsBpiCmAuthInvalidErrorCode, docsBpiCmAuthInvalidErrorString=docsBpiCmAuthInvalidErrorString, docsBpiCmTEKTable=docsBpiCmTEKTable, docsBpiCmTEKEntry=docsBpiCmTEKEntry, docsBpiCmTEKPrivacyEnable=docsBpiCmTEKPrivacyEnable, docsBpiCmTEKState=docsBpiCmTEKState, docsBpiCmTEKExpiresOld=docsBpiCmTEKExpiresOld, docsBpiCmTEKExpiresNew=docsBpiCmTEKExpiresNew, docsBpiCmTEKKeyRequests=docsBpiCmTEKKeyRequests, docsBpiCmTEKKeyReplies=docsBpiCmTEKKeyReplies, docsBpiCmTEKKeyRejects=docsBpiCmTEKKeyRejects, docsBpiCmTEKInvalids=docsBpiCmTEKInvalids, docsBpiCmTEKAuthPends=docsBpiCmTEKAuthPends, docsBpiCmTEKKeyRejectErrorCode=docsBpiCmTEKKeyRejectErrorCode, docsBpiCmTEKKeyRejectErrorString=docsBpiCmTEKKeyRejectErrorString, docsBpiCmTEKInvalidErrorCode=docsBpiCmTEKInvalidErrorCode, docsBpiCmTEKInvalidErrorString=docsBpiCmTEKInvalidErrorString, docsBpiCmtsObjects=docsBpiCmtsObjects, docsBpiCmtsBaseTable=docsBpiCmtsBaseTable, docsBpiCmtsBaseEntry=docsBpiCmtsBaseEntry, docsBpiCmtsDefaultAuthLifetime=docsBpiCmtsDefaultAuthLifetime, docsBpiCmtsDefaultTEKLifetime=docsBpiCmtsDefaultTEKLifetime, docsBpiCmtsDefaultAuthGraceTime=docsBpiCmtsDefaultAuthGraceTime, docsBpiCmtsDefaultTEKGraceTime=docsBpiCmtsDefaultTEKGraceTime, docsBpiCmtsAuthRequests=docsBpiCmtsAuthRequests, docsBpiCmtsAuthReplies=docsBpiCmtsAuthReplies, docsBpiCmtsAuthRejects=docsBpiCmtsAuthRejects, docsBpiCmtsAuthInvalids=docsBpiCmtsAuthInvalids, docsBpiCmtsAuthTable=docsBpiCmtsAuthTable, docsBpiCmtsAuthEntry=docsBpiCmtsAuthEntry, docsBpiCmtsAuthCmMacAddress=docsBpiCmtsAuthCmMacAddress, docsBpiCmtsAuthCmPublicKey=docsBpiCmtsAuthCmPublicKey, docsBpiCmtsAuthCmKeySequenceNumber=docsBpiCmtsAuthCmKeySequenceNumber, docsBpiCmtsAuthCmExpires=docsBpiCmtsAuthCmExpires, docsBpiCmtsAuthCmLifetime=docsBpiCmtsAuthCmLifetime, docsBpiCmtsAuthCmGraceTime=docsBpiCmtsAuthCmGraceTime, docsBpiCmtsAuthCmReset=docsBpiCmtsAuthCmReset, docsBpiCmtsAuthCmRequests=docsBpiCmtsAuthCmRequests, docsBpiCmtsAuthCmReplies=docsBpiCmtsAuthCmReplies, docsBpiCmtsAuthCmRejects=docsBpiCmtsAuthCmRejects, docsBpiCmtsAuthCmInvalids=docsBpiCmtsAuthCmInvalids, docsBpiCmtsAuthRejectErrorCode=docsBpiCmtsAuthRejectErrorCode, docsBpiCmtsAuthRejectErrorString=docsBpiCmtsAuthRejectErrorString, docsBpiCmtsAuthInvalidErrorCode=docsBpiCmtsAuthInvalidErrorCode, docsBpiCmtsAuthInvalidErrorString=docsBpiCmtsAuthInvalidErrorString, docsBpiCmtsTEKTable=docsBpiCmtsTEKTable, docsBpiCmtsTEKEntry=docsBpiCmtsTEKEntry, docsBpiCmtsTEKLifetime=docsBpiCmtsTEKLifetime, docsBpiCmtsTEKGraceTime=docsBpiCmtsTEKGraceTime, docsBpiCmtsTEKExpiresOld=docsBpiCmtsTEKExpiresOld, docsBpiCmtsTEKExpiresNew=docsBpiCmtsTEKExpiresNew, docsBpiCmtsTEKReset=docsBpiCmtsTEKReset, docsBpiCmtsKeyRequests=docsBpiCmtsKeyRequests, docsBpiCmtsKeyReplies=docsBpiCmtsKeyReplies, docsBpiCmtsKeyRejects=docsBpiCmtsKeyRejects, docsBpiCmtsTEKInvalids=docsBpiCmtsTEKInvalids, docsBpiCmtsKeyRejectErrorCode=docsBpiCmtsKeyRejectErrorCode, docsBpiCmtsKeyRejectErrorString=docsBpiCmtsKeyRejectErrorString, docsBpiCmtsTEKInvalidErrorCode=docsBpiCmtsTEKInvalidErrorCode, docsBpiCmtsTEKInvalidErrorString=docsBpiCmtsTEKInvalidErrorString, docsBpiMulticastControl=docsBpiMulticastControl, docsBpiIpMulticastMapTable=docsBpiIpMulticastMapTable, docsBpiIpMulticastMapEntry=docsBpiIpMulticastMapEntry, docsBpiIpMulticastAddress=docsBpiIpMulticastAddress, docsBpiIpMulticastPrefixLength=docsBpiIpMulticastPrefixLength, docsBpiIpMulticastServiceId=docsBpiIpMulticastServiceId, docsBpiIpMulticastMapControl=docsBpiIpMulticastMapControl, docsBpiMulticastAuthTable=docsBpiMulticastAuthTable, docsBpiMulticastAuthEntry=docsBpiMulticastAuthEntry, docsBpiMulticastServiceId=docsBpiMulticastServiceId, docsBpiMulticastCmMacAddress=docsBpiMulticastCmMacAddress, docsBpiMulticastAuthControl=docsBpiMulticastAuthControl, docsBpiNotification=docsBpiNotification, docsBpiConformance=docsBpiConformance, docsBpiCompliances=docsBpiCompliances, docsBpiGroups=docsBpiGroups)

# Groups
mibBuilder.exportSymbols("DOCS-BPI-MIB", docsBpiObsoleteObjectsGroup=docsBpiObsoleteObjectsGroup, docsBpiCmtsGroup=docsBpiCmtsGroup, docsBpiCmGroup=docsBpiCmGroup)
