# PySNMP SMI module. Autogenerated from smidump -f python DOCS-IF-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:17 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "transmission")
( MacAddress, RowStatus, StorageType, TextualConvention, TimeInterval, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "RowStatus", "StorageType", "TextualConvention", "TimeInterval", "TimeStamp", "TruthValue")

# Types

class DocsEqualizerData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(36,260),)
    pass

class DocsisQosVersion(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,)
    namedValues = namedval.NamedValues(("docsis10", 1), ("docsis11", 2), )
    pass

class DocsisUpstreamType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(0,1,2,4,3,)
    namedValues = namedval.NamedValues(("unknown", 0), ("tdma", 1), ("atdma", 2), ("scdma", 3), ("tdmaAndAtdma", 4), )
    pass

class DocsisVersion(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,1,2,)
    namedValues = namedval.NamedValues(("docsis10", 1), ("docsis11", 2), ("docsis20", 3), )
    pass

class TenthdB(TextualConvention, Integer32):
    displayHint = "d-1"
    pass

class TenthdBmV(TextualConvention, Integer32):
    displayHint = "d-1"
    pass


# Objects

docsIfMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 127)).setRevisions(("2006-05-24 00:00","1999-08-19 00:00",))
if mibBuilder.loadTexts: docsIfMib.setOrganization("IETF IPCDN Working Group")
if mibBuilder.loadTexts: docsIfMib.setContactInfo("        David Raftus\nPostal: ATI Technologies Inc.\n        340 Terry Fox Drive, Suite 202\n        Ottawa Ontario\n        Canada\nPhone:  +1 613 592 1052 ext.222\nE-mail: david.raftus@ati.com\n\n        Eduardo Cardona\nPostal: Cable Television Laboratories, Inc.\n        858 Coal Creek Circle\n        Louisville, CO 80027-9750\n        U.S.A.\nPhone:  Tel:    +1 303 661 9100\n        Fax:    +1 303 661 9199\nE-mail: e.cardona@cablelabs.com;mibs@cablelabs.com\n\nIETF IPCDN Working Group\nGeneral Discussion: ipcdn@ietf.org\nSubscribe: http://www.ietf.org/mailman/listinfo/ipcdn\nArchive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn\nCo-chairs: Richard Woundy, Richard_Woundy@cable.comcast.com\n           Jean-Francois Mule, jf.mule@cablelabs.com")
if mibBuilder.loadTexts: docsIfMib.setDescription("This is the MIB Module for DOCSIS 2.0-compliant Radio\nFrequency (RF) interfaces in Cable Modems and\nCable Modem Termination Systems.\n\nCopyright (C) The Internet Society (2006).  This\nversion of this MIB module is part of RFC 4546; see\nthe RFC itself for full legal notices.")
docsIfMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1))
docsIfBaseObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 1))
docsIfDownstreamChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1))
if mibBuilder.loadTexts: docsIfDownstreamChannelTable.setDescription("This table describes the attributes of downstream\nchannels (frequency bands).")
docsIfDownstreamChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfDownstreamChannelEntry.setDescription("An entry provides a list of attributes for a single\ndownstream channel.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableDownstream(128).")
docsIfDownChannelId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelId.setDescription("The Cable Modem Termination System identification of the\ndownstream channel within this particular MAC interface.\nif the interface is down, the object returns the most\ncurrent value.  If the downstream channel ID is unknown,\nthis object returns a value of 0.")
docsIfDownChannelFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1000000000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelFrequency.setDescription("The center of the downstream frequency associated with\nthis channel.  This object will return the current tuner\n\n\n\nfrequency.  If a CMTS provides IF output, this object\nwill return 0, unless this CMTS is in control of the\nfinal downstream frequency.  See the associated\ncompliance object for a description of valid frequencies\nthat may be written to this object.")
docsIfDownChannelWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16000000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelWidth.setDescription("The bandwidth of this downstream channel.  Most\nimplementations are expected to support a channel width\nof 6 MHz (North America) and/or 8 MHz (Europe).  See the\nassociated compliance object for a description of the\nvalid channel widths for this object.")
docsIfDownChannelModulation = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("other", 2), ("qam64", 3), ("qam256", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelModulation.setDescription("The modulation type associated with this downstream\nchannel.  If the interface is down, this object either\nreturns the configured value (CMTS), the most current\nvalue (CM), or the value of unknown(1).  See the\nassociated conformance object for write conditions and\nlimitations.  See the reference for specifics on the\nmodulation profiles implied by qam64 and qam256.")
docsIfDownChannelInterleave = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(7,1,3,8,2,5,6,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("other", 2), ("taps8Increment16", 3), ("taps16Increment8", 4), ("taps32Increment4", 5), ("taps64Increment2", 6), ("taps128Increment1", 7), ("taps12increment17", 8), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelInterleave.setDescription("The Forward Error Correction (FEC) interleaving used\nfor this downstream channel.\nValues are defined as follows:\ntaps8Increment16(3):   protection 5.9/4.1 usec,\n                       latency .22/.15 msec\ntaps16Increment8(4):   protection 12/8.2 usec,\n                       latency .48/.33 msec\ntaps32Increment4(5):   protection 24/16 usec,\n                       latency .98/.68 msec\ntaps64Increment2(6):   protection 47/33 usec,\n                       latency 2/1.4 msec\ntaps128Increment1(7):  protection 95/66 usec,\n                       latency 4/2.8 msec\ntaps12increment17(8):  protection 18/14 usec,\n                       latency 0.43/0.32 msec\n\nThe value 'taps12increment17' is supported by EuroDOCSIS\ncable systems only, and the others by DOCSIS cable systems.\n\nIf the interface is down, this object either returns\nthe configured value (CMTS), the most current value (CM),\nor the value of unknown(1).\nThe value of other(2) is returned if the interleave\nis known but not defined in the above list.\nSee the associated conformance object for write\nconditions and limitations.  See the reference for the FEC\nconfiguration described by the setting of this object.")
docsIfDownChannelPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 6), TenthdBmV()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelPower.setDescription("At the CMTS, the operational transmit power.  At the CM,\nthe received power level.\nIf the interface is down, this object either returns\nthe configured value (CMTS), the most current value (CM)\nor the value of 0.  See the associated conformance object\nfor write conditions and limitations.  See the reference\nfor recommended and required power levels.")
docsIfDownChannelAnnex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,5,1,2,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("other", 2), ("annexA", 3), ("annexB", 4), ("annexC", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelAnnex.setDescription("The value of this object indicates the conformance of\nthe implementation to important regional cable standards.\nannexA : Annex A from ITU-T J.83 is used.\n         (equivalent to EN 300 429)\nannexB : Annex B from ITU-T J.83 is used.\nannexC : Annex C from ITU-T J.83 is used.")
docsIfDownChannelStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 8), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelStorageType.setDescription("The storage type for this conceptual row.\nEntries with this object set to permanent(4)\ndo not require write operations for read-write\nobjects.")
docsIfUpstreamChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2))
if mibBuilder.loadTexts: docsIfUpstreamChannelTable.setDescription("This table describes the attributes of attached upstream\nchannels.")
docsIfUpstreamChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfUpstreamChannelEntry.setDescription("List of attributes for a single upstream channel.  For\nDOCSIS 2.0 CMTSs, an entry in this table exists for\neach ifEntry with an ifType of docsCableUpstreamChannel\n(205).\nFor DOCSIS 1.x CM/CMTSs and DOCSIS 2.0 CMs, an entry in\nthis table exists for each ifEntry with an ifType of\ndocsCableUpstream (129).\n\nFor DOCSIS 2.0 CMTSs, two classes of interfaces can be\ndefined for this table:\n o Upstream Physical Interfaces: The traditional DOCSIS\n   1.x CMTS upstream interface ifType 129 and the DOCSIS\n   2.0 ifType 205 that are functional.  In other words,\n   interfaces that represent upstream receivers within\n   an RF MAC interface.\n   Entries of physical interfaces are exposed to the\n   management interface with their corresponding\n   ifStack hierarchy and are not administratively\n   created by this table.\n\n\n\n\n o Upstream Temporary Interfaces: A fictitious\n   interface created for the purpose of manipulating\n   physical interface parameters offline, then\n   validating prior to updating the target physical\n   interface.\n\nIn case of a reinitialization of the managed system,\nphysical interfaces values persist while the temporary\ninterfaces are not recreated.\n\nThis mechanism helps to minimize service disruptions\noriginating in situations where a group of interface\nparameter values need to be consistent with each other\nin SET operations.  A temporary buffer\n(temporary interface) is provided to allow the CMTS\nto validate the parameters offline.")
docsIfUpChannelId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelId.setDescription("The CMTS identification of the upstream channel.")
docsIfUpChannelFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1000000000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelFrequency.setDescription("The center of the frequency band associated with this\nupstream interface.  This object returns 0 if the frequency\nis undefined or unknown.  Minimum permitted upstream\nfrequency is 5,000,000 Hz for current technology.  See\nthe associated conformance object for write conditions\nand limitations.")
docsIfUpChannelWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 64000000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelWidth.setDescription("The bandwidth of this upstream interface.  This object\nreturns 0 if the interface width is undefined or unknown.\nMinimum permitted interface width is currently 200,000 Hz.\nSee the associated conformance object for write conditions\nand limitations.")
docsIfUpChannelModulationProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelModulationProfile.setDescription("An entry identical to the docsIfModIndex in the\ndocsIfCmtsModulationTable that describes this channel.\nThis channel is further instantiated there by a grouping\nof interval usage codes (IUCs) that, together, fully\ndescribe the channel modulation.  This object returns 0 if\nthe docsIfCmtsModulationTable entry does not exist or is\nempty.  See the associated conformance object for write\nconditions and limitations.\n\n\n\nSetting this object returns an 'inconsistentValue'\nerror if the following conditions are not satisfied:\n1. All the IUC entries in the selected modulation profile\nMUST have the same value of docsIfCmtsModChannelType.\n2. All of the Modulation parameters in the selected\nmodulation profile MUST be consistent with the other\nparameters in this docsIfUpstreamChannelEntry.")
docsIfUpChannelSlotSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelSlotSize.setDescription("Applicable to TDMA and ATDMA channel types only.\nThe number of 6.25 microsecond ticks in each upstream\nmini-slot.  Returns zero if the value is undefined or\nunknown or in case of an SCDMA channel.\nSee the associated conformance object for write\nconditions and limitations.")
docsIfUpChannelTxTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelTxTimingOffset.setDescription("At the CM, a measure of the current round trip time\nobtained from the ranging offset (initial ranging offset +\nranging offset adjustments).\nAt the CMTS, the maximum of timing offset, among all the\nCMs that are/were present on the channel, taking into\naccount all ( initial + periodic ) timing offset\ncorrections that were sent for each of the CMs.  Generally,\nthese measurements are positive, but if the measurements\nare negative, the value of this object is zero.  Used for\ntiming of CM upstream transmissions to ensure synchronized\narrivals at the CMTS.\nUnits are one 64th fraction of 6.25 microseconds.")
docsIfUpChannelRangingBackoffStart = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelRangingBackoffStart.setDescription("The initial random backoff window to use when retrying\nRanging Requests.  Expressed as a power of 2.  A value of\n16 at the CMTS indicates that a proprietary adaptive retry\nmechanism is to be used.  See the associated conformance\nobject for write conditions and limitations.")
docsIfUpChannelRangingBackoffEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelRangingBackoffEnd.setDescription("The final random backoff window to use when retrying\nRanging Requests.  Expressed as a power of 2.  A value of\n16 at the CMTS indicates that a proprietary adaptive retry\nmechanism is to be used.  See the associated conformance\nobject for write conditions and limitations.")
docsIfUpChannelTxBackoffStart = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelTxBackoffStart.setDescription("The initial random backoff window to use when retrying\ntransmissions.  Expressed as a power of 2.  A value of 16\nat the CMTS indicates that a proprietary adaptive retry\nmechanism is to be used.  See the associated conformance\nobject for write conditions and limitations.")
docsIfUpChannelTxBackoffEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelTxBackoffEnd.setDescription("The final random backoff window to use when retrying\ntransmissions.  Expressed as a power of 2.  A value of 16\nat the CMTS indicates that a proprietary adaptive retry\nmechanism is to be used.  See the associated conformance\nobject for write conditions and limitations.")
docsIfUpChannelScdmaActiveCodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(64,66),constraint.ValueRangeConstraint(68,70),constraint.ValueRangeConstraint(72,72),constraint.ValueRangeConstraint(74,78),constraint.ValueRangeConstraint(80,82),constraint.ValueRangeConstraint(84,88),constraint.ValueRangeConstraint(90,96),constraint.ValueRangeConstraint(98,100),constraint.ValueRangeConstraint(102,102),constraint.ValueRangeConstraint(104,106),constraint.ValueRangeConstraint(108,108),constraint.ValueRangeConstraint(110,112),constraint.ValueRangeConstraint(114,126),constraint.ValueRangeConstraint(128,128),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaActiveCodes.setDescription("Applicable for SCDMA channel types only.\nNumber of active codes.  Returns zero for\nNon-SCDMA channel types.  Note that legal\nvalues from 64..128 MUST be non-prime.")
docsIfUpChannelScdmaCodesPerSlot = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(2,32),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaCodesPerSlot.setDescription("Applicable for SCDMA channel types only.\nThe number of SCDMA codes per mini-slot.\nReturns zero if the value is undefined or unknown or in\n\n\n\ncase of a TDMA or ATDMA channel.")
docsIfUpChannelScdmaFrameSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaFrameSize.setDescription("Applicable for SCDMA channel types only.\nSCDMA Frame size in units of spreading intervals.\nThis value returns zero for non-SCDMA Profiles.")
docsIfUpChannelScdmaHoppingSeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaHoppingSeed.setDescription("Applicable for SCDMA channel types only.\n15-bit seed used for code hopping sequence initialization.\nReturns zero for non-SCDMA channel types.\nSetting this value to a value different than zero for\nnon-SCDMA channel types returns the error 'wrongValue'.")
docsIfUpChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 15), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelType.setDescription("Reflects the Upstream channel type.\nThis object returns the value of docsIfCmtsModChannelType\nfor the modulation profile selected in\ndocsIfUpChannelModulationProfile for this row.")
docsIfUpChannelCloneFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 16), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelCloneFrom.setDescription("This object contains the ifIndex value of the physical\ninterface row entry whose parameters are to be adjusted.\n\nUpon setting this object to the ifIndex value of a\nphysical interface, the following interface objects values\nare copied to this entry:\ndocsIfUpChannelFrequency,\ndocsIfUpChannelWidth,\ndocsIfUpChannelModulationProfile,\ndocsIfUpChannelSlotSize,\ndocsIfUpChannelRangingBackoffStart,\ndocsIfUpChannelRangingBackoffEnd,\ndocsIfUpChannelTxBackoffStart,\ndocsIfUpChannelTxBackoffEnd,\ndocsIfUpChannelScdmaActiveCodes,\ndocsIfUpChannelScdmaCodesPerSlot,\ndocsIfUpChannelScdmaFrameSize,\ndocsIfUpChannelScdmaHoppingSeed,\ndocsIfUpChannelType, and\ndocsIfUpChannelPreEqEnable\nSetting this object to the value of a non-existent or\na temporary upstream interface returns the error\n'wrongValue'.\nThis object MUST contain a value of zero for physical\ninterfaces entries.\nSetting this object in row entries that correspond to\nphysical interfaces returns the error 'wrongValue'.")
docsIfUpChannelUpdate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 17), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelUpdate.setDescription("Used to perform the copy of adjusted parameters from the\ntemporary interface entry to the physical interface\nindicated by the docsIfUpChannelCloneFrom object.  The\ntransfer is initiated through an SNMP SET to 'true' of\n\n\n\nthis object.\nA SET to 'true' fails and returns error 'commitFailed'\nif docsIfUpChannelStatus value is 'notInService', which\nmeans that the interface parameters values are not\ncompatible with each other or have not been validated yet.\nReading this object always returns 'false'.")
docsIfUpChannelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 18), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelStatus.setDescription("This object is only used for the creation of a temporary\nupstream row with the purpose of updating the parameters\nof a physical upstream channel entry.\n\nThe following restrictions apply to this object:\n1. This object is not writable for physical interfaces.\n2. Temporary interface entries are only created by a SET\n   of this object to createandWait(5).\n3. ifAdminStatus from the Interface MIB RFC 2863 is used\n   to take a physical upstream channel offline, to be\n   consistent with DOCSIS 1.x operation, as indicated in\n   RFC 2670.\n   In addition,\n    o ifAdminStatus 'down' is reflected in this object\n      as 'notInService'.\n    o ifOperStatus 'down' while ifAdminStatus 'up' is\n      reflected in this object as 'notInservice'.\n4. Temporary created rows MUST be set to 'active' with\n   the purpose of validating upstream parameter\n   consistency prior to transferring the parameters to the\n   physical interface.\n\nBelow is a mandatory procedure for adjusting the values\nof a physical interface:\n1. Create a temporary interface entry through an SNMP SET\n   using 'createAndWait'.  At this point, the RowStatus\n   reports 'notReady'.\n   The Manager entity uses an ifIndex value outside the\n   operational range of the physical interfaces for the\n   creation of a temporary interface.\n2. Set the docsIfUpChannelCloneFrom object to the ifIndex\n   value of the physical row to update.  Now\n   docsIfUpChannelStatus reports 'notInService'.\n3. Change the upstream parameters to the desired values\n   in the temporary row.\n\n\n\n4. Validate that all parameters are consistent by setting\n   docsIfUpChannelStatus to 'active'.  A failure to set the\n   RowStatus to 'active' returns the error 'commitFailed',\n   which means the parameters are not compatible with the\n   target physical interface.\n5. With docsIfUpChannelStatus 'active', transfer the\n   parameters to the target physical interface by setting\n   the object docsIfUpChannelUpdate to 'true'.\n6. Delete the temporary row by setting\n   docsIfUpChannelStatus to 'destroy'.")
docsIfUpChannelPreEqEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 19), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelPreEqEnable.setDescription("At the CMTS, this object is used to enable or disable\npre-equalization on the upstream channel represented by\nthis table instance.  At the CM, this object is read-only\nand reflects the status of pre-equalization as represented\nin the RNG-RSP.  Pre-equalization is considered enabled at\nthe CM if a RNG-RSP with pre-equalization data has been\nreceived at least once since the last mac\nreinitialization.")
docsIfQosProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3))
if mibBuilder.loadTexts: docsIfQosProfileTable.setDescription("Describes the attributes for each class of service.")
docsIfQosProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1)).setIndexNames((0, "DOCS-IF-MIB", "docsIfQosProfIndex"))
if mibBuilder.loadTexts: docsIfQosProfileEntry.setDescription("Describes the attributes for a single class of service.\nIf implemented as read-create in the Cable Modem\nTermination System, creation of entries in this table is\ncontrolled by the value of\ndocsIfCmtsQosProfilePermissions.\n\nIf implemented as read-only, entries are created based\non information in REG-REQ MAC messages received from\ncable modems (for Cable Modem Termination System), or\nbased on information extracted from the TFTP option file\n(for Cable Modem).\nIn the Cable Modem Termination System, read-only entries\nare removed if no longer referenced by\ndocsIfCmtsServiceTable.\n\nAn entry in this table MUST not be removed while it is\nreferenced by an entry in docsIfCmServiceTable (Cable\nModem) or docsIfCmtsServiceTable (Cable Modem Termination\nSystem).\n\nAn entry in this table SHOULD NOT be changeable while\nit is referenced by an entry in docsIfCmtsServiceTable.\n\nIf this table is created automatically, there SHOULD only\nbe a single entry for each Class of Service.  Multiple\nentries with the same Class of Service parameters are NOT\nRECOMMENDED.")
docsIfQosProfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16383))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfQosProfIndex.setDescription("The index value that uniquely identifies an entry\nin the docsIfQosProfileTable.")
docsIfQosProfPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 7)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfPriority.setDescription("A relative priority assigned to this service when\nallocating bandwidth.  Zero indicates lowest priority\nand seven indicates highest priority.\nInterpretation of priority is device-specific.\nMUST NOT be changed while this row is active.")
docsIfQosProfMaxUpBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100000000)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxUpBandwidth.setDescription("The maximum upstream bandwidth, in bits per second,\nallowed for a service with this service class.\nZero if there is no restriction of upstream bandwidth.\nMUST NOT be changed while this row is active.")
docsIfQosProfGuarUpBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100000000)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfGuarUpBandwidth.setDescription("Minimum guaranteed upstream bandwidth, in bits per second,\n\n\n\nallowed for a service with this service class.\nMUST NOT be changed while this row is active.")
docsIfQosProfMaxDownBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100000000)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxDownBandwidth.setDescription("The maximum downstream bandwidth, in bits per second,\nallowed for a service with this service class.\nZero if there is no restriction of downstream bandwidth.\nMUST NOT be changed while this row is active.")
docsIfQosProfMaxTxBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxTxBurst.setDescription("The maximum number of mini-slots that may be requested\nfor a single upstream transmission.\nA value of zero means there is no limit.\nMUST NOT be changed while this row is active.\nThis object has been deprecated and replaced by\ndocsIfQosProfMaxTransmitBurst, to fix a mismatch\nof the units and value range with respect to the DOCSIS\nMaximum Upstream Channel Transmit Burst Configuration\nSetting.")
docsIfQosProfBaselinePrivacy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 7), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfBaselinePrivacy.setDescription("Indicates whether Baseline Privacy is enabled for this\nservice class.\nMUST NOT be changed while this row is active.")
docsIfQosProfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfStatus.setDescription("This is object is used to create or delete rows in\nthis table.  This object MUST NOT be changed from active\nwhile the row is referenced by any entry in either\ndocsIfCmServiceTable (on the CM) or\ndocsIfCmtsServiceTable (on the CMTS).")
docsIfQosProfMaxTransmitBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxTransmitBurst.setDescription("The maximum number of bytes that may be requested for a\nsingle upstream transmission.  A value of zero means there\nis no limit.  Note: This value does not include any\nphysical layer overhead.\nMUST NOT be changed while this row is active.")
docsIfQosProfStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 10), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfQosProfStorageType.setDescription("The storage type for this conceptual row.\nEntries with this object set to permanent(4)\n\n\n\ndo not require write operations for writable\nobjects.")
docsIfSignalQualityTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4))
if mibBuilder.loadTexts: docsIfSignalQualityTable.setDescription("At the CM, describes the PHY signal quality of downstream\nchannels.  At the CMTS, this object describes the PHY\nsignal quality of upstream channels.  At the CMTS, this\ntable MAY exclude contention intervals.")
docsIfSignalQualityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfSignalQualityEntry.setDescription("At the CM, this object describes the PHY characteristics of\na downstream channel.  At the CMTS, it describes the PHY\nsignal quality of an upstream channel.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableDownstream(128) for Cable Modems.\nFor DOCSIS 1.1 Cable Modem Termination Systems, an entry\nexists for each ifEntry with an ifType of\ndocsCableUpstream (129).\nFor DOCSIS 2.0 Cable Modem Termination Systems, an entry\nexists for each ifEntry with an ifType of\ndocsCableUpstreamChannel (205).")
docsIfSigQIncludesContention = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQIncludesContention.setDescription("true(1) if this CMTS includes contention intervals in\nthe counters in this table.  Always false(2) for CMs.")
docsIfSigQUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQUnerroreds.setDescription("Codewords received on this channel without error.\nThis includes all codewords, whether or not they\nwere part of frames destined for this device.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfSigQCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQCorrecteds.setDescription("Codewords received on this channel with correctable\nerrors.  This includes all codewords, whether or not\nthey were part of frames destined for this device.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfSigQUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQUncorrectables.setDescription("Codewords received on this channel with uncorrectable\nerrors.  This includes all codewords, whether or not\nthey were part of frames destined for this device.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfSigQSignalNoise = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 5), TenthdB()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQSignalNoise.setDescription("Signal/Noise ratio as perceived for this channel.\nAt the CM, this object  describes the Signal/Noise of the\ndownstream channel.  At the CMTS, it describes the\naverage Signal/Noise of the upstream channel.")
docsIfSigQMicroreflections = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQMicroreflections.setDescription("Microreflections, including in-channel response\nas perceived on this interface, measured in dBc below\nthe signal level.\nThis object is not assumed to return an absolutely\naccurate value, but it gives a rough indication\n\n\n\nof microreflections received on this interface.\nIt is up to the implementer to provide information\nas accurately as possible.")
docsIfSigQEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 7), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQEqualizationData.setDescription("At the CM, this object returns the equalization data for\nthe downstream channel.\n\nAt the CMTS, this object is not applicable and is not\ninstantiated.  Note that previous CMTS implementations\nmay instantiate this object in two ways:\n- An equalization value indicating an equalization\n  average for the upstream channel.  Those values have\n  vendor-dependent interpretations.\n- Return a zero-length OCTET STRING to indicate that\n  the value is unknown or if there is no equalization\n  data available or defined.")
docsIfSigQExtUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtUnerroreds.setDescription("Codewords received on this channel without error.\nThis includes all codewords, whether or not they\nwere part of frames destined for this device.\nThis is the 64-bit version of docsIfSigQUnerroreds.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfSigQExtCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtCorrecteds.setDescription("Codewords received on this channel with correctable\nerrors.  This includes all codewords, whether or not\nthey were part of frames destined for this device.\nThis is the 64-bit version of docsIfSigQCorrecteds.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfSigQExtUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtUncorrectables.setDescription("Codewords received on this channel with uncorrectable\nerrors.  This includes all codewords, whether or not\nthey were part of frames destined for this device.\nThis is the 64-bit version of docsIfSigQUncorrectables.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfDocsisBaseCapability = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 5), DocsisVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDocsisBaseCapability.setDescription("Indication of the DOCSIS capability of the device.")
docsIfCmObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 2))
docsIfCmMacTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1))
if mibBuilder.loadTexts: docsIfCmMacTable.setDescription("Describes the attributes of each CM MAC interface,\nextending the information available from ifEntry.")
docsIfCmMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmMacEntry.setDescription("An entry containing objects describing attributes of\neach MAC entry, extending the information in ifEntry.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsIfCmCmtsAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmCmtsAddress.setDescription("Identifies the CMTS that is believed to control this MAC\ndomain.  At the CM, this will be the source address from\nSYNC, MAP, and other MAC-layer messages.  If the CMTS is\nunknown, returns 00-00-00-00-00-00.")
docsIfCmCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 2), Bits().subtype(namedValues=namedval.NamedValues(("atmCells", 0), ("concatenation", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmCapabilities.setDescription("Identifies the capabilities of the MAC implementation\nat this interface.  Note that packet transmission is\nalways supported.  Therefore, there is no specific bit\nrequired to explicitly indicate this capability.\nNote that BITS objects are encoded most significant bit\nfirst.  For example, if bit 1 is set, the value of this\nobject is the octet string '40'H.")
docsIfCmRangingRespTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 3), TimeTicks().clone(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmRangingRespTimeout.setDescription("Waiting time for a Ranging Response packet.\nThis object has been obsoleted and replaced by\ndocsIfCmRangingTimeout to correct the typing to\nTimeInterval.")
docsIfCmRangingTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 4), TimeInterval().clone(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmRangingTimeout.setDescription("Waiting time for a Ranging Response packet.\nThis object MUST NOT persist at reinitialization\nof the managed system.")
docsIfCmStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2))
if mibBuilder.loadTexts: docsIfCmStatusTable.setDescription("This table maintains a number of status objects\nand counters for Cable Modems.")
docsIfCmStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmStatusEntry.setDescription("A set of status objects and counters for a single MAC\nlayer instance in Cable Modem.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsIfCmStatusValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(7,4,3,8,5,12,2,1,10,6,13,11,9,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("paramTransferComplete", 10), ("registrationComplete", 11), ("operational", 12), ("accessDenied", 13), ("notReady", 2), ("notSynchronized", 3), ("phySynchronized", 4), ("usParametersAcquired", 5), ("rangingComplete", 6), ("ipComplete", 7), ("todEstablished", 8), ("securityEstablished", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusValue.setDescription("Current Cable Modem connectivity state, as specified\nin the RF Interface Specification.  Interpretations for\nstate values 1-12 are clearly outlined in the SP-RFI\nreference given below.\nThe state value accessDenied(13) indicates the CMTS has\nsent a Registration Aborted message to the CM.  The same\nstate is reported as accessDenied(7) by the CMTS object\ndocsIfCmtsCmStatusValue.")
docsIfCmStatusCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(5,6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusCode.setDescription("Status code for a Cable Modem as defined in the\nOSSI Specification.  The status code consists\nof a single character indicating error groups, followed\nby a two- or three-digit number indicating the status\ncondition, followed by a decimal.\nAn example of a returned value could be 'T101.0'.\nThe zero-length OCTET STRING indicates no status code yet\nregistered.")
docsIfCmStatusTxPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 3), TenthdBmV()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusTxPower.setDescription("The operational transmit power for the attached upstream\nchannel.")
docsIfCmStatusResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusResets.setDescription("Number of times the CM reset or initialized this\ninterface.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\n\n\n\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusLostSyncs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusLostSyncs.setDescription("Number of times the CM lost synchronization with\nthe downstream channel.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusInvalidMaps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidMaps.setDescription("Number of times the CM received invalid MAP messages.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusInvalidUcds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidUcds.setDescription("Number of times the CM received invalid UCD messages.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusInvalidRangingResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidRangingResponses.setDescription("Number of times the CM received invalid ranging response\nmessages.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusInvalidRegistrationResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidRegistrationResponses.setDescription("Number of times the CM received invalid registration\nresponse messages.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusT1Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT1Timeouts.setDescription("Number of times counter T1 expired in the CM.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusT2Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT2Timeouts.setDescription("Number of times counter T2 expired in the CM.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusT3Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT3Timeouts.setDescription("Number of times counter T3 expired in the CM.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusT4Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT4Timeouts.setDescription("Number of times counter T4 expired in the CM.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusRangingAborteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusRangingAborteds.setDescription("Number of times the ranging process was aborted\nby the CMTS.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusDocsisOperMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 15), DocsisQosVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusDocsisOperMode.setDescription("Indication of whether the device has registered using 1.0\nClass of Service or 1.1 Quality of Service.\nAn unregistered CM SHOULD indicate 'docsis11' for a\ndocsIfDocsisBaseCapability value of DOCSIS 1.1/2.0.  An\nunregistered CM SHOULD indicate 'docsis10'  for a\ndocsIfDocsisBaseCapability value of DOCSIS 1.0.")
docsIfCmStatusModulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 16), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusModulationType.setDescription("Indicates modulation type status currently used by the\nCM.  Since this object specifically identifies PHY mode,\nthe shared upstream channel type is not permitted.")
docsIfCmStatusEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 17), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusEqualizationData.setDescription("Pre-equalization data for this CM after convolution with\ndata indicated in the RNG-RSP.  This data is valid when\ndocsIfUpChannelPreEqEnable is set to true.")
docsIfCmStatusUCCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusUCCs.setDescription("The number of successful Upstream Channel Change\ntransactions.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmStatusUCCFails = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusUCCFails.setDescription("The number of failed Upstream Channel Change\ntransactions.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3))
if mibBuilder.loadTexts: docsIfCmServiceTable.setDescription("Describes the attributes of each upstream service queue\non a CM.")
docsIfCmServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmServiceId"))
if mibBuilder.loadTexts: docsIfCmServiceEntry.setDescription("Describes the attributes of an upstream bandwidth service\nqueue.\nAn entry in this table exists for each Service ID.\nThe primary index is an ifIndex with an ifType of\ndocsCableMaclayer(127).")
docsIfCmServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16383))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmServiceId.setDescription("Identifies a service queue for upstream bandwidth.  The\nattributes of this service queue are shared between the\nCM and the CMTS.  The CMTS allocates upstream bandwidth\nto this service queue based on requests from the CM and\non the class of service associated with this queue.")
docsIfCmServiceQosProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceQosProfile.setDescription("The index in docsIfQosProfileTable describing the quality\nof service attributes associated with this particular\nservice.  If no associated entry in docsIfQosProfileTable\nexists, this object returns a value of zero.")
docsIfCmServiceTxSlotsImmed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxSlotsImmed.setDescription("The number of upstream mini-slots that have been used to\ntransmit data PDUs in immediate (contention) mode.  This\nincludes only those PDUs that are presumed to have\narrived at the head-end (i.e., those that were explicitly\nacknowledged).  It does not include retransmission attempts\nor mini-slots used by requests.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceTxSlotsDed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxSlotsDed.setDescription("The number of upstream mini-slots that have been used to\ntransmit data PDUs in dedicated mode (i.e., as a result\nof a unicast Data Grant).\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceTxRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxRetries.setDescription("The number of attempts to transmit data PDUs containing\nrequests for acknowledgment that did not result in\nacknowledgment.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceTxExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxExceededs.setDescription("The number of data PDU transmission failures due to\nexcessive retries without acknowledgment.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceRqRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceRqRetries.setDescription("The number of attempts to transmit bandwidth requests\nthat did not result in acknowledgment.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceRqExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceRqExceededs.setDescription("The number of requests for bandwidth that failed due to\nexcessive retries without acknowledgment.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceExtTxSlotsImmed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceExtTxSlotsImmed.setDescription("The number of upstream mini-slots that have been used to\ntransmit data PDUs in immediate (contention) mode.  This\nincludes only those PDUs that are presumed to have\narrived at the head-end (i.e., those that were explicitly\nacknowledged).  It does not include retransmission attempts\nor mini-slots used by requests.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmServiceExtTxSlotsDed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceExtTxSlotsDed.setDescription("The number of upstream mini-slots that have been used to\ntransmit data PDUs in dedicated mode (i.e., as a result\nof a unicast Data Grant).\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 3))
docsIfCmtsMacTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1))
if mibBuilder.loadTexts: docsIfCmtsMacTable.setDescription("Describes the attributes of each CMTS MAC interface,\nextending the information available from ifEntry.\nMandatory for all CMTS devices.")
docsIfCmtsMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsMacEntry.setDescription("An entry containing objects describing attributes of each\nMAC entry, extending the information in ifEntry.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsIfCmtsCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("atmCells", 0), ("concatenation", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCapabilities.setDescription("Identifies the capabilities of the CMTS MAC\nimplementation at this interface.  Note that packet\ntransmission is always supported.  Therefore, there\nis no specific bit required to explicitly indicate\nthis capability.\nNote that BITS objects are encoded most significant bit\nfirst.  For example, if bit 1 is set, the value of this\nobject is the octet string '40'H.")
docsIfCmtsSyncInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 200))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsSyncInterval.setDescription("The interval between CMTS transmission of successive SYNC\nmessages at this interface.")
docsIfCmtsUcdInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsUcdInterval.setDescription("The interval between CMTS transmission of successive\nUpstream Channel Descriptor messages for each upstream\nchannel at this interface.")
docsIfCmtsMaxServiceIds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsMaxServiceIds.setDescription("The maximum number of service IDs that may be\nsimultaneously active.")
docsIfCmtsInsertionInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 5), TimeTicks()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInsertionInterval.setDescription("The amount of time to elapse between each broadcast\ninitial maintenance grant.  Broadcast initial maintenance\ngrants are used to allow new cable modems to join the\nnetwork.  Zero indicates that a vendor-specific algorithm\nis used instead of a fixed time.  The maximum amount of\n\n\n\ntime permitted by the specification is 2 seconds.\nThis object has been obsoleted and replaced by\ndocsIfCmtsInsertInterval to fix a SYNTAX typing problem.")
docsIfCmtsInvitedRangingAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1024))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInvitedRangingAttempts.setDescription("The maximum number of attempts to make on invitations\nfor ranging requests.  A value of zero means the system\nSHOULD attempt to range forever.")
docsIfCmtsInsertInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 7), TimeInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInsertInterval.setDescription("The amount of time to elapse between each broadcast\ninitial maintenance grant.  Broadcast initial maintenance\ngrants are used to allow new cable modems to join the\nnetwork.  Zero indicates that a vendor-specific algorithm\nis used instead of a fixed time.  The maximum amount of\ntime permitted by the specification is 2 seconds.")
docsIfCmtsMacStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 8), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsMacStorageType.setDescription("The storage type for this conceptual row.\n\n\n\nEntries with this object set to permanent(4)\ndo not require write operations for read-write\nobjects.")
docsIfCmtsStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2))
if mibBuilder.loadTexts: docsIfCmtsStatusTable.setDescription("For the MAC layer, this group maintains a number of\nstatus objects and counters.")
docsIfCmtsStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsStatusEntry.setDescription("Status entry for a single MAC layer.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableMaclayer(127).")
docsIfCmtsStatusInvalidRangeReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidRangeReqs.setDescription("This object counts invalid RNG-REQ messages received on\nthis interface.\nDiscontinuities in the value of this counter can occur\n\n\n\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsStatusRangingAborteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusRangingAborteds.setDescription("This object counts ranging attempts that were explicitly\naborted by the CMTS.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsStatusInvalidRegReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidRegReqs.setDescription("This object counts invalid REG-REQ messages received on\nthis interface; that is, syntax, out of range parameters,\nor erroneous requests.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsStatusFailedRegReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusFailedRegReqs.setDescription("This object counts failed registration attempts.  Included\nare docsIfCmtsStatusInvalidRegReqs, authentication, and\nclass of service failures.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsStatusInvalidDataReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidDataReqs.setDescription("This object counts invalid data request messages\nreceived on this interface.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsStatusT5Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusT5Timeouts.setDescription("This object counts the number of times counter T5\nexpired on this interface.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3))
if mibBuilder.loadTexts: docsIfCmtsCmStatusTable.setDescription("A set of objects in the CMTS, maintained for each\ncable modem connected to this CMTS.")
docsIfCmtsCmStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1)).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsCmStatusIndex"))
if mibBuilder.loadTexts: docsIfCmtsCmStatusEntry.setDescription("Status information for a single cable modem.\nAn entry in this table exists for each cable modem\nthat is connected to the CMTS implementing this table.")
docsIfCmtsCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsCmStatusIndex.setDescription("Index value to uniquely identify an entry in this table.\nFor an individual cable modem, this index value SHOULD\nNOT change during CMTS uptime.")
docsIfCmtsCmStatusMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusMacAddress.setDescription("MAC address of the cable modem.  If the cable modem has\nmultiple MAC addresses, this is the MAC address associated\nwith the Cable interface.")
docsIfCmtsCmStatusIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusIpAddress.setDescription("IP address of this cable modem.  If the cable modem has no\nIP address assigned, or the IP address is unknown, this\nobject returns a value of 0.0.0.0.  If the cable modem has\nmultiple IP addresses, this object returns the IP address\nassociated with the Cable interface.\nThis object has been deprecated and replaced by\ndocsIfCmtsCmStatusInetAddressType and\ndocsIfCmtsCmStatusInetAddress, to enable IPv6 addressing\nin the future.")
docsIfCmtsCmStatusDownChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 4), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusDownChannelIfIndex.setDescription("IfIndex of the downstream channel that this CM is\nconnected to.  If the downstream channel is unknown, this\nobject returns a value of zero.")
docsIfCmtsCmStatusUpChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 5), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUpChannelIfIndex.setDescription("For DOCSIS 2.0, indicates the ifIndex of the logical\nupstream channel (ifType 205) this CM is connected to.\nFor DOCSIS 1.x, indicates the ifIndex of the upstream\n channel (ifType 129) this CM is connected to.\n If the upstream channel is unknown, this object\n returns a value of zero.")
docsIfCmtsCmStatusRxPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 6), TenthdBmV()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusRxPower.setDescription("The receive power as perceived for upstream data from\nthis cable modem.\nIf the receive power is unknown, this object returns\na value of zero.")
docsIfCmtsCmStatusTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusTimingOffset.setDescription("A measure of the current round trip time for this CM.\nUsed for timing of CM upstream transmissions to ensure\nsynchronized arrivals at the CMTS.  Units are in terms\nof (6.25 microseconds/64).  Returns zero if the value\nis unknown.\nFor channels requiring finer resolution, please refer to\nobject docsIfCmtsCmStatusHighResolutionTimingOffset.")
docsIfCmtsCmStatusEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 8), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusEqualizationData.setDescription("Equalization data for this CM, as measured by the CMTS.\nReturns the zero-length OCTET STRING if the value is\nunknown or if there is no equalization data available\nor defined.")
docsIfCmtsCmStatusValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(9,2,5,1,4,8,3,6,7,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("ranging", 2), ("rangingAborted", 3), ("rangingComplete", 4), ("ipComplete", 5), ("registrationComplete", 6), ("accessDenied", 7), ("operational", 8), ("registeredBPIInitializing", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusValue.setDescription("Current cable modem connectivity state, as specified\nin the RF Interface Specification.  Returned status\ninformation is the CM status, as assumed by the CMTS,\nand indicates the following events:\nother(1)\n   Any state other than below.\nranging(2)\n   The CMTS has received an Initial Ranging Request\n   message from the CM, and the ranging process is not\n   yet complete.\nrangingAborted(3)\n   The CMTS has sent a Ranging Abort message to the CM.\n\n\n\nrangingComplete(4)\n   The CMTS has sent a Ranging Complete message to the CM.\nipComplete(5)\n   The CMTS has received a DHCP reply message and\n   forwarded it to the CM.\nregistrationComplete(6)\n   The CMTS has sent a Registration Response message to\n   the CM.\naccessDenied(7)\n   The CMTS has sent a Registration Aborted message\n   to the CM.\noperational(8)\n   Value 8 is considered reserved and should not be defined\n   in future revisions of this MIB module to avoid conflict\n   with documented implementations that support value 8 to\n   indicate operational state after completing the BPI\n   initialization process.\nregisteredBPIInitializing(9)\n   Baseline Privacy (BPI) is enabled and the CMTS is in the\n   process of completing BPI initialization.  This state\n   MAY last for a significant length of time if failures\n   occur during the initialization process.  After\n   completion of BPI initialization, the CMTS will report\n   registrationComplete(6).\nThe CMTS only needs to report states it is able to\ndetect.")
docsIfCmtsCmStatusUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUnerroreds.setDescription("Codewords received without error from this cable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusCorrecteds.setDescription("Codewords received with correctable errors from this\ncable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUncorrectables.setDescription("Codewords received with uncorrectable errors from this\ncable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusSignalNoise = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 13), TenthdB()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusSignalNoise.setDescription("Signal/Noise ratio as perceived for upstream data from\nthis cable modem.\nIf the Signal/Noise is unknown, this object returns\na value of zero.")
docsIfCmtsCmStatusMicroreflections = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusMicroreflections.setDescription("Total microreflections, including in-channel response\nas perceived on this interface, measured in dBc below\nthe signal level.\nThis object is not assumed to return an absolutely\naccurate value, but it gives a rough indication\nof microreflections received on this interface.\nIt is up to the implementer to provide information\nas accurately as possible.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusExtUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 15), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtUnerroreds.setDescription("Codewords received without error from this cable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusExtCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 16), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtCorrecteds.setDescription("Codewords received with correctable errors from this\ncable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusExtUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 17), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtUncorrectables.setDescription("Codewords received with uncorrectable errors from this\ncable modem.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsCmStatusDocsisRegMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 18), DocsisQosVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusDocsisRegMode.setDescription("Indication of whether the CM has registered using 1.0\nClass of Service or 1.1 Quality of Service.")
docsIfCmtsCmStatusModulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 19), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusModulationType.setDescription("Indicates modulation type currently used by the CM.  Since\nthis object specifically identifies PHY mode, the shared\ntype is not permitted.  If the upstream channel is\nunknown, this object returns a value of zero.")
docsIfCmtsCmStatusInetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 20), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusInetAddressType.setDescription("The type of internet address of\ndocsIfCmtsCmStatusInetAddress.  If the cable modem\ninternet address is unassigned or unknown, then the\nvalue of this object is unknown(0).")
docsIfCmtsCmStatusInetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 21), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusInetAddress.setDescription("Internet address of this cable modem.  If the Cable\nModem has no Internet address assigned, or the Internet\naddress is unknown, the value of this object is the\nzero-length OCTET STRING.  If the cable modem has\nmultiple Internet addresses, this object returns the\nInternet address associated with the Cable\n(i.e., RF MAC) interface.")
docsIfCmtsCmStatusValueLastUpdate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 22), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusValueLastUpdate.setDescription("The value of sysUpTime when docsIfCmtsCmStatusValue\nwas last updated.")
docsIfCmtsCmStatusHighResolutionTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 23), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusHighResolutionTimingOffset.setDescription("A measure of the current round trip time for this CM.\nUsed for timing of CM upstream transmissions to ensure\nsynchronized arrivals at the CMTS.  Units are in terms\nof (6.25 microseconds/(64*256)).  Returns zero if the value\nis unknown.\nThis is the high resolution version of object\ndocsIfCmtsCmStatusTimingOffset, for channels requiring\nfiner resolution.")
docsIfCmtsServiceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4))
if mibBuilder.loadTexts: docsIfCmtsServiceTable.setDescription("Describes the attributes of upstream service queues\nin a Cable Modem Termination System.")
docsIfCmtsServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsServiceId"))
if mibBuilder.loadTexts: docsIfCmtsServiceEntry.setDescription("Describes the attributes of a single upstream bandwidth\nservice queue.\nEntries in this table exist for each ifEntry with an\nifType of docsCableMaclayer(127), and for each service\nqueue (Service ID) within this MAC layer.\nEntries in this table are created with the creation of\nindividual Service IDs by the MAC layer and removed\nwhen a Service ID is removed.")
docsIfCmtsServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16383))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsServiceId.setDescription("Identifies a service queue for upstream bandwidth.  The\nattributes of this service queue are shared between the\nCable Modem and the Cable Modem Termination System.\nThe CMTS allocates upstream bandwidth to this service\nqueue based on requests from the CM and on the class of\nservice associated with this queue.")
docsIfCmtsServiceCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceCmStatusIndex.setDescription("Pointer to an entry in docsIfCmtsCmStatusTable identifying\nthe cable modem using this Service Queue.  If multiple\ncable modems are using this Service Queue, the value of\nthis object is zero.\nThis object has been deprecated and replaced by\ndocsIfCmtsServiceNewCmStatusIndex, to fix a mismatch\nof the value range with respect to docsIfCmtsCmStatusIndex\n(1..2147483647).")
docsIfCmtsServiceAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("destroyed", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsServiceAdminStatus.setDescription("Allows a service class for a particular modem to be\nsuppressed, (re-)enabled, or deleted altogether.")
docsIfCmtsServiceQosProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceQosProfile.setDescription("The index in docsIfQosProfileTable describing the quality\nof service attributes associated with this particular\nservice.  If no associated docsIfQosProfileTable entry\nexists, this object returns a value of zero.")
docsIfCmtsServiceCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceCreateTime.setDescription("The value of sysUpTime when this entry was created.")
docsIfCmtsServiceInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceInOctets.setDescription("The cumulative number of Packet Data octets received\non this Service ID.  The count does not include the\nsize of the Cable MAC header.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsServiceInPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceInPackets.setDescription("The cumulative number of Packet Data packets received\non this Service ID.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsServiceNewCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceNewCmStatusIndex.setDescription("Pointer (via docsIfCmtsCmStatusIndex) to an entry in\ndocsIfCmtsCmStatusTable identifying the cable modem\nusing this Service Queue.  If multiple cable modems are\nusing this Service Queue, the value of this object is\nzero.")
docsIfCmtsModulationTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5))
if mibBuilder.loadTexts: docsIfCmtsModulationTable.setDescription("Describes a modulation profile associated with one or more\nupstream channels.")
docsIfCmtsModulationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1)).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsModIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsModIntervalUsageCode"))
if mibBuilder.loadTexts: docsIfCmtsModulationEntry.setDescription("Describes a modulation profile for an Interval Usage Code\nfor one or more upstream channels.\nEntries in this table are created by the operator.\n\nInitial default entries MAY be created at system\ninitialization time, which could report a value of\n'permanent' or 'readOnly' for docsIfCmtsModStorageType.\nA CMTS MAY reject the creation of additional Interval\nUsage Codes for a modulation profile being defined at\nInitialization time.\nNo individual objects have to be specified in order\nto create an entry in this table.\n\n\n\nNote that some objects do not have DEFVAL clauses\nbut do have calculated defaults and need not be specified\nduring row creation.")
docsIfCmtsModIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsModIndex.setDescription("An index into the Channel Modulation table representing\na group of Interval Usage Codes, all associated with the\nsame channel.")
docsIfCmtsModIntervalUsageCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,6,9,1,2,10,11,4,5,)).subtype(namedValues=namedval.NamedValues(("request", 1), ("advPhyLongData", 10), ("ugs", 11), ("requestData", 2), ("initialRanging", 3), ("periodicRanging", 4), ("shortData", 5), ("longData", 6), ("advPhyShortData", 9), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsModIntervalUsageCode.setDescription("An index into the Channel Modulation table that, when\ngrouped with other Interval Usage Codes, fully\ninstantiates all modulation sets for a given upstream\nchannel.")
docsIfCmtsModControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModControl.setDescription("Controls and reflects the status of rows in this table.\nThere is no restriction on the changing of values in this\ntable while their associated rows are active, with the\nexception of:\n\n1. If a modulation profile is being referenced by one\n   or more upstream channels, an attempt to set the value\n   of docsIfCmtsModChannelType returns an\n   'inconsistentValue' error.\n\n2. If a modulation profile is being referenced by one\n   or more upstream channels, an attempt to set\n   docsIfCmtsModControl to destroy(6) or notInService(2)\n   returns an 'inconsistentValue' error.")
docsIfCmtsModType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,6,7,4,5,3,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("qpsk", 2), ("qam16", 3), ("qam8", 4), ("qam32", 5), ("qam64", 6), ("qam128", 7), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModType.setDescription("The modulation type used on this channel.  Returns\nother(1) if the modulation type is not\nqpsk, qam16, qam8, qam32, qam64, or qam128.\nType qam128 is used for SCDMA channels only.\nSee the reference for the modulation profiles\nimplied by different modulation types.")
docsIfCmtsModPreambleLen = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModPreambleLen.setDescription("The preamble length for this modulation profile in bits.\nDefault value is the minimum needed by the implementation\nat the CMTS for the given modulation profile.")
docsIfCmtsModDifferentialEncoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModDifferentialEncoding.setDescription("Specifies whether or not differential encoding is used\non this channel.")
docsIfCmtsModFECErrorCorrection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModFECErrorCorrection.setDescription("The number of correctable errored bytes (t) used in\nforward error correction code.  The value of 0 indicates\nthat no correction is employed.  The number of check bytes\nappended will be twice this value.")
docsIfCmtsModFECCodewordLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(32)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModFECCodewordLength.setDescription("The number of data bytes (k) in the forward error\ncorrection codeword.\nThis object is not used if docsIfCmtsModFECErrorCorrection\nis zero.")
docsIfCmtsModScramblerSeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScramblerSeed.setDescription("The 15-bit seed value for the scrambler polynomial.")
docsIfCmtsModMaxBurstSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModMaxBurstSize.setDescription("The maximum number of mini-slots that can be transmitted\nduring this channel's burst time.  Returns zero if the\nburst length is bounded by the allocation MAP rather than\nby this profile.\nDefault value is 0, except for shortData, where it is 8.")
docsIfCmtsModGuardTimeSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsModGuardTimeSize.setDescription("The number of symbol-times that MUST follow the end of\nthis channel's burst.  Default value is the minimum time\nneeded by the implementation for this modulation profile.")
docsIfCmtsModLastCodewordShortened = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 12), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModLastCodewordShortened.setDescription("Indicates whether the last FEC codeword is truncated.")
docsIfCmtsModScrambler = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 13), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScrambler.setDescription("Indicates whether the scrambler is employed.")
docsIfCmtsModByteInterleaverDepth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 14), Unsigned32().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModByteInterleaverDepth.setDescription("ATDMA Byte Interleaver Depth (Ir).  This object returns 1\nfor non-ATDMA profiles.")
docsIfCmtsModByteInterleaverBlockSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 15), Unsigned32().clone(18)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModByteInterleaverBlockSize.setDescription("ATDMA Byte Interleaver Block size (Br).  This object\nreturns zero for non-ATDMA profiles ")
docsIfCmtsModPreambleType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(0,1,2,)).subtype(namedValues=namedval.NamedValues(("unknown", 0), ("qpsk0", 1), ("qpsk1", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModPreambleType.setDescription("Preamble type for DOCSIS 2.0 bursts.  The value\n'unknown(0)' represents a row entry consisting only of\nDOCSIS 1.x bursts")
docsIfCmtsModTcmErrorCorrectionOn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 17), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModTcmErrorCorrectionOn.setDescription("Trellis Code Modulation (TCM) On/Off.  This value returns\nfalse for non-S-CDMA profiles.")
docsIfCmtsModScdmaInterleaverStepSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 18), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaInterleaverStepSize.setDescription(" S-CDMA Interleaver step size.  This value returns zero\nfor non-S-CDMA profiles.")
docsIfCmtsModScdmaSpreaderEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 19), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaSpreaderEnable.setDescription(" S-CDMA spreader.  This value returns false for non-S-CDMA\nprofiles.  Default value for IUC 3 and 4 is OFF; for\nall other IUCs it is ON.")
docsIfCmtsModScdmaSubframeCodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 20), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaSubframeCodes.setDescription(" S-CDMA sub-frame size.  This value returns zero\nfor non-S-CDMA profiles.")
docsIfCmtsModChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 21), DocsisUpstreamType().clone('tdma')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModChannelType.setDescription("Describes the modulation channel type for this modulation\nentry.\nAll the active entries in a modulation profile (that is all\nactive entries that share a common docsIfCmtsModIndex)\nMUST have the same value of docsIfCmtsModChannelType.")
docsIfCmtsModStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 22), StorageType().clone('nonVolatile')).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsModStorageType.setDescription("The storage type for this conceptual row.\nEntries with this object set to permanent(4)\ndo not require write operations for read-write\nobjects.")
docsIfCmtsQosProfilePermissions = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 6), Bits().subtype(namedValues=namedval.NamedValues(("createByManagement", 0), ("updateByManagement", 1), ("createByModems", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsQosProfilePermissions.setDescription("This object specifies permitted methods of creating\nentries in docsIfQosProfileTable.\ncreateByManagement(0) is set if entries can be created\nusing SNMP.  updateByManagement(1) is set if updating\nentries using SNMP is permitted.  createByModems(2)\nis set if entries can be created based on information\nin REG-REQ MAC messages received from cable modems.\nInformation in this object is only applicable if\ndocsIfQosProfileTable is implemented as read-create.\nOtherwise, this object is implemented as read-only\nand returns createByModems(2).\nEither createByManagement(0) or updateByManagement(1)\nMUST be set when writing to this object.\nNote that BITS objects are encoded most significant bit\nfirst.  For example, if bit 2 is set, the value of this\nobject is the octet string '20'H.")
docsIfCmtsMacToCmTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7))
if mibBuilder.loadTexts: docsIfCmtsMacToCmTable.setDescription("This is a table to provide a quick access index into the\ndocsIfCmtsCmStatusTable.  There is exactly one row in this\ntable for each row in the docsIfCmtsCmStatusTable.  In\ngeneral, the management station SHOULD use this table only\nto get a pointer into the docsIfCmtsCmStatusTable (which\ncorresponds to the CM's RF interface MAC address) and\nSHOULD not iterate (e.g., GetNext through) this table.")
docsIfCmtsMacToCmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1)).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsCmMac"))
if mibBuilder.loadTexts: docsIfCmtsMacToCmEntry.setDescription("A row in the docsIfCmtsMacToCmTable.\nAn entry in this table exists for each cable modem\nthat is connected to the CMTS implementing this table.")
docsIfCmtsCmMac = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsCmMac.setDescription("The RF side MAC address for the referenced CM (e.g., the\ninterface on the CM that has docsCableMacLayer(127) as\nits ifType).")
docsIfCmtsCmPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmPtr.setDescription("An row index into docsIfCmtsCmStatusTable.  When queried\nwith the correct instance value (e.g., a CM's MAC address),\nreturns the index in docsIfCmtsCmStatusTable that\nrepresents that CM.")
docsIfCmtsChannelUtilizationInterval = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 86400))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationInterval.setDescription("The time interval in seconds over which the channel\nutilization index is calculated.  All upstream/downstream\nchannels use the same\ndocsIfCmtsChannelUtilizationInterval.\n\n\n\nSetting a value of zero disables utilization reporting.\nA channel utilization index is calculated over a fixed\nwindow applying to the most recent\ndocsIfCmtsChannelUtilizationInterval.  It would therefore\nbe prudent to use a relatively short\ndocsIfCmtsChannelUtilizationInterval.\nIt is a vendor decision whether to reset the timer when\ndocsIfCmtsChannelUtilizationInterval is changed during a\nutilization sampling period.")
docsIfCmtsChannelUtilizationTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9))
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationTable.setDescription("Reports utilization statistics for attached upstream and\ndownstream physical channels.")
docsIfCmtsChannelUtilizationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsChannelUtIfType"), (0, "DOCS-IF-MIB", "docsIfCmtsChannelUtId"))
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationEntry.setDescription("Utilization statistics for a single upstream or downstream\nphysical channel.  An entry exists in this table for each\nifEntry with an ifType equal to\ndocsCableDownstream (128)\nor docsCableUpstream (129).")
docsIfCmtsChannelUtIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 1), IANAifType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsChannelUtIfType.setDescription("The secondary index into this table.  Indicates the IANA\ninterface type associated with this physical channel.\nOnly docsCableDownstream (128) and\n\n\n\ndocsCableUpstream (129) are valid.")
docsIfCmtsChannelUtId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsIfCmtsChannelUtId.setDescription("The tertiary index into this table.  Indicates the CMTS\nidentifier for this physical channel.")
docsIfCmtsChannelUtUtilization = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsChannelUtUtilization.setDescription("The calculated and truncated utilization index for this\nphysical upstream or downstream channel, accurate as of\nthe most recent docsIfCmtsChannelUtilizationInterval.\n\nUpstream Channel Utilization Index:\n\nThe upstream channel utilization index is expressed as a\npercentage of mini-slots utilized on the physical channel,\nregardless of burst type.  For an Initial Maintenance\nregion, the mini-slots for the complete region are\nconsidered utilized if the CMTS received an upstream\nburst within the region from any CM on the physical\nchannel.  For contention REQ and REQ/DATA regions, the\nmini-slots for a transmission opportunity within the\nregion are considered utilized if the CMTS received an\nupstream burst within the opportunity from any CM on the\nphysical channel.  For all other regions, utilized\nmini-slots are those in which the CMTS granted\nbandwidth to any unicast SID on the physical channel.\n\nFor an upstream interface that has multiple logical\nupstream channels enabled, the utilization index is a\nweighted sum of utilization indices for the logical\nchannels.  The weight for each utilization index is the\npercentage of upstream mini-slots allocated for the\ncorresponding logical channel.\nExample:\nIf 75% of bandwidth is allocated to the first logical\nchannel and 25% to the second, and the utilization\nindices for each are 60 and 40, respectively, the\n\n\n\nutilization index for the upstream physical channel is\n(60 * 0.75) + (40 * 0.25) = 55.  This figure\napplies to the most recent utilization interval.\n\nDownstream Channel Utilization Index:\n\nThe downstream channel utilization index is a percentage\nexpressing the ratio between bytes used to transmit data\nversus the total number of bytes transmitted in the raw\nbandwidth of the MPEG channel.  As with the upstream\nutilization index, the calculated value represents\nthe most recent utilization interval.\nFormula:\nDownstream utilization index =\n(100 * (data bytes / raw bytes))\n\nDefinitions:\nData bytes:    Number of bytes transmitted as data in the\n               docsIfCmtsChannelUtilizationInterval.\n               Identical to docsIfCmtsDownChannelCtrUsed\n               Bytes measured over the utilization\n               interval.\nRaw bandwidth: Total number of bytes available for\n               transmitting data, not including bytes\n               used for headers and other overhead.\nRaw bytes:     (raw bandwidth *\n               docsIfCmtsChannelUtilizationInterval).\n               Identical to docsIfCmtsDownChannelCtrTotal\n               Bytes measured over the utilization\n               interval.")
docsIfCmtsDownChannelCounterTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10))
if mibBuilder.loadTexts: docsIfCmtsDownChannelCounterTable.setDescription("This table is implemented at the CMTS to collect\ndownstream channel statistics for utilization\n\n\n\ncalculations.")
docsIfCmtsDownChannelCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsDownChannelCounterEntry.setDescription("An entry provides a list of traffic counters for a single\ndownstream channel.\nAn entry in this table exists for each ifEntry with an\nifType of docsCableDownstream(128).")
docsIfCmtsDownChnlCtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrId.setDescription("The Cable Modem Termination System identification\nof the downstream channel within this particular MAC\ninterface.  If the interface is down, the object returns\nthe most current value.  If the downstream channel ID is\nunknown, this object returns a value of 0.")
docsIfCmtsDownChnlCtrTotalBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrTotalBytes.setDescription("At the CMTS, the total number of bytes in the Payload\nportion of MPEG Packets (i.e., not including MPEG header\nor pointer_field) transported by this downstream channel.\nThis is the 32-bit version of\ndocsIfCmtsDownChnlCtrExtTotalBytes, included to provide\nback compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\n\n\n\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsDownChnlCtrUsedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrUsedBytes.setDescription("At the CMTS, the total number of DOCSIS data bytes\ntransported by this downstream channel.\nThe number of data bytes is defined as the total number\nof bytes transported in DOCSIS payloads minus the number\nof stuff bytes transported in DOCSIS payloads.\nThis is the 32-bit version of\ndocsIfCmtsDownChnlCtrExtUsedBytes, included to provide\nback compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsDownChnlCtrExtTotalBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrExtTotalBytes.setDescription("At the CMTS, the total number of bytes in the Payload\nportion of MPEG Packets (i.e., not including MPEG header\nor pointer_field) transported by this downstream\nchannel.\nThis is the 64-bit version of\ndocsIfCmtsDownChnlCtrTotalBytes and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsDownChnlCtrExtUsedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrExtUsedBytes.setDescription("At the CMTS, the total number of DOCSIS data bytes\ntransported by this downstream channel.  The number\nof data bytes is defined as the total number of bytes\ntransported in DOCSIS payloads minus the number of\nstuff bytes transported in DOCSIS payloads.\nThis is the 64-bit version of\ndocsIfCmtsDownChnlCtrUsedBytes and will not be accessible\nto SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChannelCounterTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11))
if mibBuilder.loadTexts: docsIfCmtsUpChannelCounterTable.setDescription("This table is implemented at the CMTS to provide upstream\nchannel statistics appropriate for channel utilization\ncalculations.")
docsIfCmtsUpChannelCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsUpChannelCounterEntry.setDescription("List of traffic statistics for a single upstream channel.\nFor DOCSIS 2.0 CMTSs, an entry in this table\nexists for each ifEntry with an ifType of\ndocsCableUpstreamChannel (205).\n\n\n\nFor DOCSIS 1.x CMTSs, an entry in this table\nexists for each ifEntry with an ifType of\ndocsCableUpstream (129).")
docsIfCmtsUpChnlCtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrId.setDescription("The CMTS identification of the upstream channel.")
docsIfCmtsUpChnlCtrTotalMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalMslots.setDescription("Current count, from CMTS initialization, of all mini-slots\ndefined for this upstream logical channel.  This count\nincludes all IUCs and SIDs, even those allocated to the\nNULL SID for a 2.0 logical channel that is inactive.  This\nis the 32-bit version of docsIfCmtsUpChnlCtrExtTotalMslots\nand is included for back compatibility with SNMPv1\nmanagers.  Support for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrUcastGrantedMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUcastGrantedMslots.setDescription("Current count, from CMTS initialization, of unicast\ngranted mini-slots on the upstream logical channel,\nregardless of burst type.  Unicast granted mini-slots are\nthose in which the CMTS assigned bandwidth to any unicast\nSID on the logical channel.  However, this object does not\ninclude minis-lots for reserved IUCs, or grants to SIDs\ndesignated as meaning 'no CM'.  This is the 32-bit version\nof docsIfCmtsUpChnlCtrExtUcastGrantedMslots, and is\nincluded for back compatibility with SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrTotalCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnMslots.setDescription("Current count, from CMTS initialization, of contention\nmini-slots defined for this upstream logical channel.  This\ncount includes all mini-slots assigned to a broadcast or\n\n\n\nmulticast SID on the logical channel.  This is the 32-bit\nversion of docsIfCmtsUpChnlCtrExtTotalCntnMslots, and is\nincluded for back compatibility with SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrUsedCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnMslots.setDescription("Current count, from CMTS initialization, of contention\nmini-slots utilized on the upstream logical channel.  For\ncontention regions, utilized mini-slots are those in which\nthe CMTS correctly received an upstream burst from any CM\non the upstream logical channel.  This is the 32-bit\nversion of docsIfCmtsUpChnlCtrExtUsedCntnMslots and is\nincluded for back compatibility with SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalMslots.setDescription("Current count, from CMTS initialization, of all mini-slots\ndefined for this upstream logical channel.  This count\nincludes all IUCs and SIDs, even those allocated to the\nNULL SID for a 2.0 logical channel that is inactive.  This\nis the 64-bit version of docsIfCmtsUpChnlCtrTotalMslots\nand will not be accessible to SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtUcastGrantedMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUcastGrantedMslots.setDescription("Current count, from CMTS initialization, of unicast\ngranted mini-slots on the upstream logical channel,\nregardless of burst type.  Unicast granted mini-slots are\nthose in which the CMTS assigned bandwidth to any unicast\nSID on the logical channel.  However, this object does not\ninclude mini-slots for reserved IUCs, or grants to SIDs\ndesignated as meaning 'no CM'.  This is the 64-bit version\nof docsIfCmtsUpChnlCtrUcastGrantedMslots and will not be\naccessible to SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnMslots.setDescription("Current count, from CMTS initialization, of contention\nmini-slots defined for this upstream logical channel.  This\ncount includes all mini-slots assigned to a broadcast or\nmulticast SID on the logical channel.  This is the 64-bit\nversion of docsIfCmtsUpChnlCtrTotalCntnMslots and will\nnot be accessible to SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtUsedCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnMslots.setDescription("Current count, from CMTS initialization, of contention\n\n\n\nmini-slots utilized on the upstream logical channel.  For\ncontention regions, utilized mini-slots are those in which\nthe CMTS correctly received an upstream burst from any CM\non the upstream logical channel.  This is the 64-bit\nversion of docsIfCmtsUpChnlCtrUsedCntnMslots and will not\nbe accessible to SNMPv1 managers.\nSupport for this object is mandatory.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrCollCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnMslots.setDescription("Current count, from CMTS initialization, of contention\nmini-slots subjected to collisions on the upstream logical\nchannel.  For contention regions, these are the mini-slots\napplicable to bursts that the CMTS detected but could not\ncorrectly receive.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtCollCntnMslots and is included for\nback compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrTotalCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots defined for this upstream logical\nchannel.  This count includes all mini-slots for IUC1\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtTotalCntnReqMslots and is included\nfor back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrUsedCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots utilized on this upstream logical\nchannel.  This count includes all contention mini-slots for\nIUC1 applicable to bursts that the CMTS correctly\nreceived.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtUsedCntnReqMslots and is included\nfor back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrCollCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots subjected to collisions on this upstream\nlogical channel.  This includes all contention mini-slots\nfor IUC1 applicable to bursts that the CMTS detected but\ncould not correctly receive.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtCollCntnReqMslots and is included\nfor back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrTotalCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\n\n\n\nrequest data mini-slots defined for this upstream logical\nchannel.  This count includes all mini-slots for IUC2\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots and is\nincluded for back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrUsedCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest data mini-slots utilized on this upstream logical\nchannel.  This includes all contention mini-slots for IUC2\napplicable to bursts that the CMTS correctly received.\nThis is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots and is\nincluded for back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrCollCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest data mini-slots subjected to collisions on this\nupstream logical channel.  This includes all contention\nmini-slots for IUC2 applicable to bursts that the CMTS\ndetected, but could not correctly receive.  This is the\n32-bit version of\ndocsIfCmtsUpChnlCtrExtCollCntnReqDataMslots and is\nincluded for back compatibility with SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of contention\ninitial maintenance mini-slots defined for this upstream\nlogical channel.  This includes all mini-slots for IUC3\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots\nand is included for back compatibility with SNMPv1\nmanagers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of contention\ninitial maintenance mini-slots utilized on this upstream\nlogical channel.  This includes all contention mini-slots\nfor IUC3 applicable to bursts that the CMTS correctly\nreceived.  This is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots\nand is included for back compatibility with SNMPv1\nmanagers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrCollCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of contention\ninitial maintenance mini-slots subjected to collisions on\nthis upstream logical channel.  This includes all\ncontention mini-slots for IUC3 applicable to bursts that\nthe CMTS detected, but could not correctly receive.\nThis is the 32-bit version of\ndocsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots\nand is included for back compatibility with SNMPv1\nmanagers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtCollCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 20), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnMslots.setDescription("Current count, from CMTS initialization, of collision\ncontention mini-slots on the upstream logical channel.\nFor contention regions, these are the mini-slots applicable\nto bursts that the CMTS detected, but could not correctly\nreceive.  This is the 64-bit version of\ndocsIfCmtsUpChnlCtrCollCntnMslots and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots defined for this upstream logical\nchannel.  This count includes all mini-slots for IUC1\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 64-bit version of\ndocsIfCmtsUpChnlCtrTotalCntnReqMslots and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\n\n\n\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtUsedCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 22), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots utilized on this upstream logical\nchannel.  This count includes all contention mini-slots for\nIUC1 applicable to bursts that the CMTS correctly\nreceived.  This is the 64-bit version of\ndocsIfCmtsUpChnlCtrUsedCntnReqMslots and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtCollCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 23), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnReqMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest mini-slots subjected to collisions on this upstream\nlogical channel.  This includes all contention mini-slots\nfor IUC1 applicable to bursts that the CMTS detected,\nbut could not correctly receive.  This is the 64-bit\nversion of docsIfCmtsUpChnlCtrCollCntnReqMslots and will\nnot be accessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest data mini-slots defined for this upstream logical\nchannel.  This count includes all mini-slots for IUC2\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 64-bit version of\ndocsIfCmtsUpChnlCtrTotalCntnReqDataMslots and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 25), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest data mini-slots utilized on this upstream logical\nchannel.  This includes all contention mini-slots for IUC2\napplicable to bursts that the CMTS correctly received.\nThis is the 64-bit version of\ndocsIfCmtsUpChnlCtrUsedCntnReqDataMslots and will not be\naccessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 26), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots.setDescription("Current count, from CMTS initialization, of contention\nrequest data mini-slots subjected to collisions on this\nupstream logical channel.  This includes all contention\nmini-slots for IUC2 applicable to bursts that the CMTS\ndetected, but could not correctly receive.  This is the\n64-bit version of\ndocsIfCmtsUpChnlCtrCollCntnReqDataMslots\nand will not be accessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\n\n\n\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 27), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of initial\nmaintenance mini-slots defined for this upstream logical\nchannel.  This count includes all mini-slots for IUC3\nassigned to a broadcast or multicast SID on the logical\nchannel.  This is the 64-bit version of\ndocsIfCmtsUpChnlCtrTotalCntnInitMaintMslots\nand will not be accessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 28), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of initial\nmaintenance mini-slots utilized on this upstream logical\nchannel.  This includes all contention mini-slots for IUC3\napplicable to bursts that the CMTS correctly received.\nThis is the 64-bit version of\ndocsIfCmtsUpChnlCtrUsedCntnInitMaintMslots\nand will not be accessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 29), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots.setDescription("Current count, from CMTS initialization, of contention\ninitial maintenance mini-slots subjected to collisions on\nthis upstream logical channel.  This includes all\ncontention mini-slots for IUC3 applicable to bursts that\nthe CMTS detected, but could not correctly receive.\nThis is the 64-bit version of\ndocsIfCmtsUpChnlCtrCollCntnInitMaintMslots and will not\nbe accessible to SNMPv1 managers.\nDiscontinuities in the value of this counter can occur\nat reinitialization of the managed system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime for the associated ifIndex.")
docsIfNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 2))
docsIfConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3))
docsIfCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3, 1))
docsIfGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3, 2))

# Augmentions

# Groups

docsIfBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 1)).setObjects(("DOCS-IF-MIB", "docsIfQosProfStatus"), ("DOCS-IF-MIB", "docsIfSigQSignalNoise"), ("DOCS-IF-MIB", "docsIfUpChannelSlotSize"), ("DOCS-IF-MIB", "docsIfQosProfPriority"), ("DOCS-IF-MIB", "docsIfQosProfMaxUpBandwidth"), ("DOCS-IF-MIB", "docsIfDownChannelWidth"), ("DOCS-IF-MIB", "docsIfDownChannelFrequency"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelTxTimingOffset"), ("DOCS-IF-MIB", "docsIfQosProfMaxTxBurst"), ("DOCS-IF-MIB", "docsIfSigQEqualizationData"), ("DOCS-IF-MIB", "docsIfUpChannelWidth"), ("DOCS-IF-MIB", "docsIfUpChannelModulationProfile"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelId"), ("DOCS-IF-MIB", "docsIfSigQUnerroreds"), ("DOCS-IF-MIB", "docsIfQosProfMaxDownBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfGuarUpBandwidth"), ("DOCS-IF-MIB", "docsIfSigQMicroreflections"), ("DOCS-IF-MIB", "docsIfUpChannelFrequency"), ("DOCS-IF-MIB", "docsIfQosProfBaselinePrivacy"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffEnd"), ("DOCS-IF-MIB", "docsIfDownChannelInterleave"), ("DOCS-IF-MIB", "docsIfSigQIncludesContention"), ("DOCS-IF-MIB", "docsIfDownChannelPower"), ("DOCS-IF-MIB", "docsIfSigQUncorrectables"), ("DOCS-IF-MIB", "docsIfDownChannelModulation"), ("DOCS-IF-MIB", "docsIfSigQCorrecteds"), ("DOCS-IF-MIB", "docsIfDownChannelId"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffEnd"), )
docsIfCmGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 6)).setObjects(("DOCS-IF-MIB", "docsIfCmStatusDocsisOperMode"), ("DOCS-IF-MIB", "docsIfCmServiceTxRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmStatusT3Timeouts"), ("DOCS-IF-MIB", "docsIfCmRangingTimeout"), ("DOCS-IF-MIB", "docsIfCmStatusT1Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidUcds"), ("DOCS-IF-MIB", "docsIfCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRangingResponses"), ("DOCS-IF-MIB", "docsIfSigQEqualizationData"), ("DOCS-IF-MIB", "docsIfCmStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmCapabilities"), ("DOCS-IF-MIB", "docsIfCmStatusCode"), ("DOCS-IF-MIB", "docsIfCmServiceRqRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxExceededs"), ("DOCS-IF-MIB", "docsIfCmServiceRqExceededs"), ("DOCS-IF-MIB", "docsIfCmStatusUCCFails"), ("DOCS-IF-MIB", "docsIfCmStatusT4Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusResets"), ("DOCS-IF-MIB", "docsIfCmStatusLostSyncs"), ("DOCS-IF-MIB", "docsIfCmServiceExtTxSlotsDed"), ("DOCS-IF-MIB", "docsIfCmCmtsAddress"), ("DOCS-IF-MIB", "docsIfCmServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRegistrationResponses"), ("DOCS-IF-MIB", "docsIfCmServiceExtTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmStatusTxPower"), ("DOCS-IF-MIB", "docsIfCmStatusModulationType"), ("DOCS-IF-MIB", "docsIfCmStatusT2Timeouts"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsDed"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidMaps"), ("DOCS-IF-MIB", "docsIfCmStatusUCCs"), )
docsIfCmtsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 3)).setObjects(("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidDataReqs"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMacAddress"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusRxPower"), ("DOCS-IF-MIB", "docsIfCmtsServiceInPackets"), ("DOCS-IF-MIB", "docsIfCmtsServiceAdminStatus"), ("DOCS-IF-MIB", "docsIfCmtsModFECErrorCorrection"), ("DOCS-IF-MIB", "docsIfCmtsSyncInterval"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmtsStatusFailedRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmtsModScramblerSeed"), ("DOCS-IF-MIB", "docsIfCmtsModType"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRangeReqs"), ("DOCS-IF-MIB", "docsIfCmtsModFECCodewordLength"), ("DOCS-IF-MIB", "docsIfCmtsModScrambler"), ("DOCS-IF-MIB", "docsIfCmtsModGuardTimeSize"), ("DOCS-IF-MIB", "docsIfCmtsCapabilities"), ("DOCS-IF-MIB", "docsIfCmtsCmPtr"), ("DOCS-IF-MIB", "docsIfCmtsModDifferentialEncoding"), ("DOCS-IF-MIB", "docsIfCmtsModLastCodewordShortened"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleLen"), ("DOCS-IF-MIB", "docsIfCmtsMaxServiceIds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDownChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUpChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsQosProfilePermissions"), ("DOCS-IF-MIB", "docsIfCmtsInvitedRangingAttempts"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsUcdInterval"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsServiceInOctets"), ("DOCS-IF-MIB", "docsIfCmtsServiceCmStatusIndex"), ("DOCS-IF-MIB", "docsIfCmtsStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmtsServiceCreateTime"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusIpAddress"), ("DOCS-IF-MIB", "docsIfCmtsModMaxBurstSize"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMicroreflections"), ("DOCS-IF-MIB", "docsIfCmtsStatusT5Timeouts"), ("DOCS-IF-MIB", "docsIfCmtsModControl"), ("DOCS-IF-MIB", "docsIfCmtsInsertInterval"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusSignalNoise"), )
docsIfCmtsGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 7)).setObjects(("DOCS-IF-MIB", "docsIfCmtsServiceNewCmStatusIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsChannelUtilizationInterval"), ("DOCS-IF-MIB", "docsIfCmtsModScramblerSeed"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalMslots"), ("DOCS-IF-MIB", "docsIfCmtsServiceAdminStatus"), ("DOCS-IF-MIB", "docsIfCmtsModDifferentialEncoding"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleType"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidDataReqs"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsMacStorageType"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrTotalBytes"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaSpreaderEnable"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsModType"), ("DOCS-IF-MIB", "docsIfCmtsModFECCodewordLength"), ("DOCS-IF-MIB", "docsIfCmtsModStorageType"), ("DOCS-IF-MIB", "docsIfCmtsModGuardTimeSize"), ("DOCS-IF-MIB", "docsIfCmtsCmPtr"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsModLastCodewordShortened"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUcastGrantedMslots"), ("DOCS-IF-MIB", "docsIfCmtsServiceCreateTime"), ("DOCS-IF-MIB", "docsIfCmtsModMaxBurstSize"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMicroreflections"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaInterleaverStepSize"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusInetAddressType"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrExtTotalBytes"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusRxPower"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsServiceInPackets"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsSyncInterval"), ("DOCS-IF-MIB", "docsIfCmtsServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmtsStatusFailedRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsCapabilities"), ("DOCS-IF-MIB", "docsIfCmtsChannelUtUtilization"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrId"), ("DOCS-IF-MIB", "docsIfCmtsModScrambler"), ("DOCS-IF-MIB", "docsIfCmtsModByteInterleaverBlockSize"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleLen"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValueLastUpdate"), ("DOCS-IF-MIB", "docsIfCmtsMaxServiceIds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUpChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsModByteInterleaverDepth"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrExtUsedBytes"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaSubframeCodes"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusInetAddress"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfQosProfStorageType"), ("DOCS-IF-MIB", "docsIfCmtsStatusT5Timeouts"), ("DOCS-IF-MIB", "docsIfCmtsQosProfilePermissions"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMacAddress"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrId"), ("DOCS-IF-MIB", "docsIfCmtsModFECErrorCorrection"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusSignalNoise"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrUsedBytes"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDocsisRegMode"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfDownChannelStorageType"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRangeReqs"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusHighResolutionTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDownChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsInvitedRangingAttempts"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsServiceInOctets"), ("DOCS-IF-MIB", "docsIfCmtsUcdInterval"), ("DOCS-IF-MIB", "docsIfCmtsModTcmErrorCorrectionOn"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusModulationType"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmtsModControl"), ("DOCS-IF-MIB", "docsIfCmtsInsertInterval"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUcastGrantedMslots"), ("DOCS-IF-MIB", "docsIfCmtsModChannelType"), )
docsIfCmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 2)).setObjects(("DOCS-IF-MIB", "docsIfCmServiceTxRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmStatusT3Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT1Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidUcds"), ("DOCS-IF-MIB", "docsIfCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRangingResponses"), ("DOCS-IF-MIB", "docsIfCmStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmCapabilities"), ("DOCS-IF-MIB", "docsIfCmStatusCode"), ("DOCS-IF-MIB", "docsIfCmServiceRqRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxExceededs"), ("DOCS-IF-MIB", "docsIfCmServiceRqExceededs"), ("DOCS-IF-MIB", "docsIfCmStatusT4Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusResets"), ("DOCS-IF-MIB", "docsIfCmStatusLostSyncs"), ("DOCS-IF-MIB", "docsIfCmCmtsAddress"), ("DOCS-IF-MIB", "docsIfCmServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmRangingTimeout"), ("DOCS-IF-MIB", "docsIfCmStatusTxPower"), ("DOCS-IF-MIB", "docsIfCmStatusT2Timeouts"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsDed"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidMaps"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRegistrationResponses"), )
docsIfBasicGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 5)).setObjects(("DOCS-IF-MIB", "docsIfQosProfStatus"), ("DOCS-IF-MIB", "docsIfUpChannelCloneFrom"), ("DOCS-IF-MIB", "docsIfSigQExtCorrecteds"), ("DOCS-IF-MIB", "docsIfSigQSignalNoise"), ("DOCS-IF-MIB", "docsIfUpChannelSlotSize"), ("DOCS-IF-MIB", "docsIfQosProfPriority"), ("DOCS-IF-MIB", "docsIfQosProfMaxUpBandwidth"), ("DOCS-IF-MIB", "docsIfDownChannelWidth"), ("DOCS-IF-MIB", "docsIfDownChannelFrequency"), ("DOCS-IF-MIB", "docsIfQosProfMaxTransmitBurst"), ("DOCS-IF-MIB", "docsIfUpChannelPreEqEnable"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaActiveCodes"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelTxTimingOffset"), ("DOCS-IF-MIB", "docsIfUpChannelWidth"), ("DOCS-IF-MIB", "docsIfDownChannelAnnex"), ("DOCS-IF-MIB", "docsIfUpChannelModulationProfile"), ("DOCS-IF-MIB", "docsIfUpChannelType"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelId"), ("DOCS-IF-MIB", "docsIfSigQUnerroreds"), ("DOCS-IF-MIB", "docsIfQosProfMaxDownBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfGuarUpBandwidth"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaFrameSize"), ("DOCS-IF-MIB", "docsIfDocsisBaseCapability"), ("DOCS-IF-MIB", "docsIfSigQMicroreflections"), ("DOCS-IF-MIB", "docsIfUpChannelFrequency"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffEnd"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffEnd"), ("DOCS-IF-MIB", "docsIfDownChannelInterleave"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaCodesPerSlot"), ("DOCS-IF-MIB", "docsIfSigQIncludesContention"), ("DOCS-IF-MIB", "docsIfDownChannelPower"), ("DOCS-IF-MIB", "docsIfUpChannelStatus"), ("DOCS-IF-MIB", "docsIfSigQExtUncorrectables"), ("DOCS-IF-MIB", "docsIfSigQUncorrectables"), ("DOCS-IF-MIB", "docsIfDownChannelModulation"), ("DOCS-IF-MIB", "docsIfUpChannelUpdate"), ("DOCS-IF-MIB", "docsIfSigQCorrecteds"), ("DOCS-IF-MIB", "docsIfDownChannelId"), ("DOCS-IF-MIB", "docsIfSigQExtUnerroreds"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaHoppingSeed"), ("DOCS-IF-MIB", "docsIfQosProfBaselinePrivacy"), )
docsIfObsoleteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 4)).setObjects(("DOCS-IF-MIB", "docsIfCmtsInsertionInterval"), ("DOCS-IF-MIB", "docsIfCmRangingRespTimeout"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DOCS-IF-MIB", PYSNMP_MODULE_ID=docsIfMib)

# Types
mibBuilder.exportSymbols("DOCS-IF-MIB", DocsEqualizerData=DocsEqualizerData, DocsisQosVersion=DocsisQosVersion, DocsisUpstreamType=DocsisUpstreamType, DocsisVersion=DocsisVersion, TenthdB=TenthdB, TenthdBmV=TenthdBmV)

# Objects
mibBuilder.exportSymbols("DOCS-IF-MIB", docsIfMib=docsIfMib, docsIfMibObjects=docsIfMibObjects, docsIfBaseObjects=docsIfBaseObjects, docsIfDownstreamChannelTable=docsIfDownstreamChannelTable, docsIfDownstreamChannelEntry=docsIfDownstreamChannelEntry, docsIfDownChannelId=docsIfDownChannelId, docsIfDownChannelFrequency=docsIfDownChannelFrequency, docsIfDownChannelWidth=docsIfDownChannelWidth, docsIfDownChannelModulation=docsIfDownChannelModulation, docsIfDownChannelInterleave=docsIfDownChannelInterleave, docsIfDownChannelPower=docsIfDownChannelPower, docsIfDownChannelAnnex=docsIfDownChannelAnnex, docsIfDownChannelStorageType=docsIfDownChannelStorageType, docsIfUpstreamChannelTable=docsIfUpstreamChannelTable, docsIfUpstreamChannelEntry=docsIfUpstreamChannelEntry, docsIfUpChannelId=docsIfUpChannelId, docsIfUpChannelFrequency=docsIfUpChannelFrequency, docsIfUpChannelWidth=docsIfUpChannelWidth, docsIfUpChannelModulationProfile=docsIfUpChannelModulationProfile, docsIfUpChannelSlotSize=docsIfUpChannelSlotSize, docsIfUpChannelTxTimingOffset=docsIfUpChannelTxTimingOffset, docsIfUpChannelRangingBackoffStart=docsIfUpChannelRangingBackoffStart, docsIfUpChannelRangingBackoffEnd=docsIfUpChannelRangingBackoffEnd, docsIfUpChannelTxBackoffStart=docsIfUpChannelTxBackoffStart, docsIfUpChannelTxBackoffEnd=docsIfUpChannelTxBackoffEnd, docsIfUpChannelScdmaActiveCodes=docsIfUpChannelScdmaActiveCodes, docsIfUpChannelScdmaCodesPerSlot=docsIfUpChannelScdmaCodesPerSlot, docsIfUpChannelScdmaFrameSize=docsIfUpChannelScdmaFrameSize, docsIfUpChannelScdmaHoppingSeed=docsIfUpChannelScdmaHoppingSeed, docsIfUpChannelType=docsIfUpChannelType, docsIfUpChannelCloneFrom=docsIfUpChannelCloneFrom, docsIfUpChannelUpdate=docsIfUpChannelUpdate, docsIfUpChannelStatus=docsIfUpChannelStatus, docsIfUpChannelPreEqEnable=docsIfUpChannelPreEqEnable, docsIfQosProfileTable=docsIfQosProfileTable, docsIfQosProfileEntry=docsIfQosProfileEntry, docsIfQosProfIndex=docsIfQosProfIndex, docsIfQosProfPriority=docsIfQosProfPriority, docsIfQosProfMaxUpBandwidth=docsIfQosProfMaxUpBandwidth, docsIfQosProfGuarUpBandwidth=docsIfQosProfGuarUpBandwidth, docsIfQosProfMaxDownBandwidth=docsIfQosProfMaxDownBandwidth, docsIfQosProfMaxTxBurst=docsIfQosProfMaxTxBurst, docsIfQosProfBaselinePrivacy=docsIfQosProfBaselinePrivacy, docsIfQosProfStatus=docsIfQosProfStatus, docsIfQosProfMaxTransmitBurst=docsIfQosProfMaxTransmitBurst, docsIfQosProfStorageType=docsIfQosProfStorageType, docsIfSignalQualityTable=docsIfSignalQualityTable, docsIfSignalQualityEntry=docsIfSignalQualityEntry, docsIfSigQIncludesContention=docsIfSigQIncludesContention, docsIfSigQUnerroreds=docsIfSigQUnerroreds, docsIfSigQCorrecteds=docsIfSigQCorrecteds, docsIfSigQUncorrectables=docsIfSigQUncorrectables, docsIfSigQSignalNoise=docsIfSigQSignalNoise, docsIfSigQMicroreflections=docsIfSigQMicroreflections, docsIfSigQEqualizationData=docsIfSigQEqualizationData, docsIfSigQExtUnerroreds=docsIfSigQExtUnerroreds, docsIfSigQExtCorrecteds=docsIfSigQExtCorrecteds, docsIfSigQExtUncorrectables=docsIfSigQExtUncorrectables, docsIfDocsisBaseCapability=docsIfDocsisBaseCapability, docsIfCmObjects=docsIfCmObjects, docsIfCmMacTable=docsIfCmMacTable, docsIfCmMacEntry=docsIfCmMacEntry, docsIfCmCmtsAddress=docsIfCmCmtsAddress, docsIfCmCapabilities=docsIfCmCapabilities, docsIfCmRangingRespTimeout=docsIfCmRangingRespTimeout, docsIfCmRangingTimeout=docsIfCmRangingTimeout, docsIfCmStatusTable=docsIfCmStatusTable, docsIfCmStatusEntry=docsIfCmStatusEntry, docsIfCmStatusValue=docsIfCmStatusValue, docsIfCmStatusCode=docsIfCmStatusCode, docsIfCmStatusTxPower=docsIfCmStatusTxPower, docsIfCmStatusResets=docsIfCmStatusResets, docsIfCmStatusLostSyncs=docsIfCmStatusLostSyncs, docsIfCmStatusInvalidMaps=docsIfCmStatusInvalidMaps, docsIfCmStatusInvalidUcds=docsIfCmStatusInvalidUcds, docsIfCmStatusInvalidRangingResponses=docsIfCmStatusInvalidRangingResponses, docsIfCmStatusInvalidRegistrationResponses=docsIfCmStatusInvalidRegistrationResponses, docsIfCmStatusT1Timeouts=docsIfCmStatusT1Timeouts, docsIfCmStatusT2Timeouts=docsIfCmStatusT2Timeouts, docsIfCmStatusT3Timeouts=docsIfCmStatusT3Timeouts, docsIfCmStatusT4Timeouts=docsIfCmStatusT4Timeouts, docsIfCmStatusRangingAborteds=docsIfCmStatusRangingAborteds, docsIfCmStatusDocsisOperMode=docsIfCmStatusDocsisOperMode, docsIfCmStatusModulationType=docsIfCmStatusModulationType, docsIfCmStatusEqualizationData=docsIfCmStatusEqualizationData, docsIfCmStatusUCCs=docsIfCmStatusUCCs, docsIfCmStatusUCCFails=docsIfCmStatusUCCFails, docsIfCmServiceTable=docsIfCmServiceTable, docsIfCmServiceEntry=docsIfCmServiceEntry, docsIfCmServiceId=docsIfCmServiceId, docsIfCmServiceQosProfile=docsIfCmServiceQosProfile, docsIfCmServiceTxSlotsImmed=docsIfCmServiceTxSlotsImmed, docsIfCmServiceTxSlotsDed=docsIfCmServiceTxSlotsDed, docsIfCmServiceTxRetries=docsIfCmServiceTxRetries, docsIfCmServiceTxExceededs=docsIfCmServiceTxExceededs, docsIfCmServiceRqRetries=docsIfCmServiceRqRetries, docsIfCmServiceRqExceededs=docsIfCmServiceRqExceededs, docsIfCmServiceExtTxSlotsImmed=docsIfCmServiceExtTxSlotsImmed, docsIfCmServiceExtTxSlotsDed=docsIfCmServiceExtTxSlotsDed, docsIfCmtsObjects=docsIfCmtsObjects, docsIfCmtsMacTable=docsIfCmtsMacTable, docsIfCmtsMacEntry=docsIfCmtsMacEntry, docsIfCmtsCapabilities=docsIfCmtsCapabilities, docsIfCmtsSyncInterval=docsIfCmtsSyncInterval, docsIfCmtsUcdInterval=docsIfCmtsUcdInterval, docsIfCmtsMaxServiceIds=docsIfCmtsMaxServiceIds, docsIfCmtsInsertionInterval=docsIfCmtsInsertionInterval, docsIfCmtsInvitedRangingAttempts=docsIfCmtsInvitedRangingAttempts, docsIfCmtsInsertInterval=docsIfCmtsInsertInterval, docsIfCmtsMacStorageType=docsIfCmtsMacStorageType, docsIfCmtsStatusTable=docsIfCmtsStatusTable, docsIfCmtsStatusEntry=docsIfCmtsStatusEntry, docsIfCmtsStatusInvalidRangeReqs=docsIfCmtsStatusInvalidRangeReqs, docsIfCmtsStatusRangingAborteds=docsIfCmtsStatusRangingAborteds, docsIfCmtsStatusInvalidRegReqs=docsIfCmtsStatusInvalidRegReqs, docsIfCmtsStatusFailedRegReqs=docsIfCmtsStatusFailedRegReqs, docsIfCmtsStatusInvalidDataReqs=docsIfCmtsStatusInvalidDataReqs, docsIfCmtsStatusT5Timeouts=docsIfCmtsStatusT5Timeouts, docsIfCmtsCmStatusTable=docsIfCmtsCmStatusTable, docsIfCmtsCmStatusEntry=docsIfCmtsCmStatusEntry, docsIfCmtsCmStatusIndex=docsIfCmtsCmStatusIndex, docsIfCmtsCmStatusMacAddress=docsIfCmtsCmStatusMacAddress, docsIfCmtsCmStatusIpAddress=docsIfCmtsCmStatusIpAddress, docsIfCmtsCmStatusDownChannelIfIndex=docsIfCmtsCmStatusDownChannelIfIndex, docsIfCmtsCmStatusUpChannelIfIndex=docsIfCmtsCmStatusUpChannelIfIndex, docsIfCmtsCmStatusRxPower=docsIfCmtsCmStatusRxPower)
mibBuilder.exportSymbols("DOCS-IF-MIB", docsIfCmtsCmStatusTimingOffset=docsIfCmtsCmStatusTimingOffset, docsIfCmtsCmStatusEqualizationData=docsIfCmtsCmStatusEqualizationData, docsIfCmtsCmStatusValue=docsIfCmtsCmStatusValue, docsIfCmtsCmStatusUnerroreds=docsIfCmtsCmStatusUnerroreds, docsIfCmtsCmStatusCorrecteds=docsIfCmtsCmStatusCorrecteds, docsIfCmtsCmStatusUncorrectables=docsIfCmtsCmStatusUncorrectables, docsIfCmtsCmStatusSignalNoise=docsIfCmtsCmStatusSignalNoise, docsIfCmtsCmStatusMicroreflections=docsIfCmtsCmStatusMicroreflections, docsIfCmtsCmStatusExtUnerroreds=docsIfCmtsCmStatusExtUnerroreds, docsIfCmtsCmStatusExtCorrecteds=docsIfCmtsCmStatusExtCorrecteds, docsIfCmtsCmStatusExtUncorrectables=docsIfCmtsCmStatusExtUncorrectables, docsIfCmtsCmStatusDocsisRegMode=docsIfCmtsCmStatusDocsisRegMode, docsIfCmtsCmStatusModulationType=docsIfCmtsCmStatusModulationType, docsIfCmtsCmStatusInetAddressType=docsIfCmtsCmStatusInetAddressType, docsIfCmtsCmStatusInetAddress=docsIfCmtsCmStatusInetAddress, docsIfCmtsCmStatusValueLastUpdate=docsIfCmtsCmStatusValueLastUpdate, docsIfCmtsCmStatusHighResolutionTimingOffset=docsIfCmtsCmStatusHighResolutionTimingOffset, docsIfCmtsServiceTable=docsIfCmtsServiceTable, docsIfCmtsServiceEntry=docsIfCmtsServiceEntry, docsIfCmtsServiceId=docsIfCmtsServiceId, docsIfCmtsServiceCmStatusIndex=docsIfCmtsServiceCmStatusIndex, docsIfCmtsServiceAdminStatus=docsIfCmtsServiceAdminStatus, docsIfCmtsServiceQosProfile=docsIfCmtsServiceQosProfile, docsIfCmtsServiceCreateTime=docsIfCmtsServiceCreateTime, docsIfCmtsServiceInOctets=docsIfCmtsServiceInOctets, docsIfCmtsServiceInPackets=docsIfCmtsServiceInPackets, docsIfCmtsServiceNewCmStatusIndex=docsIfCmtsServiceNewCmStatusIndex, docsIfCmtsModulationTable=docsIfCmtsModulationTable, docsIfCmtsModulationEntry=docsIfCmtsModulationEntry, docsIfCmtsModIndex=docsIfCmtsModIndex, docsIfCmtsModIntervalUsageCode=docsIfCmtsModIntervalUsageCode, docsIfCmtsModControl=docsIfCmtsModControl, docsIfCmtsModType=docsIfCmtsModType, docsIfCmtsModPreambleLen=docsIfCmtsModPreambleLen, docsIfCmtsModDifferentialEncoding=docsIfCmtsModDifferentialEncoding, docsIfCmtsModFECErrorCorrection=docsIfCmtsModFECErrorCorrection, docsIfCmtsModFECCodewordLength=docsIfCmtsModFECCodewordLength, docsIfCmtsModScramblerSeed=docsIfCmtsModScramblerSeed, docsIfCmtsModMaxBurstSize=docsIfCmtsModMaxBurstSize, docsIfCmtsModGuardTimeSize=docsIfCmtsModGuardTimeSize, docsIfCmtsModLastCodewordShortened=docsIfCmtsModLastCodewordShortened, docsIfCmtsModScrambler=docsIfCmtsModScrambler, docsIfCmtsModByteInterleaverDepth=docsIfCmtsModByteInterleaverDepth, docsIfCmtsModByteInterleaverBlockSize=docsIfCmtsModByteInterleaverBlockSize, docsIfCmtsModPreambleType=docsIfCmtsModPreambleType, docsIfCmtsModTcmErrorCorrectionOn=docsIfCmtsModTcmErrorCorrectionOn, docsIfCmtsModScdmaInterleaverStepSize=docsIfCmtsModScdmaInterleaverStepSize, docsIfCmtsModScdmaSpreaderEnable=docsIfCmtsModScdmaSpreaderEnable, docsIfCmtsModScdmaSubframeCodes=docsIfCmtsModScdmaSubframeCodes, docsIfCmtsModChannelType=docsIfCmtsModChannelType, docsIfCmtsModStorageType=docsIfCmtsModStorageType, docsIfCmtsQosProfilePermissions=docsIfCmtsQosProfilePermissions, docsIfCmtsMacToCmTable=docsIfCmtsMacToCmTable, docsIfCmtsMacToCmEntry=docsIfCmtsMacToCmEntry, docsIfCmtsCmMac=docsIfCmtsCmMac, docsIfCmtsCmPtr=docsIfCmtsCmPtr, docsIfCmtsChannelUtilizationInterval=docsIfCmtsChannelUtilizationInterval, docsIfCmtsChannelUtilizationTable=docsIfCmtsChannelUtilizationTable, docsIfCmtsChannelUtilizationEntry=docsIfCmtsChannelUtilizationEntry, docsIfCmtsChannelUtIfType=docsIfCmtsChannelUtIfType, docsIfCmtsChannelUtId=docsIfCmtsChannelUtId, docsIfCmtsChannelUtUtilization=docsIfCmtsChannelUtUtilization, docsIfCmtsDownChannelCounterTable=docsIfCmtsDownChannelCounterTable, docsIfCmtsDownChannelCounterEntry=docsIfCmtsDownChannelCounterEntry, docsIfCmtsDownChnlCtrId=docsIfCmtsDownChnlCtrId, docsIfCmtsDownChnlCtrTotalBytes=docsIfCmtsDownChnlCtrTotalBytes, docsIfCmtsDownChnlCtrUsedBytes=docsIfCmtsDownChnlCtrUsedBytes, docsIfCmtsDownChnlCtrExtTotalBytes=docsIfCmtsDownChnlCtrExtTotalBytes, docsIfCmtsDownChnlCtrExtUsedBytes=docsIfCmtsDownChnlCtrExtUsedBytes, docsIfCmtsUpChannelCounterTable=docsIfCmtsUpChannelCounterTable, docsIfCmtsUpChannelCounterEntry=docsIfCmtsUpChannelCounterEntry, docsIfCmtsUpChnlCtrId=docsIfCmtsUpChnlCtrId, docsIfCmtsUpChnlCtrTotalMslots=docsIfCmtsUpChnlCtrTotalMslots, docsIfCmtsUpChnlCtrUcastGrantedMslots=docsIfCmtsUpChnlCtrUcastGrantedMslots, docsIfCmtsUpChnlCtrTotalCntnMslots=docsIfCmtsUpChnlCtrTotalCntnMslots, docsIfCmtsUpChnlCtrUsedCntnMslots=docsIfCmtsUpChnlCtrUsedCntnMslots, docsIfCmtsUpChnlCtrExtTotalMslots=docsIfCmtsUpChnlCtrExtTotalMslots, docsIfCmtsUpChnlCtrExtUcastGrantedMslots=docsIfCmtsUpChnlCtrExtUcastGrantedMslots, docsIfCmtsUpChnlCtrExtTotalCntnMslots=docsIfCmtsUpChnlCtrExtTotalCntnMslots, docsIfCmtsUpChnlCtrExtUsedCntnMslots=docsIfCmtsUpChnlCtrExtUsedCntnMslots, docsIfCmtsUpChnlCtrCollCntnMslots=docsIfCmtsUpChnlCtrCollCntnMslots, docsIfCmtsUpChnlCtrTotalCntnReqMslots=docsIfCmtsUpChnlCtrTotalCntnReqMslots, docsIfCmtsUpChnlCtrUsedCntnReqMslots=docsIfCmtsUpChnlCtrUsedCntnReqMslots, docsIfCmtsUpChnlCtrCollCntnReqMslots=docsIfCmtsUpChnlCtrCollCntnReqMslots, docsIfCmtsUpChnlCtrTotalCntnReqDataMslots=docsIfCmtsUpChnlCtrTotalCntnReqDataMslots, docsIfCmtsUpChnlCtrUsedCntnReqDataMslots=docsIfCmtsUpChnlCtrUsedCntnReqDataMslots, docsIfCmtsUpChnlCtrCollCntnReqDataMslots=docsIfCmtsUpChnlCtrCollCntnReqDataMslots, docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots=docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots, docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots=docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots, docsIfCmtsUpChnlCtrCollCntnInitMaintMslots=docsIfCmtsUpChnlCtrCollCntnInitMaintMslots, docsIfCmtsUpChnlCtrExtCollCntnMslots=docsIfCmtsUpChnlCtrExtCollCntnMslots, docsIfCmtsUpChnlCtrExtTotalCntnReqMslots=docsIfCmtsUpChnlCtrExtTotalCntnReqMslots, docsIfCmtsUpChnlCtrExtUsedCntnReqMslots=docsIfCmtsUpChnlCtrExtUsedCntnReqMslots, docsIfCmtsUpChnlCtrExtCollCntnReqMslots=docsIfCmtsUpChnlCtrExtCollCntnReqMslots, docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots=docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots, docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots=docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots, docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots=docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots, docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots, docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots, docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots, docsIfNotification=docsIfNotification, docsIfConformance=docsIfConformance, docsIfCompliances=docsIfCompliances, docsIfGroups=docsIfGroups)

# Groups
mibBuilder.exportSymbols("DOCS-IF-MIB", docsIfBasicGroup=docsIfBasicGroup, docsIfCmGroupV2=docsIfCmGroupV2, docsIfCmtsGroup=docsIfCmtsGroup, docsIfCmtsGroupV2=docsIfCmtsGroupV2, docsIfCmGroup=docsIfCmGroup, docsIfBasicGroupV2=docsIfBasicGroupV2, docsIfObsoleteGroup=docsIfObsoleteGroup)
