# PySNMP SMI module. Autogenerated from smidump -f python DS0BUNDLE-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:18 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( DisplayString, RowStatus, TestAndIncr, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TestAndIncr")

# Objects

ds0Bundle = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 82)).setRevisions(("1998-07-16 16:30","1998-05-24 20:10",))
if mibBuilder.loadTexts: ds0Bundle.setOrganization("IETF Trunk MIB Working Group")
if mibBuilder.loadTexts: ds0Bundle.setContactInfo("        David Fowler\n\nPostal: Newbridge Networks Corporation\n        600 March Road\n        Kanata, Ontario, Canada K2K 2E6\n\n        Tel: +1 613 591 3600\n        Fax: +1 613 599 3619\n\nE-mail: davef@newbridge.com")
if mibBuilder.loadTexts: ds0Bundle.setDescription("The MIB module to describe\nDS0 Bundle interfaces objects.")
dsx0BondingTable = MibTable((1, 3, 6, 1, 2, 1, 10, 82, 1))
if mibBuilder.loadTexts: dsx0BondingTable.setDescription("The DS0 Bonding table.")
dsx0BondingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 82, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dsx0BondingEntry.setDescription("An entry in the DS0 Bonding table.  There is a\nrow in this table for each DS0Bundle interface.")
dsx0BondMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,6,3,4,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("other", 2), ("mode0", 3), ("mode1", 4), ("mode2", 5), ("mode3", 6), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsx0BondMode.setDescription("This object indicates which BONDing mode is used,\nif any, for a ds0Bundle.  Mode0 provides parameter\nand number exchange with no synchronization.  Mode\n1 provides parameter and number exchange.  Mode 1\nalso provides synchronization during\ninitialization but does not include inband\nmonitoring.  Mode 2 provides all of the above plus\ninband monitoring.  Mode 2 also steals 1/64th of\nthe bandwidth of each channel (thus not supporting\nn x 56/64 kbit/s data channels for most values of\nn). Mode 3 provides all of the above, but also\nprovides n x 56/64 kbit/s data channels.  Most\ncommon implementations of Mode 3 add an extra\nchannel to support the inband monitoring overhead.\nModeNone should be used when the interface is not\nperforming bandwidth-on-demand.")
dsx0BondStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("idle", 1), ("callSetup", 2), ("dataTransfer", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx0BondStatus.setDescription("This object indicates the current status of the\nbonding call using this ds0Bundle. idle(1) should\nbe used when the bonding mode is set to none(1).")
dsx0BondRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 1, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsx0BondRowStatus.setDescription("This object is used to create new rows in this\ntable, modify existing rows, and to delete\nexisting rows.")
dsx0BundleNextIndex = MibScalar((1, 3, 6, 1, 2, 1, 10, 82, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx0BundleNextIndex.setDescription("This object is used to assist the manager in\nselecting a value for dsx0BundleIndex.  Because\nthis object is of syntax TestAndIncr (see the\nSNMPv2-TC document, RFC 1903) it can also be used\nto avoid race conditions with multiple managers\ntrying to create rows in the table.\n\nIf the result of the SET for dsx0BundleNextIndex\nis not success, this means the value has been\nchanged from index (i.e. another manager used the\nvalue), so a new value is required.\n\nThe algorithm is:\ndone = false\nwhile done == false\n    index = GET (dsx0BundleNextIndex.0)\n    SET (dsx0BundleNextIndex.0=index)\n    if (set failed)\n      done = false\n    else\n      SET(dsx0BundleRowStatus.index=createAndGo)\n      if (set failed)\n        done = false\n      else\n        done = true\n        other error handling")
dsx0BundleTable = MibTable((1, 3, 6, 1, 2, 1, 10, 82, 3))
if mibBuilder.loadTexts: dsx0BundleTable.setDescription("There is an row in this table for each ds0Bundle\nin the system.  This table can be used to\n(indirectly) create rows in the ifTable with\nifType = 'ds0Bundle(82)'.")
dsx0BundleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 82, 3, 1)).setIndexNames((0, "DS0BUNDLE-MIB", "dsx0BundleIndex"))
if mibBuilder.loadTexts: dsx0BundleEntry.setDescription("There is a row in entry in this table for each\nds0Bundle interface.")
dsx0BundleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsx0BundleIndex.setDescription("A unique identifier for a ds0Bundle.  This is not\nthe same value as ifIndex.  This table is not\nindexed by ifIndex because the manager has to\nchoose the index in a createable row and the agent\nmust be allowed to select ifIndex values.")
dsx0BundleIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 3, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx0BundleIfIndex.setDescription("The ifIndex value the agent selected for the\n(new) ds0Bundle interface.")
dsx0BundleCircuitIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 3, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsx0BundleCircuitIdentifier.setDescription("This variable contains the transmission vendor's\ncircuit identifier, for the purpose of\nfacilitating troubleshooting.")
dsx0BundleRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 82, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsx0BundleRowStatus.setDescription("This object is used to create and delete rows in\nthis table.")
ds0BundleConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 82, 4))
ds0BundleGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 82, 4, 1))
ds0BundleCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 82, 4, 2))

# Augmentions

# Groups

ds0BundleConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 82, 4, 1, 2)).setObjects(("DS0BUNDLE-MIB", "dsx0BundleIfIndex"), ("DS0BUNDLE-MIB", "dsx0BundleRowStatus"), ("DS0BUNDLE-MIB", "dsx0BundleCircuitIdentifier"), ("DS0BUNDLE-MIB", "dsx0BundleNextIndex"), )
ds0BondingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 82, 4, 1, 1)).setObjects(("DS0BUNDLE-MIB", "dsx0BondMode"), ("DS0BUNDLE-MIB", "dsx0BondStatus"), ("DS0BUNDLE-MIB", "dsx0BondRowStatus"), )

# Exports

# Module identity
mibBuilder.exportSymbols("DS0BUNDLE-MIB", PYSNMP_MODULE_ID=ds0Bundle)

# Objects
mibBuilder.exportSymbols("DS0BUNDLE-MIB", ds0Bundle=ds0Bundle, dsx0BondingTable=dsx0BondingTable, dsx0BondingEntry=dsx0BondingEntry, dsx0BondMode=dsx0BondMode, dsx0BondStatus=dsx0BondStatus, dsx0BondRowStatus=dsx0BondRowStatus, dsx0BundleNextIndex=dsx0BundleNextIndex, dsx0BundleTable=dsx0BundleTable, dsx0BundleEntry=dsx0BundleEntry, dsx0BundleIndex=dsx0BundleIndex, dsx0BundleIfIndex=dsx0BundleIfIndex, dsx0BundleCircuitIdentifier=dsx0BundleCircuitIdentifier, dsx0BundleRowStatus=dsx0BundleRowStatus, ds0BundleConformance=ds0BundleConformance, ds0BundleGroups=ds0BundleGroups, ds0BundleCompliances=ds0BundleCompliances)

# Groups
mibBuilder.exportSymbols("DS0BUNDLE-MIB", ds0BundleConfigGroup=ds0BundleConfigGroup, ds0BondingGroup=ds0BondingGroup)
