# PySNMP SMI module. Autogenerated from smidump -f python ETHER-WIS
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:19 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( sonetFarEndLineStuff2, sonetFarEndPathStuff2, sonetLineStuff2, sonetMediumCircuitIdentifier, sonetMediumLineCoding, sonetMediumLineType, sonetMediumLoopbackConfig, sonetMediumStuff2, sonetMediumType, sonetPathCurrentWidth, sonetPathStuff2, sonetSESthresholdSet, sonetSectionStuff2, ) = mibBuilder.importSymbols("SONET-MIB", "sonetFarEndLineStuff2", "sonetFarEndPathStuff2", "sonetLineStuff2", "sonetMediumCircuitIdentifier", "sonetMediumLineCoding", "sonetMediumLineType", "sonetMediumLoopbackConfig", "sonetMediumStuff2", "sonetMediumType", "sonetPathCurrentWidth", "sonetPathStuff2", "sonetSESthresholdSet", "sonetSectionStuff2")

# Objects

etherWisMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 134)).setRevisions(("2003-09-19 00:00",))
if mibBuilder.loadTexts: etherWisMIB.setOrganization("IETF Ethernet Interfaces and Hub MIB\nWorking Group")
if mibBuilder.loadTexts: etherWisMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/hubmib-charter.html\n\nMailing Lists:\nGeneral Discussion: hubmib@ietf.org\nTo Subscribe: hubmib-request@ietf.org\nIn Body: subscribe your_email_address\n\nChair: Dan Romascanu\nPostal: Avaya Inc.\n      Atidim Technology Park, Bldg. 3\n      Tel Aviv 61131\n      Israel\n Tel: +972 3 645 8414\nE-mail: dromasca@avaya.com\n\nEditor: C. M. Heard\nPostal: 600 Rainbow Dr. #141\n      Mountain View, CA 94041-2542\n      USA\n Tel: +1 650-964-8391\nE-mail: heard@pobox.com")
if mibBuilder.loadTexts: etherWisMIB.setDescription("The objects in this MIB module are used in conjunction\nwith objects in the SONET-MIB and the MAU-MIB to manage\nthe Ethernet WAN Interface Sublayer (WIS).\n\nThe following reference is used throughout this MIB module:\n\n[IEEE 802.3 Std] refers to:\n   IEEE Std 802.3, 2000 Edition: 'IEEE Standard for\n   Information technology - Telecommunications and\n   information exchange between systems - Local and\n   metropolitan area networks - Specific requirements -\n   Part 3: Carrier sense multiple access with collision\n   detection (CSMA/CD) access method and physical layer\n   specifications', as amended by IEEE Std 802.3ae-2002,\n   'IEEE Standard for Carrier Sense Multiple Access with\n   Collision Detection (CSMA/CD) Access Method and\n   Physical Layer Specifications - Media Access Control\n   (MAC) Parameters, Physical Layer and Management\n   Parameters for 10 Gb/s Operation', 30 August 2002.\n\nOf particular interest are Clause 50, 'WAN Interface\nSublayer (WIS), type 10GBASE-W', Clause 30, '10Mb/s,\n100Mb/s, 1000Mb/s, and 10Gb/s MAC Control, and Link\nAggregation Management', and Clause 45, 'Management\nData Input/Output (MDIO) Interface'.\n\nCopyright (C) The Internet Society (2003).  This version\nof this MIB module is part of RFC 3637;  see the RFC\nitself for full legal notices.")
etherWisObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 1))
etherWisDevice = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 1, 1))
etherWisDeviceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 134, 1, 1, 1))
if mibBuilder.loadTexts: etherWisDeviceTable.setDescription("The table for Ethernet WIS devices")
etherWisDeviceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 134, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: etherWisDeviceEntry.setDescription("An entry in the Ethernet WIS device table.  For each\ninstance of this object there MUST be a corresponding\ninstance of sonetMediumEntry.")
etherWisDeviceTxTestPatternMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 1, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("squareWave", 2), ("prbs31", 3), ("mixedFrequency", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherWisDeviceTxTestPatternMode.setDescription("This variable controls the transmit test pattern mode.\nThe value none(1) puts the the WIS transmit path into\nthe normal operating mode.  The value squareWave(2) puts\nthe WIS transmit path into the square wave test pattern\nmode described in [IEEE 802.3 Std.] subclause 50.3.8.1.\nThe value prbs31(3) puts the WIS transmit path into the\nPRBS31 test pattern mode described in [IEEE 802.3 Std.]\nsubclause 50.3.8.2.  The value mixedFrequency(4) puts the\nWIS transmit path into the mixed frequency test pattern\nmode described in [IEEE 802.3 Std.] subclause 50.3.8.3.\nAny attempt to set this object to a value other than\nnone(1) when the corresponding instance of ifAdminStatus\nhas the value up(1) MUST be rejected with the error\ninconsistentValue, and any attempt to set the corresponding\ninstance of ifAdminStatus to the value up(1) when an\ninstance of this object has a value other than none(1)\nMUST be rejected with the error inconsistentValue.")
etherWisDeviceRxTestPatternMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 1, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("prbs31", 3), ("mixedFrequency", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherWisDeviceRxTestPatternMode.setDescription("This variable controls the receive test pattern mode.\nThe value none(1) puts the the WIS receive path into the\nnormal operating mode.  The value prbs31(3) puts the WIS\nreceive path into the PRBS31 test pattern mode described\nin [IEEE 802.3 Std.] subclause 50.3.8.2.  The value\nmixedFrequency(4) puts the WIS receive path into the mixed\nfrequency test pattern mode described in [IEEE 802.3 Std.]\nsubclause 50.3.8.3.  Any attempt to set this object to a\nvalue other than none(1) when the corresponding instance\nof ifAdminStatus has the value up(1) MUST be rejected with\nthe error inconsistentValue, and any attempt to set the\ncorresponding instance of ifAdminStatus to the value up(1)\nwhen an instance of this object has a value other than\nnone(1) MUST be rejected with the error inconsistentValue.")
etherWisDeviceRxTestPatternErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 1, 1, 1, 1, 3), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherWisDeviceRxTestPatternErrors.setDescription("This object counts the number of errors detected when the\nWIS receive path is operating in the PRBS31 test pattern\nmode.  It is reset to zero when the WIS receive path\ninitially enters that mode, and it increments each time\nthe PRBS pattern checker detects an error as described in\n[IEEE 802.3 Std.] subclause 50.3.8.2 unless its value is\n65535, in which case it remains unchanged.  This object is\nwriteable so that it may be reset upon explicit request\nof a command generator application while the WIS receive\npath continues to operate in PRBS31 test pattern mode.")
etherWisSection = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 1, 2))
etherWisSectionCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 134, 1, 2, 1))
if mibBuilder.loadTexts: etherWisSectionCurrentTable.setDescription("The table for the current state of Ethernet WIS sections.")
etherWisSectionCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 134, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: etherWisSectionCurrentEntry.setDescription("An entry in the etherWisSectionCurrentTable.  For each\ninstance of this object there MUST be a corresponding\ninstance of sonetSectionCurrentEntry.")
etherWisSectionCurrentJ0Transmitted = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 1, 2, 1, 1, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(16, 16)).setFixedLength(16)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherWisSectionCurrentJ0Transmitted.setDescription("This is the 16-octet section trace message that\nis transmitted in the J0 byte.  The value SHOULD\nbe '89'h followed by fifteen octets of '00'h\n(or some cyclic shift thereof) when the section\ntrace function is not used, and the implementation\nSHOULD use that value (or a cyclic shift thereof)\nas a default if no other value has been set.")
etherWisSectionCurrentJ0Received = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 1, 2, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(16, 16)).setFixedLength(16)).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherWisSectionCurrentJ0Received.setDescription("This is the 16-octet section trace message that\nwas most recently received in the J0 byte.")
etherWisObjectsPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 2))
etherWisPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 2, 1))
etherWisPathCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 134, 2, 1, 1))
if mibBuilder.loadTexts: etherWisPathCurrentTable.setDescription("The table for the current state of Ethernet WIS paths.")
etherWisPathCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 134, 2, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: etherWisPathCurrentEntry.setDescription("An entry in the etherWisPathCurrentTable.  For each\ninstance of this object there MUST be a corresponding\ninstance of sonetPathCurrentEntry.")
etherWisPathCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 2, 1, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("etherWisPathLOP", 0), ("etherWisPathAIS", 1), ("etherWisPathPLM", 2), ("etherWisPathLCD", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherWisPathCurrentStatus.setDescription("This variable indicates the current status of the\npath payload with a bit map that can indicate multiple\ndefects at once.  The bit positions are assigned as\nfollows:\n\netherWisPathLOP(0)\n   This bit is set to indicate that an\n   LOP-P (Loss of Pointer - Path) defect\n   is being experienced.  Note:  when this\n   bit is set, sonetPathSTSLOP MUST be set\n   in the corresponding instance of\n   sonetPathCurrentStatus.\n\netherWisPathAIS(1)\n   This bit is set to indicate that an\n   AIS-P (Alarm Indication Signal - Path)\n   defect is being experienced.  Note:  when\n   this bit is set, sonetPathSTSAIS MUST be\n   set in the corresponding instance of\n   sonetPathCurrentStatus.\n\netherWisPathPLM(1)\n   This bit is set to indicate that a\n   PLM-P (Payload Label Mismatch - Path)\n   defect is being experienced.  Note:  when\n   this bit is set, sonetPathSignalLabelMismatch\n   MUST be set in the corresponding instance of\n   sonetPathCurrentStatus.\n\n\n\n\n\n\n\n\n\n\n\n\n\netherWisPathLCD(3)\n   This bit is set to indicate that an\n   LCD-P (Loss of Codegroup Delination - Path)\n   defect is being experienced.  Since this\n   defect is detected by the PCS and not by\n   the path layer itself, there is no\n   corresponding bit in sonetPathCurrentStatus.")
etherWisPathCurrentJ1Transmitted = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 2, 1, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(16, 16)).setFixedLength(16)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherWisPathCurrentJ1Transmitted.setDescription("This is the 16-octet path trace message that\nis transmitted in the J1 byte.  The value SHOULD\nbe '89'h followed by fifteen octets of '00'h\n(or some cyclic shift thereof) when the path\ntrace function is not used, and the implementation\nSHOULD use that value (or a cyclic shift thereof)\nas a default if no other value has been set.")
etherWisPathCurrentJ1Received = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 2, 1, 1, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(16, 16)).setFixedLength(16)).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherWisPathCurrentJ1Received.setDescription("This is the 16-octet path trace message that\nwas most recently received in the J1 byte.")
etherWisFarEndPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 2, 2))
etherWisFarEndPathCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 134, 2, 2, 1))
if mibBuilder.loadTexts: etherWisFarEndPathCurrentTable.setDescription("The table for the current far-end state of Ethernet WIS\npaths.")
etherWisFarEndPathCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 134, 2, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: etherWisFarEndPathCurrentEntry.setDescription("An entry in the etherWisFarEndPathCurrentTable.  For each\ninstance of this object there MUST be a corresponding\ninstance of sonetFarEndPathCurrentEntry.")
etherWisFarEndPathCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 134, 2, 2, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("etherWisFarEndPayloadDefect", 0), ("etherWisFarEndServerDefect", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherWisFarEndPathCurrentStatus.setDescription("This variable indicates the current status at the\nfar end of the path using a bit map that can indicate\nmultiple defects at once.  The bit positions are\nassigned as follows:\n\netherWisFarEndPayloadDefect(0)\n   A far end payload defect (i.e., far end\n   PLM-P or LCD-P) is currently being signaled\n   in G1 bits 5-7.\n\n\n\n\netherWisFarEndServerDefect(1)\n   A far end server defect (i.e., far end\n   LOP-P or AIS-P) is currently being signaled\n   in G1 bits 5-7.  Note:  when this bit is set,\n   sonetPathSTSRDI MUST be set in the corresponding\n   instance of sonetPathCurrentStatus.")
etherWisConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 3))
etherWisGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 3, 1))
etherWisCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 134, 3, 2))

# Augmentions

# Groups

etherWisDeviceGroupBasic = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 134, 3, 1, 1)).setObjects(("ETHER-WIS", "etherWisDeviceRxTestPatternMode"), ("ETHER-WIS", "etherWisDeviceTxTestPatternMode"), )
etherWisDeviceGroupExtra = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 134, 3, 1, 2)).setObjects(("ETHER-WIS", "etherWisDeviceRxTestPatternErrors"), )
etherWisPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 134, 3, 1, 4)).setObjects(("ETHER-WIS", "etherWisPathCurrentStatus"), ("ETHER-WIS", "etherWisPathCurrentJ1Transmitted"), ("ETHER-WIS", "etherWisPathCurrentJ1Received"), )
etherWisFarEndPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 134, 3, 1, 5)).setObjects(("ETHER-WIS", "etherWisFarEndPathCurrentStatus"), )
etherWisSectionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 134, 3, 1, 3)).setObjects(("ETHER-WIS", "etherWisSectionCurrentJ0Received"), ("ETHER-WIS", "etherWisSectionCurrentJ0Transmitted"), )

# Exports

# Module identity
mibBuilder.exportSymbols("ETHER-WIS", PYSNMP_MODULE_ID=etherWisMIB)

# Objects
mibBuilder.exportSymbols("ETHER-WIS", etherWisMIB=etherWisMIB, etherWisObjects=etherWisObjects, etherWisDevice=etherWisDevice, etherWisDeviceTable=etherWisDeviceTable, etherWisDeviceEntry=etherWisDeviceEntry, etherWisDeviceTxTestPatternMode=etherWisDeviceTxTestPatternMode, etherWisDeviceRxTestPatternMode=etherWisDeviceRxTestPatternMode, etherWisDeviceRxTestPatternErrors=etherWisDeviceRxTestPatternErrors, etherWisSection=etherWisSection, etherWisSectionCurrentTable=etherWisSectionCurrentTable, etherWisSectionCurrentEntry=etherWisSectionCurrentEntry, etherWisSectionCurrentJ0Transmitted=etherWisSectionCurrentJ0Transmitted, etherWisSectionCurrentJ0Received=etherWisSectionCurrentJ0Received, etherWisObjectsPath=etherWisObjectsPath, etherWisPath=etherWisPath, etherWisPathCurrentTable=etherWisPathCurrentTable, etherWisPathCurrentEntry=etherWisPathCurrentEntry, etherWisPathCurrentStatus=etherWisPathCurrentStatus, etherWisPathCurrentJ1Transmitted=etherWisPathCurrentJ1Transmitted, etherWisPathCurrentJ1Received=etherWisPathCurrentJ1Received, etherWisFarEndPath=etherWisFarEndPath, etherWisFarEndPathCurrentTable=etherWisFarEndPathCurrentTable, etherWisFarEndPathCurrentEntry=etherWisFarEndPathCurrentEntry, etherWisFarEndPathCurrentStatus=etherWisFarEndPathCurrentStatus, etherWisConformance=etherWisConformance, etherWisGroups=etherWisGroups, etherWisCompliances=etherWisCompliances)

# Groups
mibBuilder.exportSymbols("ETHER-WIS", etherWisDeviceGroupBasic=etherWisDeviceGroupBasic, etherWisDeviceGroupExtra=etherWisDeviceGroupExtra, etherWisPathGroup=etherWisPathGroup, etherWisFarEndPathGroup=etherWisFarEndPathGroup, etherWisSectionGroup=etherWisSectionGroup)
