# PySNMP SMI module. Autogenerated from smidump -f python FDDI-SMT73-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:19 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( transmission, ) = mibBuilder.importSymbols("RFC1213-MIB", "transmission")
( Bits, Counter32, Integer32, Integer32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")

# Types

class FddiMACLongAddressType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(6,6)
    fixedLength = 6
    pass

class FddiResourceId(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,65535)
    pass

class FddiSMTStationIdType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    fixedLength = 8
    pass

class FddiTimeMilli(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class FddiTimeNano(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass


# Objects

fddi = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15))
fddimib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73))
fddimibSMT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 1))
fddimibSMTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTNumber.setDescription("The number of SMT implementations (regardless of\ntheir current state) on this network management\napplication entity.  The value for this variable\nmust remain constant at least from one re-\ninitialization of the entity's network management\nsystem to the next re-initialization.")
fddimibSMTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2))
if mibBuilder.loadTexts: fddimibSMTTable.setDescription("A list of SMT entries.  The number of entries\nshall not exceed the value of fddimibSMTNumber.")
fddimibSMTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibSMTIndex"))
if mibBuilder.loadTexts: fddimibSMTEntry.setDescription("An SMT entry containing information common to a\ngiven SMT.")
fddimibSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTIndex.setDescription("A unique value for each SMT.  The value for each\nSMT must remain constant at least from one re-\ninitialization of the entity's network management\nsystem to the next re-initialization.")
fddimibSMTStationId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 2), FddiSMTStationIdType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTStationId.setDescription("Used to uniquely identify an FDDI station.")
fddimibSMTOpVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTOpVersionId.setDescription("The version that this station is using for its\noperation (refer to ANSI 7.1.2.2). The value of\nthis variable is 2 for this SMT revision.")
fddimibSMTHiVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTHiVersionId.setDescription("The highest version of SMT that this station\nsupports (refer to ANSI 7.1.2.2).")
fddimibSMTLoVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTLoVersionId.setDescription("The lowest version of SMT that this station\nsupports (refer to ANSI 7.1.2.2).")
fddimibSMTUserData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 6), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(32, 32)).setFixedLength(32)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTUserData.setDescription("This variable contains 32 octets of user defined\ninformation. The information shall be an ASCII\nstring.")
fddimibSMTMIBVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMIBVersionId.setDescription("The version of the FDDI MIB of this station.  The\nvalue of this variable is 1 for this SMT\nrevision.")
fddimibSMTMACCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMACCts.setDescription("The number of MACs in this station or\nconcentrator.")
fddimibSMTNonMasterCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTNonMasterCts.setDescription("The value of this variable is the number of A, B,\nand S ports in this station or concentrator.")
fddimibSMTMasterCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMasterCts.setDescription("The number of M Ports in a node. If the node is\nnot a concentrator, the value of the variable is\nzero.")
fddimibSMTAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTAvailablePaths.setDescription("A value that indicates the PATH types available\nin the station.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis node has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary     0\n    Secondary     1\n        Local     2\n\nFor example, a station having Primary and Local\nPATHs available would have a value of 5 (2**0 +\n2**2).")
fddimibSMTConfigCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTConfigCapabilities.setDescription("A value that indicates the configuration\ncapabilities of a node. The 'Hold Available' bit\nindicates the support of the optional Hold\nFunction, which is controlled by\nfddiSMTConfigPolicy.  The 'CF-Wrap-AB' bit\nindicates that the station has the capability of\nperforming a wrap_ab (refer to ANSI SMT 9.7.2.2).\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the configuration\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n           Policy   Power\n    holdAvailable     0\n       CF-Wrap-AB     1 ")
fddimibSMTConfigPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTConfigPolicy.setDescription("A value that indicates the configuration policies\ncurrently desired in a node.  'Hold' is one of the\nterms used for the Hold Flag, an optional ECM flag\nused to enable the optional Hold policy.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the configuration\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n               Policy   Power\n    configurationhold     0 ")
fddimibSMTConnectionPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(32768, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTConnectionPolicy.setDescription("A value representing the connection policies in\neffect in a node. A station sets the corresponding\nbit for each of the connection types that it\nrejects. The letter designations, X and Y, in the\n'rejectX-Y' names have the following significance:\nX represents the PC-Type of the local PORT and Y\nrepresents the PC_Type of the adjacent PORT\n(PC_Neighbor). The evaluation of Connection-\nPolicy (PC-Type, PC-Neighbor) is done to determine\nthe setting of T- Val(3) in the PC-Signalling\nsequence (refer to ANSI 9.6.3). Note that Bit 15,\n(rejectM-M), is always set and cannot be cleared.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the connection\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n       Policy   Power\n    rejectA-A     0\n    rejectA-B     1\n    rejectA-S     2\n    rejectA-M     3\n    rejectB-A     4\n    rejectB-B     5\n    rejectB-S     6\n    rejectB-M     7\n    rejectS-A     8\n    rejectS-B     9\n    rejectS-S     10\n    rejectS-M     11\n    rejectM-A     12\n    rejectM-B     13\n    rejectM-S     14\n    rejectM-M     15 ")
fddimibSMTTNotify = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(2, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTTNotify.setDescription("The timer, expressed in seconds, used in the\nNeighbor Notification protocol. It has a range of\n2 seconds to 30 seconds, and its default value is\n30 seconds (refer to ANSI SMT 8.2).")
fddimibSMTStatRptPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTStatRptPolicy.setDescription("If true, indicates that the node will generate\nStatus Reporting Frames for its implemented events\nand conditions. It has an initial value of true.\nThis variable determines the value of the\nSR_Enable Flag (refer to ANSI SMT 8.3.2.1).")
fddimibSMTTraceMaxExpiration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 17), FddiTimeMilli()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTTraceMaxExpiration.setDescription("Reference Trace_Max (refer to ANSI SMT\n9.4.4.2.2).")
fddimibSMTBypassPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 18), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTBypassPresent.setDescription("A flag indicating if the station has a bypass on\nits AB port pair.")
fddimibSMTECMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 19), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(8,7,6,5,4,3,2,1,)).subtype(namedValues=namedval.NamedValues(("ec0", 1), ("ec1", 2), ("ec2", 3), ("ec3", 4), ("ec4", 5), ("ec5", 6), ("ec6", 7), ("ec7", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTECMState.setDescription("Indicates the current state of the ECM state\nmachine (refer to ANSI SMT 9.5.2).")
fddimibSMTCFState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(11,12,13,9,10,7,8,5,6,3,4,1,2,)).subtype(namedValues=namedval.NamedValues(("cf0", 1), ("cf9", 10), ("cf10", 11), ("cf11", 12), ("cf12", 13), ("cf1", 2), ("cf2", 3), ("cf3", 4), ("cf4", 5), ("cf5", 6), ("cf6", 7), ("cf7", 8), ("cf8", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTCFState.setDescription("The attachment configuration for the station or\nconcentrator (refer to ANSI SMT 9.7.2.2).")
fddimibSMTRemoteDisconnectFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTRemoteDisconnectFlag.setDescription("A flag indicating that the station was remotely\ndisconnected from the network as a result of\nreceiving an fddiSMTAction, disconnect (refer to\nANSI SMT 6.4.5.3) in a Parameter Management Frame.\nA station requires a Connect Action to rejoin and\nclear the flag (refer to ANSI SMT 6.4.5.2).")
fddimibSMTStationStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 22), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("concatenated", 1), ("separated", 2), ("thru", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTStationStatus.setDescription("The current status of the primary and secondary\npaths within this station.")
fddimibSMTPeerWrapFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTPeerWrapFlag.setDescription("This variable assumes the value of the\nPeerWrapFlag in CFM (refer to ANSI SMT\n9.7.2.4.4).")
fddimibSMTTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 24), FddiTimeMilli()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTTimeStamp.setDescription("This variable assumes the value of TimeStamp\n(refer to ANSI SMT 8.3.2.1).")
fddimibSMTTransitionTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 25), FddiTimeMilli()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTTransitionTimeStamp.setDescription("This variable assumes the value of\nTransitionTimeStamp (refer to ANSI SMT 8.3.2.1).")
fddimibSMTStationAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 26), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,2,8,7,6,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("connect", 2), ("disconnect", 3), ("path-Test", 4), ("self-Test", 5), ("disable-a", 6), ("disable-b", 7), ("disable-m", 8), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTStationAction.setDescription("This object, when read, always returns a value of\nother(1).  The behavior of setting this variable\nto each of the acceptable values is as follows:\n\n     other(1): Results in an appropriate error.\n     connect(2): Generates a Connect signal to ECM\n          to begin a connection sequence. See ANSI\n          Ref 9.4.2.\n     disconnect(3): Generates a Disconnect signal\n          to ECM. see ANSI Ref 9.4.2.\n     path-Test(4): Initiates a station Path_Test.\n          The Path_Test variable (see ANSI Ref\n          9.4.1) is set to 'Testing'. The results\n          of this action are not specified in this\n          standard.\n     self-Test(5): Initiates a station Self_Test.\n          The results of this action are not\n          specified in this standard.\n     disable-a(6): Causes a PC_Disable on the A\n          port if the A port mode is peer.\n     disable-b(7): Causes a PC_Disable on the B\n          port if the B port mode is peer.\n     disable-m(8): Causes a PC_Disable on all M\n          ports.\n\nAttempts to set this object to all other values\nresults in an appropriate error.  The result of\nsetting this variable to path-Test(4) or self-\nTest(5) is implementation-specific.")
fddimibMAC = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 2))
fddimibMACNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNumber.setDescription("The total number of MAC implementations (across\nall SMTs) on this network management application\nentity.  The value for this variable must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
fddimibMACTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2))
if mibBuilder.loadTexts: fddimibMACTable.setDescription("A list of MAC entries.  The number of entries\nshall not exceed the value of fddimibMACNumber.")
fddimibMACEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibMACSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibMACIndex"))
if mibBuilder.loadTexts: fddimibMACEntry.setDescription("A MAC entry containing information common to a\ngiven MAC.")
fddimibMACSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACSMTIndex.setDescription("The value of the SMT index associated with this\nMAC.")
fddimibMACIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACIndex.setDescription("Index variable for uniquely identifying the MAC\nobject instances, which is the same as the\ncorresponding resource index in SMT.")
fddimibMACIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACIfIndex.setDescription("The value of the MIB-II ifIndex corresponding to\nthis MAC.  If none is applicable, 0 is returned.")
fddimibMACFrameStatusFunctions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameStatusFunctions.setDescription("Indicates the MAC's optional Frame Status\nprocessing functions.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each function present, 2\nraised to a power is added to the sum.  The powers\nare according to the following table:\n\n     function   Power\n fs-repeating     0\n   fs-setting     1\n  fs-clearing     2 ")
fddimibMACTMaxCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 5), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTMaxCapability.setDescription("Indicates the maximum time value of fddiMACTMax\nthat this MAC can support.")
fddimibMACTVXCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 6), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTVXCapability.setDescription("Indicates the maximum time value of\nfddiMACTvxValue that this MAC can support.")
fddimibMACAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACAvailablePaths.setDescription("Indicates the paths available for this MAC (refer\nto ANSI SMT 9.7.7).\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis MAC has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary     0\n    Secondary     1\n        Local     2 ")
fddimibMACCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,1,4,6,2,3,)).subtype(namedValues=namedval.NamedValues(("isolated", 1), ("local", 2), ("secondary", 3), ("primary", 4), ("concatenated", 5), ("thru", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACCurrentPath.setDescription("Indicates the Path into which this MAC is\ncurrently inserted (refer to ANSI 9.7.7).")
fddimibMACUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 9), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACUpstreamNbr.setDescription("The MAC's upstream neighbor's long individual MAC\naddress. It has an initial value of the SMT-\nUnknown-MAC Address and is only modified as\nspecified by the Neighbor Information Frame\nprotocol (refer to ANSI SMT 7.2.1 and 8.2).")
fddimibMACDownstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 10), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDownstreamNbr.setDescription("The MAC's downstream neighbor's long individual\nMAC address. It has an initial value of the SMT-\nUnknown-MAC Address and is only modified as\nspecified by the Neighbor Information Frame\nprotocol (refer to ANSI SMT 7.2.1 and 8.2).")
fddimibMACOldUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 11), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACOldUpstreamNbr.setDescription("The previous value of the MAC's upstream\nneighbor's long individual MAC address. It has an\ninitial value of the SMT-Unknown- MAC Address and\nis only modified as specified by the Neighbor\nInformation Frame protocol (refer to ANSI SMT\n7.2.1 and 8.2).")
fddimibMACOldDownstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 12), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACOldDownstreamNbr.setDescription("The previous value of the MAC's downstream\nneighbor's long individual MAC address. It has an\ninitial value of the SMT- Unknown-MAC Address and\nis only modified as specified by the Neighbor\nInformation Frame protocol (refer to ANSI SMT\n7.2.1 and 8.2).")
fddimibMACDupAddressTest = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("pass", 2), ("fail", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDupAddressTest.setDescription("The Duplicate Address Test flag, Dup_Addr_Test\n(refer to ANSI 8.2).")
fddimibMACRequestedPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACRequestedPaths.setDescription("List of permitted Paths which specifies the\nPath(s) into which the MAC may be inserted (refer\nto ansi SMT 9.7).\n\nThe value is a sum which represents the individual\npaths that are desired.  This value initially\ntakes the value zero, then for each type of PATH\nthat this node is, 2 raised to a power is added to\nthe sum.  The powers are according to the\nfollowing table:\n\n                   Path   Power\n                  local     0\n    secondary-alternate     1\n      primary-alternate     2\n concatenated-alternate     3\n    secondary-preferred     4\n      primary-preferred     5\n concatenated-preferred     6\n                   thru     7 ")
fddimibMACDownstreamPORTType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 15), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=namedval.NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDownstreamPORTType.setDescription("Indicates the PC-Type of the first port that is\ndownstream of this MAC (the exit port).")
fddimibMACSMTAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 16), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACSMTAddress.setDescription("The 48-bit individual address of the MAC used for\nSMT frames.")
fddimibMACTReq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 17), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTReq.setDescription("This variable is the T_Req_value passed to the\nMAC.  Without having detected a duplicate, the\ntime value of this variable shall assume the\nmaximum supported time value which is less than or\nequal to the time value of fddiPATHMaxT-Req.  When\na MAC has an address detected as a duplicate, it\nmay use a time value for this variable greater\nthan the time value of fddiPATHTMaxLowerBound.  A\nstation shall cause claim when the new T_Req may\ncause the value of T_Neg to change in the claim\nprocess, (i.e., time value new T_Req < T_Neg, or\nold T_Req = T_Neg).")
fddimibMACTNeg = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 18), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTNeg.setDescription("It is reported as a FddiTimeNano number.")
fddimibMACTMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 19), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTMax.setDescription("This variable is the T_Max_value passed to the\nMAC.  The time value of this variable shall assume\nthe minimum suported time value which is greater\nthan or equal to the time value of fddiPATHT-\nMaxLowerBound")
fddimibMACTvxValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 20), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTvxValue.setDescription("This variable is the TVX_value passed to the MAC.\nThe time value of this variable shall assume the\nminimum suported time value which is greater than\nor equal to the time value of\nfddiPATHTVXLowerBound.")
fddimibMACFrameCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameCts.setDescription("A count of the number of frames received by this\nMAC (refer to ANSI MAC 7.5.1).")
fddimibMACCopiedCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACCopiedCts.setDescription("A count that should as closely as possible match\nthe number of frames addressed to (A bit set) and\nsuccessfully copied into the station's receive\nbuffers (C bit set) by this MAC (refer to ANSI MAC\n7.5). Note that this count does not include MAC\nframes.")
fddimibMACTransmitCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTransmitCts.setDescription("A count that should as closely as possible match\nthe number of frames transmitted by this MAC\n(refer to ANSI MAC 7.5).  Note that this count\ndoes not include MAC frames.")
fddimibMACErrorCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACErrorCts.setDescription("A count of the number of frames that were\ndetected in error by this MAC that had not been\ndetected in error by another MAC (refer to ANSI\nMAC 7.5.2).")
fddimibMACLostCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACLostCts.setDescription("A count of the number of instances that this MAC\ndetected a format error during frame reception\nsuch that the frame was stripped (refer to ANSI\nMAC 7.5.3).")
fddimibMACFrameErrorThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 26), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACFrameErrorThreshold.setDescription("A threshold for determining when a MAC Condition\nreport (see ANSI 8.3.1.1) shall be generated.\nStations not supporting variable thresholds shall\nhave a value of 0 and a range of (0..0).")
fddimibMACFrameErrorRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 27), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameErrorRatio.setDescription("This variable is the value of the ratio,\n\n((delta fddiMACLostCts + delta fddiMACErrorCts) /\n(delta fddiMACFrameCts + delta fddiMACLostCts ))\n* 2**16 ")
fddimibMACRMTState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 28), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,2,7,8,5,6,)).subtype(namedValues=namedval.NamedValues(("rm0", 1), ("rm1", 2), ("rm2", 3), ("rm3", 4), ("rm4", 5), ("rm5", 6), ("rm6", 7), ("rm7", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACRMTState.setDescription("Indicates the current state of the RMT State\nMachine (refer to ANSI 10.3.2).")
fddimibMACDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 29), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDaFlag.setDescription("The RMT flag Duplicate Address Flag, DA_Flag\n(refer to ANSI 10.2.1.2).")
fddimibMACUnaDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 30), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACUnaDaFlag.setDescription("A flag, UNDA_Flag (refer to ANSI 8.2.2.1), set\nwhen the upstream neighbor reports a duplicate\naddress condition. Cleared when the condition\nclears.")
fddimibMACFrameErrorFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 31), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameErrorFlag.setDescription("Indicates the MAC Frame Error Condition is\npresent when set. Cleared when the condition\nclears and on station initialization.")
fddimibMACMAUnitdataAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 32), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACMAUnitdataAvailable.setDescription("This variable shall take on the value of the\nMAC_Avail flag defined in RMT.")
fddimibMACHardwarePresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 33), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACHardwarePresent.setDescription("This variable indicates the presence of\nunderlying hardware support for this MAC object.\nIf the value of this object is false(2), the\nreporting of the objects in this entry may be\nhandled in an implementation-specific manner.")
fddimibMACMAUnitdataEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 34), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACMAUnitdataEnable.setDescription("This variable determines the value of the\nMA_UNITDATA_Enable flag in RMT.  The default and\ninitial value of this flag is true(1).")
fddimibMACCounters = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 3))
fddimibMACCountersTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1))
if mibBuilder.loadTexts: fddimibMACCountersTable.setDescription("A list of MAC Counters entries.  The number of\nentries shall not exceed the value of\nfddimibMACNumber.")
fddimibMACCountersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibMACSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibMACIndex"))
if mibBuilder.loadTexts: fddimibMACCountersEntry.setDescription("A MAC Counters entry containing information\ncommon to a given MAC.")
fddimibMACTokenCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTokenCts.setDescription("A count that should as closely as possible match\nthe number of times the station has received a\ntoken (total of non-restricted and restricted) on\nthis MAC (see ANSI MAC 7.4). This count is\nvaluable for determination of network load.")
fddimibMACTvxExpiredCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTvxExpiredCts.setDescription("A count that should as closely as possible match\nthe number of times that TVX has expired.")
fddimibMACNotCopiedCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedCts.setDescription("A count that should as closely as possible match\nthe number of frames that were addressed to this\nMAC but were not copied into its receive buffers\n(see ANSI MAC 7.5). For example, this might occur\ndue to local buffer congestion. Because of\nimplementation considerations, this count may not\nmatch the actual number of frames not copied. It\nis not a requirement that this count be exact.\nNote that this count does not include MAC frames.")
fddimibMACLateCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACLateCts.setDescription("A count that should as closely as possible match\nthe number of TRT expirations since this MAC was\nreset or a token was received (refer to ANSI MAC\n7.4.5).")
fddimibMACRingOpCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACRingOpCts.setDescription("The count of the number of times the ring has\nentered the 'Ring_Operational' state from the\n'Ring Not Operational' state.  This count is\nupdated when a SM_MA_STATUS.Indication of a change\nin the Ring_Operational status occurs (refer to\nANSI 6.1.4). Because of implementation\nconsiderations, this count may be less than the\nactual RingOp_Ct. It is not a requirement that\nthis count be exact.")
fddimibMACNotCopiedRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedRatio.setDescription("This variable is the value of the ratio:\n\n(delta fddiMACNotCopiedCts /\n(delta fddiMACCopiedCts +\n  delta fddiMACNotCopiedCts )) * 2**16 ")
fddimibMACNotCopiedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedFlag.setDescription("Indicates that the Not Copied condition is\npresent when read as true(1).  Set to false(2)\nwhen the condition clears and on station\ninitialization.")
fddimibMACNotCopiedThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACNotCopiedThreshold.setDescription("A threshold for determining when a MAC condition\nreport shall be generated.  Stations not\nsupporting variable thresholds shall have a value\nof 0 and a range of (0..0).")
fddimibPATH = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 4))
fddimibPATHNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHNumber.setDescription("The total number of PATHs possible (across all\nSMTs) on this network management application\nentity.  The value for this variable must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
fddimibPATHTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2))
if mibBuilder.loadTexts: fddimibPATHTable.setDescription("A list of PATH entries.  The number of entries\nshall not exceed the value of fddimibPATHNumber.")
fddimibPATHEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPATHSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHIndex"))
if mibBuilder.loadTexts: fddimibPATHEntry.setDescription("A PATH entry containing information common to a\ngiven PATH.")
fddimibPATHSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHSMTIndex.setDescription("The value of the SMT index associated with this\nPATH.")
fddimibPATHIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHIndex.setDescription("Index variable for uniquely identifying the\nprimary, secondary and local PATH object\ninstances. Local PATH object instances are\nrepresented with integer values 3 to 255.")
fddimibPATHTVXLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 3), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHTVXLowerBound.setDescription("Specifies the minimum time value of\nfddiMACTvxValue that shall be used by any MAC that\nis configured in this path. The operational value\nof fddiMACTvxValue is managed by settting this\nvariable.  This variable has the time value range\nof:\n\n0 < fddimibPATHTVXLowerBound < fddimibPATHMaxTReq\nChanges to this variable shall either satisfy the\ntime value relationship:\n\nfddimibPATHTVXLowerBound <=\nfddimibMACTVXCapability\n\nof each of the MACs currently on the path, or be\nconsidered out of range.  The initial value of\nfddimibPATHTVXLowerBound shall be 2500 nsec (2.5\nms).")
fddimibPATHTMaxLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 4), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHTMaxLowerBound.setDescription("Specifies the minimum time value of fddiMACTMax\nthat shall be used by any MAC that is configured\nin this path.  The operational value of\nfddiMACTMax is managed by setting this variable.\nThis variable has the time value range of:\n\nfddimibPATHMaxTReq <= fddimibPATHTMaxLowerBound\n\nand an absolute time value range of:\n\n10000nsec (10 msec) <= fddimibPATHTMaxLowerBound\n\nChanges to this variable shall either satisfy the\ntime value relationship:\n\nfddimibPATHTMaxLowerBound <\nfddimibMACTMaxCapability\n\nof each of the MACs currently on the path, or be\nconsidered out of range.  The initial value of\nfddimibPATHTMaxLowerBound shall be 165000 nsec\n(165 msec).")
fddimibPATHMaxTReq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 5), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHMaxTReq.setDescription("Specifies the maximum time value of fddiMACT-Req\nthat shall be used by any MAC that is configured\nin this path.  The operational value of fddiMACT-\nReq is managed by setting this variable.  This\nvariable has the time value range of:\n\nfddimibPATHTVXLowerBound < fddimibPATHMaxTReq <=\n                         fddimibPATHTMaxLowerBound.\n\nThe default value of fddimibPATHMaxTReq is 165000\nnsec (165 msec).")
fddimibPATHConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3))
if mibBuilder.loadTexts: fddimibPATHConfigTable.setDescription("A table of Path configuration entries.  This\ntable lists all the resources that may be in this\nPath.")
fddimibPATHConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPATHConfigSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHConfigPATHIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHConfigTokenOrder"))
if mibBuilder.loadTexts: fddimibPATHConfigEntry.setDescription("A collection of objects containing information\nfor a given PATH Configuration entry.")
fddimibPATHConfigSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigSMTIndex.setDescription("The value of the SMT index associated with this\nconfiguration entry.")
fddimibPATHConfigPATHIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigPATHIndex.setDescription("The value of the PATH resource index associated\nwith this configuration entry.")
fddimibPATHConfigTokenOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigTokenOrder.setDescription("An object associated with Token order for this\nentry.  Thus if the token passes resources a, b, c\nand d, in that order, then the value of this\nobject for these resources would be 1, 2, 3 and 4\nrespectively.")
fddimibPATHConfigResourceType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,4,)).subtype(namedValues=namedval.NamedValues(("mac", 2), ("port", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigResourceType.setDescription("The type of resource associated with this\nconfiguration entry.")
fddimibPATHConfigResourceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigResourceIndex.setDescription("The value of the SMT resource index used to refer\nto the instance of this MAC or Port resource.")
fddimibPATHConfigCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,1,4,6,2,3,)).subtype(namedValues=namedval.NamedValues(("isolated", 1), ("local", 2), ("secondary", 3), ("primary", 4), ("concatenated", 5), ("thru", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigCurrentPath.setDescription("The current insertion status for this resource on\nthis Path.")
fddimibPORT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 5))
fddimibPORTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTNumber.setDescription("The total number of PORT implementations (across\nall SMTs) on this network management application\nentity.  The value for this variable must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
fddimibPORTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2))
if mibBuilder.loadTexts: fddimibPORTTable.setDescription("A list of PORT entries.  The number of entries\nshall not exceed the value of fddimibPORTNumber.")
fddimibPORTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1)).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPORTSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPORTIndex"))
if mibBuilder.loadTexts: fddimibPORTEntry.setDescription("A PORT entry containing information common to a\ngiven PORT.")
fddimibPORTSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTSMTIndex.setDescription("The value of the SMT index associated with this\nPORT.")
fddimibPORTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTIndex.setDescription("A unique value for each PORT within a given SMT,\nwhich is the same as the corresponding resource\nindex in SMT.  The value for each PORT must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
fddimibPORTMyType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=namedval.NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMyType.setDescription("The value of the PORT's PC_Type (refer to ANSI\n9.4.1, and 9.6.3.2).")
fddimibPORTNeighborType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=namedval.NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTNeighborType.setDescription("The type of the remote PORT as determined in PCM.\nThis variable has an initial value of none, and is\nonly modified in PC_RCode(3)_Actions (refer to\nANSI SMT 9.6.3.2).")
fddimibPORTConnectionPolicies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTConnectionPolicies.setDescription("A value representing the PORT's connection\npolicies desired in the node. The value of pc-\nmac-lct is a term used in the PC_MAC_LCT Flag (see\n9.4.3.2).  The value of pc-mac-loop is a term used\nin the PC_MAC_Loop Flag.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each PORT policy, 2\nraised to a power is added to the sum.  The powers\nare according to the following table:\n\n              Policy   Power\n          pc-mac-lct     0\n         pc-mac-loop     1 ")
fddimibPORTMACIndicated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,2,1,)).subtype(namedValues=namedval.NamedValues(("tVal9FalseRVal9False", 1), ("tVal9FalseRVal9True", 2), ("tVal9TrueRVal9False", 3), ("tVal9TrueRVal9True", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMACIndicated.setDescription("The indications (T_Val(9), R_Val(9)) in PC-\nSignalling, of the intent to place a MAC in the\noutput token path to a PORT (refer to ANSI SMT\n9.6.3.2.).")
fddimibPORTCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,5,4,3,2,1,)).subtype(namedValues=namedval.NamedValues(("ce0", 1), ("ce1", 2), ("ce2", 3), ("ce3", 4), ("ce4", 5), ("ce5", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTCurrentPath.setDescription("Indicates the Path(s) into which this PORT is\ncurrently inserted.")
fddimibPORTRequestedPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 8), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTRequestedPaths.setDescription("This variable is a list of permitted Paths where\neach list element defines the Port's permitted\nPaths.  The first octet corresponds to 'none', the\nsecond octet to 'tree', and the third octet to\n'peer'.")
fddimibPORTMACPlacement = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 9), FddiResourceId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMACPlacement.setDescription("Indicates the MAC, if any, whose transmit path\nexits the station via this PORT. The value shall\nbe zero if there is no MAC associated with the\nPORT. Otherwise, the MACIndex of the MAC will be\nthe value of the variable.")
fddimibPORTAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTAvailablePaths.setDescription("Indicates the Paths which are available to this\nPort. In the absence of faults, the A and B Ports\nwill always have both the Primary and Secondary\nPaths available.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis port has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary     0\n    Secondary     1\n        Local     2 ")
fddimibPORTPMDClass = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,7,6,8,5,4,1,)).subtype(namedValues=namedval.NamedValues(("multimode", 1), ("single-mode1", 2), ("single-mode2", 3), ("sonet", 4), ("low-cost-fiber", 5), ("twisted-pair", 6), ("unknown", 7), ("unspecified", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPMDClass.setDescription("This variable indicates the type of PMD entity\nassociated with this port.")
fddimibPORTConnectionCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTConnectionCapabilities.setDescription("A value that indicates the connection\ncapabilities of the port. The pc-mac-lct bit\nindicates that the station has the capability of\nsetting the PC_MAC_LCT Flag. The pc-mac-loop bit\nindicates that the station has the capability of\nsetting the PC_MAC_Loop Flag (refer to ANSI\n9.4.3.2).\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each capability that this\nport has, 2 raised to a power is added to the sum.\nThe powers are according to the following table:\n\n   capability   Power\n   pc-mac-lct     0\n  pc-mac-loop     1 ")
fddimibPORTBSFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTBSFlag.setDescription("This variable assumes the value of the BS_Flag\n(refer to ANSI SMT 9.4.3.3).")
fddimibPORTLCTFailCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLCTFailCts.setDescription("The count of the consecutive times the link\nconfidence test (LCT) has failed during connection\nmanagement (refer to ANSI 9.4.1).")
fddimibPORTLerEstimate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLerEstimate.setDescription("A long term average link error rate. It ranges\nfrom 10**-4 to 10**-15 and is reported as the\nabsolute value of the base 10 logarithm (refer to\nANSI SMT 9.4.7.5.).")
fddimibPORTLemRejectCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLemRejectCts.setDescription("A link error monitoring count of the times that a\nlink has been rejected.")
fddimibPORTLemCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLemCts.setDescription("The aggregate link error monitor error count, set\nto zero only on station initialization.")
fddimibPORTLerCutoff = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTLerCutoff.setDescription("The link error rate estimate at which a link\nconnection will be broken. It ranges from 10**-4\nto 10**-15 and is reported as the absolute value\nof the base 10 logarithm (default of 7).")
fddimibPORTLerAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTLerAlarm.setDescription("The link error rate estimate at which a link\nconnection will generate an alarm. It ranges from\n10**-4 to 10**-15 and is reported as the absolute\nvalue of the base 10 logarithm of the estimate\n(default of 8).")
fddimibPORTConnectState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,4,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("connecting", 2), ("standby", 3), ("active", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTConnectState.setDescription("An indication of the connect state of this PORT\nand is equal to the value of Connect_State (refer\nto ANSI 9.4.1)")
fddimibPORTPCMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(9,10,3,4,1,2,7,8,5,6,)).subtype(namedValues=namedval.NamedValues(("pc0", 1), ("pc9", 10), ("pc1", 2), ("pc2", 3), ("pc3", 4), ("pc4", 5), ("pc5", 6), ("pc6", 7), ("pc7", 8), ("pc8", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPCMState.setDescription("The state of this Port's PCM state machine refer\nto ANSI SMT 9.6.2).")
fddimibPORTPCWithhold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 22), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("m-m", 2), ("otherincompatible", 3), ("pathnotavailable", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPCWithhold.setDescription("The value of PC_Withhold (refer to ANSI SMT\n9.4.1).")
fddimibPORTLerFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLerFlag.setDescription("The condition becomes active when the value of\nfddiPORTLerEstimate is less than or equal to\nfddiPORTLerAlarm. This will be reported with the\nStatus Report Frames (SRF) (refer to ANSI SMT\n 7.2.7 and 8.3).")
fddimibPORTHardwarePresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 24), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTHardwarePresent.setDescription("This variable indicates the presence of\nunderlying hardware support for this Port object.\nIf the value of this object is false(2), the\nreporting of the objects in this entry may be\nhandled in an implementation-specific manner.")
fddimibPORTAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 25), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,4,3,1,2,6,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("maintPORT", 2), ("enablePORT", 3), ("disablePORT", 4), ("startPORT", 5), ("stopPORT", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTAction.setDescription("Causes a Control signal to be generated with a\ncontrol_action of 'Signal' and the 'variable'\nparameter set with the appropriate value (i.e.,\nPC_Maint, PC_Enable, PC_Disable, PC_Start, or\nPC_Stop) (refer to ANSI 9.4.2).")

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("FDDI-SMT73-MIB", FddiMACLongAddressType=FddiMACLongAddressType, FddiResourceId=FddiResourceId, FddiSMTStationIdType=FddiSMTStationIdType, FddiTimeMilli=FddiTimeMilli, FddiTimeNano=FddiTimeNano)

# Objects
mibBuilder.exportSymbols("FDDI-SMT73-MIB", fddi=fddi, fddimib=fddimib, fddimibSMT=fddimibSMT, fddimibSMTNumber=fddimibSMTNumber, fddimibSMTTable=fddimibSMTTable, fddimibSMTEntry=fddimibSMTEntry, fddimibSMTIndex=fddimibSMTIndex, fddimibSMTStationId=fddimibSMTStationId, fddimibSMTOpVersionId=fddimibSMTOpVersionId, fddimibSMTHiVersionId=fddimibSMTHiVersionId, fddimibSMTLoVersionId=fddimibSMTLoVersionId, fddimibSMTUserData=fddimibSMTUserData, fddimibSMTMIBVersionId=fddimibSMTMIBVersionId, fddimibSMTMACCts=fddimibSMTMACCts, fddimibSMTNonMasterCts=fddimibSMTNonMasterCts, fddimibSMTMasterCts=fddimibSMTMasterCts, fddimibSMTAvailablePaths=fddimibSMTAvailablePaths, fddimibSMTConfigCapabilities=fddimibSMTConfigCapabilities, fddimibSMTConfigPolicy=fddimibSMTConfigPolicy, fddimibSMTConnectionPolicy=fddimibSMTConnectionPolicy, fddimibSMTTNotify=fddimibSMTTNotify, fddimibSMTStatRptPolicy=fddimibSMTStatRptPolicy, fddimibSMTTraceMaxExpiration=fddimibSMTTraceMaxExpiration, fddimibSMTBypassPresent=fddimibSMTBypassPresent, fddimibSMTECMState=fddimibSMTECMState, fddimibSMTCFState=fddimibSMTCFState, fddimibSMTRemoteDisconnectFlag=fddimibSMTRemoteDisconnectFlag, fddimibSMTStationStatus=fddimibSMTStationStatus, fddimibSMTPeerWrapFlag=fddimibSMTPeerWrapFlag, fddimibSMTTimeStamp=fddimibSMTTimeStamp, fddimibSMTTransitionTimeStamp=fddimibSMTTransitionTimeStamp, fddimibSMTStationAction=fddimibSMTStationAction, fddimibMAC=fddimibMAC, fddimibMACNumber=fddimibMACNumber, fddimibMACTable=fddimibMACTable, fddimibMACEntry=fddimibMACEntry, fddimibMACSMTIndex=fddimibMACSMTIndex, fddimibMACIndex=fddimibMACIndex, fddimibMACIfIndex=fddimibMACIfIndex, fddimibMACFrameStatusFunctions=fddimibMACFrameStatusFunctions, fddimibMACTMaxCapability=fddimibMACTMaxCapability, fddimibMACTVXCapability=fddimibMACTVXCapability, fddimibMACAvailablePaths=fddimibMACAvailablePaths, fddimibMACCurrentPath=fddimibMACCurrentPath, fddimibMACUpstreamNbr=fddimibMACUpstreamNbr, fddimibMACDownstreamNbr=fddimibMACDownstreamNbr, fddimibMACOldUpstreamNbr=fddimibMACOldUpstreamNbr, fddimibMACOldDownstreamNbr=fddimibMACOldDownstreamNbr, fddimibMACDupAddressTest=fddimibMACDupAddressTest, fddimibMACRequestedPaths=fddimibMACRequestedPaths, fddimibMACDownstreamPORTType=fddimibMACDownstreamPORTType, fddimibMACSMTAddress=fddimibMACSMTAddress, fddimibMACTReq=fddimibMACTReq, fddimibMACTNeg=fddimibMACTNeg, fddimibMACTMax=fddimibMACTMax, fddimibMACTvxValue=fddimibMACTvxValue, fddimibMACFrameCts=fddimibMACFrameCts, fddimibMACCopiedCts=fddimibMACCopiedCts, fddimibMACTransmitCts=fddimibMACTransmitCts, fddimibMACErrorCts=fddimibMACErrorCts, fddimibMACLostCts=fddimibMACLostCts, fddimibMACFrameErrorThreshold=fddimibMACFrameErrorThreshold, fddimibMACFrameErrorRatio=fddimibMACFrameErrorRatio, fddimibMACRMTState=fddimibMACRMTState, fddimibMACDaFlag=fddimibMACDaFlag, fddimibMACUnaDaFlag=fddimibMACUnaDaFlag, fddimibMACFrameErrorFlag=fddimibMACFrameErrorFlag, fddimibMACMAUnitdataAvailable=fddimibMACMAUnitdataAvailable, fddimibMACHardwarePresent=fddimibMACHardwarePresent, fddimibMACMAUnitdataEnable=fddimibMACMAUnitdataEnable, fddimibMACCounters=fddimibMACCounters, fddimibMACCountersTable=fddimibMACCountersTable, fddimibMACCountersEntry=fddimibMACCountersEntry, fddimibMACTokenCts=fddimibMACTokenCts, fddimibMACTvxExpiredCts=fddimibMACTvxExpiredCts, fddimibMACNotCopiedCts=fddimibMACNotCopiedCts, fddimibMACLateCts=fddimibMACLateCts, fddimibMACRingOpCts=fddimibMACRingOpCts, fddimibMACNotCopiedRatio=fddimibMACNotCopiedRatio, fddimibMACNotCopiedFlag=fddimibMACNotCopiedFlag, fddimibMACNotCopiedThreshold=fddimibMACNotCopiedThreshold, fddimibPATH=fddimibPATH, fddimibPATHNumber=fddimibPATHNumber, fddimibPATHTable=fddimibPATHTable, fddimibPATHEntry=fddimibPATHEntry, fddimibPATHSMTIndex=fddimibPATHSMTIndex, fddimibPATHIndex=fddimibPATHIndex, fddimibPATHTVXLowerBound=fddimibPATHTVXLowerBound, fddimibPATHTMaxLowerBound=fddimibPATHTMaxLowerBound, fddimibPATHMaxTReq=fddimibPATHMaxTReq, fddimibPATHConfigTable=fddimibPATHConfigTable, fddimibPATHConfigEntry=fddimibPATHConfigEntry, fddimibPATHConfigSMTIndex=fddimibPATHConfigSMTIndex, fddimibPATHConfigPATHIndex=fddimibPATHConfigPATHIndex, fddimibPATHConfigTokenOrder=fddimibPATHConfigTokenOrder, fddimibPATHConfigResourceType=fddimibPATHConfigResourceType, fddimibPATHConfigResourceIndex=fddimibPATHConfigResourceIndex, fddimibPATHConfigCurrentPath=fddimibPATHConfigCurrentPath, fddimibPORT=fddimibPORT, fddimibPORTNumber=fddimibPORTNumber, fddimibPORTTable=fddimibPORTTable, fddimibPORTEntry=fddimibPORTEntry, fddimibPORTSMTIndex=fddimibPORTSMTIndex, fddimibPORTIndex=fddimibPORTIndex, fddimibPORTMyType=fddimibPORTMyType, fddimibPORTNeighborType=fddimibPORTNeighborType, fddimibPORTConnectionPolicies=fddimibPORTConnectionPolicies, fddimibPORTMACIndicated=fddimibPORTMACIndicated, fddimibPORTCurrentPath=fddimibPORTCurrentPath, fddimibPORTRequestedPaths=fddimibPORTRequestedPaths, fddimibPORTMACPlacement=fddimibPORTMACPlacement, fddimibPORTAvailablePaths=fddimibPORTAvailablePaths, fddimibPORTPMDClass=fddimibPORTPMDClass, fddimibPORTConnectionCapabilities=fddimibPORTConnectionCapabilities, fddimibPORTBSFlag=fddimibPORTBSFlag, fddimibPORTLCTFailCts=fddimibPORTLCTFailCts, fddimibPORTLerEstimate=fddimibPORTLerEstimate, fddimibPORTLemRejectCts=fddimibPORTLemRejectCts, fddimibPORTLemCts=fddimibPORTLemCts, fddimibPORTLerCutoff=fddimibPORTLerCutoff, fddimibPORTLerAlarm=fddimibPORTLerAlarm, fddimibPORTConnectState=fddimibPORTConnectState, fddimibPORTPCMState=fddimibPORTPCMState, fddimibPORTPCWithhold=fddimibPORTPCWithhold, fddimibPORTLerFlag=fddimibPORTLerFlag, fddimibPORTHardwarePresent=fddimibPORTHardwarePresent)
mibBuilder.exportSymbols("FDDI-SMT73-MIB", fddimibPORTAction=fddimibPORTAction)

