# PySNMP SMI module. Autogenerated from smidump -f python FIBRE-CHANNEL-FE-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:20 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class FcAddressId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,3)
    fixedLength = 3
    pass

class FcBbCredit(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,32767)
    pass

class FcBbCreditModel(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,)
    namedValues = namedval.NamedValues(("regular", 1), ("alternate", 2), )
    pass

class FcCosCap(Bits):
    namedValues = namedval.NamedValues(("classF", 0), ("class1", 1), ("class2", 2), ("class3", 3), ("class4", 4), ("class5", 5), ("class6", 6), )
    pass

class FcFeFxPortCapacity(Unsigned32):
    pass

class FcFeFxPortIndex(Unsigned32):
    pass

class FcFeModuleCapacity(Unsigned32):
    pass

class FcFeModuleIndex(Unsigned32):
    pass

class FcFeNxPortIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,126)
    pass

class FcNameId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    fixedLength = 8
    pass

class FcRxDataFieldSize(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(128,2112)
    pass

class FcStackedConnMode(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,1,2,)
    namedValues = namedval.NamedValues(("none", 1), ("transparent", 2), ("lockedDown", 3), )
    pass

class FcphVersion(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,255)
    pass

class MicroSeconds(Unsigned32):
    pass

class MilliSeconds(Unsigned32):
    pass


# Objects

fcFeMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 75)).setRevisions(("2000-05-18 00:00",))
if mibBuilder.loadTexts: fcFeMIB.setOrganization("IETF IPFC Working Group")
if mibBuilder.loadTexts: fcFeMIB.setContactInfo("Kha Sin Teow\nBrocade Communications Systems,\n1901 Guadalupe Parkway,\nSan Jose, CA 95131\nU.S.A\nTel: +1 408 487 8180\nFax: +1 408 487 8190\nEmail: khasin@Brocade.COM\n\nWG Mailing list:ipfc@standards.gadzoox.com\nTo Subscribe: ipfc-request@standards.gadzoox.com\nIn Body: subscribe")
if mibBuilder.loadTexts: fcFeMIB.setDescription("The MIB module for Fibre Channel Fabric Element.")
fcFeMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1))
fcFeConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 1))
fcFeFabricName = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 1), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeFabricName.setDescription("The Name_Identifier of the Fabric to which this Fabric\nElement belongs.")
fcFeElementName = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 2), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeElementName.setDescription("The Name_Identifier of the Fabric Element.")
fcFeModuleCapacity = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 3), FcFeModuleCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleCapacity.setDescription("The maximum number of modules in the Fabric Element,\nregardless of their current state.")
fcFeModuleTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 1, 4))
if mibBuilder.loadTexts: fcFeModuleTable.setDescription("A table that contains, one entry for each module in the\nFabric Element, information of the modules.")
fcFeModuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1)).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"))
if mibBuilder.loadTexts: fcFeModuleEntry.setDescription("An entry containing the configuration parameters of a\nmodule.")
fcFeModuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 1), FcFeModuleIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcFeModuleIndex.setDescription("This object identifies the module within the Fabric Element\nfor which this entry contains information. This value is\nnever greater than fcFeModuleCapacity.")
fcFeModuleDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleDescr.setDescription("A textual description of the module. This value should\ninclude the full name and version identification of the\nmodule.")
fcFeModuleObjectID = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleObjectID.setDescription("The vendor's authoritative identification of the module.\nThis value may be allocated within the SMI enterprises\nsubtree (1.3.6.1.4.1) and provides a straight-forward and\nunambiguous means for determining what kind of module is\nbeing managed.\n\nFor example, this object could take the value\n1.3.6.1.4.1.99649.3.9 if vendor 'Neufe Inc.' was assigned\nthe subtree 1.3.6.1.4.1.99649, and had assigned the\nidentifier 1.3.6.1.4.1.99649.3.9 to its 'FeFiFo-16\nPlugInCard.'")
fcFeModuleOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("online", 1), ("offline", 2), ("testing", 3), ("faulty", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleOperStatus.setDescription("This object indicates the operational status of the module:\nonline(1)   the module is functioning properly;\noffline(2)  the module is not available;\ntesting(3)  the module is under testing; and\nfaulty(4)   the module is defective in some way.")
fcFeModuleLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleLastChange.setDescription("This object contains the value of sysUpTime when the module\nentered its current operational status. A value of zero\nindicates that the operational status of the module has not\nchanged since the agent last restarted.")
fcFeModuleFxPortCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 6), FcFeFxPortCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleFxPortCapacity.setDescription("The number of FxPort that can be contained within the\nmodule. Within each module, the ports are uniquely numbered\nin the range from 1 to fcFeModuleFxPortCapacity inclusive.\nHowever, the numbers are not required to be contiguous.")
fcFeModuleName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 7), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeModuleName.setDescription("The Name_Identifier of the module.")
fcFxPortTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 1, 5))
if mibBuilder.loadTexts: fcFxPortTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, configuration and service parameters of the\nFxPorts.")
fcFxPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1)).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortIndex"))
if mibBuilder.loadTexts: fcFxPortEntry.setDescription("An entry containing the configuration and service parameters\nof a FxPort.")
fcFxPortIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 1), FcFeFxPortIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcFxPortIndex.setDescription("This object identifies the FxPort within the module.  This\nnumber ranges from 1 to the value of fcFeModulePortCapacity\nfor the associated module. The value remains constant for\nthe identified FxPort until the module is re-initialized.")
fcFxPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 2), FcNameId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortName.setDescription("The World_wide Name of this FxPort.  Each FxPort has a\nunique Port World_wide Name within the Fabric.")
fcFxPortFcphVersionHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 3), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionHigh.setDescription("The highest or most recent version of FC-PH that the FxPort\nis configured to support.")
fcFxPortFcphVersionLow = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 4), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionLow.setDescription("The lowest or earliest version of FC-PH that the FxPort is\nconfigured to support.")
fcFxPortBbCredit = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 5), FcBbCredit()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortBbCredit.setDescription("The total number of receive buffers available for holding\nClass 1 connect-request, Class 2 or 3 frames from the\nattached NxPort.  It is for buffer-to-buffer flow control\nin the direction from the attached NxPort (if applicable)\nto FxPort.")
fcFxPortRxBufSize = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 6), FcRxDataFieldSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortRxBufSize.setDescription("The largest Data_Field Size (in octets) for an FT_1 frame\nthat can be received by the FxPort.")
fcFxPortRatov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 7), MilliSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortRatov.setDescription("The Resource_Allocation_Timeout Value configured for the\nFxPort.  This is used as the timeout value for determining\nwhen to reuse an NxPort resource such as a\nRecovery_Qualifier.  It represents E_D_TOV (see next\nobject) plus twice the maximum time that a frame may be\ndelayed within the Fabric and still be delivered.")
fcFxPortEdtov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 8), MilliSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortEdtov.setDescription("The E_D_TOV value configured for the FxPort. The\nError_Detect_Timeout Value is used as the timeout value for\ndetecting an error condition.")
fcFxPortCosSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 9), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCosSupported.setDescription("A value indicating the set of Classes of Service supported\nby the FxPort.")
fcFxPortIntermixSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortIntermixSupported.setDescription("A flag indicating whether or not the FxPort supports an\nIntermixed Dedicated Connection.")
fcFxPortStackedConnMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 11), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortStackedConnMode.setDescription("A value indicating the mode of Stacked Connect supported by\nthe FxPort.")
fcFxPortClass2SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass2SeqDeliv.setDescription("A flag indicating whether or not Class 2 Sequential\nDelivery is supported by the FxPort.")
fcFxPortClass3SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass3SeqDeliv.setDescription("A flag indicating whether or not Class 3 Sequential\nDelivery is supported by the FxPort.")
fcFxPortHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 14), MicroSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortHoldTime.setDescription("The maximum time (in microseconds) that the FxPort shall\nhold a frame before discarding the frame if it is unable to\ndeliver the frame. The value 0 means that the FxPort does\nnot support this parameter.")
fcFeStatus = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 2))
fcFxPortStatusTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 1))
if mibBuilder.loadTexts: fcFxPortStatusTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, operational status and parameters of the\nFxPorts.")
fcFxPortStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1))
if mibBuilder.loadTexts: fcFxPortStatusEntry.setDescription("An entry containing operational status and parameters of a\nFxPort.")
fcFxPortID = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 1), FcAddressId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortID.setDescription("The address identifier by which this FxPort is identified\nwithin the Fabric.  The FxPort may assign its address\nidentifier to its attached NxPort(s) during Fabric Login.")
fcFxPortBbCreditAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortBbCreditAvailable.setDescription("The number of buffers currently available for receiving\nframes from the attached port in the buffer-to-buffer flow\ncontrol. The value should be less than or equal to\nfcFxPortBbCredit.")
fcFxPortOperMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("fPort", 2), ("flPort", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOperMode.setDescription("The current operational mode of the FxPort.")
fcFxPortAdminMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,)).subtype(namedValues=namedval.NamedValues(("fPort", 2), ("flPort", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortAdminMode.setDescription("The desired operational mode of the FxPort.")
fcFxPortPhysTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 2))
if mibBuilder.loadTexts: fcFxPortPhysTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, physical level status and parameters of the\nFxPorts.")
fcFxPortPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1))
if mibBuilder.loadTexts: fcFxPortPhysEntry.setDescription("An entry containing physical level status and parameters of\na FxPort.")
fcFxPortPhysAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("online", 1), ("offline", 2), ("testing", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortPhysAdminStatus.setDescription("The desired state of the FxPort.  A management station may\nplace the FxPort in a desired state by setting this object\naccordingly.  The testing(3) state indicates that no\noperational frames can be passed.  When a Fabric Element\ninitializes, all FxPorts start with fcFxPortPhysAdminStatus\nin the offline(2) state.  As the result of either explicit\nmanagement action or per configuration information\naccessible by the Fabric Element, fcFxPortPhysAdminStatus\nis then changed to either the online(1) or testing(3)\nstates, or remains in the offline state.")
fcFxPortPhysOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("online", 1), ("offline", 2), ("testing", 3), ("linkFailure", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPhysOperStatus.setDescription("The current operational status of the FxPort.  The\ntesting(3) indicates that no operational frames can be\npassed.  If fcFxPortPhysAdminStatus is offline(2) then\nfcFxPortPhysOperStatus should be offline(2). If\nfcFxPortPhysAdminStatus is changed to online(1) then\nfcFxPortPhysOperStatus should change to online(1) if the\nFxPort is ready to accept Fabric Login request from the\nattached NxPort; it should proceed and remain in the link-\nfailure(4) state if and only if there is a fault that\nprevents it from going to the online(1) state.")
fcFxPortPhysLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPhysLastChange.setDescription("The value of sysUpTime at the time the FxPort entered its\ncurrent operational status. A value of zero indicates that\nthe FxPort's operational status has not changed since the\nagent last restarted.")
fcFxPortPhysRttov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 4), MilliSeconds()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortPhysRttov.setDescription("The Receiver_Transmitter_Timeout value of the FxPort. This\nis used by the receiver logic to detect Loss of\nSynchronization.")
fcFxLoginTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 3))
if mibBuilder.loadTexts: fcFxLoginTable.setDescription("A table that contains, one entry for each NxPort attached\nto a particular FxPort in the Fabric Element, services\nparameters established from the most recent Fabric Login,\nexplicit or implicit. Note that an FxPort may have one or\nmore NxPort attached to it.")
fcFxLoginEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1)).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortNxLoginIndex"))
if mibBuilder.loadTexts: fcFxLoginEntry.setDescription("An entry containing service parameters established from a\nsuccessful Fabric Login.")
fcFxPortNxLoginIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 1), FcFeNxPortIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcFxPortNxLoginIndex.setDescription("The object identifies the associated NxPort in the\nattachment for which the entry contains information.")
fcFxPortFcphVersionAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 2), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionAgreed.setDescription("The version of FC-PH that the FxPort has agreed to support\nfrom the Fabric Login")
fcFxPortNxPortBbCredit = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 3), FcBbCredit()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortBbCredit.setDescription("The total number of buffers available for holding Class 1\nconnect-request, Class 2 or Class 3 frames to be\ntransmitted to the attached NxPort.  It is for buffer-to-\nbuffer flow control in the direction from FxPort to NxPort.\nThe buffer-to-buffer flow control mechanism is indicated in\nthe respective fcFxPortBbCreditModel.")
fcFxPortNxPortRxDataFieldSize = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 4), FcRxDataFieldSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortRxDataFieldSize.setDescription("The Receive Data Field Size of the attached NxPort. This\nobject specifies the largest Data Field Size for an FT_1\nframe that can be received by the NxPort.")
fcFxPortCosSuppAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 5), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCosSuppAgreed.setDescription("A variable indicating that the attached NxPort has\nrequested the FxPort for the support of classes of services\nand the FxPort has granted the request.")
fcFxPortIntermixSuppAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortIntermixSuppAgreed.setDescription("A variable indicating that the attached NxPort has\nrequested the FxPort for the support of Intermix and the\nFxPort has granted the request. This flag is only valid if\nClass 1 service is supported.")
fcFxPortStackedConnModeAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 7), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortStackedConnModeAgreed.setDescription("A variable indicating whether the FxPort has agreed to\nsupport stacked connect from the Fabric Login. This is only\nmeaningful if Class 1 service has been agreed.")
fcFxPortClass2SeqDelivAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass2SeqDelivAgreed.setDescription("A variable indicating whether the FxPort has agreed to\nsupport Class 2 sequential delivery from the Fabric Login.\nThis is only meaningful if Class 2 service has been\nagreed.")
fcFxPortClass3SeqDelivAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass3SeqDelivAgreed.setDescription("A flag indicating whether the FxPort has agreed to support\nClass 3 sequential delivery from the Fabric Login. This is\nonly meaningful if Class 3 service has been agreed.")
fcFxPortNxPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 10), FcNameId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortName.setDescription("The port name of the attached NxPort.")
fcFxPortConnectedNxPort = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 11), FcAddressId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortConnectedNxPort.setDescription("The address identifier of the destination NxPort with which\nthis FxPort is currently engaged in a either a Class 1 or\nloop connection. If this FxPort is not engaged in a\nconnection, then the value of this object is '000000'H.")
fcFxPortBbCreditModel = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 12), FcBbCreditModel()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortBbCreditModel.setDescription("This object identifies the BB_Credit model used by the\nFxPort.")
fcFeError = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 3))
fcFxPortErrorTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 3, 1))
if mibBuilder.loadTexts: fcFxPortErrorTable.setDescription("A table that contains, one entry for each FxPort, counters\nthat record the numbers of errors detected.")
fcFxPortErrorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1))
if mibBuilder.loadTexts: fcFxPortErrorEntry.setDescription("An entry containing error counters of a FxPort.")
fcFxPortLinkFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkFailures.setDescription("The number of link failures detected by this FxPort.")
fcFxPortSyncLosses = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortSyncLosses.setDescription("The number of loss of synchronization detected by the\nFxPort.")
fcFxPortSigLosses = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortSigLosses.setDescription("The number of loss of signal detected by the FxPort.")
fcFxPortPrimSeqProtoErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPrimSeqProtoErrors.setDescription("The number of primitive sequence protocol errors detected\nby the FxPort.")
fcFxPortInvalidTxWords = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortInvalidTxWords.setDescription("The number of invalid transmission word detected by the\nFxPort.")
fcFxPortInvalidCrcs = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortInvalidCrcs.setDescription("The number of invalid CRC detected by this FxPort.")
fcFxPortDelimiterErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortDelimiterErrors.setDescription("The number of Delimiter Errors detected by this FxPort.")
fcFxPortAddressIdErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortAddressIdErrors.setDescription("The number of address identifier errors detected by this\nFxPort.")
fcFxPortLinkResetIns = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkResetIns.setDescription("The number of Link Reset Protocol received by this FxPort\nfrom the attached NxPort.")
fcFxPortLinkResetOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkResetOuts.setDescription("The number of Link Reset Protocol issued by this FxPort to\nthe attached NxPort.")
fcFxPortOlsIns = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOlsIns.setDescription("The number of Offline Sequence received by this FxPort.")
fcFxPortOlsOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOlsOuts.setDescription("The number of Offline Sequence issued by this FxPort.")
fcFeAccounting = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 4))
fcFxPortC1AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 1))
if mibBuilder.loadTexts: fcFxPortC1AccountingTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, Class 1 accounting information recorded\nsince the management agent has re-initialized.")
fcFxPortC1AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1))
if mibBuilder.loadTexts: fcFxPortC1AccountingEntry.setDescription("An entry containing Class 1 accounting information for each\nFxPort.")
fcFxPortC1InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InFrames.setDescription("The number of Class 1 frames (other than Class 1 connect-\nrequest) received by this FxPort from its attached NxPort.")
fcFxPortC1OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutFrames.setDescription("The number of Class 1 frames (other than Class 1 connect-\nrequest) delivered through this FxPort to its attached\nNxPort.")
fcFxPortC1InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InOctets.setDescription("The number of Class 1 frame octets, including the frame\ndelimiters,  received by this FxPort from its attached\nNxPort.")
fcFxPortC1OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutOctets.setDescription("The number of Class 1 frame octets, including the frame\ndelimiters, delivered through this FxPort its attached\nNxPort.")
fcFxPortC1Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1Discards.setDescription("The number of Class 1 frames discarded by this FxPort.")
fcFxPortC1FbsyFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1FbsyFrames.setDescription("The number of F_BSY frames generated by this FxPort against\nClass 1 connect-request.")
fcFxPortC1FrjtFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1FrjtFrames.setDescription("The number of F_RJT frames generated by this FxPort against\nClass 1 connect-request.")
fcFxPortC1InConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InConnections.setDescription("The number of Class 1 connections successfully established\nin which the attached NxPort is the source of the connect-\nrequest.")
fcFxPortC1OutConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutConnections.setDescription("The number of Class 1 connections successfully established\nin which the attached NxPort is the destination of the\nconnect-request.")
fcFxPortC1ConnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 10), MilliSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1ConnTime.setDescription("The cumulative time that this FxPort has been engaged in\nClass 1 connection.  The amount of time is counted from\nafter a connect-request has been accepted until the\nconnection is disengaged, either by an EOFdt or Link\nReset.")
fcFxPortC2AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 2))
if mibBuilder.loadTexts: fcFxPortC2AccountingTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, Class 2 accounting information recorded\nsince the management agent has re-initialized.")
fcFxPortC2AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1))
if mibBuilder.loadTexts: fcFxPortC2AccountingEntry.setDescription("An entry containing Class 2 accounting information for each\nFxPort.")
fcFxPortC2InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2InFrames.setDescription("The number of Class 2 frames received by this FxPort from\nits attached NxPort.")
fcFxPortC2OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2OutFrames.setDescription("The number of Class 2 frames delivered through this FxPort\nto its attached NxPort.")
fcFxPortC2InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2InOctets.setDescription("The number of Class 2 frame octets, including the frame\ndelimiters, received by this FxPort from its attached\nNxPort.")
fcFxPortC2OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2OutOctets.setDescription("The number of Class 2 frame octets, including the frame\ndelimiters, delivered through this FxPort to its attached\nNxPort.")
fcFxPortC2Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2Discards.setDescription("The number of Class 2 frames discarded by this FxPort.")
fcFxPortC2FbsyFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2FbsyFrames.setDescription("The number of F_BSY frames generated by this FxPort against\nClass 2 frames.")
fcFxPortC2FrjtFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2FrjtFrames.setDescription("The number of F_RJT frames generated by this FxPort against\nClass 2 frames.")
fcFxPortC3AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 3))
if mibBuilder.loadTexts: fcFxPortC3AccountingTable.setDescription("A table that contains, one entry for each FxPort in the\nFabric Element, Class 3 accounting information recorded\nsince the management agent has re-initialized.")
fcFxPortC3AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1))
if mibBuilder.loadTexts: fcFxPortC3AccountingEntry.setDescription("An entry containing Class 3 accounting information for each\nFxPort.")
fcFxPortC3InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3InFrames.setDescription("The number of Class 3 frames received by this FxPort from\nits attached NxPort.")
fcFxPortC3OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3OutFrames.setDescription("The number of Class 3 frames delivered through this FxPort\nto its attached NxPort.")
fcFxPortC3InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3InOctets.setDescription("The number of Class 3 frame octets, including the frame\ndelimiters, received by this FxPort from its attached\nNxPort.")
fcFxPortC3OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3OutOctets.setDescription("The number of Class 3 frame octets, including the frame\ndelimiters, delivered through this FxPort to its attached\nNxPort.")
fcFxPortC3Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3Discards.setDescription("The number of Class 3 frames discarded by this FxPort.")
fcFeCapabilities = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 5))
fcFxPortCapTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 5, 1))
if mibBuilder.loadTexts: fcFxPortCapTable.setDescription("A table that contains, one entry for each FxPort, the\ncapabilities of the port within the Fabric Element.")
fcFxPortCapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1))
if mibBuilder.loadTexts: fcFxPortCapEntry.setDescription("An entry containing the Cap of a FxPort.")
fcFxPortCapFcphVersionHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 1), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapFcphVersionHigh.setDescription("The highest or most recent version of FC-PH that the FxPort\nis capable of supporting.")
fcFxPortCapFcphVersionLow = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 2), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapFcphVersionLow.setDescription("The lowest or earliest version of FC-PH that the FxPort is\ncapable of supporting.")
fcFxPortCapBbCreditMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 3), FcBbCredit()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapBbCreditMax.setDescription("The maximum number of receive buffers available for holding\nClass 1 connect-request, Class 2 or Class 3 frames from the\nattached NxPort.")
fcFxPortCapBbCreditMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 4), FcBbCredit()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapBbCreditMin.setDescription("The minimum number of receive buffers available for holding\nClass 1 connect-request, Class 2 or Class 3 frames from the\nattached NxPort.")
fcFxPortCapRxDataFieldSizeMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 5), FcRxDataFieldSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapRxDataFieldSizeMax.setDescription("The maximum size in bytes of the Data Field in a frame that\nthe FxPort is capable of receiving from its attached\nNxPort.")
fcFxPortCapRxDataFieldSizeMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 6), FcRxDataFieldSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapRxDataFieldSizeMin.setDescription("The minimum size in bytes of the Data Field in a frame that\nthe FxPort is capable of receiving from its attached\nNxPort.")
fcFxPortCapCos = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 7), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapCos.setDescription("A value indicating the set of Classes of Service that the\nFxPort is capable of supporting.")
fcFxPortCapIntermix = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapIntermix.setDescription("A flag indicating whether or not the FxPort is capable of\nsupporting the intermixing of Class 2 and Class 3 frames\nduring a Class 1 connection. This flag is only valid if the\nport is capable of supporting Class 1 service.")
fcFxPortCapStackedConnMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 9), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapStackedConnMode.setDescription("A value indicating the mode of Stacked Connect request that\nthe FxPort is capable of supporting.")
fcFxPortCapClass2SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapClass2SeqDeliv.setDescription("A flag indicating whether or not the FxPort is capable of\nsupporting Class 2 Sequential Delivery.")
fcFxPortCapClass3SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapClass3SeqDeliv.setDescription("A flag indicating whether or not the FxPort is capable of\nsupporting Class 3 Sequential Delivery.")
fcFxPortCapHoldTimeMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 12), MicroSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapHoldTimeMax.setDescription("The maximum holding time (in microseconds) that the FxPort\nis capable of supporting.")
fcFxPortCapHoldTimeMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 13), MicroSeconds()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapHoldTimeMin.setDescription("The minimum holding time (in microseconds) that the FxPort\nis capable of supporting.")
fcFeMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2))
fcFeMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2, 1))
fcFeMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2, 2))

# Augmentions
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1AccountingEntry"))
apply(fcFxPortC1AccountingEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3AccountingEntry"))
apply(fcFxPortC3AccountingEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysEntry"))
apply(fcFxPortPhysEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortErrorEntry"))
apply(fcFxPortErrorEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapEntry"))
apply(fcFxPortCapEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2AccountingEntry"))
apply(fcFxPortC2AccountingEntry.setIndexNames, fcFxPortEntry.getIndexNames())
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortStatusEntry"))
apply(fcFxPortStatusEntry.setIndexNames, fcFxPortEntry.getIndexNames())

# Groups

fcFeClass3AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 6)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3InOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3Discards"), )
fcFeClass1AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 4)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutConnections"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InConnections"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1FbsyFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1ConnTime"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1FrjtFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1Discards"), )
fcFeConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 1)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFeModuleCapacity"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleOperStatus"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleName"), ("FIBRE-CHANNEL-FE-MIB", "fcFeElementName"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortRatov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortName"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleDescr"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass3SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortEdtov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCosSupported"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCredit"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass2SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortIntermixSupported"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortRxBufSize"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionHigh"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleLastChange"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleFxPortCapacity"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortHoldTime"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortStackedConnMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleObjectID"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionLow"), ("FIBRE-CHANNEL-FE-MIB", "fcFeFabricName"), )
fcFeStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 2)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortBbCredit"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysRttov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortID"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass2SeqDelivAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCosSuppAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortRxDataFieldSize"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortIntermixSuppAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCreditAvailable"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass3SeqDelivAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortStackedConnModeAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortName"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysLastChange"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysAdminStatus"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortAdminMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCreditModel"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOperMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortConnectedNxPort"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysOperStatus"), )
fcFeCapabilitiesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 7)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapFcphVersionLow"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapRxDataFieldSizeMin"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapBbCreditMin"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapFcphVersionHigh"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapClass2SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapBbCreditMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapHoldTimeMin"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapClass3SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapHoldTimeMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapStackedConnMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapRxDataFieldSizeMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapIntermix"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapCos"), )
fcFeClass2AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 5)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2FbsyFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2FrjtFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2Discards"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2InOctets"), )
fcFeErrorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 3)).setObjects(("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkFailures"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortInvalidTxWords"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkResetIns"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPrimSeqProtoErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortAddressIdErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOlsIns"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkResetOuts"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortInvalidCrcs"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOlsOuts"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortDelimiterErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortSyncLosses"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortSigLosses"), )

# Exports

# Module identity
mibBuilder.exportSymbols("FIBRE-CHANNEL-FE-MIB", PYSNMP_MODULE_ID=fcFeMIB)

# Types
mibBuilder.exportSymbols("FIBRE-CHANNEL-FE-MIB", FcAddressId=FcAddressId, FcBbCredit=FcBbCredit, FcBbCreditModel=FcBbCreditModel, FcCosCap=FcCosCap, FcFeFxPortCapacity=FcFeFxPortCapacity, FcFeFxPortIndex=FcFeFxPortIndex, FcFeModuleCapacity=FcFeModuleCapacity, FcFeModuleIndex=FcFeModuleIndex, FcFeNxPortIndex=FcFeNxPortIndex, FcNameId=FcNameId, FcRxDataFieldSize=FcRxDataFieldSize, FcStackedConnMode=FcStackedConnMode, FcphVersion=FcphVersion, MicroSeconds=MicroSeconds, MilliSeconds=MilliSeconds)

# Objects
mibBuilder.exportSymbols("FIBRE-CHANNEL-FE-MIB", fcFeMIB=fcFeMIB, fcFeMIBObjects=fcFeMIBObjects, fcFeConfig=fcFeConfig, fcFeFabricName=fcFeFabricName, fcFeElementName=fcFeElementName, fcFeModuleCapacity=fcFeModuleCapacity, fcFeModuleTable=fcFeModuleTable, fcFeModuleEntry=fcFeModuleEntry, fcFeModuleIndex=fcFeModuleIndex, fcFeModuleDescr=fcFeModuleDescr, fcFeModuleObjectID=fcFeModuleObjectID, fcFeModuleOperStatus=fcFeModuleOperStatus, fcFeModuleLastChange=fcFeModuleLastChange, fcFeModuleFxPortCapacity=fcFeModuleFxPortCapacity, fcFeModuleName=fcFeModuleName, fcFxPortTable=fcFxPortTable, fcFxPortEntry=fcFxPortEntry, fcFxPortIndex=fcFxPortIndex, fcFxPortName=fcFxPortName, fcFxPortFcphVersionHigh=fcFxPortFcphVersionHigh, fcFxPortFcphVersionLow=fcFxPortFcphVersionLow, fcFxPortBbCredit=fcFxPortBbCredit, fcFxPortRxBufSize=fcFxPortRxBufSize, fcFxPortRatov=fcFxPortRatov, fcFxPortEdtov=fcFxPortEdtov, fcFxPortCosSupported=fcFxPortCosSupported, fcFxPortIntermixSupported=fcFxPortIntermixSupported, fcFxPortStackedConnMode=fcFxPortStackedConnMode, fcFxPortClass2SeqDeliv=fcFxPortClass2SeqDeliv, fcFxPortClass3SeqDeliv=fcFxPortClass3SeqDeliv, fcFxPortHoldTime=fcFxPortHoldTime, fcFeStatus=fcFeStatus, fcFxPortStatusTable=fcFxPortStatusTable, fcFxPortStatusEntry=fcFxPortStatusEntry, fcFxPortID=fcFxPortID, fcFxPortBbCreditAvailable=fcFxPortBbCreditAvailable, fcFxPortOperMode=fcFxPortOperMode, fcFxPortAdminMode=fcFxPortAdminMode, fcFxPortPhysTable=fcFxPortPhysTable, fcFxPortPhysEntry=fcFxPortPhysEntry, fcFxPortPhysAdminStatus=fcFxPortPhysAdminStatus, fcFxPortPhysOperStatus=fcFxPortPhysOperStatus, fcFxPortPhysLastChange=fcFxPortPhysLastChange, fcFxPortPhysRttov=fcFxPortPhysRttov, fcFxLoginTable=fcFxLoginTable, fcFxLoginEntry=fcFxLoginEntry, fcFxPortNxLoginIndex=fcFxPortNxLoginIndex, fcFxPortFcphVersionAgreed=fcFxPortFcphVersionAgreed, fcFxPortNxPortBbCredit=fcFxPortNxPortBbCredit, fcFxPortNxPortRxDataFieldSize=fcFxPortNxPortRxDataFieldSize, fcFxPortCosSuppAgreed=fcFxPortCosSuppAgreed, fcFxPortIntermixSuppAgreed=fcFxPortIntermixSuppAgreed, fcFxPortStackedConnModeAgreed=fcFxPortStackedConnModeAgreed, fcFxPortClass2SeqDelivAgreed=fcFxPortClass2SeqDelivAgreed, fcFxPortClass3SeqDelivAgreed=fcFxPortClass3SeqDelivAgreed, fcFxPortNxPortName=fcFxPortNxPortName, fcFxPortConnectedNxPort=fcFxPortConnectedNxPort, fcFxPortBbCreditModel=fcFxPortBbCreditModel, fcFeError=fcFeError, fcFxPortErrorTable=fcFxPortErrorTable, fcFxPortErrorEntry=fcFxPortErrorEntry, fcFxPortLinkFailures=fcFxPortLinkFailures, fcFxPortSyncLosses=fcFxPortSyncLosses, fcFxPortSigLosses=fcFxPortSigLosses, fcFxPortPrimSeqProtoErrors=fcFxPortPrimSeqProtoErrors, fcFxPortInvalidTxWords=fcFxPortInvalidTxWords, fcFxPortInvalidCrcs=fcFxPortInvalidCrcs, fcFxPortDelimiterErrors=fcFxPortDelimiterErrors, fcFxPortAddressIdErrors=fcFxPortAddressIdErrors, fcFxPortLinkResetIns=fcFxPortLinkResetIns, fcFxPortLinkResetOuts=fcFxPortLinkResetOuts, fcFxPortOlsIns=fcFxPortOlsIns, fcFxPortOlsOuts=fcFxPortOlsOuts, fcFeAccounting=fcFeAccounting, fcFxPortC1AccountingTable=fcFxPortC1AccountingTable, fcFxPortC1AccountingEntry=fcFxPortC1AccountingEntry, fcFxPortC1InFrames=fcFxPortC1InFrames, fcFxPortC1OutFrames=fcFxPortC1OutFrames, fcFxPortC1InOctets=fcFxPortC1InOctets, fcFxPortC1OutOctets=fcFxPortC1OutOctets, fcFxPortC1Discards=fcFxPortC1Discards, fcFxPortC1FbsyFrames=fcFxPortC1FbsyFrames, fcFxPortC1FrjtFrames=fcFxPortC1FrjtFrames, fcFxPortC1InConnections=fcFxPortC1InConnections, fcFxPortC1OutConnections=fcFxPortC1OutConnections, fcFxPortC1ConnTime=fcFxPortC1ConnTime, fcFxPortC2AccountingTable=fcFxPortC2AccountingTable, fcFxPortC2AccountingEntry=fcFxPortC2AccountingEntry, fcFxPortC2InFrames=fcFxPortC2InFrames, fcFxPortC2OutFrames=fcFxPortC2OutFrames, fcFxPortC2InOctets=fcFxPortC2InOctets, fcFxPortC2OutOctets=fcFxPortC2OutOctets, fcFxPortC2Discards=fcFxPortC2Discards, fcFxPortC2FbsyFrames=fcFxPortC2FbsyFrames, fcFxPortC2FrjtFrames=fcFxPortC2FrjtFrames, fcFxPortC3AccountingTable=fcFxPortC3AccountingTable, fcFxPortC3AccountingEntry=fcFxPortC3AccountingEntry, fcFxPortC3InFrames=fcFxPortC3InFrames, fcFxPortC3OutFrames=fcFxPortC3OutFrames, fcFxPortC3InOctets=fcFxPortC3InOctets, fcFxPortC3OutOctets=fcFxPortC3OutOctets, fcFxPortC3Discards=fcFxPortC3Discards, fcFeCapabilities=fcFeCapabilities, fcFxPortCapTable=fcFxPortCapTable, fcFxPortCapEntry=fcFxPortCapEntry, fcFxPortCapFcphVersionHigh=fcFxPortCapFcphVersionHigh, fcFxPortCapFcphVersionLow=fcFxPortCapFcphVersionLow, fcFxPortCapBbCreditMax=fcFxPortCapBbCreditMax, fcFxPortCapBbCreditMin=fcFxPortCapBbCreditMin, fcFxPortCapRxDataFieldSizeMax=fcFxPortCapRxDataFieldSizeMax, fcFxPortCapRxDataFieldSizeMin=fcFxPortCapRxDataFieldSizeMin, fcFxPortCapCos=fcFxPortCapCos, fcFxPortCapIntermix=fcFxPortCapIntermix, fcFxPortCapStackedConnMode=fcFxPortCapStackedConnMode, fcFxPortCapClass2SeqDeliv=fcFxPortCapClass2SeqDeliv, fcFxPortCapClass3SeqDeliv=fcFxPortCapClass3SeqDeliv, fcFxPortCapHoldTimeMax=fcFxPortCapHoldTimeMax, fcFxPortCapHoldTimeMin=fcFxPortCapHoldTimeMin, fcFeMIBConformance=fcFeMIBConformance, fcFeMIBCompliances=fcFeMIBCompliances, fcFeMIBGroups=fcFeMIBGroups)

# Groups
mibBuilder.exportSymbols("FIBRE-CHANNEL-FE-MIB", fcFeClass3AccountingGroup=fcFeClass3AccountingGroup, fcFeClass1AccountingGroup=fcFeClass1AccountingGroup, fcFeConfigGroup=fcFeConfigGroup, fcFeStatusGroup=fcFeStatusGroup, fcFeCapabilitiesGroup=fcFeCapabilitiesGroup, fcFeClass2AccountingGroup=fcFeClass2AccountingGroup, fcFeErrorGroup=fcFeErrorGroup)
