# PySNMP SMI module. Autogenerated from smidump -f python FLOW-METER-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:20 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( TimeFilter, ) = mibBuilder.importSymbols("RMON2-MIB", "TimeFilter")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class ActionNumber(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,15,6,5,10,17,2,1,13,14,16,7,9,11,8,4,12,)
    namedValues = namedval.NamedValues(("ignore", 1), ("goto", 10), ("gotoAct", 11), ("pushRuleTo", 12), ("pushRuleToAct", 13), ("pushPktTo", 14), ("pushPktToAct", 15), ("popTo", 16), ("popToAct", 17), ("noMatch", 2), ("count", 3), ("countPkt", 4), ("return", 5), ("gosub", 6), ("gosubAct", 7), ("assign", 8), ("assignAct", 9), )
    pass

class AdjacentAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,20)
    pass

class AdjacentType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,3,9,12,13,7,11,15,)
    namedValues = namedval.NamedValues(("ip", 1), ("ipx", 11), ("appletalk", 12), ("decnet", 13), ("fddi", 15), ("nsap", 3), ("ethernet", 7), ("tokenring", 9), )
    pass

class FlowAttributeNumber(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(30,29,31,32,33,18,16,34,15,25,37,4,2,40,27,28,13,7,5,14,38,20,35,26,41,24,22,9,3,39,1,12,10,17,11,8,19,21,6,36,23,)
    namedValues = namedval.NamedValues(("flowIndex", 1), ("sourcePeerMask", 10), ("sourceTransType", 11), ("sourceTransAddress", 12), ("sourceTransMask", 13), ("destInterface", 14), ("destAdjacentType", 15), ("destAdjacentAddress", 16), ("destAdjacentMask", 17), ("destPeerType", 18), ("destPeerAddress", 19), ("flowStatus", 2), ("destPeerMask", 20), ("destTransType", 21), ("destTransAddress", 22), ("destTransMask", 23), ("pduScale", 24), ("octetScale", 25), ("ruleSet", 26), ("toOctets", 27), ("toPDUs", 28), ("fromOctets", 29), ("flowTimeMark", 3), ("fromPDUs", 30), ("firstTime", 31), ("lastActiveTime", 32), ("sourceSubscriberID", 33), ("destSubscriberID", 34), ("sessionID", 35), ("sourceClass", 36), ("destClass", 37), ("flowClass", 38), ("sourceKind", 39), ("sourceInterface", 4), ("destKind", 40), ("flowKind", 41), ("sourceAdjacentType", 5), ("sourceAdjacentAddress", 6), ("sourceAdjacentMask", 7), ("sourcePeerType", 8), ("sourcePeerAddress", 9), )
    pass

class PeerAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,20)
    pass

class PeerType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,13,12,1,2,11,)
    namedValues = namedval.NamedValues(("ipv4", 1), ("ipx", 11), ("appletalk", 12), ("decnet", 13), ("ipv6", 2), ("nsap", 3), )
    pass

class RuleAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(2,20)
    pass

class RuleAttributeNumber(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(33,18,16,34,15,0,37,4,50,39,21,38,51,35,53,54,55,41,22,9,14,12,6,11,52,8,19,5,40,36,)
    namedValues = namedval.NamedValues(("null", 0), ("sourceTransType", 11), ("sourceTransAddress", 12), ("destInterface", 14), ("destAdjacentType", 15), ("destAdjacentAddress", 16), ("destPeerType", 18), ("destPeerAddress", 19), ("destTransType", 21), ("destTransAddress", 22), ("sourceSubscriberID", 33), ("destSubscriberID", 34), ("sessionID", 35), ("sourceClass", 36), ("destClass", 37), ("flowClass", 38), ("sourceKind", 39), ("sourceInterface", 4), ("destKind", 40), ("flowKind", 41), ("sourceAdjacentType", 5), ("matchingStoD", 50), ("v1", 51), ("v2", 52), ("v3", 53), ("v4", 54), ("v5", 55), ("sourceAdjacentAddress", 6), ("sourcePeerType", 8), ("sourcePeerAddress", 9), )
    pass

class TransportAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(2,2)
    fixedLength = 2
    pass

class TransportType(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,255)
    pass

class UTF8OwnerString(TextualConvention, OctetString):
    displayHint = "127t"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,127)
    pass


# Objects

flowMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 40)).setRevisions(("1999-10-25 00:00","1999-08-30 12:50","1999-08-19 10:10","1997-12-23 09:37","1997-07-07 17:15","1996-03-08 02:08",))
if mibBuilder.loadTexts: flowMIB.setOrganization("IETF Realtime Traffic Flow Measurement Working Group")
if mibBuilder.loadTexts: flowMIB.setContactInfo("Nevil Brownlee, The University of Auckland\n\nPostal: Information Technology Sytems & Services\n        The University of Auckland\n        Private Bag 92-019\n        Auckland, New Zealand\n\nPhone:  +64 9 373 7599 x8941\nE-mail: n.brownlee@auckland.ac.nz")
if mibBuilder.loadTexts: flowMIB.setDescription("MIB for the RTFM Traffic Flow Meter.")
flowControl = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 1))
flowRuleSetInfoTable = MibTable((1, 3, 6, 1, 2, 1, 40, 1, 1))
if mibBuilder.loadTexts: flowRuleSetInfoTable.setDescription("An array of information about the RuleSets held in the\nmeter.\n\nAny manager may configure a new RuleSet for the meter by\ncreating a row in this table with status active(1), and setting\nvalues for all the objects in its rules.  At this stage the new\nRuleSet is available but not 'running', i.e. it is not being\nused by the meter to produce entries in the flow table.\n\nTo actually 'run' a RuleSet a manager must create a row in\nthe flowManagerInfoTable, set it's flowManagerStatus to\nactive(1), and set either its CurrentRuleSet or StandbyRuleSet\nto point to the RuleSet to be run.\n\nOnce a RuleSet is running a manager may not change any of the\nobjects within the RuleSet itself.  Any attempt to do so should\nresult in a notWritable(17) SNMP error-status for such objects.\n\nA manager may stop a RuleSet running by removing all\nreferences to it in the flowManagerInfoTable (i.e. by setting\nCurrentRuleSet and StandbyRuleSet values to 0).  This provides\na way to stop RuleSets left running if a manager fails.\nFor example, when a manager is started, it could search the\nmeter's flowManager table and stop all RuleSets having a\nspecified value of flowRuleInfoOwner.\n\nTo prevent a manager from interfering with variables belonging\nto another manager, the meter should use MIB views [RFC2575] so\nas to limit each manager's access to the meter's variables,\neffectively dividing the single meter into several virtual\nmeters, one for each independent manager.")
flowRuleSetInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 1, 1, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowRuleInfoIndex"))
if mibBuilder.loadTexts: flowRuleSetInfoEntry.setDescription("Information about a particular RuleSet.")
flowRuleInfoIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowRuleInfoIndex.setDescription("An index which selects an entry in the flowRuleSetInfoTable.\nEach such entry contains control information for a particular\nRuleSet which the meter may run.")
flowRuleInfoSize = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 2), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowRuleInfoSize.setDescription("Number of rules in this RuleSet.  Setting this variable will\ncause the meter to allocate space for these rules.")
flowRuleInfoOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 3), UTF8OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowRuleInfoOwner.setDescription("Identifies the manager which 'owns' this RuleSet.  A manager\nmust set this variable when creating a row in this table.")
flowRuleInfoTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowRuleInfoTimeStamp.setDescription("Time this row's associated RuleSet was last changed.")
flowRuleInfoStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowRuleInfoStatus.setDescription("The status of this flowRuleSetInfoEntry. If this value is\nnot active(1) the meter must not attempt to use the row's\nassociated RuleSet.  Once its value has been set to active(1)\na manager may not change any of the other variables in the\nrow, nor the contents of the associated RuleSet.  Any attempt\nto do so should result in a notWritable(17) SNMP error-status\nfor such variables or objects.\n\nTo download a RuleSet, a manger could:\n   - Locate an open slot in the RuleSetInfoTable.\n   - Create a RuleSetInfoEntry by setting the status for this\n       open slot to createAndWait(5).\n   - Set flowRuleInfoSize and flowRuleInfoName as required.\n   - Download the rules into the row's rule table.\n   - Set flowRuleInfoStatus to active(1).\n\nThe RuleSet would then be ready to run. The manager is not\nallowed to change the value of flowRuleInfoStatus from\nactive(1) if the associated RuleSet is being referenced by any\nof the entries in the flowManagerInfoTable.\n\nSetting RuleInfoStatus to destroy(6) destroys the associated\nRuleSet together with any flow data collected by it.")
flowRuleInfoName = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 6), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowRuleInfoName.setDescription("An alphanumeric identifier used by managers and readers to\nidentify a RuleSet.  For example, a manager wishing to run a\nRuleSet named WWW-FLOWS could search the flowRuleSetInfoTable\nto see whether the WWW-FLOWS RuleSet is already available on\nthe meter.\n\nNote that references to RuleSets in the flowManagerInfoTable\nuse indexes for their flowRuleSetInfoTable entries.  These may\nbe different each time the RuleSet is loaded into a meter.")
flowRuleInfoRulesReady = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 7), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowRuleInfoRulesReady.setDescription("Indicates whether the rules for this row's associated RuleSet\nare ready for use.  The meter will refuse to 'run' the RuleSet\nunless this variable has been set to true(1).\nWhile RulesReady is false(2), the manager may modify the\nRuleSet, for example by downloading rules into it.")
flowRuleInfoFlowRecords = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 1, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowRuleInfoFlowRecords.setDescription("The number of entries in the flow table for this RuleSet.\nThese may be current (waiting for collection by one or more\nmeter readers) or idle (waiting for the meter to recover\ntheir memory).")
flowInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 40, 1, 2))
if mibBuilder.loadTexts: flowInterfaceTable.setDescription("An array of information specific to each meter interface.")
flowInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: flowInterfaceEntry.setDescription("Information about a particular interface.")
flowInterfaceSampleRate = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 2, 1, 1), Integer32().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowInterfaceSampleRate.setDescription("The parameter N for statistical counting on this interface.\nSet to N to count 1/Nth of the packets appearing at this\ninterface.  A sampling rate of 1 counts all packets.\nA sampling rate of 0 results in the interface being ignored\nby the meter.\n\nA meter should choose its own algorithm to introduce variance\ninto the sampling so that exactly every Nth packet is counted.\nThe IPPM Working Group's RFC 'Framework for IP Performance\nMetrics' [IPPM-FRM] explains why this should be done, and sets\nout an algorithm for doing it.")
flowInterfaceLostPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowInterfaceLostPackets.setDescription("The number of packets the meter has lost for this interface.\nSuch losses may occur because the meter has been unable to\nkeep up with the traffic volume.")
flowReaderInfoTable = MibTable((1, 3, 6, 1, 2, 1, 40, 1, 3))
if mibBuilder.loadTexts: flowReaderInfoTable.setDescription("An array of information about meter readers which have\nregistered their intent to collect flow data from this meter.")
flowReaderInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 1, 3, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowReaderIndex"))
if mibBuilder.loadTexts: flowReaderInfoEntry.setDescription("Information about a particular meter reader.")
flowReaderIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowReaderIndex.setDescription("An index which selects an entry in the flowReaderInfoTable.")
flowReaderTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 2), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowReaderTimeout.setDescription("Specifies the maximum time (in seconds) between flow data\ncollections for this meter reader.  If this time elapses\nwithout a collection, the meter should assume that this meter\nreader has stopped collecting, and delete this row from the\ntable.  A value of zero indicates that this row should not be\ntimed out.")
flowReaderOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 3), UTF8OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowReaderOwner.setDescription("Identifies the meter reader which created this row.")
flowReaderLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 4), TimeStamp()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowReaderLastTime.setDescription("Time this meter reader began its most recent data collection.\n\nThis variable should be written by a meter reader as its first\nstep in reading flow data.  The meter will set this LastTime\nvalue to its current Uptime, and set its PreviousTime value\n(below) to the old  LastTime.  This allows the meter to\nrecover flows which have been inactive since PreviousTime,\nfor these have been collected at least once.\n\nIf the meter reader fails to write flowLastReadTime, collection\nmay still proceed but the meter may not be able to recover\ninactive flows until the flowReaderTimeout has been reached\nfor this entry.")
flowReaderPreviousTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowReaderPreviousTime.setDescription("Time this meter reader began the collection before last.")
flowReaderStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowReaderStatus.setDescription("The status of this FlowReaderInfoEntry. A value of active(1)\nimplies that the associated reader should be collecting data\nfrom the meter.  Once this variable has been set to active(1)\na manager may only change this row's flowReaderLastTime and\nflowReaderTimeout variables.")
flowReaderRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowReaderRuleSet.setDescription("An index to the array of RuleSets.  Specifies a set of rules\nof interest to this meter reader.  The reader will attempt to\ncollect any data generated by the meter for this RuleSet, and\nthe meter will not recover the memory of any of the RuleSet's\nflows until this collection has taken place.  Note that a\nreader may have entries in this table for several RuleSets.")
flowManagerInfoTable = MibTable((1, 3, 6, 1, 2, 1, 40, 1, 4))
if mibBuilder.loadTexts: flowManagerInfoTable.setDescription("An array of information about managers which have\nregistered their intent to run RuleSets on this meter.")
flowManagerInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 1, 4, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowManagerIndex"))
if mibBuilder.loadTexts: flowManagerInfoEntry.setDescription("Information about a particular meter 'task.'  By creating\nan entry in this table and activating it, a manager requests\nthat the meter 'run' the indicated RuleSet.\n\nThe entry also specifies a HighWaterMark and a StandbyRuleSet.\nIf the meter's flow table usage exceeds this task's\nHighWaterMark the meter will stop running the task's\nCurrentRuleSet and switch to its StandbyRuleSet.\n\nIf the value of the task's StandbyRuleSet is 0 when its\nHighWaterMark is exceeded, the meter simply stops running the\ntask's CurrentRuleSet.  By careful selection of HighWaterMarks\nfor the various tasks a manager can ensure that the most\ncritical RuleSets are the last to stop running as the number\nof flows increases.\n\nWhen a manager has determined that the demand for flow table\nspace has abated, it may cause the task to switch back to its\nCurrentRuleSet by setting its flowManagerRunningStandby\nvariable to false(2).")
flowManagerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowManagerIndex.setDescription("An index which selects an entry in the flowManagerInfoTable.")
flowManagerCurrentRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 2), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerCurrentRuleSet.setDescription("Index to the array of RuleSets.  Specifies which set of\nrules is the 'current' one for this task.  The meter will\nbe 'running' the current RuleSet if this row's\nflowManagerRunningStandby value is false(2).\n\nWhen the manager sets this variable the meter will stop using\nthe task's old current RuleSet and start using the new one.\nSpecifying RuleSet 0 (the empty set) stops flow measurement\nfor this task.")
flowManagerStandbyRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 3), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerStandbyRuleSet.setDescription("Index to the array of RuleSets.  After reaching HighWaterMark\n(see below) the manager will switch to using the task's\nStandbyRuleSet in place of its CurrentRuleSet.  For this to be\neffective the designated StandbyRuleSet should have a coarser\nreporting granularity then the CurrentRuleSet.  The manager may\nalso need to decrease the meter reading interval so that the\nmeter can recover flows measured by this task's CurrentRuleSet.")
flowManagerHighWaterMark = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerHighWaterMark.setDescription("A value expressed as a percentage, interpreted by the meter\nas an indication of how full the flow table should be before\nit should switch to the standby RuleSet (if one has been\nspecified) for this task.  Values of 0% or 100% disable the\nchecking represented by this variable.")
flowManagerCounterWrap = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("wrap", 1), ("scale", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerCounterWrap.setDescription("Specifies whether PDU and octet counters should wrap when\nthey reach the top of their range (normal behaviour for\nCounter64 objects), or whether their scale factors should\nbe used instead.  The combination of counter and scale\nfactor allows counts to be returned as non-negative binary\nfloating point numbers, with 64-bit mantissas and 8-bit\nexponents.")
flowManagerOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 6), UTF8OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerOwner.setDescription("Identifies the manager which created this row.")
flowManagerTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowManagerTimeStamp.setDescription("Time this row was last changed by its manager.")
flowManagerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerStatus.setDescription("The status of this row in the flowManagerInfoTable.  A value\nof active(1) implies that this task may be activated, by\nsetting its CurrentRuleSet and StandbyRuleSet variables.\nIts HighWaterMark and RunningStandby variables may also be\nchanged.")
flowManagerRunningStandby = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 1, 4, 1, 9), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: flowManagerRunningStandby.setDescription("Set to true(1) by the meter to indicate that it has switched\nto runnning this task's StandbyRuleSet in place of its\nCurrentRuleSet.  To switch back to the CurrentRuleSet, the\nmanager may simply set this variable to false(2).")
flowFloodMark = MibScalar((1, 3, 6, 1, 2, 1, 40, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100)).clone(95)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowFloodMark.setDescription("A value expressed as a percentage, interpreted by the meter\nas an indication of how full the flow table should be before\nit should take some action to avoid running out of resources\nto handle new flows, as discussed in section 4.6 (Handling\nIncreasing Traffic Levels) of the RTFM Architecture RFC\n[RTFM-ARC].\n\nValues of 0% or 100% disable the checking represented by\nthis variable.")
flowInactivityTimeout = MibScalar((1, 3, 6, 1, 2, 1, 40, 1, 6), Integer32().clone(600)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowInactivityTimeout.setDescription("The time in seconds since the last packet seen, after which\na flow becomes 'idle.'  Note that although a flow may be\nidle, it will not be discarded (and its memory recovered)\nuntil after its data has been collected by all the meter\nreaders registered for its RuleSet.")
flowActiveFlows = MibScalar((1, 3, 6, 1, 2, 1, 40, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowActiveFlows.setDescription("The number of flows which are currently in use.")
flowMaxFlows = MibScalar((1, 3, 6, 1, 2, 1, 40, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowMaxFlows.setDescription("The maximum number of flows allowed in the meter's\nflow table.  At present this is determined when the meter\nis first started up.")
flowFloodMode = MibScalar((1, 3, 6, 1, 2, 1, 40, 1, 9), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowFloodMode.setDescription("Indicates that the meter has passed its FloodMark and is\nnot running in its normal mode.\n\nWhen the manager notices this it should take action to remedy\nthe problem which caused the flooding.  It should then monitor\nflowActiveFlows so as to determine when the flood has receded.\nAt that point the manager may set flowFloodMode to false(2) to\nresume normal operation.")
flowData = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 2))
flowDataTable = MibTable((1, 3, 6, 1, 2, 1, 40, 2, 1))
if mibBuilder.loadTexts: flowDataTable.setDescription("The list of all flows being measured.")
flowDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 2, 1, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowDataRuleSet"), (0, "FLOW-METER-MIB", "flowDataTimeMark"), (0, "FLOW-METER-MIB", "flowDataIndex"))
if mibBuilder.loadTexts: flowDataEntry.setDescription("The flow data record for a particular flow.")
flowDataIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowDataIndex.setDescription("Value of this flow data record's index within the meter's\nflow table.")
flowDataTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 2), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowDataTimeMark.setDescription("A TimeFilter for this entry.  Allows GetNext and GetBulk\nto find flow table rows which have changed since a specified\nvalue of the meter's Uptime.")
flowDataStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("current", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataStatus.setDescription("Status of this flow data record.")
flowDataSourceInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceInterface.setDescription("Index of the interface associated with the source address\nfor this flow.  It's value is one of those contained in the\nifIndex field of the meter's interfaces table.")
flowDataSourceAdjacentType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 5), AdjacentType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceAdjacentType.setDescription("Adjacent address type of the source for this flow.\n\nIf metering is being performed at the network level,\nAdjacentType will indicate the medium for the interface on\nwhich the flow was observed and AdjacentAddress will be the\nMAC address for that interface.  This is the usual case.\n\nIf traffic is being metered inside a tunnel, AdjacentType will\nbe the peer type of the host at the end of the tunnel and\nAdjacentAddress will be the peer address for that host.")
flowDataSourceAdjacentAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 6), AdjacentAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceAdjacentAddress.setDescription("Address of the adjacent device on the path for the source\nfor this flow.")
flowDataSourceAdjacentMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 7), AdjacentAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceAdjacentMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the adjacent source address for this flow.")
flowDataSourcePeerType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 8), PeerType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourcePeerType.setDescription("Peer address type of the source for this flow.")
flowDataSourcePeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 9), PeerAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourcePeerAddress.setDescription("Address of the peer device for the source of this flow.")
flowDataSourcePeerMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 10), PeerAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourcePeerMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the source peer address for this flow.")
flowDataSourceTransType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 11), TransportType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceTransType.setDescription("Transport address type of the source for this flow.  The\nvalue of this attribute will depend on the peer address type.")
flowDataSourceTransAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 12), TransportAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceTransAddress.setDescription("Transport address for the source of this flow.")
flowDataSourceTransMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 13), TransportAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceTransMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the transport source address for this flow.")
flowDataDestInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 14), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestInterface.setDescription("Index of the interface associated with the dest address for\nthis flow.  This value is one of the values contained in the\nifIndex field of the interfaces table.")
flowDataDestAdjacentType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 15), AdjacentType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestAdjacentType.setDescription("Adjacent address type of the destination for this flow.")
flowDataDestAdjacentAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 16), AdjacentAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestAdjacentAddress.setDescription("Address of the adjacent device on the path for the\ndestination for this flow.")
flowDataDestAdjacentMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 17), AdjacentAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestAdjacentMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the adjacent destination address for this flow.")
flowDataDestPeerType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 18), PeerType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestPeerType.setDescription("Peer address type of the destination for this flow.")
flowDataDestPeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 19), PeerAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestPeerAddress.setDescription("Address of the peer device for the destination of this flow.")
flowDataDestPeerMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 20), PeerAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestPeerMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the destination peer type for this flow.")
flowDataDestTransType = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 21), TransportType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestTransType.setDescription("Transport address type of the destination for this flow.  The\nvalue of this attribute will depend on the peer address type.")
flowDataDestTransAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 22), TransportAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestTransAddress.setDescription("Transport address for the destination of this flow.")
flowDataDestTransMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 23), TransportAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestTransMask.setDescription("1-bits in this mask indicate which bits must match when\ncomparing the transport destination address for this flow.")
flowDataPDUScale = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 24), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataPDUScale.setDescription("The scale factor applied to this particular flow.  Indicates\nthe number of bits the PDU counter values should be moved left\nto obtain the actual values.")
flowDataOctetScale = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 25), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataOctetScale.setDescription("The scale factor applied to this particular flow.  Indicates\nthe number of bits the octet counter values should be moved\nleft to obtain the actual values.")
flowDataRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 26), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowDataRuleSet.setDescription("The RuleSet number of the RuleSet which created this flow.\nAllows a manager to use GetNext or GetBulk requests to find\nflows belonging to a particular RuleSet.")
flowDataToOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 27), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataToOctets.setDescription("The count of octets flowing from source to destination\nfor this flow.")
flowDataToPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 28), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataToPDUs.setDescription("The count of packets flowing from source to destination\nfor this flow.")
flowDataFromOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 29), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataFromOctets.setDescription("The count of octets flowing from destination to source\nfor this flow.")
flowDataFromPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 30), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataFromPDUs.setDescription("The count of packets flowing from destination to source\nfor this flow.")
flowDataFirstTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 31), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataFirstTime.setDescription("The time at which this flow was first entered in the table")
flowDataLastActiveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 32), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataLastActiveTime.setDescription("The last time this flow had activity, i.e. the time of\narrival of the most recent PDU belonging to this flow.")
flowDataSourceSubscriberID = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 33), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 20))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceSubscriberID.setDescription("Subscriber ID associated with the source address for this\nflow.  A Subscriber ID is an unspecified text string, used\nto ascribe traffic flows to individual users.  At this time\nthe means by which a Subscriber ID may be associated with a\nflow is unspecified.")
flowDataDestSubscriberID = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 34), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 20))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestSubscriberID.setDescription("Subscriber ID associated with the destination address for\nthis flow.  A Subscriber ID is an unspecified text string,\nused to ascribe traffic flows to individual users.  At this\ntime the means by which a Subscriber ID may be associated\nwith a flow is unspecified.")
flowDataSessionID = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 35), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSessionID.setDescription("Session ID for this flow.  Such an ID might be allocated\nby a network access server to distinguish a series of sessions\nbetween the same pair of addresses, which would otherwise\nappear to be parts of the same accounting flow.")
flowDataSourceClass = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 36), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceClass.setDescription("Source class for this flow.  Determined by the rules, set by\na PushRule action when this flow was entered in the table.")
flowDataDestClass = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 37), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestClass.setDescription("Destination class for this flow.  Determined by the rules, set\nby a PushRule action when this flow was entered in the table.")
flowDataClass = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 38), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataClass.setDescription("Class for this flow.  Determined by the rules, set by a\nPushRule action when this flow was entered in the table.")
flowDataSourceKind = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 39), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataSourceKind.setDescription("Source kind for this flow.  Determined by the rules, set by\na PushRule action when this flow was entered in the table.")
flowDataDestKind = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 40), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataDestKind.setDescription("Destination kind for this flow.  Determined by the rules, set\nby a PushRule action when this flow was entered in the table.")
flowDataKind = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 1, 1, 41), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowDataKind.setDescription("Class for this flow.  Determined by the rules, set by a\nPushRule action when this flow was entered in the table.")
flowColumnActivityTable = MibTable((1, 3, 6, 1, 2, 1, 40, 2, 2))
if mibBuilder.loadTexts: flowColumnActivityTable.setDescription("Index into the Flow Table.  Allows a meter reader to retrieve\na list containing the flow table indexes of flows which were\nlast active at or after a given time, together with the values\nof a specified attribute for each such flow.")
flowColumnActivityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 2, 2, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowColumnActivityAttribute"), (0, "FLOW-METER-MIB", "flowColumnActivityTime"), (0, "FLOW-METER-MIB", "flowColumnActivityIndex"))
if mibBuilder.loadTexts: flowColumnActivityEntry.setDescription("The Column Activity Entry for a particular attribute,\nactivity time and flow.")
flowColumnActivityAttribute = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 2, 1, 1), FlowAttributeNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowColumnActivityAttribute.setDescription("Specifies the attribute for which values are required from\nactive flows.")
flowColumnActivityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 2, 1, 2), TimeFilter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowColumnActivityTime.setDescription("This variable is a copy of flowDataLastActiveTime in the\nflow data record identified by the flowColumnActivityIndex\nvalue of this flowColumnActivityTable entry.")
flowColumnActivityIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowColumnActivityIndex.setDescription("Index of a flow table entry which was active at or after\na specified flowColumnActivityTime.")
flowColumnActivityData = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 2, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 1000))).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowColumnActivityData.setDescription("Collection of attribute data for flows active after\nflowColumnActivityTime.  Within the OCTET STRING is a\nsequence of { flow index, attribute value } pairs, one for\neach active flow.  The end of the sequence is marked by a\nflow index value of 0, indicating that there are no more\nrows in this column.\n\nThe format of objects inside flowColumnFlowData is as follows.\nAll numbers are unsigned.  Numbers and strings appear with\ntheir high-order bytes leading.  Numbers are fixed size, as\nspecified by their SYNTAX in the flow table (above), i.e. one\noctet for flowAddressType and small constants, and four octets\nfor Counter and TimeStamp.  Strings are variable-length, with\nthe length given in a single leading octet.\n\nThe following is an attempt at an ASN.1 definition of\nflowColumnActivityData:\n\nflowColumnActivityData ::= SEQUENCE flowRowItemEntry\nflowRowItemEntry ::= SEQUENCE {\n   flowRowNumber    Integer32 (1..65535),\n                         -- 0 indicates the end of this column\n   flowDataValue   flowDataType -- Choice depends on attribute\n   }\nflowDataType ::= CHOICE {\n    flowByteValue   Integer32 (1..255),\n    flowShortValue  Integer32 (1..65535),\n    flowLongValue   Integer32,\n    flowStringValue OCTET STRING  -- Length (n) in first byte,\n          -- n+1 bytes total length, trailing zeroes truncated\n    }")
flowDataPackageTable = MibTable((1, 3, 6, 1, 2, 1, 40, 2, 3))
if mibBuilder.loadTexts: flowDataPackageTable.setDescription("Index into the Flow Table.  Allows a meter reader to retrieve\na sequence containing the values of a specified set of\nattributes for a flow which came from a specified RuleSet and\nwhich was last active at or after a given time.")
flowDataPackageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 2, 3, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowPackageSelector"), (0, "FLOW-METER-MIB", "flowPackageRuleSet"), (0, "FLOW-METER-MIB", "flowPackageTime"), (0, "FLOW-METER-MIB", "flowPackageIndex"))
if mibBuilder.loadTexts: flowDataPackageEntry.setDescription("The data package containing selected variables from\nactive rows in the flow table.")
flowPackageSelector = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 3, 1, 1), OctetString()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowPackageSelector.setDescription("Specifies the attributes for which values are required from\nan active flow.  These are encoded as a sequence of octets\neach containing a FlowAttribute number, preceded by an octet\ngiving the length of the sequence (not including the length\noctet).  For a flowPackageSelector to be valid, it must\ncontain at least one attribute.")
flowPackageRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowPackageRuleSet.setDescription("Specifies the index (in the flowRuleSetInfoTable) of the rule\nset which produced the required flow.")
flowPackageTime = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 3, 1, 3), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowPackageTime.setDescription("This variable is a copy of flowDataLastActiveTime in the\nflow data record identified by the flowPackageIndex\nvalue of this flowPackageTable entry.")
flowPackageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowPackageIndex.setDescription("Index of a flow table entry which was active at or after\na specified flowPackageTime.")
flowPackageData = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 2, 3, 1, 5), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: flowPackageData.setDescription("A collection of attribute values for a single flow, as\nspecified by this row's indexes.  The attribute values are\ncontained within a BER-encoded sequence [ASN-1, ASN-BER],\nin the order they appear in their flowPackageSelector.\n\nFor example, to retrieve a flowPackage containing values for\nattributes 11, 18 and 29, for a flow in RuleSet 7, with flow\nindex 3447, one would GET the package whose Object Identifier\n(OID) is\n    flowPackageData . 3.11.18.29 . 7. 0 . 3447\n\nTo get a package for the next such flow which had been\nactive since time 12345 one would GETNEXT the package whose\nObject Identifier (OID) is\n    flowPackageData . 3.11.18.29 . 7. 12345 . 3447")
flowRules = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 3))
flowRuleTable = MibTable((1, 3, 6, 1, 2, 1, 40, 3, 1))
if mibBuilder.loadTexts: flowRuleTable.setDescription("Contains all the RuleSets which may be used by the meter.")
flowRuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 40, 3, 1, 1)).setIndexNames((0, "FLOW-METER-MIB", "flowRuleSet"), (0, "FLOW-METER-MIB", "flowRuleIndex"))
if mibBuilder.loadTexts: flowRuleEntry.setDescription("The rule record itself.")
flowRuleSet = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowRuleSet.setDescription("Selects a RuleSet from the array of RuleSets.")
flowRuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: flowRuleIndex.setDescription("The index into the Rule table.  N.B: These values will\nnormally be consecutive, given the fall-through semantics\nof processing the table.")
flowRuleSelector = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 3), RuleAttributeNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowRuleSelector.setDescription("Indicates the attribute to be matched.\n\nnull(0) is a special case; null rules always succeed.\nmatchingStoD(50) is set by the meter's Packet Matching Engine.\nIts value is true(1) if the PME is attempting to match the\npacket with its addresses in Source-to-Destination order (i.e.\nas they appear in the packet), and false(2) otherwise.\nDetails of how packets are matched are given in the 'Traffic\nFlow Measurement: Architecture' document [RTFM-ARC].\nv1(51), v2(52), v3(53), v4(54) and v5(55) select meter\nvariables, each of which can hold the name (i.e. selector\nvalue) of an address attribute.  When one of these is used\nas a selector, its value specifies the attribute to be\ntested.  Variable values are set by an Assign action.")
flowRuleMask = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 4), RuleAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowRuleMask.setDescription("The initial mask used to compute the desired value.  If the\nmask is zero the rule's test will always succeed.")
flowRuleMatchedValue = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 5), RuleAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowRuleMatchedValue.setDescription("The resulting value to be matched for equality.\nSpecifically, if the attribute chosen by the flowRuleSelector\nlogically ANDed with the mask specified by the flowRuleMask\nequals the value specified in the flowRuleMatchedValue, then\ncontinue processing the table entry based on the action\nspecified by the flowRuleAction entry.  Otherwise, proceed to\nthe next entry in the rule table.")
flowRuleAction = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 6), ActionNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowRuleAction.setDescription("The action to be taken if this rule's test succeeds, or if\nthe meter's 'test' flag is off.  Actions are opcodes for the\nmeter's Packet Matching Engine; details are given in the\n'Traffic Flow Measurement: Architecture' document [RTFM-ARC].")
flowRuleParameter = MibTableColumn((1, 3, 6, 1, 2, 1, 40, 3, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: flowRuleParameter.setDescription("A parameter value providing extra information for this rule's\naction.  Most of the actions use the parameter value to specify\nwhich rule to execute after this rule's test has failed; details\nare given in the 'Traffic Flow Measurement: Architecture'\ndocument [RTFM-ARC].")
flowMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 4))
flowMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 4, 1))
flowMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 40, 4, 2))

# Augmentions

# Groups

flowDataScaleGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 8)).setObjects(("FLOW-METER-MIB", "flowDataPDUScale"), ("FLOW-METER-MIB", "flowDataOctetScale"), )
flowDataScaleGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 3)).setObjects(("FLOW-METER-MIB", "flowDataPDUScale"), ("FLOW-METER-MIB", "flowDataOctetScale"), ("FLOW-METER-MIB", "flowManagerCounterWrap"), )
flowControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 1)).setObjects(("FLOW-METER-MIB", "flowFloodMark"), ("FLOW-METER-MIB", "flowManagerOwner"), ("FLOW-METER-MIB", "flowActiveFlows"), ("FLOW-METER-MIB", "flowReaderOwner"), ("FLOW-METER-MIB", "flowManagerStatus"), ("FLOW-METER-MIB", "flowManagerCounterWrap"), ("FLOW-METER-MIB", "flowRuleInfoFlowRecords"), ("FLOW-METER-MIB", "flowInactivityTimeout"), ("FLOW-METER-MIB", "flowMaxFlows"), ("FLOW-METER-MIB", "flowFloodMode"), ("FLOW-METER-MIB", "flowManagerTimeStamp"), ("FLOW-METER-MIB", "flowInterfaceSampleRate"), ("FLOW-METER-MIB", "flowManagerRunningStandby"), ("FLOW-METER-MIB", "flowManagerHighWaterMark"), ("FLOW-METER-MIB", "flowRuleInfoTimeStamp"), ("FLOW-METER-MIB", "flowReaderLastTime"), ("FLOW-METER-MIB", "flowRuleInfoName"), ("FLOW-METER-MIB", "flowRuleInfoOwner"), ("FLOW-METER-MIB", "flowReaderTimeout"), ("FLOW-METER-MIB", "flowReaderStatus"), ("FLOW-METER-MIB", "flowReaderRuleSet"), ("FLOW-METER-MIB", "flowReaderPreviousTime"), ("FLOW-METER-MIB", "flowRuleInfoRulesReady"), ("FLOW-METER-MIB", "flowInterfaceLostPackets"), ("FLOW-METER-MIB", "flowManagerCurrentRuleSet"), ("FLOW-METER-MIB", "flowRuleInfoStatus"), ("FLOW-METER-MIB", "flowManagerStandbyRuleSet"), ("FLOW-METER-MIB", "flowRuleInfoSize"), )
flowRuleTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 7)).setObjects(("FLOW-METER-MIB", "flowRuleSelector"), ("FLOW-METER-MIB", "flowRuleAction"), ("FLOW-METER-MIB", "flowRuleParameter"), ("FLOW-METER-MIB", "flowRuleMask"), ("FLOW-METER-MIB", "flowRuleMatchedValue"), )
flowDataColumnTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 5)).setObjects(("FLOW-METER-MIB", "flowColumnActivityIndex"), ("FLOW-METER-MIB", "flowColumnActivityTime"), ("FLOW-METER-MIB", "flowColumnActivityData"), ("FLOW-METER-MIB", "flowColumnActivityAttribute"), )
flowDataPackageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 6)).setObjects(("FLOW-METER-MIB", "flowPackageData"), )
flowControlGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 9)).setObjects(("FLOW-METER-MIB", "flowFloodMark"), ("FLOW-METER-MIB", "flowManagerOwner"), ("FLOW-METER-MIB", "flowActiveFlows"), ("FLOW-METER-MIB", "flowReaderOwner"), ("FLOW-METER-MIB", "flowManagerStatus"), ("FLOW-METER-MIB", "flowMaxFlows"), ("FLOW-METER-MIB", "flowRuleInfoFlowRecords"), ("FLOW-METER-MIB", "flowInactivityTimeout"), ("FLOW-METER-MIB", "flowFloodMode"), ("FLOW-METER-MIB", "flowManagerTimeStamp"), ("FLOW-METER-MIB", "flowInterfaceSampleRate"), ("FLOW-METER-MIB", "flowManagerRunningStandby"), ("FLOW-METER-MIB", "flowManagerHighWaterMark"), ("FLOW-METER-MIB", "flowRuleInfoTimeStamp"), ("FLOW-METER-MIB", "flowReaderLastTime"), ("FLOW-METER-MIB", "flowRuleInfoName"), ("FLOW-METER-MIB", "flowRuleInfoOwner"), ("FLOW-METER-MIB", "flowReaderTimeout"), ("FLOW-METER-MIB", "flowReaderStatus"), ("FLOW-METER-MIB", "flowReaderRuleSet"), ("FLOW-METER-MIB", "flowReaderPreviousTime"), ("FLOW-METER-MIB", "flowInterfaceLostPackets"), ("FLOW-METER-MIB", "flowManagerCurrentRuleSet"), ("FLOW-METER-MIB", "flowRuleInfoStatus"), ("FLOW-METER-MIB", "flowManagerStandbyRuleSet"), ("FLOW-METER-MIB", "flowRuleInfoSize"), )
flowDataSubscriberGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 4)).setObjects(("FLOW-METER-MIB", "flowDataSourceSubscriberID"), ("FLOW-METER-MIB", "flowDataSessionID"), ("FLOW-METER-MIB", "flowDataDestSubscriberID"), )
flowDataTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 40, 4, 2, 2)).setObjects(("FLOW-METER-MIB", "flowDataSourceClass"), ("FLOW-METER-MIB", "flowDataDestTransType"), ("FLOW-METER-MIB", "flowDataSourceTransMask"), ("FLOW-METER-MIB", "flowDataDestAdjacentMask"), ("FLOW-METER-MIB", "flowDataDestKind"), ("FLOW-METER-MIB", "flowDataSourceAdjacentMask"), ("FLOW-METER-MIB", "flowDataSourceAdjacentType"), ("FLOW-METER-MIB", "flowDataDestInterface"), ("FLOW-METER-MIB", "flowDataDestClass"), ("FLOW-METER-MIB", "flowDataSourceInterface"), ("FLOW-METER-MIB", "flowDataStatus"), ("FLOW-METER-MIB", "flowDataDestTransAddress"), ("FLOW-METER-MIB", "flowDataDestPeerMask"), ("FLOW-METER-MIB", "flowDataClass"), ("FLOW-METER-MIB", "flowDataSourcePeerAddress"), ("FLOW-METER-MIB", "flowDataFromOctets"), ("FLOW-METER-MIB", "flowDataFirstTime"), ("FLOW-METER-MIB", "flowDataSourceAdjacentAddress"), ("FLOW-METER-MIB", "flowDataSourceKind"), ("FLOW-METER-MIB", "flowDataToPDUs"), ("FLOW-METER-MIB", "flowDataDestTransMask"), ("FLOW-METER-MIB", "flowDataKind"), ("FLOW-METER-MIB", "flowDataSourcePeerType"), ("FLOW-METER-MIB", "flowDataSourceTransAddress"), ("FLOW-METER-MIB", "flowDataSourcePeerMask"), ("FLOW-METER-MIB", "flowDataSourceTransType"), ("FLOW-METER-MIB", "flowDataDestPeerAddress"), ("FLOW-METER-MIB", "flowDataDestAdjacentType"), ("FLOW-METER-MIB", "flowDataDestPeerType"), ("FLOW-METER-MIB", "flowDataFromPDUs"), ("FLOW-METER-MIB", "flowDataDestAdjacentAddress"), ("FLOW-METER-MIB", "flowDataLastActiveTime"), ("FLOW-METER-MIB", "flowDataToOctets"), )

# Exports

# Module identity
mibBuilder.exportSymbols("FLOW-METER-MIB", PYSNMP_MODULE_ID=flowMIB)

# Types
mibBuilder.exportSymbols("FLOW-METER-MIB", ActionNumber=ActionNumber, AdjacentAddress=AdjacentAddress, AdjacentType=AdjacentType, FlowAttributeNumber=FlowAttributeNumber, PeerAddress=PeerAddress, PeerType=PeerType, RuleAddress=RuleAddress, RuleAttributeNumber=RuleAttributeNumber, TransportAddress=TransportAddress, TransportType=TransportType, UTF8OwnerString=UTF8OwnerString)

# Objects
mibBuilder.exportSymbols("FLOW-METER-MIB", flowMIB=flowMIB, flowControl=flowControl, flowRuleSetInfoTable=flowRuleSetInfoTable, flowRuleSetInfoEntry=flowRuleSetInfoEntry, flowRuleInfoIndex=flowRuleInfoIndex, flowRuleInfoSize=flowRuleInfoSize, flowRuleInfoOwner=flowRuleInfoOwner, flowRuleInfoTimeStamp=flowRuleInfoTimeStamp, flowRuleInfoStatus=flowRuleInfoStatus, flowRuleInfoName=flowRuleInfoName, flowRuleInfoRulesReady=flowRuleInfoRulesReady, flowRuleInfoFlowRecords=flowRuleInfoFlowRecords, flowInterfaceTable=flowInterfaceTable, flowInterfaceEntry=flowInterfaceEntry, flowInterfaceSampleRate=flowInterfaceSampleRate, flowInterfaceLostPackets=flowInterfaceLostPackets, flowReaderInfoTable=flowReaderInfoTable, flowReaderInfoEntry=flowReaderInfoEntry, flowReaderIndex=flowReaderIndex, flowReaderTimeout=flowReaderTimeout, flowReaderOwner=flowReaderOwner, flowReaderLastTime=flowReaderLastTime, flowReaderPreviousTime=flowReaderPreviousTime, flowReaderStatus=flowReaderStatus, flowReaderRuleSet=flowReaderRuleSet, flowManagerInfoTable=flowManagerInfoTable, flowManagerInfoEntry=flowManagerInfoEntry, flowManagerIndex=flowManagerIndex, flowManagerCurrentRuleSet=flowManagerCurrentRuleSet, flowManagerStandbyRuleSet=flowManagerStandbyRuleSet, flowManagerHighWaterMark=flowManagerHighWaterMark, flowManagerCounterWrap=flowManagerCounterWrap, flowManagerOwner=flowManagerOwner, flowManagerTimeStamp=flowManagerTimeStamp, flowManagerStatus=flowManagerStatus, flowManagerRunningStandby=flowManagerRunningStandby, flowFloodMark=flowFloodMark, flowInactivityTimeout=flowInactivityTimeout, flowActiveFlows=flowActiveFlows, flowMaxFlows=flowMaxFlows, flowFloodMode=flowFloodMode, flowData=flowData, flowDataTable=flowDataTable, flowDataEntry=flowDataEntry, flowDataIndex=flowDataIndex, flowDataTimeMark=flowDataTimeMark, flowDataStatus=flowDataStatus, flowDataSourceInterface=flowDataSourceInterface, flowDataSourceAdjacentType=flowDataSourceAdjacentType, flowDataSourceAdjacentAddress=flowDataSourceAdjacentAddress, flowDataSourceAdjacentMask=flowDataSourceAdjacentMask, flowDataSourcePeerType=flowDataSourcePeerType, flowDataSourcePeerAddress=flowDataSourcePeerAddress, flowDataSourcePeerMask=flowDataSourcePeerMask, flowDataSourceTransType=flowDataSourceTransType, flowDataSourceTransAddress=flowDataSourceTransAddress, flowDataSourceTransMask=flowDataSourceTransMask, flowDataDestInterface=flowDataDestInterface, flowDataDestAdjacentType=flowDataDestAdjacentType, flowDataDestAdjacentAddress=flowDataDestAdjacentAddress, flowDataDestAdjacentMask=flowDataDestAdjacentMask, flowDataDestPeerType=flowDataDestPeerType, flowDataDestPeerAddress=flowDataDestPeerAddress, flowDataDestPeerMask=flowDataDestPeerMask, flowDataDestTransType=flowDataDestTransType, flowDataDestTransAddress=flowDataDestTransAddress, flowDataDestTransMask=flowDataDestTransMask, flowDataPDUScale=flowDataPDUScale, flowDataOctetScale=flowDataOctetScale, flowDataRuleSet=flowDataRuleSet, flowDataToOctets=flowDataToOctets, flowDataToPDUs=flowDataToPDUs, flowDataFromOctets=flowDataFromOctets, flowDataFromPDUs=flowDataFromPDUs, flowDataFirstTime=flowDataFirstTime, flowDataLastActiveTime=flowDataLastActiveTime, flowDataSourceSubscriberID=flowDataSourceSubscriberID, flowDataDestSubscriberID=flowDataDestSubscriberID, flowDataSessionID=flowDataSessionID, flowDataSourceClass=flowDataSourceClass, flowDataDestClass=flowDataDestClass, flowDataClass=flowDataClass, flowDataSourceKind=flowDataSourceKind, flowDataDestKind=flowDataDestKind, flowDataKind=flowDataKind, flowColumnActivityTable=flowColumnActivityTable, flowColumnActivityEntry=flowColumnActivityEntry, flowColumnActivityAttribute=flowColumnActivityAttribute, flowColumnActivityTime=flowColumnActivityTime, flowColumnActivityIndex=flowColumnActivityIndex, flowColumnActivityData=flowColumnActivityData, flowDataPackageTable=flowDataPackageTable, flowDataPackageEntry=flowDataPackageEntry, flowPackageSelector=flowPackageSelector, flowPackageRuleSet=flowPackageRuleSet, flowPackageTime=flowPackageTime, flowPackageIndex=flowPackageIndex, flowPackageData=flowPackageData, flowRules=flowRules, flowRuleTable=flowRuleTable, flowRuleEntry=flowRuleEntry, flowRuleSet=flowRuleSet, flowRuleIndex=flowRuleIndex, flowRuleSelector=flowRuleSelector, flowRuleMask=flowRuleMask, flowRuleMatchedValue=flowRuleMatchedValue, flowRuleAction=flowRuleAction, flowRuleParameter=flowRuleParameter, flowMIBConformance=flowMIBConformance, flowMIBCompliances=flowMIBCompliances, flowMIBGroups=flowMIBGroups)

# Groups
mibBuilder.exportSymbols("FLOW-METER-MIB", flowDataScaleGroup2=flowDataScaleGroup2, flowDataScaleGroup=flowDataScaleGroup, flowControlGroup=flowControlGroup, flowRuleTableGroup=flowRuleTableGroup, flowDataColumnTableGroup=flowDataColumnTableGroup, flowDataPackageGroup=flowDataPackageGroup, flowControlGroup2=flowControlGroup2, flowDataSubscriberGroup=flowDataSubscriberGroup, flowDataTableGroup=flowDataTableGroup)
