# PySNMP SMI module. Autogenerated from smidump -f python HDSL2-SHDSL-LINE-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:22 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( PerfCurrentCount, PerfIntervalCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfCurrentCount", "PerfIntervalCount")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention")

# Types

class Hdsl2Shdsl1DayIntervalCount(TextualConvention, Gauge32):
    displayHint = "d"
    pass

class Hdsl2ShdslClockReferenceType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,4,1,)
    namedValues = namedval.NamedValues(("localClk", 1), ("networkClk", 2), ("dataOrNetworkClk", 3), ("dataClk", 4), )
    pass

class Hdsl2ShdslPerfCurrDayCount(TextualConvention, Gauge32):
    displayHint = "d"
    pass

class Hdsl2ShdslPerfIntervalThreshold(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,900)
    pass

class Hdsl2ShdslPerfTimeElapsed(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,86399)
    pass

class Hdsl2ShdslTransmissionModeType(Bits):
    namedValues = namedval.NamedValues(("region1", 0), ("region2", 1), )
    pass

class Hdsl2ShdslUnitId(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(6,9,8,3,5,4,10,2,1,7,)
    namedValues = namedval.NamedValues(("xtuC", 1), ("xru8", 10), ("xtuR", 2), ("xru1", 3), ("xru2", 4), ("xru3", 5), ("xru4", 6), ("xru5", 7), ("xru6", 8), ("xru7", 9), )
    pass

class Hdsl2ShdslUnitSide(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,)
    namedValues = namedval.NamedValues(("networkSide", 1), ("customerSide", 2), )
    pass

class Hdsl2ShdslWirePair(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,3,4,)
    namedValues = namedval.NamedValues(("wirePair1", 1), ("wirePair2", 2), ("wirePair3", 3), ("wirePair4", 4), )
    pass


# Objects

hdsl2ShdslMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 48)).setRevisions(("2005-12-07 00:00","2002-05-09 00:00",))
if mibBuilder.loadTexts: hdsl2ShdslMIB.setOrganization("ADSLMIB Working Group")
if mibBuilder.loadTexts: hdsl2ShdslMIB.setContactInfo("WG-email:  adslmib@ietf.org\nWG-URL:\n   http://www.ietf.org/html.charters/adslmib-charter.html\nInfo:       https://www1.ietf.org/mailman/listinfo/adslmib\nChair:      Mike Sneed\n            Sand Channel Systems\nPostal:     1210-203 Westview Ln\n            Raleigh NC 27605  USA\nEmail:      sneedmike@hotmail.com\nPhone:     +1 206 600 7022\n\nCo-Chair    Bob Ray\n            PESA Switching Systems, Inc.\n\n\n\nPostal      330-A Wynn Drive\n            Huntsville, AL 35805 USA\nPhone       +1 256 726 9200 ext. 142\n\nCo-editor:  Clay Sikes\n            Zhone Technologies, Inc.\nPostal:     8545 126th Ave. N.\n            Largo, FL 33772 USA\nEmail:      csikes@zhone.com\nPhone:      +1 727 530 8257\n\nCo-editor:  Bob Ray\n            PESA Switching Systems, Inc.\nPostal:     330-A Wynn Drive\n            Huntsville, AL 35805 USA\nEmail:      rray@pesa.com\nPhone:      +1 256 726 9200 ext. 142\n\nCo-editor:  Rajesh Abbi\n            Alcatel USA\nPostal:     2301 Sugar Bush Road\n            Raleigh, NC 27612-3339 USA\n\nEmail:      Rajesh.Abbi@alcatel.com\nPhone:      +1 919 850 6194")
if mibBuilder.loadTexts: hdsl2ShdslMIB.setDescription("This MIB module defines a collection of objects for managing\nHDSL2/SHDSL lines.  An agent may reside at either end of the\nline; however, the MIB module is designed to require no\nmanagement communication between the modems beyond that\ninherent in the low-level EOC line protocol as defined in\nANSI T1E1.4/2000-006 (for HDSL2 lines) or in ITU G.991.2\n(for SHDSL lines).\n\nCopyright (C) The Internet Society (2005).  This version of\nthis MIB module is part of RFC 4319; see the RFC itself for\nfull legal notices.")
hdsl2ShdslNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 48, 0))
hdsl2ShdslMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 48, 1))
hdsl2ShdslSpanConfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 1))
if mibBuilder.loadTexts: hdsl2ShdslSpanConfTable.setDescription("This table supports overall configuration of HDSL2/SHDSL\nspans.  Entries in this table MUST be maintained in a\npersistent manner.")
hdsl2ShdslSpanConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: hdsl2ShdslSpanConfEntry.setDescription("An entry in the hdsl2ShdslSpanConfTable.  Each entry\nrepresents the complete span in a single HDSL2/SHDSL line.\nIt is indexed by the ifIndex of the associated HDSL2/SHDSL\nline.")
hdsl2ShdslSpanConfNumRepeaters = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 8))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfNumRepeaters.setDescription("This object provisions the number of repeaters/regenerators\nin this HDSL2/SHDSL span.")
hdsl2ShdslSpanConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 1, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfProfile.setDescription("This object is a pointer to a span configuration profile in\nthe hdsl2ShdslSpanConfProfileTable, which applies to this\nspan.  The value of this object is the index of the referenced\nprofile in the hdsl2ShdslSpanConfProfileTable.  Note that span\nconfiguration profiles are only applicable to SHDSL lines.\n\nHDSL2 lines MUST reference the default profile, 'DEFVAL'.\nBy default, this object will have the value 'DEFVAL'\n(the index of the default profile).\n\nAny attempt to set this object to a value that is not the value\nof the index for an active entry in the profile table,\nhdsl2ShdslSpanConfProfileTable, MUST be rejected.")
hdsl2ShdslSpanConfAlarmProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 1, 1, 3), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfAlarmProfile.setDescription("This object is a pointer to an alarm configuration profile in\nthe hdsl2ShdslEndpointAlarmConfProfileTable.  The value of\nthis object is the index of the referenced profile in the\nhdsl2ShdslEndpointAlarmConfProfileTable.  The alarm\nthreshold configuration in the referenced profile will be\n\n\n\nused by default for all segment endpoints in this span.\nIndividual endpoints may override this profile by explicitly\nspecifying some other profile in the\nhdsl2ShdslEndpointConfTable.  By default, this object will\nhave the value 'DEFVAL' (the index of the default\nprofile).\n\nAny attempt to set this object to a value that is not the value\nof the index for an active entry in the profile table,\nhdsl2ShdslEndpointAlarmConfProfileTable, MUST be rejected.")
hdsl2ShdslSpanStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 2))
if mibBuilder.loadTexts: hdsl2ShdslSpanStatusTable.setDescription("This table provides overall status information of\nHDSL2/SHDSL spans.  This table contains live data from\nequipment.  As such, it is NOT persistent.")
hdsl2ShdslSpanStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: hdsl2ShdslSpanStatusEntry.setDescription("An entry in the hdsl2ShdslSpanStatusTable.  Each entry\nrepresents the complete span in a single HDSL2/SHDSL line.\nIt is indexed by the ifIndex of the associated HDSL2/SHDSL\nline.")
hdsl2ShdslStatusNumAvailRepeaters = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusNumAvailRepeaters.setDescription("Contains the actual number of repeaters/regenerators\ndiscovered in this HDSL2/SHDSL span.")
hdsl2ShdslStatusMaxAttainableLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusMaxAttainableLineRate.setDescription("Contains the maximum attainable line rate in this HDSL2/SHDSL\nspan.  This object provides the maximum rate the line is\ncapable of achieving.  This is based upon measurements made\nduring line probing.  This rate includes payload (user data)\nand any applicable framing overhead.")
hdsl2ShdslStatusActualLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusActualLineRate.setDescription("Contains the actual line rate in this HDSL2/SHDSL span.  This\nSHOULD equal ifSpeed.  This rate includes payload (user data)\nand any applicable framing overhead")
hdsl2ShdslStatusTransmissionModeCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 4), Hdsl2ShdslTransmissionModeType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusTransmissionModeCurrent.setDescription("Contains the current Power Spectral Density (PSD) regional\nsetting of the HDSL2/SHDSL span.")
hdsl2ShdslStatusMaxAttainablePayloadRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusMaxAttainablePayloadRate.setDescription("Contains the maximum attainable payload (user data)\nline rate in this HDSL2/SHDSL span.  This object provides\nthe maximum rate the line is capable of achieving.  This\nis based upon measurements made during line probing.  Any\nframing overhead is not included.")
hdsl2ShdslStatusActualPayloadRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslStatusActualPayloadRate.setDescription("Contains the actual line rate in this HDSL2/SHDSL span.  Any\nframing overhead is not included.")
hdsl2ShdslInventoryTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 3))
if mibBuilder.loadTexts: hdsl2ShdslInventoryTable.setDescription("This table supports retrieval of unit inventory information\navailable via the EOC from units in an HDSL2/SHDSL line.\n\nEntries in this table are dynamically created during the\nline discovery process.  The life cycle for these entries\nis as follows:\n\n   - xtu discovers a device, either a far-end xtu or an xru\n   - an inventory table entry is created for the device\n   - the line goes down for whatever reason\n   - inventory table entries for unreachable devices are\n     destroyed\n\nAs these entries are created/destroyed dynamically, they\nare NOT persistent.")
hdsl2ShdslInventoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"))
if mibBuilder.loadTexts: hdsl2ShdslInventoryEntry.setDescription("An entry in the hdsl2ShdslInventoryTable.  Each entry\n\n\n\nrepresents inventory information for a single unit in an\nHDSL2/SHDSL line.  It is indexed by the ifIndex of the\nHDSL2/SHDSL line and the Hdsl2ShdslUnitId of the\nassociated unit.")
hdsl2ShdslInvIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 1), Hdsl2ShdslUnitId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2ShdslInvIndex.setDescription("Each entry in this table corresponds to a physical element\nin an HDSL2/SHDSL span.  It is based on the EOC unit addressing\nscheme with reference to the xtuC.")
hdsl2ShdslInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorID.setDescription("Vendor ID as reported in an Inventory Response message.")
hdsl2ShdslInvVendorModelNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(12, 12)).setFixedLength(12)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorModelNumber.setDescription("Vendor model number as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvVendorSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(12, 12)).setFixedLength(12)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorSerialNumber.setDescription("Vendor serial number as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvVendorEOCSoftwareVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorEOCSoftwareVersion.setDescription("Vendor EOC version as reported in a Discovery Response\nmessage.")
hdsl2ShdslInvStandardVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvStandardVersion.setDescription("Version of the HDSL2/SHDSL standard implemented, as reported\nin an Inventory Response message.")
hdsl2ShdslInvVendorListNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 7), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorListNumber.setDescription("Vendor list number as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvVendorIssueNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 8), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorIssueNumber.setDescription("Vendor issue number as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvVendorSoftwareVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(6, 6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorSoftwareVersion.setDescription("Vendor software version as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvEquipmentCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 10), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(10, 10)).setFixedLength(10)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvEquipmentCode.setDescription("Equipment code conforming to ANSI T1.213, Coded Identification\nof Equipment Entities.")
hdsl2ShdslInvVendorOther = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 11), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(12, 12)).setFixedLength(12)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvVendorOther.setDescription("Other vendor information as reported in an Inventory Response\nmessage.")
hdsl2ShdslInvTransmissionModeCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 3, 1, 12), Hdsl2ShdslTransmissionModeType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslInvTransmissionModeCapability.setDescription("Contains the transmission mode capability of the SHDSL unit.")
hdsl2ShdslEndpointConfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 4))
if mibBuilder.loadTexts: hdsl2ShdslEndpointConfTable.setDescription("This table supports configuration parameters for segment\nendpoints in an HDSL2/SHDSL line.  As this table is indexed\nby ifIndex, it MUST be maintained in a persistent manner.")
hdsl2ShdslEndpointConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSide"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointWirePair"))
if mibBuilder.loadTexts: hdsl2ShdslEndpointConfEntry.setDescription("An entry in the hdsl2ShdslEndpointConfTable.  Each entry\nrepresents a single segment endpoint in an HDSL2/SHDSL line.\nIt is indexed by the ifIndex of the HDSL2/SHDSL line, the\nUnitId of the associated unit, the side of the unit, and the\nwire pair of the associated modem.")
hdsl2ShdslEndpointSide = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 4, 1, 1), Hdsl2ShdslUnitSide()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2ShdslEndpointSide.setDescription("The side of the unit associated with this segment endpoint --\nNetwork/Customer side -- as per the Hdsl2ShdslUnitSide textual\nconvention.")
hdsl2ShdslEndpointWirePair = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 4, 1, 2), Hdsl2ShdslWirePair()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2ShdslEndpointWirePair.setDescription("The wire pair of the modem associated with this segment\nendpoint as per the Hdsl2ShdslWirePair textual convention.")
hdsl2ShdslEndpointAlarmConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 4, 1, 3), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslEndpointAlarmConfProfile.setDescription("This object configures the alarm threshold values to be used\nfor this segment endpoint.  The values are obtained from the\nalarm configuration profile referenced by this object.  The\nvalue of this object is the index of the referenced profile in\nthe hdsl2ShdslEndpointAlarmConfProfileTable, or NULL (a\nzero-length SnmpAdminString).  If the value is a zero-length\nSnmpAdminString, the endpoint uses the default Alarm\nConfiguration Profile for the associated span as per the\nhdsl2ShdslSpanConfAlarmProfile object in the\nhdsl2ShdslSpanConfTable.  The default value of this object is\na zero-length SnmpAdminString.\n\nAny attempt to set this object to a value that is not the value\nof the index for an active entry in the profile table,\nhdsl2ShdslEndpointAlarmConfProfileTable, MUST be rejected.")
hdsl2ShdslEndpointCurrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 5))
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrTable.setDescription("This table contains current status and performance information\nfor segment endpoints in HDSL2/SHDSL lines.  As with other\ntables in this MIB module indexed by ifIndex, entries in this\ntable MUST be maintained in a persistent manner.")
hdsl2ShdslEndpointCurrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSide"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointWirePair"))
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrEntry.setDescription("An entry in the hdsl2ShdslEndpointCurrTable.  Each entry\ncontains status and performance information relating to a\nsingle segment endpoint.  It is indexed by the ifIndex of the\nHDSL2/SHDSL line, the UnitId of the associated unit, the side\nof the unit, and the wire pair of the associated modem.")
hdsl2ShdslEndpointCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrAtn.setDescription("The current loop attenuation for this endpoint as reported in\na Network or Customer Side Performance Status message.")
hdsl2ShdslEndpointCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrSnrMgn.setDescription("The current SNR margin for this endpoint as reported in a\nStatus Response/SNR message.")
hdsl2ShdslEndpointCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 3), Bits().subtype(namedValues=namedval.NamedValues(("noDefect", 0), ("powerBackoff", 1), ("loopbackActive", 10), ("deviceFault", 2), ("dcContinuityFault", 3), ("snrMarginAlarm", 4), ("loopAttenuationAlarm", 5), ("loswFailureAlarm", 6), ("configInitFailure", 7), ("protocolInitFailure", 8), ("noNeighborPresent", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrStatus.setDescription("Contains the current state of the endpoint.  This is a\nbit-map of possible conditions.  The various bit positions\nare as follows:\n\nnoDefect               There are no defects on the line.\n\npowerBackoff           Indicates enhanced Power Backoff.\n\ndeviceFault            Indicates that a vendor-dependent\n                       diagnostic or self-test fault\n                       has been detected.\n\ndcContinuityFault      Indicates vendor-dependent\n                       conditions that interfere with\n                       span powering such as short and\n                       open circuits.\n\nsnrMarginAlarm         Indicates that the SNR margin\n                       has dropped below the alarm threshold.\n\nloopAttenuationAlarm   Indicates that the loop attenuation\n                       exceeds the alarm threshold.\n\nloswFailureAlarm       Indicates a forward LOSW alarm.\n\nconfigInitFailure      Endpoint failure during initialization\n                       due to paired endpoint not able to\n                       support requested configuration.\n\nprotocolInitFailure    Endpoint failure during initialization\n                       due to incompatible protocol used by\n                       the paired endpoint.\n\nnoNeighborPresent      Endpoint failure during initialization\n                       due to no activation sequence detected\n                       from paired endpoint.\n\nloopbackActive         A loopback is currently active at this\n                       segment endpoint.\n\nThis is intended to supplement ifOperStatus.  Note that there\nis a 1:1 relationship between the status bits defined in this\nobject and the notification thresholds defined elsewhere in\nthis MIB module.")
hdsl2ShdslEndpointES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointES.setDescription("Count of Errored Seconds (ES) on this endpoint since the xU\nwas last restarted.")
hdsl2ShdslEndpointSES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointSES.setDescription("Count of Severely Errored Seconds (SES) on this endpoint\nsince the xU was last restarted.")
hdsl2ShdslEndpointCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCRCanomalies.setDescription("Count of CRC anomalies on this endpoint since the xU was\nlast restarted.")
hdsl2ShdslEndpointLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointLOSWS.setDescription("Count of Loss of Sync Word (LOSW) Seconds on this endpoint\nsince the xU was last restarted.")
hdsl2ShdslEndpointUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointUAS.setDescription("Count of Unavailable Seconds (UAS) on this endpoint since\nthe xU was last restarted.")
hdsl2ShdslEndpointCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 9), Hdsl2ShdslPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinTimeElapsed.setDescription("Total elapsed seconds in the current 15-minute interval.")
hdsl2ShdslEndpointCurr15MinES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinES.setDescription("Count of Errored Seconds (ES) in the current 15-minute\ninterval.")
hdsl2ShdslEndpointCurr15MinSES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinSES.setDescription("Count of Severely Errored Seconds (SES) in the current\n15-minute interval.")
hdsl2ShdslEndpointCurr15MinCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 12), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinCRCanomalies.setDescription("Count of CRC anomalies in the current 15-minute interval.")
hdsl2ShdslEndpointCurr15MinLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 13), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinLOSWS.setDescription("Count of Loss of Sync Word (LOSW) Seconds in the current\n15-minute interval.")
hdsl2ShdslEndpointCurr15MinUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 14), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr15MinUAS.setDescription("Count of Unavailable Seconds (UAS) in the current 15-minute\ninterval.")
hdsl2ShdslEndpointCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 15), Hdsl2ShdslPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the beginning of\nthe current 1-day interval.")
hdsl2ShdslEndpointCurr1DayES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 16), Hdsl2ShdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DayES.setDescription("Count of Errored Seconds (ES) during the current day as\nmeasured by hdsl2ShdslEndpointCurr1DayTimeElapsed.")
hdsl2ShdslEndpointCurr1DaySES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 17), Hdsl2ShdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DaySES.setDescription("Count of Severely Errored Seconds (SES) during the current\nday as measured by hdsl2ShdslEndpointCurr1DayTimeElapsed.")
hdsl2ShdslEndpointCurr1DayCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 18), Hdsl2ShdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DayCRCanomalies.setDescription("Count of CRC anomalies during the current day as measured\nby hdsl2ShdslEndpointCurr1DayTimeElapsed.")
hdsl2ShdslEndpointCurr1DayLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 19), Hdsl2ShdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DayLOSWS.setDescription("Count of Loss of Sync Word (LOSW) Seconds during the current\nday as measured by hdsl2ShdslEndpointCurr1DayTimeElapsed.")
hdsl2ShdslEndpointCurr1DayUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 20), Hdsl2ShdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurr1DayUAS.setDescription("Count of Unavailable Seconds (UAS) during the current day as\nmeasured by hdsl2ShdslEndpointCurr1DayTimeElapsed.")
hdsl2ShdslEndpointCurrTipRingReversal = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("normal", 1), ("reversed", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrTipRingReversal.setDescription("This object indicates the state of the tip/ring for the\nwire pair.")
hdsl2ShdslEndpointCurrActivationState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 5, 1, 22), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("preActivation", 1), ("activation", 2), ("data", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslEndpointCurrActivationState.setDescription("This object indicates the activation or training state of\nthe wire pair.")
hdsl2Shdsl15MinIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 6))
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalTable.setDescription("This table provides one row for each HDSL2/SHDSL endpoint\nperformance data collection interval.  This table contains\nlive data from equipment.  As such, it is NOT persistent.")
hdsl2Shdsl15MinIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSide"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointWirePair"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalNumber"))
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalEntry.setDescription("An entry in the hdsl2Shdsl15MinIntervalTable.")
hdsl2Shdsl15MinIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalNumber.setDescription("Performance Data Interval number.  Interval 1 is the most\nrecent previous interval; interval 96 is 24 hours ago.\nIntervals 2..96 are optional.")
hdsl2Shdsl15MinIntervalES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalES.setDescription("Count of Errored Seconds (ES) during the interval.")
hdsl2Shdsl15MinIntervalSES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalSES.setDescription("Count of Severely Errored Seconds (SES) during the interval.")
hdsl2Shdsl15MinIntervalCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalCRCanomalies.setDescription("Count of CRC anomalies during the interval.")
hdsl2Shdsl15MinIntervalLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalLOSWS.setDescription("Count of Loss of Sync Word (LOSW) Seconds during the\ninterval.")
hdsl2Shdsl15MinIntervalUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 6, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl15MinIntervalUAS.setDescription("Count of Unavailable Seconds (UAS) during the interval.")
hdsl2Shdsl1DayIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 7))
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalTable.setDescription("This table provides one row for each HDSL2/SHDSL endpoint\nperformance data collection interval.  This table contains\nlive data from equipment.  As such, it is NOT persistent.")
hdsl2Shdsl1DayIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSide"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointWirePair"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalNumber"))
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalEntry.setDescription("An entry in the hdsl2Shdsl1DayIntervalTable.")
hdsl2Shdsl1DayIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 30))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalNumber.setDescription("History Data Interval number.  Interval 1 is the most\nrecent previous day; interval 30 is 30 days ago.  Intervals\n2..30 are optional.")
hdsl2Shdsl1DayIntervalMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 2), Hdsl2ShdslPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalMoniSecs.setDescription("The amount of time in the 1-day interval over which the\nperformance monitoring information is actually counted.\nThis value will be the same as the interval duration except\nin a situation where performance monitoring data could not\nbe collected for any reason.")
hdsl2Shdsl1DayIntervalES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 3), Hdsl2Shdsl1DayIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalES.setDescription("Count of Errored Seconds (ES) during the 1-day interval as\nmeasured by hdsl2Shdsl1DayIntervalMoniSecs.")
hdsl2Shdsl1DayIntervalSES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 4), Hdsl2Shdsl1DayIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalSES.setDescription("Count of Severely Errored Seconds (SES) during the 1-day\n\n\n\ninterval as measured by hdsl2Shdsl1DayIntervalMoniSecs.")
hdsl2Shdsl1DayIntervalCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 5), Hdsl2Shdsl1DayIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalCRCanomalies.setDescription("Count of CRC anomalies during the 1-day interval as\nmeasured by hdsl2Shdsl1DayIntervalMoniSecs.")
hdsl2Shdsl1DayIntervalLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 6), Hdsl2Shdsl1DayIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalLOSWS.setDescription("Count of Loss of Sync Word (LOSW) Seconds during the 1-day\ninterval as measured by hdsl2Shdsl1DayIntervalMoniSecs.")
hdsl2Shdsl1DayIntervalUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 7, 1, 7), Hdsl2Shdsl1DayIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2Shdsl1DayIntervalUAS.setDescription("Count of Unavailable Seconds (UAS) during the 1-day interval\nas measured by hdsl2Shdsl1DayIntervalMoniSecs.")
hdsl2ShdslEndpointMaintTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 8))
if mibBuilder.loadTexts: hdsl2ShdslEndpointMaintTable.setDescription("This table supports maintenance operations (e.g., loopbacks)\nto be performed on HDSL2/SHDSL segment endpoints.  This table\ncontains live data from equipment.  As such, it is NOT\n\n\n\npersistent.")
hdsl2ShdslEndpointMaintEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 8, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSide"))
if mibBuilder.loadTexts: hdsl2ShdslEndpointMaintEntry.setDescription("An entry in the hdsl2ShdslEndpointMaintTable.  Each entry\ncorresponds to a single segment endpoint and is indexed by the\nifIndex of the HDSL2/SHDSL line, the UnitId of the associated\nunit, and the side of the unit.")
hdsl2ShdslMaintLoopbackConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 8, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("noLoopback", 1), ("normalLoopback", 2), ("specialLoopback", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslMaintLoopbackConfig.setDescription("This object controls configuration of loopbacks for the\nassociated segment endpoint.  The status of the loopback\nis obtained via the hdsl2ShdslEndpointCurrStatus object.")
hdsl2ShdslMaintTipRingReversal = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 8, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("normal", 1), ("reversed", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslMaintTipRingReversal.setDescription("This object indicates the state of the tip/ring pair at the\nassociated segment endpoint.")
hdsl2ShdslMaintPowerBackOff = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 8, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("default", 1), ("enhanced", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslMaintPowerBackOff.setDescription("This object configures the receiver at the associated\nsegment endpoint to operate in default or enhanced power\nbackoff mode.")
hdsl2ShdslMaintSoftRestart = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 8, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("ready", 1), ("restart", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslMaintSoftRestart.setDescription("This object enables the manager to trigger a soft restart\nof the modem at the associated segment endpoint.  The\nmanager may only set this object to the 'restart(2)'\nvalue, which initiates a restart.  The agent will perform a\nrestart after approximately 5 seconds.  Following the 5 second\nperiod, the agent will restore the object to the 'ready(1)'\nstate.")
hdsl2ShdslUnitMaintTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 9))
if mibBuilder.loadTexts: hdsl2ShdslUnitMaintTable.setDescription("This table supports maintenance operations for units in a\nHDSL2/SHDSL line.  Entries in this table MUST be maintained\nin a persistent manner.")
hdsl2ShdslUnitMaintEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 9, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvIndex"))
if mibBuilder.loadTexts: hdsl2ShdslUnitMaintEntry.setDescription("An entry in the hdsl2ShdslUnitMaintTable.  Each entry\ncorresponds to a single unit and is indexed by the\nifIndex of the HDSL2/SHDSL line and the UnitId of the\nassociated unit.")
hdsl2ShdslMaintLoopbackTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 9, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hdsl2ShdslMaintLoopbackTimeout.setDescription("This object configures the timeout value for loopbacks\ninitiated at segments endpoints contained in the associated\nunit.  A value of 0 disables the timeout.")
hdsl2ShdslMaintUnitPowerSource = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 9, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("local", 1), ("span", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hdsl2ShdslMaintUnitPowerSource.setDescription("This object indicates the DC power source being used by the\nassociated unit.")
hdsl2ShdslSpanConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 10))
if mibBuilder.loadTexts: hdsl2ShdslSpanConfProfileTable.setDescription("This table supports definitions of span configuration\nprofiles for SHDSL lines.  HDSL2 does not support these\nconfiguration options.  This table MUST be maintained\nin a persistent manner.")
hdsl2ShdslSpanConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1)).setIndexNames((1, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfProfileName"))
if mibBuilder.loadTexts: hdsl2ShdslSpanConfProfileEntry.setDescription("Each entry corresponds to a single span configuration\nprofile.  Each profile contains a set of span configuration\nparameters.  The configuration parameters in a profile are\napplied to those lines referencing that profile (see the\nhdsl2ShdslSpanConfProfile object).  Profiles may be\ncreated/deleted using the row creation/deletion mechanism\nvia hdsl2ShdslSpanConfProfileRowStatus.  If an active\nentry is referenced in hdsl2ShdslSpanConfProfile, the\nentry MUST remain active until all references are removed.")
hdsl2ShdslSpanConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfProfileName.setDescription("This object is the unique index associated with this profile.\nEntries in this table are referenced via the object\nhdsl2ShdslSpanConfProfile in Hdsl2ShdslSpanConfEntry.")
hdsl2ShdslSpanConfWireInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("twoWire", 1), ("fourWire", 2), ("sixWire", 3), ("eightWire", 4), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfWireInterface.setDescription("This object configures the two-wire or optional four-wire,\nsix-wire, or eight-wire operation for SHDSL lines.")
hdsl2ShdslSpanConfMinLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L)).clone(1552000)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfMinLineRate.setDescription("This object configures the minimum transmission rate for\nthe associated SHDSL Line in bits-per-second (bps) and includes\nboth payload (user data) and any applicable framing overhead.\nIf the minimum line rate equals the maximum line rate\n(hdsl2ShdslSpanMaxLineRate), the line rate is considered\n'fixed'.  If the minimum line rate is less than the\nmaximum line rate, the line rate is considered\n'rate-adaptive'.")
hdsl2ShdslSpanConfMaxLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L)).clone(1552000)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfMaxLineRate.setDescription("This object configures the maximum transmission rate for\nthe associated SHDSL Line in bits-per-second (bps) and includes\nboth payload (user data) and any applicable framing overhead.\nIf the minimum line rate equals the maximum line rate\n(hdsl2ShdslSpanMaxLineRate), the line rate is considered\n'fixed'.  If the minimum line rate is less than the\nmaximum line rate, the line rate is considered\n'rate-adaptive'.")
hdsl2ShdslSpanConfPSD = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("symmetric", 1), ("asymmetric", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfPSD.setDescription("This object configures use of symmetric/asymmetric PSD (Power\nSpectral Density) Mask for the associated SHDSL Line.  Support\nfor symmetric PSD is mandatory for all supported data rates.\nSupport for asymmetric PSD is optional.")
hdsl2ShdslSpanConfTransmissionMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 6), Hdsl2ShdslTransmissionModeType().clone('(region1)')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfTransmissionMode.setDescription("This object specifies the regional setting for the SHDSL\nline.")
hdsl2ShdslSpanConfRemoteEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfRemoteEnabled.setDescription("This object enables/disables support for remote management\nof the units in an SHDSL line from the STU-R via the EOC.")
hdsl2ShdslSpanConfPowerFeeding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("noPower", 1), ("powerFeed", 2), ("wettingCurrent", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfPowerFeeding.setDescription("This object enables/disables support for optional power\nfeeding in an SHDSL line.")
hdsl2ShdslSpanConfCurrCondTargetMarginDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-10, 21)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfCurrCondTargetMarginDown.setDescription("This object specifies the downstream current condition target\nSNR margin for an SHDSL line.  The SNR margin is the difference\nbetween the desired SNR and the actual SNR.  Target SNR margin\nis the desired SNR margin for a unit.")
hdsl2ShdslSpanConfWorstCaseTargetMarginDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-10, 21)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfWorstCaseTargetMarginDown.setDescription("This object specifies the downstream worst-case target SNR\nmargin for an SHDSL line.  The SNR margin is the difference\nbetween the desired SNR and the actual SNR.  Target SNR\nmargin is the desired SNR margin for a unit.")
hdsl2ShdslSpanConfCurrCondTargetMarginUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-10, 21)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfCurrCondTargetMarginUp.setDescription("This object specifies the upstream current-condition target\nSNR margin for an SHDSL line.  The SNR margin is the difference\nbetween the desired SNR and the actual SNR.  Target SNR margin\nis the desired SNR margin for a unit.")
hdsl2ShdslSpanConfWorstCaseTargetMarginUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-10, 21)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfWorstCaseTargetMarginUp.setDescription("This object specifies the upstream worst-case target SNR\nmargin for an SHDSL line.  The SNR margin is the difference\nbetween the desired SNR and the actual SNR.  Target SNR margin\nis the desired SNR margin for a unit.")
hdsl2ShdslSpanConfUsedTargetMargins = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 13), Bits().subtype(namedValues=namedval.NamedValues(("currCondDown", 0), ("worstCaseDown", 1), ("currCondUp", 2), ("worstCaseUp", 3), )).clone(("currCondDown",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfUsedTargetMargins.setDescription("Indicates whether a target SNR margin is enabled or\ndisabled.  This is a bit-map of possible settings.  The\nvarious bit positions are as follows:\n\ncurrCondDown   - current-condition downstream target SNR\n                 margin enabled\n\nworstCaseDown  - worst-case downstream target SNR margin\n                 enabled\n\ncurrCondUp     - current-condition upstream target SNR\n                 margin enabled\n\nworstCaseUp    - worst-case upstream target SNR margin\n                 enabled.")
hdsl2ShdslSpanConfReferenceClock = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 14), Hdsl2ShdslClockReferenceType().clone('localClk')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfReferenceClock.setDescription("This object configures the clock reference for the STU-C\nin an SHDSL Line.")
hdsl2ShdslSpanConfLineProbeEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 15), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("disable", 1), ("enable", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfLineProbeEnable.setDescription("This object enables/disables support for Line Probe of\nthe units in an SHDSL line.  When Line Probe is enabled, the\nsystem performs Line Probing to find the best possible\nrate.  If Line Probe is disabled, the rate adaptation phase\nis skipped to shorten set up time.")
hdsl2ShdslSpanConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 10, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslSpanConfProfileRowStatus.setDescription("This object controls creation/deletion of the associated\nentry in this table per the semantics of RowStatus.  If an\nactive entry is referenced in hdsl2ShdslSpanConfProfile, the\nentry MUST remain active until all references are removed.")
hdsl2ShdslEndpointAlarmConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 48, 1, 11))
if mibBuilder.loadTexts: hdsl2ShdslEndpointAlarmConfProfileTable.setDescription("This table supports definitions of alarm configuration\nprofiles for HDSL2/SHDSL segment endpoints.  This table\nMUST be maintained in a persistent manner.")
hdsl2ShdslEndpointAlarmConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1)).setIndexNames((1, "HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointAlarmConfProfileName"))
if mibBuilder.loadTexts: hdsl2ShdslEndpointAlarmConfProfileEntry.setDescription("Each entry corresponds to a single alarm configuration profile.\nEach profile contains a set of parameters for setting alarm\nthresholds for various performance attributes monitored at\nHDSL2/SHDSL segment endpoints.  Profiles may be created/deleted\nusing the row creation/deletion mechanism via\nhdsl2ShdslEndpointAlarmConfProfileRowStatus.  If an active\nentry is referenced in either hdsl2ShdslSpanConfAlarmProfile\nor hdsl2ShdslEndpointAlarmConfProfile, the entry MUST remain\nactive until all references are removed.")
hdsl2ShdslEndpointAlarmConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hdsl2ShdslEndpointAlarmConfProfileName.setDescription("This object is the unique index associated with this profile.")
hdsl2ShdslEndpointThreshLoopAttenuation = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshLoopAttenuation.setDescription("This object configures the loop attenuation alarm threshold.\nWhen the current value of hdsl2ShdslEndpointCurrAtn reaches\nor exceeds this threshold, an hdsl2ShdslLoopAttenCrossing\nMAY be generated.")
hdsl2ShdslEndpointThreshSNRMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshSNRMargin.setDescription("This object configures the SNR margin alarm threshold.\nWhen the current value of hdsl2ShdslEndpointCurrSnrMgn\nreaches or drops below this threshold, a\nhdsl2ShdslSNRMarginCrossing MAY be generated.")
hdsl2ShdslEndpointThreshES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 4), Hdsl2ShdslPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshES.setDescription("This object configures the threshold for the number of\nErrored Seconds (ES) within any given 15-minute performance\ndata collection interval.  If the value of Errored Seconds\nin a particular 15-minute collection interval reaches/\nexceeds this value, an hdsl2ShdslPerfESThresh MAY be\ngenerated.  At most, one notification will be sent per\ninterval per endpoint.")
hdsl2ShdslEndpointThreshSES = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 5), Hdsl2ShdslPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshSES.setDescription("This object configures the threshold for the number of\nSeverely Errored Seconds (SES) within any given 15-minute\nperformance data collection interval.  If the value of\nSeverely Errored Seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, an hdsl2ShdslPerfSESThresh\nMAY be generated.  At most, one notification will be sent per\ninterval per endpoint.")
hdsl2ShdslEndpointThreshCRCanomalies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 6), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshCRCanomalies.setDescription("This object configures the threshold for the number of\nCRC anomalies within any given 15-minute performance data\ncollection interval.  If the value of CRC anomalies in a\nparticular 15-minute collection interval reaches/exceeds\nthis value, an hdsl2ShdslPerfCRCanomaliesThresh MAY be\ngenerated.  At most, one notification will be sent per\ninterval per endpoint.")
hdsl2ShdslEndpointThreshLOSWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 7), Hdsl2ShdslPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshLOSWS.setDescription("This object configures the threshold for the number of\nLoss of Sync Word (LOSW) Seconds within any given 15-minute\nperformance data collection interval.  If the value of LOSW\nin a particular 15-minute collection interval reaches/exceeds\nthis value, an hdsl2ShdslPerfLOSWSThresh MAY be generated.\nAt most, one notification will be sent per interval per\nendpoint.")
hdsl2ShdslEndpointThreshUAS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 8), Hdsl2ShdslPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointThreshUAS.setDescription("This object configures the threshold for the number of\nUnavailable Seconds (UAS) within any given 15-minute\nperformance data collection interval.  If the value of UAS\nin a particular 15-minute collection interval reaches/exceeds\nthis value, an hdsl2ShdslPerfUASThresh MAY be generated.\nAt most, one notification will be sent per interval per\nendpoint.")
hdsl2ShdslEndpointAlarmConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 48, 1, 11, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hdsl2ShdslEndpointAlarmConfProfileRowStatus.setDescription("This object controls creation/deletion of the associated\nentry in this table as per the semantics of RowStatus.\nIf an active entry is referenced in either\nhdsl2ShdslSpanConfAlarmProfile or\nhdsl2ShdslEndpointAlarmConfProfile, the entry MUST remain\nactive until all references are removed.")
hdsl2ShdslConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 48, 3))
hdsl2ShdslGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 48, 3, 1))
hdsl2ShdslCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 48, 3, 2))

# Augmentions

# Notifications

hdsl2ShdslpowerBackoff = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 10)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdslPerfCRCanomaliesThresh = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 5)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinCRCanomalies"), )
hdsl2ShdslnoNeighborPresent = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 15)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdslLoopAttenCrossing = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 1)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrAtn"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshLoopAttenuation"), )
hdsl2ShdslconfigInitFailure = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 13)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdsldeviceFault = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 11)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdslprotocolInitFailure = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 14)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdslPerfESThresh = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 3)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshES"), )
hdsl2ShdslLoopbackFailure = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 9)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintLoopbackConfig"), )
hdsl2ShdsldcContinuityFault = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 12)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), )
hdsl2ShdslSpanInvalidNumRepeaters = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 8)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfNumRepeaters"), )
hdsl2ShdslLocalPowerLoss = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 16)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorID"), )
hdsl2ShdslSNRMarginCrossing = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 2)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrSnrMgn"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshSNRMargin"), )
hdsl2ShdslPerfSESThresh = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 4)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinSES"), )
hdsl2ShdslPerfUASThresh = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 7)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinUAS"), )
hdsl2ShdslPerfLOSWSThresh = NotificationType((1, 3, 6, 1, 2, 1, 10, 48, 0, 6)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshLOSWS"), )

# Groups

hdsl2Shdsl15MinIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 8)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl15MinIntervalES"), )
hdsl2ShdslWirePairGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 14)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrTipRingReversal"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrActivationState"), )
hdsl2ShdslSpanShdslStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 4)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusActualLineRate"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusMaxAttainableLineRate"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusTransmissionModeCurrent"), )
hdsl2ShdslEndpointConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 6)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrAtn"), )
hdsl2ShdslSpanConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 1)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfNumRepeaters"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfAlarmProfile"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfProfile"), )
hdsl2ShdslEndpointCurrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 7)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrSnrMgn"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinTimeElapsed"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DayUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DaySES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DayLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrAtn"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DayES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DayTimeElapsed"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurrStatus"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr1DayCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointCurr15MinUAS"), )
hdsl2ShdslInventoryShdslGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 3)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvTransmissionModeCapability"), )
hdsl2ShdslSpanStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 2)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusNumAvailRepeaters"), )
hdsl2ShdslInventoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 5)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorSerialNumber"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvStandardVersion"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorOther"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorSoftwareVersion"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorIssueNumber"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorModelNumber"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorID"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorListNumber"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvVendorEOCSoftwareVersion"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslInvEquipmentCode"), )
hdsl2ShdslMaintenanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 10)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintPowerBackOff"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintLoopbackTimeout"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintUnitPowerSource"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintSoftRestart"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintTipRingReversal"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslMaintLoopbackConfig"), )
hdsl2ShdslSpanConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 13)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfLineProbeEnable"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfUsedTargetMargins"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfPowerFeeding"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfWireInterface"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfWorstCaseTargetMarginUp"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfReferenceClock"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfRemoteEnabled"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfMinLineRate"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfCurrCondTargetMarginUp"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfTransmissionMode"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfPSD"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfMaxLineRate"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfCurrCondTargetMarginDown"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfProfileRowStatus"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanConfWorstCaseTargetMarginDown"), )
hdsl2ShdslEndpointAlarmConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 11)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshSNRMargin"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointAlarmConfProfileRowStatus"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointAlarmConfProfile"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslEndpointThreshLoopAttenuation"), )
hdsl2ShdslPayloadRateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 15)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusMaxAttainablePayloadRate"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslStatusActualPayloadRate"), )
hdsl2ShdslNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 12)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslpowerBackoff"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslPerfCRCanomaliesThresh"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslnoNeighborPresent"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslLoopAttenCrossing"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslconfigInitFailure"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdsldeviceFault"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslprotocolInitFailure"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslPerfESThresh"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslLoopbackFailure"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdsldcContinuityFault"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSpanInvalidNumRepeaters"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslLocalPowerLoss"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslSNRMarginCrossing"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslPerfSESThresh"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslPerfUASThresh"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2ShdslPerfLOSWSThresh"), )
hdsl2Shdsl1DayIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 48, 3, 1, 9)).setObjects(("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalCRCanomalies"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalUAS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalSES"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalMoniSecs"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalLOSWS"), ("HDSL2-SHDSL-LINE-MIB", "hdsl2Shdsl1DayIntervalES"), )

# Exports

# Module identity
mibBuilder.exportSymbols("HDSL2-SHDSL-LINE-MIB", PYSNMP_MODULE_ID=hdsl2ShdslMIB)

# Types
mibBuilder.exportSymbols("HDSL2-SHDSL-LINE-MIB", Hdsl2Shdsl1DayIntervalCount=Hdsl2Shdsl1DayIntervalCount, Hdsl2ShdslClockReferenceType=Hdsl2ShdslClockReferenceType, Hdsl2ShdslPerfCurrDayCount=Hdsl2ShdslPerfCurrDayCount, Hdsl2ShdslPerfIntervalThreshold=Hdsl2ShdslPerfIntervalThreshold, Hdsl2ShdslPerfTimeElapsed=Hdsl2ShdslPerfTimeElapsed, Hdsl2ShdslTransmissionModeType=Hdsl2ShdslTransmissionModeType, Hdsl2ShdslUnitId=Hdsl2ShdslUnitId, Hdsl2ShdslUnitSide=Hdsl2ShdslUnitSide, Hdsl2ShdslWirePair=Hdsl2ShdslWirePair)

# Objects
mibBuilder.exportSymbols("HDSL2-SHDSL-LINE-MIB", hdsl2ShdslMIB=hdsl2ShdslMIB, hdsl2ShdslNotifications=hdsl2ShdslNotifications, hdsl2ShdslMibObjects=hdsl2ShdslMibObjects, hdsl2ShdslSpanConfTable=hdsl2ShdslSpanConfTable, hdsl2ShdslSpanConfEntry=hdsl2ShdslSpanConfEntry, hdsl2ShdslSpanConfNumRepeaters=hdsl2ShdslSpanConfNumRepeaters, hdsl2ShdslSpanConfProfile=hdsl2ShdslSpanConfProfile, hdsl2ShdslSpanConfAlarmProfile=hdsl2ShdslSpanConfAlarmProfile, hdsl2ShdslSpanStatusTable=hdsl2ShdslSpanStatusTable, hdsl2ShdslSpanStatusEntry=hdsl2ShdslSpanStatusEntry, hdsl2ShdslStatusNumAvailRepeaters=hdsl2ShdslStatusNumAvailRepeaters, hdsl2ShdslStatusMaxAttainableLineRate=hdsl2ShdslStatusMaxAttainableLineRate, hdsl2ShdslStatusActualLineRate=hdsl2ShdslStatusActualLineRate, hdsl2ShdslStatusTransmissionModeCurrent=hdsl2ShdslStatusTransmissionModeCurrent, hdsl2ShdslStatusMaxAttainablePayloadRate=hdsl2ShdslStatusMaxAttainablePayloadRate, hdsl2ShdslStatusActualPayloadRate=hdsl2ShdslStatusActualPayloadRate, hdsl2ShdslInventoryTable=hdsl2ShdslInventoryTable, hdsl2ShdslInventoryEntry=hdsl2ShdslInventoryEntry, hdsl2ShdslInvIndex=hdsl2ShdslInvIndex, hdsl2ShdslInvVendorID=hdsl2ShdslInvVendorID, hdsl2ShdslInvVendorModelNumber=hdsl2ShdslInvVendorModelNumber, hdsl2ShdslInvVendorSerialNumber=hdsl2ShdslInvVendorSerialNumber, hdsl2ShdslInvVendorEOCSoftwareVersion=hdsl2ShdslInvVendorEOCSoftwareVersion, hdsl2ShdslInvStandardVersion=hdsl2ShdslInvStandardVersion, hdsl2ShdslInvVendorListNumber=hdsl2ShdslInvVendorListNumber, hdsl2ShdslInvVendorIssueNumber=hdsl2ShdslInvVendorIssueNumber, hdsl2ShdslInvVendorSoftwareVersion=hdsl2ShdslInvVendorSoftwareVersion, hdsl2ShdslInvEquipmentCode=hdsl2ShdslInvEquipmentCode, hdsl2ShdslInvVendorOther=hdsl2ShdslInvVendorOther, hdsl2ShdslInvTransmissionModeCapability=hdsl2ShdslInvTransmissionModeCapability, hdsl2ShdslEndpointConfTable=hdsl2ShdslEndpointConfTable, hdsl2ShdslEndpointConfEntry=hdsl2ShdslEndpointConfEntry, hdsl2ShdslEndpointSide=hdsl2ShdslEndpointSide, hdsl2ShdslEndpointWirePair=hdsl2ShdslEndpointWirePair, hdsl2ShdslEndpointAlarmConfProfile=hdsl2ShdslEndpointAlarmConfProfile, hdsl2ShdslEndpointCurrTable=hdsl2ShdslEndpointCurrTable, hdsl2ShdslEndpointCurrEntry=hdsl2ShdslEndpointCurrEntry, hdsl2ShdslEndpointCurrAtn=hdsl2ShdslEndpointCurrAtn, hdsl2ShdslEndpointCurrSnrMgn=hdsl2ShdslEndpointCurrSnrMgn, hdsl2ShdslEndpointCurrStatus=hdsl2ShdslEndpointCurrStatus, hdsl2ShdslEndpointES=hdsl2ShdslEndpointES, hdsl2ShdslEndpointSES=hdsl2ShdslEndpointSES, hdsl2ShdslEndpointCRCanomalies=hdsl2ShdslEndpointCRCanomalies, hdsl2ShdslEndpointLOSWS=hdsl2ShdslEndpointLOSWS, hdsl2ShdslEndpointUAS=hdsl2ShdslEndpointUAS, hdsl2ShdslEndpointCurr15MinTimeElapsed=hdsl2ShdslEndpointCurr15MinTimeElapsed, hdsl2ShdslEndpointCurr15MinES=hdsl2ShdslEndpointCurr15MinES, hdsl2ShdslEndpointCurr15MinSES=hdsl2ShdslEndpointCurr15MinSES, hdsl2ShdslEndpointCurr15MinCRCanomalies=hdsl2ShdslEndpointCurr15MinCRCanomalies, hdsl2ShdslEndpointCurr15MinLOSWS=hdsl2ShdslEndpointCurr15MinLOSWS, hdsl2ShdslEndpointCurr15MinUAS=hdsl2ShdslEndpointCurr15MinUAS, hdsl2ShdslEndpointCurr1DayTimeElapsed=hdsl2ShdslEndpointCurr1DayTimeElapsed, hdsl2ShdslEndpointCurr1DayES=hdsl2ShdslEndpointCurr1DayES, hdsl2ShdslEndpointCurr1DaySES=hdsl2ShdslEndpointCurr1DaySES, hdsl2ShdslEndpointCurr1DayCRCanomalies=hdsl2ShdslEndpointCurr1DayCRCanomalies, hdsl2ShdslEndpointCurr1DayLOSWS=hdsl2ShdslEndpointCurr1DayLOSWS, hdsl2ShdslEndpointCurr1DayUAS=hdsl2ShdslEndpointCurr1DayUAS, hdsl2ShdslEndpointCurrTipRingReversal=hdsl2ShdslEndpointCurrTipRingReversal, hdsl2ShdslEndpointCurrActivationState=hdsl2ShdslEndpointCurrActivationState, hdsl2Shdsl15MinIntervalTable=hdsl2Shdsl15MinIntervalTable, hdsl2Shdsl15MinIntervalEntry=hdsl2Shdsl15MinIntervalEntry, hdsl2Shdsl15MinIntervalNumber=hdsl2Shdsl15MinIntervalNumber, hdsl2Shdsl15MinIntervalES=hdsl2Shdsl15MinIntervalES, hdsl2Shdsl15MinIntervalSES=hdsl2Shdsl15MinIntervalSES, hdsl2Shdsl15MinIntervalCRCanomalies=hdsl2Shdsl15MinIntervalCRCanomalies, hdsl2Shdsl15MinIntervalLOSWS=hdsl2Shdsl15MinIntervalLOSWS, hdsl2Shdsl15MinIntervalUAS=hdsl2Shdsl15MinIntervalUAS, hdsl2Shdsl1DayIntervalTable=hdsl2Shdsl1DayIntervalTable, hdsl2Shdsl1DayIntervalEntry=hdsl2Shdsl1DayIntervalEntry, hdsl2Shdsl1DayIntervalNumber=hdsl2Shdsl1DayIntervalNumber, hdsl2Shdsl1DayIntervalMoniSecs=hdsl2Shdsl1DayIntervalMoniSecs, hdsl2Shdsl1DayIntervalES=hdsl2Shdsl1DayIntervalES, hdsl2Shdsl1DayIntervalSES=hdsl2Shdsl1DayIntervalSES, hdsl2Shdsl1DayIntervalCRCanomalies=hdsl2Shdsl1DayIntervalCRCanomalies, hdsl2Shdsl1DayIntervalLOSWS=hdsl2Shdsl1DayIntervalLOSWS, hdsl2Shdsl1DayIntervalUAS=hdsl2Shdsl1DayIntervalUAS, hdsl2ShdslEndpointMaintTable=hdsl2ShdslEndpointMaintTable, hdsl2ShdslEndpointMaintEntry=hdsl2ShdslEndpointMaintEntry, hdsl2ShdslMaintLoopbackConfig=hdsl2ShdslMaintLoopbackConfig, hdsl2ShdslMaintTipRingReversal=hdsl2ShdslMaintTipRingReversal, hdsl2ShdslMaintPowerBackOff=hdsl2ShdslMaintPowerBackOff, hdsl2ShdslMaintSoftRestart=hdsl2ShdslMaintSoftRestart, hdsl2ShdslUnitMaintTable=hdsl2ShdslUnitMaintTable, hdsl2ShdslUnitMaintEntry=hdsl2ShdslUnitMaintEntry, hdsl2ShdslMaintLoopbackTimeout=hdsl2ShdslMaintLoopbackTimeout, hdsl2ShdslMaintUnitPowerSource=hdsl2ShdslMaintUnitPowerSource, hdsl2ShdslSpanConfProfileTable=hdsl2ShdslSpanConfProfileTable, hdsl2ShdslSpanConfProfileEntry=hdsl2ShdslSpanConfProfileEntry, hdsl2ShdslSpanConfProfileName=hdsl2ShdslSpanConfProfileName, hdsl2ShdslSpanConfWireInterface=hdsl2ShdslSpanConfWireInterface, hdsl2ShdslSpanConfMinLineRate=hdsl2ShdslSpanConfMinLineRate, hdsl2ShdslSpanConfMaxLineRate=hdsl2ShdslSpanConfMaxLineRate, hdsl2ShdslSpanConfPSD=hdsl2ShdslSpanConfPSD, hdsl2ShdslSpanConfTransmissionMode=hdsl2ShdslSpanConfTransmissionMode, hdsl2ShdslSpanConfRemoteEnabled=hdsl2ShdslSpanConfRemoteEnabled, hdsl2ShdslSpanConfPowerFeeding=hdsl2ShdslSpanConfPowerFeeding, hdsl2ShdslSpanConfCurrCondTargetMarginDown=hdsl2ShdslSpanConfCurrCondTargetMarginDown, hdsl2ShdslSpanConfWorstCaseTargetMarginDown=hdsl2ShdslSpanConfWorstCaseTargetMarginDown, hdsl2ShdslSpanConfCurrCondTargetMarginUp=hdsl2ShdslSpanConfCurrCondTargetMarginUp, hdsl2ShdslSpanConfWorstCaseTargetMarginUp=hdsl2ShdslSpanConfWorstCaseTargetMarginUp, hdsl2ShdslSpanConfUsedTargetMargins=hdsl2ShdslSpanConfUsedTargetMargins, hdsl2ShdslSpanConfReferenceClock=hdsl2ShdslSpanConfReferenceClock, hdsl2ShdslSpanConfLineProbeEnable=hdsl2ShdslSpanConfLineProbeEnable, hdsl2ShdslSpanConfProfileRowStatus=hdsl2ShdslSpanConfProfileRowStatus, hdsl2ShdslEndpointAlarmConfProfileTable=hdsl2ShdslEndpointAlarmConfProfileTable, hdsl2ShdslEndpointAlarmConfProfileEntry=hdsl2ShdslEndpointAlarmConfProfileEntry, hdsl2ShdslEndpointAlarmConfProfileName=hdsl2ShdslEndpointAlarmConfProfileName, hdsl2ShdslEndpointThreshLoopAttenuation=hdsl2ShdslEndpointThreshLoopAttenuation, hdsl2ShdslEndpointThreshSNRMargin=hdsl2ShdslEndpointThreshSNRMargin, hdsl2ShdslEndpointThreshES=hdsl2ShdslEndpointThreshES, hdsl2ShdslEndpointThreshSES=hdsl2ShdslEndpointThreshSES, hdsl2ShdslEndpointThreshCRCanomalies=hdsl2ShdslEndpointThreshCRCanomalies, hdsl2ShdslEndpointThreshLOSWS=hdsl2ShdslEndpointThreshLOSWS, hdsl2ShdslEndpointThreshUAS=hdsl2ShdslEndpointThreshUAS, hdsl2ShdslEndpointAlarmConfProfileRowStatus=hdsl2ShdslEndpointAlarmConfProfileRowStatus, hdsl2ShdslConformance=hdsl2ShdslConformance, hdsl2ShdslGroups=hdsl2ShdslGroups, hdsl2ShdslCompliances=hdsl2ShdslCompliances)

# Notifications
mibBuilder.exportSymbols("HDSL2-SHDSL-LINE-MIB", hdsl2ShdslpowerBackoff=hdsl2ShdslpowerBackoff, hdsl2ShdslPerfCRCanomaliesThresh=hdsl2ShdslPerfCRCanomaliesThresh, hdsl2ShdslnoNeighborPresent=hdsl2ShdslnoNeighborPresent, hdsl2ShdslLoopAttenCrossing=hdsl2ShdslLoopAttenCrossing, hdsl2ShdslconfigInitFailure=hdsl2ShdslconfigInitFailure, hdsl2ShdsldeviceFault=hdsl2ShdsldeviceFault, hdsl2ShdslprotocolInitFailure=hdsl2ShdslprotocolInitFailure, hdsl2ShdslPerfESThresh=hdsl2ShdslPerfESThresh, hdsl2ShdslLoopbackFailure=hdsl2ShdslLoopbackFailure, hdsl2ShdsldcContinuityFault=hdsl2ShdsldcContinuityFault, hdsl2ShdslSpanInvalidNumRepeaters=hdsl2ShdslSpanInvalidNumRepeaters, hdsl2ShdslLocalPowerLoss=hdsl2ShdslLocalPowerLoss, hdsl2ShdslSNRMarginCrossing=hdsl2ShdslSNRMarginCrossing, hdsl2ShdslPerfSESThresh=hdsl2ShdslPerfSESThresh, hdsl2ShdslPerfUASThresh=hdsl2ShdslPerfUASThresh, hdsl2ShdslPerfLOSWSThresh=hdsl2ShdslPerfLOSWSThresh)

# Groups
mibBuilder.exportSymbols("HDSL2-SHDSL-LINE-MIB", hdsl2Shdsl15MinIntervalGroup=hdsl2Shdsl15MinIntervalGroup, hdsl2ShdslWirePairGroup=hdsl2ShdslWirePairGroup, hdsl2ShdslSpanShdslStatusGroup=hdsl2ShdslSpanShdslStatusGroup, hdsl2ShdslEndpointConfGroup=hdsl2ShdslEndpointConfGroup, hdsl2ShdslSpanConfGroup=hdsl2ShdslSpanConfGroup, hdsl2ShdslEndpointCurrGroup=hdsl2ShdslEndpointCurrGroup, hdsl2ShdslInventoryShdslGroup=hdsl2ShdslInventoryShdslGroup, hdsl2ShdslSpanStatusGroup=hdsl2ShdslSpanStatusGroup, hdsl2ShdslInventoryGroup=hdsl2ShdslInventoryGroup, hdsl2ShdslMaintenanceGroup=hdsl2ShdslMaintenanceGroup, hdsl2ShdslSpanConfProfileGroup=hdsl2ShdslSpanConfProfileGroup, hdsl2ShdslEndpointAlarmConfGroup=hdsl2ShdslEndpointAlarmConfGroup, hdsl2ShdslPayloadRateGroup=hdsl2ShdslPayloadRateGroup, hdsl2ShdslNotificationGroup=hdsl2ShdslNotificationGroup, hdsl2Shdsl1DayIntervalGroup=hdsl2Shdsl1DayIntervalGroup)
