# PySNMP SMI module. Autogenerated from smidump -f python IF-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:24 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( snmpTraps, ) = mibBuilder.importSymbols("SNMPv2-MIB", "snmpTraps")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( AutonomousType, DisplayString, PhysAddress, RowStatus, TextualConvention, TestAndIncr, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "DisplayString", "PhysAddress", "RowStatus", "TextualConvention", "TestAndIncr", "TimeStamp", "TruthValue")

# Types

class InterfaceIndex(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,2147483647L)
    pass

class InterfaceIndexOrZero(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class OwnerString(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,255)
    pass


# Objects

interfaces = MibIdentifier((1, 3, 6, 1, 2, 1, 2))
ifNumber = MibScalar((1, 3, 6, 1, 2, 1, 2, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifNumber.setDescription("The number of network interfaces (regardless of their\ncurrent state) present on this system.")
ifTable = MibTable((1, 3, 6, 1, 2, 1, 2, 2))
if mibBuilder.loadTexts: ifTable.setDescription("A list of interface entries.  The number of entries is\ngiven by the value of ifNumber.")
ifEntry = MibTableRow((1, 3, 6, 1, 2, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: ifEntry.setDescription("An entry containing management information applicable to a\nparticular interface.")
ifIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifIndex.setDescription("A unique value, greater than zero, for each interface.  It\nis recommended that values are assigned contiguously\nstarting from 1.  The value for each interface sub-layer\nmust remain constant at least from one re-initialization of\nthe entity's network management system to the next re-\ninitialization.")
ifDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifDescr.setDescription("A textual string containing information about the\ninterface.  This string should include the name of the\nmanufacturer, the product name and the version of the\ninterface hardware/software.")
ifType = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 3), IANAifType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifType.setDescription("The type of interface.  Additional values for ifType are\nassigned by the Internet Assigned Numbers Authority (IANA),\nthrough updating the syntax of the IANAifType textual\nconvention.")
ifMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMtu.setDescription("The size of the largest packet which can be sent/received\non the interface, specified in octets.  For interfaces that\nare used for transmitting network datagrams, this is the\nsize of the largest network datagram that can be sent on the\ninterface.")
ifSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpeed.setDescription("An estimate of the interface's current bandwidth in bits\nper second.  For interfaces which do not vary in bandwidth\nor for those where no accurate estimation can be made, this\nobject should contain the nominal bandwidth.  If the\nbandwidth of the interface is greater than the maximum value\nreportable by this object then this object should report its\nmaximum value (4,294,967,295) and ifHighSpeed must be used\nto report the interace's speed.  For a sub-layer which has\nno concept of bandwidth, this object should be zero.")
ifPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 6), PhysAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifPhysAddress.setDescription("The interface's address at its protocol sub-layer.  For\nexample, for an 802.x interface, this object normally\ncontains a MAC address.  The interface's media-specific MIB\nmust define the bit and byte ordering and the format of the\nvalue of this object.  For interfaces which do not have such\nan address (e.g., a serial line), this object should contain\nan octet string of zero length.")
ifAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("testing", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifAdminStatus.setDescription("The desired state of the interface.  The testing(3) state\nindicates that no operational packets can be passed.  When a\nmanaged system initializes, all interfaces start with\nifAdminStatus in the down(2) state.  As a result of either\nexplicit management action or per configuration information\nretained by the managed system, ifAdminStatus is then\nchanged to either the up(1) or testing(3) states (or remains\nin the down(2) state).")
ifOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,7,4,3,1,2,6,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("testing", 3), ("unknown", 4), ("dormant", 5), ("notPresent", 6), ("lowerLayerDown", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOperStatus.setDescription("The current operational state of the interface.  The\ntesting(3) state indicates that no operational packets can\nbe passed.  If ifAdminStatus is down(2) then ifOperStatus\nshould be down(2).  If ifAdminStatus is changed to up(1)\nthen ifOperStatus should change to up(1) if the interface is\nready to transmit and receive network traffic; it should\nchange to dormant(5) if the interface is waiting for\nexternal actions (such as a serial line waiting for an\nincoming connection); it should remain in the down(2) state\nif and only if there is a fault that prevents it from going\nto the up(1) state; it should remain in the notPresent(6)\nstate if the interface has missing (typically, hardware)\ncomponents.")
ifLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifLastChange.setDescription("The value of sysUpTime at the time the interface entered\nits current operational state.  If the current state was\nentered prior to the last re-initialization of the local\nnetwork management subsystem, then this object contains a\nzero value.")
ifInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInOctets.setDescription("The total number of octets received on the interface,\n\n\nincluding framing characters.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifInUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUcastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were not addressed to a multicast\nor broadcast address at this sub-layer.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifInNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInNUcastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were addressed to a multicast or\nbroadcast address at this sub-layer.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.\n\nThis object is deprecated in favour of ifInMulticastPkts and\nifInBroadcastPkts.")
ifInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInDiscards.setDescription("The number of inbound packets which were chosen to be\ndiscarded even though no errors had been detected to prevent\n\n\ntheir being deliverable to a higher-layer protocol.  One\npossible reason for discarding such a packet could be to\nfree up buffer space.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInErrors.setDescription("For packet-oriented interfaces, the number of inbound\npackets that contained errors preventing them from being\ndeliverable to a higher-layer protocol.  For character-\noriented or fixed-length interfaces, the number of inbound\ntransmission units that contained errors preventing them\nfrom being deliverable to a higher-layer protocol.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUnknownProtos.setDescription("For packet-oriented interfaces, the number of packets\nreceived via the interface which were discarded because of\nan unknown or unsupported protocol.  For character-oriented\nor fixed-length interfaces that support protocol\nmultiplexing the number of transmission units received via\nthe interface which were discarded because of an unknown or\nunsupported protocol.  For any interface that does not\nsupport protocol multiplexing, this counter will always be\n0.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutOctets.setDescription("The total number of octets transmitted out of the\ninterface, including framing characters.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutUcastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were not addressed to a\nmulticast or broadcast address at this sub-layer, including\nthose that were discarded or not sent.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutNUcastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were addressed to a\nmulticast or broadcast address at this sub-layer, including\nthose that were discarded or not sent.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.\n\nThis object is deprecated in favour of ifOutMulticastPkts\nand ifOutBroadcastPkts.")
ifOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutDiscards.setDescription("The number of outbound packets which were chosen to be\ndiscarded even though no errors had been detected to prevent\ntheir being transmitted.  One possible reason for discarding\nsuch a packet could be to free up buffer space.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutErrors.setDescription("For packet-oriented interfaces, the number of outbound\npackets that could not be transmitted because of errors.\nFor character-oriented or fixed-length interfaces, the\nnumber of outbound transmission units that could not be\ntransmitted because of errors.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutQLen.setDescription("The length of the output packet queue (in packets).")
ifSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 22), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpecific.setDescription("A reference to MIB definitions specific to the particular\nmedia being used to realize the interface.  It is\n\n\nrecommended that this value point to an instance of a MIB\nobject in the media-specific MIB, i.e., that this object\nhave the semantics associated with the InstancePointer\ntextual convention defined in RFC 2579.  In fact, it is\nrecommended that the media-specific MIB specify what value\nifSpecific should/can take for values of ifType.  If no MIB\ndefinitions specific to the particular media are available,\nthe value should be set to the OBJECT IDENTIFIER { 0 0 }.")
ifMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 31)).setRevisions(("2000-06-14 00:00","1996-02-28 21:55","1993-11-08 21:55",))
if mibBuilder.loadTexts: ifMIB.setOrganization("IETF Interfaces MIB Working Group")
if mibBuilder.loadTexts: ifMIB.setContactInfo("   Keith McCloghrie\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA  95134-1706\nUS\n\n408-526-5260\nkzm@cisco.com")
if mibBuilder.loadTexts: ifMIB.setDescription("The MIB module to describe generic objects for network\ninterface sub-layers.  This MIB is an updated version of\nMIB-II's ifTable, and incorporates the extensions defined in\nRFC 1229.")
ifMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 1))
ifXTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 1))
if mibBuilder.loadTexts: ifXTable.setDescription("A list of interface entries.  The number of entries is\ngiven by the value of ifNumber.  This table contains\nadditional objects for the interface table.")
ifXEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 1, 1))
if mibBuilder.loadTexts: ifXEntry.setDescription("An entry containing additional management information\napplicable to a particular interface.")
ifName = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 1), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifName.setDescription("The textual name of the interface.  The value of this\nobject should be the name of the interface as assigned by\nthe local device and should be suitable for use in commands\nentered at the device's `console'.  This might be a text\nname, such as `le0' or a simple port number, such as `1',\ndepending on the interface naming syntax of the device.  If\nseveral entries in the ifTable together represent a single\ninterface as named by the device, then each will have the\nsame value of ifName.  Note that for an agent which responds\nto SNMP queries concerning an interface on some other\n(proxied) device, then the value of ifName for such an\ninterface is the proxied device's local name for it.\n\nIf there is no local name, or this object is otherwise not\napplicable, then this object contains a zero-length string.")
ifInMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInMulticastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were addressed to a multicast\naddress at this sub-layer.  For a MAC layer protocol, this\nincludes both Group and Functional addresses.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifInBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInBroadcastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were addressed to a broadcast\naddress at this sub-layer.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutMulticastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were addressed to a\nmulticast address at this sub-layer, including those that\nwere discarded or not sent.  For a MAC layer protocol, this\nincludes both Group and Functional addresses.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutBroadcastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were addressed to a\nbroadcast address at this sub-layer, including those that\nwere discarded or not sent.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInOctets.setDescription("The total number of octets received on the interface,\nincluding framing characters.  This object is a 64-bit\nversion of ifInOctets.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCInUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInUcastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were not addressed to a multicast\nor broadcast address at this sub-layer.  This object is a\n64-bit version of ifInUcastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCInMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInMulticastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were addressed to a multicast\naddress at this sub-layer.  For a MAC layer protocol, this\nincludes both Group and Functional addresses.  This object\nis a 64-bit version of ifInMulticastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCInBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInBroadcastPkts.setDescription("The number of packets, delivered by this sub-layer to a\nhigher (sub-)layer, which were addressed to a broadcast\naddress at this sub-layer.  This object is a 64-bit version\nof ifInBroadcastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutOctets.setDescription("The total number of octets transmitted out of the\ninterface, including framing characters.  This object is a\n64-bit version of ifOutOctets.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCOutUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 11), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutUcastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were not addressed to a\nmulticast or broadcast address at this sub-layer, including\nthose that were discarded or not sent.  This object is a\n64-bit version of ifOutUcastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutMulticastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were addressed to a\nmulticast address at this sub-layer, including those that\nwere discarded or not sent.  For a MAC layer protocol, this\nincludes both Group and Functional addresses.  This object\nis a 64-bit version of ifOutMulticastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifHCOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutBroadcastPkts.setDescription("The total number of packets that higher-level protocols\nrequested be transmitted, and which were addressed to a\nbroadcast address at this sub-layer, including those that\nwere discarded or not sent.  This object is a 64-bit version\nof ifOutBroadcastPkts.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
ifLinkUpDownTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 14), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifLinkUpDownTrapEnable.setDescription("Indicates whether linkUp/linkDown traps should be generated\nfor this interface.\n\nBy default, this object should have the value enabled(1) for\ninterfaces which do not operate on 'top' of any other\ninterface (as defined in the ifStackTable), and disabled(2)\notherwise.")
ifHighSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHighSpeed.setDescription("An estimate of the interface's current bandwidth in units\nof 1,000,000 bits per second.  If this object reports a\nvalue of `n' then the speed of the interface is somewhere in\nthe range of `n-500,000' to `n+499,999'.  For interfaces\nwhich do not vary in bandwidth or for those where no\naccurate estimation can be made, this object should contain\nthe nominal bandwidth.  For a sub-layer which has no concept\nof bandwidth, this object should be zero.")
ifPromiscuousMode = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 16), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifPromiscuousMode.setDescription("This object has a value of false(2) if this interface only\naccepts packets/frames that are addressed to this station.\nThis object has a value of true(1) when the station accepts\nall packets/frames transmitted on the media.  The value\ntrue(1) is only legal on certain types of media.  If legal,\nsetting this object to a value of true(1) may require the\ninterface to be reset before becoming effective.\n\nThe value of ifPromiscuousMode does not affect the reception\nof broadcast and multicast packets/frames by the interface.")
ifConnectorPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifConnectorPresent.setDescription("This object has the value 'true(1)' if the interface\nsublayer has a physical connector and the value 'false(2)'\notherwise.")
ifAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 18), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifAlias.setDescription("This object is an 'alias' name for the interface as\nspecified by a network manager, and provides a non-volatile\n'handle' for the interface.\n\nOn the first instantiation of an interface, the value of\nifAlias associated with that interface is the zero-length\nstring.  As and when a value is written into an instance of\nifAlias through a network management set operation, then the\nagent must retain the supplied value in the ifAlias instance\nassociated with the same interface for as long as that\ninterface remains instantiated, including across all re-\ninitializations/reboots of the network management system,\nincluding those which result in a change of the interface's\nifIndex value.\n\nAn example of the value which a network manager might store\nin this object for a WAN interface is the (Telco's) circuit\nnumber/identifier of the interface.\n\nSome agents may support write-access only for interfaces\nhaving particular values of ifType.  An agent which supports\nwrite access to this object is required to keep the value in\nnon-volatile storage, but it may limit the length of new\nvalues depending on how much storage is already occupied by\nthe current values for other interfaces.")
ifCounterDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 19), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifCounterDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\nany one or more of this interface's counters suffered a\ndiscontinuity.  The relevant counters are the specific\ninstances associated with this interface of any Counter32 or\n\n\nCounter64 object contained in the ifTable or ifXTable.  If\nno such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ifStackTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 2))
if mibBuilder.loadTexts: ifStackTable.setDescription("The table containing information on the relationships\nbetween the multiple sub-layers of network interfaces.  In\nparticular, it contains information on which sub-layers run\n'on top of' which other sub-layers, where each sub-layer\ncorresponds to a conceptual row in the ifTable.  For\nexample, when the sub-layer with ifIndex value x runs over\nthe sub-layer with ifIndex value y, then this table\ncontains:\n\n  ifStackStatus.x.y=active\n\nFor each ifIndex value, I, which identifies an active\ninterface, there are always at least two instantiated rows\nin this table associated with I.  For one of these rows, I\nis the value of ifStackHigherLayer; for the other, I is the\nvalue of ifStackLowerLayer.  (If I is not involved in\nmultiplexing, then these are the only two rows associated\nwith I.)\n\nFor example, two rows exist even for an interface which has\nno others stacked on top or below it:\n\n  ifStackStatus.0.x=active\n  ifStackStatus.x.0=active ")
ifStackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifStackHigherLayer"), (0, "IF-MIB", "ifStackLowerLayer"))
if mibBuilder.loadTexts: ifStackEntry.setDescription("Information on a particular relationship between two sub-\nlayers, specifying that one sub-layer runs on 'top' of the\nother sub-layer.  Each sub-layer corresponds to a conceptual\nrow in the ifTable.")
ifStackHigherLayer = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 1), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ifStackHigherLayer.setDescription("The value of ifIndex corresponding to the higher sub-layer\nof the relationship, i.e., the sub-layer which runs on 'top'\nof the sub-layer identified by the corresponding instance of\nifStackLowerLayer.  If there is no higher sub-layer (below\nthe internetwork layer), then this object has the value 0.")
ifStackLowerLayer = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 2), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ifStackLowerLayer.setDescription("The value of ifIndex corresponding to the lower sub-layer\nof the relationship, i.e., the sub-layer which runs 'below'\nthe sub-layer identified by the corresponding instance of\nifStackHigherLayer.  If there is no lower sub-layer, then\nthis object has the value 0.")
ifStackStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifStackStatus.setDescription("The status of the relationship between two sub-layers.\n\nChanging the value of this object from 'active' to\n'notInService' or 'destroy' will likely have consequences up\nand down the interface stack.  Thus, write access to this\nobject is likely to be inappropriate for some types of\ninterfaces, and many implementations will choose not to\nsupport write-access for any type of interface.")
ifTestTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 3))
if mibBuilder.loadTexts: ifTestTable.setDescription("This table contains one entry per interface.  It defines\nobjects which allow a network manager to instruct an agent\nto test an interface for various faults.  Tests for an\ninterface are defined in the media-specific MIB for that\ninterface.  After invoking a test, the object ifTestResult\ncan be read to determine the outcome.  If an agent can not\nperform the test, ifTestResult is set to so indicate.  The\nobject ifTestCode can be used to provide further test-\nspecific or interface-specific (or even enterprise-specific)\ninformation concerning the outcome of the test.  Only one\ntest can be in progress on each interface at any one time.\nIf one test is in progress when another test is invoked, the\nsecond test is rejected.  Some agents may reject a test when\na prior test is active on another interface.\n\nBefore starting a test, a manager-station must first obtain\n'ownership' of the entry in the ifTestTable for the\ninterface to be tested.  This is accomplished with the\nifTestId and ifTestStatus objects as follows:\n\ntry_again:\n  get (ifTestId, ifTestStatus)\n  while (ifTestStatus != notInUse)\n      /*\n       * Loop while a test is running or some other\n       * manager is configuring a test.\n       */\n      short delay\n      get (ifTestId, ifTestStatus)\n  }\n\n  /*\n   * Is not being used right now -- let's compete\n   * to see who gets it.\n   */\n  lock_value = ifTestId\n\n  if ( set(ifTestId = lock_value, ifTestStatus = inUse,\n\n\n           ifTestOwner = 'my-IP-address') == FAILURE)\n      /*\n       * Another manager got the ifTestEntry -- go\n       * try again\n       */\n      goto try_again;\n\n  /*\n   * I have the lock\n   */\n  set up any test parameters.\n\n  /*\n   * This starts the test\n   */\n  set(ifTestType = test_to_run);\n\n  wait for test completion by polling ifTestResult\n\n  when test completes, agent sets ifTestResult\n       agent also sets ifTestStatus = 'notInUse'\n\n  retrieve any additional test results, and ifTestId\n\n  if (ifTestId == lock_value+1) results are valid\n\nA manager station first retrieves the value of the\nappropriate ifTestId and ifTestStatus objects, periodically\nrepeating the retrieval if necessary, until the value of\nifTestStatus is 'notInUse'.  The manager station then tries\nto set the same ifTestId object to the value it just\nretrieved, the same ifTestStatus object to 'inUse', and the\ncorresponding ifTestOwner object to a value indicating\nitself.  If the set operation succeeds then the manager has\nobtained ownership of the ifTestEntry, and the value of the\nifTestId object is incremented by the agent (per the\nsemantics of TestAndIncr).  Failure of the set operation\nindicates that some other manager has obtained ownership of\nthe ifTestEntry.\n\nOnce ownership is obtained, any test parameters can be\nsetup, and then the test is initiated by setting ifTestType.\nOn completion of the test, the agent sets ifTestStatus to\n'notInUse'.  Once this occurs, the manager can retrieve the\nresults.  In the (rare) event that the invocation of tests\nby two network managers were to overlap, then there would be\na possibility that the first test's results might be\noverwritten by the second test's results prior to the first\n\n\nresults being read.  This unlikely circumstance can be\ndetected by a network manager retrieving ifTestId at the\nsame time as retrieving the test results, and ensuring that\nthe results are for the desired request.\n\nIf ifTestType is not set within an abnormally long period of\ntime after ownership is obtained, the agent should time-out\nthe manager, and reset the value of the ifTestStatus object\nback to 'notInUse'.  It is suggested that this time-out\nperiod be 5 minutes.\n\nIn general, a management station must not retransmit a\nrequest to invoke a test for which it does not receive a\nresponse; instead, it properly inspects an agent's MIB to\ndetermine if the invocation was successful.  Only if the\ninvocation was unsuccessful, is the invocation request\nretransmitted.\n\nSome tests may require the interface to be taken off-line in\norder to execute them, or may even require the agent to\nreboot after completion of the test.  In these\ncircumstances, communication with the management station\ninvoking the test may be lost until after completion of the\ntest.  An agent is not required to support such tests.\nHowever, if such tests are supported, then the agent should\nmake every effort to transmit a response to the request\nwhich invoked the test prior to losing communication.  When\nthe agent is restored to normal service, the results of the\ntest are properly made available in the appropriate objects.\nNote that this requires that the ifIndex value assigned to\nan interface must be unchanged even if the test causes a\nreboot.  An agent must reject any test for which it cannot,\nperhaps due to resource constraints, make available at least\nthe minimum amount of information after that test\ncompletes.")
ifTestEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 3, 1))
if mibBuilder.loadTexts: ifTestEntry.setDescription("An entry containing objects for invoking tests on an\ninterface.")
ifTestId = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestId.setDescription("This object identifies the current invocation of the\ninterface's test.")
ifTestStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("notInUse", 1), ("inUse", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestStatus.setDescription("This object indicates whether or not some manager currently\nhas the necessary 'ownership' required to invoke a test on\nthis interface.  A write to this object is only successful\nwhen it changes its value from 'notInUse(1)' to 'inUse(2)'.\nAfter completion of a test, the agent resets the value back\nto 'notInUse(1)'.")
ifTestType = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 3), AutonomousType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestType.setDescription("A control variable used to start and stop operator-\ninitiated interface tests.  Most OBJECT IDENTIFIER values\nassigned to tests are defined elsewhere, in association with\nspecific types of interface.  However, this document assigns\na value for a full-duplex loopback test, and defines the\nspecial meanings of the subject identifier:\n\n    noTest  OBJECT IDENTIFIER ::= { 0 0 }\n\nWhen the value noTest is written to this object, no action\nis taken unless a test is in progress, in which case the\ntest is aborted.  Writing any other value to this object is\n\n\nonly valid when no test is currently in progress, in which\ncase the indicated test is initiated.\n\nWhen read, this object always returns the most recent value\nthat ifTestType was set to.  If it has not been set since\nthe last initialization of the network management subsystem\non the agent, a value of noTest is returned.")
ifTestResult = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,7,5,6,3,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("success", 2), ("inProgress", 3), ("notSupported", 4), ("unAbleToRun", 5), ("aborted", 6), ("failed", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTestResult.setDescription("This object contains the result of the most recently\nrequested test, or the value none(1) if no tests have been\nrequested since the last reset.  Note that this facility\nprovides no provision for saving the results of one test\nwhen starting another, as could be required if used by\nmultiple managers concurrently.")
ifTestCode = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 5), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTestCode.setDescription("This object contains a code which contains more specific\ninformation on the test result, for example an error-code\nafter a failed test.  Error codes and other values this\nobject may take are specific to the type of interface and/or\ntest.  The value may have the semantics of either the\nAutonomousType or InstancePointer textual conventions as\ndefined in RFC 2579.  The identifier:\n\n    testCodeUnknown  OBJECT IDENTIFIER ::= { 0 0 }\n\nis defined for use if no additional result code is\navailable.")
ifTestOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 6), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestOwner.setDescription("The entity which currently has the 'ownership' required to\ninvoke a test on this interface.")
ifRcvAddressTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 4))
if mibBuilder.loadTexts: ifRcvAddressTable.setDescription("This table contains an entry for each address (broadcast,\nmulticast, or uni-cast) for which the system will receive\npackets/frames on a particular interface, except as follows:\n\n- for an interface operating in promiscuous mode, entries\nare only required for those addresses for which the system\nwould receive frames were it not operating in promiscuous\nmode.\n\n\n- for 802.5 functional addresses, only one entry is\nrequired, for the address which has the functional address\nbit ANDed with the bit mask of all functional addresses for\nwhich the interface will accept frames.\n\nA system is normally able to use any unicast address which\ncorresponds to an entry in this table as a source address.")
ifRcvAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "IF-MIB", "ifRcvAddressAddress"))
if mibBuilder.loadTexts: ifRcvAddressEntry.setDescription("A list of objects identifying an address for which the\nsystem will accept packets/frames on the particular\ninterface identified by the index value ifIndex.")
ifRcvAddressAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 1), PhysAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ifRcvAddressAddress.setDescription("An address for which the system will accept packets/frames\non this entry's interface.")
ifRcvAddressStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifRcvAddressStatus.setDescription("This object is used to create and delete rows in the\nifRcvAddressTable.")
ifRcvAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("volatile", 2), ("nonVolatile", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifRcvAddressType.setDescription("This object has the value nonVolatile(3) for those entries\nin the table which are valid and will not be deleted by the\nnext restart of the managed system.  Entries having the\nvalue volatile(2) are valid and exist, but have not been\nsaved, so that will not exist after the next restart of the\nmanaged system.  Entries having the value other(1) are valid\nand exist but are not classified as to whether they will\ncontinue to exist after the next restart.")
ifTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 31, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTableLastChange.setDescription("The value of sysUpTime at the time of the last creation or\ndeletion of an entry in the ifTable.  If the number of\nentries has been unchanged since the last re-initialization\nof the local network management subsystem, then this object\ncontains a zero value.")
ifStackLastChange = MibScalar((1, 3, 6, 1, 2, 1, 31, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifStackLastChange.setDescription("The value of sysUpTime at the time of the last change of\nthe (whole) interface stack.  A change of the interface\nstack is defined to be any creation, deletion, or change in\nvalue of any instance of ifStackStatus.  If the interface\nstack has been unchanged since the last re-initialization of\nthe local network management subsystem, then this object\ncontains a zero value.")
ifConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2))
ifGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2, 1))
ifCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2, 2))

# Augmentions
ifEntry.registerAugmentions(("IF-MIB", "ifTestEntry"))
apply(ifTestEntry.setIndexNames, ifEntry.getIndexNames())
ifEntry.registerAugmentions(("IF-MIB", "ifXEntry"))
apply(ifXEntry.setIndexNames, ifEntry.getIndexNames())

# Notifications

linkUp = NotificationType((1, 3, 6, 1, 6, 3, 1, 1, 5, 4)).setObjects(("IF-MIB", "ifIndex"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), )
linkDown = NotificationType((1, 3, 6, 1, 6, 3, 1, 1, 5, 3)).setObjects(("IF-MIB", "ifIndex"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), )

# Groups

ifPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 4)).setObjects(("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifPromiscuousMode"), ("IF-MIB", "ifMtu"), )
ifFixedLengthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 2)).setObjects(("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutErrors"), )
ifHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 5)).setObjects(("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifPromiscuousMode"), ("IF-MIB", "ifMtu"), )
ifOldObjectsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 12)).setObjects(("IF-MIB", "ifOutQLen"), ("IF-MIB", "ifSpecific"), ("IF-MIB", "ifInNUcastPkts"), ("IF-MIB", "ifOutNUcastPkts"), )
ifStackGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 11)).setObjects(("IF-MIB", "ifStackStatus"), ("IF-MIB", "ifStackLastChange"), )
ifCounterDiscontinuityGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 13)).setObjects(("IF-MIB", "ifCounterDiscontinuityTime"), )
ifGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 1)).setObjects(("IF-MIB", "ifConnectorPresent"), ("IF-MIB", "ifSpeed"), ("IF-MIB", "ifType"), ("IF-MIB", "ifHighSpeed"), ("IF-MIB", "ifLinkUpDownTrapEnable"), ("IF-MIB", "ifLastChange"), ("IF-MIB", "ifPhysAddress"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifDescr"), ("IF-MIB", "ifName"), ("IF-MIB", "ifOperStatus"), )
ifTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 8)).setObjects(("IF-MIB", "ifTestId"), ("IF-MIB", "ifTestCode"), ("IF-MIB", "ifTestOwner"), ("IF-MIB", "ifTestStatus"), ("IF-MIB", "ifTestResult"), ("IF-MIB", "ifTestType"), )
linkUpDownNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 14)).setObjects(("IF-MIB", "linkUp"), ("IF-MIB", "linkDown"), )
ifRcvAddressGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 7)).setObjects(("IF-MIB", "ifRcvAddressStatus"), ("IF-MIB", "ifRcvAddressType"), )
ifVHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 6)).setObjects(("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifMtu"), ("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifHCInMulticastPkts"), ("IF-MIB", "ifPromiscuousMode"), ("IF-MIB", "ifHCInUcastPkts"), ("IF-MIB", "ifHCOutMulticastPkts"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifHCOutBroadcastPkts"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifHCInBroadcastPkts"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifHCOutUcastPkts"), )
ifStackGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 9)).setObjects(("IF-MIB", "ifStackStatus"), )
ifHCFixedLengthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 3)).setObjects(("IF-MIB", "ifInErrors"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifInUnknownProtos"), )
ifGeneralInformationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 10)).setObjects(("IF-MIB", "ifConnectorPresent"), ("IF-MIB", "ifSpeed"), ("IF-MIB", "ifType"), ("IF-MIB", "ifTableLastChange"), ("IF-MIB", "ifHighSpeed"), ("IF-MIB", "ifNumber"), ("IF-MIB", "ifLinkUpDownTrapEnable"), ("IF-MIB", "ifLastChange"), ("IF-MIB", "ifPhysAddress"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifDescr"), ("IF-MIB", "ifIndex"), ("IF-MIB", "ifName"), ("IF-MIB", "ifAlias"), ("IF-MIB", "ifOperStatus"), )

# Exports

# Module identity
mibBuilder.exportSymbols("IF-MIB", PYSNMP_MODULE_ID=ifMIB)

# Types
mibBuilder.exportSymbols("IF-MIB", InterfaceIndex=InterfaceIndex, InterfaceIndexOrZero=InterfaceIndexOrZero, OwnerString=OwnerString)

# Objects
mibBuilder.exportSymbols("IF-MIB", interfaces=interfaces, ifNumber=ifNumber, ifTable=ifTable, ifEntry=ifEntry, ifIndex=ifIndex, ifDescr=ifDescr, ifType=ifType, ifMtu=ifMtu, ifSpeed=ifSpeed, ifPhysAddress=ifPhysAddress, ifAdminStatus=ifAdminStatus, ifOperStatus=ifOperStatus, ifLastChange=ifLastChange, ifInOctets=ifInOctets, ifInUcastPkts=ifInUcastPkts, ifInNUcastPkts=ifInNUcastPkts, ifInDiscards=ifInDiscards, ifInErrors=ifInErrors, ifInUnknownProtos=ifInUnknownProtos, ifOutOctets=ifOutOctets, ifOutUcastPkts=ifOutUcastPkts, ifOutNUcastPkts=ifOutNUcastPkts, ifOutDiscards=ifOutDiscards, ifOutErrors=ifOutErrors, ifOutQLen=ifOutQLen, ifSpecific=ifSpecific, ifMIB=ifMIB, ifMIBObjects=ifMIBObjects, ifXTable=ifXTable, ifXEntry=ifXEntry, ifName=ifName, ifInMulticastPkts=ifInMulticastPkts, ifInBroadcastPkts=ifInBroadcastPkts, ifOutMulticastPkts=ifOutMulticastPkts, ifOutBroadcastPkts=ifOutBroadcastPkts, ifHCInOctets=ifHCInOctets, ifHCInUcastPkts=ifHCInUcastPkts, ifHCInMulticastPkts=ifHCInMulticastPkts, ifHCInBroadcastPkts=ifHCInBroadcastPkts, ifHCOutOctets=ifHCOutOctets, ifHCOutUcastPkts=ifHCOutUcastPkts, ifHCOutMulticastPkts=ifHCOutMulticastPkts, ifHCOutBroadcastPkts=ifHCOutBroadcastPkts, ifLinkUpDownTrapEnable=ifLinkUpDownTrapEnable, ifHighSpeed=ifHighSpeed, ifPromiscuousMode=ifPromiscuousMode, ifConnectorPresent=ifConnectorPresent, ifAlias=ifAlias, ifCounterDiscontinuityTime=ifCounterDiscontinuityTime, ifStackTable=ifStackTable, ifStackEntry=ifStackEntry, ifStackHigherLayer=ifStackHigherLayer, ifStackLowerLayer=ifStackLowerLayer, ifStackStatus=ifStackStatus, ifTestTable=ifTestTable, ifTestEntry=ifTestEntry, ifTestId=ifTestId, ifTestStatus=ifTestStatus, ifTestType=ifTestType, ifTestResult=ifTestResult, ifTestCode=ifTestCode, ifTestOwner=ifTestOwner, ifRcvAddressTable=ifRcvAddressTable, ifRcvAddressEntry=ifRcvAddressEntry, ifRcvAddressAddress=ifRcvAddressAddress, ifRcvAddressStatus=ifRcvAddressStatus, ifRcvAddressType=ifRcvAddressType, ifTableLastChange=ifTableLastChange, ifStackLastChange=ifStackLastChange, ifConformance=ifConformance, ifGroups=ifGroups, ifCompliances=ifCompliances)

# Notifications
mibBuilder.exportSymbols("IF-MIB", linkUp=linkUp, linkDown=linkDown)

# Groups
mibBuilder.exportSymbols("IF-MIB", ifPacketGroup=ifPacketGroup, ifFixedLengthGroup=ifFixedLengthGroup, ifHCPacketGroup=ifHCPacketGroup, ifOldObjectsGroup=ifOldObjectsGroup, ifStackGroup2=ifStackGroup2, ifCounterDiscontinuityGroup=ifCounterDiscontinuityGroup, ifGeneralGroup=ifGeneralGroup, ifTestGroup=ifTestGroup, linkUpDownNotificationsGroup=linkUpDownNotificationsGroup, ifRcvAddressGroup=ifRcvAddressGroup, ifVHCPacketGroup=ifVHCPacketGroup, ifStackGroup=ifStackGroup, ifHCFixedLengthGroup=ifHCFixedLengthGroup, ifGeneralInformationGroup=ifGeneralInformationGroup)
