# PySNMP SMI module. Autogenerated from smidump -f python IPV6-TCP-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:26 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Ipv6Address, Ipv6IfIndexOrZero, ) = mibBuilder.importSymbols("IPV6-TC", "Ipv6Address", "Ipv6IfIndexOrZero")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, experimental, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "experimental", "mib-2")

# Objects

tcp = MibIdentifier((1, 3, 6, 1, 2, 1, 6))
ipv6TcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 6, 16))
if mibBuilder.loadTexts: ipv6TcpConnTable.setDescription("A table containing TCP connection-specific information,\nfor only those connections whose endpoints are IPv6 addresses.")
ipv6TcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 16, 1)).setIndexNames((0, "IPV6-TCP-MIB", "ipv6TcpConnLocalAddress"), (0, "IPV6-TCP-MIB", "ipv6TcpConnLocalPort"), (0, "IPV6-TCP-MIB", "ipv6TcpConnRemAddress"), (0, "IPV6-TCP-MIB", "ipv6TcpConnRemPort"), (0, "IPV6-TCP-MIB", "ipv6TcpConnIfIndex"))
if mibBuilder.loadTexts: ipv6TcpConnEntry.setDescription("A conceptual row of the ipv6TcpConnTable containing\ninformation about a particular current TCP connection.\nEach row of this table is transient, in that it ceases to\nexist when (or soon after) the connection makes the transition\nto the CLOSED state.\n\nNote that conceptual rows in this table require an additional\nindex object compared to tcpConnTable, since IPv6 addresses\nare not guaranteed to be unique on the managed node.")
ipv6TcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 1), Ipv6Address()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6TcpConnLocalAddress.setDescription("The local IPv6 address for this TCP connection. In\nthe case of a connection in the listen state which\nis willing to accept connections for any IPv6\naddress associated with the managed node, the value\n::0 is used.")
ipv6TcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6TcpConnLocalPort.setDescription("The local port number for this TCP connection.")
ipv6TcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 3), Ipv6Address()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6TcpConnRemAddress.setDescription("The remote IPv6 address for this TCP connection.")
ipv6TcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6TcpConnRemPort.setDescription("The remote port number for this TCP connection.")
ipv6TcpConnIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 5), Ipv6IfIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6TcpConnIfIndex.setDescription("An index object used to disambiguate conceptual rows in\nthe table, since the connection 4-tuple may not be unique.\n\nIf the connection's remote address (ipv6TcpConnRemAddress)\nis a link-local address and the connection's local address\n(ipv6TcpConnLocalAddress) is not a link-local address, this\nobject identifies a local interface on the same link as\nthe connection's remote link-local address.\n\nOtherwise, this object identifies the local interface that\nis associated with the ipv6TcpConnLocalAddress for this\nTCP connection.  If such a local interface cannot be determined,\nthis object should take on the value 0.  (A possible example\nof this would be if the value of ipv6TcpConnLocalAddress is ::0.)\n\nThe interface identified by a particular non-0 value of this\nindex is the same interface as identified by the same value\nof ipv6IfIndex.\n\nThe value of this object must remain constant during the life\nof the TCP connection.")
ipv6TcpConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,5,7,11,9,8,12,6,1,10,2,3,)).subtype(namedValues=namedval.NamedValues(("closed", 1), ("closing", 10), ("timeWait", 11), ("deleteTCB", 12), ("listen", 2), ("synSent", 3), ("synReceived", 4), ("established", 5), ("finWait1", 6), ("finWait2", 7), ("closeWait", 8), ("lastAck", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6TcpConnState.setDescription("The state of this TCP connection.\n\nThe only value which may be set by a management station is\ndeleteTCB(12).  Accordingly, it is appropriate for an agent\nto return an error response (`badValue' for SNMPv1, 'wrongValue'\nfor SNMPv2) if a management station attempts to set this\nobject to any other value.\n\nIf a management station sets this object to the value\ndeleteTCB(12), then this has the effect of deleting the TCB\n(as defined in RFC 793) of the corresponding connection on\nthe managed node, resulting in immediate termination of the\nconnection.\nAs an implementation-specific option, a RST segment may be\nsent from the managed node to the other TCP endpoint (note\nhowever that RST segments are not sent reliably).")
ipv6TcpMIB = ModuleIdentity((1, 3, 6, 1, 3, 86)).setRevisions(("1998-01-29 00:00",))
if mibBuilder.loadTexts: ipv6TcpMIB.setOrganization("IETF IPv6 MIB Working Group")
if mibBuilder.loadTexts: ipv6TcpMIB.setContactInfo("       Mike Daniele\n\nPostal: Compaq Computer Corporation\n        110 Spitbrook Rd\n        Nashua, NH 03062.\n        US\n\nPhone:  +1 603 884 1423\nEmail:  daniele@zk3.dec.com")
if mibBuilder.loadTexts: ipv6TcpMIB.setDescription("The MIB module for entities implementing TCP over IPv6.")
ipv6TcpConformance = MibIdentifier((1, 3, 6, 1, 3, 86, 2))
ipv6TcpCompliances = MibIdentifier((1, 3, 6, 1, 3, 86, 2, 1))
ipv6TcpGroups = MibIdentifier((1, 3, 6, 1, 3, 86, 2, 2))

# Augmentions

# Groups

ipv6TcpGroup = ObjectGroup((1, 3, 6, 1, 3, 86, 2, 2, 1)).setObjects(("IPV6-TCP-MIB", "ipv6TcpConnState"), )

# Exports

# Module identity
mibBuilder.exportSymbols("IPV6-TCP-MIB", PYSNMP_MODULE_ID=ipv6TcpMIB)

# Objects
mibBuilder.exportSymbols("IPV6-TCP-MIB", tcp=tcp, ipv6TcpConnTable=ipv6TcpConnTable, ipv6TcpConnEntry=ipv6TcpConnEntry, ipv6TcpConnLocalAddress=ipv6TcpConnLocalAddress, ipv6TcpConnLocalPort=ipv6TcpConnLocalPort, ipv6TcpConnRemAddress=ipv6TcpConnRemAddress, ipv6TcpConnRemPort=ipv6TcpConnRemPort, ipv6TcpConnIfIndex=ipv6TcpConnIfIndex, ipv6TcpConnState=ipv6TcpConnState, ipv6TcpMIB=ipv6TcpMIB, ipv6TcpConformance=ipv6TcpConformance, ipv6TcpCompliances=ipv6TcpCompliances, ipv6TcpGroups=ipv6TcpGroups)

# Groups
mibBuilder.exportSymbols("IPV6-TCP-MIB", ipv6TcpGroup=ipv6TcpGroup)
