# PySNMP SMI module. Autogenerated from smidump -f python Job-Monitoring-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:27 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, enterprises, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "enterprises")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")

# Types

class JmAttributeTypeTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(90,51,74,175,115,52,93,174,22,6,94,36,23,38,195,70,54,170,171,151,114,8,55,132,1,173,56,150,7,172,113,75,76,112,9,192,190,111,25,95,91,29,34,73,50,152,193,194,31,96,32,26,30,92,4,3,72,5,110,130,21,35,53,20,77,28,71,131,97,33,27,24,191,37,)
    namedValues = namedval.NamedValues(("other", 1), ("impressionsSpooled", 110), ("impressionsSentToDevice", 111), ("impressionsInterpreted", 112), ("impressionsCompletedCurrentCopy", 113), ("fullColorImpressionsCompleted", 114), ("highlightColorImpressionsCompleted", 115), ("pagesRequested", 130), ("pagesCompleted", 131), ("pagesCompletedCurrentCopy", 132), ("sheetsRequested", 150), ("sheetsCompleted", 151), ("sheetsCompletedCurrentCopy", 152), ("mediumRequested", 170), ("mediumConsumed", 171), ("colorantRequested", 172), ("colorantConsumed", 173), ("mediumTypeConsumed", 174), ("mediumSizeConsumed", 175), ("jobSubmissionToServerTime", 190), ("jobSubmissionTime", 191), ("jobStartedBeingHeldTime", 192), ("jobStartedProcessingTime", 193), ("jobCompletionTime", 194), ("jobProcessingCPUTime", 195), ("jobURI", 20), ("jobAccountName", 21), ("serverAssignedJobName", 22), ("jobName", 23), ("jobServiceTypes", 24), ("jobSourceChannelIndex", 25), ("jobSourcePlatformType", 26), ("submittingServerName", 27), ("submittingApplicationName", 28), ("jobOriginatingHost", 29), ("jobStateReasons2", 3), ("deviceNameRequested", 30), ("queueNameRequested", 31), ("physicalDevice", 32), ("numberOfDocuments", 33), ("fileName", 34), ("documentName", 35), ("jobComment", 36), ("documentFormatIndex", 37), ("documentFormat", 38), ("jobStateReasons3", 4), ("jobStateReasons4", 5), ("jobPriority", 50), ("jobProcessAfterDateAndTime", 51), ("jobHold", 52), ("jobHoldUntil", 53), ("outputBin", 54), ("sides", 55), ("finishing", 56), ("processingMessage", 6), ("processingMessageNaturalLangTag", 7), ("printQualityRequested", 70), ("printQualityUsed", 71), ("printerResolutionRequested", 72), ("printerResolutionUsed", 73), ("tonerEcomonyRequested", 74), ("tonerEcomonyUsed", 75), ("tonerDensityRequested", 76), ("tonerDensityUsed", 77), ("jobCodedCharSet", 8), ("jobNaturalLanguageTag", 9), ("jobCopiesRequested", 90), ("jobCopiesCompleted", 91), ("documentCopiesRequested", 92), ("documentCopiesCompleted", 93), ("jobKOctetsTransferred", 94), ("sheetCompletedCopyNumber", 95), ("sheetCompletedDocumentNumber", 96), ("jobCollationType", 97), )
    pass

class JmBooleanTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,4,)
    namedValues = namedval.NamedValues(("unknown", 2), ("false", 3), ("true", 4), )
    pass

class JmFinishingTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,6,5,1,7,4,)
    namedValues = namedval.NamedValues(("other", 1), ("unknown", 2), ("none", 3), ("staple", 4), ("punch", 5), ("cover", 6), ("bind", 7), )
    pass

class JmJobCollationTypeTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(5,2,1,3,4,)
    namedValues = namedval.NamedValues(("other", 1), ("unknown", 2), ("uncollatedSheets", 3), ("collatedDocuments", 4), ("uncollatedDocuments", 5), )
    pass

class JmJobServiceTypesTC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmJobSourcePlatformTypeTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(10,9,12,2,4,11,3,1,5,7,6,8,)
    namedValues = namedval.NamedValues(("other", 1), ("sptVMS", 10), ("sptWindows", 11), ("sptNetWare", 12), ("unknown", 2), ("sptUNIX", 3), ("sptOS2", 4), ("sptPCDOS", 5), ("sptNT", 6), ("sptMVS", 7), ("sptVM", 8), ("sptOS400", 9), )
    pass

class JmJobStateReasons1TC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmJobStateReasons2TC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmJobStateReasons3TC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmJobStateReasons4TC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmJobStateTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,9,5,6,7,8,4,3,)
    namedValues = namedval.NamedValues(("unknown", 2), ("pending", 3), ("pendingHeld", 4), ("processing", 5), ("processingStopped", 6), ("canceled", 7), ("aborted", 8), ("completed", 9), )
    pass

class JmJobStringTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,63)
    pass

class JmJobSubmissionIDTypeTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,1)
    fixedLength = 1
    pass

class JmMediumTypeTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(12,13,2,11,5,9,8,1,6,4,3,10,7,)
    namedValues = namedval.NamedValues(("other", 1), ("tabStock", 10), ("multiPartForm", 11), ("labels", 12), ("multiLayer", 13), ("unknown", 2), ("stationery", 3), ("transparency", 4), ("envelope", 5), ("envelopePlain", 6), ("envelopeWindow", 7), ("continuousLong", 8), ("continuousShort", 9), )
    pass

class JmNaturalLanguageTagTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,63)
    pass

class JmPrintQualityTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,2,5,1,3,)
    namedValues = namedval.NamedValues(("other", 1), ("unknown", 2), ("draft", 3), ("normal", 4), ("high", 5), )
    pass

class JmPrinterResolutionTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(9,9)
    fixedLength = 9
    pass

class JmTimeStampTC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class JmTonerEconomyTC(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,3,2,)
    namedValues = namedval.NamedValues(("unknown", 2), ("off", 3), ("on", 4), )
    pass

class JmUTF8StringTC(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,63)
    pass


# Objects

jobmonMIB = ModuleIdentity((1, 3, 6, 1, 4, 1, 2699, 1, 1)).setRevisions(("1999-02-19 00:00",))
if mibBuilder.loadTexts: jobmonMIB.setOrganization("Printer Working Group (PWG)")
if mibBuilder.loadTexts: jobmonMIB.setContactInfo("Tom Hastings\nPostal:  Xerox Corp.\n         Mail stop ESAE-231\n         701 S. Aviation Blvd.\n         El Segundo, CA 90245\n\nTel:     (301)333-6413\nFax:     (301)333-5514\nE-mail:  hastings@cp10.es.xerox.com\n\nSend questions and comments to the Printer Working Group (PWG)\nusing the Job Monitoring Project (JMP) Mailing List:\njmp@pwg.org\n\nFor further information, including how to subscribe to the\njmp mailing list, access the PWG web page under 'JMP':\n\n    http://www.pwg.org/\n\nImplementers of this specification are encouraged to join the\njmp mailing list in order to participate in discussions on any\nclarifications needed and registration proposals being reviewed\nin order to achieve consensus.")
if mibBuilder.loadTexts: jobmonMIB.setDescription("The MIB module for monitoring job in servers, printers, and\nother devices.\n\nVersion: 1.0")
jobmonMIBObjects = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1))
jmGeneral = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1))
jmGeneralTable = MibTable((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1))
if mibBuilder.loadTexts: jmGeneralTable.setDescription("The jmGeneralTable consists of information of a general nature\nthat are per-job-set, but are not per-job.  See Section 2\nentitled 'Terminology and Job Model' for the definition of a\njob set.\n\nThe MANDATORY-GROUP macro specifies that this group is\nMANDATORY.")
jmGeneralEntry = MibTableRow((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1)).setIndexNames((0, "Job-Monitoring-MIB", "jmGeneralJobSetIndex"))
if mibBuilder.loadTexts: jmGeneralEntry.setDescription("Information about a job set (queue).\n\nAn entry SHALL exist in this table for each job set.")
jmGeneralJobSetIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32767))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: jmGeneralJobSetIndex.setDescription("A unique value for each job set in this MIB.  The jmJobTable\nand jmAttributeTable tables have this same index as their\nprimary index.\n\nThe value(s) of the jmGeneralJobSetIndex SHALL be persistent\nacross power cycles, so that clients that have retained\njmGeneralJobSetIndex values will access the same job sets upon\nsubsequent power-up.\n\nAn implementation that has only one job set, such as a printer\nwith a single queue, SHALL hard code this object with the value\n1.\n\nSee Section 2 entitled 'Terminology and Job Model' for the\ndefinition of a job set.\nCorresponds to the first index in jmJobTable and\njmAttributeTable.")
jmGeneralNumberOfActiveJobs = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralNumberOfActiveJobs.setDescription("The current number of 'active' jobs in the jmJobIDTable,\njmJobTable, and jmAttributeTable, i.e., the total number of\njobs that are in the pending, processing, or processingStopped\nstates.  See the JmJobStateTC textual-convention for the exact\nspecification of the semantics of the job states.")
jmGeneralOldestActiveJobIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralOldestActiveJobIndex.setDescription("The jmJobIndex of the oldest job that is still in one of the\n'active' states (pending, processing, or processingStopped).\nIn other words, the index of the 'active' job that has been in\nthe job tables the longest.\n\nIf there are no active jobs, the agent SHALL set the value of\nthis object to 0.\n\nSee Section 3.2 entitled 'The Job Tables and the Oldest Active\nand Newest Active Indexes' for a description of the usage of\nthis object.")
jmGeneralNewestActiveJobIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralNewestActiveJobIndex.setDescription("The jmJobIndex of the newest job that is in one of the\n'active' states (pending, processing, or processingStopped).\nIn other words, the index of the 'active' job that has been\nmost recently added to the job tables.\n\nWhen all jobs become 'inactive', i.e., enter the pendingHeld,\ncompleted, canceled, or aborted states, the agent SHALL set the\nvalue of this object to 0.\n\nSee Section 3.2 entitled 'The Job Tables and the Oldest Active\nand Newest Active Indexes' for a description of the usage of\nthis object.")
jmGeneralJobPersistence = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(15, 2147483647L)).clone(60)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralJobPersistence.setDescription("The minimum time in seconds for this instance of the Job Set\nthat an entry SHALL remain in the jmJobIDTable and jmJobTable\nafter processing has completed, i.e., the minimum time in\nseconds starting when the job enters the completed, canceled,\nor aborted state.\n\nConfiguring this object is implementation-dependent.\n\nThis value SHALL be equal to or greater than the value of\njmGeneralAttributePersistence.  This value SHOULD be at least\n60 which gives a monitoring or accounting application one\nminute in which to poll for job data.")
jmGeneralAttributePersistence = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(15, 2147483647L)).clone(60)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralAttributePersistence.setDescription("The minimum time in seconds for this instance of the Job Set\nthat an entry SHALL remain in the jmAttributeTable after\nprocessing has completed , i.e., the time in seconds starting\nwhen the job enters the completed, canceled, or aborted state.\n\nConfiguring this object is implementation-dependent.\n\nThis value SHOULD be at least 60 which gives a monitoring or\naccounting application one minute in which to poll for job\ndata.")
jmGeneralJobSetName = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 1, 1, 1, 7), JmUTF8StringTC().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63)).clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmGeneralJobSetName.setDescription("The human readable name of this job set assigned by the system\nadministrator (by means outside of this MIB).  Typically, this\nname SHOULD be the name of the job queue.  If a server or\ndevice has only a single job set, this object can be the\nadministratively assigned name of the server or device itself.\nThis name does not need to be unique, though each job set in a\nsingle Job Monitoring MIB SHOULD have distinct names.\n\nNOTE - If the job set corresponds to a single printer and the\nPrinter MIB is implemented, this value SHOULD be the same as\nthe prtGeneralPrinterName object in the draft Printer MIB\n[print-mib-draft].  If the job set corresponds to an IPP\nPrinter, this value SHOULD be the same as the IPP 'printer-\nname' Printer attribute.\n\nNOTE - The purpose of this object is to help the user of the\njob monitoring application distinguish between several job sets\nin implementations that support more than one job set.\n\nSee the OBJECT compliance macro for the minimum maximum length\nrequired for conformance.")
jmJobID = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2))
jmJobIDTable = MibTable((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2, 1))
if mibBuilder.loadTexts: jmJobIDTable.setDescription("The jmJobIDTable provides a correspondence map (1) between the\njob submission ID that a client uses to refer to a job and (2)\nthe jmGeneralJobSetIndex and jmJobIndex that the Job Monitoring\nMIB agent assigned to the job and that are used to access the\njob in all of the other tables in the MIB.  If a monitoring\napplication already knows the jmGeneralJobSetIndex and the\njmJobIndex of the job it is querying, that application NEED NOT\nuse the jmJobIDTable.\n\nThe MANDATORY-GROUP macro specifies that this group is\nMANDATORY.")
jmJobIDEntry = MibTableRow((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2, 1, 1)).setIndexNames((0, "Job-Monitoring-MIB", "jmJobSubmissionID"))
if mibBuilder.loadTexts: jmJobIDEntry.setDescription("The map from (1) the jmJobSubmissionID to (2) the\njmGeneralJobSetIndex and jmJobIndex.\n\nAn entry SHALL exist in this table for each job currently known\nto the agent for all job sets and job states.  There MAY be\nmore than one jmJobIDEntry that maps to a single job.  This\nmany to one mapping can occur when more than one network entity\nalong the job submission path supplies a job submission ID.\nSee Section 3.5.  However, each job SHALL appear once and in\none and only one job set.")
jmJobSubmissionID = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2, 1, 1, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(48, 48)).setFixedLength(48)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: jmJobSubmissionID.setDescription("A quasi-unique 48-octet fixed-length string ID which\nidentifies the job within a particular client-server\nenvironment.  There are multiple formats for the\njmJobSubmissionID.  Each format SHALL be uniquely identified.\nSee the JmJobSubmissionIDTypeTC textual convention.  Each\nformat SHALL be registered using the procedures of a type 2\nenum.  See section 3.7.3 entitled: 'PWG Registration of Job\nSubmission Id Formats'.\n\nIf the requester (client or server) does not supply a job\nsubmission ID in the job submission protocol, then the\nrecipient (server or device) SHALL assign a job submission ID\nusing any of the standard formats that have been reserved for\nagents and adding the final 8 octets to distinguish the ID from\nothers submitted from the same requester.\n\nThe monitoring application, whether in the client or running\nseparately, MAY use the job submission ID to help identify\nwhich jmJobIndex was assigned by the agent, i.e., in which row\nthe job information is in the other tables.\n\nNOTE - fixed-length is used so that a management application\ncan use a shortened GetNext varbind (in SNMPv1 and SNMPv2) in\norder to get the next submission ID, disregarding the remainder\nof the ID in order to access jobs independent of the trailing\nidentifier part, e.g., to get all jobs submitted by a\nparticular jmJobOwner or submitted from a particular MAC\naddress.\n\nSee the JmJobSubmissionIDTypeTC textual convention.\nSee APPENDIX B - Support of Job Submission Protocols.")
jmJobIDJobSetIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobIDJobSetIndex.setDescription("This object contains the value of the jmGeneralJobSetIndex for\nthe job with the jmJobSubmissionID value, i.e., the job set\nindex of the job set in which the job was placed when that\nserver or device accepted the job.  This 16-bit value in\ncombination with the jmJobIDJobIndex value permits the\nmanagement application to access the other tables to obtain the\njob-specific objects for this job.\n\nSee jmGeneralJobSetIndex in the jmGeneralTable.")
jmJobIDJobIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobIDJobIndex.setDescription("This object contains the value of the jmJobIndex for the job\nwith the jmJobSubmissionID value, i.e., the job index for the\njob when the server or device accepted the job.  This value, in\ncombination with the jmJobIDJobSetIndex value, permits the\nmanagement application to access the other tables to obtain the\njob-specific objects for this job.\n\nSee jmJobIndex in the jmJobTable.")
jmJob = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3))
jmJobTable = MibTable((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1))
if mibBuilder.loadTexts: jmJobTable.setDescription("The jmJobTable consists of basic job state and status\ninformation for each job in a job set that (1) monitoring\napplications need to be able to access in a single SNMP Get\noperation, (2) that have a single value per job, and (3) that\nSHALL always be implemented.\n\nThe MANDATORY-GROUP macro specifies that this group is\nMANDATORY.")
jmJobEntry = MibTableRow((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1)).setIndexNames((0, "Job-Monitoring-MIB", "jmGeneralJobSetIndex"), (0, "Job-Monitoring-MIB", "jmJobIndex"))
if mibBuilder.loadTexts: jmJobEntry.setDescription("Basic per-job state and status information.\n\nAn entry SHALL exist in this table for each job, no matter what\nthe state of the job is.  Each job SHALL appear in one and only\none job set.\n\nSee Section 3.2 entitled 'The Job Tables'.")
jmJobIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: jmJobIndex.setDescription("The sequential, monatonically increasing identifier index for\nthe job generated by the server or device when that server or\ndevice accepted the job.  This index value permits the\nmanagement application to access the other tables to obtain the\njob-specific row entries.\n\nSee Section 3.2 entitled 'The Job Tables and the Oldest Active\nand Newest Active Indexes'.\nSee Section 3.5 entitled 'Job Identification'.\nSee also jmGeneralNewestActiveJobIndex for the largest value of\njmJobIndex.\nSee JmJobSubmissionIDTypeTC for a limit on the size of this\nindex if the agent represents it as an 8-digit decimal number.")
jmJobState = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 2), JmJobStateTC().clone('unknown')).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobState.setDescription("The current state of the job (pending, processing, completed,\netc.).  Agents SHALL implement only those states which are\nappropriate for the particular implementation.  However,\nmanagement applications SHALL be prepared to receive all the\nstandard job states.\n\nThe final value for this object SHALL be one of: completed,\ncanceled, or aborted.  The minimum length of time that the\nagent SHALL maintain MIB data for a job in the completed,\ncanceled, or aborted state before removing the job data from\nthe jmJobIDTable and jmJobTable is specified by the value of\nthe jmGeneralJobPersistence object.")
jmJobStateReasons1 = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 3), JmJobStateReasons1TC().clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobStateReasons1.setDescription("Additional information about the job's current state, i.e.,\ninformation that augments the value of the job's jmJobState\nobject.\n\nImplementation of any reason values is OPTIONAL, but an agent\nSHOULD return any reason information available.  These values\nMAY be used with any job state or states for which the reason\nmakes sense.  Since the Job State Reasons will be more dynamic\nthan the Job State, it is recommended that a job monitoring\napplication read this object every time jmJobState is read.\nWhen the agent cannot provide a reason for the current state of\nthe job, the value of the jmJobStateReasons1 object and\njobStateReasonsN attributes SHALL be 0.\n\nThe jobStateReasonsN (N=2..4) attributes provide further\nadditional information about the job's current state.")
jmNumberOfInterveningJobs = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmNumberOfInterveningJobs.setDescription("The number of jobs that are expected to complete processing\nbefore this job has completed processing according to the\nimplementation's queuing algorithm, if no other jobs were to be\nsubmitted.  In other words, this value is the job's queue\nposition.  The agent SHALL return a value of 0 for this\nattribute when the job is the next job to complete processing\n(or has completed processing).")
jmJobKOctetsPerCopyRequested = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(-2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobKOctetsPerCopyRequested.setDescription("The total size in K (1024) octets of the document(s) being\nrequested to be processed in the job.  The agent SHALL round\nthe actual number of octets up to the next highest K.  Thus 0\noctets is represented as '0', 1-1024 octets is represented as\n'1', 1025-2048 is represented as '2', etc.\n\nIn computing this value, the server/device SHALL NOT include\nthe multiplicative factors contributed by (1) the number of\ndocument copies, and (2) the number of job copies, independent\nof whether the device can process multiple copies of the job or\ndocument without making multiple passes over the job or\ndocument data and independent of whether the output is collated\nor not.  Thus the server/device computation is independent of\nthe implementation and indicates the size of the document(s)\nmeasured in K octets independent of the number of copies.")
jmJobKOctetsProcessed = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobKOctetsProcessed.setDescription("The total number of octets processed by the server or device\nmeasured in units of K (1024) octets so far.  The agent SHALL\nround the actual number of octets processed up to the next\nhigher K.  Thus 0 octets is represented as '0', 1-1024 octets\nis represented as '1', 1025-2048 octets is '2', etc.  For\nprinting devices, this value is the number interpreted by the\npage description language interpreter rather than what has been\nmarked on media.\n\nFor implementations where multiple copies are produced by the\ninterpreter with only a single pass over the data, the final\nvalue SHALL be equal to the value of the\njmJobKOctetsPerCopyRequested object.  For implementations where\nmultiple copies are produced by the interpreter by processing\nthe data for each copy, the final value SHALL be a multiple of\nthe value of the jmJobKOctetsPerCopyRequested object.\n\nNOTE - See the impressionsCompletedCurrentCopy and\npagesCompletedCurrentCopy attributes for attributes that are\nreset on each document copy.\n\nNOTE - The jmJobKOctetsProcessed object can be used with the\njmJobKOctetsPerCopyRequested object to provide an indication of\nthe relative progress of the job, provided that the\nmultiplicative factor is taken into account for some\nimplementations of multiple copies.")
jmJobImpressionsPerCopyRequested = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(-2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobImpressionsPerCopyRequested.setDescription("The total size in number of impressions of the document(s)\nsubmitted.\n\nIn computing this value, the server/device SHALL NOT include\nthe multiplicative factors contributed by (1) the number of\ndocument copies, and (2) the number of job copies, independent\nof whether the device can process multiple copies of the job or\ndocument without making multiple passes over the job or\ndocument data and independent of whether the output is collated\nor not.  Thus the server/device computation is independent of\nthe implementation and reflects the size of the document(s)\nmeasured in impressions independent of the number of copies.\n\nSee the definition of the term 'impression' in Section 2.")
jmJobImpressionsCompleted = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobImpressionsCompleted.setDescription("The total number of impressions completed for this job so far.\nFor printing devices, the impressions completed includes\ninterpreting, marking, and stacking the output.  For other\ntypes of job services, the number of impressions completed\nincludes the number of impressions processed.\n\nNOTE - See the impressionsCompletedCurrentCopy and\npagesCompletedCurrentCopy attributes for attributes that are\nreset on each document copy.\n\nNOTE - The jmJobImpressionsCompleted object can be used with\nthe jmJobImpressionsPerCopyRequested object to provide an\nindication of the relative progress of the job, provided that\nthe multiplicative factor is taken into account for some\nimplementations of multiple copies.\n\nSee the definition of the term 'impression' in Section 2 and\nthe counting example in Section 3.4 entitled 'Monitoring Job\nProgress'.")
jmJobOwner = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 3, 1, 1, 9), JmJobStringTC().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63)).clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmJobOwner.setDescription("The coded character set name of the user that submitted the\njob.  The method of assigning this user name will be system\nand/or site specific but the method MUST ensure that the name\nis unique to the network that is visible to the client and\ntarget device.\n\nThis value SHOULD be the most authenticated name of the user\nsubmitting the job.\n\nSee the OBJECT compliance macro for the minimum maximum length\nrequired for conformance.")
jmAttribute = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4))
jmAttributeTable = MibTable((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1))
if mibBuilder.loadTexts: jmAttributeTable.setDescription("The jmAttributeTable SHALL contain attributes of the job and\ndocument(s) for each job in a job set.  Instead of allocating\ndistinct objects for each attribute, each attribute is\nrepresented as a separate row in the jmAttributeTable.\n\nThe MANDATORY-GROUP macro specifies that this group is\nMANDATORY.  An agent SHALL implement any attribute if (1) the\nserver or device supports the functionality represented by the\nattribute and (2) the information is available to the agent. ")
jmAttributeEntry = MibTableRow((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1, 1)).setIndexNames((0, "Job-Monitoring-MIB", "jmGeneralJobSetIndex"), (0, "Job-Monitoring-MIB", "jmJobIndex"), (0, "Job-Monitoring-MIB", "jmAttributeTypeIndex"), (0, "Job-Monitoring-MIB", "jmAttributeInstanceIndex"))
if mibBuilder.loadTexts: jmAttributeEntry.setDescription("Attributes representing information about the job and\ndocument(s) or resources required and/or consumed.\n\nEach entry in the jmAttributeTable is a per-job entry with an\nextra index for each type of attribute (jmAttributeTypeIndex)\nthat a job can have and an additional index\n(jmAttributeInstanceIndex) for those attributes that can have\nmultiple instances per job.  The jmAttributeTypeIndex object\nSHALL contain an enum type that indicates the type of attribute\n(see the JmAttributeTypeTC textual-convention).  The value of\nthe attribute SHALL be represented in either the\njmAttributeValueAsInteger or jmAttributeValueAsOctets objects,\nand/or both, as specified in the JmAttributeTypeTC textual-\nconvention.\n\nThe agent SHALL create rows in the jmAttributeTable as the\nserver or device is able to discover the attributes either from\nthe job submission protocol itself or from the document PDL.\nAs the documents are interpreted, the interpreter MAY discover\nadditional attributes and so the agent adds additional rows to\nthis table.  As the attributes that represent resources are\nactually consumed, the usage counter contained in the\njmAttributeValueAsInteger object is incremented according to\nthe units indicated in the description of the JmAttributeTypeTC\nenum.\n\nThe agent SHALL maintain each row in the jmAttributeTable for\nat least the minimum time after a job completes as specified by\nthe jmGeneralAttributePersistence object.\n\nZero or more entries SHALL exist in this table for each job in\na job set.\n\nSee Section 3.3 entitled 'The Attribute Mechanism' for a\ndescription of the jmAttributeTable.")
jmAttributeTypeIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1, 1, 1), JmAttributeTypeTC()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: jmAttributeTypeIndex.setDescription("The type of attribute that this row entry represents.\n\nThe type MAY identify information about the job or document(s)\nor MAY identify a resource required to process the job before\nthe job start processing and/or consumed by the job as the job\nis processed.\n\nExamples of job attributes (i.e., apply to the job as a whole)\nthat have only one instance per job include:\njobCopiesRequested(90), documentCopiesRequested(92),\njobCopiesCompleted(91), documentCopiesCompleted(93), while\nexamples of job attributes that may have more than one instance\nper job include:  documentFormatIndex(37), and\ndocumentFormat(38).\n\nExamples of document attributes (one instance per document)\ninclude: fileName(34), and documentName(35).\n\nExamples of required and consumed resource attributes include:\npagesRequested(130), mediumRequested(170), pagesCompleted(131),\nand mediumConsumed(171), respectively.")
jmAttributeInstanceIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32767))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: jmAttributeInstanceIndex.setDescription("A running 16-bit index of the attributes of the same type for\neach job.  For those attributes with only a single instance per\njob, this index value SHALL be 1.  For those attributes that\nare a single value per document, the index value SHALL be the\ndocument number, starting with 1 for the first document in the\njob.  Jobs with only a single document SHALL use the index\nvalue of 1.  For those attributes that can have multiple values\nper job or per document, such as documentFormatIndex(37) or\ndocumentFormat(38), the index SHALL be a running index for the\njob as a whole, starting at 1.")
jmAttributeValueAsInteger = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2, 2147483647L)).clone(-2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmAttributeValueAsInteger.setDescription("The integer value of the attribute.  The value of the\nattribute SHALL be represented as an integer if the enum\ndescription in the JmAttributeTypeTC textual-convention\ndefinition has the tag: 'INTEGER:'.\n\nDepending on the enum definition, this object value MAY be an\ninteger, a counter, an index, or an enum, depending on the\njmAttributeTypeIndex value.  The units of this value are\nspecified in the enum description.\n\nFor those attributes that are accumulating job consumption as\nthe job is processed as specified in the JmAttributeTypeTC\ntextual-convention, SHALL contain the final value after the job\ncompletes processing, i.e., this value SHALL indicate the total\nusage of this resource made by the job.\n\nA monitoring application is able to copy this value to a\nsuitable longer term storage for later processing as part of an\naccounting system.\n\nSince the agent MAY add attributes representing resources to\nthis table while the job is waiting to be processed or being\nprocessed, which can be a long time before any of the resources\nare actually used, the agent SHALL set the value of the\njmAttributeValueAsInteger object to 0 for resources that the\njob has not yet consumed.\n\nAttributes for which the concept of an integer value is\nmeaningless, such as fileName(34), jobName, and\nprocessingMessage, do not have the 'INTEGER:' tag in the\nJmAttributeTypeTC definition and so an agent SHALL always\nreturn a value of '-1' to indicate 'other' for the value of the\njmAttributeValueAsInteger object for these attributes.\n\nFor attributes which do have the 'INTEGER:' tag in the\nJmAttributeTypeTC definition, if the integer value is not (yet)\nknown, the agent either (1) SHALL not materialize the row in\nthe jmAttributeTable until the value is known or (2) SHALL\nreturn a '-2' to represent an 'unknown' counting integer value,\na '0' to represent an 'unknown' index value, and a '2' to\nrepresent an 'unknown(2)' enum value.")
jmAttributeValueAsOctets = MibTableColumn((1, 3, 6, 1, 4, 1, 2699, 1, 1, 1, 4, 1, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63)).clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: jmAttributeValueAsOctets.setDescription("The octet string value of the attribute.  The value of the\nattribute SHALL be represented as an OCTET STRING if the enum\ndescription in the JmAttributeTypeTC textual-convention\ndefinition has the tag: 'OCTETS:'.\n\nDepending on the enum definition, this object value MAY be a\ncoded character set string (text), such as 'JmUTF8StringTC', or\na binary octet string, such as 'DateAndTime'.\n\nAttributes for which the concept of an octet string value is\nmeaningless, such as pagesCompleted, do not have the tag\n'OCTETS:' in the JmAttributeTypeTC definition and so the agent\nSHALL always return a zero length string for the value of the\njmAttributeValueAsOctets object.\n\nFor attributes which do have the 'OCTETS:' tag in the\nJmAttributeTypeTC definition, if the OCTET STRING value is not\n(yet) known, the agent either SHALL NOT materialize the row in\nthe jmAttributeTable until the value is known or SHALL return a\nzero-length string.")
jobmonMIBNotifications = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 2))
jmMIBConformance = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3))
jmMIBGroups = MibIdentifier((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3, 2))

# Augmentions

# Groups

jmJobIDGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3, 2, 2)).setObjects(("Job-Monitoring-MIB", "jmJobIDJobSetIndex"), ("Job-Monitoring-MIB", "jmJobIDJobIndex"), )
jmJobGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3, 2, 3)).setObjects(("Job-Monitoring-MIB", "jmJobImpressionsCompleted"), ("Job-Monitoring-MIB", "jmJobImpressionsPerCopyRequested"), ("Job-Monitoring-MIB", "jmNumberOfInterveningJobs"), ("Job-Monitoring-MIB", "jmJobKOctetsProcessed"), ("Job-Monitoring-MIB", "jmJobStateReasons1"), ("Job-Monitoring-MIB", "jmJobOwner"), ("Job-Monitoring-MIB", "jmJobKOctetsPerCopyRequested"), ("Job-Monitoring-MIB", "jmJobState"), )
jmGeneralGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3, 2, 1)).setObjects(("Job-Monitoring-MIB", "jmGeneralJobPersistence"), ("Job-Monitoring-MIB", "jmGeneralJobSetName"), ("Job-Monitoring-MIB", "jmGeneralOldestActiveJobIndex"), ("Job-Monitoring-MIB", "jmGeneralNumberOfActiveJobs"), ("Job-Monitoring-MIB", "jmGeneralAttributePersistence"), ("Job-Monitoring-MIB", "jmGeneralNewestActiveJobIndex"), )
jmAttributeGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 2699, 1, 1, 3, 2, 4)).setObjects(("Job-Monitoring-MIB", "jmAttributeValueAsOctets"), ("Job-Monitoring-MIB", "jmAttributeValueAsInteger"), )

# Exports

# Module identity
mibBuilder.exportSymbols("Job-Monitoring-MIB", PYSNMP_MODULE_ID=jobmonMIB)

# Types
mibBuilder.exportSymbols("Job-Monitoring-MIB", JmAttributeTypeTC=JmAttributeTypeTC, JmBooleanTC=JmBooleanTC, JmFinishingTC=JmFinishingTC, JmJobCollationTypeTC=JmJobCollationTypeTC, JmJobServiceTypesTC=JmJobServiceTypesTC, JmJobSourcePlatformTypeTC=JmJobSourcePlatformTypeTC, JmJobStateReasons1TC=JmJobStateReasons1TC, JmJobStateReasons2TC=JmJobStateReasons2TC, JmJobStateReasons3TC=JmJobStateReasons3TC, JmJobStateReasons4TC=JmJobStateReasons4TC, JmJobStateTC=JmJobStateTC, JmJobStringTC=JmJobStringTC, JmJobSubmissionIDTypeTC=JmJobSubmissionIDTypeTC, JmMediumTypeTC=JmMediumTypeTC, JmNaturalLanguageTagTC=JmNaturalLanguageTagTC, JmPrintQualityTC=JmPrintQualityTC, JmPrinterResolutionTC=JmPrinterResolutionTC, JmTimeStampTC=JmTimeStampTC, JmTonerEconomyTC=JmTonerEconomyTC, JmUTF8StringTC=JmUTF8StringTC)

# Objects
mibBuilder.exportSymbols("Job-Monitoring-MIB", jobmonMIB=jobmonMIB, jobmonMIBObjects=jobmonMIBObjects, jmGeneral=jmGeneral, jmGeneralTable=jmGeneralTable, jmGeneralEntry=jmGeneralEntry, jmGeneralJobSetIndex=jmGeneralJobSetIndex, jmGeneralNumberOfActiveJobs=jmGeneralNumberOfActiveJobs, jmGeneralOldestActiveJobIndex=jmGeneralOldestActiveJobIndex, jmGeneralNewestActiveJobIndex=jmGeneralNewestActiveJobIndex, jmGeneralJobPersistence=jmGeneralJobPersistence, jmGeneralAttributePersistence=jmGeneralAttributePersistence, jmGeneralJobSetName=jmGeneralJobSetName, jmJobID=jmJobID, jmJobIDTable=jmJobIDTable, jmJobIDEntry=jmJobIDEntry, jmJobSubmissionID=jmJobSubmissionID, jmJobIDJobSetIndex=jmJobIDJobSetIndex, jmJobIDJobIndex=jmJobIDJobIndex, jmJob=jmJob, jmJobTable=jmJobTable, jmJobEntry=jmJobEntry, jmJobIndex=jmJobIndex, jmJobState=jmJobState, jmJobStateReasons1=jmJobStateReasons1, jmNumberOfInterveningJobs=jmNumberOfInterveningJobs, jmJobKOctetsPerCopyRequested=jmJobKOctetsPerCopyRequested, jmJobKOctetsProcessed=jmJobKOctetsProcessed, jmJobImpressionsPerCopyRequested=jmJobImpressionsPerCopyRequested, jmJobImpressionsCompleted=jmJobImpressionsCompleted, jmJobOwner=jmJobOwner, jmAttribute=jmAttribute, jmAttributeTable=jmAttributeTable, jmAttributeEntry=jmAttributeEntry, jmAttributeTypeIndex=jmAttributeTypeIndex, jmAttributeInstanceIndex=jmAttributeInstanceIndex, jmAttributeValueAsInteger=jmAttributeValueAsInteger, jmAttributeValueAsOctets=jmAttributeValueAsOctets, jobmonMIBNotifications=jobmonMIBNotifications, jmMIBConformance=jmMIBConformance, jmMIBGroups=jmMIBGroups)

# Groups
mibBuilder.exportSymbols("Job-Monitoring-MIB", jmJobIDGroup=jmJobIDGroup, jmJobGroup=jmJobGroup, jmGeneralGroup=jmGeneralGroup, jmAttributeGroup=jmAttributeGroup)
