# PySNMP SMI module. Autogenerated from smidump -f python MALLOC-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:27 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAmallocRangeSource, IANAscopeSource, ) = mibBuilder.importSymbols("IANA-MALLOC-MIB", "IANAmallocRangeSource", "IANAscopeSource")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( LanguageTag, ) = mibBuilder.importSymbols("IPMROUTE-STD-MIB", "LanguageTag")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TruthValue")

# Objects

mallocMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 101)).setRevisions(("2003-06-09 00:00",))
if mibBuilder.loadTexts: mallocMIB.setOrganization("IETF MALLOC Working Group")
if mibBuilder.loadTexts: mallocMIB.setContactInfo(" WG-EMail:   malloc@catarina.usc.edu\nSubscribe:  malloc-request@catarina.usc.edu\nArchive:    catarina.usc.edu/pub/multicast/malloc/\n\nCo-chair/editor:\nDave Thaler\nMicrosoft Corporation\nOne Microsoft Way\nRedmond, WA 98052\nEMail: dthaler@microsoft.com\n\nCo-chair:\nSteve Hanna\nSun Microsystems, Inc.\nOne Network Drive\nBurlington, MA 01803\nEMail: steve.hanna@sun.com")
if mibBuilder.loadTexts: mallocMIB.setDescription("The MIB module for management of multicast address\nallocation.\n\nCopyright (C) The Internet Society (2003).  This version of\nthis MIB module is part of RFC 3559; see the RFC itself for\nfull legal notices.")
mallocMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1))
malloc = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1, 1))
mallocCapabilities = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("startTime", 0), ("serverMobility", 1), ("retryAfter", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocCapabilities.setDescription("This object describes the capabilities which a client or\nserver supports.  The startTime bit indicates that\nallocations with a future start time are supported.  The\nserverMobility bit indicates that allocations can be renewed\nor released from a server other than the one granting the\noriginal allocation.  The retryAfter bit indicates support\nfor a waiting state where the client may check back at a\nlater time to get the status of its request.")
mallocScopeTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 2))
if mibBuilder.loadTexts: mallocScopeTable.setDescription("The (conceptual) table containing information on multicast\nscopes from which addresses may be allocated.  Entries in\nthis table may be dynamically discovered via some other\n\n\n\nprotocol, such as MZAP, or may be statically configured,\nsuch as in an isolated network environment.  Each scope is\nassociated with a range of multicast addresses, and ranges\nfor different rows must be disjoint.")
mallocScopeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1)).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"))
if mibBuilder.loadTexts: mallocScopeEntry.setDescription("An entry (conceptual row) containing the information on a\nparticular multicast scope.")
mallocScopeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocScopeAddressType.setDescription("The type of the addresses in the multicast scope range.\nLegal values correspond to the subset of address families\nfor which multicast address allocation is supported.")
mallocScopeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 20))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocScopeFirstAddress.setDescription("The first address in the multicast scope range.  The type\nof this address is determined by the value of the\nmallocScopeAddressType object.")
mallocScopeLastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 20))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeLastAddress.setDescription("The last address in the multicast scope range.  The type of\nthis address is determined by the value of the\nmallocScopeAddressType object.")
mallocScopeHopLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(255)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeHopLimit.setDescription("The default IPv4 TTL or IPv6 hop limit which applications\nshould use for groups within the scope.")
mallocScopeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeStatus.setDescription("The status of this row, by which new entries may be\ncreated, or old entries deleted from this table.  If write\naccess is supported, the other writable objects in this\ntable may be modified even while the status is `active'.")
mallocScopeSource = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 6), IANAscopeSource()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocScopeSource.setDescription("The method by which this entry was learned.")
mallocScopeDivisible = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 7), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeDivisible.setDescription("If false, the server may allocate addresses out of the\nentire range.  If true, the server must not allocate\n\n\n\naddresses out of the entire range, but may only allocate\naddresses out of a subrange learned via another method.\nCreating or deleting a scope which is not divisible has the\nside effect of creating or deleting the corresponding entry\nin the mallocAllocRangeTable.  Deleting a scope which is\ndivisible has the side effect of deleting any corresponding\nentries in the mallocAllocRangeTable, and the\nmallocRequestTable.")
mallocScopeServerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 8), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeServerAddressType.setDescription("The type of the address of a multicast address allocation\nserver to which a request may be sent.")
mallocScopeServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 9), InetAddress().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeServerAddress.setDescription("The address of a multicast address allocation server to\nwhich a request may be sent.  The default value is an zero-\nlength address, indicating that no server is known.  The\ntype of this address is determined by the value of the\nmallocScopeServerAddressType object.")
mallocScopeSSM = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 10), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeSSM.setDescription("Indicates whether the scope is a Source-Specific Multicast\n(SSM) range.")
mallocScopeStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to\nany columnar objects in the row.")
mallocScopeNameTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 3))
if mibBuilder.loadTexts: mallocScopeNameTable.setDescription("The (conceptual) table containing information on multicast\nscope names.  Entries in this table may be dynamically\ndiscovered via some other protocol, such as MZAP, or may be\nstatically configured, such as in an isolated network\nenvironment.")
mallocScopeNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1)).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"), (1, "MALLOC-MIB", "mallocScopeNameLangName"))
if mibBuilder.loadTexts: mallocScopeNameEntry.setDescription("An entry (conceptual row) containing the information on a\nparticular multicast scope name.")
mallocScopeNameLangName = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 1), LanguageTag().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 94))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocScopeNameLangName.setDescription("The RFC 3066 language tag for the language of the scope\nname.")
mallocScopeNameScopeName = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameScopeName.setDescription("The textual name associated with the multicast scope.  The\nvalue of this object should be suitable for displaying to\nend-users, such as when allocating a multicast address in\nthis scope.  If the scope is an IPv4 scope, and no name is\nspecified, the default value of this object should be the\nstring 239.x.x.x/y with x and y replaced appropriately to\ndescribe the address and mask length associated with the\nscope.  If the scope is an IPv6 scope, and no name is\nspecified, the default value of this object should\ngenerically describe the scope level (e.g., site).")
mallocScopeNameDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 3), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameDefault.setDescription("If true, indicates a preference that the name in the\nassociated language should be used by applications if no\nname is available in a desired language.")
mallocScopeNameStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameStatus.setDescription("The status of this row, by which new entries may be\ncreated, or old entries deleted from this table.  If write\naccess is supported, the other writable objects in this\ntable may be modified even while the status is `active'.")
mallocScopeNameStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to\nany columnar objects in the row.")
mallocAllocRangeTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 4))
if mibBuilder.loadTexts: mallocAllocRangeTable.setDescription("The (conceptual) table containing information on subranges\nof addresses from which the device may allocate addresses,\nif it is a MAAS.  If the device is a Prefix Coordinator, any\nranges which the device is advertising to MAAS's will be in\nthis table.  Note that the device may be both a MAAS and a\nPrefix Coordinator.\n\nAddress ranges for different rows must be disjoint, and must\nbe contained with the address range of the corresponding row\nof the mallocScopeTable.\n\nDeleting an allocation range has the side effect of deleting\nany entries within that range from the mallocAddressTable.")
mallocAllocRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1)).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"), (0, "MALLOC-MIB", "mallocAllocRangeFirstAddress"))
if mibBuilder.loadTexts: mallocAllocRangeEntry.setDescription("An entry (conceptual row) containing the information on a\nparticular allocation range.")
mallocAllocRangeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 1), InetAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 20))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocAllocRangeFirstAddress.setDescription("The first address in the allocation range.  The type of\nthis address is determined by the value of the\nmallocScopeAddressType object.")
mallocAllocRangeLastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 20))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeLastAddress.setDescription("The last address in the allocation range.  The type of this\naddress is determined by the value of the\nmallocScopeAddressType object.")
mallocAllocRangeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeStatus.setDescription("The status of this row, by which new entries may be\ncreated, or old entries deleted from this table.  If write\naccess is supported, the other writable objects in this\ntable may be modified even while the status is `active'.")
mallocAllocRangeSource = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 4), IANAmallocRangeSource()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeSource.setDescription("The means by which this entry was learned.")
mallocAllocRangeLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 5), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeLifetime.setDescription("The number of seconds remaining in the lifetime of the\n(sub)range out of which addresses are being allocated.  A\nvalue of 0 indicates that the range is not subject to\naging.")
mallocAllocRangeMaxLeaseAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 6), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeMaxLeaseAddrs.setDescription("The maximum number of addresses which the server is willing\nto grant for each future request in this range.  A value of\n0 means that no specific limit is enforced, as long as the\nserver has valid addresses to allocate.")
mallocAllocRangeMaxLeaseTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 7), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeMaxLeaseTime.setDescription("The maximum lifetime which the server will grant for future\nrequests in this range.  A value of 0 means that no\nadditional limit is enforced beyond that of\nmallocAllocRangeLifetime.")
mallocAllocRangeNumAllocatedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumAllocatedAddrs.setDescription("The number of addresses in the range which have been\nallocated.  This value can be used to determine the current\naddress space utilization within the scoped range.  This\n\n\n\nshould match the total number of addresses for this scope\ncovered by entries in the mallocAddressTable.")
mallocAllocRangeNumOfferedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumOfferedAddrs.setDescription("The number of addresses in the range which have been\noffered.  This number should match the sum of\nmallocRequestNumAddrs for all entries in the\nmallocRequestTable in the offered state.  Together with\nmallocAllocRangeNumAllocatedAddrs and\nmallocAllocRangeNumTryingAddrs, this can be used to\ndetermine the address space utilization within the scoped\nrange in the immediate future.")
mallocAllocRangeNumWaitingAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumWaitingAddrs.setDescription("The number of addresses in the range which have been\nrequested, but whose state is waiting, while the server\nattempts to acquire more address space.")
mallocAllocRangeNumTryingAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumTryingAddrs.setDescription("The number of addresses in the scope covered by entries in\nthe mallocRequestTable in the trying state.")
mallocAllocRangeAdvertisable = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 12), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeAdvertisable.setDescription("The value of this object is true if the range is eligible\nto be advertised to other MAASs.  When the row is first\ncreated, the default value of this object is true if the\nscope is divisible, and is false otherwise.")
mallocAllocRangeTotalAllocatedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeTotalAllocatedAddrs.setDescription("The approximate number of addresses in the range which have\nbeen allocated by any MAAS, as determined by a Prefix\nCoordinator.  This object need only be present if\nmallocAllocRangeAdvertisable is true.  If the number is\nunknown, a value of 0 may be reported.")
mallocAllocRangeTotalRequestedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeTotalRequestedAddrs.setDescription("The approximate number of addresses in the range for which\nthere is potential demand among MAASs, as determined by a\nPrefix Coordinator.  This object need only be present if\nmallocAllocRangeAdvertisable is true.  If the number is\nunknown, a value of 0 may be reported.")
mallocAllocRangeStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 15), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to\nany columnar objects in the row.")
mallocRequestTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 5))
if mibBuilder.loadTexts: mallocRequestTable.setDescription("The (conceptual) table containing information on allocation\nrequests, whether allocated or in progress.  This table may\nalso be used to determine which clients are responsible for\nhigh address space utilization within a given scope.\n\n\n\nEntries in this table reflect requests dynamically received\nby an address allocation protocol.")
mallocRequestEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1)).setIndexNames((0, "MALLOC-MIB", "mallocRequestId"))
if mibBuilder.loadTexts: mallocRequestEntry.setDescription("An entry (conceptual row) containing the information on a\nparticular allocation request.")
mallocRequestId = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocRequestId.setDescription("An arbitrary value identifying this row.")
mallocRequestScopeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestScopeAddressType.setDescription("The type of the first address of the scope to which the\nrequest applies.  Legal values correspond to the subset of\naddress families for which multicast address allocation is\nsupported.")
mallocRequestScopeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestScopeFirstAddress.setDescription("The first address of the scope to which the request\napplies.  This must match mallocScopeFirstAddress for some\nrow in the mallocScopeTable.  The type of this address is\ndetermined by the value of the mallocRequestScopeAddressType\nobject.")
mallocRequestStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestStartTime.setDescription("The number of seconds remaining before the start time of\nthe request.  A value of 0 means that the allocation is\ncurrently in effect.")
mallocRequestEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestEndTime.setDescription("The number of seconds remaining before the end time of the\nrequest.")
mallocRequestNumAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestNumAddrs.setDescription("The number of addresses requested.  If the addresses have\nbeen allocated, this number should match the total number of\naddresses for this request covered by entries in the\nmallocAddressTable.")
mallocRequestState = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("allocated", 1), ("offered", 2), ("waiting", 3), ("trying", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestState.setDescription("The state of the request.  A value of allocated(1)\nindicates that one or more entries for this request are\npresent in the mallocAddressTable.  A value of offered(2)\nindicates that addresses have been offered to the client\n(e.g. via a MADCAP OFFER message), but the allocation has\nnot been committed.  A value of waiting(3) indicates that\nthe allocation is blocked while the server attempts to\nacquire more space from which it can allocate addresses.  A\nvalue of trying(4) means that no addresses have been offered\nto the client, but that an attempt to allocate is in\nprogress.")
mallocRequestClientAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 8), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestClientAddressType.setDescription("The type of the address of the client that (last) requested\nthis allocation.")
mallocRequestClientAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 9), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestClientAddress.setDescription("The address of the client that (last) requested this\nallocation.  The type of this address is determined by the\nvalue of the mallocRequestClientAddressType object.")
mallocRequestServerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 10), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestServerAddressType.setDescription("The type of the address of the server to which the request\nwas (last) sent.")
mallocRequestServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 11), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestServerAddress.setDescription("The address of the server to which the request was (last)\nsent.  The type of this address is determined by the value\nof the mallocRequestServerAddressType object.")
mallocRequestLeaseIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 12), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestLeaseIdentifier.setDescription("The Lease Identifier of this request.  If the allocation\nmechanism in use does not use Lease Identifiers, then the\nvalue is a 0-length string.")
mallocAddressTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 6))
if mibBuilder.loadTexts: mallocAddressTable.setDescription("The (conceptual) table containing information on blocks of\nallocated addresses.  This table may be used to map a given\nmulticast group address to the associated request.")
mallocAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1)).setIndexNames((0, "MALLOC-MIB", "mallocAddressAddressType"), (0, "MALLOC-MIB", "mallocAddressFirstAddress"))
if mibBuilder.loadTexts: mallocAddressEntry.setDescription("An entry (conceptual row) containing the information on a\nparticular block of allocated addresses.  The block of\naddresses covered by each entry in this table must fall\nwithin a range corresponding to an entry in the\nmallocAllocRangeTable.")
mallocAddressAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocAddressAddressType.setDescription("The type of the first address in the allocated block.\nLegal values correspond to the subset of address families\nfor which multicast address allocation is supported.")
mallocAddressFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 20))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mallocAddressFirstAddress.setDescription("The first address in the allocated block.  The type of this\naddress is determined by the value of the\nmallocAddressAddressType object.")
mallocAddressNumAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAddressNumAddrs.setDescription("The number of addresses in the allocated block.")
mallocAddressRequestId = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAddressRequestId.setDescription("The index of the request which caused this block of\naddresses to be allocated.  This value must match the value\nof mallocRequestId for some entry in the\nmallocRequestTable.")
madcap = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1, 2))
madcapConfig = ObjectIdentity((1, 3, 6, 1, 2, 1, 101, 1, 2, 1))
if mibBuilder.loadTexts: madcapConfig.setDescription("Group of objects that count various MADCAP events.")
madcapConfigExtraAllocationTime = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 1), Unsigned32()).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: madcapConfigExtraAllocationTime.setDescription("The amount of extra time on either side of a lease which\nthe MADCAP server allocates to allow for clock skew among\nclients.")
madcapConfigNoResponseDelay = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 2), Unsigned32()).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: madcapConfigNoResponseDelay.setDescription("The amount of time the MADCAP client allows for receiving a\nresponse from a MADCAP server.")
madcapConfigOfferHold = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 3), Unsigned32()).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: madcapConfigOfferHold.setDescription("The amount of time the MADCAP server will reserve an\naddress for after sending an OFFER message in anticipation\nof receiving a REQUEST message.")
madcapConfigResponseCacheInterval = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 300))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: madcapConfigResponseCacheInterval.setDescription("The amount of time the MADCAP server uses to detect\nduplicate messages.")
madcapConfigClockSkewAllowance = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: madcapConfigClockSkewAllowance.setDescription("The clock skew threshold used by the MADCAP server to\ngenerate Excessive Clock Skew errors.")
madcapCounters = ObjectIdentity((1, 3, 6, 1, 2, 1, 101, 1, 2, 2))
if mibBuilder.loadTexts: madcapCounters.setDescription("A group of objects that count various MADCAP events.")
madcapTotalErrors = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapTotalErrors.setDescription("The total number of transactions for which the MADCAP\nserver has detected an error of any type, regardless of\nwhether the server ignored the request or generated a NAK.")
madcapRequestsDenied = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRequestsDenied.setDescription("The number of valid requests for which the MADCAP server\ncould not complete an allocation, regardless of whether NAKs\nwere sent.  This corresponds to the Valid Request Could Not\nBe Completed error code in MADCAP.")
madcapInvalidRequests = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapInvalidRequests.setDescription("The number of invalid requests received by the MADCAP\nserver, regardless of whether NAKs were sent.  This\ncorresponds to the Invalid Request error code in MADCAP.")
madcapExcessiveClockSkews = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapExcessiveClockSkews.setDescription("The number of requests received by the MADCAP server with\nan excessive clock skew, regardless of whether NAKs were\nsent.  This corresponds to the Excessive Clock Skew error\ncode in MADCAP.")
madcapBadLeaseIds = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapBadLeaseIds.setDescription("The number of requests received by the MADCAP server with\nan unrecognized Lease Identifier, regardless of whether NAKs\nwere sent.  This corresponds to the Lease Identifier Not\nRecognized error code in MADCAP.")
madcapDiscovers = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapDiscovers.setDescription("The number of DISCOVER messages received by the MADCAP\nserver.")
madcapInforms = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapInforms.setDescription("The number of INFORM messages received by the MADCAP\nserver.")
madcapRequests = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRequests.setDescription("The number of REQUEST messages received by the MADCAP\nserver.")
madcapRenews = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRenews.setDescription("The number of RENEW messages received by the MADCAP\nserver.")
madcapReleases = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapReleases.setDescription("The number of RELEASE messages received by the MADCAP\nserver.")
mallocConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2))
mallocCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2, 1))
mallocGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2, 2))

# Augmentions

# Groups

mallocServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 2)).setObjects(("MALLOC-MIB", "mallocAllocRangeMaxLeaseTime"), ("MALLOC-MIB", "mallocScopeHopLimit"), ("MALLOC-MIB", "mallocScopeStorage"), ("MALLOC-MIB", "mallocRequestClientAddressType"), ("MALLOC-MIB", "mallocAllocRangeStorage"), ("MALLOC-MIB", "mallocAllocRangeMaxLeaseAddrs"), ("MALLOC-MIB", "mallocScopeNameScopeName"), ("MALLOC-MIB", "mallocAllocRangeNumOfferedAddrs"), ("MALLOC-MIB", "mallocAllocRangeLifetime"), ("MALLOC-MIB", "mallocAllocRangeNumTryingAddrs"), ("MALLOC-MIB", "mallocAllocRangeNumAllocatedAddrs"), ("MALLOC-MIB", "mallocScopeNameDefault"), ("MALLOC-MIB", "mallocAllocRangeNumWaitingAddrs"), ("MALLOC-MIB", "mallocScopeNameStorage"), ("MALLOC-MIB", "mallocAllocRangeLastAddress"), ("MALLOC-MIB", "mallocAllocRangeStatus"), ("MALLOC-MIB", "mallocScopeSSM"), ("MALLOC-MIB", "mallocScopeStatus"), ("MALLOC-MIB", "mallocAllocRangeSource"), ("MALLOC-MIB", "mallocScopeNameStatus"), ("MALLOC-MIB", "mallocScopeDivisible"), ("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocRequestClientAddress"), ("MALLOC-MIB", "mallocScopeSource"), )
madcapServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 4)).setObjects(("MALLOC-MIB", "madcapRenews"), ("MALLOC-MIB", "madcapConfigOfferHold"), ("MALLOC-MIB", "madcapReleases"), ("MALLOC-MIB", "madcapInforms"), ("MALLOC-MIB", "madcapTotalErrors"), ("MALLOC-MIB", "madcapDiscovers"), ("MALLOC-MIB", "madcapConfigExtraAllocationTime"), ("MALLOC-MIB", "madcapExcessiveClockSkews"), ("MALLOC-MIB", "madcapConfigClockSkewAllowance"), ("MALLOC-MIB", "madcapRequestsDenied"), ("MALLOC-MIB", "madcapRequests"), ("MALLOC-MIB", "madcapInvalidRequests"), ("MALLOC-MIB", "madcapConfigResponseCacheInterval"), ("MALLOC-MIB", "madcapBadLeaseIds"), )
mallocClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 3)).setObjects(("MALLOC-MIB", "mallocRequestServerAddressType"), ("MALLOC-MIB", "mallocRequestServerAddress"), )
madcapClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 5)).setObjects(("MALLOC-MIB", "mallocRequestLeaseIdentifier"), ("MALLOC-MIB", "madcapConfigNoResponseDelay"), )
mallocPrefixCoordinatorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 7)).setObjects(("MALLOC-MIB", "mallocAllocRangeAdvertisable"), ("MALLOC-MIB", "mallocAllocRangeLastAddress"), ("MALLOC-MIB", "mallocAllocRangeStatus"), ("MALLOC-MIB", "mallocAllocRangeSource"), ("MALLOC-MIB", "mallocAllocRangeLifetime"), ("MALLOC-MIB", "mallocScopeDivisible"), ("MALLOC-MIB", "mallocAllocRangeStorage"), ("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocAllocRangeTotalAllocatedAddrs"), ("MALLOC-MIB", "mallocAllocRangeTotalRequestedAddrs"), ("MALLOC-MIB", "mallocScopeSource"), )
mallocClientScopeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 6)).setObjects(("MALLOC-MIB", "mallocScopeStorage"), ("MALLOC-MIB", "mallocScopeHopLimit"), ("MALLOC-MIB", "mallocScopeNameStatus"), ("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocScopeNameDefault"), ("MALLOC-MIB", "mallocScopeServerAddress"), ("MALLOC-MIB", "mallocScopeNameStorage"), ("MALLOC-MIB", "mallocScopeSSM"), ("MALLOC-MIB", "mallocScopeNameScopeName"), ("MALLOC-MIB", "mallocScopeStatus"), ("MALLOC-MIB", "mallocScopeSource"), ("MALLOC-MIB", "mallocScopeServerAddressType"), )
mallocBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 1)).setObjects(("MALLOC-MIB", "mallocRequestScopeFirstAddress"), ("MALLOC-MIB", "mallocAddressRequestId"), ("MALLOC-MIB", "mallocRequestScopeAddressType"), ("MALLOC-MIB", "mallocAddressNumAddrs"), ("MALLOC-MIB", "mallocRequestStartTime"), ("MALLOC-MIB", "mallocRequestState"), ("MALLOC-MIB", "mallocRequestNumAddrs"), ("MALLOC-MIB", "mallocCapabilities"), ("MALLOC-MIB", "mallocRequestEndTime"), )

# Exports

# Module identity
mibBuilder.exportSymbols("MALLOC-MIB", PYSNMP_MODULE_ID=mallocMIB)

# Objects
mibBuilder.exportSymbols("MALLOC-MIB", mallocMIB=mallocMIB, mallocMIBObjects=mallocMIBObjects, malloc=malloc, mallocCapabilities=mallocCapabilities, mallocScopeTable=mallocScopeTable, mallocScopeEntry=mallocScopeEntry, mallocScopeAddressType=mallocScopeAddressType, mallocScopeFirstAddress=mallocScopeFirstAddress, mallocScopeLastAddress=mallocScopeLastAddress, mallocScopeHopLimit=mallocScopeHopLimit, mallocScopeStatus=mallocScopeStatus, mallocScopeSource=mallocScopeSource, mallocScopeDivisible=mallocScopeDivisible, mallocScopeServerAddressType=mallocScopeServerAddressType, mallocScopeServerAddress=mallocScopeServerAddress, mallocScopeSSM=mallocScopeSSM, mallocScopeStorage=mallocScopeStorage, mallocScopeNameTable=mallocScopeNameTable, mallocScopeNameEntry=mallocScopeNameEntry, mallocScopeNameLangName=mallocScopeNameLangName, mallocScopeNameScopeName=mallocScopeNameScopeName, mallocScopeNameDefault=mallocScopeNameDefault, mallocScopeNameStatus=mallocScopeNameStatus, mallocScopeNameStorage=mallocScopeNameStorage, mallocAllocRangeTable=mallocAllocRangeTable, mallocAllocRangeEntry=mallocAllocRangeEntry, mallocAllocRangeFirstAddress=mallocAllocRangeFirstAddress, mallocAllocRangeLastAddress=mallocAllocRangeLastAddress, mallocAllocRangeStatus=mallocAllocRangeStatus, mallocAllocRangeSource=mallocAllocRangeSource, mallocAllocRangeLifetime=mallocAllocRangeLifetime, mallocAllocRangeMaxLeaseAddrs=mallocAllocRangeMaxLeaseAddrs, mallocAllocRangeMaxLeaseTime=mallocAllocRangeMaxLeaseTime, mallocAllocRangeNumAllocatedAddrs=mallocAllocRangeNumAllocatedAddrs, mallocAllocRangeNumOfferedAddrs=mallocAllocRangeNumOfferedAddrs, mallocAllocRangeNumWaitingAddrs=mallocAllocRangeNumWaitingAddrs, mallocAllocRangeNumTryingAddrs=mallocAllocRangeNumTryingAddrs, mallocAllocRangeAdvertisable=mallocAllocRangeAdvertisable, mallocAllocRangeTotalAllocatedAddrs=mallocAllocRangeTotalAllocatedAddrs, mallocAllocRangeTotalRequestedAddrs=mallocAllocRangeTotalRequestedAddrs, mallocAllocRangeStorage=mallocAllocRangeStorage, mallocRequestTable=mallocRequestTable, mallocRequestEntry=mallocRequestEntry, mallocRequestId=mallocRequestId, mallocRequestScopeAddressType=mallocRequestScopeAddressType, mallocRequestScopeFirstAddress=mallocRequestScopeFirstAddress, mallocRequestStartTime=mallocRequestStartTime, mallocRequestEndTime=mallocRequestEndTime, mallocRequestNumAddrs=mallocRequestNumAddrs, mallocRequestState=mallocRequestState, mallocRequestClientAddressType=mallocRequestClientAddressType, mallocRequestClientAddress=mallocRequestClientAddress, mallocRequestServerAddressType=mallocRequestServerAddressType, mallocRequestServerAddress=mallocRequestServerAddress, mallocRequestLeaseIdentifier=mallocRequestLeaseIdentifier, mallocAddressTable=mallocAddressTable, mallocAddressEntry=mallocAddressEntry, mallocAddressAddressType=mallocAddressAddressType, mallocAddressFirstAddress=mallocAddressFirstAddress, mallocAddressNumAddrs=mallocAddressNumAddrs, mallocAddressRequestId=mallocAddressRequestId, madcap=madcap, madcapConfig=madcapConfig, madcapConfigExtraAllocationTime=madcapConfigExtraAllocationTime, madcapConfigNoResponseDelay=madcapConfigNoResponseDelay, madcapConfigOfferHold=madcapConfigOfferHold, madcapConfigResponseCacheInterval=madcapConfigResponseCacheInterval, madcapConfigClockSkewAllowance=madcapConfigClockSkewAllowance, madcapCounters=madcapCounters, madcapTotalErrors=madcapTotalErrors, madcapRequestsDenied=madcapRequestsDenied, madcapInvalidRequests=madcapInvalidRequests, madcapExcessiveClockSkews=madcapExcessiveClockSkews, madcapBadLeaseIds=madcapBadLeaseIds, madcapDiscovers=madcapDiscovers, madcapInforms=madcapInforms, madcapRequests=madcapRequests, madcapRenews=madcapRenews, madcapReleases=madcapReleases, mallocConformance=mallocConformance, mallocCompliances=mallocCompliances, mallocGroups=mallocGroups)

# Groups
mibBuilder.exportSymbols("MALLOC-MIB", mallocServerGroup=mallocServerGroup, madcapServerGroup=madcapServerGroup, mallocClientGroup=mallocClientGroup, madcapClientGroup=madcapClientGroup, mallocPrefixCoordinatorGroup=mallocPrefixCoordinatorGroup, mallocClientScopeGroup=mallocClientScopeGroup, mallocBasicGroup=mallocBasicGroup)
