# PySNMP SMI module. Autogenerated from smidump -f python MPLS-LDP-STD-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:28 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IndexInteger, IndexIntegerNextFree, ) = mibBuilder.importSymbols("DIFFSERV-MIB", "IndexInteger", "IndexIntegerNextFree")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetPortNumber")
( MplsIndexType, ) = mibBuilder.importSymbols("MPLS-LSR-STD-MIB", "MplsIndexType")
( MplsLabelDistributionMethod, MplsLdpIdentifier, MplsLdpLabelType, MplsLspType, MplsLsrIdentifier, MplsRetentionMode, mplsStdMIB, ) = mibBuilder.importSymbols("MPLS-TC-STD-MIB", "MplsLabelDistributionMethod", "MplsLdpIdentifier", "MplsLdpLabelType", "MplsLspType", "MplsLsrIdentifier", "MplsRetentionMode", "mplsStdMIB")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32")
( RowStatus, StorageType, TimeInterval, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TimeInterval", "TimeStamp", "TruthValue")

# Objects

mplsLdpStdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 166, 4)).setRevisions(("2004-06-03 00:00",))
if mibBuilder.loadTexts: mplsLdpStdMIB.setOrganization("Multiprotocol Label Switching (mpls)\nWorking Group")
if mibBuilder.loadTexts: mplsLdpStdMIB.setContactInfo("Joan Cucchiara (jcucchiara@mindspring.com)\nMarconi Communications, Inc.\n\nHans Sjostrand (hans@ipunplugged.com)\nipUnplugged\n\nJames V. Luciani (james_luciani@mindspring.com)\nMarconi Communications, Inc.\n\nWorking Group Chairs:\nGeorge Swallow,   email: swallow@cisco.com\nLoa Andersson,    email: loa@pi.se\n\nMPLS Working Group, email: mpls@uu.net")
if mibBuilder.loadTexts: mplsLdpStdMIB.setDescription("Copyright (C) The Internet Society (2004). The\ninitial version of this MIB module was published\n\n\n\nin RFC 3815. For full legal notices see the RFC\nitself or see:\nhttp://www.ietf.org/copyrights/ianamib.html\n\nThis MIB contains managed object definitions for the\n'Multiprotocol Label Switching, Label Distribution\nProtocol, LDP' document.")
mplsLdpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 0))
mplsLdpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1))
mplsLdpLsrObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 1))
mplsLdpLsrId = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 1, 1), MplsLsrIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpLsrId.setDescription("The Label Switching Router's Identifier.")
mplsLdpLsrLoopDetectionCapable = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,5,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("other", 2), ("hopCount", 3), ("pathVector", 4), ("hopCountAndPathVector", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpLsrLoopDetectionCapable.setDescription("A indication of whether this\nLabel Switching Router supports\nloop detection.\n\nnone(1) -- Loop Detection is not supported\n           on this LSR.\n\nother(2) -- Loop Detection is supported but\n            by a method other than those\n            listed below.\n\nhopCount(3) -- Loop Detection is supported by\n               Hop Count only.\n\npathVector(4) -- Loop Detection is supported by\n                 Path Vector only.\n\nhopCountAndPathVector(5) -- Loop Detection is\n                     supported by both Hop Count\n                     And Path Vector.\n\nSince Loop Detection is determined during\nSession Initialization, an individual session\nmay not be running with loop detection.  This\nobject simply gives an indication of whether or not the\nLSR has the ability to support Loop Detection and\nwhich types.")
mplsLdpEntityObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2))
mplsLdpEntityLastChange = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityLastChange.setDescription("The value of sysUpTime at the time of the most\nrecent addition or deletion of an entry\nto/from the mplsLdpEntityTable/mplsLdpEntityStatsTable, or\nthe most recent change in value of any objects in the\nmplsLdpEntityTable.\n\n\n\nIf no such changes have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
mplsLdpEntityIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 2), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityIndexNext.setDescription("This object contains an appropriate value to\nbe used for mplsLdpEntityIndex when creating\nentries in the mplsLdpEntityTable. The value\n0 indicates that no unassigned entries are\navailable.")
mplsLdpEntityTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3))
if mibBuilder.loadTexts: mplsLdpEntityTable.setDescription("This table contains information about the\nMPLS Label Distribution Protocol Entities which\nexist on this Label Switching Router (LSR)\nor Label Edge Router (LER).")
mplsLdpEntityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"))
if mibBuilder.loadTexts: mplsLdpEntityEntry.setDescription("An entry in this table represents an LDP entity.\nAn entry can be created by a network administrator\nor by an SNMP agent as instructed by LDP.")
mplsLdpEntityLdpId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 1), MplsLdpIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpEntityLdpId.setDescription("The LDP identifier.")
mplsLdpEntityIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 2), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpEntityIndex.setDescription("This index is used as a secondary index to uniquely\nidentify this row.  Before creating a row in this table,\nthe 'mplsLdpEntityIndexNext' object should be retrieved.\nThat value should be used for the value of this index\nwhen creating a row in this table.  NOTE:  if a value\nof zero (0) is retrieved, that indicates that no rows\ncan be created in this table at this time.\n\nA secondary index (this object) is meaningful to some\nbut not all, LDP implementations.  For example\nan LDP implementation which uses PPP would\nuse this index to differentiate PPP sub-links.\n\nAnother way to use this index is to give this the\nvalue of ifIndex.  However, this is dependant\n\n\n\non the implementation.")
mplsLdpEntityProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityProtocolVersion.setDescription("The version number of the LDP protocol which will be\nused in the session initialization message.\n\nSection 3.5.3 in the LDP Specification specifies\nthat the version of the LDP protocol is negotiated during\nsession establishment. The value of this object\nrepresents the value that is sent in the initialization\nmessage.")
mplsLdpEntityAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("enable", 1), ("disable", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityAdminStatus.setDescription("The administrative status of this LDP Entity.\nIf this object is changed from 'enable' to 'disable'\nand this entity has already attempted to establish\ncontact with a Peer, then all contact with that\nPeer is lost and all information from that Peer\nneeds to be removed from the MIB. (This implies\nthat the network management subsystem should clean\nup any related entry in the mplsLdpPeerTable.  This\nfurther implies that a 'tear-down' for that session\nis issued and the session and all information related\nto that session cease to exist).\n\nAt this point the operator is able to change values\nwhich are related to this entity.\n\nWhen the admin status is set back to 'enable', then\nthis Entity will attempt to establish a new session\nwith the Peer.")
mplsLdpEntityOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("enabled", 2), ("disabled", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityOperStatus.setDescription("The operational status of this LDP Entity.\n\nThe value of unknown(1) indicates that the\noperational status cannot be determined at\nthis time.  The value of unknown should be\na transient condition before changing\nto enabled(2) or disabled(3).")
mplsLdpEntityTcpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 6), InetPortNumber().clone(646)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityTcpPort.setDescription("The TCP Port for\nLDP.  The default value is the well-known\nvalue of this port.")
mplsLdpEntityUdpDscPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 7), InetPortNumber().clone(646)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityUdpDscPort.setDescription("The UDP Discovery Port for\nLDP.  The default value is the\nwell-known value for this port.")
mplsLdpEntityMaxPduLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(256, 65535)).clone(4096)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityMaxPduLength.setDescription("The maximum PDU Length that is sent in\nthe Common Session Parameters of an Initialization\nMessage. According to the LDP Specification [RFC3036]\na value of 255 or less specifies the\ndefault maximum length of 4096 octets, this is why\nthe value of this object starts at 256.  The operator\nshould explicitly choose the default value (i.e., 4096),\nor some other value.\n\nThe receiving LSR MUST calculate the maximum PDU\nlength for the session by using the smaller of its and\nits peer's proposals for Max PDU Length.")
mplsLdpEntityKeepAliveHoldTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(40)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityKeepAliveHoldTimer.setDescription("The 16-bit integer value which is the proposed keep\nalive hold timer for this LDP Entity.")
mplsLdpEntityHelloHoldTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityHelloHoldTimer.setDescription("The 16-bit integer value which is the proposed Hello\nhold timer for this LDP Entity. The Hello Hold time\nin seconds.\n\n\n\nAn LSR maintains a record of Hellos received\nfrom potential peers.  This object represents\nthe Hold Time in the Common Hello Parameters TLV of\nthe Hello Message.\n\nA value of 0 is a default value and should be\ninterpretted in conjunction with the\nmplsLdpEntityTargetPeer object.\n\nIf the value of this object is 0: if the value of the\nmplsLdpEntityTargetPeer object is false(2), then this\nspecifies that the Hold Time's actual default value is\n15 seconds (i.e., the default Hold time for Link Hellos\nis 15 seconds).  Otherwise if the value of the\nmplsLdpEntityTargetPeer object is true(1), then this\nspecifies that the Hold Time's actual default value is\n45 seconds (i.e., the default Hold time for Targeted\nHellos is 45 seconds).\n\nA value of 65535 means infinite (i.e., wait forever).\n\nAll other values represent the amount of time in\nseconds to wait for a Hello Message.  Setting the\nhold time to a value smaller than 15 is not\nrecommended, although not forbidden according\nto RFC3036.")
mplsLdpEntityInitSessionThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100)).clone(8)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityInitSessionThreshold.setDescription("When attempting to establish a session with\na given Peer, the given LDP Entity should\nsend out the SNMP notification,\n'mplsLdpInitSessionThresholdExceeded', when\nthe number of Session Initialization messages\nsent exceeds this threshold.\n\nThe notification is used to notify an\noperator when this Entity and its Peer are\npossibly engaged in an endless sequence\nof messages as each NAKs the other's\n\n\n\nInitialization messages with Error Notification\nmessages.  Setting this threshold which triggers\nthe notification is one way to notify the\noperator.  The notification should be generated\neach time this threshold is exceeded and\nfor every subsequent Initialization message\nwhich is NAK'd with an Error Notification\nmessage after this threshold is exceeded.\n\nA value of 0 (zero) for this object\nindicates that the threshold is infinity, thus\nthe SNMP notification will never be generated.")
mplsLdpEntityLabelDistMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 12), MplsLabelDistributionMethod()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityLabelDistMethod.setDescription("For any given LDP session, the method of\nlabel distribution must be specified.")
mplsLdpEntityLabelRetentionMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 13), MplsRetentionMode()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityLabelRetentionMode.setDescription("The LDP Entity can be configured to use either\nconservative or liberal label retention mode.\n\nIf the value of this object is conservative(1)\nthen advertized label mappings are retained\nonly if they will be used to forward packets,\ni.e., if label came from a valid next hop.\n\nIf the value of this object is liberal(2)\nthen all advertized label mappings are retained\nwhether they are from a valid next hop or not.")
mplsLdpEntityPathVectorLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityPathVectorLimit.setDescription("If the value of this object is 0 (zero) then\nLoop Detection for Path Vectors is disabled.\n\nOtherwise, if this object has a value greater than\nzero, then Loop Dection for Path Vectors is enabled,\nand the Path Vector Limit is this value.\nAlso, the value of the object,\n'mplsLdpLsrLoopDetectionCapable', must be set to\neither 'pathVector(4)' or 'hopCountAndPathVector(5)',\nif this object has a value greater than 0 (zero),\notherwise it is ignored.")
mplsLdpEntityHopCountLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityHopCountLimit.setDescription("If the value of this object is 0 (zero),\nthen Loop Detection using Hop Counters is\ndisabled.\n\nIf the value of this object is greater than\n0 (zero) then Loop Detection using Hop\nCounters is enabled, and this object\nspecifies this Entity's maximum allowable\nvalue for the Hop Count.\nAlso, the value of the object\nmplsLdpLsrLoopDetectionCapable must be set\nto either 'hopCount(3)' or\n'hopCountAndPathVector(5)' if this object\nhas a value greater than 0 (zero), otherwise\nit is ignored.")
mplsLdpEntityTransportAddrKind = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("interface", 1), ("loopback", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityTransportAddrKind.setDescription("This specifies whether the loopback or interface\naddress is to be used as the transport address\nin the transport address TLV of the\nhello message.\n\nIf the value is interface(1), then the IP\naddress of the interface from which hello\nmessages are sent is used as the transport\naddress in the hello message.\n\nOtherwise, if the value is loopback(2), then the IP\naddress of the loopback interface is used as the\ntransport address in the hello message.")
mplsLdpEntityTargetPeer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 17), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityTargetPeer.setDescription("If this LDP entity uses targeted peer then set\nthis to true.")
mplsLdpEntityTargetPeerAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 18), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityTargetPeerAddrType.setDescription("The type of the internetwork layer address used for\nthe Extended Discovery.  This object indicates how\nthe value of mplsLdpEntityTargetPeerAddr is to\nbe interpreted.")
mplsLdpEntityTargetPeerAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 19), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityTargetPeerAddr.setDescription("The value of the internetwork layer address\nused for the Extended Discovery.  The value of\nmplsLdpEntityTargetPeerAddrType specifies how\nthis address is to be interpreted.")
mplsLdpEntityLabelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 20), MplsLdpLabelType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityLabelType.setDescription("Specifies the optional parameters for the LDP\nInitialization Message.\n\nIf the value is generic(1) then no\noptional parameters will be sent in\nthe LDP Initialization message associated\nwith this Entity.\n\nIf the value is atmParameters(2) then\na row must be created in the\nmplsLdpEntityAtmTable, which\ncorresponds to this entry.\n\nIf the value is frameRelayParameters(3) then\na row must be created in the\nmplsLdpEntityFrameRelayTable, which\ncorresponds to this entry.")
mplsLdpEntityDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 21), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this entity's counters\nsuffered a discontinuity.  The relevant counters\nare the specific instances associated with this\nentity of any Counter32 object contained\nin the 'mplsLdpEntityStatsTable'.  If no such\ndiscontinuities have occurred since the last\nre-initialization of the local management\nsubsystem, then this object contains a zero\nvalue.")
mplsLdpEntityStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 22), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent(4)'\nneed not allow write-access to any columnar\nobjects in the row.")
mplsLdpEntityRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 3, 1, 23), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpEntityRowStatus.setDescription("The status of this conceptual row.  All writable\nobjects in this row may be modified at any\ntime, however, as described in detail in\nthe section entitled, 'Changing Values After\nSession Establishment', and again described\nin the DESCRIPTION clause of the\nmplsLdpEntityAdminStatus object, if a session\nhas been initiated with a Peer, changing objects\nin this table will wreak havoc with the session\nand interrupt traffic.  To repeat again:\nthe recommended procedure is to\nset the mplsLdpEntityAdminStatus to down, thereby\nexplicitly causing a session to be torn down. Then,\nchange objects in this entry, then set\nthe mplsLdpEntityAdminStatus to enable,\nwhich enables a new session to be initiated.")
mplsLdpEntityStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4))
if mibBuilder.loadTexts: mplsLdpEntityStatsTable.setDescription("This table is a read-only table which augments\nthe mplsLdpEntityTable.  The purpose of this\ntable is to keep statistical information about\nthe LDP Entities on the LSR.")
mplsLdpEntityStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1))
if mibBuilder.loadTexts: mplsLdpEntityStatsEntry.setDescription("A row in this table contains statistical information\nabout an LDP Entity.  Some counters contained in a\nrow are for fatal errors received during a former\nLDP Session associated with this entry.  For example,\nan LDP PDU received on a TCP connection during an\nLDP Session contains a fatal error.  That\nerror is counted here, because the\nsession is terminated.\n\nIf the error is NOT fatal (i.e., the Session\nremains), then the error is counted in the\nmplsLdpSessionStatsEntry.")
mplsLdpEntityStatsSessionAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsSessionAttempts.setDescription("A count of the Session Initialization messages\nwhich were sent or received by this LDP Entity and\nwere NAK'd.   In other words, this counter counts\nthe number of session initializations that failed.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsSessionRejectedNoHelloErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsSessionRejectedNoHelloErrors.setDescription("A count of the Session Rejected/No Hello Error\nNotification Messages sent or received by\nthis LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsSessionRejectedAdErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsSessionRejectedAdErrors.setDescription("A count of the Session Rejected/Parameters\nAdvertisement Mode Error Notification Messages sent\nor received by this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsSessionRejectedMaxPduErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsSessionRejectedMaxPduErrors.setDescription("A count of the Session Rejected/Parameters\n\nMax Pdu Length Error Notification Messages sent\nor received by this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsSessionRejectedLRErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsSessionRejectedLRErrors.setDescription("A count of the Session Rejected/Parameters\nLabel Range Notification Messages sent\nor received by this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsBadLdpIdentifierErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsBadLdpIdentifierErrors.setDescription("This object counts the number of Bad LDP Identifier\nFatal Errors detected by the session(s)\n(past and present) associated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsBadPduLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsBadPduLengthErrors.setDescription("This object counts the number of Bad PDU Length\nFatal Errors detected by the session(s)\n(past and present) associated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsBadMessageLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsBadMessageLengthErrors.setDescription("This object counts the number of Bad Message\nLength Fatal Errors detected by the session(s)\n(past and present) associated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsBadTlvLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsBadTlvLengthErrors.setDescription("This object counts the number of Bad TLV\nLength Fatal Errors detected by the session(s)\n(past and present) associated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsMalformedTlvValueErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsMalformedTlvValueErrors.setDescription("This object counts the number of Malformed TLV\nValue Fatal Errors detected by the session(s)\n(past and present) associated with this\nLDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsKeepAliveTimerExpErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsKeepAliveTimerExpErrors.setDescription("This object counts the number of Session Keep Alive\nTimer Expired Errors detected by the session(s)\n(past and present) associated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsShutdownReceivedNotifications = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsShutdownReceivedNotifications.setDescription("This object counts the number of Shutdown Notifications\nreceived related to session(s) (past and present)\nassociated with this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpEntityDiscontinuityTime.")
mplsLdpEntityStatsShutdownSentNotifications = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 2, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpEntityStatsShutdownSentNotifications.setDescription("This object counts the number of Shutdown Notfications\nsent related to session(s) (past and present) associated\nwith this LDP Entity.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\n\n\n\nmplsLdpEntityDiscontinuityTime.")
mplsLdpSessionObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3))
mplsLdpPeerLastChange = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpPeerLastChange.setDescription("The value of sysUpTime at the time of the most\nrecent addition or deletion to/from the\nmplsLdpPeerTable/mplsLdpSessionTable.")
mplsLdpPeerTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2))
if mibBuilder.loadTexts: mplsLdpPeerTable.setDescription("Information about LDP peers known by Entities in\nthe mplsLdpEntityTable.  The information in this table\nis based on information from the Entity-Peer interaction\nduring session initialization but is not appropriate\nfor the mplsLdpSessionTable, because objects in this\ntable may or may not be used in session establishment.")
mplsLdpPeerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"))
if mibBuilder.loadTexts: mplsLdpPeerEntry.setDescription("Information about a single Peer which is related\nto a Session.  This table is augmented by\nthe mplsLdpSessionTable.")
mplsLdpPeerLdpId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1, 1), MplsLdpIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpPeerLdpId.setDescription("The LDP identifier of this LDP Peer.")
mplsLdpPeerLabelDistMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1, 2), MplsLabelDistributionMethod()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpPeerLabelDistMethod.setDescription("For any given LDP session, the method of\nlabel distribution must be specified.")
mplsLdpPeerPathVectorLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpPeerPathVectorLimit.setDescription("If the value of this object is 0 (zero) then\nLoop Dection for Path Vectors for this Peer\nis disabled.\n\nOtherwise, if this object has a value greater than\nzero, then Loop Dection for Path  Vectors for this\nPeer is enabled and the Path Vector Limit is this value.")
mplsLdpPeerTransportAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpPeerTransportAddrType.setDescription("The type of the Internet address for the\nmplsLdpPeerTransportAddr object.  The LDP\nspecification describes this as being either\nan IPv4 Transport Address or IPv6 Transport\n\n\n\nAddress which is used in opening the LDP session's\nTCP connection, or if the optional TLV is not\npresent, then this is the IPv4/IPv6 source\naddress for the UPD packet carrying the Hellos.\n\nThis object specifies how the value of the\nmplsLdpPeerTransportAddr object should be\ninterpreted.")
mplsLdpPeerTransportAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 2, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpPeerTransportAddr.setDescription("The Internet address advertised by the peer\nin the Hello Message or the Hello source address.\n\nThe type of this address is specified by the\nvalue of the mplsLdpPeerTransportAddrType\nobject.")
mplsLdpSessionTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3))
if mibBuilder.loadTexts: mplsLdpSessionTable.setDescription("A table of Sessions between the LDP Entities\nand LDP Peers.  This table AUGMENTS the\nmplsLdpPeerTable.  Each row in this table\nrepresents a single session.")
mplsLdpSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1))
if mibBuilder.loadTexts: mplsLdpSessionEntry.setDescription("An entry in this table represents information on a\nsingle session between an LDP Entity and LDP Peer.\nThe information contained in a row is read-only.\n\nPlease note:  the Path Vector Limit for the\nSession is the value which is configured in\nthe corresponding mplsLdpEntityEntry. The\nPeer's Path Vector Limit is in the\nmplsLdpPeerPathVectorLimit object in the\nmplsLdpPeerTable.\n\nValues which may differ from those configured are\nnoted in the objects of this table, the\nmplsLdpAtmSessionTable and the\nmplsLdpFrameRelaySessionTable. A value will\ndiffer if it was negotiated between the\nEntity and the Peer.  Values may or may not\nbe negotiated.  For example, if the values\nare the same then no negotiation takes place.\nIf they are negotiated, then they may differ.")
mplsLdpSessionStateLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionStateLastChange.setDescription("The value of sysUpTime at the time this\nSession entered its current state as\ndenoted by the mplsLdpSessionState\nobject.")
mplsLdpSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,5,2,)).subtype(namedValues=namedval.NamedValues(("nonexistent", 1), ("initialized", 2), ("openrec", 3), ("opensent", 4), ("operational", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionState.setDescription("The current state of the session, all of the\nstates 1 to 5 are based on the state machine\nfor session negotiation behavior.")
mplsLdpSessionRole = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("active", 2), ("passive", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionRole.setDescription("During session establishment the LSR/LER takes either\nthe active role or the passive role based on address\ncomparisons.  This object indicates whether this LSR/LER\nwas behaving in an active role or passive role during\nthis session's establishment.\n\nThe value of unknown(1), indicates that the role is not\nable to be determined at the present time.")
mplsLdpSessionProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionProtocolVersion.setDescription("The version of the LDP Protocol which\nthis session is using.  This is the version of\n\n\n\nthe LDP protocol which has been negotiated\nduring session initialization.")
mplsLdpSessionKeepAliveHoldTimeRem = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 5), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionKeepAliveHoldTimeRem.setDescription("The keep alive hold time remaining for\nthis session.")
mplsLdpSessionKeepAliveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionKeepAliveTime.setDescription("The negotiated KeepAlive Time which\nrepresents the amount of seconds between\nkeep alive messages.  The\nmplsLdpEntityKeepAliveHoldTimer\nrelated to this Session is the\nvalue that was proposed as the\nKeepAlive Time for this session.\n\nThis value is negotiated during\nsession initialization between\nthe entity's proposed value\n(i.e., the value configured in\nmplsLdpEntityKeepAliveHoldTimer)\nand the peer's proposed\nKeepAlive Hold Timer value.\nThis value is the smaller\nof the two proposed values.")
mplsLdpSessionMaxPduLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionMaxPduLength.setDescription("The value of maximum allowable length for LDP PDUs for\nthis session.  This value may have been negotiated\nduring the Session Initialization.  This object is\nrelated to the mplsLdpEntityMaxPduLength object.  The\nmplsLdpEntityMaxPduLength object specifies the requested\nLDP PDU length, and this object reflects the negotiated\nLDP PDU length between the Entity and\nthe Peer.")
mplsLdpSessionDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 3, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this session's counters\nsuffered a discontinuity.  The relevant counters are\nthe specific instances associated with this session\nof any Counter32 object contained in the\nmplsLdpSessionStatsTable.\n\nThe initial value of this object is the value of\nsysUpTime when the entry was created in this table.\n\nAlso, a command generator can distinguish when a session\nbetween a given Entity and Peer goes away and a new\nsession is established.  This value would change and\nthus indicate to the command generator that this is a\ndifferent session.")
mplsLdpSessionStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 4))
if mibBuilder.loadTexts: mplsLdpSessionStatsTable.setDescription("A table of statistics for Sessions between\nLDP Entities and LDP Peers.  This table AUGMENTS\n\n\n\nthe mplsLdpPeerTable.")
mplsLdpSessionStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 4, 1))
if mibBuilder.loadTexts: mplsLdpSessionStatsEntry.setDescription("An entry in this table represents statistical\ninformation on a single session between an LDP\nEntity and LDP Peer.")
mplsLdpSessionStatsUnknownMesTypeErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionStatsUnknownMesTypeErrors.setDescription("This object counts the number of Unknown Message Type\nErrors detected by this LSR/LER during this session.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpSessionDiscontinuityTime.")
mplsLdpSessionStatsUnknownTlvErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionStatsUnknownTlvErrors.setDescription("This object counts the number of Unknown TLV Errors\ndetected by this LSR/LER during this session.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at\nother times as indicated by the value of\nmplsLdpSessionDiscontinuityTime.")
mplsLdpHelloAdjacencyObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5))
mplsLdpHelloAdjacencyTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1))
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyTable.setDescription("A table of Hello Adjacencies for Sessions.")
mplsLdpHelloAdjacencyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpHelloAdjacencyIndex"))
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyEntry.setDescription("Each row represents a single LDP Hello Adjacency.\nAn LDP Session can have one or more Hello\nAdjacencies.")
mplsLdpHelloAdjacencyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyIndex.setDescription("An identifier for this specific adjacency.")
mplsLdpHelloAdjacencyHoldTimeRem = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1, 1, 2), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyHoldTimeRem.setDescription("If the value of this object is 65535,\nthis means that the hold time is infinite\n(i.e., wait forever).\n\nOtherwise, the time remaining for\nthis Hello Adjacency to receive its\nnext Hello Message.\n\nThis interval will change when the 'next'\nHello Message which corresponds to this\nHello Adjacency is received unless it\nis infinite.")
mplsLdpHelloAdjacencyHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyHoldTime.setDescription("The Hello hold time which is negotiated between\nthe Entity and the Peer.  The entity associated\nwith this Hello Adjacency issues a proposed\nHello Hold Time value in the\nmplsLdpEntityHelloHoldTimer object.  The peer\nalso proposes a value and this object represents\nthe negotiated value.\n\nA value of 0 means the default,\nwhich is 15 seconds for Link Hellos\nand 45 seconds for Targeted Hellos.\nA value of 65535 indicates an\ninfinite hold time.")
mplsLdpHelloAdjacencyType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 5, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("link", 1), ("targeted", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpHelloAdjacencyType.setDescription("This adjacency is the result of a 'link'\nhello if the value of this object is link(1).\n\n\n\nOtherwise, it is a result of a 'targeted'\nhello, targeted(2).")
mplsInSegmentLdpLspTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 6))
if mibBuilder.loadTexts: mplsInSegmentLdpLspTable.setDescription("A table of LDP LSP's which\nmap to the mplsInSegmentTable in the\nMPLS-LSR-STD-MIB module.")
mplsInSegmentLdpLspEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 6, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsInSegmentLdpLspIndex"))
if mibBuilder.loadTexts: mplsInSegmentLdpLspEntry.setDescription("An entry in this table represents information\non a single LDP LSP which is represented by\na session's index triple (mplsLdpEntityLdpId,\nmplsLdpEntityIndex, mplsLdpPeerLdpId) AND the\nindex for the mplsInSegmentTable\n(mplsInSegmentLdpLspLabelIndex) from the\nMPLS-LSR-STD-MIB.\n\nThe information contained in a row is read-only.")
mplsInSegmentLdpLspIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 6, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInSegmentLdpLspIndex.setDescription("This contains the same value as the\nmplsInSegmentIndex in the\nMPLS-LSR-STD-MIB's mplsInSegmentTable.")
mplsInSegmentLdpLspLabelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 6, 1, 2), MplsLdpLabelType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentLdpLspLabelType.setDescription("The Layer 2 Label Type.")
mplsInSegmentLdpLspType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 6, 1, 3), MplsLspType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentLdpLspType.setDescription("The type of LSP connection.")
mplsOutSegmentLdpLspTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 7))
if mibBuilder.loadTexts: mplsOutSegmentLdpLspTable.setDescription("A table of LDP LSP's which\nmap to the mplsOutSegmentTable in the\nMPLS-LSR-STD-MIB.")
mplsOutSegmentLdpLspEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 7, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsOutSegmentLdpLspIndex"))
if mibBuilder.loadTexts: mplsOutSegmentLdpLspEntry.setDescription("An entry in this table represents information\non a single LDP LSP which is represented by\na session's index triple (mplsLdpEntityLdpId,\nmplsLdpEntityIndex, mplsLdpPeerLdpId) AND the\nindex (mplsOutSegmentLdpLspIndex)\nfor the mplsOutSegmentTable.\n\nThe information contained in a row is read-only.")
mplsOutSegmentLdpLspIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 7, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsOutSegmentLdpLspIndex.setDescription("This contains the same value as the\nmplsOutSegmentIndex in the\nMPLS-LSR-STD-MIB's mplsOutSegmentTable.")
mplsOutSegmentLdpLspLabelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 7, 1, 2), MplsLdpLabelType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentLdpLspLabelType.setDescription("The Layer 2 Label Type.")
mplsOutSegmentLdpLspType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 7, 1, 3), MplsLspType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentLdpLspType.setDescription("The type of LSP connection.")
mplsFecObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8))
mplsFecLastChange = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsFecLastChange.setDescription("The value of sysUpTime at the time of the most\nrecent addition/deletion of an entry\nto/from the mplsLdpFectTable or\nthe most recent change in values to any objects\nin the mplsLdpFecTable.\n\nIf no such changes have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
mplsFecIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 2), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsFecIndexNext.setDescription("This object contains an appropriate value to\nbe used for mplsFecIndex when creating\nentries in the mplsFecTable. The value\n0 indicates that no unassigned entries are\navailable.")
mplsFecTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3))
if mibBuilder.loadTexts: mplsFecTable.setDescription("This table represents the FEC\n(Forwarding Equivalence Class)\nInformation associated with an LSP.")
mplsFecEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsFecIndex"))
if mibBuilder.loadTexts: mplsFecEntry.setDescription("Each row represents a single FEC Element.")
mplsFecIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsFecIndex.setDescription("The index which uniquely identifies this entry.")
mplsFecType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("prefix", 1), ("hostAddress", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecType.setDescription("The type of the FEC.  If the value of this object\nis 'prefix(1)' then the FEC type described by this\nrow is an address prefix.\n\nIf the value of this object is 'hostAddress(2)' then\nthe FEC type described by this row is a host address.")
mplsFecAddrPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 3), InetAddressPrefixLength().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecAddrPrefixLength.setDescription("If the value of the 'mplsFecType' is 'hostAddress(2)'\nthen this object is undefined.\n\nIf the value of 'mplsFecType' is 'prefix(1)'\nthen the value of this object is the length in\nbits of the address prefix represented by\n'mplsFecAddr', or zero.  If the value of this\nobject is zero, this indicates that the\nprefix matches all addresses.  In this case the\naddress prefix MUST also be zero (i.e., 'mplsFecAddr'\nshould have the value of zero.)")
mplsFecAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 4), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecAddrType.setDescription("The value of this object is the type of the\nInternet address.  The value of this object,\ndecides how the value of the mplsFecAddr object\nis interpreted.")
mplsFecAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 5), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecAddr.setDescription("The value of this object is interpreted based\non the value of the 'mplsFecAddrType' object.\n\nThis address is then further interpretted as\nan being used with the address prefix,\nor as the host address.  This further interpretation\nis indicated by the 'mplsFecType' object.\nIn other words, the FEC element is populated\naccording to the Prefix FEC Element value encoding, or\nthe Host Address FEC Element encoding.")
mplsFecStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent(4)'\nneed not allow write-access to any columnar\nobjects in the row.")
mplsFecRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 8, 3, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsFecRowStatus.setDescription("The status of this conceptual row.  If the value of this\nobject is 'active(1)', then none of the writable objects\nof this entry can be modified, except to set this object\nto 'destroy(6)'.\n\nNOTE: if this row is being referenced by any entry in\nthe mplsLdpLspFecTable, then a request to destroy\nthis row, will result in an inconsistentValue error.")
mplsLdpLspFecLastChange = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpLspFecLastChange.setDescription("The value of sysUpTime at the time of the most\nrecent addition/deletion of an entry\nto/from the mplsLdpLspFecTable or\nthe most recent change in values to any objects in the\nmplsLdpLspFecTable.\n\nIf no such changes have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
mplsLdpLspFecTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10))
if mibBuilder.loadTexts: mplsLdpLspFecTable.setDescription("A table which shows the relationship between\nLDP LSPs and FECs.  Each row represents\na single LDP LSP to FEC association.")
mplsLdpLspFecEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpLspFecSegment"), (0, "MPLS-LDP-STD-MIB", "mplsLdpLspFecSegmentIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpLspFecIndex"))
if mibBuilder.loadTexts: mplsLdpLspFecEntry.setDescription("An entry represents a LDP LSP\nto FEC association.")
mplsLdpLspFecSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("inSegment", 1), ("outSegment", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpLspFecSegment.setDescription("If the value is inSegment(1), then this\nindicates that the following index,\nmplsLdpLspFecSegmentIndex, contains the same\nvalue as the mplsInSegmentLdpLspIndex.\n\nOtherwise, if the value of this object is\n\n\n\noutSegment(2),  then this\nindicates that following index,\nmplsLdpLspFecSegmentIndex, contains the same\nvalue as the mplsOutSegmentLdpLspIndex.")
mplsLdpLspFecSegmentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1, 2), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpLspFecSegmentIndex.setDescription("This index is interpretted by using the value\nof the mplsLdpLspFecSegment.\n\nIf the mplsLdpLspFecSegment is inSegment(1),\nthen this index has the same value as\nmplsInSegmentLdpLspIndex.\n\nIf the mplsLdpLspFecSegment is outSegment(2),\nthen this index has the same value as\nmplsOutSegmentLdpLspIndex.")
mplsLdpLspFecIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1, 3), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpLspFecIndex.setDescription("This index identifies the FEC entry in the\nmplsFecTable associated with this session.\nIn other words, the value of this index\nis the same as the value of the mplsFecIndex\nthat denotes the FEC associated with this\nSession.")
mplsLdpLspFecStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpLspFecStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent(4)'\nneed not allow write-access to any columnar\nobjects in the row.")
mplsLdpLspFecRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 10, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLdpLspFecRowStatus.setDescription("The status of this conceptual row.  If the\nvalue of this object is 'active(1)', then\nnone of the writable objects of this entry\ncan be modified.\n\nThe Agent should delete this row when\nthe session ceases to exist.  If an\noperator wants to associate the session with\na different FEC, the recommended\nprocedure is (as described in detail in the section\nentitled, 'Changing Values After Session\nEstablishment', and again described in the\nDESCRIPTION clause of the\nmplsLdpEntityAdminStatus object)\nis to set the mplsLdpEntityAdminStatus to\ndown, thereby explicitly causing a session\nto be torn down. This will also\ncause this entry to be deleted.\n\nThen, set the mplsLdpEntityAdminStatus\nto enable which enables a new session to be initiated.\nOnce the session is initiated, an entry may be\nadded to this table to associate the new session\nwith a FEC.")
mplsLdpSessionPeerAddrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 11))
if mibBuilder.loadTexts: mplsLdpSessionPeerAddrTable.setDescription("This table 'extends' the mplsLdpSessionTable.\nThis table is used to store Label Address Information\nfrom Label Address Messages received by this LSR from\nPeers.  This table is read-only and should be updated\n\n\n\nwhen Label Withdraw Address Messages are received, i.e.,\nRows should be deleted as appropriate.\n\nNOTE:  since more than one address may be contained\nin a Label Address Message, this table 'sparse augments',\nthe mplsLdpSessionTable's information.")
mplsLdpSessionPeerAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 11, 1)).setIndexNames((0, "MPLS-LDP-STD-MIB", "mplsLdpEntityLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpEntityIndex"), (0, "MPLS-LDP-STD-MIB", "mplsLdpPeerLdpId"), (0, "MPLS-LDP-STD-MIB", "mplsLdpSessionPeerAddrIndex"))
if mibBuilder.loadTexts: mplsLdpSessionPeerAddrEntry.setDescription("An entry in this table represents information on\na session's single next hop address which was\nadvertised in an Address Message from the LDP peer.\nThe information contained in a row is read-only.")
mplsLdpSessionPeerAddrIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 11, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLdpSessionPeerAddrIndex.setDescription("An index which uniquely identifies this entry within\na given session.")
mplsLdpSessionPeerNextHopAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 11, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionPeerNextHopAddrType.setDescription("The internetwork layer address type of this Next Hop\nAddress as specified in the Label Address Message\nassociated with this Session. The value of this\nobject indicates how to interpret the value of\n\n\n\nmplsLdpSessionPeerNextHopAddr.")
mplsLdpSessionPeerNextHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 4, 1, 3, 11, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLdpSessionPeerNextHopAddr.setDescription("The next hop address.  The type of this address\nis specified by the value of the\nmplsLdpSessionPeerNextHopAddrType.")
mplsLdpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 2))
mplsLdpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 2, 1))
mplsLdpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 4, 2, 2))

# Augmentions
mplsLdpPeerEntry.registerAugmentions(("MPLS-LDP-STD-MIB", "mplsLdpSessionEntry"))
apply(mplsLdpSessionEntry.setIndexNames, mplsLdpPeerEntry.getIndexNames())
mplsLdpEntityEntry.registerAugmentions(("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsEntry"))
apply(mplsLdpEntityStatsEntry.setIndexNames, mplsLdpEntityEntry.getIndexNames())
mplsLdpPeerEntry.registerAugmentions(("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsEntry"))
apply(mplsLdpSessionStatsEntry.setIndexNames, mplsLdpPeerEntry.getIndexNames())

# Notifications

mplsLdpSessionDown = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 4, 0, 4)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpSessionState"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionDiscontinuityTime"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownTlvErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownMesTypeErrors"), )
mplsLdpInitSessionThresholdExceeded = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 4, 0, 1)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpEntityInitSessionThreshold"), )
mplsLdpSessionUp = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 4, 0, 3)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpSessionState"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionDiscontinuityTime"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownTlvErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownMesTypeErrors"), )
mplsLdpPathVectorLimitMismatch = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 4, 0, 2)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpPeerPathVectorLimit"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityPathVectorLimit"), )

# Groups

mplsLdpGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 4, 2, 1, 1)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpSessionPeerNextHopAddrType"), ("MPLS-LDP-STD-MIB", "mplsLdpLsrId"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityTransportAddrKind"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityKeepAliveHoldTimer"), ("MPLS-LDP-STD-MIB", "mplsFecRowStatus"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsBadMessageLengthErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpPeerLabelDistMethod"), ("MPLS-LDP-STD-MIB", "mplsLdpPeerTransportAddrType"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityInitSessionThreshold"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionPeerNextHopAddr"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsSessionRejectedLRErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownMesTypeErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityIndexNext"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsBadPduLengthErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityProtocolVersion"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityTargetPeerAddrType"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionMaxPduLength"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityUdpDscPort"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsBadTlvLengthErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityHelloHoldTimer"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityLabelType"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityOperStatus"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityTargetPeerAddr"), ("MPLS-LDP-STD-MIB", "mplsFecLastChange"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsShutdownSentNotifications"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityHopCountLimit"), ("MPLS-LDP-STD-MIB", "mplsLdpHelloAdjacencyHoldTime"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionRole"), ("MPLS-LDP-STD-MIB", "mplsFecIndexNext"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityLabelDistMethod"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStatsUnknownTlvErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityDiscontinuityTime"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsSessionRejectedMaxPduErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityLabelRetentionMode"), ("MPLS-LDP-STD-MIB", "mplsLdpPeerLastChange"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionKeepAliveHoldTimeRem"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityTargetPeer"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionProtocolVersion"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsShutdownReceivedNotifications"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityLastChange"), ("MPLS-LDP-STD-MIB", "mplsLdpHelloAdjacencyType"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsBadLdpIdentifierErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityTcpPort"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionState"), ("MPLS-LDP-STD-MIB", "mplsLdpPeerPathVectorLimit"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsKeepAliveTimerExpErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsMalformedTlvValueErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionDiscontinuityTime"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityRowStatus"), ("MPLS-LDP-STD-MIB", "mplsLdpLsrLoopDetectionCapable"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsSessionRejectedAdErrors"), ("MPLS-LDP-STD-MIB", "mplsFecAddrType"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityPathVectorLimit"), ("MPLS-LDP-STD-MIB", "mplsFecAddrPrefixLength"), ("MPLS-LDP-STD-MIB", "mplsFecAddr"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsSessionRejectedNoHelloErrors"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionStateLastChange"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStorageType"), ("MPLS-LDP-STD-MIB", "mplsLdpHelloAdjacencyHoldTimeRem"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityMaxPduLength"), ("MPLS-LDP-STD-MIB", "mplsLdpPeerTransportAddr"), ("MPLS-LDP-STD-MIB", "mplsFecStorageType"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityAdminStatus"), ("MPLS-LDP-STD-MIB", "mplsLdpEntityStatsSessionAttempts"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionKeepAliveTime"), ("MPLS-LDP-STD-MIB", "mplsFecType"), )
mplsLdpNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 166, 4, 2, 1, 3)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpSessionDown"), ("MPLS-LDP-STD-MIB", "mplsLdpInitSessionThresholdExceeded"), ("MPLS-LDP-STD-MIB", "mplsLdpSessionUp"), ("MPLS-LDP-STD-MIB", "mplsLdpPathVectorLimitMismatch"), )
mplsLdpLspGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 4, 2, 1, 2)).setObjects(("MPLS-LDP-STD-MIB", "mplsLdpLspFecLastChange"), ("MPLS-LDP-STD-MIB", "mplsOutSegmentLdpLspType"), ("MPLS-LDP-STD-MIB", "mplsLdpLspFecRowStatus"), ("MPLS-LDP-STD-MIB", "mplsLdpLspFecStorageType"), ("MPLS-LDP-STD-MIB", "mplsInSegmentLdpLspLabelType"), ("MPLS-LDP-STD-MIB", "mplsInSegmentLdpLspType"), ("MPLS-LDP-STD-MIB", "mplsOutSegmentLdpLspLabelType"), )

# Exports

# Module identity
mibBuilder.exportSymbols("MPLS-LDP-STD-MIB", PYSNMP_MODULE_ID=mplsLdpStdMIB)

# Objects
mibBuilder.exportSymbols("MPLS-LDP-STD-MIB", mplsLdpStdMIB=mplsLdpStdMIB, mplsLdpNotifications=mplsLdpNotifications, mplsLdpObjects=mplsLdpObjects, mplsLdpLsrObjects=mplsLdpLsrObjects, mplsLdpLsrId=mplsLdpLsrId, mplsLdpLsrLoopDetectionCapable=mplsLdpLsrLoopDetectionCapable, mplsLdpEntityObjects=mplsLdpEntityObjects, mplsLdpEntityLastChange=mplsLdpEntityLastChange, mplsLdpEntityIndexNext=mplsLdpEntityIndexNext, mplsLdpEntityTable=mplsLdpEntityTable, mplsLdpEntityEntry=mplsLdpEntityEntry, mplsLdpEntityLdpId=mplsLdpEntityLdpId, mplsLdpEntityIndex=mplsLdpEntityIndex, mplsLdpEntityProtocolVersion=mplsLdpEntityProtocolVersion, mplsLdpEntityAdminStatus=mplsLdpEntityAdminStatus, mplsLdpEntityOperStatus=mplsLdpEntityOperStatus, mplsLdpEntityTcpPort=mplsLdpEntityTcpPort, mplsLdpEntityUdpDscPort=mplsLdpEntityUdpDscPort, mplsLdpEntityMaxPduLength=mplsLdpEntityMaxPduLength, mplsLdpEntityKeepAliveHoldTimer=mplsLdpEntityKeepAliveHoldTimer, mplsLdpEntityHelloHoldTimer=mplsLdpEntityHelloHoldTimer, mplsLdpEntityInitSessionThreshold=mplsLdpEntityInitSessionThreshold, mplsLdpEntityLabelDistMethod=mplsLdpEntityLabelDistMethod, mplsLdpEntityLabelRetentionMode=mplsLdpEntityLabelRetentionMode, mplsLdpEntityPathVectorLimit=mplsLdpEntityPathVectorLimit, mplsLdpEntityHopCountLimit=mplsLdpEntityHopCountLimit, mplsLdpEntityTransportAddrKind=mplsLdpEntityTransportAddrKind, mplsLdpEntityTargetPeer=mplsLdpEntityTargetPeer, mplsLdpEntityTargetPeerAddrType=mplsLdpEntityTargetPeerAddrType, mplsLdpEntityTargetPeerAddr=mplsLdpEntityTargetPeerAddr, mplsLdpEntityLabelType=mplsLdpEntityLabelType, mplsLdpEntityDiscontinuityTime=mplsLdpEntityDiscontinuityTime, mplsLdpEntityStorageType=mplsLdpEntityStorageType, mplsLdpEntityRowStatus=mplsLdpEntityRowStatus, mplsLdpEntityStatsTable=mplsLdpEntityStatsTable, mplsLdpEntityStatsEntry=mplsLdpEntityStatsEntry, mplsLdpEntityStatsSessionAttempts=mplsLdpEntityStatsSessionAttempts, mplsLdpEntityStatsSessionRejectedNoHelloErrors=mplsLdpEntityStatsSessionRejectedNoHelloErrors, mplsLdpEntityStatsSessionRejectedAdErrors=mplsLdpEntityStatsSessionRejectedAdErrors, mplsLdpEntityStatsSessionRejectedMaxPduErrors=mplsLdpEntityStatsSessionRejectedMaxPduErrors, mplsLdpEntityStatsSessionRejectedLRErrors=mplsLdpEntityStatsSessionRejectedLRErrors, mplsLdpEntityStatsBadLdpIdentifierErrors=mplsLdpEntityStatsBadLdpIdentifierErrors, mplsLdpEntityStatsBadPduLengthErrors=mplsLdpEntityStatsBadPduLengthErrors, mplsLdpEntityStatsBadMessageLengthErrors=mplsLdpEntityStatsBadMessageLengthErrors, mplsLdpEntityStatsBadTlvLengthErrors=mplsLdpEntityStatsBadTlvLengthErrors, mplsLdpEntityStatsMalformedTlvValueErrors=mplsLdpEntityStatsMalformedTlvValueErrors, mplsLdpEntityStatsKeepAliveTimerExpErrors=mplsLdpEntityStatsKeepAliveTimerExpErrors, mplsLdpEntityStatsShutdownReceivedNotifications=mplsLdpEntityStatsShutdownReceivedNotifications, mplsLdpEntityStatsShutdownSentNotifications=mplsLdpEntityStatsShutdownSentNotifications, mplsLdpSessionObjects=mplsLdpSessionObjects, mplsLdpPeerLastChange=mplsLdpPeerLastChange, mplsLdpPeerTable=mplsLdpPeerTable, mplsLdpPeerEntry=mplsLdpPeerEntry, mplsLdpPeerLdpId=mplsLdpPeerLdpId, mplsLdpPeerLabelDistMethod=mplsLdpPeerLabelDistMethod, mplsLdpPeerPathVectorLimit=mplsLdpPeerPathVectorLimit, mplsLdpPeerTransportAddrType=mplsLdpPeerTransportAddrType, mplsLdpPeerTransportAddr=mplsLdpPeerTransportAddr, mplsLdpSessionTable=mplsLdpSessionTable, mplsLdpSessionEntry=mplsLdpSessionEntry, mplsLdpSessionStateLastChange=mplsLdpSessionStateLastChange, mplsLdpSessionState=mplsLdpSessionState, mplsLdpSessionRole=mplsLdpSessionRole, mplsLdpSessionProtocolVersion=mplsLdpSessionProtocolVersion, mplsLdpSessionKeepAliveHoldTimeRem=mplsLdpSessionKeepAliveHoldTimeRem, mplsLdpSessionKeepAliveTime=mplsLdpSessionKeepAliveTime, mplsLdpSessionMaxPduLength=mplsLdpSessionMaxPduLength, mplsLdpSessionDiscontinuityTime=mplsLdpSessionDiscontinuityTime, mplsLdpSessionStatsTable=mplsLdpSessionStatsTable, mplsLdpSessionStatsEntry=mplsLdpSessionStatsEntry, mplsLdpSessionStatsUnknownMesTypeErrors=mplsLdpSessionStatsUnknownMesTypeErrors, mplsLdpSessionStatsUnknownTlvErrors=mplsLdpSessionStatsUnknownTlvErrors, mplsLdpHelloAdjacencyObjects=mplsLdpHelloAdjacencyObjects, mplsLdpHelloAdjacencyTable=mplsLdpHelloAdjacencyTable, mplsLdpHelloAdjacencyEntry=mplsLdpHelloAdjacencyEntry, mplsLdpHelloAdjacencyIndex=mplsLdpHelloAdjacencyIndex, mplsLdpHelloAdjacencyHoldTimeRem=mplsLdpHelloAdjacencyHoldTimeRem, mplsLdpHelloAdjacencyHoldTime=mplsLdpHelloAdjacencyHoldTime, mplsLdpHelloAdjacencyType=mplsLdpHelloAdjacencyType, mplsInSegmentLdpLspTable=mplsInSegmentLdpLspTable, mplsInSegmentLdpLspEntry=mplsInSegmentLdpLspEntry, mplsInSegmentLdpLspIndex=mplsInSegmentLdpLspIndex, mplsInSegmentLdpLspLabelType=mplsInSegmentLdpLspLabelType, mplsInSegmentLdpLspType=mplsInSegmentLdpLspType, mplsOutSegmentLdpLspTable=mplsOutSegmentLdpLspTable, mplsOutSegmentLdpLspEntry=mplsOutSegmentLdpLspEntry, mplsOutSegmentLdpLspIndex=mplsOutSegmentLdpLspIndex, mplsOutSegmentLdpLspLabelType=mplsOutSegmentLdpLspLabelType, mplsOutSegmentLdpLspType=mplsOutSegmentLdpLspType, mplsFecObjects=mplsFecObjects, mplsFecLastChange=mplsFecLastChange, mplsFecIndexNext=mplsFecIndexNext, mplsFecTable=mplsFecTable, mplsFecEntry=mplsFecEntry, mplsFecIndex=mplsFecIndex, mplsFecType=mplsFecType, mplsFecAddrPrefixLength=mplsFecAddrPrefixLength, mplsFecAddrType=mplsFecAddrType, mplsFecAddr=mplsFecAddr, mplsFecStorageType=mplsFecStorageType, mplsFecRowStatus=mplsFecRowStatus, mplsLdpLspFecLastChange=mplsLdpLspFecLastChange, mplsLdpLspFecTable=mplsLdpLspFecTable, mplsLdpLspFecEntry=mplsLdpLspFecEntry, mplsLdpLspFecSegment=mplsLdpLspFecSegment, mplsLdpLspFecSegmentIndex=mplsLdpLspFecSegmentIndex, mplsLdpLspFecIndex=mplsLdpLspFecIndex, mplsLdpLspFecStorageType=mplsLdpLspFecStorageType, mplsLdpLspFecRowStatus=mplsLdpLspFecRowStatus, mplsLdpSessionPeerAddrTable=mplsLdpSessionPeerAddrTable, mplsLdpSessionPeerAddrEntry=mplsLdpSessionPeerAddrEntry, mplsLdpSessionPeerAddrIndex=mplsLdpSessionPeerAddrIndex, mplsLdpSessionPeerNextHopAddrType=mplsLdpSessionPeerNextHopAddrType, mplsLdpSessionPeerNextHopAddr=mplsLdpSessionPeerNextHopAddr, mplsLdpConformance=mplsLdpConformance, mplsLdpGroups=mplsLdpGroups, mplsLdpCompliances=mplsLdpCompliances)

# Notifications
mibBuilder.exportSymbols("MPLS-LDP-STD-MIB", mplsLdpSessionDown=mplsLdpSessionDown, mplsLdpInitSessionThresholdExceeded=mplsLdpInitSessionThresholdExceeded, mplsLdpSessionUp=mplsLdpSessionUp, mplsLdpPathVectorLimitMismatch=mplsLdpPathVectorLimitMismatch)

# Groups
mibBuilder.exportSymbols("MPLS-LDP-STD-MIB", mplsLdpGeneralGroup=mplsLdpGeneralGroup, mplsLdpNotificationsGroup=mplsLdpNotificationsGroup, mplsLdpLspGroup=mplsLdpLspGroup)
