# PySNMP SMI module. Autogenerated from smidump -f python MPLS-LSR-STD-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:29 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( AddressFamilyNumbers, ) = mibBuilder.importSymbols("IANA-ADDRESS-FAMILY-NUMBERS-MIB", "AddressFamilyNumbers")
( InterfaceIndexOrZero, ifCounterDiscontinuityGroup, ifGeneralInformationGroup, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifCounterDiscontinuityGroup", "ifGeneralInformationGroup")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( MplsBitRate, MplsLSPID, MplsLabel, MplsOwner, mplsStdMIB, ) = mibBuilder.importSymbols("MPLS-TC-STD-MIB", "MplsBitRate", "MplsLSPID", "MplsLabel", "MplsOwner", "mplsStdMIB")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, zeroDotZero, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "zeroDotZero")
( RowPointer, RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowPointer", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class MplsIndexNextType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,24)
    pass

class MplsIndexType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,24)
    pass


# Objects

mplsLsrStdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 166, 2)).setRevisions(("2004-06-03 00:00",))
if mibBuilder.loadTexts: mplsLsrStdMIB.setOrganization("Multiprotocol Label Switching (MPLS) Working Group")
if mibBuilder.loadTexts: mplsLsrStdMIB.setContactInfo("        Cheenu Srinivasan\nBloomberg L.P.\nEmail:  cheenu@bloomberg.net\n\nArun Viswanathan\nForce10 Networks, Inc.\nEmail:  arunv@force10networks.com\n\nThomas D. Nadeau\nCisco Systems, Inc.\nEmail:  tnadeau@cisco.com\n\nComments about this document should be emailed\ndirectly to the MPLS working group mailing list at\nmpls@uu.net.")
if mibBuilder.loadTexts: mplsLsrStdMIB.setDescription("This MIB module contains managed object definitions for\nthe Multiprotocol Label Switching (MPLS) Router as\n\n\n\ndefined in: Rosen, E., Viswanathan, A., and R.\nCallon, Multiprotocol Label Switching Architecture,\nRFC 3031, January 2001.\n\nCopyright (C) The Internet Society (2004). The\ninitial version of this MIB module was published\nin RFC 3812. For full legal notices see the RFC\nitself or see:\nhttp://www.ietf.org/copyrights/ianamib.html")
mplsLsrNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 2, 0))
mplsLsrObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 2, 1))
mplsInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1))
if mibBuilder.loadTexts: mplsInterfaceTable.setDescription("This table specifies per-interface MPLS capability\nand associated information.")
mplsInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsInterfaceIndex"))
if mibBuilder.loadTexts: mplsInterfaceEntry.setDescription("A conceptual row in this table is created\nautomatically by an LSR for every interface capable\nof supporting MPLS and which is configured to do so.\nA conceptual row in this table will exist if and only if\na corresponding entry in ifTable exists with ifType =\nmpls(166). If this associated entry in ifTable is\noperationally disabled (thus removing MPLS\ncapabilities on that interface), the corresponding\nentry in this table MUST be deleted shortly thereafter.\nAn conceptual row with index 0 is created if the LSR\nsupports per-platform labels. This conceptual row\nrepresents the per-platform label space and contains\nparameters that apply to all interfaces that participate\nin the per-platform label space. Other conceptual rows\nin this table represent MPLS interfaces that may\nparticipate in either the per-platform or per-\ninterface label spaces, or both.  Implementations\nthat either only support per-platform labels,\nor have only them configured, may choose to return\njust the mplsInterfaceEntry of 0 and not return\nthe other rows. This will greatly reduce the number\nof objects returned. Further information about label\nspace participation of an interface is provided in\nthe DESCRIPTION clause of\nmplsInterfaceLabelParticipationType.")
mplsInterfaceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 1), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInterfaceIndex.setDescription("This is a unique index for an entry in the\nMplsInterfaceTable.  A non-zero index for an\nentry indicates the ifIndex for the corresponding\ninterface entry of the MPLS-layer in the ifTable.\nThe entry with index 0 represents the per-platform\nlabel space and contains parameters that apply to all\ninterfaces that participate in the per-platform label\nspace. Other entries defined in this table represent\nadditional MPLS interfaces that may participate in either\nthe per-platform or per-interface label spaces, or both.")
mplsInterfaceLabelMinIn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 2), MplsLabel()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceLabelMinIn.setDescription("This is the minimum value of an MPLS label that this\nLSR is willing to receive on this interface.")
mplsInterfaceLabelMaxIn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 3), MplsLabel()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceLabelMaxIn.setDescription("This is the maximum value of an MPLS label that this\nLSR is willing to receive on this interface.")
mplsInterfaceLabelMinOut = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 4), MplsLabel()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceLabelMinOut.setDescription("This is the minimum value of an MPLS label that this\n\n\n\nLSR is willing to send on this interface.")
mplsInterfaceLabelMaxOut = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 5), MplsLabel()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceLabelMaxOut.setDescription("This is the maximum value of an MPLS label that this\nLSR is willing to send on this interface.")
mplsInterfaceTotalBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 6), MplsBitRate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceTotalBandwidth.setDescription("This value indicates the total amount of usable\nbandwidth on this interface and is specified in\nkilobits per second (Kbps).  This variable is not\napplicable when applied to the interface with index\n0. When this value cannot be measured, this value\nshould contain the nominal bandwidth.")
mplsInterfaceAvailableBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 7), MplsBitRate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceAvailableBandwidth.setDescription("This value indicates the total amount of available\nbandwidth available on this interface and is\nspecified in kilobits per second (Kbps).  This value\nis calculated as the difference between the amount\nof bandwidth currently in use and that specified in\nmplsInterfaceTotalBandwidth.  This variable is not\napplicable when applied to the interface with index\n0. When this value cannot be measured, this value\nshould contain the nominal bandwidth.")
mplsInterfaceLabelParticipationType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 1, 1, 8), Bits().subtype(namedValues=namedval.NamedValues(("perPlatform", 0), ("perInterface", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfaceLabelParticipationType.setDescription("If the value of the mplsInterfaceIndex for this\nentry is zero, then this entry corresponds to the\nper-platform label space for all interfaces configured\nto use that label space. In this case the perPlatform(0)\nbit MUST be set; the perInterface(1) bit is meaningless\nand MUST be ignored.\n\nThe remainder of this description applies to entries\nwith a non-zero value of mplsInterfaceIndex.\n\nIf the perInterface(1) bit is set then the value of\nmplsInterfaceLabelMinIn, mplsInterfaceLabelMaxIn,\nmplsInterfaceLabelMinOut, and\nmplsInterfaceLabelMaxOut for this entry reflect the\nlabel ranges for this interface.\n\nIf only the perPlatform(0) bit is set, then the value of\nmplsInterfaceLabelMinIn, mplsInterfaceLabelMaxIn,\nmplsInterfaceLabelMinOut, and\nmplsInterfaceLabelMaxOut for this entry MUST be\nidentical to the instance of these objects with\nindex 0.  These objects may only vary from the entry\nwith index 0 if both the perPlatform(0) and perInterface(1)\nbits are set.\n\nIn all cases, at a minimum one of the perPlatform(0) or\nperInterface(1) bits MUST be set to indicate that\nat least one label space is in use by this interface. In\nall cases, agents MUST ensure that label ranges are\nspecified consistently and MUST return an\ninconsistentValue error when they do not.")
mplsInterfacePerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2))
if mibBuilder.loadTexts: mplsInterfacePerfTable.setDescription("This table provides MPLS performance information on\na per-interface basis.")
mplsInterfacePerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2, 1))
if mibBuilder.loadTexts: mplsInterfacePerfEntry.setDescription("An entry in this table is created by the LSR for\nevery interface capable of supporting MPLS.  Its is\nan extension to the mplsInterfaceEntry table.\nNote that the discontinuity behavior of entries in\nthis table MUST be based on the corresponding\nifEntry's ifDiscontinuityTime.")
mplsInterfacePerfInLabelsInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfacePerfInLabelsInUse.setDescription("This object counts the number of labels that are in\nuse at this point in time on this interface in the\nincoming direction. If the interface participates in\nonly the per-platform label space, then the value of\nthe instance of this object MUST be identical to\nthe value of the instance with index 0. If the\ninterface participates in the per-interface label\nspace, then the instance of this object MUST\nrepresent the number of per-interface labels that\nare in use on this interface.")
mplsInterfacePerfInLabelLookupFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfacePerfInLabelLookupFailures.setDescription("This object counts the number of labeled packets\nthat have been received on this interface and which\nwere discarded because there was no matching cross-\nconnect entry. This object MUST count on a per-\ninterface basis regardless of which label space the\ninterface participates in.")
mplsInterfacePerfOutLabelsInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfacePerfOutLabelsInUse.setDescription("This object counts the number of top-most labels in\nthe outgoing label stacks that are in use at this\npoint in time on this interface. This object MUST\ncount on a per-interface basis regardless of which\nlabel space the interface participates in.")
mplsInterfacePerfOutFragmentedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInterfacePerfOutFragmentedPkts.setDescription("This object counts the number of outgoing MPLS\npackets that required fragmentation before\ntransmission on this interface. This object MUST\ncount on a per-interface basis regardless of which\nlabel space the interface participates in.")
mplsInSegmentIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 3), MplsIndexNextType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentIndexNext.setDescription("This object contains the next available value to\nbe used for mplsInSegmentIndex when creating entries\nin the mplsInSegmentTable. The special value of a\nstring containing the single octet 0x00 indicates\nthat no new entries can be created in this table.\nAgents not allowing managers to create entries\n\n\n\nin this table MUST set this object to this special\nvalue.")
mplsInSegmentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4))
if mibBuilder.loadTexts: mplsInSegmentTable.setDescription("This table contains a description of the incoming MPLS\nsegments (labels) to an LSR and their associated parameters.\nThe index for this table is mplsInSegmentIndex.\nThe index structure of this table is specifically designed\nto handle many different MPLS implementations that manage\ntheir labels both in a distributed and centralized manner.\nThe table is also designed to handle existing MPLS labels\nas defined in RFC3031 as well as longer ones that may\nbe necessary in the future.\n\nIn cases where the label cannot fit into the\nmplsInSegmentLabel object, the mplsInSegmentLabelPtr\nwill indicate this by being set to the first accessible\ncolumn in the appropriate extension table's row.\nIn this case an additional table MUST\nbe provided and MUST be indexed by at least the indexes\nused by this table. In all other cases when the label is\nrepresented within the mplsInSegmentLabel object, the\nmplsInSegmentLabelPtr MUST be set to 0.0. Due to the\nfact that MPLS labels may not exceed 24 bits, the\nmplsInSegmentLabelPtr object is only a provision for\nfuture-proofing the MIB module. Thus, the definition\nof any extension tables is beyond the scope of this\nMIB module.")
mplsInSegmentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsInSegmentIndex"))
if mibBuilder.loadTexts: mplsInSegmentEntry.setDescription("An entry in this table represents one incoming\nsegment as is represented in an LSR's LFIB.\nAn entry can be created by a network\nadministrator or an SNMP agent, or an MPLS signaling\nprotocol.  The creator of the entry is denoted by\nmplsInSegmentOwner.\n\n\n\n\nThe value of mplsInSegmentRowStatus cannot be active(1)\nunless the ifTable entry corresponding to\nmplsInSegmentInterface exists.  An entry in this table\nmust match any incoming packets, and indicates an\ninstance of mplsXCEntry based on which forwarding\nand/or switching actions are taken.")
mplsInSegmentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInSegmentIndex.setDescription("The index for this in-segment. The\nstring containing the single octet 0x00\nMUST not be used as an index.")
mplsInSegmentInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentInterface.setDescription("This object represents the\ninterface index for the incoming MPLS interface.  A\nvalue of zero represents all interfaces participating in\nthe per-platform label space.  This may only be used\nin cases where the incoming interface and label\nare associated with the same mplsXCEntry. Specifically,\ngiven a label and any incoming interface pair from the\nper-platform label space, the outgoing label/interface\nmapping remains the same. If this is not the case,\nthen individual entries MUST exist that\n\n\n\ncan then be mapped to unique mplsXCEntries.")
mplsInSegmentLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 3), MplsLabel()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentLabel.setDescription("If the corresponding instance of mplsInSegmentLabelPtr is\nzeroDotZero then this object MUST contain the incoming label\nassociated with this in-segment. If not this object SHOULD\nbe zero and MUST be ignored.")
mplsInSegmentLabelPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 4), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentLabelPtr.setDescription("If the label for this segment cannot be represented\nfully within the mplsInSegmentLabel object,\nthis object MUST point to the first accessible\ncolumn of a conceptual row in an external table containing\nthe label.  In this case, the mplsInSegmentTopLabel\nobject SHOULD be set to 0 and ignored. This object MUST\nbe set to zeroDotZero otherwise.")
mplsInSegmentNPop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentNPop.setDescription("The number of labels to pop from the incoming\npacket.  Normally only the top label is popped from\nthe packet and used for all switching decisions for\nthat packet.  This is indicated by setting this\nobject to the default value of 1. If an LSR supports\npopping of more than one label, this object MUST\nbe set to that number. This object cannot be modified\nif mplsInSegmentRowStatus is active(1).")
mplsInSegmentAddrFamily = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 6), AddressFamilyNumbers().clone('other')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentAddrFamily.setDescription("The IANA address family [IANAFamily] of packets\nreceived on this segment, which is used at an egress\nLSR to deliver them to the appropriate layer 3 entity.\nA value of other(0) indicates that the family type is\neither unknown or undefined; this SHOULD NOT be used\nat an egress LSR. This object cannot be\nmodified if mplsInSegmentRowStatus is active(1).")
mplsInSegmentXCIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 7), MplsIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentXCIndex.setDescription("Index into mplsXCTable which identifies which cross-\nconnect entry this segment is part of.  The string\ncontaining the single octet 0x00 indicates that this\nentry is not referred to by any cross-connect entry.\nWhen a cross-connect entry is created which this\nin-segment is a part of, this object is automatically\nupdated to reflect the value of mplsXCIndex of that\ncross-connect entry.")
mplsInSegmentOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 8), MplsOwner()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentOwner.setDescription("Denotes the entity that created and is responsible\nfor managing this segment.")
mplsInSegmentTrafficParamPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 9), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentTrafficParamPtr.setDescription("This variable represents a pointer to the traffic\nparameter specification for this in-segment.  This\nvalue may point at an entry in the\nmplsTunnelResourceTable in the MPLS-TE-STD-MIB (RFC3812)\nto indicate which traffic parameter settings for this\nsegment if it represents an LSP used for a TE tunnel.\n\nThis value may optionally point at an\nexternally defined traffic parameter specification\ntable.  A value of zeroDotZero indicates best-effort\ntreatment.  By having the same value of this object,\ntwo or more segments can indicate resource sharing\nof such things as LSP queue space, etc.\n\nThis object cannot be modified if mplsInSegmentRowStatus\nis active(1).  For entries in this table that\nare preserved after a re-boot, the agent MUST ensure\nthat their integrity be preserved, or this object should\nbe set to 0.0 if it cannot.")
mplsInSegmentRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table. When a row in this\ntable has a row in the active(1) state, no\nobjects in this row can be modified except the\nmplsInSegmentRowStatus and mplsInSegmentStorageType.")
mplsInSegmentStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 4, 1, 11), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsInSegmentStorageType.setDescription("This variable indicates the storage type for this\nobject. The agent MUST ensure that this object's\nvalue remains consistent with the associated\nmplsXCEntry. Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar objects in the row.")
mplsInSegmentPerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5))
if mibBuilder.loadTexts: mplsInSegmentPerfTable.setDescription("This table contains statistical information for\nincoming MPLS segments to an LSR.")
mplsInSegmentPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1))
if mibBuilder.loadTexts: mplsInSegmentPerfEntry.setDescription("An entry in this table contains statistical\ninformation about one incoming segment which is\nconfigured in the mplsInSegmentTable. The counters\nin this entry should behave in a manner similar to\nthat of the interface.\nmplsInSegmentPerfDiscontinuityTime indicates the\ntime of the last discontinuity in all of these\nobjects.")
mplsInSegmentPerfOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfOctets.setDescription("This value represents the total number of octets\nreceived by this segment. It MUST be equal to the\nleast significant 32 bits of\nmplsInSegmentPerfHCOctets\nif mplsInSegmentPerfHCOctets is supported according to\nthe rules spelled out in RFC2863.")
mplsInSegmentPerfPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfPackets.setDescription("Total number of packets received by this segment.")
mplsInSegmentPerfErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfErrors.setDescription("The number of errored packets received on this\nsegment.")
mplsInSegmentPerfDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfDiscards.setDescription("The number of labeled packets received on this in-\nsegment, which were chosen to be discarded even\nthough no errors had been detected to prevent their\nbeing transmitted.  One possible reason for\ndiscarding such a labeled packet could be to free up\nbuffer space.")
mplsInSegmentPerfHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfHCOctets.setDescription("The total number of octets received.  This is the 64\nbit version of mplsInSegmentPerfOctets,\nif mplsInSegmentPerfHCOctets is supported according to\nthe rules spelled out in RFC2863.")
mplsInSegmentPerfDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 5, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentPerfDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this segment's Counter32\nor Counter64 suffered a discontinuity. If no such\ndiscontinuities have occurred since the last re-\ninitialization of the local management subsystem,\nthen this object contains a zero value.")
mplsOutSegmentIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 6), MplsIndexNextType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentIndexNext.setDescription("This object contains the next available value to\nbe used for mplsOutSegmentIndex when creating entries\nin the mplsOutSegmentTable. The special value of a\nstring containing the single octet 0x00\nindicates that no new entries can be created in this\ntable. Agents not allowing managers to create entries\nin this table MUST set this object to this special\nvalue.")
mplsOutSegmentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7))
if mibBuilder.loadTexts: mplsOutSegmentTable.setDescription("This table contains a representation of the outgoing\nsegments from an LSR.")
mplsOutSegmentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsOutSegmentIndex"))
if mibBuilder.loadTexts: mplsOutSegmentEntry.setDescription("An entry in this table represents one outgoing\n\n\n\nsegment.  An entry can be created by a network\nadministrator, an SNMP agent, or an MPLS signaling\nprotocol.  The object mplsOutSegmentOwner indicates\nthe creator of this entry. The value of\nmplsOutSegmentRowStatus cannot be active(1) unless\nthe ifTable entry corresponding to\nmplsOutSegmentInterface exists.\n\nNote that the indexing of this table uses a single,\narbitrary index (mplsOutSegmentIndex) to indicate\nwhich out-segment (i.e.: label) is being switched to\nfrom which in-segment (i.e: label) or in-segments.\nThis is necessary because it is possible to have an\nequal-cost multi-path situation where two identical\nout-going labels are assigned to the same\ncross-connect (i.e.: they go to two different neighboring\nLSRs); thus, requiring two out-segments. In order to\npreserve the uniqueness of the references\nby the mplsXCEntry, an arbitrary integer must be used as\nthe index for this table.")
mplsOutSegmentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsOutSegmentIndex.setDescription("This value contains a unique index for this row.\nWhile a value of a string containing the single\noctet 0x00 is not valid as an index for entries\nin this table, it can be supplied as a valid value\nto index the mplsXCTable to represent entries for\n\n\n\nwhich no out-segment has been configured or\nexists.")
mplsOutSegmentInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentInterface.setDescription("This value must contain the interface index of the\noutgoing interface. This object cannot be modified\nif mplsOutSegmentRowStatus is active(1). The\nmplsOutSegmentRowStatus cannot be set to active(1)\nuntil this object is set to a value corresponding to\na valid ifEntry.")
mplsOutSegmentPushTopLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 3), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentPushTopLabel.setDescription("This value indicates whether or not a top label\nshould be pushed onto the outgoing packet's label\nstack.  The value of this variable MUST be set to\ntrue(1) if the outgoing interface does not support\npop-and-go (and no label stack remains). For example,\non ATM interface, or if the segment represents a\ntunnel origination.  Note that it is considered\nan error in the case that mplsOutSegmentPushTopLabel\nis set to false, but the cross-connect entry which\nrefers to this out-segment has a non-zero\nmplsLabelStackIndex.  The LSR MUST ensure that this\nsituation does not happen. This object cannot be\nmodified if mplsOutSegmentRowStatus is active(1).")
mplsOutSegmentTopLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 4), MplsLabel().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentTopLabel.setDescription("If mplsOutSegmentPushTopLabel is true then this\nrepresents the label that should be pushed onto the\ntop of the outgoing packet's label stack. Otherwise\nthis value SHOULD be set to 0 by the management\nstation and MUST be ignored by the agent. This\n\n\n\nobject cannot be modified if mplsOutSegmentRowStatus\nis active(1).")
mplsOutSegmentTopLabelPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 5), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentTopLabelPtr.setDescription("If the label for this segment cannot be represented\nfully within the mplsOutSegmentLabel object,\nthis object MUST point to the first accessible\ncolumn of a conceptual row in an external table containing\nthe label.  In this case, the mplsOutSegmentTopLabel\nobject SHOULD be set to 0 and ignored. This object\nMUST be set to zeroDotZero otherwise.")
mplsOutSegmentNextHopAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 6), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentNextHopAddrType.setDescription("Indicates the next hop Internet address type.\nOnly values unknown(0), ipv4(1) or ipv6(2)\nhave to be supported.\n\nA value of unknown(0) is allowed only when\nthe outgoing interface is of type point-to-point.\nIf any other unsupported values are attempted in a set\noperation, the agent MUST return an inconsistentValue\nerror.")
mplsOutSegmentNextHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 7), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentNextHopAddr.setDescription("The internet address of the next hop. The type of\nthis address is determined by the value of the\nmplslOutSegmentNextHopAddrType object.\n\nThis object cannot be modified if\n\n\n\nmplsOutSegmentRowStatus is active(1).")
mplsOutSegmentXCIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 8), MplsIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentXCIndex.setDescription("Index into mplsXCTable which identifies which cross-\nconnect entry this segment is part of.  A value of\nthe string containing the single octet 0x00\nindicates that this entry is not referred\nto by any cross-connect entry.  When a cross-connect\nentry is created which this out-segment is a part of,\nthis object MUST be updated by the agent to reflect\nthe value of mplsXCIndex of that cross-connect\nentry.")
mplsOutSegmentOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 9), MplsOwner()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentOwner.setDescription("Denotes the entity which created and is responsible\nfor managing this segment.")
mplsOutSegmentTrafficParamPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 10), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentTrafficParamPtr.setDescription("This variable represents a pointer to the traffic\nparameter specification for this out-segment.  This\nvalue may point at an entry in the\nMplsTunnelResourceEntry in the MPLS-TE-STD-MIB (RFC3812)\n\nRFC Editor: Please fill in RFC number.\n\nto indicate which traffic parameter settings for this\nsegment if it represents an LSP used for a TE tunnel.\n\nThis value may optionally point at an\nexternally defined traffic parameter specification\ntable.  A value of zeroDotZero indicates best-effort\ntreatment.  By having the same value of this object,\ntwo or more segments can indicate resource sharing\n\n\n\nof such things as LSP queue space, etc.\n\nThis object cannot be modified if\nmplsOutSegmentRowStatus is active(1).\nFor entries in this table that\nare preserved after a re-boot, the agent MUST ensure\nthat their integrity be preserved, or this object should\nbe set to 0.0 if it cannot.")
mplsOutSegmentRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentRowStatus.setDescription("For creating, modifying, and deleting this row.\nWhen a row in this table has a row in the active(1)\nstate, no objects in this row can be modified\nexcept the mplsOutSegmentRowStatus or\nmplsOutSegmentStorageType.")
mplsOutSegmentStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 7, 1, 12), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsOutSegmentStorageType.setDescription("This variable indicates the storage type for this\nobject. The agent MUST ensure that this object's value\nremains consistent with the associated mplsXCEntry.\nConceptual rows having the value 'permanent'\nneed not allow write-access to any columnar\nobjects in the row.")
mplsOutSegmentPerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8))
if mibBuilder.loadTexts: mplsOutSegmentPerfTable.setDescription("This table contains statistical information about\n\n\n\noutgoing segments from an LSR. The counters in this\nentry should behave in a manner similar to that of\nthe interface.")
mplsOutSegmentPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1))
if mibBuilder.loadTexts: mplsOutSegmentPerfEntry.setDescription("An entry in this table contains statistical\ninformation about one outgoing segment configured in\nmplsOutSegmentTable. The object\nmplsOutSegmentPerfDiscontinuityTime indicates the\ntime of the last discontinuity in these objects. ")
mplsOutSegmentPerfOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfOctets.setDescription("This value contains the total number of octets sent\non this segment. It MUST be equal to the least\nsignificant 32 bits of mplsOutSegmentPerfHCOctets\nif mplsOutSegmentPerfHCOctets is supported according to\nthe rules spelled out in RFC2863.")
mplsOutSegmentPerfPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfPackets.setDescription("This value contains the total number of packets sent\n\n\n\non this segment.")
mplsOutSegmentPerfErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfErrors.setDescription("Number of packets that could not be sent due to\nerrors on this segment.")
mplsOutSegmentPerfDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfDiscards.setDescription("The number of labeled packets attempted to be transmitted\non this out-segment, which were chosen to be discarded\neven though no errors had been detected to prevent their\nbeing transmitted. One possible reason for\ndiscarding such a labeled packet could be to free up\nbuffer space.")
mplsOutSegmentPerfHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfHCOctets.setDescription("Total number of octets sent.  This is the 64 bit\nversion of mplsOutSegmentPerfOctets,\nif mplsOutSegmentPerfHCOctets is supported according to\nthe rules spelled out in RFC2863.")
mplsOutSegmentPerfDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 8, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsOutSegmentPerfDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this segment's Counter32\nor Counter64 suffered a discontinuity. If no such\ndiscontinuities have occurred since the last re-\ninitialization of the local management subsystem,\nthen this object contains a zero value.")
mplsXCIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 9), MplsIndexNextType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsXCIndexNext.setDescription("This object contains the next available value to\nbe used for mplsXCIndex when creating entries in\nthe mplsXCTable. A special value of the zero length\nstring indicates that no more new entries can be created\nin the relevant table.  Agents not allowing managers\nto create entries in this table MUST set this value\nto the zero length string.")
mplsXCTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10))
if mibBuilder.loadTexts: mplsXCTable.setDescription("This table specifies information for switching\nbetween LSP segments.  It supports point-to-point,\npoint-to-multipoint and multipoint-to-point\nconnections.  mplsLabelStackTable specifies the\nlabel stack information for a cross-connect LSR and\nis referred to from mplsXCTable.")
mplsXCEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsXCIndex"), (0, "MPLS-LSR-STD-MIB", "mplsXCInSegmentIndex"), (0, "MPLS-LSR-STD-MIB", "mplsXCOutSegmentIndex"))
if mibBuilder.loadTexts: mplsXCEntry.setDescription("A row in this table represents one cross-connect\nentry.  It is indexed by the following objects:\n\n- cross-connect index mplsXCIndex that uniquely\n  identifies a group of cross-connect entries\n\n- in-segment index, mplsXCInSegmentIndex\n\n- out-segment index, mplsXCOutSegmentIndex\n\n\n\n\nLSPs originating at this LSR:\nThese are represented by using the special\nof value of mplsXCInSegmentIndex set to the\nstring containing a single octet 0x00. In\nthis case the mplsXCOutSegmentIndex\nMUST not be the string containing a single\noctet 0x00.\n\nLSPs terminating at this LSR:\nThese are represented by using the special value\nmplsXCOutSegmentIndex set to the string containing\na single octet 0x00.\n\nSpecial labels:\nEntries indexed by the strings containing the\nreserved MPLS label values as a single octet 0x00\nthrough 0x0f (inclusive) imply LSPs terminating at\nthis LSR.  Note that situations where LSPs are\nterminated with incoming label equal to the string\ncontaining a single octet 0x00 can be distinguished\nfrom LSPs originating at this LSR because the\nmplsXCOutSegmentIndex equals the string containing the\nsingle octet 0x00.\n\nAn entry can be created by a network administrator\nor by an SNMP agent as instructed by an MPLS\nsignaling protocol.")
mplsXCIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsXCIndex.setDescription("Primary index for the conceptual row identifying a\ngroup of cross-connect segments. The string\ncontaining a single octet 0x00 is an invalid index.")
mplsXCInSegmentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 2), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsXCInSegmentIndex.setDescription("Incoming label index.\nIf this object is set to the string containing\na single octet 0x00, this indicates a special\ncase outlined in the table's description above.\nIn this case no corresponding mplsInSegmentEntry\nshall exist.")
mplsXCOutSegmentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 3), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsXCOutSegmentIndex.setDescription("Index of out-segment for LSPs not terminating on\nthis LSR if not set to the string containing the\nsingle octet 0x00. If the segment identified by this\nentry is terminating, then this object MUST be set to\nthe string containing a single octet 0x00 to indicate\nthat no corresponding mplsOutSegmentEntry shall\nexist.")
mplsXCLspId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 4), MplsLSPID()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsXCLspId.setDescription("This value identifies the label switched path that\nthis cross-connect entry belongs to. This object\ncannot be modified if mplsXCRowStatus is active(1)\nexcept for this object.")
mplsXCLabelStackIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 5), MplsIndexType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsXCLabelStackIndex.setDescription("Primary index into mplsLabelStackTable identifying a\nstack of labels to be pushed beneath the top label.\nNote that the top label identified by the out-\nsegment ensures that all the components of a\nmultipoint-to-point connection have the same\noutgoing label. A value of the string containing the\nsingle octet 0x00 indicates that no labels are to\nbe stacked beneath the top label.\nThis object cannot be modified if mplsXCRowStatus is\nactive(1).")
mplsXCOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 6), MplsOwner()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsXCOwner.setDescription("Denotes the entity that created and is responsible\nfor managing this cross-connect.")
mplsXCRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsXCRowStatus.setDescription("For creating, modifying, and deleting this row.\nWhen a row in this table has a row in the active(1)\nstate, no objects in this row except this object\nand the mplsXCStorageType can be modified. ")
mplsXCStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 8), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsXCStorageType.setDescription("This variable indicates the storage type for this\nobject. The agent MUST ensure that the associated in\nand out segments also have the same StorageType value\nand are restored consistently upon system restart.\nThis value SHOULD be set to permanent(4) if created\nas a result of a static LSP configuration.\n\nConceptual rows having the value 'permanent'\nneed not allow write-access to any columnar\nobjects in the row.")
mplsXCAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("testing", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsXCAdminStatus.setDescription("The desired operational status of this segment.")
mplsXCOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 10, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,7,4,3,1,2,6,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("testing", 3), ("unknown", 4), ("dormant", 5), ("notPresent", 6), ("lowerLayerDown", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsXCOperStatus.setDescription("The actual operational status of this cross-\nconnect.")
mplsMaxLabelStackDepth = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsMaxLabelStackDepth.setDescription("The maximum stack depth supported by this LSR.")
mplsLabelStackIndexNext = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 12), MplsIndexNextType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsLabelStackIndexNext.setDescription("This object contains the next available value to\nbe used for mplsLabelStackIndex when creating entries\nin the mplsLabelStackTable. The special string\ncontaining the single octet 0x00\nindicates that no more new entries can be created\nin the relevant table.  Agents not allowing managers\nto create entries in this table MUST set this value\nto the string containing the single octet 0x00.")
mplsLabelStackTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13))
if mibBuilder.loadTexts: mplsLabelStackTable.setDescription("This table specifies the label stack to be pushed\nonto a packet, beneath the top label.  Entries into\nthis table are referred to from mplsXCTable.")
mplsLabelStackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsLabelStackIndex"), (0, "MPLS-LSR-STD-MIB", "mplsLabelStackLabelIndex"))
if mibBuilder.loadTexts: mplsLabelStackEntry.setDescription("An entry in this table represents one label which is\nto be pushed onto an outgoing packet, beneath the\ntop label.  An entry can be created by a network\nadministrator or by an SNMP agent as instructed by\nan MPLS signaling protocol.")
mplsLabelStackIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 1), MplsIndexType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLabelStackIndex.setDescription("Primary index for this row identifying a stack of\nlabels to be pushed on an outgoing packet, beneath\nthe top label. An index containing the string with\na single octet 0x00 MUST not be used.")
mplsLabelStackLabelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsLabelStackLabelIndex.setDescription("Secondary index for this row identifying one label\nof the stack.  Note that an entry with a smaller\nmplsLabelStackLabelIndex would refer to a label\nhigher up the label stack and would be popped at a\ndownstream LSR before a label represented by a\nhigher mplsLabelStackLabelIndex at a downstream\nLSR.")
mplsLabelStackLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 3), MplsLabel()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLabelStackLabel.setDescription("The label to pushed.")
mplsLabelStackLabelPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 4), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLabelStackLabelPtr.setDescription("If the label for this segment cannot be represented\nfully within the mplsLabelStackLabel object,\nthis object MUST point to the first accessible\ncolumn of a conceptual row in an external table containing\nthe label.  In this case, the mplsLabelStackLabel\nobject SHOULD be set to 0 and ignored. This object\nMUST be set to zeroDotZero otherwise.")
mplsLabelStackRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLabelStackRowStatus.setDescription("For creating, modifying, and deleting this row.\nWhen a row in this table has a row in the active(1)\nstate, no objects in this row except this object\nand the mplsLabelStackStorageType can be modified.")
mplsLabelStackStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 13, 1, 6), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mplsLabelStackStorageType.setDescription("This variable indicates the storage type for this\nobject. This object cannot be modified if\nmplsLabelStackRowStatus is active(1).\nNo objects are required to be writable for\nrows in this table with this object set to\npermanent(4).\n\nThe agent MUST ensure that all related entries\nin this table retain the same value for this\nobject.  Agents MUST ensure that the storage type\nfor all entries related to a particular mplsXCEntry\nretain the same value for this object as the\nmplsXCEntry's StorageType.")
mplsInSegmentMapTable = MibTable((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14))
if mibBuilder.loadTexts: mplsInSegmentMapTable.setDescription("This table specifies the mapping from the\nmplsInSegmentIndex to the corresponding\nmplsInSegmentInterface and mplsInSegmentLabel\nobjects. The purpose of this table is to\nprovide the manager with an alternative\nmeans by which to locate in-segments.")
mplsInSegmentMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14, 1)).setIndexNames((0, "MPLS-LSR-STD-MIB", "mplsInSegmentMapInterface"), (0, "MPLS-LSR-STD-MIB", "mplsInSegmentMapLabel"), (0, "MPLS-LSR-STD-MIB", "mplsInSegmentMapLabelPtrIndex"))
if mibBuilder.loadTexts: mplsInSegmentMapEntry.setDescription("An entry in this table represents one interface\nand incoming label pair.\n\nIn cases where the label cannot fit into the\nmplsInSegmentLabel object, the mplsInSegmentLabelPtr\nwill indicate this by being set to the first accessible\ncolumn in the appropriate extension table's row,\nand the mplsInSegmentLabel SHOULD be set to 0.\nIn all other cases when the label is\nrepresented within the mplsInSegmentLabel object, the\nmplsInSegmentLabelPtr MUST be 0.0.\n\nImplementors need to be aware that if the value of\nthe mplsInSegmentMapLabelPtrIndex (an OID) has more\nthat 111 sub-identifiers, then OIDs of column\ninstances in this table will have more than 128\nsub-identifiers and cannot be accessed using SNMPv1,\nSNMPv2c, or SNMPv3.")
mplsInSegmentMapInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14, 1, 1), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInSegmentMapInterface.setDescription("This index contains the same value as the\nmplsInSegmentIndex in the mplsInSegmentTable.")
mplsInSegmentMapLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14, 1, 2), MplsLabel()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInSegmentMapLabel.setDescription("This index contains the same value as the\nmplsInSegmentLabel in the mplsInSegmentTable.")
mplsInSegmentMapLabelPtrIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14, 1, 3), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mplsInSegmentMapLabelPtrIndex.setDescription("This index contains the same value as the\nmplsInSegmentLabelPtr.\n\nIf the label for the InSegment cannot be represented\nfully within the mplsInSegmentLabel object,\nthis index MUST point to the first accessible\ncolumn of a conceptual row in an external table containing\nthe label.  In this case, the mplsInSegmentTopLabel\nobject SHOULD be set to 0 and ignored. This object MUST\nbe set to zeroDotZero otherwise.")
mplsInSegmentMapIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 14, 1, 4), MplsIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mplsInSegmentMapIndex.setDescription("The mplsInSegmentIndex that corresponds\nto the mplsInSegmentInterface and\nmplsInSegmentLabel, or the mplsInSegmentInterface\nand mplsInSegmentLabelPtr, if applicable.\nThe string containing the single octet 0x00\nMUST not be returned.")
mplsXCNotificationsEnable = MibScalar((1, 3, 6, 1, 2, 1, 10, 166, 2, 1, 15), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mplsXCNotificationsEnable.setDescription("If this object is set to true(1), then it enables\nthe emission of mplsXCUp and mplsXCDown\nnotifications; otherwise these notifications are not\n\n\n\nemitted.")
mplsLsrConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 2, 2))
mplsLsrGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1))
mplsLsrCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 2))

# Augmentions
mplsInSegmentEntry.registerAugmentions(("MPLS-LSR-STD-MIB", "mplsInSegmentPerfEntry"))
apply(mplsInSegmentPerfEntry.setIndexNames, mplsInSegmentEntry.getIndexNames())
mplsOutSegmentEntry.registerAugmentions(("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfEntry"))
apply(mplsOutSegmentPerfEntry.setIndexNames, mplsOutSegmentEntry.getIndexNames())
mplsInterfaceEntry.registerAugmentions(("MPLS-LSR-STD-MIB", "mplsInterfacePerfEntry"))
apply(mplsInterfacePerfEntry.setIndexNames, mplsInterfaceEntry.getIndexNames())

# Notifications

mplsXCDown = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 2, 0, 2)).setObjects(("MPLS-LSR-STD-MIB", "mplsXCOperStatus"), )
mplsXCUp = NotificationType((1, 3, 6, 1, 2, 1, 10, 166, 2, 0, 1)).setObjects(("MPLS-LSR-STD-MIB", "mplsXCOperStatus"), )

# Groups

mplsLabelStackGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 8)).setObjects(("MPLS-LSR-STD-MIB", "mplsLabelStackStorageType"), ("MPLS-LSR-STD-MIB", "mplsLabelStackLabelPtr"), ("MPLS-LSR-STD-MIB", "mplsMaxLabelStackDepth"), ("MPLS-LSR-STD-MIB", "mplsLabelStackLabel"), ("MPLS-LSR-STD-MIB", "mplsLabelStackIndexNext"), ("MPLS-LSR-STD-MIB", "mplsLabelStackRowStatus"), )
mplsHCOutSegmentPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 7)).setObjects(("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfHCOctets"), )
mplsPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 5)).setObjects(("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfDiscontinuityTime"), ("MPLS-LSR-STD-MIB", "mplsInterfacePerfInLabelLookupFailures"), ("MPLS-LSR-STD-MIB", "mplsInterfacePerfOutLabelsInUse"), ("MPLS-LSR-STD-MIB", "mplsInSegmentPerfPackets"), ("MPLS-LSR-STD-MIB", "mplsInSegmentPerfDiscards"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfOctets"), ("MPLS-LSR-STD-MIB", "mplsInterfacePerfOutFragmentedPkts"), ("MPLS-LSR-STD-MIB", "mplsInSegmentPerfDiscontinuityTime"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfPackets"), ("MPLS-LSR-STD-MIB", "mplsInSegmentPerfErrors"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfDiscards"), ("MPLS-LSR-STD-MIB", "mplsInterfacePerfInLabelsInUse"), ("MPLS-LSR-STD-MIB", "mplsInSegmentPerfOctets"), )
mplsInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 1)).setObjects(("MPLS-LSR-STD-MIB", "mplsInterfaceLabelParticipationType"), ("MPLS-LSR-STD-MIB", "mplsInterfaceLabelMaxOut"), ("MPLS-LSR-STD-MIB", "mplsInterfaceLabelMinIn"), ("MPLS-LSR-STD-MIB", "mplsInterfaceAvailableBandwidth"), ("MPLS-LSR-STD-MIB", "mplsInterfaceTotalBandwidth"), ("MPLS-LSR-STD-MIB", "mplsInterfaceLabelMinOut"), ("MPLS-LSR-STD-MIB", "mplsInterfaceLabelMaxIn"), )
mplsHCInSegmentPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 6)).setObjects(("MPLS-LSR-STD-MIB", "mplsInSegmentPerfHCOctets"), )
mplsOutSegmentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 3)).setObjects(("MPLS-LSR-STD-MIB", "mplsOutSegmentStorageType"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentNextHopAddrType"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentInterface"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentTopLabel"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentTrafficParamPtr"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentRowStatus"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentXCIndex"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfOctets"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentOwner"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentIndexNext"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentTopLabelPtr"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfDiscards"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentNextHopAddr"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPerfErrors"), ("MPLS-LSR-STD-MIB", "mplsOutSegmentPushTopLabel"), )
mplsInSegmentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 2)).setObjects(("MPLS-LSR-STD-MIB", "mplsInSegmentLabel"), ("MPLS-LSR-STD-MIB", "mplsInSegmentMapIndex"), ("MPLS-LSR-STD-MIB", "mplsInSegmentRowStatus"), ("MPLS-LSR-STD-MIB", "mplsInSegmentIndexNext"), ("MPLS-LSR-STD-MIB", "mplsInSegmentInterface"), ("MPLS-LSR-STD-MIB", "mplsInSegmentXCIndex"), ("MPLS-LSR-STD-MIB", "mplsInSegmentStorageType"), ("MPLS-LSR-STD-MIB", "mplsInSegmentTrafficParamPtr"), ("MPLS-LSR-STD-MIB", "mplsInSegmentLabelPtr"), ("MPLS-LSR-STD-MIB", "mplsInSegmentOwner"), ("MPLS-LSR-STD-MIB", "mplsInSegmentNPop"), ("MPLS-LSR-STD-MIB", "mplsInSegmentAddrFamily"), )
mplsLsrNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 9)).setObjects(("MPLS-LSR-STD-MIB", "mplsXCDown"), ("MPLS-LSR-STD-MIB", "mplsXCUp"), )
mplsXCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 166, 2, 2, 1, 4)).setObjects(("MPLS-LSR-STD-MIB", "mplsXCLspId"), ("MPLS-LSR-STD-MIB", "mplsXCRowStatus"), ("MPLS-LSR-STD-MIB", "mplsXCOwner"), ("MPLS-LSR-STD-MIB", "mplsXCNotificationsEnable"), ("MPLS-LSR-STD-MIB", "mplsXCOperStatus"), ("MPLS-LSR-STD-MIB", "mplsXCIndexNext"), ("MPLS-LSR-STD-MIB", "mplsXCStorageType"), ("MPLS-LSR-STD-MIB", "mplsXCLabelStackIndex"), ("MPLS-LSR-STD-MIB", "mplsXCAdminStatus"), )

# Exports

# Module identity
mibBuilder.exportSymbols("MPLS-LSR-STD-MIB", PYSNMP_MODULE_ID=mplsLsrStdMIB)

# Types
mibBuilder.exportSymbols("MPLS-LSR-STD-MIB", MplsIndexNextType=MplsIndexNextType, MplsIndexType=MplsIndexType)

# Objects
mibBuilder.exportSymbols("MPLS-LSR-STD-MIB", mplsLsrStdMIB=mplsLsrStdMIB, mplsLsrNotifications=mplsLsrNotifications, mplsLsrObjects=mplsLsrObjects, mplsInterfaceTable=mplsInterfaceTable, mplsInterfaceEntry=mplsInterfaceEntry, mplsInterfaceIndex=mplsInterfaceIndex, mplsInterfaceLabelMinIn=mplsInterfaceLabelMinIn, mplsInterfaceLabelMaxIn=mplsInterfaceLabelMaxIn, mplsInterfaceLabelMinOut=mplsInterfaceLabelMinOut, mplsInterfaceLabelMaxOut=mplsInterfaceLabelMaxOut, mplsInterfaceTotalBandwidth=mplsInterfaceTotalBandwidth, mplsInterfaceAvailableBandwidth=mplsInterfaceAvailableBandwidth, mplsInterfaceLabelParticipationType=mplsInterfaceLabelParticipationType, mplsInterfacePerfTable=mplsInterfacePerfTable, mplsInterfacePerfEntry=mplsInterfacePerfEntry, mplsInterfacePerfInLabelsInUse=mplsInterfacePerfInLabelsInUse, mplsInterfacePerfInLabelLookupFailures=mplsInterfacePerfInLabelLookupFailures, mplsInterfacePerfOutLabelsInUse=mplsInterfacePerfOutLabelsInUse, mplsInterfacePerfOutFragmentedPkts=mplsInterfacePerfOutFragmentedPkts, mplsInSegmentIndexNext=mplsInSegmentIndexNext, mplsInSegmentTable=mplsInSegmentTable, mplsInSegmentEntry=mplsInSegmentEntry, mplsInSegmentIndex=mplsInSegmentIndex, mplsInSegmentInterface=mplsInSegmentInterface, mplsInSegmentLabel=mplsInSegmentLabel, mplsInSegmentLabelPtr=mplsInSegmentLabelPtr, mplsInSegmentNPop=mplsInSegmentNPop, mplsInSegmentAddrFamily=mplsInSegmentAddrFamily, mplsInSegmentXCIndex=mplsInSegmentXCIndex, mplsInSegmentOwner=mplsInSegmentOwner, mplsInSegmentTrafficParamPtr=mplsInSegmentTrafficParamPtr, mplsInSegmentRowStatus=mplsInSegmentRowStatus, mplsInSegmentStorageType=mplsInSegmentStorageType, mplsInSegmentPerfTable=mplsInSegmentPerfTable, mplsInSegmentPerfEntry=mplsInSegmentPerfEntry, mplsInSegmentPerfOctets=mplsInSegmentPerfOctets, mplsInSegmentPerfPackets=mplsInSegmentPerfPackets, mplsInSegmentPerfErrors=mplsInSegmentPerfErrors, mplsInSegmentPerfDiscards=mplsInSegmentPerfDiscards, mplsInSegmentPerfHCOctets=mplsInSegmentPerfHCOctets, mplsInSegmentPerfDiscontinuityTime=mplsInSegmentPerfDiscontinuityTime, mplsOutSegmentIndexNext=mplsOutSegmentIndexNext, mplsOutSegmentTable=mplsOutSegmentTable, mplsOutSegmentEntry=mplsOutSegmentEntry, mplsOutSegmentIndex=mplsOutSegmentIndex, mplsOutSegmentInterface=mplsOutSegmentInterface, mplsOutSegmentPushTopLabel=mplsOutSegmentPushTopLabel, mplsOutSegmentTopLabel=mplsOutSegmentTopLabel, mplsOutSegmentTopLabelPtr=mplsOutSegmentTopLabelPtr, mplsOutSegmentNextHopAddrType=mplsOutSegmentNextHopAddrType, mplsOutSegmentNextHopAddr=mplsOutSegmentNextHopAddr, mplsOutSegmentXCIndex=mplsOutSegmentXCIndex, mplsOutSegmentOwner=mplsOutSegmentOwner, mplsOutSegmentTrafficParamPtr=mplsOutSegmentTrafficParamPtr, mplsOutSegmentRowStatus=mplsOutSegmentRowStatus, mplsOutSegmentStorageType=mplsOutSegmentStorageType, mplsOutSegmentPerfTable=mplsOutSegmentPerfTable, mplsOutSegmentPerfEntry=mplsOutSegmentPerfEntry, mplsOutSegmentPerfOctets=mplsOutSegmentPerfOctets, mplsOutSegmentPerfPackets=mplsOutSegmentPerfPackets, mplsOutSegmentPerfErrors=mplsOutSegmentPerfErrors, mplsOutSegmentPerfDiscards=mplsOutSegmentPerfDiscards, mplsOutSegmentPerfHCOctets=mplsOutSegmentPerfHCOctets, mplsOutSegmentPerfDiscontinuityTime=mplsOutSegmentPerfDiscontinuityTime, mplsXCIndexNext=mplsXCIndexNext, mplsXCTable=mplsXCTable, mplsXCEntry=mplsXCEntry, mplsXCIndex=mplsXCIndex, mplsXCInSegmentIndex=mplsXCInSegmentIndex, mplsXCOutSegmentIndex=mplsXCOutSegmentIndex, mplsXCLspId=mplsXCLspId, mplsXCLabelStackIndex=mplsXCLabelStackIndex, mplsXCOwner=mplsXCOwner, mplsXCRowStatus=mplsXCRowStatus, mplsXCStorageType=mplsXCStorageType, mplsXCAdminStatus=mplsXCAdminStatus, mplsXCOperStatus=mplsXCOperStatus, mplsMaxLabelStackDepth=mplsMaxLabelStackDepth, mplsLabelStackIndexNext=mplsLabelStackIndexNext, mplsLabelStackTable=mplsLabelStackTable, mplsLabelStackEntry=mplsLabelStackEntry, mplsLabelStackIndex=mplsLabelStackIndex, mplsLabelStackLabelIndex=mplsLabelStackLabelIndex, mplsLabelStackLabel=mplsLabelStackLabel, mplsLabelStackLabelPtr=mplsLabelStackLabelPtr, mplsLabelStackRowStatus=mplsLabelStackRowStatus, mplsLabelStackStorageType=mplsLabelStackStorageType, mplsInSegmentMapTable=mplsInSegmentMapTable, mplsInSegmentMapEntry=mplsInSegmentMapEntry, mplsInSegmentMapInterface=mplsInSegmentMapInterface, mplsInSegmentMapLabel=mplsInSegmentMapLabel, mplsInSegmentMapLabelPtrIndex=mplsInSegmentMapLabelPtrIndex, mplsInSegmentMapIndex=mplsInSegmentMapIndex, mplsXCNotificationsEnable=mplsXCNotificationsEnable, mplsLsrConformance=mplsLsrConformance, mplsLsrGroups=mplsLsrGroups, mplsLsrCompliances=mplsLsrCompliances)

# Notifications
mibBuilder.exportSymbols("MPLS-LSR-STD-MIB", mplsXCDown=mplsXCDown, mplsXCUp=mplsXCUp)

# Groups
mibBuilder.exportSymbols("MPLS-LSR-STD-MIB", mplsLabelStackGroup=mplsLabelStackGroup, mplsHCOutSegmentPerfGroup=mplsHCOutSegmentPerfGroup, mplsPerfGroup=mplsPerfGroup, mplsInterfaceGroup=mplsInterfaceGroup, mplsHCInSegmentPerfGroup=mplsHCInSegmentPerfGroup, mplsOutSegmentGroup=mplsOutSegmentGroup, mplsInSegmentGroup=mplsInSegmentGroup, mplsLsrNotificationGroup=mplsLsrNotificationGroup, mplsXCGroup=mplsXCGroup)
