# PySNMP SMI module. Autogenerated from smidump -f python Modem-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:28 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( mib_2, ) = mibBuilder.importSymbols("RFC1213-MIB", "mib-2")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString")

# Objects

mdmMib = MibIdentifier((1, 3, 6, 1, 2, 1, 38))
mdmMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 38, 1)).setRevisions(("1994-06-12 00:00",))
if mibBuilder.loadTexts: mdmMIB.setOrganization("IETF Modem Management Working Group")
if mibBuilder.loadTexts: mdmMIB.setContactInfo("        Steven Waldbusser\nPostal: Carnegie Mellon University\n        5000 Forbes Ave\n        Pittsburgh, PA, 15213\n        US\n\n   Tel: +1 412 268 6628\n   Fax: +1 412 268 4987\nE-mail: waldbusser@cmu.edu")
if mibBuilder.loadTexts: mdmMIB.setDescription("The MIB module for management of dial-up modems.")
mdmMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 38, 1, 1))
mdmNumber = MibScalar((1, 3, 6, 1, 2, 1, 38, 1, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmNumber.setDescription("The number of modem rows in the modem table.  This value\ndefines the maximum value of the mdmIndex object.")
mdmIDTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 2))
if mibBuilder.loadTexts: mdmIDTable.setDescription("The base table for the modems managed by this MIB.  The\nmdmLineTable, mdmDTEInterfaceTable, mdmCallControlTable, and\nmdmStatsTable all augment the rows defined in this table.")
mdmIDEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 2, 1)).setIndexNames((0, "Modem-MIB", "mdmIndex"))
if mibBuilder.loadTexts: mdmIDEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mdmIndex.setDescription("A unique number for each modem that ranges from 1 to\nmdmNumber.  The value must remain constant at least from one\nre-initialization of the network management agent to the\nnext.")
mdmIDManufacturerOID = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 2, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmIDManufacturerOID.setDescription("This value is intended to identify the manufacturer, model,\nand version of this modem.  This may be used to identify the\nexistance of enterprise-specific functions and behaviours.")
mdmIDProductDetails = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 2, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 79))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmIDProductDetails.setDescription("A textual description of this device, including the\nmanufacturer's name, modem model name, hardware revision,\nfirmware revision, and optionally, its serial number.  The\nexact format of this description is defined by the vendor.\nThis description may only contain characters from the NVT\nASCII character set.")
mdmLineTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 3))
if mibBuilder.loadTexts: mdmLineTable.setDescription("The modem Line Table augments the modem ID table.")
mdmLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 3, 1))
if mibBuilder.loadTexts: mdmLineEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmLineCarrierLossTime = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmLineCarrierLossTime.setDescription("Duration in 10ths of a second the modem waits after loss of\ncarrier before hanging up.  If this value is set to `255',\nthe modem will not hang up upon loss of carrier.  This\nallows the modem to distinguish between a momentary lapse in\nline quality and a true disconnect and can be useful to tune\nthe tolerance of the modem to lines of poor quality.")
mdmLineState = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,1,2,4,5,3,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("onHook", 2), ("offHook", 3), ("connected", 4), ("busiedOut", 5), ("reset", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmLineState.setDescription("Allows the inspection and alteration of the state of the\nmodem.  Management commands may change the state to `on-\nhook', `busied-out', or `reset' from any state.  No other\nalterations are permitted from the management protocol.\nWhen this object is set to reset, the modem shall be reset\nand the value will change to the modem's new, implementation\ndependent state.")
mdmLineCapabilitiesTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 4))
if mibBuilder.loadTexts: mdmLineCapabilitiesTable.setDescription("A list of protocol capabilities for this modem.")
mdmLineCapabilitiesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 4, 1)).setIndexNames((0, "Modem-MIB", "mdmIndex"), (0, "Modem-MIB", "mdmLineCapabilitiesIndex"))
if mibBuilder.loadTexts: mdmLineCapabilitiesEntry.setDescription("A listing of the protocol(s) that this modem is capable of.\nEntries in this table are created only by the agent.  One\nentry exists for each protocol that the modem is capable of,\nregardless of whether that protocol is enabled or not.\n\nThis table is useful for providing an inventory of the\ncapabilities on a modem, and allowing the manager to enable\nor disable capabilities from the menu of available\npossibilities.  Row creation is not required to enable or\ndisable capabilities.")
mdmLineCapabilitiesIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 4, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mdmLineCapabilitiesIndex.setDescription("A unique index for this capabilities entry.")
mdmLineCapabilitiesID = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 4, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmLineCapabilitiesID.setDescription("An identifier for this capability.  Standard protocol\ncapabilities will have identifiers registered in this\ndocument or other companion standards documents.\nProprietary protocol capabilities will be registered by\ntheir respective organization.  All capabilities, standard\nor vendor-specific, shall be registered in this table.")
mdmLineCapabilitiesEnableRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("optional", 2), ("preferred", 3), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmLineCapabilitiesEnableRequested.setDescription("The requested configuration of this capability.  If this\nvalue is 'disabled(1)', this is a request to disable this\nprotocol.  If this value is 'preferred(3)', this is a\nrequest to enable this protocol, and to prefer it in any\nnegotiation over other appropriate protocols that have a\nvalue of 'optional(2)'.")
mdmLineCapabilitiesEnableGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 4, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("optional", 2), ("preferred", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmLineCapabilitiesEnableGranted.setDescription("The actual configuration of this capability.  The agent\nshall attempt to set this as close as possible to the\nassociated mdmLineCapabilitiesEnableRequested value.  The\nagent shall make this determination in an implementation-\nspecific manner that may take into account the configuration\nof other capabilities or other considerations.  The modem\nwill choose in an implementation-specific manner between\nmultiple mutually-exclusive capabilities that each have the\nsame (non-disabled) value.  However, the modem must prefer\nall capabilities with a value of 'preferred(3)' over all\ncapabilities with a value of 'optional(2)'.\n\nIn other words, if there are one or more mutually-exclusive\ncapabilities (e.g. V.32 and V.32bis) that are set to\n`preferred', the agent must choose one in an\nimplementation-specific manner.  Otherwise, if there are one\nor more mutually-exclusive capabilities that are set to\n`optional', the agent must choose one in an implementation-\nspecific manner.")
mdmLineCapabilities = MibIdentifier((1, 3, 6, 1, 2, 1, 38, 1, 1, 5))
mdmLineCapabilitiesV21 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 1))
if mibBuilder.loadTexts: mdmLineCapabilitiesV21.setDescription("ITU V.21")
mdmLineCapabilitiesV22 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 2))
if mibBuilder.loadTexts: mdmLineCapabilitiesV22.setDescription("ITU V.22")
mdmLineCapabilitiesV22bis = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 3))
if mibBuilder.loadTexts: mdmLineCapabilitiesV22bis.setDescription("ITU V.22bis")
mdmLineCapabilitiesV23CC = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 4))
if mibBuilder.loadTexts: mdmLineCapabilitiesV23CC.setDescription("ITU V.23CC")
mdmLineCapabilitiesV23SC = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 5))
if mibBuilder.loadTexts: mdmLineCapabilitiesV23SC.setDescription("ITU V.23SC")
mdmLineCapabilitiesV25bis = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 6))
if mibBuilder.loadTexts: mdmLineCapabilitiesV25bis.setDescription("ITU V.25bis")
mdmLineCapabilitiesV26bis = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 7))
if mibBuilder.loadTexts: mdmLineCapabilitiesV26bis.setDescription("ITU V.26bis")
mdmLineCapabilitiesV26ter = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 8))
if mibBuilder.loadTexts: mdmLineCapabilitiesV26ter.setDescription("ITU V.26ter")
mdmLineCapabilitiesV27ter = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 9))
if mibBuilder.loadTexts: mdmLineCapabilitiesV27ter.setDescription("ITU V.27ter")
mdmLineCapabilitiesV32 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 10))
if mibBuilder.loadTexts: mdmLineCapabilitiesV32.setDescription("ITU V.32")
mdmLineCapabilitiesV32bis = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 11))
if mibBuilder.loadTexts: mdmLineCapabilitiesV32bis.setDescription("ITU V.32bis")
mdmLineCapabilitiesV32terbo = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 12))
if mibBuilder.loadTexts: mdmLineCapabilitiesV32terbo.setDescription("ITU V.32terbo")
mdmLineCapabilitiesVFC = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 13))
if mibBuilder.loadTexts: mdmLineCapabilitiesVFC.setDescription("ITU V.FC")
mdmLineCapabilitiesV34 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 14))
if mibBuilder.loadTexts: mdmLineCapabilitiesV34.setDescription("ITU V.34")
mdmLineCapabilitiesV42 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 15))
if mibBuilder.loadTexts: mdmLineCapabilitiesV42.setDescription("ITU V.42")
mdmLineCapabilitiesV42bis = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 16))
if mibBuilder.loadTexts: mdmLineCapabilitiesV42bis.setDescription("ITU V.42bis")
mdmLineCapabilitiesMNP1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 17))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP1.setDescription("MNP1")
mdmLineCapabilitiesMNP2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 18))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP2.setDescription("MNP2")
mdmLineCapabilitiesMNP3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 19))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP3.setDescription("MNP3")
mdmLineCapabilitiesMNP4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 20))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP4.setDescription("MNP4")
mdmLineCapabilitiesMNP5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 21))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP5.setDescription("MNP5")
mdmLineCapabilitiesMNP6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 22))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP6.setDescription("MNP6")
mdmLineCapabilitiesMNP7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 23))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP7.setDescription("MNP7")
mdmLineCapabilitiesMNP8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 24))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP8.setDescription("MNP8")
mdmLineCapabilitiesMNP9 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 25))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP9.setDescription("MNP9")
mdmLineCapabilitiesMNP10 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 26))
if mibBuilder.loadTexts: mdmLineCapabilitiesMNP10.setDescription("MNP10")
mdmLineCapabilitiesV29 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 27))
if mibBuilder.loadTexts: mdmLineCapabilitiesV29.setDescription("ITU V.29")
mdmLineCapabilitiesV33 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 28))
if mibBuilder.loadTexts: mdmLineCapabilitiesV33.setDescription("ITU V.33")
mdmLineCapabilitiesBell208 = ObjectIdentity((1, 3, 6, 1, 2, 1, 38, 1, 1, 5, 29))
if mibBuilder.loadTexts: mdmLineCapabilitiesBell208.setDescription("Bell 208")
mdmDTEInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 6))
if mibBuilder.loadTexts: mdmDTEInterfaceTable.setDescription("The modem DTE Interface Table augments the modem ID table.")
mdmDTEInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1))
if mibBuilder.loadTexts: mdmDTEInterfaceEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmDTEActionDTROnToOff = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("ignore", 1), ("escapeToCommandMode", 2), ("disconnectCall", 3), ("resetModem", 4), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmDTEActionDTROnToOff.setDescription("Defines the action the modem will take when DTR drops.\n\nIf the value is set to ignore(1), the modem takes no action\nwhen DTR drops.  Typically, mdmDTEActionDTROffToOn would\nalso be set to ignore(1) if this object is set to ignore(1).\n\nIf the value is escapeToCommandMode(2), the modem remains\nconnected and enters command mode.  If the value is\ndisconnectCall(3), the current call (if any) is terminated\nand the modem will not auto-answer while DTR is off.  If the\nvalue is resetModem(4), the current call (if any) is\nterminated and the modem is reset.")
mdmDTEActionDTROffToOn = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("ignore", 1), ("enableDial", 2), ("autoAnswerEnable", 3), ("establishConnection", 4), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmDTEActionDTROffToOn.setDescription("Defines the action the modem will take when DTR is raised.\n\nIf the value is set to ignore(1), the modem takes no action\nwhen DTR is raised.  Typically, mdmDTEActionDTROnToOff would\nalso be set to ignore(1) if this object is set to ignore(1).\n\nIf the value is set to enableDial(2), the modem prepares to\ndial an outgoing call.  If the value is set to\nautoAnswerEnable(3), the modem will be configured to answer\nany incoming call.  If the value is set to\nestablishConnection(4), the modem dials an implementation\nspecific number.\n\nImmediately after any reset or power-on of the modem, if the\nDTR is high, the action specified here will be executed.")
mdmDTESyncTimingSource = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,2,)).subtype(namedValues=namedval.NamedValues(("internal", 1), ("external", 2), ("loopback", 3), ("network", 4), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmDTESyncTimingSource.setDescription("The clock source for synchronous transmissions.  If set to\ninternal(1), the modem is the clock source and sends the\nclock signals to the DTE.  If set to external(2), the\ntransmit clock signals are provided by the DTE.  If\nloopback(3), the modem receiver clock is used for the\ntransmit clock.  If network(4), the clock signals are\nsupplied by the DCE interface.\n\nIf the modem is not in synchronous mode, setting this object\nwill have no effect on the current operations of the modem.")
mdmDTESyncAsyncMode = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("async", 1), ("sync", 2), ("syncAfterDial", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmDTESyncAsyncMode.setDescription("The operational mode of the modem.  If the value is\nsyncAfterDial(3), the modem will accept commands in\nasynchronous mode and change to synchronous mode to pass\ndata after a dial sequence has been executed.")
mdmDTEInactivityTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 6, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmDTEInactivityTimeout.setDescription("The amount of idle time in minutes that the modem will wait\nbefore disconnecting a connection.  When a call is connected\nand no data is transferred (continuous marking condition) on\nboth circuits 103 and 104 for the specified time, the DCE\ndisconnects the call. If the value is 0, no idle disconnect\nwill occur.  This function applies to asynchronous dial\noperations only and is intended for administrative control\nover idle connections.")
mdmCallControlTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 7))
if mibBuilder.loadTexts: mdmCallControlTable.setDescription("The modem Call Control Table augments the modem ID table.")
mdmCallControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1))
if mibBuilder.loadTexts: mdmCallControlEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmCCRingsBeforeAnswer = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 1), Integer32().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmCCRingsBeforeAnswer.setDescription("Determines which ring the modem will wait to answer the\nphone on.  If this value is `0', the modem will not go\noffhook and answer a call when a ring signal is detected.")
mdmCCCallSetUpFailTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(30)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmCCCallSetUpFailTimer.setDescription("This parameter specifies the amount of time, in seconds,\nthat the modem shall allow between either answering a call\n(automatically or manually) or completion of dialing, and\nestablishment of a connection with the remote modem. If no\nconnection is established during this time, the modem\ndisconnects from the line and returns a result code\nindicating the cause of the disconnection. In TIA-602, this\nis controlled by the value in the S7 register.")
mdmCCResultCodeEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("numericEnabled", 2), ("verboseEnabled", 3), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmCCResultCodeEnable.setDescription("When disabled, the DCE shall issue no 'result codes' of any\nkind to the DTE either in response to unsolicited events\n(eg. ring signal), or commands. In TIA-602, this is\ncontrolled by the ATQ command.  When numericEnabled, the DCE\nshall issue result codes in numeric form.  When\nverboseEnabled, the DCE shall issue result codes in a\nverbose, textual form.")
mdmCCEscapeAction = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("ignoreEscape", 1), ("hangUp", 2), ("enterCommandMode", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmCCEscapeAction.setDescription("The modem's action upon successfully recognizing the\n'escape to command mode' character sequence.")
mdmCCCallDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmCCCallDuration.setDescription("Present or last completed connection time in seconds. If\nthere have been no previous connections, this value should\nbe -1.")
mdmCCConnectionFailReason = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 7, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(33,10,1,32,11,41,30,4,2,5,40,20,3,6,42,31,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("powerLoss", 10), ("equipmentFailure", 11), ("other", 2), ("dtrDrop", 20), ("managementCommand", 3), ("noDialTone", 30), ("lineBusy", 31), ("noAnswer", 32), ("voiceDetected", 33), ("inactivityTimeout", 4), ("carrierLost", 40), ("trainingFailed", 41), ("faxDetected", 42), ("mnpIncompatibility", 5), ("protocolError", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmCCConnectionFailReason.setDescription("Indicates the reason that the last connection or attempt\nfailed. The meaning of each reason code is explained below.\n\n   unknown:\nThis code means the failure reason is unknown or\nthere has been no previous call.\n\n   other:\nThis code used when no other code is applicable.\nAdditional vendor information may be available\nelsewhere.\n\n   managementCommand:\nA management command terminated the call.  These\ncommands include escaping to command mode, initiating\ndialing, restoring lines, and disconnecting.\n\n   inactivityTimeout:\nThe call was terminated because it was inactive for\nat the minimum duration specified.\n\n   mnpIncompatibility:\nThe modems are unable to resolve MNP protocol\ndifferences.\n\n   protocolError:\nAn error occured in one of protocol in use.  Further\ninformation is required to determine in which\nprotocol the error occurred, and the exact nature of\nthe error.\n\n   powerLoss:\nThe modem lost power and disconnected the call.\n\n   equipmentFailure:\nThe modem equipment failed.\n\n   dtrDrop:\nDTR has been turned off while the modem is to\ndisconnect on DTR drop. (Ref: V.58 cct108TurnedOff)\n\n   noDialTone:\nIf the modem is to monitor for call progress tones,\nbut the modem has failed to detect dial tone while\nattempting to dial a number.\n\n   lineBusy:\nBusy signal is detected while busy signal detection\nis enabled, or while the 'W' or '@' dial modifier is\nused. (Ref: V.58 engagedTone)\n\n   noAnswer:\nThe call was not answered.\n\n   voiceDetected:\nA voice was detected on the call.\n\n   carrierLost:\nIndicates that the modem has disconnected due to\ndetection of loss of carrier.  In TIA-602, the S10\nregister determines the time that loss of carrier\nmust be detected before the modem disconnects.\n\n   trainingFailed:\nIndicates that the modems did not successfully train\nand reach data mode on the previous connection.\n\n   faxDetected:\nA fax was detected on the call.")
mdmCCStoredDialStringTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 8))
if mibBuilder.loadTexts: mdmCCStoredDialStringTable.setDescription("The table of stored dial strings.")
mdmCCStoredDialStringEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 8, 1)).setIndexNames((0, "Modem-MIB", "mdmIndex"), (0, "Modem-MIB", "mdmCCStoredDialStringIndex"))
if mibBuilder.loadTexts: mdmCCStoredDialStringEntry.setDescription("A stored dial string.")
mdmCCStoredDialStringIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 8, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mdmCCStoredDialStringIndex.setDescription("The unique index of a particular dial string.")
mdmCCStoredDialString = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 8, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mdmCCStoredDialString.setDescription("A dial string stored in the modem.")
mdmECTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 9))
if mibBuilder.loadTexts: mdmECTable.setDescription("The modem error correcting table augments the modem ID\ntable.")
mdmECEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 9, 1))
if mibBuilder.loadTexts: mdmECEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmECErrorControlUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 9, 1, 1), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmECErrorControlUsed.setDescription("Indicates the error control method used during the current\nor previous call.  This shall be one of the values for error\ncontrol protocols registered in the capabilities table for\nthis modem.  If no error control protocol is in use, this\nobject shall have the value '{0 0}'.")
mdmDCTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 10))
if mibBuilder.loadTexts: mdmDCTable.setDescription("The modem data compression table augments the modem ID\ntable.")
mdmDCEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 10, 1))
if mibBuilder.loadTexts: mdmDCEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmDCCompressionTypeUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 10, 1, 1), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmDCCompressionTypeUsed.setDescription("Indicates the data compression method used during the\ncurrent or previous call.  This shall be one of the values\nfor compression protocols registered in the capabilities\ntable for this modem.  If no compression protocol is in use,\nthis object shall have the value '{0 0}'.")
mdmSCTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 11))
if mibBuilder.loadTexts: mdmSCTable.setDescription("The modem signal convertor table augments the modem ID\ntable.")
mdmSCEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1))
if mibBuilder.loadTexts: mdmSCEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmSCCurrentLineTransmitRate = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmSCCurrentLineTransmitRate.setDescription("The current link transmit rate of a connection, or the last\nlink transmit rate of the last connection in bits per\nsecond.")
mdmSCCurrentLineReceiveRate = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmSCCurrentLineReceiveRate.setDescription("The current link receive rate of a connection, or the last\nlink receive rate of the last connection in bits per\nsecond.")
mdmSCInitialLineTransmitRate = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmSCInitialLineTransmitRate.setDescription("The initial link transmit rate of the current connection,\nor the initial link transmit rate of the last connection in\nbits per second.")
mdmSCInitialLineReceiveRate = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmSCInitialLineReceiveRate.setDescription("The initial link receive rate of the current connection, or\nthe initial link receive rate of the last connection in bits\nper second.")
mdmSCModulationSchemeUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 11, 1, 5), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmSCModulationSchemeUsed.setDescription("The modulation scheme of the current or previous call.\nThis shall be one of the values for modulation protocols\nregistered in the capabilities table for this modem.")
mdmStatsTable = MibTable((1, 3, 6, 1, 2, 1, 38, 1, 1, 12))
if mibBuilder.loadTexts: mdmStatsTable.setDescription("The modem statistics Table augments the modem ID table.")
mdmStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1))
if mibBuilder.loadTexts: mdmStatsEntry.setDescription("Entries in this table are created only by the agent. One\nentry exists for each modem managed by the agent.")
mdmStatsRingNoAnswers = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsRingNoAnswers.setDescription("The number of events in which ringing was detected but the\ncall was not answered.")
mdmStatsIncomingConnectionFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsIncomingConnectionFailures.setDescription("The number of incoming connection requests that this modem\nanswered in which it could not train with the other DCE.")
mdmStatsIncomingConnectionCompletions = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsIncomingConnectionCompletions.setDescription("The number of incoming connection requests that this modem\nanswered and successfully trained with the other DCE.")
mdmStatsFailedDialAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsFailedDialAttempts.setDescription("The number of call attempts that failed because the modem\ndidn't go off hook, or there was no dialtone.")
mdmStatsOutgoingConnectionFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsOutgoingConnectionFailures.setDescription("The number of outgoing calls from this modem which\nsucessfully went off hook and dialed, in which it could not\ntrain with the other DCE.")
mdmStatsOutgoingConnectionCompletions = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsOutgoingConnectionCompletions.setDescription("The number of outgoing calls from this modem which resulted\nin successfully training with the other DCE.")
mdmStatsRetrains = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsRetrains.setDescription("The number of retrains experienced on connections on this\nline.")
mdmStats2400OrLessConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStats2400OrLessConnections.setDescription("The number of connections initially established at a\nmodulation speed of 2400 bits per second or less.")
mdmStats2400To14400Connections = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStats2400To14400Connections.setDescription("The number of connections initially established at a\nmodulation speed of greater than 2400 bits per second and\nless than 14400 bits per second.")
mdmStatsGreaterThan14400Connections = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsGreaterThan14400Connections.setDescription("The number of connections initially established at a\nmodulation speed of greater than 14400 bits per second.")
mdmStatsErrorControlledConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsErrorControlledConnections.setDescription("The number of established connections using an error\ncontrol protocol.")
mdmStatsCompressedConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsCompressedConnections.setDescription("The number of established connections using a compression\nprotocol.")
mdmStatsCompressionEfficiency = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsCompressionEfficiency.setDescription("The number of bytes transferred into the compression\nencoder divided by the number of bytes transferred out of\nthe encoder, multiplied by 100 for either the current or\nlast call.  If a data compression protocol is not in use,\nthis value shall be `100'.")
mdmStatsSentOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsSentOctets.setDescription("The number of octets presented to the modem by the DTE.")
mdmStatsReceivedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsReceivedOctets.setDescription("The number of octets presented to the DTE by the modem.")
mdmStatsSentDataFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsSentDataFrames.setDescription("The number of data frames sent on the line interface.  If\nthere is no frame-oriented protocol in use on the line\ninterface, this counter shall not increment.")
mdmStatsReceivedDataFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsReceivedDataFrames.setDescription("The number of data frames received on the line interface.\nIf there is no frame-oriented protocol in use on the line\ninterface, this counter shall not increment.")
mdmStatsResentFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsResentFrames.setDescription("The number of times this modem retransmits frames on the\nline interface.  If there is no frame-oriented protocol in\nuse on the line interface, this counter shall not\nincrement.")
mdmStatsErrorFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 38, 1, 1, 12, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mdmStatsErrorFrames.setDescription("The number of block errors received on the link.  If there\nis no frame-oriented protocol in use on the line interface,\nthis counter shall not increment.")
mdmConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 38, 1, 2))
mdmCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 38, 1, 2, 1))
mdmGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 38, 1, 2, 2))

# Augmentions
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmLineEntry"))
apply(mdmLineEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmStatsEntry"))
apply(mdmStatsEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmDTEInterfaceEntry"))
apply(mdmDTEInterfaceEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmDCEntry"))
apply(mdmDCEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmECEntry"))
apply(mdmECEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmCallControlEntry"))
apply(mdmCallControlEntry.setIndexNames, mdmIDEntry.getIndexNames())
mdmIDEntry.registerAugmentions(("Modem-MIB", "mdmSCEntry"))
apply(mdmSCEntry.setIndexNames, mdmIDEntry.getIndexNames())

# Groups

mdmDTEInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 3)).setObjects(("Modem-MIB", "mdmDTEActionDTROnToOff"), ("Modem-MIB", "mdmDTESyncAsyncMode"), ("Modem-MIB", "mdmDTEInactivityTimeout"), ("Modem-MIB", "mdmDTEActionDTROffToOn"), ("Modem-MIB", "mdmDTESyncTimingSource"), )
mdmErrorControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 5)).setObjects(("Modem-MIB", "mdmECErrorControlUsed"), )
mdmSignalConvertorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 7)).setObjects(("Modem-MIB", "mdmSCCurrentLineTransmitRate"), ("Modem-MIB", "mdmSCInitialLineReceiveRate"), ("Modem-MIB", "mdmSCModulationSchemeUsed"), ("Modem-MIB", "mdmSCInitialLineTransmitRate"), ("Modem-MIB", "mdmSCCurrentLineReceiveRate"), )
mdmStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 8)).setObjects(("Modem-MIB", "mdmStatsOutgoingConnectionFailures"), ("Modem-MIB", "mdmStatsOutgoingConnectionCompletions"), ("Modem-MIB", "mdmStatsFailedDialAttempts"), ("Modem-MIB", "mdmStatsSentOctets"), ("Modem-MIB", "mdmStatsResentFrames"), ("Modem-MIB", "mdmStatsCompressionEfficiency"), ("Modem-MIB", "mdmStats2400OrLessConnections"), ("Modem-MIB", "mdmStatsSentDataFrames"), ("Modem-MIB", "mdmStatsIncomingConnectionFailures"), ("Modem-MIB", "mdmStatsIncomingConnectionCompletions"), ("Modem-MIB", "mdmStatsErrorControlledConnections"), ("Modem-MIB", "mdmStats2400To14400Connections"), ("Modem-MIB", "mdmStatsReceivedOctets"), ("Modem-MIB", "mdmStatsRetrains"), ("Modem-MIB", "mdmStatsCompressedConnections"), ("Modem-MIB", "mdmStatsReceivedDataFrames"), ("Modem-MIB", "mdmStatsGreaterThan14400Connections"), ("Modem-MIB", "mdmStatsErrorFrames"), ("Modem-MIB", "mdmStatsRingNoAnswers"), )
mdmLineInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 2)).setObjects(("Modem-MIB", "mdmLineCapabilitiesEnableGranted"), ("Modem-MIB", "mdmLineCapabilitiesEnableRequested"), ("Modem-MIB", "mdmLineCapabilitiesID"), ("Modem-MIB", "mdmLineState"), ("Modem-MIB", "mdmLineCarrierLossTime"), )
mdmIDGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 1)).setObjects(("Modem-MIB", "mdmIDManufacturerOID"), ("Modem-MIB", "mdmIDProductDetails"), )
mdmCallControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 4)).setObjects(("Modem-MIB", "mdmCCCallSetUpFailTimer"), ("Modem-MIB", "mdmCCCallDuration"), ("Modem-MIB", "mdmCCEscapeAction"), ("Modem-MIB", "mdmCCStoredDialString"), ("Modem-MIB", "mdmCCResultCodeEnable"), ("Modem-MIB", "mdmCCConnectionFailReason"), ("Modem-MIB", "mdmCCRingsBeforeAnswer"), )
mdmDataCompressionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 38, 1, 2, 2, 6)).setObjects(("Modem-MIB", "mdmDCCompressionTypeUsed"), )

# Exports

# Module identity
mibBuilder.exportSymbols("Modem-MIB", PYSNMP_MODULE_ID=mdmMIB)

# Objects
mibBuilder.exportSymbols("Modem-MIB", mdmMib=mdmMib, mdmMIB=mdmMIB, mdmMIBObjects=mdmMIBObjects, mdmNumber=mdmNumber, mdmIDTable=mdmIDTable, mdmIDEntry=mdmIDEntry, mdmIndex=mdmIndex, mdmIDManufacturerOID=mdmIDManufacturerOID, mdmIDProductDetails=mdmIDProductDetails, mdmLineTable=mdmLineTable, mdmLineEntry=mdmLineEntry, mdmLineCarrierLossTime=mdmLineCarrierLossTime, mdmLineState=mdmLineState, mdmLineCapabilitiesTable=mdmLineCapabilitiesTable, mdmLineCapabilitiesEntry=mdmLineCapabilitiesEntry, mdmLineCapabilitiesIndex=mdmLineCapabilitiesIndex, mdmLineCapabilitiesID=mdmLineCapabilitiesID, mdmLineCapabilitiesEnableRequested=mdmLineCapabilitiesEnableRequested, mdmLineCapabilitiesEnableGranted=mdmLineCapabilitiesEnableGranted, mdmLineCapabilities=mdmLineCapabilities, mdmLineCapabilitiesV21=mdmLineCapabilitiesV21, mdmLineCapabilitiesV22=mdmLineCapabilitiesV22, mdmLineCapabilitiesV22bis=mdmLineCapabilitiesV22bis, mdmLineCapabilitiesV23CC=mdmLineCapabilitiesV23CC, mdmLineCapabilitiesV23SC=mdmLineCapabilitiesV23SC, mdmLineCapabilitiesV25bis=mdmLineCapabilitiesV25bis, mdmLineCapabilitiesV26bis=mdmLineCapabilitiesV26bis, mdmLineCapabilitiesV26ter=mdmLineCapabilitiesV26ter, mdmLineCapabilitiesV27ter=mdmLineCapabilitiesV27ter, mdmLineCapabilitiesV32=mdmLineCapabilitiesV32, mdmLineCapabilitiesV32bis=mdmLineCapabilitiesV32bis, mdmLineCapabilitiesV32terbo=mdmLineCapabilitiesV32terbo, mdmLineCapabilitiesVFC=mdmLineCapabilitiesVFC, mdmLineCapabilitiesV34=mdmLineCapabilitiesV34, mdmLineCapabilitiesV42=mdmLineCapabilitiesV42, mdmLineCapabilitiesV42bis=mdmLineCapabilitiesV42bis, mdmLineCapabilitiesMNP1=mdmLineCapabilitiesMNP1, mdmLineCapabilitiesMNP2=mdmLineCapabilitiesMNP2, mdmLineCapabilitiesMNP3=mdmLineCapabilitiesMNP3, mdmLineCapabilitiesMNP4=mdmLineCapabilitiesMNP4, mdmLineCapabilitiesMNP5=mdmLineCapabilitiesMNP5, mdmLineCapabilitiesMNP6=mdmLineCapabilitiesMNP6, mdmLineCapabilitiesMNP7=mdmLineCapabilitiesMNP7, mdmLineCapabilitiesMNP8=mdmLineCapabilitiesMNP8, mdmLineCapabilitiesMNP9=mdmLineCapabilitiesMNP9, mdmLineCapabilitiesMNP10=mdmLineCapabilitiesMNP10, mdmLineCapabilitiesV29=mdmLineCapabilitiesV29, mdmLineCapabilitiesV33=mdmLineCapabilitiesV33, mdmLineCapabilitiesBell208=mdmLineCapabilitiesBell208, mdmDTEInterfaceTable=mdmDTEInterfaceTable, mdmDTEInterfaceEntry=mdmDTEInterfaceEntry, mdmDTEActionDTROnToOff=mdmDTEActionDTROnToOff, mdmDTEActionDTROffToOn=mdmDTEActionDTROffToOn, mdmDTESyncTimingSource=mdmDTESyncTimingSource, mdmDTESyncAsyncMode=mdmDTESyncAsyncMode, mdmDTEInactivityTimeout=mdmDTEInactivityTimeout, mdmCallControlTable=mdmCallControlTable, mdmCallControlEntry=mdmCallControlEntry, mdmCCRingsBeforeAnswer=mdmCCRingsBeforeAnswer, mdmCCCallSetUpFailTimer=mdmCCCallSetUpFailTimer, mdmCCResultCodeEnable=mdmCCResultCodeEnable, mdmCCEscapeAction=mdmCCEscapeAction, mdmCCCallDuration=mdmCCCallDuration, mdmCCConnectionFailReason=mdmCCConnectionFailReason, mdmCCStoredDialStringTable=mdmCCStoredDialStringTable, mdmCCStoredDialStringEntry=mdmCCStoredDialStringEntry, mdmCCStoredDialStringIndex=mdmCCStoredDialStringIndex, mdmCCStoredDialString=mdmCCStoredDialString, mdmECTable=mdmECTable, mdmECEntry=mdmECEntry, mdmECErrorControlUsed=mdmECErrorControlUsed, mdmDCTable=mdmDCTable, mdmDCEntry=mdmDCEntry, mdmDCCompressionTypeUsed=mdmDCCompressionTypeUsed, mdmSCTable=mdmSCTable, mdmSCEntry=mdmSCEntry, mdmSCCurrentLineTransmitRate=mdmSCCurrentLineTransmitRate, mdmSCCurrentLineReceiveRate=mdmSCCurrentLineReceiveRate, mdmSCInitialLineTransmitRate=mdmSCInitialLineTransmitRate, mdmSCInitialLineReceiveRate=mdmSCInitialLineReceiveRate, mdmSCModulationSchemeUsed=mdmSCModulationSchemeUsed, mdmStatsTable=mdmStatsTable, mdmStatsEntry=mdmStatsEntry, mdmStatsRingNoAnswers=mdmStatsRingNoAnswers, mdmStatsIncomingConnectionFailures=mdmStatsIncomingConnectionFailures, mdmStatsIncomingConnectionCompletions=mdmStatsIncomingConnectionCompletions, mdmStatsFailedDialAttempts=mdmStatsFailedDialAttempts, mdmStatsOutgoingConnectionFailures=mdmStatsOutgoingConnectionFailures, mdmStatsOutgoingConnectionCompletions=mdmStatsOutgoingConnectionCompletions, mdmStatsRetrains=mdmStatsRetrains, mdmStats2400OrLessConnections=mdmStats2400OrLessConnections, mdmStats2400To14400Connections=mdmStats2400To14400Connections, mdmStatsGreaterThan14400Connections=mdmStatsGreaterThan14400Connections, mdmStatsErrorControlledConnections=mdmStatsErrorControlledConnections, mdmStatsCompressedConnections=mdmStatsCompressedConnections, mdmStatsCompressionEfficiency=mdmStatsCompressionEfficiency, mdmStatsSentOctets=mdmStatsSentOctets, mdmStatsReceivedOctets=mdmStatsReceivedOctets, mdmStatsSentDataFrames=mdmStatsSentDataFrames, mdmStatsReceivedDataFrames=mdmStatsReceivedDataFrames, mdmStatsResentFrames=mdmStatsResentFrames, mdmStatsErrorFrames=mdmStatsErrorFrames, mdmConformance=mdmConformance, mdmCompliances=mdmCompliances, mdmGroups=mdmGroups)

# Groups
mibBuilder.exportSymbols("Modem-MIB", mdmDTEInterfaceGroup=mdmDTEInterfaceGroup, mdmErrorControlGroup=mdmErrorControlGroup, mdmSignalConvertorGroup=mdmSignalConvertorGroup, mdmStatisticsGroup=mdmStatisticsGroup, mdmLineInterfaceGroup=mdmLineInterfaceGroup, mdmIDGroup=mdmIDGroup, mdmCallControlGroup=mdmCallControlGroup, mdmDataCompressionGroup=mdmDataCompressionGroup)
