# PySNMP SMI module. Autogenerated from smidump -f python PINT-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:31 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")
( sysApplInstallPkgEntry, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "sysApplInstallPkgEntry")

# Types

class PintPerfStatPeriod(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,4,2,1,)
    namedValues = namedval.NamedValues(("last30sec", 1), ("last15min", 2), ("last24Hr", 3), ("sinceReboot", 4), )
    pass

class PintServiceType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,4,1,3,)
    namedValues = namedval.NamedValues(("r2C", 1), ("r2F", 2), ("r2FB", 3), ("r2HC", 4), )
    pass


# Objects

pintMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 93)).setRevisions(("2001-02-01 00:00",))
if mibBuilder.loadTexts: pintMib.setOrganization("IETF PINT Working Group")
if mibBuilder.loadTexts: pintMib.setContactInfo("\nChairs:  Steve Bellovin\n            E-mail: smb@research.att.com\n\n            Igor Faynberg\n            E-mail: faynberg@lucent.com\n\nAuthors: Murali Krishnaswamy\n             Postal: 20 Corporate Place South\n                        Piscataway, NJ 08854\n                        Tel:    +1 (732)465-1000\n\n\n                        E-mail: murali@photuris.com\n\n                        Dan Romascanu\n                        Postal: Atidim Technology Park, Bldg 3\n                        Tel Aviv, Israel\n                        Tel:    +972 3 6458414\n                        E-mail: dromasca@avaya.com\n\nGeneral Discussion:pint@lists.bell-labs.com\nTo Subscribe: pint-request@lists.bell-labs.com\nIn Body: subscribe your-email-addres\nArchive: http://www.bell-labs.com/mailing-lists/pint/")
if mibBuilder.loadTexts: pintMib.setDescription("This MIB defines the objects necessary to monitor\nPINT Services")
pintServerConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 1))
pintReleaseNumber = MibScalar((1, 3, 6, 1, 2, 1, 93, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintReleaseNumber.setDescription("An indication of version of the PINT protocol supported\nby this agent.")
pintSysContact = MibScalar((1, 3, 6, 1, 2, 1, 93, 1, 2), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pintSysContact.setDescription("Contact information related to the administration of the PINT\nservices.")
pintApplInstallPkgTable = MibTable((1, 3, 6, 1, 2, 1, 93, 1, 3))
if mibBuilder.loadTexts: pintApplInstallPkgTable.setDescription("Table describing the PINT applications that are installed.")
pintApplInstallPkgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 1, 3, 1))
if mibBuilder.loadTexts: pintApplInstallPkgEntry.setDescription("Entries per PINT Application.")
pintApplInstallPkgDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 1, 3, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintApplInstallPkgDescription.setDescription("Textual description of the installed PINT application.")
pintRegisteredGatewayTable = MibTable((1, 3, 6, 1, 2, 1, 93, 1, 4))
if mibBuilder.loadTexts: pintRegisteredGatewayTable.setDescription("Table describing the registered gateway applications.")
pintRegisteredGatewayEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 1, 4, 1))
if mibBuilder.loadTexts: pintRegisteredGatewayEntry.setDescription("Entries per Registered Gateway Application.")
pintRegisteredGatewayName = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 1, 4, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintRegisteredGatewayName.setDescription("Name of the registered gateway.")
pintRegisteredGatewayDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 1, 4, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintRegisteredGatewayDescription.setDescription("Textual description of the registered gateway.")
pintServerMonitor = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 2))
pintServerGlobalPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 2, 1))
pintServerGlobalStatsTable = MibTable((1, 3, 6, 1, 2, 1, 93, 2, 1, 1))
if mibBuilder.loadTexts: pintServerGlobalStatsTable.setDescription("Table displaying the monitored global server statistics.")
pintServerGlobalStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1)).setIndexNames((0, "PINT-MIB", "pintServerServiceTypeIndex"), (0, "PINT-MIB", "pintServerPerfStatPeriodIndex"))
if mibBuilder.loadTexts: pintServerGlobalStatsEntry.setDescription("Entries in the global statistics table.\nOne entry is defined for each monitored service type and\nperformance statistics collection period.")
pintServerServiceTypeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 1), PintServiceType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pintServerServiceTypeIndex.setDescription("The unique identifier of the monitored service.")
pintServerPerfStatPeriodIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 2), PintPerfStatPeriod()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pintServerPerfStatPeriodIndex.setDescription("Time period for which the performance statistics are requested\nfrom the pint server.")
pintServerGlobalCallsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalCallsReceived.setDescription("Number of received global calls.")
pintServerGlobalSuccessfulCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalSuccessfulCalls.setDescription("Number of global successful calls.")
pintServerGlobalDisconnectedCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalDisconnectedCalls.setDescription("Number of global disconnected (failed) calls.")
pintServerGlobalDisCUAutFCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalDisCUAutFCalls.setDescription("Number of global calls that were disconnected because of client\nor user authorization failure.")
pintServerGlobalDisServProbCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalDisServProbCalls.setDescription("Number of global calls that were disconnected because of\nserver problems.")
pintServerGlobalDisGatProbCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 1, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGlobalDisGatProbCalls.setDescription("Number of global calls that were disconnected because of\ngateway problems.")
pintServerClientPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 2, 2))
pintServerClientStatsTable = MibTable((1, 3, 6, 1, 2, 1, 93, 2, 2, 1))
if mibBuilder.loadTexts: pintServerClientStatsTable.setDescription("Table displaying the monitored server client statistics.")
pintServerClientStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1)).setIndexNames((0, "PINT-MIB", "pintServerClientAddress"), (0, "PINT-MIB", "pintServerServiceTypeIndex"), (0, "PINT-MIB", "pintServerPerfStatPeriodIndex"))
if mibBuilder.loadTexts: pintServerClientStatsEntry.setDescription("Entries in the client server statistics table.\nOne entry is defined for each client identified by name,\nmonitored service type and performance statistics collection\nperiod.")
pintServerClientAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 1), SnmpAdminString()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pintServerClientAddress.setDescription("The unique identifier of the monitored client\nidentified by its address represented as as a string.")
pintServerClientCallsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerClientCallsReceived.setDescription("Number of calls received from the specific client.")
pintServerClientSuccessfulCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerClientSuccessfulCalls.setDescription("Number of calls from the client successfully completed.")
pintServerClientDisconnectedCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerClientDisconnectedCalls.setDescription("Number of calls received from the client, and that were\ndisconnected (failed).")
pintServerClientDisCAutFCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerClientDisCAutFCalls.setDescription("Number of calls from the client that were disconnected because of\nclient authorization failure.")
pintServerClientDisEFProbCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerClientDisEFProbCalls.setDescription("Number of calls from the client that were disconnected because\nof egress facility problems.")
pintServerUserIdPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 2, 3))
pintServerUserIdStatsTable = MibTable((1, 3, 6, 1, 2, 1, 93, 2, 3, 1))
if mibBuilder.loadTexts: pintServerUserIdStatsTable.setDescription("Table displaying the monitored Pint service user statistics.")
pintServerUserIdStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1)).setIndexNames((0, "PINT-MIB", "pintServerUserIdName"), (0, "PINT-MIB", "pintServerServiceTypeIndex"), (0, "PINT-MIB", "pintServerPerfStatPeriodIndex"))
if mibBuilder.loadTexts: pintServerUserIdStatsEntry.setDescription("Entries in the user statistics table.\nOne entry is defined for each user identified by name,\neach monitored service type and performance statistics collection\nperiod.\n\n It is assumed that the capabilities of the pint server\n are enough to accommodate the number of entries in this table.\n It is a local server implementation issue if an aging mechanism\n Is implemented in order to avoid scalability problems.")
pintServerUserIdName = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pintServerUserIdName.setDescription("The unique identifier of the monitored user\nidentified by its name.")
pintServerUserIdCallsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerUserIdCallsReceived.setDescription("Number of calls received from the specific user.")
pintServerUserIdSuccessfulCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerUserIdSuccessfulCalls.setDescription("Number of calls from the user successfully completed.")
pintServerUserIdDisconnectedCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerUserIdDisconnectedCalls.setDescription("Number of calls received from the user that were\ndisconnected (failed).")
pintServerUserIdDiscUIdAFailCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerUserIdDiscUIdAFailCalls.setDescription("Number of calls from the user that were disconnected because of\nuser authorization failure.")
pintServerUserIdEFProbCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 3, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerUserIdEFProbCalls.setDescription("Number of calls from the user that were disconnected because of\negress facility problems.")
pintServerGatewayPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 2, 4))
pintServerGatewayStatsTable = MibTable((1, 3, 6, 1, 2, 1, 93, 2, 4, 1))
if mibBuilder.loadTexts: pintServerGatewayStatsTable.setDescription("Table displaying the monitored gateway statistics.")
pintServerGatewayStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 93, 2, 4, 1, 1)).setIndexNames((0, "PINT-MIB", "pintRegisteredGatewayName"), (0, "PINT-MIB", "pintServerServiceTypeIndex"), (0, "PINT-MIB", "pintServerPerfStatPeriodIndex"))
if mibBuilder.loadTexts: pintServerGatewayStatsEntry.setDescription("Entries in the gateway table.\nOne entry is defined for each gateway identified by name,\neach monitored service type and performance statistics collection\nperiod.")
pintServerGatewayCallsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 4, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGatewayCallsReceived.setDescription("Number of calls received at the specified gateway.")
pintServerGatewaySuccessfulCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 4, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGatewaySuccessfulCalls.setDescription("Number of calls successfully completed at the specified gateway.")
pintServerGatewayDisconnectedCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 93, 2, 4, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pintServerGatewayDisconnectedCalls.setDescription("Number of calls that were disconnected (failed) at the specified\ngateway.")
pintMibConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 3))
pintMibCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 3, 1))
pintMibGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 93, 3, 2))

# Augmentions
sysApplInstallPkgEntry, = mibBuilder.importSymbols("SYSAPPL-MIB", "sysApplInstallPkgEntry")
sysApplInstallPkgEntry.registerAugmentions(("PINT-MIB", "pintRegisteredGatewayEntry"))
apply(pintRegisteredGatewayEntry.setIndexNames, sysApplInstallPkgEntry.getIndexNames())
sysApplInstallPkgEntry, = mibBuilder.importSymbols("SYSAPPL-MIB", "sysApplInstallPkgEntry")
sysApplInstallPkgEntry.registerAugmentions(("PINT-MIB", "pintApplInstallPkgEntry"))
apply(pintApplInstallPkgEntry.setIndexNames, sysApplInstallPkgEntry.getIndexNames())

# Groups

pintMibMonitorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 93, 3, 2, 2)).setObjects(("PINT-MIB", "pintServerGatewayCallsReceived"), ("PINT-MIB", "pintServerGatewaySuccessfulCalls"), ("PINT-MIB", "pintServerGlobalDisGatProbCalls"), ("PINT-MIB", "pintServerGlobalSuccessfulCalls"), ("PINT-MIB", "pintServerUserIdDisconnectedCalls"), ("PINT-MIB", "pintServerClientDisEFProbCalls"), ("PINT-MIB", "pintServerClientSuccessfulCalls"), ("PINT-MIB", "pintServerGlobalDisconnectedCalls"), ("PINT-MIB", "pintServerUserIdEFProbCalls"), ("PINT-MIB", "pintServerGlobalDisCUAutFCalls"), ("PINT-MIB", "pintServerGlobalDisServProbCalls"), ("PINT-MIB", "pintServerGatewayDisconnectedCalls"), ("PINT-MIB", "pintServerClientCallsReceived"), ("PINT-MIB", "pintServerGlobalCallsReceived"), ("PINT-MIB", "pintServerUserIdSuccessfulCalls"), ("PINT-MIB", "pintServerUserIdCallsReceived"), ("PINT-MIB", "pintServerUserIdDiscUIdAFailCalls"), ("PINT-MIB", "pintServerClientDisconnectedCalls"), ("PINT-MIB", "pintServerClientDisCAutFCalls"), )
pintMibConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 93, 3, 2, 1)).setObjects(("PINT-MIB", "pintSysContact"), ("PINT-MIB", "pintApplInstallPkgDescription"), ("PINT-MIB", "pintRegisteredGatewayDescription"), ("PINT-MIB", "pintReleaseNumber"), ("PINT-MIB", "pintRegisteredGatewayName"), )

# Exports

# Module identity
mibBuilder.exportSymbols("PINT-MIB", PYSNMP_MODULE_ID=pintMib)

# Types
mibBuilder.exportSymbols("PINT-MIB", PintPerfStatPeriod=PintPerfStatPeriod, PintServiceType=PintServiceType)

# Objects
mibBuilder.exportSymbols("PINT-MIB", pintMib=pintMib, pintServerConfig=pintServerConfig, pintReleaseNumber=pintReleaseNumber, pintSysContact=pintSysContact, pintApplInstallPkgTable=pintApplInstallPkgTable, pintApplInstallPkgEntry=pintApplInstallPkgEntry, pintApplInstallPkgDescription=pintApplInstallPkgDescription, pintRegisteredGatewayTable=pintRegisteredGatewayTable, pintRegisteredGatewayEntry=pintRegisteredGatewayEntry, pintRegisteredGatewayName=pintRegisteredGatewayName, pintRegisteredGatewayDescription=pintRegisteredGatewayDescription, pintServerMonitor=pintServerMonitor, pintServerGlobalPerf=pintServerGlobalPerf, pintServerGlobalStatsTable=pintServerGlobalStatsTable, pintServerGlobalStatsEntry=pintServerGlobalStatsEntry, pintServerServiceTypeIndex=pintServerServiceTypeIndex, pintServerPerfStatPeriodIndex=pintServerPerfStatPeriodIndex, pintServerGlobalCallsReceived=pintServerGlobalCallsReceived, pintServerGlobalSuccessfulCalls=pintServerGlobalSuccessfulCalls, pintServerGlobalDisconnectedCalls=pintServerGlobalDisconnectedCalls, pintServerGlobalDisCUAutFCalls=pintServerGlobalDisCUAutFCalls, pintServerGlobalDisServProbCalls=pintServerGlobalDisServProbCalls, pintServerGlobalDisGatProbCalls=pintServerGlobalDisGatProbCalls, pintServerClientPerf=pintServerClientPerf, pintServerClientStatsTable=pintServerClientStatsTable, pintServerClientStatsEntry=pintServerClientStatsEntry, pintServerClientAddress=pintServerClientAddress, pintServerClientCallsReceived=pintServerClientCallsReceived, pintServerClientSuccessfulCalls=pintServerClientSuccessfulCalls, pintServerClientDisconnectedCalls=pintServerClientDisconnectedCalls, pintServerClientDisCAutFCalls=pintServerClientDisCAutFCalls, pintServerClientDisEFProbCalls=pintServerClientDisEFProbCalls, pintServerUserIdPerf=pintServerUserIdPerf, pintServerUserIdStatsTable=pintServerUserIdStatsTable, pintServerUserIdStatsEntry=pintServerUserIdStatsEntry, pintServerUserIdName=pintServerUserIdName, pintServerUserIdCallsReceived=pintServerUserIdCallsReceived, pintServerUserIdSuccessfulCalls=pintServerUserIdSuccessfulCalls, pintServerUserIdDisconnectedCalls=pintServerUserIdDisconnectedCalls, pintServerUserIdDiscUIdAFailCalls=pintServerUserIdDiscUIdAFailCalls, pintServerUserIdEFProbCalls=pintServerUserIdEFProbCalls, pintServerGatewayPerf=pintServerGatewayPerf, pintServerGatewayStatsTable=pintServerGatewayStatsTable, pintServerGatewayStatsEntry=pintServerGatewayStatsEntry, pintServerGatewayCallsReceived=pintServerGatewayCallsReceived, pintServerGatewaySuccessfulCalls=pintServerGatewaySuccessfulCalls, pintServerGatewayDisconnectedCalls=pintServerGatewayDisconnectedCalls, pintMibConformance=pintMibConformance, pintMibCompliances=pintMibCompliances, pintMibGroups=pintMibGroups)

# Groups
mibBuilder.exportSymbols("PINT-MIB", pintMibMonitorGroup=pintMibMonitorGroup, pintMibConfigGroup=pintMibConfigGroup)
