# PySNMP SMI module. Autogenerated from smidump -f python RMON-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:35 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( DisplayString, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention")

# Types

class EntryStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,3,2,1,)
    namedValues = namedval.NamedValues(("valid", 1), ("createRequest", 2), ("underCreation", 3), ("invalid", 4), )
    pass

class OwnerString(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,127)
    pass


# Objects

rmon = MibIdentifier((1, 3, 6, 1, 2, 1, 16))
rmonEventsV2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 16, 0))
if mibBuilder.loadTexts: rmonEventsV2.setDescription("Definition point for RMON notifications.")
statistics = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 1))
etherStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 1, 1))
if mibBuilder.loadTexts: etherStatsTable.setDescription("A list of Ethernet statistics entries.")
etherStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 1, 1, 1)).setIndexNames((0, "RMON-MIB", "etherStatsIndex"))
if mibBuilder.loadTexts: etherStatsEntry.setDescription("A collection of statistics kept for a particular\nEthernet interface.  As an example, an instance of the\netherStatsPkts object might be named etherStatsPkts.1")
etherStatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsIndex.setDescription("The value of this object uniquely identifies this\netherStats entry.")
etherStatsDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsDataSource.setDescription("This object identifies the source of the data that\nthis etherStats entry is configured to analyze.  This\nsource can be any ethernet interface on this device.\nIn order to identify a particular interface, this object\nshall identify the instance of the ifIndex object,\ndefined in RFC 2233 [17], for the desired interface.\nFor example, if an entry were to receive data from\ninterface #1, this object would be set to ifIndex.1.\n\nThe statistics in this group reflect all packets\non the local network segment attached to the identified\ninterface.\n\nAn agent may or may not be able to tell if fundamental\nchanges to the media of the interface have occurred and\nnecessitate an invalidation of this entry.  For example, a\nhot-pluggable ethernet card could be pulled out and replaced\nby a token-ring card.  In such a case, if the agent has such\nknowledge of the change, it is recommended that it\ninvalidate this entry.\n\nThis object may not be modified if the associated\netherStatsStatus object is equal to valid(1).")
etherStatsDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsDropEvents.setDescription("The total number of events in which packets\nwere dropped by the probe due to lack of resources.\nNote that this number is not necessarily the number of\npackets dropped; it is just the number of times this\ncondition has been detected.")
etherStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOctets.setDescription("The total number of octets of data (including\nthose in bad packets) received on the\nnetwork (excluding framing bits but including\nFCS octets).\nThis object can be used as a reasonable estimate of\n10-Megabit ethernet utilization.  If greater precision is\ndesired, the etherStatsPkts and etherStatsOctets objects\nshould be sampled before and after a common interval.  The\ndifferences in the sampled values are Pkts and Octets,\nrespectively, and the number of seconds in the interval is\nInterval.  These values are used to calculate the Utilization\nas follows:\n\n                 Pkts * (9.6 + 6.4) + (Octets * .8)\n Utilization = -------------------------------------\n                         Interval * 10,000\n\nThe result of this equation is the value Utilization which\nis the percent utilization of the ethernet segment on a\nscale of 0 to 100 percent.")
etherStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts.setDescription("The total number of packets (including bad packets,\nbroadcast packets, and multicast packets) received.")
etherStatsBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsBroadcastPkts.setDescription("The total number of good packets received that were\ndirected to the broadcast address.  Note that this\ndoes not include multicast packets.")
etherStatsMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsMulticastPkts.setDescription("The total number of good packets received that were\ndirected to a multicast address.  Note that this number\ndoes not include packets directed to the broadcast\naddress.")
etherStatsCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCRCAlignErrors.setDescription("The total number of packets received that\nhad a length (excluding framing bits, but\nincluding FCS octets) of between 64 and 1518\noctets, inclusive, but had either a bad\nFrame Check Sequence (FCS) with an integral\nnumber of octets (FCS Error) or a bad FCS with\na non-integral number of octets (Alignment Error).")
etherStatsUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsUndersizePkts.setDescription("The total number of packets received that were\nless than 64 octets long (excluding framing bits,\nbut including FCS octets) and were otherwise well\nformed.")
etherStatsOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOversizePkts.setDescription("The total number of packets received that were\nlonger than 1518 octets (excluding framing bits,\nbut including FCS octets) and were otherwise\nwell formed.")
etherStatsFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsFragments.setDescription("The total number of packets received that were less than\n64 octets in length (excluding framing bits but including\nFCS octets) and had either a bad Frame Check Sequence\n(FCS) with an integral number of octets (FCS Error) or a\nbad FCS with a non-integral number of octets (Alignment\nError).\n\nNote that it is entirely normal for etherStatsFragments to\nincrement.  This is because it counts both runts (which are\nnormal occurrences due to collisions) and noise hits.")
etherStatsJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsJabbers.setDescription("The total number of packets received that were\nlonger than 1518 octets (excluding framing bits,\nbut including FCS octets), and had either a bad\nFrame Check Sequence (FCS) with an integral number\nof octets (FCS Error) or a bad FCS with a non-integral\nnumber of octets (Alignment Error).\n\nNote that this definition of jabber is different\nthan the definition in IEEE-802.3 section 8.2.1.5\n(10BASE5) and section 10.3.1.4 (10BASE2).  These\ndocuments define jabber as the condition where any\npacket exceeds 20 ms.  The allowed range to detect\njabber is between 20 ms and 150 ms.")
etherStatsCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCollisions.setDescription("The best estimate of the total number of collisions\non this Ethernet segment.\n\nThe value returned will depend on the location of the\nRMON probe. Section 8.2.1.3 (10BASE-5) and section\n10.3.1.3 (10BASE-2) of IEEE standard 802.3 states that a\nstation must detect a collision, in the receive mode, if\nthree or more stations are transmitting simultaneously.  A\nrepeater port must detect a collision when two or more\nstations are transmitting simultaneously.  Thus a probe\nplaced on a repeater port could record more collisions\nthan a probe connected to a station on the same segment\nwould.\n\nProbe location plays a much smaller role when considering\n10BASE-T.  14.2.1.4 (10BASE-T) of IEEE standard 802.3\ndefines a collision as the simultaneous presence of signals\non the DO and RD circuits (transmitting and receiving\nat the same time).  A 10BASE-T station can only detect\ncollisions when it is transmitting.  Thus probes placed on\na station and a repeater, should report the same number of\ncollisions.\n\nNote also that an RMON probe inside a repeater should\nideally report collisions between the repeater and one or\nmore other hosts (transmit collisions as defined by IEEE\n802.3k) plus receiver collisions observed on any coax\nsegments to which the repeater is connected.")
etherStatsPkts64Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts64Octets.setDescription("The total number of packets (including bad\npackets) received that were 64 octets in length\n(excluding framing bits but including FCS octets).")
etherStatsPkts65to127Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts65to127Octets.setDescription("The total number of packets (including bad\npackets) received that were between\n65 and 127 octets in length inclusive\n(excluding framing bits but including FCS octets).")
etherStatsPkts128to255Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts128to255Octets.setDescription("The total number of packets (including bad\npackets) received that were between\n128 and 255 octets in length inclusive\n(excluding framing bits but including FCS octets).")
etherStatsPkts256to511Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts256to511Octets.setDescription("The total number of packets (including bad\npackets) received that were between\n256 and 511 octets in length inclusive\n(excluding framing bits but including FCS octets).")
etherStatsPkts512to1023Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts512to1023Octets.setDescription("The total number of packets (including bad\npackets) received that were between\n512 and 1023 octets in length inclusive\n(excluding framing bits but including FCS octets).")
etherStatsPkts1024to1518Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts1024to1518Octets.setDescription("The total number of packets (including bad\npackets) received that were between\n1024 and 1518 octets in length inclusive\n(excluding framing bits but including FCS octets).")
etherStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 20), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
etherStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 21), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsStatus.setDescription("The status of this etherStats entry.")
history = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 2))
historyControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 1))
if mibBuilder.loadTexts: historyControlTable.setDescription("A list of history control entries.")
historyControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 1, 1)).setIndexNames((0, "RMON-MIB", "historyControlIndex"))
if mibBuilder.loadTexts: historyControlEntry.setDescription("A list of parameters that set up a periodic sampling of\nstatistics.  As an example, an instance of the\nhistoryControlInterval object might be named\nhistoryControlInterval.2")
historyControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlIndex.setDescription("An index that uniquely identifies an entry in the\nhistoryControl table.  Each such entry defines a\nset of samples at a particular interval for an\ninterface on the device.")
historyControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlDataSource.setDescription("This object identifies the source of the data for\nwhich historical data was collected and\nplaced in a media-specific table on behalf of this\nhistoryControlEntry.  This source can be any\ninterface on this device.  In order to identify\na particular interface, this object shall identify\nthe instance of the ifIndex object, defined\nin  RFC 2233 [17], for the desired interface.\nFor example, if an entry were to receive data from\ninterface #1, this object would be set to ifIndex.1.\n\nThe statistics in this group reflect all packets\non the local network segment attached to the identified\ninterface.\n\nAn agent may or may not be able to tell if fundamental\nchanges to the media of the interface have occurred and\nnecessitate an invalidation of this entry.  For example, a\nhot-pluggable ethernet card could be pulled out and replaced\nby a token-ring card.  In such a case, if the agent has such\nknowledge of the change, it is recommended that it\ninvalidate this entry.\n\nThis object may not be modified if the associated\nhistoryControlStatus object is equal to valid(1).")
historyControlBucketsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(50)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlBucketsRequested.setDescription("The requested number of discrete time intervals\nover which data is to be saved in the part of the\nmedia-specific table associated with this\nhistoryControlEntry.\n\nWhen this object is created or modified, the probe\nshould set historyControlBucketsGranted as closely to\nthis object as is possible for the particular probe\nimplementation and available resources.")
historyControlBucketsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlBucketsGranted.setDescription("The number of discrete sampling intervals\nover which data shall be saved in the part of\nthe media-specific table associated with this\nhistoryControlEntry.\nWhen the associated historyControlBucketsRequested\nobject is created or modified, the probe\nshould set this object as closely to the requested\nvalue as is possible for the particular\nprobe implementation and available resources.  The\nprobe must not lower this value except as a result\nof a modification to the associated\nhistoryControlBucketsRequested object.\n\nThere will be times when the actual number of\nbuckets associated with this entry is less than\nthe value of this object.  In this case, at the\nend of each sampling interval, a new bucket will\nbe added to the media-specific table.\n\nWhen the number of buckets reaches the value of\nthis object and a new bucket is to be added to the\nmedia-specific table, the oldest bucket associated\nwith this historyControlEntry shall be deleted by\nthe agent so that the new bucket can be added.\n\nWhen the value of this object changes to a value less\nthan the current value, entries are deleted\nfrom the media-specific table associated with this\nhistoryControlEntry.  Enough of the oldest of these\nentries shall be deleted by the agent so that their\nnumber remains less than or equal to the new value of\nthis object.\n\nWhen the value of this object changes to a value greater\nthan the current value, the number of associated media-\nspecific entries may be allowed to grow.")
historyControlInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 3600)).clone(1800)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlInterval.setDescription("The interval in seconds over which the data is\nsampled for each bucket in the part of the\nmedia-specific table associated with this\nhistoryControlEntry.  This interval can\nbe set to any number of seconds between 1 and\n3600 (1 hour).\n\nBecause the counters in a bucket may overflow at their\nmaximum value with no indication, a prudent manager will\ntake into account the possibility of overflow in any of\nthe associated counters.  It is important to consider the\nminimum time in which any counter could overflow on a\nparticular media type and set the historyControlInterval\nobject to a value less than this interval.  This is\ntypically most important for the 'octets' counter in any\nmedia-specific table.  For example, on an Ethernet\nnetwork, the etherHistoryOctets counter could overflow\nin about one hour at the Ethernet's maximum\nutilization.\n\nThis object may not be modified if the associated\nhistoryControlStatus object is equal to valid(1).")
historyControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 6), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
historyControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 7), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlStatus.setDescription("The status of this historyControl entry.\n\nEach instance of the media-specific table associated\nwith this historyControlEntry will be deleted by the agent\nif this historyControlEntry is not equal to valid(1).")
etherHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 2))
if mibBuilder.loadTexts: etherHistoryTable.setDescription("A list of Ethernet history entries.")
etherHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 2, 1)).setIndexNames((0, "RMON-MIB", "etherHistoryIndex"), (0, "RMON-MIB", "etherHistorySampleIndex"))
if mibBuilder.loadTexts: etherHistoryEntry.setDescription("An historical sample of Ethernet statistics on a particular\nEthernet interface.  This sample is associated with the\nhistoryControlEntry which set up the parameters for\na regular collection of these samples.  As an example, an\ninstance of the etherHistoryPkts object might be named\netherHistoryPkts.2.89")
etherHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIndex.setDescription("The history of which this entry is a part.  The\nhistory identified by a particular value of this\nindex is the same history as identified\nby the same value of historyControlIndex.")
etherHistorySampleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistorySampleIndex.setDescription("An index that uniquely identifies the particular\nsample this entry represents among all samples\nassociated with the same historyControlEntry.\nThis index starts at 1 and increases by one\nas each new sample is taken.")
etherHistoryIntervalStart = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIntervalStart.setDescription("The value of sysUpTime at the start of the interval\nover which this sample was measured.  If the probe\nkeeps track of the time of day, it should start\nthe first sample of the history at a time such that\nwhen the next hour of the day begins, a sample is\nstarted at that instant.  Note that following this\nrule may require the probe to delay collecting the\nfirst sample of the history, as each sample must be\nof the same interval.  Also note that the sample which\nis currently being collected is not accessible in this\ntable until the end of its interval.")
etherHistoryDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryDropEvents.setDescription("The total number of events in which packets\nwere dropped by the probe due to lack of resources\nduring this sampling interval.  Note that this number\nis not necessarily the number of packets dropped, it\nis just the number of times this condition has been\ndetected.")
etherHistoryOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOctets.setDescription("The total number of octets of data (including\nthose in bad packets) received on the\nnetwork (excluding framing bits but including\nFCS octets).")
etherHistoryPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryPkts.setDescription("The number of packets (including bad packets)\nreceived during this sampling interval.")
etherHistoryBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryBroadcastPkts.setDescription("The number of good packets received during this\nsampling interval that were directed to the\nbroadcast address.")
etherHistoryMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryMulticastPkts.setDescription("The number of good packets received during this\nsampling interval that were directed to a\nmulticast address.  Note that this number does not\ninclude packets addressed to the broadcast address.")
etherHistoryCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCRCAlignErrors.setDescription("The number of packets received during this\nsampling interval that had a length (excluding\nframing bits but including FCS octets) between\n64 and 1518 octets, inclusive, but had either a bad Frame\nCheck Sequence (FCS) with an integral number of octets\n(FCS Error) or a bad FCS with a non-integral number\nof octets (Alignment Error).")
etherHistoryUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUndersizePkts.setDescription("The number of packets received during this\nsampling interval that were less than 64 octets\nlong (excluding framing bits but including FCS\noctets) and were otherwise well formed.")
etherHistoryOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOversizePkts.setDescription("The number of packets received during this\nsampling interval that were longer than 1518\noctets (excluding framing bits but including\nFCS octets) but were otherwise well formed.")
etherHistoryFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryFragments.setDescription("The total number of packets received during this\nsampling interval that were less than 64 octets in\nlength (excluding framing bits but including FCS\noctets) had either a bad Frame Check Sequence (FCS)\nwith an integral number of octets (FCS Error) or a bad\nFCS with a non-integral number of octets (Alignment\nError).\n\nNote that it is entirely normal for etherHistoryFragments to\nincrement.  This is because it counts both runts (which are\nnormal occurrences due to collisions) and noise hits.")
etherHistoryJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryJabbers.setDescription("The number of packets received during this\nsampling interval that were longer than 1518 octets\n(excluding framing bits but including FCS octets),\nand  had either a bad Frame Check Sequence (FCS)\nwith an integral number of octets (FCS Error) or\na bad FCS with a non-integral number of octets\n(Alignment Error).\n\nNote that this definition of jabber is different\nthan the definition in IEEE-802.3 section 8.2.1.5\n(10BASE5) and section 10.3.1.4 (10BASE2).  These\ndocuments define jabber as the condition where any\npacket exceeds 20 ms.  The allowed range to detect\njabber is between 20 ms and 150 ms.")
etherHistoryCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCollisions.setDescription("The best estimate of the total number of collisions\non this Ethernet segment during this sampling\ninterval.\n\nThe value returned will depend on the location of the\nRMON probe. Section 8.2.1.3 (10BASE-5) and section\n10.3.1.3 (10BASE-2) of IEEE standard 802.3 states that a\nstation must detect a collision, in the receive mode, if\nthree or more stations are transmitting simultaneously.  A\nrepeater port must detect a collision when two or more\nstations are transmitting simultaneously.  Thus a probe\nplaced on a repeater port could record more collisions\nthan a probe connected to a station on the same segment\nwould.\n\nProbe location plays a much smaller role when considering\n10BASE-T.  14.2.1.4 (10BASE-T) of IEEE standard 802.3\ndefines a collision as the simultaneous presence of signals\non the DO and RD circuits (transmitting and receiving\nat the same time).  A 10BASE-T station can only detect\ncollisions when it is transmitting.  Thus probes placed on\na station and a repeater, should report the same number of\ncollisions.\n\nNote also that an RMON probe inside a repeater should\nideally report collisions between the repeater and one or\nmore other hosts (transmit collisions as defined by IEEE\n802.3k) plus receiver collisions observed on any coax\nsegments to which the repeater is connected.")
etherHistoryUtilization = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 10000))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUtilization.setDescription("The best estimate of the mean physical layer\nnetwork utilization on this interface during this\nsampling interval, in hundredths of a percent.")
alarm = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 3))
alarmTable = MibTable((1, 3, 6, 1, 2, 1, 16, 3, 1))
if mibBuilder.loadTexts: alarmTable.setDescription("A list of alarm entries.")
alarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 3, 1, 1)).setIndexNames((0, "RMON-MIB", "alarmIndex"))
if mibBuilder.loadTexts: alarmEntry.setDescription("A list of parameters that set up a periodic checking\nfor alarm conditions.  For example, an instance of the\nalarmValue object might be named alarmValue.8")
alarmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmIndex.setDescription("An index that uniquely identifies an entry in the\nalarm table.  Each such entry defines a\ndiagnostic sample at a particular interval\nfor an object on the device.")
alarmInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 2), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmInterval.setDescription("The interval in seconds over which the data is\nsampled and compared with the rising and falling\nthresholds.  When setting this variable, care\nshould be taken in the case of deltaValue\nsampling - the interval should be set short enough\nthat the sampled variable is very unlikely to\nincrease or decrease by more than 2^31 - 1 during\na single sampling interval.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmVariable = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 3), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmVariable.setDescription("The object identifier of the particular variable to be\nsampled.  Only variables that resolve to an ASN.1 primitive\ntype of INTEGER (INTEGER, Integer32, Counter32, Counter64,\nGauge, or TimeTicks) may be sampled.\n\nBecause SNMP access control is articulated entirely\nin terms of the contents of MIB views, no access\ncontrol mechanism exists that can restrict the value of\nthis object to identify only those objects that exist\nin a particular MIB view.  Because there is thus no\nacceptable means of restricting the read access that\ncould be obtained through the alarm mechanism, the\nprobe must only grant write access to this object in\nthose views that have read access to all objects on\nthe probe.\n\nDuring a set operation, if the supplied variable name is\nnot available in the selected MIB view, a badValue error\nmust be returned.  If at any time the variable name of\nan established alarmEntry is no longer available in the\nselected MIB view, the probe must change the status of\nthis alarmEntry to invalid(4).\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmSampleType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("absoluteValue", 1), ("deltaValue", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmSampleType.setDescription("The method of sampling the selected variable and\ncalculating the value to be compared against the\nthresholds.  If the value of this object is\nabsoluteValue(1), the value of the selected variable\nwill be compared directly with the thresholds at the\nend of the sampling interval.  If the value of this\nobject is deltaValue(2), the value of the selected\nvariable at the last sample will be subtracted from\nthe current value, and the difference compared with\nthe thresholds.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmValue = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmValue.setDescription("The value of the statistic during the last sampling\nperiod.  For example, if the sample type is deltaValue,\nthis value will be the difference between the samples\nat the beginning and end of the period.  If the sample\ntype is absoluteValue, this value will be the sampled\nvalue at the end of the period.\nThis is the value that is compared with the rising and\nfalling thresholds.\n\nThe value during the current sampling period is not\nmade available until the period is completed and will\nremain available until the next period completes.")
alarmStartupAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("risingAlarm", 1), ("fallingAlarm", 2), ("risingOrFallingAlarm", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmStartupAlarm.setDescription("The alarm that may be sent when this entry is first\nset to valid.  If the first sample after this entry\nbecomes valid is greater than or equal to the\nrisingThreshold and alarmStartupAlarm is equal to\nrisingAlarm(1) or risingOrFallingAlarm(3), then a single\nrising alarm will be generated.  If the first sample\nafter this entry becomes valid is less than or equal\nto the fallingThreshold and alarmStartupAlarm is equal\nto fallingAlarm(2) or risingOrFallingAlarm(3), then a\nsingle falling alarm will be generated.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmRisingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 7), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmRisingThreshold.setDescription("A threshold for the sampled statistic.  When the current\nsampled value is greater than or equal to this threshold,\nand the value at the last sampling interval was less than\nthis threshold, a single event will be generated.\nA single event will also be generated if the first\nsample after this entry becomes valid is greater than or\nequal to this threshold and the associated\nalarmStartupAlarm is equal to risingAlarm(1) or\nrisingOrFallingAlarm(3).\n\nAfter a rising event is generated, another such event\nwill not be generated until the sampled value\nfalls below this threshold and reaches the\nalarmFallingThreshold.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmFallingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 8), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmFallingThreshold.setDescription("A threshold for the sampled statistic.  When the current\nsampled value is less than or equal to this threshold,\nand the value at the last sampling interval was greater than\nthis threshold, a single event will be generated.\nA single event will also be generated if the first\nsample after this entry becomes valid is less than or\nequal to this threshold and the associated\nalarmStartupAlarm is equal to fallingAlarm(2) or\nrisingOrFallingAlarm(3).\n\nAfter a falling event is generated, another such event\nwill not be generated until the sampled value\nrises above this threshold and reaches the\nalarmRisingThreshold.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmRisingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmRisingEventIndex.setDescription("The index of the eventEntry that is\nused when a rising threshold is crossed.  The\neventEntry identified by a particular value of\nthis index is the same as identified by the same value\nof the eventIndex object.  If there is no\ncorresponding entry in the eventTable, then\nno association exists.  In particular, if this value\nis zero, no associated event will be generated, as\nzero is not a valid event index.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmFallingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmFallingEventIndex.setDescription("The index of the eventEntry that is\nused when a falling threshold is crossed.  The\neventEntry identified by a particular value of\nthis index is the same as identified by the same value\nof the eventIndex object.  If there is no\ncorresponding entry in the eventTable, then\nno association exists.  In particular, if this value\nis zero, no associated event will be generated, as\nzero is not a valid event index.\n\nThis object may not be modified if the associated\nalarmStatus object is equal to valid(1).")
alarmOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 11), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
alarmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 12), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmStatus.setDescription("The status of this alarm entry.")
hosts = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 4))
hostControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 1))
if mibBuilder.loadTexts: hostControlTable.setDescription("A list of host table control entries.")
hostControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 1, 1)).setIndexNames((0, "RMON-MIB", "hostControlIndex"))
if mibBuilder.loadTexts: hostControlEntry.setDescription("A list of parameters that set up the discovery of hosts\non a particular interface and the collection of statistics\nabout these hosts.  For example, an instance of the\nhostControlTableSize object might be named\nhostControlTableSize.1")
hostControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlIndex.setDescription("An index that uniquely identifies an entry in the\nhostControl table.  Each such entry defines\na function that discovers hosts on a particular interface\nand places statistics about them in the hostTable and\nthe hostTimeTable on behalf of this hostControlEntry.")
hostControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlDataSource.setDescription("This object identifies the source of the data for\nthis instance of the host function.  This source\ncan be any interface on this device.  In order\nto identify a particular interface, this object shall\nidentify the instance of the ifIndex object, defined\nin RFC 2233 [17], for the desired interface.\nFor example, if an entry were to receive data from\ninterface #1, this object would be set to ifIndex.1.\n\nThe statistics in this group reflect all packets\non the local network segment attached to the identified\ninterface.\n\nAn agent may or may not be able to tell if fundamental\nchanges to the media of the interface have occurred and\nnecessitate an invalidation of this entry.  For example, a\nhot-pluggable ethernet card could be pulled out and replaced\nby a token-ring card.  In such a case, if the agent has such\nknowledge of the change, it is recommended that it\ninvalidate this entry.\n\nThis object may not be modified if the associated\nhostControlStatus object is equal to valid(1).")
hostControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlTableSize.setDescription("The number of hostEntries in the hostTable and the\nhostTimeTable associated with this hostControlEntry.")
hostControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlLastDeleteTime.setDescription("The value of sysUpTime when the last entry\nwas deleted from the portion of the hostTable\nassociated with this hostControlEntry.  If no\ndeletions have occurred, this value shall be zero.")
hostControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 5), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
hostControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 6), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlStatus.setDescription("The status of this hostControl entry.\n\nIf this object is not equal to valid(1), all associated\nentries in the hostTable, hostTimeTable, and the\nhostTopNTable shall be deleted by the agent.")
hostTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 2))
if mibBuilder.loadTexts: hostTable.setDescription("A list of host entries.")
hostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 2, 1)).setIndexNames((0, "RMON-MIB", "hostIndex"), (0, "RMON-MIB", "hostAddress"))
if mibBuilder.loadTexts: hostEntry.setDescription("A collection of statistics for a particular host that has\nbeen discovered on an interface of this device.  For example,\nan instance of the hostOutBroadcastPkts object might be\nnamed hostOutBroadcastPkts.1.6.8.0.32.27.3.176")
hostAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostAddress.setDescription("The physical address of this host.")
hostCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostCreationOrder.setDescription("An index that defines the relative ordering of\nthe creation time of hosts captured for a\nparticular hostControlEntry.  This index shall\nbe between 1 and N, where N is the value of\nthe associated hostControlTableSize.  The ordering\nof the indexes is based on the order of each entry's\ninsertion into the table, in which entries added earlier\nhave a lower index value than entries added later.\n\nIt is important to note that the order for a\nparticular entry may change as an (earlier) entry\nis deleted from the table.  Because this order may\nchange, management stations should make use of the\nhostControlLastDeleteTime variable in the\nhostControlEntry associated with the relevant\nportion of the hostTable.  By observing\nthis variable, the management station may detect\nthe circumstances where a previous association\nbetween a value of hostCreationOrder\nand a hostEntry may no longer hold.")
hostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostIndex.setDescription("The set of collected host statistics of which\nthis entry is a part.  The set of hosts\nidentified by a particular value of this\nindex is associated with the hostControlEntry\nas identified by the same value of hostControlIndex.")
hostInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInPkts.setDescription("The number of good packets transmitted to this\naddress since it was added to the hostTable.")
hostOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutPkts.setDescription("The number of packets, including bad packets, transmitted\nby this address since it was added to the hostTable.")
hostInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInOctets.setDescription("The number of octets transmitted to this address since\nit was added to the hostTable (excluding framing\nbits but including FCS octets), except for those\noctets in bad packets.")
hostOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutOctets.setDescription("The number of octets transmitted by this address since\nit was added to the hostTable (excluding framing\nbits but including FCS octets), including those\noctets in bad packets.")
hostOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutErrors.setDescription("The number of bad packets transmitted by this address\nsince this host was added to the hostTable.")
hostOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutBroadcastPkts.setDescription("The number of good packets transmitted by this\naddress that were directed to the broadcast address\nsince this host was added to the hostTable.")
hostOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutMulticastPkts.setDescription("The number of good packets transmitted by this\naddress that were directed to a multicast address\nsince this host was added to the hostTable.\nNote that this number does not include packets\ndirected to the broadcast address.")
hostTimeTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 3))
if mibBuilder.loadTexts: hostTimeTable.setDescription("A list of time-ordered host table entries.")
hostTimeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 3, 1)).setIndexNames((0, "RMON-MIB", "hostTimeIndex"), (0, "RMON-MIB", "hostTimeCreationOrder"))
if mibBuilder.loadTexts: hostTimeEntry.setDescription("A collection of statistics for a particular host that has\nbeen discovered on an interface of this device.  This\ncollection includes the relative ordering of the creation\ntime of this object.  For example, an instance of the\nhostTimeOutBroadcastPkts object might be named\nhostTimeOutBroadcastPkts.1.687")
hostTimeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeAddress.setDescription("The physical address of this host.")
hostTimeCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeCreationOrder.setDescription("An index that uniquely identifies an entry in\nthe hostTime table among those entries associated\nwith the same hostControlEntry.  This index shall\nbe between 1 and N, where N is the value of\nthe associated hostControlTableSize.  The ordering\nof the indexes is based on the order of each entry's\ninsertion into the table, in which entries added earlier\nhave a lower index value than entries added later.\nThus the management station has the ability to\nlearn of new entries added to this table without\ndownloading the entire table.\n\nIt is important to note that the index for a\nparticular entry may change as an (earlier) entry\nis deleted from the table.  Because this order may\nchange, management stations should make use of the\nhostControlLastDeleteTime variable in the\nhostControlEntry associated with the relevant\nportion of the hostTimeTable.  By observing\nthis variable, the management station may detect\nthe circumstances where a download of the table\nmay have missed entries, and where a previous\nassociation between a value of hostTimeCreationOrder\nand a hostTimeEntry may no longer hold.")
hostTimeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeIndex.setDescription("The set of collected host statistics of which\nthis entry is a part.  The set of hosts\nidentified by a particular value of this\nindex is associated with the hostControlEntry\nas identified by the same value of hostControlIndex.")
hostTimeInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInPkts.setDescription("The number of good packets transmitted to this\naddress since it was added to the hostTimeTable.")
hostTimeOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutPkts.setDescription("The number of packets, including bad packets, transmitted\nby this address since it was added to the hostTimeTable.")
hostTimeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInOctets.setDescription("The number of octets transmitted to this address since\nit was added to the hostTimeTable (excluding framing\nbits but including FCS octets), except for those\noctets in bad packets.")
hostTimeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutOctets.setDescription("The number of octets transmitted by this address since\nit was added to the hostTimeTable (excluding framing\nbits but including FCS octets), including those\noctets in bad packets.")
hostTimeOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutErrors.setDescription("The number of bad packets transmitted by this address\nsince this host was added to the hostTimeTable.")
hostTimeOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutBroadcastPkts.setDescription("The number of good packets transmitted by this\naddress that were directed to the broadcast address\nsince this host was added to the hostTimeTable.")
hostTimeOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutMulticastPkts.setDescription("The number of good packets transmitted by this\naddress that were directed to a multicast address\nsince this host was added to the hostTimeTable.\nNote that this number does not include packets directed\nto the broadcast address.")
hostTopN = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 5))
hostTopNControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 1))
if mibBuilder.loadTexts: hostTopNControlTable.setDescription("A list of top N host control entries.")
hostTopNControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 1, 1)).setIndexNames((0, "RMON-MIB", "hostTopNControlIndex"))
if mibBuilder.loadTexts: hostTopNControlEntry.setDescription("A set of parameters that control the creation of a report\nof the top N hosts according to several metrics.  For\nexample, an instance of the hostTopNDuration object might\nbe named hostTopNDuration.3")
hostTopNControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNControlIndex.setDescription("An index that uniquely identifies an entry\nin the hostTopNControl table.  Each such\nentry defines one top N report prepared for\none interface.")
hostTopNHostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNHostIndex.setDescription("The host table for which a top N report will be prepared\non behalf of this entry.  The host table identified by a\nparticular value of this index is associated with the same\nhost table as identified by the same value of\nhostIndex.\n\nThis object may not be modified if the associated\nhostTopNStatus object is equal to valid(1).")
hostTopNRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,2,4,6,1,3,7,)).subtype(namedValues=namedval.NamedValues(("hostTopNInPkts", 1), ("hostTopNOutPkts", 2), ("hostTopNInOctets", 3), ("hostTopNOutOctets", 4), ("hostTopNOutErrors", 5), ("hostTopNOutBroadcastPkts", 6), ("hostTopNOutMulticastPkts", 7), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNRateBase.setDescription("The variable for each host that the hostTopNRate\nvariable is based upon.\n\nThis object may not be modified if the associated\nhostTopNStatus object is equal to valid(1).")
hostTopNTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 4), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNTimeRemaining.setDescription("The number of seconds left in the report currently being\ncollected.  When this object is modified by the management\nstation, a new collection is started, possibly aborting\na currently running report.  The new value is used\nas the requested duration of this report, which is\nloaded into the associated hostTopNDuration object.\n\nWhen this object is set to a non-zero value, any\nassociated hostTopNEntries shall be made\ninaccessible by the monitor.  While the value of this\nobject is non-zero, it decrements by one per second until\nit reaches zero.  During this time, all associated\nhostTopNEntries shall remain inaccessible.  At the time\nthat this object decrements to zero, the report is made\naccessible in the hostTopNTable.  Thus, the hostTopN\ntable needs to be created only at the end of the collection\ninterval.")
hostTopNDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 5), Integer32().clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNDuration.setDescription("The number of seconds that this report has collected\nduring the last sampling interval, or if this\nreport is currently being collected, the number\nof seconds that this report is being collected\nduring this sampling interval.\n\nWhen the associated hostTopNTimeRemaining object is set,\nthis object shall be set by the probe to the same value\nand shall not be modified until the next time\nthe hostTopNTimeRemaining is set.\n\nThis value shall be zero if no reports have been\nrequested for this hostTopNControlEntry.")
hostTopNRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 6), Integer32().clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNRequestedSize.setDescription("The maximum number of hosts requested for the top N\ntable.\n\nWhen this object is created or modified, the probe\nshould set hostTopNGrantedSize as closely to this\nobject as is possible for the particular probe\nimplementation and available resources.")
hostTopNGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNGrantedSize.setDescription("The maximum number of hosts in the top N table.\n\nWhen the associated hostTopNRequestedSize object is\ncreated or modified, the probe should set this\nobject as closely to the requested value as is possible\nfor the particular implementation and available\nresources. The probe must not lower this value except\nas a result of a set to the associated\nhostTopNRequestedSize object.\n\nHosts with the highest value of hostTopNRate shall be\nplaced in this table in decreasing order of this rate\nuntil there is no more room or until there are no more\nhosts.")
hostTopNStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNStartTime.setDescription("The value of sysUpTime when this top N report was\nlast started.  In other words, this is the time that\nthe associated hostTopNTimeRemaining object was\nmodified to start the requested report.")
hostTopNOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 9), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
hostTopNStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 10), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNStatus.setDescription("The status of this hostTopNControl entry.\n\nIf this object is not equal to valid(1), all associated\nhostTopNEntries shall be deleted by the agent.")
hostTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 2))
if mibBuilder.loadTexts: hostTopNTable.setDescription("A list of top N host entries.")
hostTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 2, 1)).setIndexNames((0, "RMON-MIB", "hostTopNReport"), (0, "RMON-MIB", "hostTopNIndex"))
if mibBuilder.loadTexts: hostTopNEntry.setDescription("A set of statistics for a host that is part of a top N\nreport.  For example, an instance of the hostTopNRate\nobject might be named hostTopNRate.3.10")
hostTopNReport = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNReport.setDescription("This object identifies the top N report of which\nthis entry is a part.  The set of hosts\nidentified by a particular value of this\nobject is part of the same report as identified\nby the same value of the hostTopNControlIndex object.")
hostTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNIndex.setDescription("An index that uniquely identifies an entry in\nthe hostTopN table among those in the same report.\nThis index is between 1 and N, where N is the\nnumber of entries in this table.  Increasing values\nof hostTopNIndex shall be assigned to entries with\ndecreasing values of hostTopNRate until index N\nis assigned to the entry with the lowest value of\nhostTopNRate or there are no more hostTopNEntries.")
hostTopNAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNAddress.setDescription("The physical address of this host.")
hostTopNRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNRate.setDescription("The amount of change in the selected variable\nduring this sampling interval.  The selected\nvariable is this host's instance of the object\nselected by hostTopNRateBase.")
matrix = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 6))
matrixControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 1))
if mibBuilder.loadTexts: matrixControlTable.setDescription("A list of information entries for the\ntraffic matrix on each interface.")
matrixControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 1, 1)).setIndexNames((0, "RMON-MIB", "matrixControlIndex"))
if mibBuilder.loadTexts: matrixControlEntry.setDescription("Information about a traffic matrix on a particular\ninterface.  For example, an instance of the\nmatrixControlLastDeleteTime object might be named\nmatrixControlLastDeleteTime.1")
matrixControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlIndex.setDescription("An index that uniquely identifies an entry in the\nmatrixControl table.  Each such entry defines\na function that discovers conversations on a particular\ninterface and places statistics about them in the\nmatrixSDTable and the matrixDSTable on behalf of this\nmatrixControlEntry.")
matrixControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlDataSource.setDescription("This object identifies the source of\nthe data from which this entry creates a traffic matrix.\nThis source can be any interface on this device.  In\norder to identify a particular interface, this object\nshall identify the instance of the ifIndex object,\ndefined in RFC 2233 [17], for the desired\ninterface.  For example, if an entry were to receive data\nfrom interface #1, this object would be set to ifIndex.1.\n\nThe statistics in this group reflect all packets\non the local network segment attached to the identified\ninterface.\n\nAn agent may or may not be able to tell if fundamental\nchanges to the media of the interface have occurred and\nnecessitate an invalidation of this entry.  For example, a\nhot-pluggable ethernet card could be pulled out and replaced\nby a token-ring card.  In such a case, if the agent has such\nknowledge of the change, it is recommended that it\ninvalidate this entry.\n\nThis object may not be modified if the associated\nmatrixControlStatus object is equal to valid(1).")
matrixControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlTableSize.setDescription("The number of matrixSDEntries in the matrixSDTable\nfor this interface.  This must also be the value of\nthe number of entries in the matrixDSTable for this\ninterface.")
matrixControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlLastDeleteTime.setDescription("The value of sysUpTime when the last entry\nwas deleted from the portion of the matrixSDTable\nor matrixDSTable associated with this matrixControlEntry.\nIf no deletions have occurred, this value shall be\nzero.")
matrixControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 5), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
matrixControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 6), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlStatus.setDescription("The status of this matrixControl entry.\nIf this object is not equal to valid(1), all associated\nentries in the matrixSDTable and the matrixDSTable\nshall be deleted by the agent.")
matrixSDTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 2))
if mibBuilder.loadTexts: matrixSDTable.setDescription("A list of traffic matrix entries indexed by\nsource and destination MAC address.")
matrixSDEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 2, 1)).setIndexNames((0, "RMON-MIB", "matrixSDIndex"), (0, "RMON-MIB", "matrixSDSourceAddress"), (0, "RMON-MIB", "matrixSDDestAddress"))
if mibBuilder.loadTexts: matrixSDEntry.setDescription("A collection of statistics for communications between\ntwo addresses on a particular interface.  For example,\nan instance of the matrixSDPkts object might be named\nmatrixSDPkts.1.6.8.0.32.27.3.176.6.8.0.32.10.8.113")
matrixSDSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDSourceAddress.setDescription("The source physical address.")
matrixSDDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDDestAddress.setDescription("The destination physical address.")
matrixSDIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDIndex.setDescription("The set of collected matrix statistics of which\nthis entry is a part.  The set of matrix statistics\nidentified by a particular value of this index\nis associated with the same matrixControlEntry\nas identified by the same value of matrixControlIndex.")
matrixSDPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDPkts.setDescription("The number of packets transmitted from the source\naddress to the destination address (this number includes\nbad packets).")
matrixSDOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDOctets.setDescription("The number of octets (excluding framing bits but\nincluding FCS octets) contained in all packets\ntransmitted from the source address to the\ndestination address.")
matrixSDErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDErrors.setDescription("The number of bad packets transmitted from\nthe source address to the destination address.")
matrixDSTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 3))
if mibBuilder.loadTexts: matrixDSTable.setDescription("A list of traffic matrix entries indexed by\ndestination and source MAC address.")
matrixDSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 3, 1)).setIndexNames((0, "RMON-MIB", "matrixDSIndex"), (0, "RMON-MIB", "matrixDSDestAddress"), (0, "RMON-MIB", "matrixDSSourceAddress"))
if mibBuilder.loadTexts: matrixDSEntry.setDescription("A collection of statistics for communications between\ntwo addresses on a particular interface.  For example,\nan instance of the matrixSDPkts object might be named\nmatrixSDPkts.1.6.8.0.32.10.8.113.6.8.0.32.27.3.176")
matrixDSSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSSourceAddress.setDescription("The source physical address.")
matrixDSDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSDestAddress.setDescription("The destination physical address.")
matrixDSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSIndex.setDescription("The set of collected matrix statistics of which\nthis entry is a part.  The set of matrix statistics\nidentified by a particular value of this index\nis associated with the same matrixControlEntry\nas identified by the same value of matrixControlIndex.")
matrixDSPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSPkts.setDescription("The number of packets transmitted from the source\naddress to the destination address (this number includes\nbad packets).")
matrixDSOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSOctets.setDescription("The number of octets (excluding framing bits\nbut including FCS octets) contained in all packets\ntransmitted from the source address to the\ndestination address.")
matrixDSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSErrors.setDescription("The number of bad packets transmitted from\nthe source address to the destination address.")
filter = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 7))
filterTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 1))
if mibBuilder.loadTexts: filterTable.setDescription("A list of packet filter entries.")
filterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 1, 1)).setIndexNames((0, "RMON-MIB", "filterIndex"))
if mibBuilder.loadTexts: filterEntry.setDescription("A set of parameters for a packet filter applied on a\nparticular interface.  As an example, an instance of the\nfilterPktData object might be named filterPktData.12")
filterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: filterIndex.setDescription("An index that uniquely identifies an entry\nin the filter table.  Each such entry defines\none filter that is to be applied to every packet\nreceived on an interface.")
filterChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterChannelIndex.setDescription("This object identifies the channel of which this filter\nis a part.  The filters identified by a particular value\nof this object are associated with the same channel as\nidentified by the same value of the channelIndex object.")
filterPktDataOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 3), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataOffset.setDescription("The offset from the beginning of each packet where\na match of packet data will be attempted.  This offset\nis measured from the point in the physical layer\npacket after the framing bits, if any.  For example,\nin an Ethernet frame, this point is at the beginning of\nthe destination MAC address.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 4), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktData.setDescription("The data that is to be matched with the input packet.\nFor each packet received, this filter and the accompanying\nfilterPktDataMask and filterPktDataNotMask will be\nadjusted for the offset.  The only bits relevant to this\nmatch algorithm are those that have the corresponding\nfilterPktDataMask bit equal to one.  The following three\nrules are then applied to every packet:\n\n(1) If the packet is too short and does not have data\n    corresponding to part of the filterPktData, the packet\n    will fail this data match.\n\n(2) For each relevant bit from the packet with the\n    corresponding filterPktDataNotMask bit set to zero, if\n    the bit from the packet is not equal to the corresponding\n    bit from the filterPktData, then the packet will fail\n    this data match.\n\n(3) If for every relevant bit from the packet with the\n    corresponding filterPktDataNotMask bit set to one, the\n    bit from the packet is equal to the corresponding bit\n    from the filterPktData, then the packet will fail this\n    data match.\n\nAny packets that have not failed any of the three matches\nabove have passed this data match.  In particular, a zero\nlength filter will match any packet.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktDataMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 5), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataMask.setDescription("The mask that is applied to the match process.\nAfter adjusting this mask for the offset, only those\nbits in the received packet that correspond to bits set\nin this mask are relevant for further processing by the\nmatch algorithm.  The offset is applied to filterPktDataMask\nin the same way it is applied to the filter.  For the\npurposes of the matching algorithm, if the associated\nfilterPktData object is longer than this mask, this mask is\nconceptually extended with '1' bits until it reaches the\nlength of the filterPktData object.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktDataNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 6), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataNotMask.setDescription("The inversion mask that is applied to the match\nprocess.  After adjusting this mask for the offset,\nthose relevant bits in the received packet that correspond\nto bits cleared in this mask must all be equal to their\ncorresponding bits in the filterPktData object for the packet\nto be accepted.  In addition, at least one of those relevant\nbits in the received packet that correspond to bits set in\nthis mask must be different to its corresponding bit in the\nfilterPktData object.\n\nFor the purposes of the matching algorithm, if the associated\nfilterPktData object is longer than this mask, this mask is\nconceptually extended with '0' bits until it reaches the\nlength of the filterPktData object.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 7), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatus.setDescription("The status that is to be matched with the input packet.\nThe only bits relevant to this match algorithm are those that\nhave the corresponding filterPktStatusMask bit equal to one.\nThe following two rules are then applied to every packet:\n\n(1) For each relevant bit from the packet status with the\n    corresponding filterPktStatusNotMask bit set to zero, if\n    the bit from the packet status is not equal to the\n    corresponding bit from the filterPktStatus, then the\n    packet will fail this status match.\n\n(2) If for every relevant bit from the packet status with the\n    corresponding filterPktStatusNotMask bit set to one, the\n    bit from the packet status is equal to the corresponding\n    bit from the filterPktStatus, then the packet will fail\n    this status match.\n\nAny packets that have not failed either of the two matches\nabove have passed this status match.  In particular, a zero\nlength status filter will match any packet's status.\n\nThe value of the packet status is a sum.  This sum\ninitially takes the value zero.  Then, for each\nerror, E, that has been discovered in this packet,\n2 raised to a value representing E is added to the sum.\nThe errors and the bits that represent them are dependent\non the media type of the interface that this channel\nis receiving packets from.\n\nThe errors defined for a packet captured off of an\nEthernet interface are as follows:\n\n    bit #    Error\n        0    Packet is longer than 1518 octets\n        1    Packet is shorter than 64 octets\n        2    Packet experienced a CRC or Alignment error\n\nFor example, an Ethernet fragment would have a\nvalue of 6 (2^1 + 2^2).\n\nAs this MIB is expanded to new media types, this object\nwill have other media-specific errors defined.\n\nFor the purposes of this status matching algorithm, if the\npacket status is longer than this filterPktStatus object,\nthis object is conceptually extended with '0' bits until it\nreaches the size of the packet status.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktStatusMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 8), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatusMask.setDescription("The mask that is applied to the status match process.\nOnly those bits in the received packet that correspond to\nbits set in this mask are relevant for further processing\nby the status match algorithm.  For the purposes\nof the matching algorithm, if the associated filterPktStatus\nobject is longer than this mask, this mask is conceptually\nextended with '1' bits until it reaches the size of the\nfilterPktStatus.  In addition, if a packet status is longer\nthan this mask, this mask is conceptually extended with '0'\nbits until it reaches the size of the packet status.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterPktStatusNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 9), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatusNotMask.setDescription("The inversion mask that is applied to the status match\nprocess.  Those relevant bits in the received packet status\nthat correspond to bits cleared in this mask must all be\nequal to their corresponding bits in the filterPktStatus\nobject for the packet to be accepted.  In addition, at least\none of those relevant bits in the received packet status\nthat correspond to bits set in this mask must be different\nto its corresponding bit in the filterPktStatus object for\nthe packet to be accepted.\n\nFor the purposes of the matching algorithm, if the associated\nfilterPktStatus object or a packet status is longer than this\nmask, this mask is conceptually extended with '0' bits until\nit reaches the longer of the lengths of the filterPktStatus\nobject and the packet status.\n\nThis object may not be modified if the associated\nfilterStatus object is equal to valid(1).")
filterOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 10), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
filterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 11), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterStatus.setDescription("The status of this filter entry.")
channelTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 2))
if mibBuilder.loadTexts: channelTable.setDescription("A list of packet channel entries.")
channelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 2, 1)).setIndexNames((0, "RMON-MIB", "channelIndex"))
if mibBuilder.loadTexts: channelEntry.setDescription("A set of parameters for a packet channel applied on a\nparticular interface.  As an example, an instance of the\nchannelMatches object might be named channelMatches.3")
channelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: channelIndex.setDescription("An index that uniquely identifies an entry in the channel\ntable.  Each such entry defines one channel, a logical\ndata and event stream.\n\nIt is suggested that before creating a channel, an\napplication should scan all instances of the\nfilterChannelIndex object to make sure that there are no\npre-existing filters that would be inadvertently be linked\nto the channel.")
channelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device to which\nthe associated filters are applied to allow data into this\nchannel.  The interface identified by a particular value\nof this object is the same interface as identified by the\nsame value of the ifIndex object, defined in RFC 2233 [17].\n\nThe filters in this group are applied to all packets on\nthe local network segment attached to the identified\ninterface.\n\nAn agent may or may not be able to tell if fundamental\nchanges to the media of the interface have occurred and\nnecessitate an invalidation of this entry.  For example, a\nhot-pluggable ethernet card could be pulled out and replaced\nby a token-ring card.  In such a case, if the agent has such\nknowledge of the change, it is recommended that it\ninvalidate this entry.\n\nThis object may not be modified if the associated\nchannelStatus object is equal to valid(1).")
channelAcceptType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("acceptMatched", 1), ("acceptFailed", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelAcceptType.setDescription("This object controls the action of the filters\nassociated with this channel.  If this object is equal\nto acceptMatched(1), packets will be accepted to this\nchannel if they are accepted by both the packet data and\npacket status matches of an associated filter.  If\nthis object is equal to acceptFailed(2), packets will\nbe accepted to this channel only if they fail either\nthe packet data match or the packet status match of\neach of the associated filters.\n\nIn particular, a channel with no associated filters will\nmatch no packets if set to acceptMatched(1) case and will\nmatch all packets in the acceptFailed(2) case.\n\nThis object may not be modified if the associated\nchannelStatus object is equal to valid(1).")
channelDataControl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("on", 1), ("off", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelDataControl.setDescription("This object controls the flow of data through this channel.\nIf this object is on(1), data, status and events flow\nthrough this channel.  If this object is off(2), data,\nstatus and events will not flow through this channel.")
channelTurnOnEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelTurnOnEventIndex.setDescription("The value of this object identifies the event\nthat is configured to turn the associated\nchannelDataControl from off to on when the event is\ngenerated.  The event identified by a particular value\nof this object is the same event as identified by the\nsame value of the eventIndex object.  If there is no\ncorresponding entry in the eventTable, then no\nassociation exists.  In fact, if no event is intended\nfor this channel, channelTurnOnEventIndex must be\nset to zero, a non-existent event index.\nThis object may not be modified if the associated\nchannelStatus object is equal to valid(1).")
channelTurnOffEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelTurnOffEventIndex.setDescription("The value of this object identifies the event\nthat is configured to turn the associated\nchannelDataControl from on to off when the event is\ngenerated.  The event identified by a particular value\nof this object is the same event as identified by the\nsame value of the eventIndex object.  If there is no\ncorresponding entry in the eventTable, then no\nassociation exists.  In fact, if no event is intended\nfor this channel, channelTurnOffEventIndex must be\nset to zero, a non-existent event index.\n\nThis object may not be modified if the associated\nchannelStatus object is equal to valid(1).")
channelEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelEventIndex.setDescription("The value of this object identifies the event\nthat is configured to be generated when the\nassociated channelDataControl is on and a packet\nis matched.  The event identified by a particular value\nof this object is the same event as identified by the\nsame value of the eventIndex object.  If there is no\ncorresponding entry in the eventTable, then no\nassociation exists.  In fact, if no event is intended\nfor this channel, channelEventIndex must be\nset to zero, a non-existent event index.\n\nThis object may not be modified if the associated\nchannelStatus object is equal to valid(1).")
channelEventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("eventReady", 1), ("eventFired", 2), ("eventAlwaysReady", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelEventStatus.setDescription("The event status of this channel.\n\nIf this channel is configured to generate events\nwhen packets are matched, a means of controlling\nthe flow of those events is often needed.  When\nthis object is equal to eventReady(1), a single\nevent may be generated, after which this object\nwill be set by the probe to eventFired(2).  While\nin the eventFired(2) state, no events will be\ngenerated until the object is modified to\neventReady(1) (or eventAlwaysReady(3)).  The\nmanagement station can thus easily respond to a\nnotification of an event by re-enabling this object.\n\nIf the management station wishes to disable this\nflow control and allow events to be generated\nat will, this object may be set to\neventAlwaysReady(3).  Disabling the flow control\nis discouraged as it can result in high network\ntraffic or other performance problems.")
channelMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: channelMatches.setDescription("The number of times this channel has matched a packet.\nNote that this object is updated even when\nchannelDataControl is set to off.")
channelDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 10), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelDescription.setDescription("A comment describing this channel.")
channelOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 11), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
channelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 12), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelStatus.setDescription("The status of this channel entry.")
capture = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 8))
bufferControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 1))
if mibBuilder.loadTexts: bufferControlTable.setDescription("A list of buffers control entries.")
bufferControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 1, 1)).setIndexNames((0, "RMON-MIB", "bufferControlIndex"))
if mibBuilder.loadTexts: bufferControlEntry.setDescription("A set of parameters that control the collection of a stream\nof packets that have matched filters.  As an example, an\ninstance of the bufferControlCaptureSliceSize object might\nbe named bufferControlCaptureSliceSize.3")
bufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlIndex.setDescription("An index that uniquely identifies an entry\nin the bufferControl table.  The value of this\nindex shall never be zero.  Each such\nentry defines one set of packets that is\ncaptured and controlled by one or more filters.")
bufferControlChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlChannelIndex.setDescription("An index that identifies the channel that is the\nsource of packets for this bufferControl table.\nThe channel identified by a particular value of this\nindex is the same as identified by the same value of\nthe channelIndex object.\n\nThis object may not be modified if the associated\nbufferControlStatus object is equal to valid(1).")
bufferControlFullStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("spaceAvailable", 1), ("full", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlFullStatus.setDescription("This object shows whether the buffer has room to\naccept new packets or if it is full.\n\nIf the status is spaceAvailable(1), the buffer is\naccepting new packets normally.  If the status is\nfull(2) and the associated bufferControlFullAction\nobject is wrapWhenFull, the buffer is accepting new\npackets by deleting enough of the oldest packets\nto make room for new ones as they arrive.  Otherwise,\nif the status is full(2) and the\nbufferControlFullAction object is lockWhenFull,\nthen the buffer has stopped collecting packets.\n\nWhen this object is set to full(2) the probe must\nnot later set it to spaceAvailable(1) except in the\ncase of a significant gain in resources such as\nan increase of bufferControlOctetsGranted.  In\nparticular, the wrap-mode action of deleting old\npackets to make room for newly arrived packets\nmust not affect the value of this object.")
bufferControlFullAction = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("lockWhenFull", 1), ("wrapWhenFull", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlFullAction.setDescription("Controls the action of the buffer when it\nreaches the full status.  When in the lockWhenFull(1)\nstate and a packet is added to the buffer that\nfills the buffer, the bufferControlFullStatus will\nbe set to full(2) and this buffer will stop capturing\npackets.")
bufferControlCaptureSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 5), Integer32().clone(100)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlCaptureSliceSize.setDescription("The maximum number of octets of each packet\nthat will be saved in this capture buffer.\nFor example, if a 1500 octet packet is received by\nthe probe and this object is set to 500, then only\n500 octets of the packet will be stored in the\nassociated capture buffer.  If this variable is set\nto 0, the capture buffer will save as many octets\nas is possible.\n\nThis object may not be modified if the associated\nbufferControlStatus object is equal to valid(1).")
bufferControlDownloadSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 6), Integer32().clone(100)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlDownloadSliceSize.setDescription("The maximum number of octets of each packet\nin this capture buffer that will be returned in\nan SNMP retrieval of that packet.  For example,\nif 500 octets of a packet have been stored in the\nassociated capture buffer, the associated\nbufferControlDownloadOffset is 0, and this\nobject is set to 100, then the captureBufferPacket\nobject that contains the packet will contain only\nthe first 100 octets of the packet.\n\nA prudent manager will take into account possible\ninteroperability or fragmentation problems that may\noccur if the download slice size is set too large.\nIn particular, conformant SNMP implementations are not\nrequired to accept messages whose length exceeds 484\noctets, although they are encouraged to support larger\ndatagrams whenever feasible.")
bufferControlDownloadOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 7), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlDownloadOffset.setDescription("The offset of the first octet of each packet\nin this capture buffer that will be returned in\nan SNMP retrieval of that packet.  For example,\nif 500 octets of a packet have been stored in the\nassociated capture buffer and this object is set to\n100, then the captureBufferPacket object that\ncontains the packet will contain bytes starting\n100 octets into the packet.")
bufferControlMaxOctetsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 8), Integer32().clone(-1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlMaxOctetsRequested.setDescription("The requested maximum number of octets to be\nsaved in this captureBuffer, including any\nimplementation-specific overhead. If this variable\nis set to -1, the capture buffer will save as many\noctets as is possible.\n\nWhen this object is created or modified, the probe\nshould set bufferControlMaxOctetsGranted as closely\nto this object as is possible for the particular probe\nimplementation and available resources.  However, if\nthe object has the special value of -1, the probe\nmust set bufferControlMaxOctetsGranted to -1.")
bufferControlMaxOctetsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlMaxOctetsGranted.setDescription("The maximum number of octets that can be\nsaved in this captureBuffer, including overhead.\nIf this variable is -1, the capture buffer will save\nas many octets as possible.\n\nWhen the bufferControlMaxOctetsRequested object is\ncreated or modified, the probe should set this object\nas closely to the requested value as is possible for the\nparticular probe implementation and available resources.\nHowever, if the request object has the special value\nof -1, the probe must set this object to -1.\n\nThe probe must not lower this value except as a result of\na modification to the associated\nbufferControlMaxOctetsRequested object.\n\nWhen this maximum number of octets is reached\nand a new packet is to be added to this\ncapture buffer and the corresponding\nbufferControlFullAction is set to wrapWhenFull(2),\nenough of the oldest packets associated with this\ncapture buffer shall be deleted by the agent so\nthat the new packet can be added.  If the corresponding\nbufferControlFullAction is set to lockWhenFull(1),\nthe new packet shall be discarded.  In either case,\nthe probe must set bufferControlFullStatus to\nfull(2).\n\nWhen the value of this object changes to a value less\nthan the current value, entries are deleted from\nthe captureBufferTable associated with this\nbufferControlEntry.  Enough of the\noldest of these captureBufferEntries shall be\ndeleted by the agent so that the number of octets\nused remains less than or equal to the new value of\nthis object.\n\nWhen the value of this object changes to a value greater\nthan the current value, the number of associated\ncaptureBufferEntries may be allowed to grow.")
bufferControlCapturedPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 10), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlCapturedPackets.setDescription("The number of packets currently in this captureBuffer.")
bufferControlTurnOnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlTurnOnTime.setDescription("The value of sysUpTime when this capture buffer was\nfirst turned on.")
bufferControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 12), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
bufferControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 13), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlStatus.setDescription("The status of this buffer Control Entry.")
captureBufferTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 2))
if mibBuilder.loadTexts: captureBufferTable.setDescription("A list of packets captured off of a channel.")
captureBufferEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 2, 1)).setIndexNames((0, "RMON-MIB", "captureBufferControlIndex"), (0, "RMON-MIB", "captureBufferIndex"))
if mibBuilder.loadTexts: captureBufferEntry.setDescription("A packet captured off of an attached network.  As an\nexample, an instance of the captureBufferPacketData\nobject might be named captureBufferPacketData.3.1783")
captureBufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferControlIndex.setDescription("The index of the bufferControlEntry with which\nthis packet is associated.")
captureBufferIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferIndex.setDescription("An index that uniquely identifies an entry\nin the captureBuffer table associated with a\nparticular bufferControlEntry.  This index will\nstart at 1 and increase by one for each new packet\nadded with the same captureBufferControlIndex.\n\nShould this value reach 2147483647, the next packet\nadded with the same captureBufferControlIndex shall\ncause this value to wrap around to 1.")
captureBufferPacketID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketID.setDescription("An index that describes the order of packets\nthat are received on a particular interface.\nThe packetID of a packet captured on an\ninterface is defined to be greater than the\npacketID's of all packets captured previously on\nthe same interface.  As the captureBufferPacketID\nobject has a maximum positive value of 2^31 - 1,\nany captureBufferPacketID object shall have the\nvalue of the associated packet's packetID mod 2^31.")
captureBufferPacketData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 4), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketData.setDescription("The data inside the packet, starting at the beginning\nof the packet plus any offset specified in the\nassociated bufferControlDownloadOffset, including any\nlink level headers.  The length of the data in this object\nis the minimum of the length of the captured packet minus\nthe offset, the length of the associated\nbufferControlCaptureSliceSize minus the offset, and the\nassociated bufferControlDownloadSliceSize.  If this minimum\nis less than zero, this object shall have a length of zero.")
captureBufferPacketLength = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketLength.setDescription("The actual length (off the wire) of the packet stored\nin this entry, including FCS octets.")
captureBufferPacketTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketTime.setDescription("The number of milliseconds that had passed since\nthis capture buffer was first turned on when this\npacket was captured.")
captureBufferPacketStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketStatus.setDescription("A value which indicates the error status of this packet.\n\nThe value of this object is defined in the same way as\nfilterPktStatus.  The value is a sum.  This sum\ninitially takes the value zero.  Then, for each\nerror, E, that has been discovered in this packet,\n2 raised to a value representing E is added to the sum.\n\nThe errors defined for a packet captured off of an\nEthernet interface are as follows:\n\n    bit #    Error\n        0    Packet is longer than 1518 octets\n        1    Packet is shorter than 64 octets\n        2    Packet experienced a CRC or Alignment error\n        3    First packet in this capture buffer after\n             it was detected that some packets were\n             not processed correctly.\n        4    Packet's order in buffer is only approximate\n             (May only be set for packets sent from\n             the probe)\n\nFor example, an Ethernet fragment would have a\nvalue of 6 (2^1 + 2^2).\n\nAs this MIB is expanded to new media types, this object\nwill have other media-specific errors defined.")
event = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 9))
eventTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 1))
if mibBuilder.loadTexts: eventTable.setDescription("A list of events to be generated.")
eventEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 1, 1)).setIndexNames((0, "RMON-MIB", "eventIndex"))
if mibBuilder.loadTexts: eventEntry.setDescription("A set of parameters that describe an event to be generated\nwhen certain conditions are met.  As an example, an instance\nof the eventLastTimeSent object might be named\neventLastTimeSent.6")
eventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventIndex.setDescription("An index that uniquely identifies an entry in the\nevent table.  Each such entry defines one event that\nis to be generated when the appropriate conditions\noccur.")
eventDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventDescription.setDescription("A comment describing this event entry.")
eventType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("log", 2), ("snmptrap", 3), ("logandtrap", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventType.setDescription("The type of notification that the probe will make\nabout this event.  In the case of log, an entry is\nmade in the log table for each event.  In the case of\nsnmp-trap, an SNMP trap is sent to one or more\nmanagement stations.")
eventCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventCommunity.setDescription("If an SNMP trap is to be sent, it will be sent to\nthe SNMP community specified by this octet string.")
eventLastTimeSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventLastTimeSent.setDescription("The value of sysUpTime at the time this event\nentry last generated an event.  If this entry has\nnot generated any events, this value will be\nzero.")
eventOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 6), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.\n\nIf this object contains a string starting with 'monitor'\nand has associated entries in the log table, all connected\nmanagement stations should retrieve those log entries,\nas they may have significance to all management stations\nconnected to this device")
eventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 7), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventStatus.setDescription("The status of this event entry.\n\nIf this object is not equal to valid(1), all associated\nlog entries shall be deleted by the agent.")
logTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 2))
if mibBuilder.loadTexts: logTable.setDescription("A list of events that have been logged.")
logEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 2, 1)).setIndexNames((0, "RMON-MIB", "logEventIndex"), (0, "RMON-MIB", "logIndex"))
if mibBuilder.loadTexts: logEntry.setDescription("A set of data describing an event that has been\nlogged.  For example, an instance of the logDescription\nobject might be named logDescription.6.47")
logEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logEventIndex.setDescription("The event entry that generated this log\nentry.  The log identified by a particular\nvalue of this index is associated with the same\neventEntry as identified by the same value\nof eventIndex.")
logIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logIndex.setDescription("An index that uniquely identifies an entry\nin the log table amongst those generated by the\nsame eventEntries.  These indexes are\nassigned beginning with 1 and increase by one\nwith each new log entry.  The association\nbetween values of logIndex and logEntries\nis fixed for the lifetime of each logEntry.\nThe agent may choose to delete the oldest\ninstances of logEntry as required because of\nlack of memory.  It is an implementation-specific\nmatter as to when this deletion may occur.")
logTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: logTime.setDescription("The value of sysUpTime when this log entry was created.")
logDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logDescription.setDescription("An implementation dependent description of the\nevent that activated this log entry.")
rmonConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20))
rmonMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 20, 8)).setRevisions(("2000-05-11 00:00","1995-02-01 00:00","1991-11-01 00:00",))
if mibBuilder.loadTexts: rmonMibModule.setOrganization("IETF RMON MIB Working Group")
if mibBuilder.loadTexts: rmonMibModule.setContactInfo("Steve Waldbusser\nPhone: +1-650-948-6500\nFax:   +1-650-745-0671\nEmail: waldbusser@nextbeacon.com")
if mibBuilder.loadTexts: rmonMibModule.setDescription("Remote network monitoring devices, often called\nmonitors or probes, are instruments that exist for\nthe purpose of managing a network. This MIB defines\nobjects for managing remote network monitoring devices.")
rmonCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 9))
rmonGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 10))

# Augmentions

# Notifications

fallingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 0, 2)).setObjects(("RMON-MIB", "alarmFallingThreshold"), ("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmSampleType"), )
risingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 0, 1)).setObjects(("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmSampleType"), ("RMON-MIB", "alarmRisingThreshold"), )

# Groups

rmonEthernetHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 3)).setObjects(("RMON-MIB", "etherHistoryUndersizePkts"), ("RMON-MIB", "etherHistoryUtilization"), ("RMON-MIB", "etherHistoryBroadcastPkts"), ("RMON-MIB", "etherHistoryFragments"), ("RMON-MIB", "etherHistoryJabbers"), ("RMON-MIB", "etherHistoryPkts"), ("RMON-MIB", "etherHistoryCollisions"), ("RMON-MIB", "etherHistoryCRCAlignErrors"), ("RMON-MIB", "etherHistoryIntervalStart"), ("RMON-MIB", "etherHistoryDropEvents"), ("RMON-MIB", "etherHistoryIndex"), ("RMON-MIB", "etherHistoryOctets"), ("RMON-MIB", "etherHistoryMulticastPkts"), ("RMON-MIB", "etherHistoryOversizePkts"), ("RMON-MIB", "etherHistorySampleIndex"), )
rmonEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 10)).setObjects(("RMON-MIB", "eventCommunity"), ("RMON-MIB", "logDescription"), ("RMON-MIB", "logTime"), ("RMON-MIB", "eventDescription"), ("RMON-MIB", "eventType"), ("RMON-MIB", "eventOwner"), ("RMON-MIB", "eventLastTimeSent"), ("RMON-MIB", "eventStatus"), ("RMON-MIB", "eventIndex"), ("RMON-MIB", "logIndex"), ("RMON-MIB", "logEventIndex"), )
rmonFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 8)).setObjects(("RMON-MIB", "filterPktStatusNotMask"), ("RMON-MIB", "channelEventIndex"), ("RMON-MIB", "filterPktStatus"), ("RMON-MIB", "channelIndex"), ("RMON-MIB", "channelIfIndex"), ("RMON-MIB", "channelDataControl"), ("RMON-MIB", "filterPktData"), ("RMON-MIB", "channelStatus"), ("RMON-MIB", "filterChannelIndex"), ("RMON-MIB", "filterPktDataMask"), ("RMON-MIB", "channelOwner"), ("RMON-MIB", "channelAcceptType"), ("RMON-MIB", "channelDescription"), ("RMON-MIB", "channelTurnOnEventIndex"), ("RMON-MIB", "filterPktDataOffset"), ("RMON-MIB", "filterOwner"), ("RMON-MIB", "channelMatches"), ("RMON-MIB", "filterIndex"), ("RMON-MIB", "filterPktDataNotMask"), ("RMON-MIB", "filterPktStatusMask"), ("RMON-MIB", "filterStatus"), ("RMON-MIB", "channelEventStatus"), ("RMON-MIB", "channelTurnOffEventIndex"), )
rmonAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 4)).setObjects(("RMON-MIB", "alarmStartupAlarm"), ("RMON-MIB", "alarmStatus"), ("RMON-MIB", "alarmRisingEventIndex"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmInterval"), ("RMON-MIB", "alarmOwner"), ("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmFallingThreshold"), ("RMON-MIB", "alarmRisingThreshold"), ("RMON-MIB", "alarmFallingEventIndex"), ("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmSampleType"), )
rmonMatrixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 7)).setObjects(("RMON-MIB", "matrixSDOctets"), ("RMON-MIB", "matrixDSOctets"), ("RMON-MIB", "matrixControlLastDeleteTime"), ("RMON-MIB", "matrixSDErrors"), ("RMON-MIB", "matrixControlStatus"), ("RMON-MIB", "matrixDSSourceAddress"), ("RMON-MIB", "matrixSDIndex"), ("RMON-MIB", "matrixDSErrors"), ("RMON-MIB", "matrixControlIndex"), ("RMON-MIB", "matrixControlDataSource"), ("RMON-MIB", "matrixDSPkts"), ("RMON-MIB", "matrixDSDestAddress"), ("RMON-MIB", "matrixSDDestAddress"), ("RMON-MIB", "matrixSDPkts"), ("RMON-MIB", "matrixControlTableSize"), ("RMON-MIB", "matrixControlOwner"), ("RMON-MIB", "matrixSDSourceAddress"), ("RMON-MIB", "matrixDSIndex"), )
rmonEtherStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 1)).setObjects(("RMON-MIB", "etherStatsOversizePkts"), ("RMON-MIB", "etherStatsPkts"), ("RMON-MIB", "etherStatsBroadcastPkts"), ("RMON-MIB", "etherStatsDataSource"), ("RMON-MIB", "etherStatsPkts1024to1518Octets"), ("RMON-MIB", "etherStatsOctets"), ("RMON-MIB", "etherStatsOwner"), ("RMON-MIB", "etherStatsPkts128to255Octets"), ("RMON-MIB", "etherStatsJabbers"), ("RMON-MIB", "etherStatsCRCAlignErrors"), ("RMON-MIB", "etherStatsMulticastPkts"), ("RMON-MIB", "etherStatsStatus"), ("RMON-MIB", "etherStatsIndex"), ("RMON-MIB", "etherStatsPkts256to511Octets"), ("RMON-MIB", "etherStatsUndersizePkts"), ("RMON-MIB", "etherStatsPkts65to127Octets"), ("RMON-MIB", "etherStatsDropEvents"), ("RMON-MIB", "etherStatsCollisions"), ("RMON-MIB", "etherStatsFragments"), ("RMON-MIB", "etherStatsPkts512to1023Octets"), ("RMON-MIB", "etherStatsPkts64Octets"), )
rmonPacketCaptureGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 9)).setObjects(("RMON-MIB", "bufferControlStatus"), ("RMON-MIB", "captureBufferPacketData"), ("RMON-MIB", "bufferControlChannelIndex"), ("RMON-MIB", "bufferControlIndex"), ("RMON-MIB", "captureBufferPacketID"), ("RMON-MIB", "bufferControlMaxOctetsGranted"), ("RMON-MIB", "bufferControlDownloadSliceSize"), ("RMON-MIB", "bufferControlCapturedPackets"), ("RMON-MIB", "bufferControlTurnOnTime"), ("RMON-MIB", "bufferControlMaxOctetsRequested"), ("RMON-MIB", "bufferControlFullAction"), ("RMON-MIB", "captureBufferPacketTime"), ("RMON-MIB", "captureBufferPacketLength"), ("RMON-MIB", "bufferControlDownloadOffset"), ("RMON-MIB", "captureBufferPacketStatus"), ("RMON-MIB", "bufferControlCaptureSliceSize"), ("RMON-MIB", "captureBufferControlIndex"), ("RMON-MIB", "captureBufferIndex"), ("RMON-MIB", "bufferControlFullStatus"), ("RMON-MIB", "bufferControlOwner"), )
rmonNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 11)).setObjects(("RMON-MIB", "fallingAlarm"), ("RMON-MIB", "risingAlarm"), )
rmonHostTopNGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 6)).setObjects(("RMON-MIB", "hostTopNAddress"), ("RMON-MIB", "hostTopNStatus"), ("RMON-MIB", "hostTopNRate"), ("RMON-MIB", "hostTopNTimeRemaining"), ("RMON-MIB", "hostTopNReport"), ("RMON-MIB", "hostTopNControlIndex"), ("RMON-MIB", "hostTopNStartTime"), ("RMON-MIB", "hostTopNIndex"), ("RMON-MIB", "hostTopNOwner"), ("RMON-MIB", "hostTopNGrantedSize"), ("RMON-MIB", "hostTopNHostIndex"), ("RMON-MIB", "hostTopNDuration"), ("RMON-MIB", "hostTopNRateBase"), ("RMON-MIB", "hostTopNRequestedSize"), )
rmonHostGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 5)).setObjects(("RMON-MIB", "hostTimeInPkts"), ("RMON-MIB", "hostTimeOutBroadcastPkts"), ("RMON-MIB", "hostIndex"), ("RMON-MIB", "hostControlTableSize"), ("RMON-MIB", "hostTimeOutOctets"), ("RMON-MIB", "hostTimeOutPkts"), ("RMON-MIB", "hostOutPkts"), ("RMON-MIB", "hostOutBroadcastPkts"), ("RMON-MIB", "hostTimeInOctets"), ("RMON-MIB", "hostAddress"), ("RMON-MIB", "hostControlDataSource"), ("RMON-MIB", "hostTimeIndex"), ("RMON-MIB", "hostTimeOutErrors"), ("RMON-MIB", "hostControlOwner"), ("RMON-MIB", "hostOutMulticastPkts"), ("RMON-MIB", "hostOutOctets"), ("RMON-MIB", "hostTimeAddress"), ("RMON-MIB", "hostCreationOrder"), ("RMON-MIB", "hostInPkts"), ("RMON-MIB", "hostControlStatus"), ("RMON-MIB", "hostInOctets"), ("RMON-MIB", "hostTimeCreationOrder"), ("RMON-MIB", "hostControlLastDeleteTime"), ("RMON-MIB", "hostTimeOutMulticastPkts"), ("RMON-MIB", "hostOutErrors"), ("RMON-MIB", "hostControlIndex"), )
rmonHistoryControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 2)).setObjects(("RMON-MIB", "historyControlIndex"), ("RMON-MIB", "historyControlBucketsGranted"), ("RMON-MIB", "historyControlDataSource"), ("RMON-MIB", "historyControlBucketsRequested"), ("RMON-MIB", "historyControlInterval"), ("RMON-MIB", "historyControlOwner"), ("RMON-MIB", "historyControlStatus"), )

# Exports

# Module identity
mibBuilder.exportSymbols("RMON-MIB", PYSNMP_MODULE_ID=rmonMibModule)

# Types
mibBuilder.exportSymbols("RMON-MIB", EntryStatus=EntryStatus, OwnerString=OwnerString)

# Objects
mibBuilder.exportSymbols("RMON-MIB", rmon=rmon, rmonEventsV2=rmonEventsV2, statistics=statistics, etherStatsTable=etherStatsTable, etherStatsEntry=etherStatsEntry, etherStatsIndex=etherStatsIndex, etherStatsDataSource=etherStatsDataSource, etherStatsDropEvents=etherStatsDropEvents, etherStatsOctets=etherStatsOctets, etherStatsPkts=etherStatsPkts, etherStatsBroadcastPkts=etherStatsBroadcastPkts, etherStatsMulticastPkts=etherStatsMulticastPkts, etherStatsCRCAlignErrors=etherStatsCRCAlignErrors, etherStatsUndersizePkts=etherStatsUndersizePkts, etherStatsOversizePkts=etherStatsOversizePkts, etherStatsFragments=etherStatsFragments, etherStatsJabbers=etherStatsJabbers, etherStatsCollisions=etherStatsCollisions, etherStatsPkts64Octets=etherStatsPkts64Octets, etherStatsPkts65to127Octets=etherStatsPkts65to127Octets, etherStatsPkts128to255Octets=etherStatsPkts128to255Octets, etherStatsPkts256to511Octets=etherStatsPkts256to511Octets, etherStatsPkts512to1023Octets=etherStatsPkts512to1023Octets, etherStatsPkts1024to1518Octets=etherStatsPkts1024to1518Octets, etherStatsOwner=etherStatsOwner, etherStatsStatus=etherStatsStatus, history=history, historyControlTable=historyControlTable, historyControlEntry=historyControlEntry, historyControlIndex=historyControlIndex, historyControlDataSource=historyControlDataSource, historyControlBucketsRequested=historyControlBucketsRequested, historyControlBucketsGranted=historyControlBucketsGranted, historyControlInterval=historyControlInterval, historyControlOwner=historyControlOwner, historyControlStatus=historyControlStatus, etherHistoryTable=etherHistoryTable, etherHistoryEntry=etherHistoryEntry, etherHistoryIndex=etherHistoryIndex, etherHistorySampleIndex=etherHistorySampleIndex, etherHistoryIntervalStart=etherHistoryIntervalStart, etherHistoryDropEvents=etherHistoryDropEvents, etherHistoryOctets=etherHistoryOctets, etherHistoryPkts=etherHistoryPkts, etherHistoryBroadcastPkts=etherHistoryBroadcastPkts, etherHistoryMulticastPkts=etherHistoryMulticastPkts, etherHistoryCRCAlignErrors=etherHistoryCRCAlignErrors, etherHistoryUndersizePkts=etherHistoryUndersizePkts, etherHistoryOversizePkts=etherHistoryOversizePkts, etherHistoryFragments=etherHistoryFragments, etherHistoryJabbers=etherHistoryJabbers, etherHistoryCollisions=etherHistoryCollisions, etherHistoryUtilization=etherHistoryUtilization, alarm=alarm, alarmTable=alarmTable, alarmEntry=alarmEntry, alarmIndex=alarmIndex, alarmInterval=alarmInterval, alarmVariable=alarmVariable, alarmSampleType=alarmSampleType, alarmValue=alarmValue, alarmStartupAlarm=alarmStartupAlarm, alarmRisingThreshold=alarmRisingThreshold, alarmFallingThreshold=alarmFallingThreshold, alarmRisingEventIndex=alarmRisingEventIndex, alarmFallingEventIndex=alarmFallingEventIndex, alarmOwner=alarmOwner, alarmStatus=alarmStatus, hosts=hosts, hostControlTable=hostControlTable, hostControlEntry=hostControlEntry, hostControlIndex=hostControlIndex, hostControlDataSource=hostControlDataSource, hostControlTableSize=hostControlTableSize, hostControlLastDeleteTime=hostControlLastDeleteTime, hostControlOwner=hostControlOwner, hostControlStatus=hostControlStatus, hostTable=hostTable, hostEntry=hostEntry, hostAddress=hostAddress, hostCreationOrder=hostCreationOrder, hostIndex=hostIndex, hostInPkts=hostInPkts, hostOutPkts=hostOutPkts, hostInOctets=hostInOctets, hostOutOctets=hostOutOctets, hostOutErrors=hostOutErrors, hostOutBroadcastPkts=hostOutBroadcastPkts, hostOutMulticastPkts=hostOutMulticastPkts, hostTimeTable=hostTimeTable, hostTimeEntry=hostTimeEntry, hostTimeAddress=hostTimeAddress, hostTimeCreationOrder=hostTimeCreationOrder, hostTimeIndex=hostTimeIndex, hostTimeInPkts=hostTimeInPkts, hostTimeOutPkts=hostTimeOutPkts, hostTimeInOctets=hostTimeInOctets, hostTimeOutOctets=hostTimeOutOctets, hostTimeOutErrors=hostTimeOutErrors, hostTimeOutBroadcastPkts=hostTimeOutBroadcastPkts, hostTimeOutMulticastPkts=hostTimeOutMulticastPkts, hostTopN=hostTopN, hostTopNControlTable=hostTopNControlTable, hostTopNControlEntry=hostTopNControlEntry, hostTopNControlIndex=hostTopNControlIndex, hostTopNHostIndex=hostTopNHostIndex, hostTopNRateBase=hostTopNRateBase, hostTopNTimeRemaining=hostTopNTimeRemaining, hostTopNDuration=hostTopNDuration, hostTopNRequestedSize=hostTopNRequestedSize, hostTopNGrantedSize=hostTopNGrantedSize, hostTopNStartTime=hostTopNStartTime, hostTopNOwner=hostTopNOwner, hostTopNStatus=hostTopNStatus, hostTopNTable=hostTopNTable, hostTopNEntry=hostTopNEntry, hostTopNReport=hostTopNReport, hostTopNIndex=hostTopNIndex, hostTopNAddress=hostTopNAddress, hostTopNRate=hostTopNRate, matrix=matrix, matrixControlTable=matrixControlTable, matrixControlEntry=matrixControlEntry, matrixControlIndex=matrixControlIndex, matrixControlDataSource=matrixControlDataSource, matrixControlTableSize=matrixControlTableSize)
mibBuilder.exportSymbols("RMON-MIB", matrixControlLastDeleteTime=matrixControlLastDeleteTime, matrixControlOwner=matrixControlOwner, matrixControlStatus=matrixControlStatus, matrixSDTable=matrixSDTable, matrixSDEntry=matrixSDEntry, matrixSDSourceAddress=matrixSDSourceAddress, matrixSDDestAddress=matrixSDDestAddress, matrixSDIndex=matrixSDIndex, matrixSDPkts=matrixSDPkts, matrixSDOctets=matrixSDOctets, matrixSDErrors=matrixSDErrors, matrixDSTable=matrixDSTable, matrixDSEntry=matrixDSEntry, matrixDSSourceAddress=matrixDSSourceAddress, matrixDSDestAddress=matrixDSDestAddress, matrixDSIndex=matrixDSIndex, matrixDSPkts=matrixDSPkts, matrixDSOctets=matrixDSOctets, matrixDSErrors=matrixDSErrors, filter=filter, filterTable=filterTable, filterEntry=filterEntry, filterIndex=filterIndex, filterChannelIndex=filterChannelIndex, filterPktDataOffset=filterPktDataOffset, filterPktData=filterPktData, filterPktDataMask=filterPktDataMask, filterPktDataNotMask=filterPktDataNotMask, filterPktStatus=filterPktStatus, filterPktStatusMask=filterPktStatusMask, filterPktStatusNotMask=filterPktStatusNotMask, filterOwner=filterOwner, filterStatus=filterStatus, channelTable=channelTable, channelEntry=channelEntry, channelIndex=channelIndex, channelIfIndex=channelIfIndex, channelAcceptType=channelAcceptType, channelDataControl=channelDataControl, channelTurnOnEventIndex=channelTurnOnEventIndex, channelTurnOffEventIndex=channelTurnOffEventIndex, channelEventIndex=channelEventIndex, channelEventStatus=channelEventStatus, channelMatches=channelMatches, channelDescription=channelDescription, channelOwner=channelOwner, channelStatus=channelStatus, capture=capture, bufferControlTable=bufferControlTable, bufferControlEntry=bufferControlEntry, bufferControlIndex=bufferControlIndex, bufferControlChannelIndex=bufferControlChannelIndex, bufferControlFullStatus=bufferControlFullStatus, bufferControlFullAction=bufferControlFullAction, bufferControlCaptureSliceSize=bufferControlCaptureSliceSize, bufferControlDownloadSliceSize=bufferControlDownloadSliceSize, bufferControlDownloadOffset=bufferControlDownloadOffset, bufferControlMaxOctetsRequested=bufferControlMaxOctetsRequested, bufferControlMaxOctetsGranted=bufferControlMaxOctetsGranted, bufferControlCapturedPackets=bufferControlCapturedPackets, bufferControlTurnOnTime=bufferControlTurnOnTime, bufferControlOwner=bufferControlOwner, bufferControlStatus=bufferControlStatus, captureBufferTable=captureBufferTable, captureBufferEntry=captureBufferEntry, captureBufferControlIndex=captureBufferControlIndex, captureBufferIndex=captureBufferIndex, captureBufferPacketID=captureBufferPacketID, captureBufferPacketData=captureBufferPacketData, captureBufferPacketLength=captureBufferPacketLength, captureBufferPacketTime=captureBufferPacketTime, captureBufferPacketStatus=captureBufferPacketStatus, event=event, eventTable=eventTable, eventEntry=eventEntry, eventIndex=eventIndex, eventDescription=eventDescription, eventType=eventType, eventCommunity=eventCommunity, eventLastTimeSent=eventLastTimeSent, eventOwner=eventOwner, eventStatus=eventStatus, logTable=logTable, logEntry=logEntry, logEventIndex=logEventIndex, logIndex=logIndex, logTime=logTime, logDescription=logDescription, rmonConformance=rmonConformance, rmonMibModule=rmonMibModule, rmonCompliances=rmonCompliances, rmonGroups=rmonGroups)

# Notifications
mibBuilder.exportSymbols("RMON-MIB", fallingAlarm=fallingAlarm, risingAlarm=risingAlarm)

# Groups
mibBuilder.exportSymbols("RMON-MIB", rmonEthernetHistoryGroup=rmonEthernetHistoryGroup, rmonEventGroup=rmonEventGroup, rmonFilterGroup=rmonFilterGroup, rmonAlarmGroup=rmonAlarmGroup, rmonMatrixGroup=rmonMatrixGroup, rmonEtherStatsGroup=rmonEtherStatsGroup, rmonPacketCaptureGroup=rmonPacketCaptureGroup, rmonNotificationGroup=rmonNotificationGroup, rmonHostTopNGroup=rmonHostTopNGroup, rmonHostGroup=rmonHostGroup, rmonHistoryControlGroup=rmonHistoryControlGroup)
